from re import compile, IGNORECASE, sub

from dosage.helpers import BasicScraper

class UClickScraper(BasicScraper):
    abstract = True

    homepage = 'http://content.uclick.com/a2z.html'
    baseUrl = 'http://www.uclick.com/client/zzz/%s/'
    imageUrl = property(lambda self: self.latestUrl + '%s/')
    imageSearch = compile(r'<img.+?src="(/feature/\d{2}/\d{2}/\d{2}/[^"]+\.gif|http://images\.ucomics\.com/comics/\w+/\d{4}/[^"]+\.gif)">', IGNORECASE)
    prevSearch = compile(r'<a href="(/client/zzz/\w+/\d{4}/\d{2}/\d{2}/)">Previous date', IGNORECASE)
    help = 'Index format: yyyy/mm/dd'

    def starter(cls):
        return cls.baseUrl % (cls.shortName,)

    @classmethod
    def fetchSubmodules(cls):
        exclusions = (
            'index',
            )

        submoduleSearch = compile(r'(<A HREF="http://content.uclick.com/content/\w+.html">[^>]+?</a>)', IGNORECASE)
        partsMatch = compile(r'<A HREF="http://content.uclick.com/content/(\w+?).html">([^>]+?)</a>', IGNORECASE)
        matches = util.fetchManyMatches(cls.homepage, (submoduleSearch,))[0]
        possibles = [partsMatch.match(match).groups() for match in matches]

        def normalizeName(name):
            name = sub(r'&(.)acute;', r'\1', name).title()
            return ''.join([c for c in name if c.isalnum()])

        def fetchSubmodule(module):
            try:
                return util.fetchUrl(cls.baseUrl % module, cls.imageSearch)
            except:
                return False

        return [normalizeName(name) for part, name in possibles if part not in exclusions and fetchSubmodule(part)]


def uclick(comics):
    return dict((name, UClickScraper.make('UClick/' + name, shortName=shortName))
                for name, shortName in comics.iteritems())

comics = {
    '9To5': 'tmntf',
    'AdamHome': 'ad',
    'Agnes': 'cragn',
    'AlcarazLalo': 'la',
    'AlcarazLaloSpanish': 'spla',
    'AndersonNick': 'wpnan',
    'AndyCapp': 'crcap',
    'AnimalCrackers': 'tmani',
    'Annie': 'tmann',
    'AsayChuck': 'crcas',
    'AskShagg': 'crask',
    'AuthTony': 'ta',
    'BadReporter': 'bad',
    'Baldo': 'ba',
    'BaldoSpanish': 'be',
    'BallardStreet': 'crbal',
    'BC': 'crbc',
    'BCSpanish': 'crbcs',
    'BensonLisa': 'wplbe',
    'BensonSteve': 'crsbe',
    'BigTop': 'bt',
    'Biographic': 'biov',
    'BobTheSquirrel': 'bob',
    'BokChip': 'crcbo',
    'BoNanas': 'bon',
    'BoondocksThe': 'bo',
    'BottomLiners': 'tmbot',
    'BoundAndGagged': 'tmbou',
    'Brainwaves': 'bwv',
    'BrendaStarr': 'tmbre',
    'BrewsterRockit': 'tmrkt',
    'BroomHilda': 'tmbro',
    'Candorville': 'cand',
    'CarlsonStuart': 'sc',
    'CatalinoKen': 'crkca',
    'Cathy': 'ca',
    'CathySpanish': 'spca',
    'CEstLaVie': 'clv',
    'CityThe': 'derf',
    'ClearBlueWater': 'cbw',
    'Cleats': 'cle',
    'CloseToHome': 'cl',
    'CompuToon': 'tmcom',
    'Condorito': 'cond',
    'ConradPaul': 'tmpco',
    'Cornered': 'co',
    'DanzigerJeff': 'jd',
    'DaviesMatt': 'tmmda',
    'DeepCover': 'deep',
    'DeeringJohn': 'crjde',
    'DickTracy': 'tmdic',
    'DinetteSetThe': 'crdin',
    'DogEatDoug': 'crdog',
    'DonWright': 'tmdow',
    'Doodles': 'tmdoo',
    'Doonesbury': 'db',
    'DuplexThe': 'dp',
    'ElderberriesThe': 'eld',
    'FacesInTheNews': 'kw',
    'FlightDeck': 'crfd',
    'FloAndFriends': 'crflo',
    'FlyingMccoysThe': 'fmc',
    'ForBetterOrForWorse': 'fb',
    'ForHeavenSSake': 'crfhs',
    'Foxtrot': 'ft',
    'FoxtrotSpanish': 'spft',
    'FrankAndErnest': 'fa',
    'FredBassetSpanish': 'spfba',
    'FredBasset': 'tmfba',
    'FrogApplause': 'frog',
    'FuscoBrothersThe': 'fu',
    'Garfield': 'ga',
    'GarfieldSpanish': 'gh',
    'GasolineAlley': 'tmgas',
    'GaturroSpanish': 'spgat',
    'GilThorp': 'tmgil',
    'GingerMeggs': 'gin',
    'GingerMeggsSpanish': 'spgin',
    'GirlsAndSports': 'crgis',
    'GorrellBob': 'crbgo',
    'HammondBruce': 'hb',
    'HandelsmanWalt': 'tmwha',
    'HeartOfTheCity': 'hc',
    'Heathcliff': 'crhea',
    'HeathcliffSpanish': 'crhes',
    'HerbAndJamaal': 'crher',
    'HigginsJack': 'jh',
    'HorseyDavid': 'tmdho',
    'Housebroken': 'tmhou',
    'HubertAndAbby': 'haa',
    'IdiotBox': 'ibox',
    'InkPen': 'ink',
    'InTheBleachers': 'bl',
    'JamesBondSpanish': 'spjb',
    'JonesClay': 'crcjo',
    'KallaugherKevin': 'cwkal',
    'KChroniclesThe': 'kk',
    'KelleySteve': 'crske',
    'Kudzu': 'tmkud',
    'LaCucaracha': 'lc',
    'LibertyMeadows': 'crlib',
    'Lio': 'lio',
    'LocherDick': 'tmdlo',
    'LooseParts': 'tmloo',
    'LostSheep': 'lost',
    'LoweChan': 'tmclo',
    'LuckovichMike': 'crmlu',
    'LuckyCow': 'luc',
    'MarletteDoug': 'tmdma',
    'MccoyGlenn': 'gm',
    'MeaningOfLilaThe': 'crlil',
    'MeehanStreak': 'tmmee',
    'MiddletonsThe': 'tmmid',
    'MinimumSecurity': 'ms',
    'ModestyBlaiseSpanish': 'spmb',
    'Momma': 'crmom',
    'MorinJim': 'cwjmo',
    'MuttJeffSpanish': 'spmut',
    'NaturalSelection': 'crns',
    'NestHeads': 'cpnst',
    'Neurotica': 'neu',
    'NonSequitur': 'nq',
    'OhmanJack': 'tmjoh',
    'OliphantPat': 'po',
    'OnAClaireDay': 'crocd',
    'OneBigHappy': 'crobh',
    'OtherCoastThe': 'crtoc',
    'OutOfTheGenePool': 'wpgen',
    'Overboard': 'ob',
    'OverboardSpanish': 'spob',
    'PepeSpanish': 'sppep',
    'PettJoel': 'jp',
    'Pickles': 'wppic',
    'Pluggers': 'tmplu',
    'PoochCafe': 'poc',
    'PoochCafeSpanish': 'sppoc',
    'PopCulture': 'pop',
    'PowellDwane': 'crdpo',
    'Preteena': 'pr',
    'PricklyCity': 'prc',
    'QuigmansThe': 'tmqui',
    'RallComic': 'tr',
    'RealLifeAdventures': 'rl',
    'RedAndRover': 'wpred',
    'RedMeat': 'red',
    'ReynoldsUnwrapped': 'rw',
    'RonaldinhoGaucho': 'ron',
    'RonaldinhoGauchoSpanish': 'spron',
    'Rubes': 'crrub',
    'SackSteve': 'tmssa',
    'SargentBen': 'bs',
    'SargentBenSpanish': 'spbs',
    'SendHelp': 'send',
    'ShenemanDrew': 'tmdsh',
    'Shoecabbage': 'shcab',
    'Shoe': 'tmsho',
    'SigmundSpanish': 'spsig',
    'Slowpoke': 'slow',
    'SmallWorld': 'small',
    'SpaceIsThePlace': 'sitp',
    'SpeedBump': 'crspe',
    'StateOfTheUnion': 'crsou',
    'StayskalWayne': 'tmwst',
    'StoneSoup': 'ss',
    'StrangeBrew': 'crstr',
    'SummersDana': 'tmdsu',
    'SuttonImpact': 'stn',
    'Sylvia': 'tmsyl',
    'SzepPaul': 'crpsz',
    'TankMcnamara': 'tm',
    'TeenageMutantNinjaTurtles': 'tmnt',
    'TelnaesAnn': 'tmate',
    'TheArgyleSweater': 'tas',
    'ThePinkPanther': 'tmpnk',
    'TheWizardOfId': 'crwiz',
    'TheWizardOfIdSpanish': 'crwis',
    'ThInk': 'think',
    'ThroughThickAndThin': 'cpthk',
    'TinySepuku': 'tiny',
    'TolesTom': 'tt',
    'TomTheDancingBug': 'td',
    'TooMuchCoffeeMan': 'tmcm',
    'Trevor': 'trev',
    'TutelandiaSpanish': 'sptut',
    'VarvelGary': 'crgva',
    'WassermanDan': 'tmdwa',
    'WatchYourHead': 'wpwyh',
    'Waylay': 'min',
    'WeePals': 'crwee',
    'WinnieThePooh': 'crwin',
    'WorkingItOut': 'crwio',
    'YennySpanish': 'spyen',
    'Yenny': 'yen',
    'ZackHill': 'crzhi',
    'ZiggySpanish': 'spzi',
    'Ziggy': 'zi',
    }

globals().update(uclick(comics))
