#
# (C) Renaud Deraison
#
if(description)
{
 script_id(12055);
 script_bugtraq_id(9633, 9635);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "ASN.1 Parsing Vulnerabilities (HTTP check)";
 script_name(english:name["english"]);
 
 desc["english"] = "
 The remote Windows host has a ASN.1 library which is vulnerable to a 
flaw which could allow an attacker to execute arbitrary code on this host.

To exploit this flaw, an attacker would need to send a specially crafted
ASN.1 encoded packet with impropriately advertised lengths.

This particular check sent a malformed HTML authorization packet and determined that 
the remote host is not patched.

Solution : http://www.microsoft.com/technet/security/bulletin/ms04-007.asp
Risk factor : High";
 
 script_description(english:desc["english"]);
 
 summary["english"] = "Checks if the remote host has a patched ASN.1 decoder (828028)";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Renaud Deraison");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 script_require_ports("Services/www", 80); 
 script_dependencies("http_version.nasl");
 exit(0);
}




include("misc_func.inc");
include("http_func.inc");




__base64_code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
function base64_code(c)
{
 return(__base64_code[c]);
}

function pow2(x)
{
 __ret = 1;
 while(x)
  {
  __ret = __ret * 2;
  x = x  - 1;
  }
 return(__ret);
}

function base64(str)
{
 len = strlen(str);
 i = 0;
 ret = "";
 char_count = 0;
 _bits = 0;
 while(i < len)
 {
  _bits = _bits + ord(str[i]);
  char_count = char_count + 1;
  if(char_count == 3)
  {
    val = _bits / 262144;
    ret = string(ret, base64_code(c:val));
    val = _bits / 4096;
    val = val & 0x3F;
    ret = string(ret, base64_code(c:val));
    val = _bits / 64;
    val = val & 0x3F;
    ret = string(ret, base64_code(c:val));
    val = _bits & 0x3F;
    ret = string(ret, base64_code(c:val));
    char_count = 0;
    _bits = 0;
 }
 else {
       _bits = _bits * 256;
       }
 i = i + 1;
 }


 if(!(char_count == 0))
 {
  cnt = char_count * 8;
  mul = 16;
  mul = mul - cnt;
  mul = pow2(x:mul);
  _bits = _bits * mul;
  val = _bits / 262144;
  ret = string(ret, base64_code(c:val));
  val = _bits / 4096;
  val = val & 0x3F;
  ret = string(ret, base64_code(c:val));
 if(char_count == 1)
 { 
  ret = string(ret, "==");
 }
 else
 {
   val = _bits / 64;
   val = val & 0x3F;
   ret = string(ret, base64_code(c:val), "=");
  }
 }
 return(ret);
}



port = get_kb_item("Services/www");
if ( ! port ) port = 80;
if ( ! get_port_state(port) ) exit(0);

sig = get_kb_item("www/hmap/" + port + "/description");
if ( sig && "IIS" >!< sig ) exit(0);

blob = "60840000006206830000062b0601050502a0820053308150a00e300c060a2b06010401823702020aa33e303ca0303b2e048101252481270401052422242024182416241424122410240e240c240a24082406240424020400048200023925a1080406e5c5f9e52004";

blob = hex2raw(s:blob);
blob = base64(str:blob);

req = string("GET / HTTP/1.1\r\n",
"Authorization: Negotiate ", blob, "\r\n",
"Host: ", get_host_name(), "\r\n\r\n");

soc = http_open_socket(port);
if ( ! soc ) exit(0); 
send(socket:soc, data:req);
result = http_recv_headers(soc);
# Vulnerable -> WWW-Authenticate: Negotiate xxxxx\r\n
# Not vulnerable -> WWW-Authenticate: Negotiate\r\n
if ( egrep(pattern:"WWW-Authenticate: Negotiate [a-zA-Z0-9\+/]", string:result) )
{
 security_hole(port);
}
