/* doscan - Denial Of Service Capable Auditing of Networks       -*- C++ -*-
 * Copyright (C) 2003 Florian Weimer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// event_queue implementation using poll(2).
// DO NOT INCLUDE THIS FILE, use event_queue::create() instead.

#ifndef EVENT_QUEUE_POLL_H
#define EVENT_QUEUE_POLL_H

#include "event_queue.h"

#include <map>
#include <vector>
#include <sys/poll.h>

class event_queue_poll : public event_queue {
  typedef std::map<int, fd_handler*> fds_t;
  fds_t fds;

  typedef std::vector<pollfd> poll_fds_t;
  poll_fds_t poll_fds;
  poll_fds_t::iterator cache_poll_fd;

  // We have to keep track of "pending" file descriptors.  These
  // descriptors have been received from poll(), but we haven't
  // dispatched them yet.  Calls to unwatch() might reassign
  // descriptors.

  struct fd_activity {
    int fd;
    fd_handler::activity act;
  };

  typedef std::vector<fd_activity> fd_activities_t;
  fd_activities_t fd_activities;

  void update_cache(int fd);
  static unsigned short convert_watch(fd_handler::watch_options);

protected:
  virtual void add_fd(fd_handler*, fd_handler::watch_options);
  virtual void update_fd(fd_handler*, fd_handler::watch_options);
  virtual void remove_fd(fd_handler*);

public:
  virtual ~event_queue_poll();
  virtual void run();
};

#endif // EVENT_QUEUE_POLL_H

// arch-tag: cc218eea-a661-41f6-b952-38cc89980108
