/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>

/* This inits the pulldown service for 3byte (RGB,GRB,uncompressed YUV, ect) frames. 
 * If oddfirst is trues then it sets the frames with the odd field first, otherwise it starts with evens.
 * foffset is used to determine the first 3:2 pulldown frame. If the interlace effect is still present then change this
 * until the interlace effect disapears. This is ment to be the first frame but sometimes isn't. Default is the first frame. */
int pulldown_init(int width, int height, bool oddfirst, int foffset);

/* This function returns a pointer to a frame. If it is NULL, then skip that frame. If it is different, 
 * then copy the returned frame to somewhere else and free it as that is not done automatically. Totalframes
 * is the number of encoded frames (meaning if it is the first frame passed, totalframes should be zero). 
 * If the returned pointer is the same as the passed frame pointer, then there is no need to copy. */
unsigned char *inverse_pulldown(guchar *framebuffer, int width, int height, glong totalframes);

/* Simply call this to close down the pulldown routines. */
void pulldown_cleanup(void);
