#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#	DrPython is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#PositionChooser Widget

import wx

class drPositionChooser(wx.Panel):
	def __init__(self, parent):
		wx.Panel.__init__(self, parent, size=(100, 100))
				
		self.ID_LEFT = 51
		self.ID_RIGHT = 52
		self.ID_TOP = 53
		self.ID_BOTTOM = 54
		
		self.Left = wx.ToggleButton(self, self.ID_LEFT, 'L', (0, 25), (25, 50))
		self.Right = wx.ToggleButton(self, self.ID_RIGHT, 'R', (75, 25), (25, 50))
		self.Top = wx.ToggleButton(self, self.ID_TOP, 'T', (25, 0), (50, 25))
		self.Bottom = wx.ToggleButton(self, self.ID_BOTTOM, 'B', (25, 75), (50, 25))
		
		self.Bind(wx.EVT_TOGGLEBUTTON, self.OnToggle, id=self.ID_LEFT)
		self.Bind(wx.EVT_TOGGLEBUTTON, self.OnToggle, id=self.ID_RIGHT)
		self.Bind(wx.EVT_TOGGLEBUTTON, self.OnToggle, id=self.ID_TOP)
		self.Bind(wx.EVT_TOGGLEBUTTON, self.OnToggle, id=self.ID_BOTTOM)
	
	def GetValue(self):
		return self.value
	
	def OnToggle(self, event):
		eid = event.GetId()
		self.value = eid - self.ID_LEFT
		self.UpdateButtons()
		
	def SetValue(self, value):
		self.value = value
		self.UpdateButtons()
		
	def UpdateButtons(self):
		self.Left.SetValue(self.value == 0)
		self.Right.SetValue(self.value == 1)
		self.Top.SetValue(self.value == 2)
		self.Bottom.SetValue(self.value == 3)