### v0.28.0

#### Freelook Rewrite
- Freelook aiming and projectile behavior has been rewritten
  - Projectile speed is correctly set for vertical angles
  - Floors and ceilings can be hit with hitscan weapons
  - Unified behavior across games
  - You can now rocket jump vertically (if enabled by MAPINFO)
  - DSDA format demos record vertical aiming since it affects behavior (e.g., in udmf map demos)
- Added MAPINFO flags to support finite height explosion behavior
  - `NoVerticalExplosionThrust`: turns off vertical explosion thrust (default)
  - `VerticalExplosionThrust`: turns on vertical explosion thrust
  - `ExplodeIn2D`: explosion damage is based on x and y coordinates (default)
  - `ExplodeIn3D`: explosion damage is based on x, y, and z coordinates
- Added MAPINFO flags to support freelook
  - `NoFreelook`: disables freelook and manual vertical aiming (default)
  - `AllowFreelook`: enables freelook and manual vertical aiming

#### UDMF
- Added `Music_ChangeSong` special
- Added `Music_Stop` special
- Added `NoGravity` MAPINFO flag ("Gravity = 0" is not cross-port compatible)

#### Console
- Added `idbehold*` console commands
- Added `player.kill` console command

#### Quality of Life
- Added `-playlump X` for playing internal demo lumps (e.g., DEMO1)
- Added level table shortcut keybinding
- Added previous level key (default bind is `PGUP`)
- Added automap tag highlighting (default binding is `h`)
- Added autosave on level start option (default is off)
- Added option to mute when out of focus
- Added automatic pistol start option
- Added some game behavior flags to the menu (not effective while recording)
  - Added fast monsters option
  - Added respawn monsters option
  - Added no monsters option
  - Added coop spawns option

#### Tools
- Added automatic demo personal best split updates
- Added message tracking distance to ledge when nearly making a jump, when coordinate display is on
- Added `lack` item condition for build mode brute force (opposite of `have`)
- Added automap player trail tools
  - Added position tracker ignoring collisions (MarkJeronimus)
  - Added position tracker with collisions (e.g., for tracking bumps)

#### Miscellaneous
- Added support for musinfo default tracks
- Added executable directory to file search path for linux and macos (already was on windows) (Pedro-Beirao)
- Added `quit_sounds` config option to restore quit sounds (FozzeY)
- Added support for shift symbols in save names in doom (Phytolizer)
- Added support for XDG_DATA_HOME for linux (spazzylemons)
  - If the legacy .dsda-doom directory exists, that will still be used
- Changed wad stats page to show totals for levels completed so far

#### Bug Fixes
- Fixed inconsistent game controller input in menus
- Fixed a performance issue in cl11+ maps with many monsters after the player was brought under 50% health
- Fixed MAPINFO par time units (seconds)
- Fixed `-recordfromto` requiring `-skill`
- Fixed background fps limit not persisting across sessions
- Fixed flat tile scaling
- Fixed walk cam resetting when hitting rewind
- Fixed an issue with interpolation that could lead to a rubber-banding effect
- Fixed a crash caused by long console commands
- Fixed junk pixels caused by midtexture row offsets in udmf
- Fixed END* patches not showing in scroll finale when provided in pwad
- Fixed inconsistent input handling in confirmation dialogs
- Fixed inconsistent sound behavior when using the walk camera
- Fixed spawning on top of 3d midtex in udmf
- Fixed demo playback progress bar colors in alternate palettes / raven
- Fixed a crash caused by entering certain symbols in the save menu in raven
- Fixed bfg edition detection
- Fixed banishment device in hexen
- Fixed UMAPINFO walkover bossactions
- Fixed the ssg triggering a weaponless player under certain conditions in mbf21
- Fixed crosshair color by health option not working in raven
- Fixed ambient sounds playing when sounds are muted
- Fixed blood color using the new hud color translations
  - You need to supply translation lumps if a given wad doesn't supply them
- Fixed sky crash when episode is out of bounds (PeterN)
- Fixed player sounds cut off by item pickups (jackrjli)
- Fixed hom on sky textures when close to height limits in opengl (Pedro-Beirao)
- Fixed error in vertex positions noticeable in detailed geometry in opengl (Pedro-Beirao)
- Fixed background fps limit affecting viddump (Pedro-Beirao)
- Fixed z-fighting on bottom texture with skytexture (Pedro-Beirao)
- Fixed weapon sprite offset for irregular aspect ratios (Omnisthetics)
