// Matrices as const char strings, generated by mkmat_h.pl using
// 'mtrx/' as input directory

const uint32 kMatrixCount = 9;

const struct MatrixInfo {
	const char*	m_name;
	const char*	m_family;
	int			m_nr;
	const char*	m_data;
	
	std::string	name() const		{ return m_name; }
	
} kMatrices[] = {
	{
		"PAM20", "PAM", 2,
		"#\n"
		"# This matrix was produced by \"pam\" Version 1.0.6 [28-Jul-93]\n"
		"#\n"
		"# PAM 20 substitution matrix, scale = ln(2)/2 = 0.346574\n"
		"#\n"
		"# Expected score = -6.18, Entropy = 2.95 bits\n"
		"#\n"
		"# Lowest score = -19, Highest score = 13\n"
		"#\n"
		"    A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *\n"
		"A   6  -8  -5  -4  -8  -5  -3  -3  -8  -6  -7  -8  -6  -9  -2  -1  -1 -16  -9  -3  -5  -4  -4 -19\n"
		"R  -8   9  -7 -12  -9  -2 -11 -11  -3  -6 -10  -1  -5 -10  -5  -4  -8  -3 -11  -9  -9  -5  -7 -19\n"
		"N  -5  -7   8   1 -13  -5  -3  -4  -1  -6  -8  -2 -11 -10  -7  -1  -3  -9  -5  -9   6  -4  -4 -19\n"
		"D  -4 -12   1   8 -16  -4   2  -4  -5  -9 -15  -6 -13 -17  -9  -5  -6 -17 -13  -9   6   0  -7 -19\n"
		"C  -8  -9 -13 -16  10 -16 -16 -11  -8  -7 -17 -16 -16 -15  -9  -4  -9 -18  -5  -7 -14 -16 -11 -19\n"
		"Q  -5  -2  -5  -4 -16   9   0  -8   0  -9  -6  -4  -5 -15  -4  -6  -7 -15 -14  -8  -4   7  -6 -19\n"
		"E  -3 -11  -3   2 -16   0   8  -5  -6  -6 -10  -5  -8 -16  -7  -5  -7 -19  -9  -8   0   6  -6 -19\n"
		"G  -3 -11  -4  -4 -11  -8  -5   7 -10 -13 -12  -8 -10 -10  -7  -3  -7 -17 -16  -7  -4  -6  -6 -19\n"
		"H  -8  -3  -1  -5  -8   0  -6 -10   9 -11  -7  -8 -13  -7  -5  -7  -8  -8  -4  -7  -2  -2  -6 -19\n"
		"I  -6  -6  -6  -9  -7  -9  -6 -13 -11   9  -2  -7  -2  -3 -10  -8  -3 -16  -7   1  -7  -7  -6 -19\n"
		"L  -7 -10  -8 -15 -17  -6 -10 -12  -7  -2   7  -9   0  -4  -8  -9  -8  -7  -8  -3 -10  -8  -7 -19\n"
		"K  -8  -1  -2  -6 -16  -4  -5  -8  -8  -7  -9   7  -3 -16  -8  -5  -4 -14 -10 -10  -3  -5  -6 -19\n"
		"M  -6  -5 -11 -13 -16  -5  -8 -10 -13  -2   0  -3  11  -5  -9  -6  -5 -15 -13  -2 -12  -6  -6 -19\n"
		"F  -9 -10 -10 -17 -15 -15 -16 -10  -7  -3  -4 -16  -5   9 -11  -7 -10  -6   1  -9 -12 -16  -9 -19\n"
		"P  -2  -5  -7  -9  -9  -4  -7  -7  -5 -10  -8  -8  -9 -11   8  -3  -5 -16 -16  -7  -8  -5  -6 -19\n"
		"S  -1  -4  -1  -5  -4  -6  -5  -3  -7  -8  -9  -5  -6  -7  -3   7   0  -6  -8  -8  -2  -6  -4 -19\n"
		"T  -1  -8  -3  -6  -9  -7  -7  -7  -8  -3  -8  -4  -5 -10  -5   0   7 -15  -7  -4  -4  -7  -5 -19\n"
		"W -16  -3  -9 -17 -18 -15 -19 -17  -8 -16  -7 -14 -15  -6 -16  -6 -15  13  -6 -18 -11 -17 -13 -19\n"
		"Y  -9 -11  -5 -13  -5 -14  -9 -16  -4  -7  -8 -10 -13   1 -16  -8  -7  -6  10  -8  -7 -11  -9 -19\n"
		"V  -3  -9  -9  -9  -7  -8  -8  -7  -7   1  -3 -10  -2  -9  -7  -8  -4 -18  -8   7  -9  -8  -6 -19\n"
		"B  -5  -9   6   6 -14  -4   0  -4  -2  -7 -10  -3 -12 -12  -8  -2  -4 -11  -7  -9   6  -1  -6 -19\n"
		"Z  -4  -5  -4   0 -16   7   6  -6  -2  -7  -8  -5  -6 -16  -5  -6  -7 -17 -11  -8  -1   6  -6 -19\n"
		"X  -4  -7  -4  -7 -11  -6  -6  -6  -6  -6  -7  -6  -6  -9  -6  -4  -5 -13  -9  -6  -6  -6  -6 -19\n"
		"* -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19   1\n"

	},
	{
		"PAM120", "PAM", 1,
		"#\n"
		"# This matrix was produced by \"pam\" Version 1.0.6 [28-Jul-93]\n"
		"#\n"
		"# PAM 120 substitution matrix, scale = ln(2)/2 = 0.346574\n"
		"#\n"
		"# Expected score = -1.64, Entropy = 0.979 bits\n"
		"#\n"
		"# Lowest score = -8, Highest score = 12\n"
		"#\n"
		"   A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *\n"
		"A  3 -3 -1  0 -3 -1  0  1 -3 -1 -3 -2 -2 -4  1  1  1 -7 -4  0  0 -1 -1 -8\n"
		"R -3  6 -1 -3 -4  1 -3 -4  1 -2 -4  2 -1 -5 -1 -1 -2  1 -5 -3 -2 -1 -2 -8\n"
		"N -1 -1  4  2 -5  0  1  0  2 -2 -4  1 -3 -4 -2  1  0 -4 -2 -3  3  0 -1 -8\n"
		"D  0 -3  2  5 -7  1  3  0  0 -3 -5 -1 -4 -7 -3  0 -1 -8 -5 -3  4  3 -2 -8\n"
		"C -3 -4 -5 -7  9 -7 -7 -4 -4 -3 -7 -7 -6 -6 -4  0 -3 -8 -1 -3 -6 -7 -4 -8\n"
		"Q -1  1  0  1 -7  6  2 -3  3 -3 -2  0 -1 -6  0 -2 -2 -6 -5 -3  0  4 -1 -8\n"
		"E  0 -3  1  3 -7  2  5 -1 -1 -3 -4 -1 -3 -7 -2 -1 -2 -8 -5 -3  3  4 -1 -8\n"
		"G  1 -4  0  0 -4 -3 -1  5 -4 -4 -5 -3 -4 -5 -2  1 -1 -8 -6 -2  0 -2 -2 -8\n"
		"H -3  1  2  0 -4  3 -1 -4  7 -4 -3 -2 -4 -3 -1 -2 -3 -3 -1 -3  1  1 -2 -8\n"
		"I -1 -2 -2 -3 -3 -3 -3 -4 -4  6  1 -3  1  0 -3 -2  0 -6 -2  3 -3 -3 -1 -8\n"
		"L -3 -4 -4 -5 -7 -2 -4 -5 -3  1  5 -4  3  0 -3 -4 -3 -3 -2  1 -4 -3 -2 -8\n"
		"K -2  2  1 -1 -7  0 -1 -3 -2 -3 -4  5  0 -7 -2 -1 -1 -5 -5 -4  0 -1 -2 -8\n"
		"M -2 -1 -3 -4 -6 -1 -3 -4 -4  1  3  0  8 -1 -3 -2 -1 -6 -4  1 -4 -2 -2 -8\n"
		"F -4 -5 -4 -7 -6 -6 -7 -5 -3  0  0 -7 -1  8 -5 -3 -4 -1  4 -3 -5 -6 -3 -8\n"
		"P  1 -1 -2 -3 -4  0 -2 -2 -1 -3 -3 -2 -3 -5  6  1 -1 -7 -6 -2 -2 -1 -2 -8\n"
		"S  1 -1  1  0  0 -2 -1  1 -2 -2 -4 -1 -2 -3  1  3  2 -2 -3 -2  0 -1 -1 -8\n"
		"T  1 -2  0 -1 -3 -2 -2 -1 -3  0 -3 -1 -1 -4 -1  2  4 -6 -3  0  0 -2 -1 -8\n"
		"W -7  1 -4 -8 -8 -6 -8 -8 -3 -6 -3 -5 -6 -1 -7 -2 -6 12 -2 -8 -6 -7 -5 -8\n"
		"Y -4 -5 -2 -5 -1 -5 -5 -6 -1 -2 -2 -5 -4  4 -6 -3 -3 -2  8 -3 -3 -5 -3 -8\n"
		"V  0 -3 -3 -3 -3 -3 -3 -2 -3  3  1 -4  1 -3 -2 -2  0 -8 -3  5 -3 -3 -1 -8\n"
		"B  0 -2  3  4 -6  0  3  0  1 -3 -4  0 -4 -5 -2  0  0 -6 -3 -3  4  2 -1 -8\n"
		"Z -1 -1  0  3 -7  4  4 -2  1 -3 -3 -1 -2 -6 -1 -1 -2 -7 -5 -3  2  4 -1 -8\n"
		"X -1 -2 -1 -2 -4 -1 -1 -2 -2 -1 -2 -2 -2 -3 -2 -1 -1 -5 -3 -1 -1 -1 -2 -8\n"
		"* -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1\n"

	},
	{
		"GONNET250", "GONNET", 2,
		"# PAM 250 matrix recommended by Gonnet, Cohen & Benner\n"
		"# Science June 5, 1992.\n"
		"# Values rounded to nearest integer\n"
		"   C  S  T  P  A  G  N  D  E  Q  H  R  K  M  I  L  V  F  Y  W  X  *\n"
		"C 12  0  0 -3  0 -2 -2 -3 -3 -2 -1 -2 -3 -1 -1 -2  0 -1  0 -1 -3 -8\n"
		"S  0  2  2  0  1  0  1  0  0  0  0  0  0 -1 -2 -2 -1 -3 -2 -3  0 -8\n"
		"T  0  2  2  0  1 -1  0  0  0  0  0  0  0 -1 -1 -1  0 -2 -2 -4  0 -8\n"
		"P -3  0  0  8  0 -2 -1 -1  0  0 -1 -1 -1 -2 -3 -2 -2 -4 -3 -5 -1 -8\n"
		"A  0  1  1  0  2  0  0  0  0  0 -1 -1  0 -1 -1 -1  0 -2 -2 -4  0 -8\n"
		"G -2  0 -1 -2  0  7  0  0 -1 -1 -1 -1 -1 -4 -4 -4 -3 -5 -4 -4 -1 -8\n"
		"N -2  1  0 -1  0  0  4  2  1  1  1  0  1 -2 -3 -3 -2 -3 -1 -4  0 -8\n"
		"D -3  0  0 -1  0  0  2  5  3  1  0  0  0 -3 -4 -4 -3 -4 -3 -5 -1 -8\n"
		"E -3  0  0  0  0 -1  1  3  4  2  0  0  1 -2 -3 -3 -2 -4 -3 -4 -1 -8\n"
		"Q -2  0  0  0  0 -1  1  1  2  3  1  2  2 -1 -2 -2 -2 -3 -2 -3 -1 -8\n"
		"H -1  0  0 -1 -1 -1  1  0  0  1  6  1  1 -1 -2 -2 -2  0  2 -1 -1 -8\n"
		"R -2  0  0 -1 -1 -1  0  0  0  2  1  5  3 -2 -2 -2 -2 -3 -2 -2 -1 -8\n"
		"K -3  0  0 -1  0 -1  1  0  1  2  1  3  3 -1 -2 -2 -2 -3 -2 -4 -1 -8\n"
		"M -1 -1 -1 -2 -1 -4 -2 -3 -2 -1 -1 -2 -1  4  2  3  2  2  0 -1 -1 -8\n"
		"I -1 -2 -1 -3 -1 -4 -3 -4 -3 -2 -2 -2 -2  2  4  3  3  1 -1 -2 -1 -8\n"
		"L -2 -2 -1 -2 -1 -4 -3 -4 -3 -2 -2 -2 -2  3  3  4  2  2  0 -1 -1 -8\n"
		"V  0 -1  0 -2  0 -3 -2 -3 -2 -2 -2 -2 -2  2  3  2  3  0 -1 -3 -1 -8\n"
		"F -1 -3 -2 -4 -2 -5 -3 -4 -4 -3  0 -3 -3  2  1  2  0  7  5  4 -2 -8\n"
		"Y  0 -2 -2 -3 -2 -4 -1 -3 -3 -2  2 -2 -2  0 -1  0 -1  5  8  4 -2 -8\n"
		"W -1 -3 -4 -5 -4 -4 -4 -5 -4 -3 -1 -2 -4 -1 -2 -1 -3  4  4 14 -4 -8\n"
		"X -3  0  0 -1  0 -1  0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -2 -2 -4 -1 -8\n"
		"* -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1\n"

	},
	{
		"PAM60", "PAM", 6,
		"#\n"
		"# This matrix was produced by \"pam\" Version 1.0.6 [28-Jul-93]\n"
		"#\n"
		"# PAM 60 substitution matrix, scale = ln(2)/2 = 0.346574\n"
		"#\n"
		"# Expected score = -3.21, Entropy = 1.79 bits\n"
		"#\n"
		"# Lowest score = -12, Highest score = 13\n"
		"#\n"
		"    A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *\n"
		"A   5  -5  -2  -2  -5  -3  -1   0  -5  -3  -4  -5  -3  -6   0   1   1 -10  -6  -1  -2  -2  -2 -12\n"
		"R  -5   8  -3  -6  -6   0  -6  -7   0  -4  -6   2  -2  -7  -2  -2  -4   0  -8  -5  -5  -2  -4 -12\n"
		"N  -2  -3   6   2  -7  -2   0  -1   1  -4  -5   0  -6  -6  -4   1  -1  -6  -3  -5   5  -1  -2 -12\n"
		"D  -2  -6   2   7 -10  -1   3  -2  -2  -5  -9  -2  -7 -11  -5  -2  -3 -11  -8  -6   5   2  -3 -12\n"
		"C  -5  -6  -7 -10   9 -10 -10  -7  -6  -4 -11 -10 -10  -9  -6  -1  -5 -12  -2  -4  -9 -10  -6 -12\n"
		"Q  -3   0  -2  -1 -10   7   2  -5   2  -5  -3  -1  -2  -9  -1  -3  -4  -9  -8  -5  -1   6  -3 -12\n"
		"E  -1  -6   0   3 -10   2   7  -2  -3  -4  -7  -3  -5 -10  -3  -2  -4 -12  -7  -4   2   5  -3 -12\n"
		"G   0  -7  -1  -2  -7  -5  -2   6  -6  -7  -8  -5  -6  -7  -4   0  -3 -11 -10  -4  -2  -3  -3 -12\n"
		"H  -5   0   1  -2  -6   2  -3  -6   8  -6  -4  -4  -7  -4  -2  -4  -5  -5  -2  -5   0   0  -3 -12\n"
		"I  -3  -4  -4  -5  -4  -5  -4  -7  -6   7   0  -4   1  -1  -6  -4  -1 -10  -4   3  -4  -4  -3 -12\n"
		"L  -4  -6  -5  -9 -11  -3  -7  -8  -4   0   6  -6   2  -1  -5  -6  -5  -4  -5  -1  -7  -5  -4 -12\n"
		"K  -5   2   0  -2 -10  -1  -3  -5  -4  -4  -6   6   0 -10  -4  -2  -2  -8  -7  -6  -1  -2  -3 -12\n"
		"M  -3  -2  -6  -7 -10  -2  -5  -6  -7   1   2   0  10  -2  -6  -4  -2  -9  -7   0  -6  -4  -3 -12\n"
		"F  -6  -7  -6 -11  -9  -9 -10  -7  -4  -1  -1 -10  -2   8  -7  -5  -6  -3   3  -5  -8 -10  -5 -12\n"
		"P   0  -2  -4  -5  -6  -1  -3  -4  -2  -6  -5  -4  -6  -7   7   0  -2 -10 -10  -4  -4  -2  -3 -12\n"
		"S   1  -2   1  -2  -1  -3  -2   0  -4  -4  -6  -2  -4  -5   0   5   1  -4  -5  -4   0  -3  -2 -12\n"
		"T   1  -4  -1  -3  -5  -4  -4  -3  -5  -1  -5  -2  -2  -6  -2   1   6  -9  -5  -1  -2  -4  -2 -12\n"
		"W -10   0  -6 -11 -12  -9 -12 -11  -5 -10  -4  -8  -9  -3 -10  -4  -9  13  -3 -11  -8 -11  -8 -12\n"
		"Y  -6  -8  -3  -8  -2  -8  -7 -10  -2  -4  -5  -7  -7   3 -10  -5  -5  -3   9  -5  -5  -7  -5 -12\n"
		"V  -1  -5  -5  -6  -4  -5  -4  -4  -5   3  -1  -6   0  -5  -4  -4  -1 -11  -5   6  -5  -5  -3 -12\n"
		"B  -2  -5   5   5  -9  -1   2  -2   0  -4  -7  -1  -6  -8  -4   0  -2  -8  -5  -5   5   1  -3 -12\n"
		"Z  -2  -2  -1   2 -10   6   5  -3   0  -4  -5  -2  -4 -10  -2  -3  -4 -11  -7  -5   1   5  -3 -12\n"
		"X  -2  -4  -2  -3  -6  -3  -3  -3  -3  -3  -4  -3  -3  -5  -3  -2  -2  -8  -5  -3  -3  -3  -3 -12\n"
		"* -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12   1\n"

	},
	{
		"BLOSUM30", "BLOSUM", 3,
		"#  Matrix made by matblas from blosum30.iij\n"
		"#  * column uses minimum score\n"
		"#  BLOSUM Clustered Scoring Matrix in 1/5 Bit Units\n"
		"#  Blocks Database = /data/blocks_5.0/blocks.dat\n"
		"#  Cluster Percentage: >= 30\n"
		"#  Entropy =   0.1424, Expected =  -0.1074\n"
		"   A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *\n"
		"A  4 -1  0  0 -3  1  0  0 -2  0 -1  0  1 -2 -1  1  1 -5 -4  1  0  0  0 -7 \n"
		"R -1  8 -2 -1 -2  3 -1 -2 -1 -3 -2  1  0 -1 -1 -1 -3  0  0 -1 -2  0 -1 -7 \n"
		"N  0 -2  8  1 -1 -1 -1  0 -1  0 -2  0  0 -1 -3  0  1 -7 -4 -2  4 -1  0 -7 \n"
		"D  0 -1  1  9 -3 -1  1 -1 -2 -4 -1  0 -3 -5 -1  0 -1 -4 -1 -2  5  0 -1 -7 \n"
		"C -3 -2 -1 -3 17 -2  1 -4 -5 -2  0 -3 -2 -3 -3 -2 -2 -2 -6 -2 -2  0 -2 -7 \n"
		"Q  1  3 -1 -1 -2  8  2 -2  0 -2 -2  0 -1 -3  0 -1  0 -1 -1 -3 -1  4  0 -7 \n"
		"E  0 -1 -1  1  1  2  6 -2  0 -3 -1  2 -1 -4  1  0 -2 -1 -2 -3  0  5 -1 -7 \n"
		"G  0 -2  0 -1 -4 -2 -2  8 -3 -1 -2 -1 -2 -3 -1  0 -2  1 -3 -3  0 -2 -1 -7 \n"
		"H -2 -1 -1 -2 -5  0  0 -3 14 -2 -1 -2  2 -3  1 -1 -2 -5  0 -3 -2  0 -1 -7 \n"
		"I  0 -3  0 -4 -2 -2 -3 -1 -2  6  2 -2  1  0 -3 -1  0 -3 -1  4 -2 -3  0 -7 \n"
		"L -1 -2 -2 -1  0 -2 -1 -2 -1  2  4 -2  2  2 -3 -2  0 -2  3  1 -1 -1  0 -7 \n"
		"K  0  1  0  0 -3  0  2 -1 -2 -2 -2  4  2 -1  1  0 -1 -2 -1 -2  0  1  0 -7 \n"
		"M  1  0  0 -3 -2 -1 -1 -2  2  1  2  2  6 -2 -4 -2  0 -3 -1  0 -2 -1  0 -7 \n"
		"F -2 -1 -1 -5 -3 -3 -4 -3 -3  0  2 -1 -2 10 -4 -1 -2  1  3  1 -3 -4 -1 -7 \n"
		"P -1 -1 -3 -1 -3  0  1 -1  1 -3 -3  1 -4 -4 11 -1  0 -3 -2 -4 -2  0 -1 -7 \n"
		"S  1 -1  0  0 -2 -1  0  0 -1 -1 -2  0 -2 -1 -1  4  2 -3 -2 -1  0 -1  0 -7 \n"
		"T  1 -3  1 -1 -2  0 -2 -2 -2  0  0 -1  0 -2  0  2  5 -5 -1  1  0 -1  0 -7 \n"
		"W -5  0 -7 -4 -2 -1 -1  1 -5 -3 -2 -2 -3  1 -3 -3 -5 20  5 -3 -5 -1 -2 -7 \n"
		"Y -4  0 -4 -1 -6 -1 -2 -3  0 -1  3 -1 -1  3 -2 -2 -1  5  9  1 -3 -2 -1 -7 \n"
		"V  1 -1 -2 -2 -2 -3 -3 -3 -3  4  1 -2  0  1 -4 -1  1 -3  1  5 -2 -3  0 -7 \n"
		"B  0 -2  4  5 -2 -1  0  0 -2 -2 -1  0 -2 -3 -2  0  0 -5 -3 -2  5  0 -1 -7 \n"
		"Z  0  0 -1  0  0  4  5 -2  0 -3 -1  1 -1 -4  0 -1 -1 -1 -2 -3  0  4  0 -7 \n"
		"X  0 -1  0 -1 -2  0 -1 -1 -1  0  0  0  0 -1 -1  0  0 -2 -1  0 -1  0 -1 -7 \n"
		"* -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7  1 \n"

	},
	{
		"PAM350", "PAM", 3,
		"#\n"
		"# This matrix was produced by \"pam\" Version 1.0.6 [28-Jul-93]\n"
		"#\n"
		"# PAM 350 substitution matrix, scale = ln(2)/5 = 0.138629\n"
		"#\n"
		"# Expected score = -0.701, Entropy = 0.186 bits\n"
		"#\n"
		"# Lowest score = -10, Highest score = 27\n"
		"#\n"
		"    A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *\n"
		"A   2  -1   0   1  -2   0   1   2  -1   0  -2  -1  -1  -4   1   1   1  -7  -4   0   1   0   0 -10\n"
		"R  -1   7   1  -1  -4   2   0  -2   2  -2  -3   4   0  -5   0   0  -1   4  -5  -3   0   1  -1 -10\n"
		"N   0   1   2   2  -4   1   2   1   2  -2  -3   1  -2  -4   0   1   1  -5  -3  -2   2   2   0 -10\n"
		"D   1  -1   2   4  -6   2   4   1   1  -2  -4   1  -3  -6   0   1   0  -8  -5  -2   3   3  -1 -10\n"
		"C  -2  -4  -4  -6  18  -6  -6  -4  -4  -3  -7  -6  -6  -5  -3   0  -2 -10   1  -2  -5  -6  -3 -10\n"
		"Q   0   2   1   2  -6   4   3  -1   3  -2  -2   1  -1  -5   1   0   0  -5  -5  -2   2   3   0 -10\n"
		"E   1   0   2   4  -6   3   4   1   1  -2  -4   0  -2  -6   0   0   0  -8  -5  -2   3   3   0 -10\n"
		"G   2  -2   1   1  -4  -1   1   5  -2  -2  -4  -1  -3  -6   0   1   1  -8  -6  -1   1   0  -1 -10\n"
		"H  -1   2   2   1  -4   3   1  -2   7  -2  -2   1  -2  -2   0  -1  -1  -3   0  -2   1   2   0 -10\n"
		"I   0  -2  -2  -2  -3  -2  -2  -2  -2   5   4  -2   3   2  -2  -1   0  -6   0   4  -2  -2   0 -10\n"
		"L  -2  -3  -3  -4  -7  -2  -4  -4  -2   4   8  -3   5   3  -3  -3  -2  -2   0   3  -4  -3  -1 -10\n"
		"K  -1   4   1   1  -6   1   0  -1   1  -2  -3   5   0  -6  -1   0   0  -4  -5  -2   1   1  -1 -10\n"
		"M  -1   0  -2  -3  -6  -1  -2  -3  -2   3   5   0   6   1  -2  -2  -1  -5  -2   2  -2  -2   0 -10\n"
		"F  -4  -5  -4  -6  -5  -5  -6  -6  -2   2   3  -6   1  13  -5  -4  -3   1  11  -1  -5  -6  -2 -10\n"
		"P   1   0   0   0  -3   1   0   0   0  -2  -3  -1  -2  -5   6   1   1  -7  -6  -1   0   0   0 -10\n"
		"S   1   0   1   1   0   0   0   1  -1  -1  -3   0  -2  -4   1   1   1  -3  -3  -1   1   0   0 -10\n"
		"T   1  -1   1   0  -2   0   0   1  -1   0  -2   0  -1  -3   1   1   2  -6  -3   0   0   0   0 -10\n"
		"W  -7   4  -5  -8 -10  -5  -8  -8  -3  -6  -2  -4  -5   1  -7  -3  -6  27   1  -7  -6  -7  -5 -10\n"
		"Y  -4  -5  -3  -5   1  -5  -5  -6   0   0   0  -5  -2  11  -6  -3  -3   1  14  -2  -4  -5  -2 -10\n"
		"V   0  -3  -2  -2  -2  -2  -2  -1  -2   4   3  -2   2  -1  -1  -1   0  -7  -2   5  -2  -2   0 -10\n"
		"B   1   0   2   3  -5   2   3   1   1  -2  -4   1  -2  -5   0   1   0  -6  -4  -2   3   2   0 -10\n"
		"Z   0   1   2   3  -6   3   3   0   2  -2  -3   1  -2  -6   0   0   0  -7  -5  -2   2   3   0 -10\n"
		"X   0  -1   0  -1  -3   0   0  -1   0   0  -1  -1   0  -2   0   0   0  -5  -2   0   0   0  -1 -10\n"
		"* -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10   1\n"

	},
	{
		"BLOSUM62", "BLOSUM", 6,
		"#  Matrix made by matblas from blosum62.iij\n"
		"#  * column uses minimum score\n"
		"#  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units\n"
		"#  Blocks Database = /data/blocks_5.0/blocks.dat\n"
		"#  Cluster Percentage: >= 62\n"
		"#  Entropy =   0.6979, Expected =  -0.5209\n"
		"   A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *\n"
		"A  4 -1 -2 -2  0 -1 -1  0 -2 -1 -1 -1 -1 -2 -1  1  0 -3 -2  0 -2 -1  0 -4 \n"
		"R -1  5  0 -2 -3  1  0 -2  0 -3 -2  2 -1 -3 -2 -1 -1 -3 -2 -3 -1  0 -1 -4 \n"
		"N -2  0  6  1 -3  0  0  0  1 -3 -3  0 -2 -3 -2  1  0 -4 -2 -3  3  0 -1 -4 \n"
		"D -2 -2  1  6 -3  0  2 -1 -1 -3 -4 -1 -3 -3 -1  0 -1 -4 -3 -3  4  1 -1 -4 \n"
		"C  0 -3 -3 -3  9 -3 -4 -3 -3 -1 -1 -3 -1 -2 -3 -1 -1 -2 -2 -1 -3 -3 -2 -4 \n"
		"Q -1  1  0  0 -3  5  2 -2  0 -3 -2  1  0 -3 -1  0 -1 -2 -1 -2  0  3 -1 -4 \n"
		"E -1  0  0  2 -4  2  5 -2  0 -3 -3  1 -2 -3 -1  0 -1 -3 -2 -2  1  4 -1 -4 \n"
		"G  0 -2  0 -1 -3 -2 -2  6 -2 -4 -4 -2 -3 -3 -2  0 -2 -2 -3 -3 -1 -2 -1 -4 \n"
		"H -2  0  1 -1 -3  0  0 -2  8 -3 -3 -1 -2 -1 -2 -1 -2 -2  2 -3  0  0 -1 -4 \n"
		"I -1 -3 -3 -3 -1 -3 -3 -4 -3  4  2 -3  1  0 -3 -2 -1 -3 -1  3 -3 -3 -1 -4 \n"
		"L -1 -2 -3 -4 -1 -2 -3 -4 -3  2  4 -2  2  0 -3 -2 -1 -2 -1  1 -4 -3 -1 -4 \n"
		"K -1  2  0 -1 -3  1  1 -2 -1 -3 -2  5 -1 -3 -1  0 -1 -3 -2 -2  0  1 -1 -4 \n"
		"M -1 -1 -2 -3 -1  0 -2 -3 -2  1  2 -1  5  0 -2 -1 -1 -1 -1  1 -3 -1 -1 -4 \n"
		"F -2 -3 -3 -3 -2 -3 -3 -3 -1  0  0 -3  0  6 -4 -2 -2  1  3 -1 -3 -3 -1 -4 \n"
		"P -1 -2 -2 -1 -3 -1 -1 -2 -2 -3 -3 -1 -2 -4  7 -1 -1 -4 -3 -2 -2 -1 -2 -4 \n"
		"S  1 -1  1  0 -1  0  0  0 -1 -2 -2  0 -1 -2 -1  4  1 -3 -2 -2  0  0  0 -4 \n"
		"T  0 -1  0 -1 -1 -1 -1 -2 -2 -1 -1 -1 -1 -2 -1  1  5 -2 -2  0 -1 -1  0 -4 \n"
		"W -3 -3 -4 -4 -2 -2 -3 -2 -2 -3 -2 -3 -1  1 -4 -3 -2 11  2 -3 -4 -3 -2 -4 \n"
		"Y -2 -2 -2 -3 -2 -1 -2 -3  2 -1 -1 -2 -1  3 -3 -2 -2  2  7 -1 -3 -2 -1 -4 \n"
		"V  0 -3 -3 -3 -1 -2 -2 -3 -3  3  1 -2  1 -1 -2 -2  0 -3 -1  4 -3 -2 -1 -4 \n"
		"B -2 -1  3  4 -3  0  1 -1  0 -3 -4  0 -3 -3 -2  0 -1 -4 -3 -3  4  1 -1 -4 \n"
		"Z -1  0  0  1 -3  3  4 -2  0 -3 -3  1 -1 -3 -1  0 -1 -3 -2 -2  1  4 -1 -4 \n"
		"X  0 -1 -1 -1 -2 -1 -1 -1 -1 -1 -1 -1 -1 -1 -2  0  0 -2 -1 -1 -1 -1 -1 -4 \n"
		"* -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4  1 \n"

	},
	{
		"BLOSUM80", "BLOSUM", 8,
		"#  Matrix made by matblas from blosum80_3.iij\n"
		"#  * column uses minimum score\n"
		"#  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units\n"
		"#  Blocks Database = /data/blocks_5.0/blocks.dat\n"
		"#  Cluster Percentage: >= 80\n"
		"#  Entropy =   0.9868, Expected =  -0.7442\n"
		"   A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *\n"
		"A  7 -3 -3 -3 -1 -2 -2  0 -3 -3 -3 -1 -2 -4 -1  2  0 -5 -4 -1 -3 -2 -1 -8 \n"
		"R -3  9 -1 -3 -6  1 -1 -4  0 -5 -4  3 -3 -5 -3 -2 -2 -5 -4 -4 -2  0 -2 -8 \n"
		"N -3 -1  9  2 -5  0 -1 -1  1 -6 -6  0 -4 -6 -4  1  0 -7 -4 -5  5 -1 -2 -8 \n"
		"D -3 -3  2 10 -7 -1  2 -3 -2 -7 -7 -2 -6 -6 -3 -1 -2 -8 -6 -6  6  1 -3 -8 \n"
		"C -1 -6 -5 -7 13 -5 -7 -6 -7 -2 -3 -6 -3 -4 -6 -2 -2 -5 -5 -2 -6 -7 -4 -8 \n"
		"Q -2  1  0 -1 -5  9  3 -4  1 -5 -4  2 -1 -5 -3 -1 -1 -4 -3 -4 -1  5 -2 -8 \n"
		"E -2 -1 -1  2 -7  3  8 -4  0 -6 -6  1 -4 -6 -2 -1 -2 -6 -5 -4  1  6 -2 -8 \n"
		"G  0 -4 -1 -3 -6 -4 -4  9 -4 -7 -7 -3 -5 -6 -5 -1 -3 -6 -6 -6 -2 -4 -3 -8 \n"
		"H -3  0  1 -2 -7  1  0 -4 12 -6 -5 -1 -4 -2 -4 -2 -3 -4  3 -5 -1  0 -2 -8 \n"
		"I -3 -5 -6 -7 -2 -5 -6 -7 -6  7  2 -5  2 -1 -5 -4 -2 -5 -3  4 -6 -6 -2 -8 \n"
		"L -3 -4 -6 -7 -3 -4 -6 -7 -5  2  6 -4  3  0 -5 -4 -3 -4 -2  1 -7 -5 -2 -8 \n"
		"K -1  3  0 -2 -6  2  1 -3 -1 -5 -4  8 -3 -5 -2 -1 -1 -6 -4 -4 -1  1 -2 -8 \n"
		"M -2 -3 -4 -6 -3 -1 -4 -5 -4  2  3 -3  9  0 -4 -3 -1 -3 -3  1 -5 -3 -2 -8 \n"
		"F -4 -5 -6 -6 -4 -5 -6 -6 -2 -1  0 -5  0 10 -6 -4 -4  0  4 -2 -6 -6 -3 -8 \n"
		"P -1 -3 -4 -3 -6 -3 -2 -5 -4 -5 -5 -2 -4 -6 12 -2 -3 -7 -6 -4 -4 -2 -3 -8 \n"
		"S  2 -2  1 -1 -2 -1 -1 -1 -2 -4 -4 -1 -3 -4 -2  7  2 -6 -3 -3  0 -1 -1 -8 \n"
		"T  0 -2  0 -2 -2 -1 -2 -3 -3 -2 -3 -1 -1 -4 -3  2  8 -5 -3  0 -1 -2 -1 -8 \n"
		"W -5 -5 -7 -8 -5 -4 -6 -6 -4 -5 -4 -6 -3  0 -7 -6 -5 16  3 -5 -8 -5 -5 -8 \n"
		"Y -4 -4 -4 -6 -5 -3 -5 -6  3 -3 -2 -4 -3  4 -6 -3 -3  3 11 -3 -5 -4 -3 -8 \n"
		"V -1 -4 -5 -6 -2 -4 -4 -6 -5  4  1 -4  1 -2 -4 -3  0 -5 -3  7 -6 -4 -2 -8 \n"
		"B -3 -2  5  6 -6 -1  1 -2 -1 -6 -7 -1 -5 -6 -4  0 -1 -8 -5 -6  6  0 -3 -8 \n"
		"Z -2  0 -1  1 -7  5  6 -4  0 -6 -5  1 -3 -6 -2 -1 -2 -5 -4 -4  0  6 -1 -8 \n"
		"X -1 -2 -2 -3 -4 -2 -2 -3 -2 -2 -2 -2 -2 -3 -3 -1 -1 -5 -3 -2 -3 -1 -2 -8 \n"
		"* -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1 \n"

	},
	{
		"BLOSUM45", "BLOSUM", 4,
		"#  Matrix made by matblas from blosum45.iij\n"
		"#  * column uses minimum score\n"
		"#  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units\n"
		"#  Blocks Database = /data/blocks_5.0/blocks.dat\n"
		"#  Cluster Percentage: >= 45\n"
		"#  Entropy =   0.3795, Expected =  -0.2789\n"
		"   A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *\n"
		"A  5 -2 -1 -2 -1 -1 -1  0 -2 -1 -1 -1 -1 -2 -1  1  0 -2 -2  0 -1 -1  0 -5 \n"
		"R -2  7  0 -1 -3  1  0 -2  0 -3 -2  3 -1 -2 -2 -1 -1 -2 -1 -2 -1  0 -1 -5 \n"
		"N -1  0  6  2 -2  0  0  0  1 -2 -3  0 -2 -2 -2  1  0 -4 -2 -3  4  0 -1 -5 \n"
		"D -2 -1  2  7 -3  0  2 -1  0 -4 -3  0 -3 -4 -1  0 -1 -4 -2 -3  5  1 -1 -5 \n"
		"C -1 -3 -2 -3 12 -3 -3 -3 -3 -3 -2 -3 -2 -2 -4 -1 -1 -5 -3 -1 -2 -3 -2 -5 \n"
		"Q -1  1  0  0 -3  6  2 -2  1 -2 -2  1  0 -4 -1  0 -1 -2 -1 -3  0  4 -1 -5 \n"
		"E -1  0  0  2 -3  2  6 -2  0 -3 -2  1 -2 -3  0  0 -1 -3 -2 -3  1  4 -1 -5 \n"
		"G  0 -2  0 -1 -3 -2 -2  7 -2 -4 -3 -2 -2 -3 -2  0 -2 -2 -3 -3 -1 -2 -1 -5 \n"
		"H -2  0  1  0 -3  1  0 -2 10 -3 -2 -1  0 -2 -2 -1 -2 -3  2 -3  0  0 -1 -5 \n"
		"I -1 -3 -2 -4 -3 -2 -3 -4 -3  5  2 -3  2  0 -2 -2 -1 -2  0  3 -3 -3 -1 -5 \n"
		"L -1 -2 -3 -3 -2 -2 -2 -3 -2  2  5 -3  2  1 -3 -3 -1 -2  0  1 -3 -2 -1 -5 \n"
		"K -1  3  0  0 -3  1  1 -2 -1 -3 -3  5 -1 -3 -1 -1 -1 -2 -1 -2  0  1 -1 -5 \n"
		"M -1 -1 -2 -3 -2  0 -2 -2  0  2  2 -1  6  0 -2 -2 -1 -2  0  1 -2 -1 -1 -5 \n"
		"F -2 -2 -2 -4 -2 -4 -3 -3 -2  0  1 -3  0  8 -3 -2 -1  1  3  0 -3 -3 -1 -5 \n"
		"P -1 -2 -2 -1 -4 -1  0 -2 -2 -2 -3 -1 -2 -3  9 -1 -1 -3 -3 -3 -2 -1 -1 -5 \n"
		"S  1 -1  1  0 -1  0  0  0 -1 -2 -3 -1 -2 -2 -1  4  2 -4 -2 -1  0  0  0 -5 \n"
		"T  0 -1  0 -1 -1 -1 -1 -2 -2 -1 -1 -1 -1 -1 -1  2  5 -3 -1  0  0 -1  0 -5 \n"
		"W -2 -2 -4 -4 -5 -2 -3 -2 -3 -2 -2 -2 -2  1 -3 -4 -3 15  3 -3 -4 -2 -2 -5 \n"
		"Y -2 -1 -2 -2 -3 -1 -2 -3  2  0  0 -1  0  3 -3 -2 -1  3  8 -1 -2 -2 -1 -5 \n"
		"V  0 -2 -3 -3 -1 -3 -3 -3 -3  3  1 -2  1  0 -3 -1  0 -3 -1  5 -3 -3 -1 -5 \n"
		"B -1 -1  4  5 -2  0  1 -1  0 -3 -3  0 -2 -3 -2  0  0 -4 -2 -3  4  2 -1 -5 \n"
		"Z -1  0  0  1 -3  4  4 -2  0 -3 -2  1 -1 -3 -1  0 -1 -2 -2 -3  2  4 -1 -5 \n"
		"X  0 -1 -1 -1 -2 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  0  0 -2 -1 -1 -1 -1 -1 -5 \n"
		"* -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5  1 \n"

	},
};
