#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <getopt.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <limits.h>
#include <sys/types.h>
#include <pwd.h>
#include <sys/time.h>

#include "header.h"

tErr header::init(char** zeMsg,long unsigned* curSize){
	tErr err;
	m_msgbuf = zeMsg;
	m_msgsize = curSize;

	if( (err = countLines(*zeMsg,*curSize)) != noErr) return err;
	if( (err = getHeaderFields()) != noErr) return err;
	return noErr;
}

tErr header::countLines(char* zeMsg,long size){
	unsigned int curLine=0;
	unsigned int curLineSize=0;

	m_headerLines[0]=0;
	for(long i=2;i<size-2;i++){
		if(zeMsg[i-2] =='\r' && zeMsg[i-1] =='\n' &&
		zeMsg[i] =='\r' && zeMsg[i+1] =='\n'){
			m_headerLinesSize[curLine]=curLineSize;
			m_headerSize = i;
			m_headerNumLines = curLine+1;
			return noErr;
		}
		if(zeMsg[i-2] =='\r' && zeMsg[i-1] =='\n'){
			m_headerLines[curLine+1]=i;
			m_headerLinesSize[curLine]=curLineSize;
			curLine++;
			if(curLine>=MAX_HEADER_LINE-2)	return INCONSISTENT_MESSAGE;
			curLineSize=0;
		}
		curLineSize++;
	}
	return INCONSISTENT_MESSAGE;
}
