#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <getopt.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <limits.h>
#include <sys/types.h>
#include <pwd.h>
#include <sys/time.h>

#include <mysql/mysql.h>

#include <dotconf.h>

#include "global.h"
#include "config_file.h"

igw_config_t igw_config;

static configoption_t options[] = {
	{"mysql_hostname", ARG_STR, cb_mysql_hostname, NULL, 0},
	{"mysql_user", ARG_STR, cb_mysql_user, NULL, 0},
	{"mysql_pass", ARG_STR, cb_mysql_pass, NULL, 0},
	{"mysql_db", ARG_STR, cb_mysql_db, NULL, 0},
	{"mysql_table_whitelist", ARG_STR, cb_mysql_table_whitelist, NULL, 0},
	{"mysql_table_pop_access", ARG_STR, cb_mysql_table_pop_access, NULL, 0},
	LAST_OPTION
};

DOTCONF_CB(cb_mysql_hostname){
	igw_config.mysql_hostname = (char*)malloc(strlen(cmd->data.str)+1);
	strcpy(igw_config.mysql_hostname,cmd->data.str);
	return NULL;
}
DOTCONF_CB(cb_mysql_user){
	igw_config.mysql_user = (char*)malloc(strlen(cmd->data.str)+1);
	strcpy(igw_config.mysql_user,cmd->data.str);
	return NULL;
}
DOTCONF_CB(cb_mysql_pass){
	igw_config.mysql_pass = (char*)malloc(strlen(cmd->data.str)+1);
	strcpy(igw_config.mysql_pass,cmd->data.str);
	return NULL;
}
DOTCONF_CB(cb_mysql_db){
	igw_config.mysql_db = (char*)malloc(strlen(cmd->data.str)+1);
	strcpy(igw_config.mysql_db,cmd->data.str);
	return NULL;
}
DOTCONF_CB(cb_mysql_table_whitelist){
	igw_config.mysql_table_whitelist = (char*)malloc(strlen(cmd->data.str)+1);
	strcpy(igw_config.mysql_table_whitelist,cmd->data.str);
	return NULL;
}
DOTCONF_CB(cb_mysql_table_pop_access){
	igw_config.mysql_table_pop_access = (char*)malloc(strlen(cmd->data.str)+1);
	strcpy(igw_config.mysql_table_pop_access,cmd->data.str);
	return NULL;
}
void read_config_file(){
	configfile_t *configfile;
	configfile = dotconf_create("/etc/igw.conf", options, 0, CASE_INSENSITIVE);
	if (dotconf_command_loop(configfile) == 0){
	fprintf(stderr, "Error reading config file\n");
		exit(2);
	}
	dotconf_cleanup(configfile);
	return;
}
