<?php
require_once('./DtcScriptingRequest.php');

class DtcAdminScriptingClient extends DtcScriptingRequest {
  private $dtcadmin_host = '';

  public function __construct( $dtcadmin_host, $dtcadmin_login, $dtcadmin_pass, $verify_cert = false ) {	
	$this->dtcadmin_host = $dtcadmin_host;
        parent::__construct( 'https://'.$dtcadmin_host.'/dtcadmin/index.php?', $dtcadmin_login, $dtcadmin_pass, true, $verify_cert, "DTC Admin Scripting Client 0.1");
  }

  public function addNewAccountRequest($product_id, $login, $password, $name, $firstname, $is_company, $company_name, $vat_num, $email, $phone, $fax, $address1, $address2, $address3, $zipcode, $city, $country, $notes, $domain_name = '', $vps_server_hostname = '-1', $vps_os = 'debian' ){
	$params = array();
	$params['action'] = 'new_user_request';
	$params['product_id'] = $product_id;
        $params['domain_name'] = $domain_name;
        $params['vps_server_hostname'] = $vps_server_hostname;
        $params['vps_os'] = $vps_os;
        $params['reqadm_login'] = $login;
        $params['reqadm_pass'] = $password;
        $params['reqadm_pass2'] = $password;
        $params['familyname'] = $name;
        $params['firstname'] = $firstname;
        $params['iscomp'] = $is_company;
        $params['compname'] = $company_name;
        $params['vat_num'] = $vat_num;
        $params['email'] = $email;
        $params['phone'] = $phone;
        $params['fax'] = $fax;
        $params['address1'] = $address1;
        $params['address2'] = $address2;
        $params['address3'] = $address3;
        $params['zipcode'] = $zipcode;
        $params['city'] = $city;
        $params['state'] = $state;
        $params['country'] = $country;
        $params['custom_notes'] = $notes;
        $params['Login'] = 'Register';

	return $this->doRequest($params, 'https://'.$this->dtcadmin_host.'/dtc/new_account.php?');
  }

  public function confirmWaitingAccount( $account ) {
	return $this->doRequest(array('action' => 'valid_waiting_user', 'reqadm_login' => $account ));
  }

}  
