/*==============================================================================

FICHIER     : [dvdtools.c]

DATE        : 2005/12/0001 22:04:33

CREATEUR    : [Linux!jef]

COMMENTAIRE :
		Released under GPL license, see gnu.org
================================================================================

==============================================================================*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <gnome.h>

#define CTEST(x)		/***/

#include "dvdinfo.h"
#include "dvdtools.h"
#include "message.h"
#include "globals.h"
#include "uitools.h"

static int BadStart = -1;
static int BadEnd = -1;

static double FramesPerSec[4] = { -1.0, 25.00, -1.0, 29.97 };
static char * _AudioFormat[7] = { "ac3", "?", "mpeg1", "mpeg2", "lpcm ", "sdds ", "dts" };

#define MAX_PISTE		100
static Piste_t	Pistes[MAX_PISTE];


/*------------------------------------------------------------------------------
	MILLISECONDE-
Linux!jef 2005/12/16 00:10:15
------------------------------------------------------------------------------*/

int MilliSeconde( dvd_time_t * dt )
{
	double fps = FramesPerSec[(dt->frame_u & 0xc0) >> 6];
	long ms;

	ms = (((dt->hour & 0xf0) >> 3) * 5 + (dt->hour & 0x0f)) * 3600000;
	ms += (((dt->minute & 0xf0) >> 3) * 5 + (dt->minute & 0x0f)) * 60000;
	ms += (((dt->second & 0xf0) >> 3) * 5 + (dt->second & 0x0f)) * 1000;

	if (fps > 0) ms += (((dt->frame_u & 0x30) >> 3) * 5 + (dt->frame_u & 0x0f)) * 1000.0 / fps;

	return( ms );
}

/*------------------------------------------------------------------------------
	ISNAVPACK-
Linux!jef 2006/01/05 21:47:00
------------------------------------------------------------------------------*/

int isNavPack( unsigned char *_ptr )
{
	uint32_t start_code;
	unsigned char * ptr = _ptr;

	if((ptr [0]!=0) || (ptr [1] !=0) || (ptr [2] != 0x01) || (ptr [3] != 0xba))
		return( 0 );

	if((ptr [4] & 0xc0) != 0x40 )	return( 0 );

    // ptr += 14;

	start_code  = (uint32_t) (ptr [14]) << 24;
	start_code |= (uint32_t) (ptr [15]) << 16;
	start_code |= (uint32_t) (ptr [16]) <<  8;
	start_code |= (uint32_t) (ptr [17]);

	if( start_code != 0x000001bb )	return( 0 );

    //  ptr += 24;

	start_code  = (uint32_t) (ptr [0x26]) << 24;
	start_code |= (uint32_t) (ptr [0x27]) << 16;
	start_code |= (uint32_t) (ptr [0x28]) <<  8;
	start_code |= (uint32_t) (ptr [0x29]);

	if( start_code != 0x000001bf )	return( 0 );

    //  ptr += 986;

	start_code  = (uint32_t) (ptr [0x400]) << 24;
	start_code |= (uint32_t) (ptr [0x401]) << 16;
	start_code |= (uint32_t) (ptr [0x402]) <<  8;
	start_code |= (uint32_t) (ptr [0x403]);

	if( start_code != 0x000001bf )	return( 0 );

	return( 1 );
}

/*------------------------------------------------------------------------------
	IDENTIFYSTREAM-
Linux!jef 2006/01/18 22:27:22
------------------------------------------------------------------------------*/

int IdentifyStream( unsigned char * buffer, int * packetType )
{
    *packetType = buffer[17];

    if( (*packetType >= 0xE0) && (*packetType <= 0xEF) ) {                 // video streams
        return stVideo;
    } else if( *packetType == 0xBB ) {                                       // system header
        return stOther;
    } else if( *packetType == 0xBE ) {                                       // padding
        return stOther;
    } else if( *packetType == 0xBF ) {                                       // nav pack
        return stOther;
    } else if( (*packetType >= 0xC0) && (*packetType <= 0xDF) ) {            // mpeg audio
        return stAudio;
    } else if( *packetType == 0xBD ) {                                       // private stream, check content
        *packetType = buffer[23+buffer[22]];
        if (( (*packetType >=0x80) && (*packetType <=0x8f)) || ((*packetType >=0xa0) && (*packetType <=0xa7)) || ((*packetType >=0xc0) && (*packetType <=0xdf)))
            return stAudio;
        if ( (*packetType >=0x20) && (*packetType <=0x3f))
            return stSubpicture;
        return stOther;
    }
	return stOther;
}
/*------------------------------------------------------------------------------
	GETSTREAMID-
Linux!jef 2006/01/18 22:49:32
------------------------------------------------------------------------------*/

int GetStreamID( int type )
{
	int abase = 0;

	if (type >= 0x80 && type <= 0x87) {
	// AC3 audio
		abase = 0x80;
	} else if (type >= 0x88 && type <= 0x8f) {
	// DTS audio
		abase = 0x88;
	} else if (type >= 0xa0 && type <= 0xbf) {
	// LPCM audio
		abase = 0xa0;
	} else if (type >= 0xc0 && type <= 0xdf) {
	// MPEG audio
		abase = 0xc0;
	} else if (type >= 0x20 && type <= 0x3f) {
	//subpicture;
		abase = 0x20;
	}
	return( type - abase );
}

/*------------------------------------------------------------------------------
	GETPGC-
Linux!jef 2006/02/16 21:37:01
------------------------------------------------------------------------------*/

pgc_t * GetPgc( int noPisteVideo )
{
	pgcit_t *vts_pgcit;
	vtsi_mat_t *vtsi_mat;
	vmgi_mat_t *vmgi_mat;
	video_attr_t *video_attr;
	int title_set_nr;
	int vts_ttn;
	pgc_t *pgc;

	vtsi_mat = Ifo[Ifo_zero->tt_srpt->title[noPisteVideo].title_set_nr]->vtsi_mat;
	vts_pgcit = Ifo[Ifo_zero->tt_srpt->title[noPisteVideo].title_set_nr]->vts_pgcit;
	video_attr = &vtsi_mat->vts_video_attr;
	vts_ttn = Ifo_zero->tt_srpt->title[noPisteVideo].vts_ttn;
	vmgi_mat = Ifo_zero->vmgi_mat;
	title_set_nr = Ifo_zero->tt_srpt->title[noPisteVideo].title_set_nr;
	pgc = vts_pgcit->pgci_srp[Ifo[title_set_nr]->vts_ptt_srpt->title[vts_ttn - 1].ptt[0].pgcn - 1].pgc;

	return( pgc );
}

/*------------------------------------------------------------------------------
	BUILDCHAPTERSTRING-
Linux!jef 2005/12/16 00:12:54
------------------------------------------------------------------------------*/

char * BuildChapitreString( int noPisteVideo )
{
	pgc_t * pgc = GetPgc( noPisteVideo );
	int cell;
	int i;
	int nbChapters = pgc->nr_of_programs;
	char * chapitreStr;
	long long milliSec = 0;

// fprintf(stderr,"Il y a %d chapitre\n", nbChapters );
	chapitreStr = malloc( (nbChapters * 15)+1);
	strcpy( chapitreStr, "00:00:00.000" );
	cell = 0;
	for( i = 0; i < pgc->nr_of_programs; i++ ) {
		int next = pgc->program_map[i + 1];

		if (i == pgc->nr_of_programs - 1)	next = pgc->nr_of_cells + 1;
		while( cell < next - 1 ) {
			milliSec += MilliSeconde( &pgc->cell_playback[cell].playback_time );
			cell++;
		}
		if (i < (pgc->nr_of_programs - 1)) {
			char szDummy[128];

			sprintf (szDummy,",%02lld:%02lld:%02lld.%03lld",
				milliSec / 3600000,
				(milliSec / 60000) % 60,
				(milliSec / 1000) % 60,
				milliSec % 1000);
			strcat( chapitreStr, szDummy);
		}
	}
// fprintf(stderr,"BuildChapitreString(%s)\n", chapitreStr );
	return( chapitreStr );
}

/*------------------------------------------------------------------------------
	SAVEPALETTE-
Linux!jef 2005/12/15 21:59:05
------------------------------------------------------------------------------*/

void SavePalette( int noPisteVideo, char * pFile )
{
	FILE * fp;
	pgc_t * pgc = GetPgc( noPisteVideo );

	if( !pgc->palette )	return;

	fp = fopen( pFile, "w" );
	if( fp  ) {
		int i;

		for( i = 0; i < 16; i++ ) {
			fprintf( fp,"%06x\n", pgc->palette[i]);
		}
		fclose( fp );
	}
}

/*------------------------------------------------------------------------------
	AUDIOLANG-
Linux!jef 2005/12/16 22:07:24
------------------------------------------------------------------------------*/

char * AudioLang( int noPisteVideo, int noPisteAudio )
{
	static char lang_code[3];
	vtsi_mat_t *vtsi_mat;
	audio_attr_t *audio_attr;

	vtsi_mat = Ifo[Ifo_zero->tt_srpt->title[noPisteVideo].title_set_nr]->vtsi_mat;

	audio_attr = &vtsi_mat->vts_audio_attr[noPisteAudio];
	sprintf( lang_code, "%c%c", audio_attr->lang_code >> 8,audio_attr->lang_code & 0xff);
	return( lang_code );
}

/*------------------------------------------------------------------------------
	SUBLANG-
Linux!jef 2005/12/16 22:07:24
------------------------------------------------------------------------------*/

char * SubLang( int noPisteVideo, int noSubtitle )
{
	static char lang_code[3];
	vtsi_mat_t *vtsi_mat;
	subp_attr_t *subp_attr;

	vtsi_mat = Ifo[Ifo_zero->tt_srpt->title[noPisteVideo].title_set_nr]->vtsi_mat;

	subp_attr = &vtsi_mat->vts_subp_attr[noSubtitle];
	sprintf (lang_code, "%c%c", subp_attr->lang_code >> 8, subp_attr->lang_code & 0xff);
	if (!lang_code[0])	strcpy (lang_code, "xx");

	return( lang_code );
}


/*------------------------------------------------------------------------------
	AUDIOFORMAT-
Linux!jef 2005/12/16 22:07:24
------------------------------------------------------------------------------*/

char * AudioFormat( int noPisteVideo, int noPisteAudio )
{
	vtsi_mat_t *vtsi_mat;
	audio_attr_t *audio_attr;

	vtsi_mat = Ifo[Ifo_zero->tt_srpt->title[noPisteVideo].title_set_nr]->vtsi_mat;

	audio_attr = &vtsi_mat->vts_audio_attr[noPisteAudio];
//!!	if( (audio_attr->channels + 1) == 6 )	return( "dts" );
	return( _AudioFormat[audio_attr->audio_format] );
}
/*------------------------------------------------------------------------------
	FINDNEXTGOODSECTOR-
Linux!jef 2006/07/07 20:49:13
------------------------------------------------------------------------------*/

static int FindNextGoodSector( dvd_file_t * dvdFile, int noSect, int lim )
{
	char buffer[DVD_VIDEO_LB_LEN];
	int bMax;
	int next;
	int res;

	if( lim < 1000 )	lim = 1000;
	bMax = noSect + lim;

	CTEST(fprintf(stderr,"Testing <%d,%d>\n", noSect, bMax ););
	while( (bMax - noSect) > 1 ) {
		next = noSect + (( bMax - noSect ) / 2);

		res = DVDReadBlocks( dvdFile, next, 1, (unsigned char *)buffer );
		if( res == 1 ) {
			CTEST(fprintf(stderr,"sector %d good\n", next ););
			bMax = next;
		}
		else {
			CTEST(fprintf(stderr,"sector %d bad\n", next ););
			noSect = next;
		}
	}
	CTEST(fprintf(stderr,"NextGood: %d\n", bMax ););
	return( bMax );
}

/*------------------------------------------------------------------------------
	MYDVDREADBLOCKS-
Linux!jef 2006/07/06 22:04:04
------------------------------------------------------------------------------*/

ssize_t MyDVDReadBlocks( dvd_file_t * dvdFile, int noSect, size_t nbSect, unsigned char * buffer )
{
	ssize_t nbRead;

	CTEST(fprintf(stderr,"Reading(%d,%ld) (%d,%d)\n", noSect, nbSect, BadStart, BadEnd ););
	if( (noSect >= BadStart) && (int)(noSect+nbSect) <= BadEnd ) {
		memset( buffer, 0, DVD_VIDEO_LB_LEN * nbSect );
		return( nbSect );
	}
	nbRead = DVDReadBlocks( dvdFile, noSect, nbSect, buffer );
	CTEST(fprintf(stderr,"Readed:=%ld\n", nbRead ););
	if( nbRead < 0 ) {
		nbRead = 0;
	}
	else {
		BadStart = BadEnd = -1;
	}
	noSect += nbRead;
	nbSect -= nbRead;
	buffer += ( nbRead * DVD_VIDEO_LB_LEN );
	if( !nbSect )	return( nbRead );
	if( IgnoreErrors == -1 ) {
		int res = MessageBoxYesNo( _("Erreur de lecture ! Ignorer les erreurs ?" ) );
		if( res == 1 )
			IgnoreErrors = 1;
		else
			IgnoreErrors = 0;
	}
	if( !IgnoreErrors )	return( -1 );
	CTEST(fprintf(stderr,"ReadError: nbSect=%ld\n", nbSect ););
/* En cas d'erreur de  lecture on suppose que c'est un plage complete qui est HS pour eviter
	de prendre trop de temps avec des lectures unitaires
*/
	BadStart = noSect;
	BadEnd = FindNextGoodSector( dvdFile, noSect, nbSect + 1 );

	return( nbRead + MyDVDReadBlocks( dvdFile, noSect, nbSect, buffer ) );
#if 0

	if( nbSect == 1 ) {
		memset( buffer, 0, DVD_VIDEO_LB_LEN );
		return( 1 );
	}
	while( nbSect > 0 ) {
		ssize_t res;

		res = DVDReadBlocks( dvdFile, noSect, 1, buffer );
		if( res != 1 ) {
fprintf(stderr,"ReadError: Sector=%d zeroed\n", noSect );
			memset( buffer, 0, DVD_VIDEO_LB_LEN );
		}
		else {
fprintf(stderr,"ReadError: Sector=%d readed\n", noSect );
		}
		noSect += 1;
		nbSect -= 1;
		buffer += ( 1 * DVD_VIDEO_LB_LEN );
		nbRead += 1;
	}
	return( nbRead );
#endif
}

/*------------------------------------------------------------------------------
	GETPISTE-
Linux!jef 2006/11/21 23:55:54
------------------------------------------------------------------------------*/

Piste_t * GetPiste( int noPisteVideo )
{
	return( Pistes + noPisteVideo );
}
/*------------------------------------------------------------------------------
	RAZPISTES-
Linux!jef 2006/11/22 00:01:51
------------------------------------------------------------------------------*/

void RazPistes()
{
	memset( &Pistes, 0, sizeof(Pistes));
}
