/*==============================================================================

FICHIER     : [config.c]

DATE        : 2005/12/0002 20:57:36

CREATEUR    : [Linux!jef]

COMMENTAIRE :
		Released under GPL license, see gnu.org
================================================================================

==============================================================================*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf-client.h>
#include <stdio.h>

#include "interface.h"
#include "support.h"
#include "systools.h"
#include "gconfig.h"
#include "globals.h"
#include "message.h"
#include "uitools.h"

/*------------------------------------------------------------------------------
	DIALOGPROPRIETE-
Linux!jef 2006/02/14 22:40:44
------------------------------------------------------------------------------*/

void DialogPropriete( GtkWidget * parent )
{
	GtkWidget * Propriete;
	GtkWidget * oldParent;

	Propriete = create_propriete();

	gtk_window_set_transient_for( GTK_WINDOW(Propriete), GTK_WINDOW(parent) );

	gtk_widget_show ( Propriete );
	LoadConfig( Propriete );
	oldParent = AlerteSetParent( Propriete );
	gtk_main();
	AlerteSetParent( oldParent );
}
/*------------------------------------------------------------------------------
	SETBUTTON-
Linux!jef 2007/01/16 23:07:50
------------------------------------------------------------------------------*/

static void SetCheck( GtkWidget * item, char * value )
{
	GtkCheckButton * rb;
	GtkToggleButton * tb;

	rb = GTK_CHECK_BUTTON( item );
	tb = &rb->toggle_button;
	if( *value == '1' )
		gtk_toggle_button_set_active( tb, TRUE );
	else
		gtk_toggle_button_set_active( tb, FALSE );
}
/*------------------------------------------------------------------------------
	GETCHECK-
Linux!jef 2007/01/16 23:13:07
------------------------------------------------------------------------------*/

static char * GetCheck( GtkWidget * item )
{
	GtkCheckButton * rb;
	GtkToggleButton * tb;

	rb = GTK_CHECK_BUTTON( item );
	tb = &rb->toggle_button;
	if( gtk_toggle_button_get_active( tb ) == TRUE )
		return( "1" );
	return( "0" );
}


/*------------------------------------------------------------------------------
	LOADCONFIG-
Linux!jef 2005/12/02 20:58:39
------------------------------------------------------------------------------*/

int LoadConfig( GtkWidget * propriete )
{
	GConfClient * cc;
	gchar * value;
	GtkWidget * item;
	int i;

	cc = gconf_client_get_default();
	if( !cc )	return( -1 );

	value = gconf_client_get_string( cc, KEY_DEVICE, NULL);
	if( !value )	value = "/dev/dvd";
	item = lookup_widget(GTK_WIDGET(propriete), "cfgdev" );
	g_assert( item );

/* Populate combo */
	if( FileExist( value ) == 2 ) {
		gtk_combo_box_append_text( GTK_COMBO_BOX(item), value );
	}
	if( FileExist( "/dev/dvd" ) == 2 ) {
		if( strcmp( value, "/dev/dvd"))	gtk_combo_box_append_text( GTK_COMBO_BOX(item), "/dev/dvd" );
	}
/* Ide cdrom/dvdrom devices */
	for( i = 0; i < 26; i++ ) {
		char devName[100];

		sprintf( devName, "/dev/hd%c", 'a'+i );
		if( FileExist( devName ) == 2 ) {
			if( strcmp( value, devName ))	gtk_combo_box_append_text( GTK_COMBO_BOX(item), devName );
		}
	}
/* Scsi cdrom/dvdrom devices */
	for( i = 0; i < 10; i++ ) {
		char devName[100];

		sprintf( devName, "/dev/sr%d", i );
		if( FileExist( devName ) == 2 ) {
			if( strcmp( value, devName ))	gtk_combo_box_append_text( GTK_COMBO_BOX(item), devName );
		}
	}
/* Loop devices */
	for( i = 0; i < 10; i++ ) {
		char devName[100];

		sprintf( devName, "/dev/loop%d", i );
		if( FileExist( devName ) == 2 && IsLoopDeviceReady( devName ) ) {
			if( strcmp( value, devName ))	gtk_combo_box_append_text( GTK_COMBO_BOX(item), devName );
		}
	}


	gtk_entry_set_text( GTK_ENTRY (GTK_BIN (item)->child), value );
	gtk_widget_show( item );

	value = gconf_client_get_string( cc, KEY_TEMP, NULL);
	if( !value )	value = "/tmp";
	item = lookup_widget(GTK_WIDGET(propriete), "cfgtemp" );
	g_assert( item );
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(item), value );
	gtk_widget_show( item );
#if 0
	value = gconf_client_get_string( cc, KEY_AUDIO, NULL);
	if( !value )	value = "fr";
	item = lookup_widget(GTK_WIDGET(propriete), "cfgpisteaudio" );
	gtk_entry_set_text( GTK_ENTRY(item), value );
	gtk_widget_show( item );

	value = gconf_client_get_string( cc, KEY_SUBTITLE, NULL);
	if( !value )	value = "fr";
	item = lookup_widget(GTK_WIDGET(propriete), "cfgsoustitre" );
	gtk_entry_set_text( GTK_ENTRY(item), value );
	gtk_widget_show( item );
#endif

	value = gconf_client_get_string( cc, KEY_USEMENU, NULL);
	if( !value )	value = "1";
	item = lookup_widget(GTK_WIDGET(propriete), "UseMenu" );
	g_assert( item );
	SetCheck( item, value );
	gtk_widget_show( item );

	value = gconf_client_get_string( cc, KEY_MKISO, NULL);
	if( !value )	value = "1";
	item = lookup_widget(GTK_WIDGET(propriete), "DoIso" );
	g_assert( item );
	SetCheck( item, value );
	gtk_widget_show( item );

	value = gconf_client_get_string( cc, KEY_GRAVER, NULL);
	if( !value )	value = "1";
	item = lookup_widget(GTK_WIDGET(propriete), "graver" );
	g_assert( item );
	SetCheck( item, value );
	gtk_widget_show( item );

	value = gconf_client_get_string( cc, KEY_QUALDYN, NULL);
	if( !value )	value = "1";
	item = lookup_widget(GTK_WIDGET(propriete), "dynqual" );
	g_assert( item );
	SetCheck( item, value );
	gtk_widget_show( item );

	value = gconf_client_get_string( cc, KEY_GENERIQUE, NULL);
	if( !value )	value = "1";
	item = lookup_widget(GTK_WIDGET(propriete), "generique" );
	g_assert( item );
	SetCheck( item, value );
	gtk_widget_show( item );

	value = gconf_client_get_string( cc, KEY_ISODIR, NULL);
	if( !value )	value = "/tmp";
	item = lookup_widget(GTK_WIDGET(propriete), "cfgiso" );
	g_assert( item );
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(item), value );
	gtk_widget_show( item );

	value = gconf_client_get_string( cc, KEY_LANG, NULL);
	if( !value )	value = "";
	item = lookup_widget(GTK_WIDGET(propriete), "lang" );
	gtk_entry_set_text( GTK_ENTRY (GTK_BIN (item)->child), value );
	gtk_widget_show( item );

	value = gconf_client_get_string( cc, KEY_PLAYER, NULL);
	if( !value )	value = "xine";
	item = lookup_widget(GTK_WIDGET(propriete), "cfgvisu" );
	g_assert( item );
	gtk_entry_set_text( GTK_ENTRY (GTK_BIN (item)->child), value );

	if( flook( "xine" ) )	gtk_combo_box_append_text( GTK_COMBO_BOX(item), "xine" );
	if( flook( "mplayer" ) )	gtk_combo_box_append_text( GTK_COMBO_BOX(item), "mplayer" );
	if( flook( "vlc" ) )	gtk_combo_box_append_text( GTK_COMBO_BOX(item), "vlc" );
	if( flook( "gxine" ) )	gtk_combo_box_append_text( GTK_COMBO_BOX(item), "gxine" );
	if( flook( "totem" ) )	gtk_combo_box_append_text( GTK_COMBO_BOX(item), "totem" );
	if( flook( "kaffeine" ) )	gtk_combo_box_append_text( GTK_COMBO_BOX(item), "kaffeine" );
	if( flook( "gnome-open" ) )	gtk_combo_box_append_text( GTK_COMBO_BOX(item), "gnome-open" );

	gtk_widget_show( item );

	value = gconf_client_get_string( cc, KEY_TRACE, NULL);
	if( !value )	value = "";
	item = lookup_widget(GTK_WIDGET(propriete), "trace" );
	g_assert( item );
	gtk_entry_set_text( GTK_ENTRY(item), value );
	gtk_widget_show( item );

	value = gconf_client_get_string( cc, KEY_SOUND, NULL);
	if( !value )	value = "0";
	item = lookup_widget(GTK_WIDGET(propriete), "sound" );
	g_assert( item );
	SetCheck( item, value );
	gtk_widget_show( item );

	value = gconf_client_get_string( cc, KEY_MEDIA, NULL);
	if( !value )	value = "0";
	item = lookup_widget(GTK_WIDGET(propriete), "cfgmedia" );
	g_assert( item );
	gtk_combo_box_set_active( GTK_COMBO_BOX(item), atoi(value));

	return( 0 );
}
/*------------------------------------------------------------------------------
	SAVECONFIG-
Linux!jef 2005/12/02 21:40:06
------------------------------------------------------------------------------*/

int SaveConfig( GtkWidget * propriete )
{
	GConfClient * cc;
	const gchar * value;
	GtkWidget * item;

	cc = gconf_client_get_default();
	if( !cc )	return( -1 );


	item = lookup_widget(GTK_WIDGET(propriete), "cfgdev" );
	g_assert( item );
	value = gtk_entry_get_text( GTK_ENTRY(GTK_BIN(item)->child) );
	gconf_client_set_string( cc, KEY_DEVICE, value, NULL);
	strcpy( Device, value );

	item = lookup_widget(GTK_WIDGET(propriete), "cfgtemp" );
	g_assert( item );
	value = gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER(item));
	gconf_client_set_string( cc, KEY_TEMP, value, NULL);

	item = lookup_widget(GTK_WIDGET(propriete), "UseMenu" );
	g_assert( item );
	gconf_client_set_string( cc, KEY_USEMENU, GetCheck(item), NULL);

	item = lookup_widget(GTK_WIDGET(propriete), "DoIso" );
	g_assert( item );
	gconf_client_set_string( cc, KEY_MKISO, GetCheck(item), NULL);

	item = lookup_widget(GTK_WIDGET(propriete), "graver" );
	g_assert( item );
	gconf_client_set_string( cc, KEY_GRAVER, GetCheck(item), NULL);


	item = lookup_widget(GTK_WIDGET(propriete), "dynqual" );
	g_assert( item );
	gconf_client_set_string( cc, KEY_QUALDYN, GetCheck(item), NULL);

	item = lookup_widget(GTK_WIDGET(propriete), "generique" );
	g_assert( item );
	gconf_client_set_string( cc, KEY_GENERIQUE, GetCheck(item), NULL);

	item = lookup_widget(GTK_WIDGET(propriete), "cfgiso" );
	g_assert( item );
	value = gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER(item));
	gconf_client_set_string( cc, KEY_ISODIR, value, NULL);

	item = lookup_widget(GTK_WIDGET(propriete), "cfgvisu" );
	g_assert( item );
	value = gtk_entry_get_text( GTK_ENTRY(GTK_BIN(item)->child) );
	gconf_client_set_string( cc, KEY_PLAYER, value, NULL);


	item = lookup_widget(GTK_WIDGET(propriete), "lang" );
	g_assert( item );
	value = gtk_entry_get_text( GTK_ENTRY(GTK_BIN(item)->child) );
	gconf_client_set_string( cc, KEY_LANG, value, NULL);


	item = lookup_widget(GTK_WIDGET(propriete), "trace" );
	g_assert( item );
	value = gtk_entry_get_text( GTK_ENTRY(item) );
	gconf_client_set_string( cc, KEY_TRACE, value, NULL);

	item = lookup_widget(GTK_WIDGET(propriete), "sound" );
	g_assert( item );
	gconf_client_set_string( cc, KEY_SOUND, GetCheck(item), NULL);

	item = lookup_widget(GTK_WIDGET(propriete), "cfgmedia" );
	g_assert( item );
	{
		int active = gtk_combo_box_get_active( GTK_COMBO_BOX(item));
		char string[100];

		sprintf( string,"%d", active );
		gconf_client_set_string( cc, KEY_MEDIA, string, NULL);
	}

	return( 0 );
}

/*------------------------------------------------------------------------------
	CONFIGGETSTRING-
Linux!jef 2005/12/02 21:56:32
------------------------------------------------------------------------------*/

gchar * ConfigGetString( char * key, char * defValue )
{
	GConfClient * cc;
	gchar * value;

	cc = gconf_client_get_default();
	if( !cc )	return( defValue );

	value = gconf_client_get_string( cc, key, NULL );
	if( !value )	return( defValue );
	return( value );
}

/*------------------------------------------------------------------------------
	CONFIGGETINT-
Linux!jef 2005/12/02 21:56:32
------------------------------------------------------------------------------*/

int ConfigGetInt( char * key, int defValue )
{
	GConfClient * cc;
	gchar * value;

	cc = gconf_client_get_default();
	if( !cc )	return( defValue );

	value = gconf_client_get_string( cc, key, NULL );
	if( !value )	return( defValue );
// fprintf(stderr,"ConfigGetInt(%s)=(%s)\n", key, value );
	return( atoi(value) );
}

/*------------------------------------------------------------------------------
	SETCONFIGSTRING-
Linux!jef 2005/12/18 20:24:09
------------------------------------------------------------------------------*/

int SetConfigString( char * key, char * value )
{
	GConfClient * cc;

	cc = gconf_client_get_default();
	if( !cc )	return( -1 );

	gconf_client_set_string( cc, key, (const gchar *)value, NULL);

	return( 0 );
}

/*------------------------------------------------------------------------------
	SETCONFIGINT-
Linux!jef 2005/12/18 20:24:09
------------------------------------------------------------------------------*/

int SetConfigInt( char * key, int value )
{
	GConfClient * cc;
	char strValue[200];

	cc = gconf_client_get_default();
	if( !cc )	return( -1 );
	sprintf( strValue,"%d", value );
	gconf_client_set_string( cc, key, (const gchar *)strValue, NULL);

	return( 0 );
}

/*------------------------------------------------------------------------------
	VERIFCONFIG-
Linux!jef 2005/12/17 00:33:17
------------------------------------------------------------------------------*/

int VerifConfig( GtkWidget * propriete )
{
	char * device = ConfigGetString( KEY_DEVICE, "/dev/dvd" );
	char * tmpDir = ConfigGetString( KEY_TEMP, "/tmp" );
	char * isoDir = ConfigGetString( KEY_ISODIR, "/tmp" );
	int res = 0;
	int ret;

	if( !strcmp( tmpDir, isoDir ) ) {
		MessageBoxError( _("Les repertoires temporaire et iso doivent etre differents  !") );
		res = -1;
	}
	if( !flook( "mkisofs" ) ) {
		MessageBoxError( _("mkisofs manquant !") );
		res = -1;
	}
	if( DirExist( tmpDir ) != 1 ) {
		MessageBoxError( _("Le repertoire %s n'existe pas !"), tmpDir );
		res = -1;
	}
	if( DirExist( isoDir ) != 1 ) {
		MessageBoxError( _("Le repertoire %s n'existe pas !"), isoDir );
		res = -1;
	}
	ret = FileExist( device );
	if( ret != 1 && ret != 2 ) {
		MessageBoxError( _("Le fichier %s n'existe pas !"), device );
		res = -1;
	}
//	if( !res ) {
//		Alerte( 0, _("Tous les outils sont present !") );
//	}
	return( res );
}
/*------------------------------------------------------------------------------
	INITTRACE-
Linux!jef 2006/01/17 19:53:34
------------------------------------------------------------------------------*/

void InitTrace()
{
	char * lvl = ConfigGetString( KEY_TRACE, "" );

	memset( DbgLevels, 0, sizeof(DbgLevels));
	if( !strcmp( lvl, "*" )) {
		memset( DbgLevels, 1, sizeof(DbgLevels));
	}
	else {
		while( *lvl )	DbgLevels[(int)*lvl] = 1;
	}
}
/*------------------------------------------------------------------------------
	CREATEDIRECTORYS-
Linux!jef 2007/01/23 23:08:26
------------------------------------------------------------------------------*/

void CreateDirectorys()
{
	char * tmpDir = ConfigGetString( KEY_TEMP, "/tmp" );
	char * isoDir = ConfigGetString( KEY_ISODIR, "/tmp" );

	MakeDirIfNeeded( tmpDir );
	MakeDirIfNeeded( isoDir );
}
/*------------------------------------------------------------------------------
	CONFIGSETSIZEPOSMAIN-
Linux!jef 2007/01/30 22:35:35
------------------------------------------------------------------------------*/

void ConfigSetSizePosMain( GtkWidget * mainWindow )
{
	int sx,sy, x, y;

	sx = ConfigGetInt( KEY_MAIN_SX, -1 );
	sy = ConfigGetInt( KEY_MAIN_SY, -1 );
	x = ConfigGetInt( KEY_MAIN_PX, -1 );
	y = ConfigGetInt( KEY_MAIN_PY, -1 );

	if((x > 0) && (y > 0))		gtk_window_move( GTK_WINDOW( mainWindow ), x, y);
	if((sx > 0) && (sy > 0))	gtk_window_resize( GTK_WINDOW( mainWindow), sx, sy);
	if( ConfigGetInt( KEY_MAIN_MAX, -1 ) == 1 )
		gtk_window_maximize( GTK_WINDOW( mainWindow ));
}
/*------------------------------------------------------------------------------
	CONFIGRECORDSIZEPOSMAIN-
Linux!jef 2007/01/30 22:45:01
------------------------------------------------------------------------------*/

void ConfigRecordSizePosMain( GtkWidget * mainWindow )
{
	int x,y,sx,sy;

	gtk_window_get_size( GTK_WINDOW( mainWindow), &sx, &sy);
	gtk_window_get_position( GTK_WINDOW( mainWindow ), &x, &y);

// fprintf(stderr,"sx=%d sy=%d x=%d y= %d\n", sx, sy, x, y );
	SetConfigInt( KEY_MAIN_SX, sx );
	SetConfigInt( KEY_MAIN_SY, sy );
	SetConfigInt( KEY_MAIN_PX, x );
	SetConfigInt( KEY_MAIN_PY, y );
}

