/*
 * setchar for real font (non-virtual font)
 */

#include	"defs.h"
#include	"commands.h"
#include	"dconv.h"
#include	"global.h"
#include	"set.h"

void
realf_setchar(c, Move)
int c;
BOOLEAN Move;
{
    int cw;
    DEV_FONT devf;

    devf = DEV_fontdict(curfontent, c);

    if (devf != DEV_NULLFONT) {	/* ignore missing fonts */
	chmove = Move;
	dev_setfont(devf);
	dev_setposn(h, v);
	cw = DEV_setchar(c);
	if (Move)
	    *move += cw;
    } else
	dev_setposn(h, v);

#ifdef STATS
    Stnc += 1;
    curfontent->ncts += 1;
#endif
}

#define	STRLEN		256
void
realf_setstring(firstch)	/* read and set a consecutive string of chars */
int firstch;
{
    char s[STRLEN];
    char *sp;
    int c, len;
    DEV_FONT devf;

    /* read entire string of chars */
    /* ensure that all characters are loaded, */
    devf = DEV_fontdict(curfontent, firstch);
    for (c = firstch, sp = s, len = 0;
	 c >= SETC_000 && c <= SETC_127 && len < STRLEN; len++) {
	if (devf != DEV_fontdict(curfontent, c))
	    break;
	*sp++ = c;
	c = DC_getcommand();
    }
    DC_backupone();

    /* NULL's are valid chars, so cant use for string termination */
    if (devf != DEV_NULLFONT) {	/* ignore missing fonts */
	chmove = TRUE;
	dev_setfont(devf);
	dev_setposn(h, v);
	*move += DEV_setstring(s, len);
    } else
	dev_setposn(h, v);

#ifdef STATS
    Stnc += len;
    curfontent->ncts += len;
#endif
}
