% Usage:
%       out = test1_f(params, y)
%   where
%       out    is a (6,1) column vector of the residuals
%              of the static system
%       params is a (8,1) vector of parameter values
%              in the ordering as declared
%       y      is a (6,1) vector of endogenous variables
%              in the ordering as declared
%
% Created by Dynare++ v. 4.3.0

% params ordering
% =====================
% beta
% rho
% alpha
% delta
% theta
% psi
% tau
% phi
%
% y ordering
% =====================
% y
% c
% k
% a
% h
% b

function out = test1_f(params, y)
if size(y) ~= [6,1]
	error('Wrong size of y, must be [6,1]');
end
if size(params) ~= [8,1]
	error('Wrong size of params, must be [8,1]');
end

% hardwired constants
a0 =            0;
a1 =            1;
a2 = NaN;
a3 =    1.1283792;
% numerical constants
a8 =            1;
% parameter values
a19 = params(1); % beta
a51 = params(2); % rho
a13 = params(3); % alpha
a31 = params(4); % delta
a5 = params(5); % theta
a9 = params(6); % psi
a54 = params(7); % tau
% phi not used in the model
% exogenous variables to zeros
a58 = 0.0; % e
a64 = 0.0; % u
% endogenous variables to y
a15 = y(1); % y
a29 = y(1); % y
a4 = y(2); % c
a25 = y(2); % c
a40 = y(3); % k
a18 = y(3); % k
a52 = y(4); % a
a38 = y(4); % a
a7 = y(5); % h
a55 = y(6); % b
a20 = y(6); % b
a23 = y(6); % b

t6 = a4 * a5;
t10 = a8 + a9;
t11 = a7 ^ t10;
t12 = t6 * t11;
t14 = a8 - a13;
t16 = t14 * a15;
t17 = t12 - t16;
t21 = exp(a20);
t22 = a4 * t21;
t24 = exp(a23);
t26 = t24 * a25;
t27 = t22 / t26;
t28 = a13 * t24;
t30 = t28 * a29;
t32 = a8 - a31;
t33 = a18 * t32;
t34 = t30 + t33;
t35 = t27 * t34;
t36 = a19 * t35;
t37 = a18 - t36;
t39 = exp(a38);
t41 = a40 ^ a13;
t42 = t39 * t41;
t43 = a7 ^ t14;
t44 = t42 * t43;
t45 = a15 - t44;
t46 = a15 - a4;
t47 = t21 * t46;
t48 = t32 * a40;
t49 = t47 + t48;
t50 = a18 - t49;
t53 = a51 * a52;
t56 = a54 * a55;
t57 = t53 + t56;
t59 = t57 + a58;
t60 = a38 - t59;
t61 = a52 * a54;
t62 = a51 * a55;
t63 = t61 + t62;
t65 = t63 + a64;
t66 = a20 - t65;
% setting the output variable
out = zeros(6, 1);
out(1) = t17;
out(2) = t37;
out(3) = t45;
out(4) = t50;
out(5) = t60;
out(6) = t66;
