/*********************************************************************************/
/* $Id: AdiUsbAdslDriver.h,v 1.5 2003/06/03 22:59:10 sleeper Exp $         */
/*										 */
/* Copyright (c) 2002, Analog Devices Inc., All Rights Reserved			 */
/*										 */
/* AdiUsbAdslDriver.h								 */
/*										 */
/* IOCtl related definitions to be shared with user mode code			 */
/*										 */
/* This file is part of the "ADI USB ADSL Driver for Linux".   			 */
/*   										 */
/* "ADI USB ADSL Driver for Linux" is free software; you can redistribute it     */
/* and/or modify it under the terms of the GNU General Public License as         */
/* published by the Free Software Foundation; either version 2 of the License,   */
/* or (at your option) any later version.   					 */
/*   										 */
/* "ADI USB ADSL Driver for Linux" is distributed in the hope that it will be    */
/* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   		 */
/* GNU General Public License for more details.   				 */
/*   										 */
/* You should have received a copy of the GNU General Public License  	         */
/* along with "ADI USB ADSL Driver for Linux"; if not, write to the Free Software*/
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA     */
/*********************************************************************************/

#ifndef ADIUSBADSLDRIVER_H
#define ADIUSBADSLDRIVER_H

/* IOCTL data structure */
struct adi_ioctl_info
{
    uint32_t IDMAStart;
    uint32_t BufferSize;
    uint8_t  *pBuffer;
};

/* IOCTL IDs */
/* #define ADIUSBADSLFIRMWARE _IOW('U', 100, struct adi_ioctl_info) */
#define ADIUSBADSLOPTIONS  _IOW('U', 101, struct adi_ioctl_info)
#define ADIUSBADSLDSP      _IOW('U', 102, struct adi_ioctl_info)
#define ADIUSBADSLGETITF   _IOWR('U', 103, struct adi_ioctl_info)
#define ADIUSBADSLSYNC     _IO('U', 104)
#define ADIUSBADSLGETDBG   _IOWR('U', 105, struct adi_ioctl_info)
#define ADIUSBADSLSETDBG   _IOWR('U', 106, struct adi_ioctl_info)
#define ADIUSBADSLCMVS     _IOW('U', 107, struct adi_ioctl_info)

/* Options structure */
#define MAX_OPTION_NAME_LENGTH      64
typedef struct
{
	char	 Name[MAX_OPTION_NAME_LENGTH];
	uint32_t Value;
} DriverOption;

enum
{
    ConfigOptn0 = 0,
    ConfigOptn2,
    ConfigOptn3,
    ConfigOptn4,
    ConfigOptn5,
    ConfigOptn6,
    ConfigOptn7,
    ConfigOptn15,
    ConfigVPI,
    ConfigVCI,
    ConfigEncapsulation,
    ConfigLinetype,
    ConfigRatePollFreq,
    ConfigOptionCount
};

#define NUM_DRV_OPTIONS ConfigOptionCount
typedef DriverOption DriverOptions[NUM_DRV_OPTIONS];


/* Sagem USB IDs */
#define kEAGLE_VID              0x1110
#define kEAGLEI_PID_PREFIRMWARE 0x9010 /* Eagle I */
#define kEAGLEI_PID_PSTFIRMWARE 0x900F

#define kEAGLEIIC_PID_PREFIRMWARE 0x9024 /* Eagle II */
#define kEAGLEIIC_PID_PSTFIRMWARE 0x9023

#define kEAGLEII_PID_PREFIRMWARE 0x9022 /* Eagle II */
#define kEAGLEII_PID_PSTFIRMWARE 0x9021 /* Eagle II */


/* USR USB IDs */
#define kUSR_VID		0x0BAF
#define kMILLER_A_PID_PREFIRMWARE	0x00F2
#define kMILLER_A_PID_PSTFIRMWARE	0x00F1
#define kMILLER_B_PID_PREFIRMWARE	0x00FA
#define kMILLER_B_PID_PSTFIRMWARE	0x00F9
#define kHEINEKEN_A_PID_PREFIRMWARE	0x00F6
#define kHEINEKEN_A_PID_PSTFIRMWARE	0x00F5
#define kHEINEKEN_B_PID_PREFIRMWARE	0x00F8
#define kHEINEKEN_B_PID_PSTFIRMWARE	0x00F7

#ifdef __KERNEL__

#define kCASE_PREFIRMWARE	kEAGLEI_PID_PREFIRMWARE:    \
    case kMILLER_A_PID_PREFIRMWARE:                     \
    case kMILLER_B_PID_PREFIRMWARE:                     \
    case kHEINEKEN_A_PID_PREFIRMWARE:                   \
    case kHEINEKEN_B_PID_PREFIRMWARE:                   \
    case kEAGLEIIC_PID_PREFIRMWARE:                     \
    case kEAGLEII_PID_PREFIRMWARE


#define kCASE_POSTFIRMWARE	kEAGLEI_PID_PSTFIRMWARE:    \
    case kMILLER_A_PID_PSTFIRMWARE:                     \
    case kMILLER_B_PID_PSTFIRMWARE:                     \
    case kHEINEKEN_A_PID_PSTFIRMWARE:                   \
    case kHEINEKEN_B_PID_PSTFIRMWARE:                   \
    case kEAGLEII_PID_PSTFIRMWARE:                      \
    case kEAGLEIIC_PID_PSTFIRMWARE

#define ISPREFIRMWARE(c)	(kEAGLEI_PID_PREFIRMWARE == (c) ||                                       \
                             kMILLER_A_PID_PREFIRMWARE == (c) || kMILLER_B_PID_PREFIRMWARE == (c) ||     \
                             kHEINEKEN_A_PID_PREFIRMWARE == (c) || kHEINEKEN_B_PID_PREFIRMWARE == (c) || \
                             kEAGLEII_PID_PREFIRMWARE == (c) || kEAGLEIIC_PID_PREFIRMWARE == (c)         \
                            )

#define ISPOSTFIRMWARE(c)	(kEAGLEI_PID_PSTFIRMWARE == (c) ||                                      \
                             kMILLER_A_PID_PSTFIRMWARE == (c) || kMILLER_B_PID_PSTFIRMWARE == (c) ||    \
                             kHEINEKEN_A_PID_PSTFIRMWARE == (c) || kHEINEKEN_B_PID_PSTFIRMWARE == (c) ||\
                             kEAGLEII_PID_PSTFIRMWARE == (c) || kEAGLEIIC_PID_PSTFIRMWARE == (c)        \
                            )

#define IS_EAGLE_I(c)      (kEAGLEI_PID_PREFIRMWARE == (c) ||                                           \
                             kMILLER_A_PID_PREFIRMWARE == (c) || kMILLER_B_PID_PREFIRMWARE == (c) ||    \
                            kHEINEKEN_A_PID_PREFIRMWARE == (c) || kHEINEKEN_B_PID_PREFIRMWARE == (c))

#endif /* __KERNEL__ */


#endif /* ADIUSBADSLDRIVER */

/***************************************************
$Log: AdiUsbAdslDriver.h,v $
Revision 1.5  2003/06/03 22:59:10  sleeper
Add support for eagle II and IIc

Revision 1.4  2003/02/24 23:53:05  sleeper
Fix a comment bug

Revision 1.3  2003/02/24 23:50:29  sleeper
Fix a comment bug

Revision 1.2  2003/02/21 21:51:45  sleeper
Add Renaud Guerin(rguerin@freebox.fr) support
 for multi-modem

Revision 1.1.1.1  2003/02/10 23:29:49  sleeper
Imported sources

Revision 1.70  2002/05/24 18:00:31  Anoosh Naderi
Clean upthe code.

Revision 1.6  2002/01/18 18:00:31  Chris
Added ADIUSBADSLOPTIONS ioctl.

Revision 1.5  2002/01/18 00:01:20  steve.urquhart
Upgraded adi_user to handle 2 ioctls

Revision 1.4  2002/01/17 19:26:39  steve.urquhart
Replaced missing newline at end of file
***************************************************/
