#!/usr/bin/env python
# Ear Candy - Pulseaduio sound managment tool
# Copyright (C) 2008 Jason Taylor
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import sys
import gtk

from earcandy.earcandyconfig import getdatapath

class EarCandyStatusIcon(gtk.StatusIcon):
    def __init__(self, core):
        gtk.StatusIcon.__init__(self)
        self.core = core
        
        menu = '''
            <ui>
             <menubar name="Menubar">
              <menu action="Menu">
               <separator/>
               <menuitem action="Preferences"/>
               <menuitem action="About"/>
               <separator/>
               <menuitem action="Exit"/>
              </menu>
             </menubar>
            </ui>
        '''
        actions = [
            ('Menu',  None, 'Menu'),
            ('Mute', "stock_volume-mute", '_Mute...', None, 'Mute sound', self.on_preferences),
            ('Lock', "stock_lock", '_Lock...', None, 'Lock volume levels', self.on_preferences),
            ('Preferences', gtk.STOCK_PREFERENCES, '_Preferences...', None, 'Edit Preferences', self.on_preferences),

            ('About', gtk.STOCK_ABOUT, '_About...', None, 'About Ear Candy', self.on_about),
            ('Exit', gtk.STOCK_STOP, '_Exit...', None, 'Exit Ear Candy', self.stop)]
        ag = gtk.ActionGroup('Actions')
        ag.add_actions(actions)
        self.manager = gtk.UIManager()
        self.manager.insert_action_group(ag, 0)
        self.manager.add_ui_from_string(menu)
        self.menu = self.manager.get_widget('/Menubar/Menu/About').props.parent
        #self.set_from_icon_name("audio-volume-medium")
        self.set_icon()
        self.set_tooltip('Ear Candy volume manager')
        self.set_visible(True)
        self.connect('activate', self.on_activate)
        self.connect('popup-menu', self.on_popup_menu)


    def on_activate(self, data):

        self.core.open_preferances()
            
    def on_preferences(self, widget):
        self.core.open_preferances()

    def on_reset(self, widget):
        self.core.reset()

    def on_popup_menu(self, status, button=None, time=0):
        self.menu.popup(None, None, None, button, time)

    def on_about(self, data):
        dialog = gtk.AboutDialog()
        dialog.set_name('Ear Candy')
        dialog.set_version(str(self.core.version))
        dialog.set_comments('An pulseaudio / X.org sound volume manager')
        dialog.set_website('https://launchpad.net/earcandy')
        dialog.run()
        dialog.destroy()
    
    def set_icon(self):
        self.set_from_file( os.path.join(getdatapath(), 'media', 'icon.png') )

    def stop(self, data=None):
        self.core.exit()
        
if __name__ == '__main__':
    ts = TrackerStatusIcon()
    ts.run()

