import wnck
import gobject
import logging
from earcandy.util.DesktopFiles import DesktopFiles
from Application import Application

log = logging.getLogger('WindowWatcher')
log.setLevel(logging.WARNING)

class Watcher():
    
    def __init__(self):
        self.screen = wnck.screen_get_default()
        self.screen.connect("active_window_changed", self.active_window_changed)
        self.screen.connect("window_opened", self.window_opened)

        self.desktop_files = DesktopFiles().read_all()
        self.current_window = None
        self.applications = {}

        self.callback = None

    def check_all(self):
        for win in self.screen.get_windows():
            self.update("exists", win) 

    def get_command(self, pid):
        command = str(pid)
        try:
            # Try and get command from PID
            f = open("/proc/%s/cmdline" % pid, "r")
            command = f.readline()[:-1]
            f.close()
        except:
            pass
        return command

    def window_opened(self, screen, win):
        if win and win.get_window_type() != wnck.WINDOW_DOCK: # ignore docks
           
            app = win.get_application ()
            app_name = app.get_name()
            
            pid = win.get_pid()
            command = self.get_command(pid)
            category = ""

            if not self.applications.has_key(command):
                a = Application(pid, command, app_name, self.desktop_files, win.get_icon ())
                self.applications[command] = a
            
            log.debug("WW :: window opened : %s" % app_name)
            self.update("open", win)
            #win.connect("geometry-changed", self.geometry_changed)
           
    def active_window_changed(self, screen, old_window):
        #print screen
        win = screen.get_active_window ()
        if win:
            log.debug("WW :: active window changed : %s" % win.get_name())
            self.update("active", win)    
    

    def update(self, state, win):
        if win and win.get_window_type() != wnck.WINDOW_DOCK: # ignore docks
                
            #try:
                app = win.get_application ()
                app_name = app.get_name()
                pid = win.get_pid()

                command = self.get_command(pid)

                application = None
                application = self.applications[command]
                application.pid = pid

                geom = win.get_geometry()
                x = float(geom[1])
                y = float(geom[0])
                w = float(geom[2])
                h = float(geom[3])

                if win.get_name():
                    application.window_name =  win.get_name()

                #application.x = x+h/2
                #application.y = y+w/2
                #application.fullscreen = win.is_fullscreen () or win.is_maximized ()
                #application.icon = win.get_icon ()
                log.debug("WW :: application : %s" % application.description)
                
                if self.callback:
                    gobject.idle_add(self.callback, application, state)
            #except:
            #    print "error reading window", win

    def geometry_changed(self, win):
        self.update("geo", win)


if __name__ == '__main__':
    logging.basicConfig(level=log.debug)
    import gtk
    # Turn on gtk threading
    gtk.gdk.threads_init()
    ww = Watcher()
    gtk.main()

