%define    name      easytag
%define    version   1.99.6
%define    release   1
%define    prefix    /usr

Summary:       Tag editor for MP3 and Ogg Vorbis files.
Summary(fr):   Editeur de tags pour fichiers MP3 et Vorbis Ogg.
Name:          %name
Version:       %version
Release:       %release
Copyright:     GPL
URL:           http://easytag.sourceforge.net
Group:         Applications/Multimedia
Source:        http://prdownloads.sourceforge.net/easytag/%{name}-%{version}.tar.bz2
BuildRoot:     /var/tmp/%name-buildroot
Vendor:        Jerome Couderc <easytag@gmail.com>
Distribution:  Any
Packager:      Jerome Couderc <easytag@gmail.com>
Requires:      gtk2      >= 2.4.0
Requires:      id3lib    >= 3.7.12
Requires:      libogg    >= 1.0
Requires:      libvorbis >= 1.0
Requires:      flac      >= 1.1.0
BuildRequires: gtk2-devel      >= 2.4.0
BuildRequires: id3lib-devel    >= 3.7.12
BuildRequires: libogg-devel    >= 1.0
BuildRequires: libvorbis-devel >= 1.0
BuildRequires: flac-devel      >= 1.1.0
Prefix:        %prefix

%description
EasyTAG is an utility for viewing and editing tags for MP3, MP2, FLAC, Ogg Vorbis,
MusePack and Monkey's Audio files. Its simple and nice GTK+ interface makes
tagging easier under GNU/Linux.

Features:
  o View, edit, write tags of MP3, MP2 files (ID3 tag with pictures), FLAC files
    (FLAC Vorbis tag), Ogg Vorbis files (Ogg Vorbis tag), and MusePack, Monkey's
    Audio files (APE tag),
  o Can edit more tag fields : Title, Artist, Album, Disc Album, Year, Track
    Number, Genre, Comment, Composer, Original Artist/Performer, Copyright, URL
    and Encoder name,
  o Auto tagging: parse filename and directory to complete automatically the
    fields (using masks),
  o Ability to rename files and directories from the tag (using masks) or by
    loading a text file,
  o Process selected files of the selected directory,
  o Ability to browse subdirectories,
  o Recursion for tagging, removing, renaming, saving...,
  o Can set a field (artist, title,...) to all other files,
  o Read file header informations (bitrate, time, ...) and display them,
  o Auto completion of the date if a partial is entered,
  o Undo and redo last changes,
  o Ability to process fields of tag and file name (convert letters into
    uppercase, downcase, ...),
  o Ability to open a directory or a file with an external program,
  o CDDB support using Freedb.org servers (manual and automatic search),
  o A tree based browser or a view by Artist & Album,
  o A list to select files,
  o A playlist generator window,
  o A file searching window,
  o Simple and explicit interface!,
  o French, German, Russian, Dutch, Hungarian, Swedish, Italian, Japanese,
    Ukrainian, Czech, Spanish, Polish, Romanian, Danish, Greek and Brazilian
    Portuguese translation languages,
  o Written in C and uses GTK+ 2.4 for the GUI.

%prep
%setup

%build
./configure --prefix=%{prefix}
make

%install
rm -rf ${RPM_BUILD_ROOT}
make prefix=${RPM_BUILD_ROOT}%{prefix} install

%post

%postun

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-, root, root)
%doc ChangeLog INSTALL COPYING README TODO THANKS USERS-GUIDE
%prefix/bin/easytag
%prefix/share/applications/easytag.desktop
%prefix/share/pixmaps/*
%prefix/man/*/easytag.*
%prefix/share/easytag/*
%prefix/share/locale/*/*/*


%changelog
* Wed Sep 17 2004 Jerome Couderc <j.couderc@ifrance.com>
  - Updated (Build)Requires entries for gtk+ 2.4.0

* Sun Jan 4 2004 Jerome Couderc <j.couderc@ifrance.com>
  - Updated (Build)Requires entries for FLAC support

* Tue Dec 16 2003 Jerome Couderc <j.couderc@ifrance.com>
  - Updated for the file easytag.desktop

* Mon Dec 31 2002 Jerome Couderc <j.couderc@ifrance.com>
  - Added man page

* Fri Aug 9 2002 Jerome Couderc <j.couderc@ifrance.com>
  - Added swith --disable-flac in the build section

* Thu Dec 18 2001 Jerome Couderc <j.couderc@ifrance.com>
  - Updated for (Build)Requires entries

* Thu Sep 22 2001 Jerome Couderc <j.couderc@ifrance.com>
  - Updated for /etc/X11/applnk/Multimedia/easytag.desktop

* Thu Sep 20 2001 Gtz Waschk <waschk@linux-mandrake.com> 0.15.1-1
  - Updated for autoconf

* Fri Jun 2 2000 Jerome Couderc <j.couderc@ifrance.com>
  - Updated to include po files into the rpm package

* Fri May 5 2000 Jerome Couderc <j.couderc@ifrance.com>
  - Initial spec file.
