/* about.c - 2000/05/05 */
/*
 *  EasyTAG - Tag editor for MP3 and Ogg Vorbis files
 *  Copyright (C) 2000-2003  Jerome Couderc <easytag@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <string.h>
#include <id3.h>
#include <errno.h>

#include "about.h"
#include "easytag.h"
#include "misc.h"
#include "msgbox.h"
#include "charset.h"

#ifndef PACKAGE_DATA_DIR
#    include "../pixmaps/EasyTAG_logo.xpm"
#endif


/****************
 * Declarations *
 ****************/
static GtkWidget *AboutWindow = NULL;


/**************
 * Prototypes *
 **************/
void About_Window_Key_Press (GtkWidget *window, GdkEvent *event);
void Quit_About_Window (void);
void About_Window_Go_To_Home_Page (void);



/*************
 * Functions *
 *************/
/*
 * Close the window when the 'escape' key is pressed.
 */
void About_Window_Key_Press (GtkWidget *window ATTRIBUTE_UNUSED, GdkEvent *event)
{
    GdkEventKey *kevent;

    if (event && event->type == GDK_KEY_PRESS)
    {
        kevent = (GdkEventKey *)event;
        switch(kevent->keyval)
        {
            case GDK_Escape:    
                Quit_About_Window();
                break;
        }
    }
}


void Quit_About_Window (void)
{
    if (AboutWindow)
    {
        gtk_widget_destroy(AboutWindow);
        AboutWindow = (GtkWidget *)NULL;
        /*gtk_widget_set_sensitive(MainWindow,TRUE);*/
    }
}

void Show_About_Window (void)
{
    GtkWidget *AboutNoteBook;
    GtkWidget *Label;
    GtkWidget *Frame;
    GtkWidget *VBox, *hbox;
    GtkWidget *ScrollWindow;
    GtkWidget *TextView;
    GtkTextBuffer *TextBuffer;
    GtkWidget *Button;
    GtkWidget *Logo;
    GdkPixmap *pixmap;
    GdkBitmap *mask;
    gchar temp[MAX_STRING_LEN];
    FILE *file;
    gint i;
    gchar *temp_str;
    gchar *tmp = NULL;
    gchar *description_text = 
            _(""
            "    EasyTAG is an utility for viewing and editing tags for MP3, MP2, "
            "FLAC, Ogg Vorbis, MusePack and Monkey's Audio files. Its simple and "
            "nice GTK+ interface makes tagging easier under GNU/Linux."
            "");


    /* Translation contributions */
    gchar *translations_thanks_text [][2]= {
            {"    - Bastian Kleineidam ",           _("(German translation)")},
            {"    - Adrian Bunk ",                  _("(German translation)")},
            {"    - Colin Marquardt ",              _("(German translation)")},
            {"    - Philipp Thomas ",               _("(German translation)")},
            {"    - Sergey Zhumatiy ",              _("(Russian translation)")},
            {"    - Andrey Astafiev ",              _("(Russian translation)")},
            {"    - Vincent van Adrighem ",         _("(Dutch translation)")},
            {"    - Bjrn Olievier ",               _("(Dutch translation)")},
            {"    - Patrik Israelsson ",            _("(Swedish translation)")},
            {"    - Szel Miklos ",                  _("(Hungarian translation)")},
            {"    - Nagy Boldizsar ",               _("(Hungarian translation)")},
            {"    - Cappelletti Lorenzo ",          _("(Italian translation)")},
            {"    - Costantino ",                   _("(Italian translation)")},
            {"    - Takeshi Aihana ",               _("(Japanese translation)")},
            {"    - Olexander Kunytsa ",            _("(Ukrainian translation)")},
            {"    - Cawko Xakep ",                  _("(Ukrainian translation)")},
            {"    - Milan Siebenburger ",           _("(Czech translation)")},
            {"    - Zbynek Mrkvicka ",              _("(Czech translation)")},
            {"    - Jaime Serrano Cartagena ",      _("(Spanish translation)")},
            {"    - Fernando M. Bueno Moreno ",     _("(Spanish translation)")},
            {"    - Francisco Javier F. Serrador ", _("(Spanish translation)")},
            {"    - Maciej Kasprzyk ",              _("(Polish translation)")},
            {"    - Pauliuc George ",               _("(Romanian translation)")},
            {"    - Morten Brix Pedersen ",         _("(Danish translation)")},
            {"    - Apollon Oikonomopoulos ",       _("(Greek translation)")},
            {"    - doutor zero ",                  _("(Brazilian Portuguese translation)")},
            {NULL,NULL}
            };

    /* General contributions */
    gchar *general_thanks_text = 
            "    - Daniel Drake (GTK2 port)\n"
            "    - Mihael Vrbanec (GTK2 port)\n"
            "    - Andrew Shuvalov\n"
            "    - Sergey Zhumatiy\n"
            "    - Kevin Venkiteswaran\n"
            "    - Sheikholeslami Navid\n"
            "    - Marcus Tegel\n"
            "    - Robert\n"
            "    - Lars Bohn\n"
            "    - Patrik Israelsson\n"
            "    - Adrian Bunk\n"
            "    - Alexander D Harkness\n"
            "    - Vaclav Slavik\n"
            "    - Charles Kerr\n"
            "    - Gian\n"
            "    - Thomas Zajic\n"
            "    - Szel Miklos\n"
            "    - Tore Aursand\n"
            "    - Cappelletti Lorenzo\n"
            "    - Colin Marquardt\n"
            "    - Goetz Waschk\n"
            "    - Holger Schemel\n"
            "    - Artur Polaczynski\n"
            "    - Maciej Kasprzyk\n"
            "    - Daniel Pichler\n"
            "    - Philipp Thomas\n"
            "    - Tony Mancill\n"
            "    - Pavel Minayev\n"
            "    - Justus Schwartz\n"
            "    - Fredrik Noring\n"
            "    - Guilherme Destefani\n"
            "";


    /* Check if already opened */
    if (AboutWindow)
    {
        gdk_window_raise(AboutWindow->window);
        return;
    }

    /* Dialog window */
    AboutWindow = gtk_dialog_new();

    /* Config */
    gtk_window_set_title(GTK_WINDOW(AboutWindow),_("About..."));
    gtk_window_set_position(GTK_WINDOW(AboutWindow),GTK_WIN_POS_CENTER);

    /* Signals connection */
    g_signal_connect(G_OBJECT(AboutWindow),"destroy", G_CALLBACK(Quit_About_Window),NULL);
    g_signal_connect(G_OBJECT(AboutWindow),"delete_event",G_CALLBACK(Quit_About_Window),NULL);
    g_signal_connect(G_OBJECT(AboutWindow),"key_press_event", G_CALLBACK(About_Window_Key_Press),NULL);

     /* The NoteBook */
    AboutNoteBook = gtk_notebook_new();
    gtk_notebook_popup_enable(GTK_NOTEBOOK(AboutNoteBook));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(AboutWindow)->vbox),AboutNoteBook,TRUE,TRUE,0);

    /*
     * Tab for common informations
     */
    Label = gtk_label_new(_("About"));
    Frame = gtk_frame_new(NULL);
    gtk_notebook_append_page (GTK_NOTEBOOK(AboutNoteBook),Frame,Label);
    gtk_container_set_border_width(GTK_CONTAINER(Frame), 2);

    VBox = gtk_vbox_new(FALSE,0);
    gtk_container_add(GTK_CONTAINER(Frame),VBox);

    /* EasyTAG Logo */
    gtk_widget_realize(AboutWindow);

#ifdef PACKAGE_DATA_DIR
    pixmap = gdk_pixmap_create_from_xpm(AboutWindow->window,&mask,NULL,PACKAGE_DATA_DIR"/EasyTAG_logo.xpm");
#else
    pixmap = gdk_pixmap_create_from_xpm_d(AboutWindow->window,&mask,NULL,EasyTAG_logo_xpm);
#endif

    if (pixmap)
    {
        Logo = gtk_image_new_from_pixmap(pixmap, mask);
        g_object_unref(pixmap);
        g_object_unref(mask);
        gtk_box_pack_start(GTK_BOX(VBox),Logo,FALSE,TRUE,0);
        gtk_misc_set_padding(GTK_MISC(Logo),2,2);
    }

    /* Infos */
    Label = gtk_label_new(APPNAME" "VERSION);
    gtk_box_pack_start(GTK_BOX(VBox),Label,FALSE,TRUE,0);

    sprintf(temp,_("(compiled: %s)"),__DATE__);
    Label = gtk_label_new(temp);
    gtk_box_pack_start(GTK_BOX(VBox),Label,FALSE,TRUE,0);

    sprintf(temp,_("(using: GTK+ %d.%d.%d and id3lib %d.%d.%d)"),GTK_MAJOR_VERSION,GTK_MINOR_VERSION,
        GTK_MICRO_VERSION,ID3LIB_MAJOR_VERSION,ID3LIB_MINOR_VERSION,ID3LIB_PATCH_VERSION);
    Label = gtk_label_new(temp);
    gtk_box_pack_start(GTK_BOX(VBox),Label,FALSE,TRUE,0);

#ifndef ENABLE_OGG
    Label = gtk_label_new(_("(Ogg Vorbis file support disabled)"));
    gtk_box_pack_start(GTK_BOX(VBox),Label,FALSE,TRUE,0);
#endif

#ifndef ENABLE_FLAC
    Label = gtk_label_new(_("(FLAC file support disabled)"));
    gtk_box_pack_start(GTK_BOX(VBox),Label,FALSE,TRUE,0);
#endif

    /* Insert a blank line */
    Label = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(VBox),Label,FALSE,TRUE,0);

    sprintf(temp,_("Author: %s"),AUTHOR);
    Label = gtk_label_new(temp);
    gtk_box_pack_start(GTK_BOX(VBox),Label,FALSE,TRUE,0);

    sprintf(temp,_("E-mail: %s"),EMAIL);
    Label = gtk_label_new(temp);
    gtk_box_pack_start(GTK_BOX(VBox),Label,FALSE,TRUE,0);

    hbox = gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(VBox),hbox,FALSE,TRUE,0);
    Label = gtk_label_new(_("Web Page: "));
    gtk_misc_set_alignment(GTK_MISC(Label),1,0.5);
    gtk_box_pack_start(GTK_BOX(hbox),Label,TRUE,TRUE,0);
    Button = gtk_button_new_with_label(WEBPAGE);
    gtk_box_pack_start(GTK_BOX(hbox),Button,TRUE,TRUE,0);
    g_signal_connect(G_OBJECT(Button),"clicked", G_CALLBACK(About_Window_Go_To_Home_Page),NULL);
    gtk_button_set_relief(GTK_BUTTON(Button),GTK_RELIEF_NONE);

    /* Insert a blank line */
    Label = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(VBox),Label,TRUE,TRUE,0);

    Frame = gtk_frame_new(_("Description:"));
    gtk_frame_set_shadow_type(GTK_FRAME(Frame),GTK_SHADOW_IN);
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,TRUE,0);
    gtk_container_set_border_width(GTK_CONTAINER(Frame), 2);

    Label = gtk_label_new(_(description_text));
    gtk_misc_set_padding(GTK_MISC(Label),2,2);
    gtk_label_set_line_wrap(GTK_LABEL(Label),TRUE);
    gtk_container_add(GTK_CONTAINER(Frame),Label);

    /*
     * Tab for thanks
     */
    Label = gtk_label_new(_("Thanks"));
    Frame = gtk_frame_new(NULL);
    gtk_notebook_append_page (GTK_NOTEBOOK(AboutNoteBook),Frame,Label);

    ScrollWindow = gtk_scrolled_window_new(NULL,NULL);
    gtk_container_add(GTK_CONTAINER(Frame),ScrollWindow);
    gtk_container_set_border_width(GTK_CONTAINER(Frame),2);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrollWindow),
                                   GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);

    TextBuffer = gtk_text_buffer_new(NULL);
    temp_str = _("Translations:\n");
    gtk_text_buffer_insert_at_cursor(TextBuffer, temp_str, g_utf8_strlen(temp_str, -1));
    for (i=0; translations_thanks_text[i][0]!=NULL; i++)
    {
        temp_str = g_strconcat(translations_thanks_text[i][0],translations_thanks_text[i][1],NULL);
        if (!g_utf8_validate(temp_str, -1, NULL))
        {
            tmp = convert_string(temp_str, "iso-8859-1", "utf-8");
            g_free(temp_str);
            temp_str = tmp;
        }
        gtk_text_buffer_insert_at_cursor(TextBuffer, temp_str, -1);
        gtk_text_buffer_insert_at_cursor(TextBuffer, "\r\n", -1);
        g_free(temp_str);
    }

    gtk_text_buffer_insert_at_cursor(TextBuffer, "\n", 1);

    temp_str = _("General:\n");
    gtk_text_buffer_insert_at_cursor(TextBuffer, temp_str, g_utf8_strlen(temp_str, -1));
    gtk_text_buffer_insert_at_cursor(TextBuffer, "\r\n", -1);
    gtk_text_buffer_insert_at_cursor(TextBuffer, general_thanks_text, g_utf8_strlen(general_thanks_text, -1));
    TextView = gtk_text_view_new_with_buffer(TextBuffer);
    gtk_container_add(GTK_CONTAINER(ScrollWindow),TextView);
    gtk_text_view_set_editable(GTK_TEXT_VIEW(TextView), FALSE);
    gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(TextView), GTK_WRAP_WORD);


    /*
     * Tab for ChangeLog
     */

#ifdef PACKAGE_DATA_DIR
    Label = gtk_label_new(_("Changes"));
    Frame = gtk_frame_new(NULL);
    gtk_notebook_append_page (GTK_NOTEBOOK(AboutNoteBook),Frame,Label);

    ScrollWindow = gtk_scrolled_window_new(NULL,NULL);
    gtk_container_add(GTK_CONTAINER(Frame),ScrollWindow);
    gtk_container_set_border_width(GTK_CONTAINER(Frame),2);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrollWindow),
                                   GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);

    TextBuffer = gtk_text_buffer_new(NULL);
    // The file 'ChangeLog' to read
    if ( (file=fopen(PACKAGE_DATA_DIR"/ChangeLog","r"))==0 )
    {
        gchar *msg = g_strdup_printf(_("Can't open file '%s' (%s)\n"),PACKAGE_DATA_DIR"/ChangeLog",g_strerror(errno));
        gtk_text_buffer_insert_at_cursor(TextBuffer, msg, g_utf8_strlen(msg, -1));
        g_free(msg);
    } else 
    {
        while(fgets(temp,sizeof(temp),file))
        {
            if (temp[strlen(temp)-1]=='\n')
                temp[strlen(temp)-1]='\0';
            if (temp[strlen(temp)-1]=='\r')
                temp[strlen(temp)-1]='\0';
            // don't use font yet....
            if (!g_utf8_validate(temp, -1, NULL))
                tmp = convert_string(temp, "iso-8859-1", "utf-8");
            else
                tmp = g_strdup(temp);

            gtk_text_buffer_insert_at_cursor(TextBuffer, tmp, -1);
            gtk_text_buffer_insert_at_cursor(TextBuffer, "\r\n", -1);
            g_free(tmp);
        }
        fclose(file);
    }
    TextView = gtk_text_view_new_with_buffer(TextBuffer);
    gtk_container_add(GTK_CONTAINER(ScrollWindow),TextView);
    gtk_text_view_set_editable(GTK_TEXT_VIEW(TextView), FALSE);
    gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(TextView), GTK_WRAP_WORD);
#endif


    /* 
     * Close Button
     */
    Button = Create_Button_With_Pixmap(BUTTON_CLOSE);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(AboutWindow)->action_area),Button,FALSE,FALSE,0);
    g_signal_connect(G_OBJECT(Button),"clicked", G_CALLBACK(Quit_About_Window),NULL);
    GTK_WIDGET_SET_FLAGS(Button,GTK_CAN_DEFAULT);
    gtk_widget_grab_default(Button);


    /* Disable main window */
    /*gtk_widget_set_sensitive(MainWindow,FALSE);*/

    gtk_widget_show_all(AboutWindow);
}


void About_Window_Go_To_Home_Page (void)
{
    system("gnome-moz-remote "WEBPAGE);
}
