// Autogenerated AST node
package org.python.pydev.parser.jython.ast;
import org.python.pydev.parser.jython.SimpleNode;
import java.io.DataOutputStream;
import java.io.IOException;

public class ImportFrom extends stmtType {
    public NameTokType module;
    public aliasType[] names;

    public ImportFrom(NameTokType module, aliasType[] names) {
        this.module = module;
        this.names = names;
    }

    public ImportFrom(NameTokType module, aliasType[] names, SimpleNode
    parent) {
        this(module, names);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ImportFrom[");
        sb.append("module=");
        sb.append(dumpThis(this.module));
        sb.append(", ");
        sb.append("names=");
        sb.append(dumpThis(this.names));
        sb.append("]");
        return sb.toString();
    }

    public void pickle(DataOutputStream ostream) throws IOException {
        pickleThis(23, ostream);
        pickleThis(this.module, ostream);
        pickleThis(this.names, ostream);
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitImportFrom(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        if (module != null)
            module.accept(visitor);
        if (names != null) {
            for (int i = 0; i < names.length; i++) {
                if (names[i] != null)
                    names[i].accept(visitor);
            }
        }
    }

}
