/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.exports.FeatureExportOperation;

public abstract class BaseExportTask
extends Task {
    protected String fDestination;
    protected String fZipFilename;
    protected boolean fToDirectory;
    protected boolean fUseJarFormat;
    protected boolean fExportSource;
    protected String fQualifier;

    public void execute() throws BuildException {
        if (this.fDestination == null) {
            throw new BuildException("No destination is specified");
        }
        if (!this.fToDirectory && this.fZipFilename == null) {
            throw new BuildException("No zip file is specified");
        }
        Job job = new Job(PDECoreMessages.BaseExportTask_pdeExport){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    BaseExportTask.this.getExportOperation().run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        if (this.isAntRunner()) {
            try {
                job.schedule();
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            job.schedule(2000L);
        }
    }

    public void setExportType(String type) {
        this.fToDirectory = !"zip".equals(type);
    }

    public void setUseJARFormat(String useJarFormat) {
        this.fUseJarFormat = "true".equals(useJarFormat);
    }

    public void setExportSource(String doExportSource) {
        this.fExportSource = "true".equals(doExportSource);
    }

    public void setDestination(String destination) {
        this.fDestination = destination;
    }

    public void setFilename(String filename) {
        this.fZipFilename = filename;
    }

    public void setQualifier(String qualifier) {
        this.fQualifier = qualifier;
    }

    public boolean isAntRunner() {
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-application")) {
                return args[i + 1].equals("org.eclipse.ant.core.antRunner");
            }
            ++i;
        }
        return false;
    }

    protected abstract FeatureExportOperation getExportOperation();
}

