#ifndef _ECS_CHAMP_ATT_H_
#define _ECS_CHAMP_ATT_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associes  la structure `ecs_champ_t' dcrivant un champ
 *   et propres aux champs auxiliaires de type "attribut"
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/

/*============================================================================
 *                                 Visibilit
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_famille_publ.h"
#include "ecs_descr_publ.h"
#include "ecs_param_perio_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui assemble un champ donn dans un champ rcepteur donn
 *
 *  Si les champs  assembler ont le mme nom, le nom donn au champ rcepteur
 *   sera ce mme nom, et on passera en argument NULL au nom  donner
 *  Sinon, on donnera en argument le nouveau nom du champ rcepteur
 *
 *  L'assemblage consiste  :
 *  - regrouper sous la mme position les valeurs des 2 champs
 *    (cela suppose donc que les 2 champs ont le mme nombre de positions)
 *  - assembler les membres des descripteurs des 2 champs
 *    Les descripteurs des 2 champs peuvent tre  `NULL'
 *    et si le descripteur du champ rcepteur est  `NULL',
 *          le descripteur du champ assembl est celui du champ  assembler
 *
 *  Le champ  assembler est dtruit apres assemblage
 *----------------------------------------------------------------------------*/

void ecs_champ_att__assemble
(
       ecs_champ_t    *const champ_recept,
       ecs_champ_t    *      champ_assemb,
 const char           *      nom
) ;


/*----------------------------------------------------------------------------
 *  Fonction ralisant l'hritage des valeurs d'un attribut d'un lment
 *   sur les sous-lments issus de sa dcomposition
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ_att__herite
(
 ecs_champ_t      *const champ_att_elt,
 ecs_champ_t      *const champ_elt_def_sselt,
 size_t                  nbr_sselt
) ;


/*----------------------------------------------------------------------------
 *  Fonction ralisant la transformation d'un champ
 *   en fusionnant les proprits de ses lments
 *   qui sont identiquement transformes par le vecteur de transformation donn
 *----------------------------------------------------------------------------*/

void ecs_champ_att__fusionne
(
       ecs_champ_t    *const this_champ_att,
       size_t                nbr_elt_new,
 const ecs_tab_int_t         vect_transf
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie la liste des numros de famille des lments
 *
 *  Pour les lments de famille 0 ou n'ayant pas de famille, on leur
 *   attribue le numro de famille par dfaut
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_champ_att__fam_elt
(
 ecs_champ_t    *const this_champ_fam,
 ecs_tab_int_t  *const tab_nbr_elt_fam
) ;


/*----------------------------------------------------------------------------
 * Fonction qui construit la liste des lments  portant des numros de
 *  familles marqus dans le tableau indic_famille
 *----------------------------------------------------------------------------*/

ecs_tab_int_t  ecs_champ_att__liste_elt_fam
(
       ecs_champ_t     *const champ_famille,
 const ecs_tab_int_t   *const liste_filtre,
 const ecs_tab_bool_t  *const indic_famille
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie un tableau donnant pour chaque valeur du champ
 *   le nombre d'lments ayant cette valeur
 *----------------------------------------------------------------------------*/

ecs_int_t * ecs_champ_att__ret_nbr_elt_val
(
 ecs_champ_t  *const champ_att,
 size_t              nbr_val_att
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit un nouveau champ attribut  partir
 *   d'un champ donn qui contient la dfinition d'lments
 *                                 en fonction de nouveaux lments
 *  L'attribut cre donne la rfrence de l'lment d'origine
 *   auquel est associe le nouvel lment
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ_att__filialise
(
 ecs_champ_t  *const champ_def,
 size_t              nbr_sselt
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui remplit un tableau de boolens
 *   Le boolen correspondant  un lment du champ est  `ECS_TRUE'
 *    si l'lment est slectionn par la description donne :
 *    - le numro du descripteur
 *    - le nom    du descripteur
 *----------------------------------------------------------------------------*/

ecs_int_t ecs_champ_att__cree_masque
(
       ecs_tab_bool_t  *const bool_elt_select,
 const ecs_tab_int_t   *const liste_filtre,
       ecs_champ_t     *const champ_select,
       int                    descr_ide,
 const char            *const descr_nom
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit les familles  partir
 *   de la liste chane de tous les champs de type "attribut"
 *   pour toutes des entits
 *
 *  Elle renvoie les champs "famille" par entit
 *
 *  Elle dtermine aussi :
 *   - la tte de la liste chane des familles
 *   - le nombre de familles
 *   - les nombres d'lments par famille et par entit
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ_att__construit_fam
(
 ecs_champ_t        *      champ_att_tete,
 ecs_famille_t    * *const vect_fam_tete,
 size_t                    nbr_elt_ent,
 int                       num_fam_deb,
 int                *const nbr_fam,
 ecs_int_t        * *const cpt_elt_fam
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui cre les champs "couleur" et "groupe"  partir
 *   du champ "famille" et de la liste chane des familles
 *----------------------------------------------------------------------------*/

void ecs_champ_att__cree_att_fam
(
 ecs_champ_t      *const champ_famille,
 ecs_famille_t    *const famille,
 ecs_champ_t    * *const champ_couleur,
 ecs_champ_t    * *const champ_groupe
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui met  jour la renumrotation
 *  "lments initiaux -> lments priodiques" en fonction d'un champ
 *  "lments prcdents -> nouveaux lments" en cas de modifications
 *  successives de la dfinition des lments.
 *  Valable pour les champs attributs de statut ECS_CHAMP_STATUT_REF_ELT
 *  On modifie  la fois 'val_tab' et on dcale 'pos_tab'.
 *
 *  L'algorithme de renumrotation numro 1 est utilis dans l'algorithme
 *  de recollement et le numro 2 dans celui de dcoupage des faces gauches.
 *----------------------------------------------------------------------------*/

void ecs_champ_att__renum_perio
(
 ecs_champ_t  *const champ_elt_perio,
 ecs_champ_t  *const champ_elt_old_new,
 size_t              nbr_elt_new
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui met  jour le tableau renvoy par
 * ecs_champ_def__typ_fac_cel() en fonction d'une connectivits ajoute par
 * une priodicit.
 *----------------------------------------------------------------------------*/

void ecs_champ_att__typ_fac_perio
(
 ecs_champ_t    * champ_fac_perio,
 ecs_tab_int_t  * typ_fac
) ;


#endif /* _ECS_CHAMP_ATT_H_ */
