#ifndef _ECS_CHAMP_DEF_H_
#define _ECS_CHAMP_DEF_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associees a la structure `ecs_champ_t' decrivant un champ
 *   et propres aux champs principaux de type "definition"
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_param_rc_glob.h"
#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui ralise le tri des types gomtriques
 *  La fonction affiche le nombre d'lments par type gomtrique
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_champ_def__trie_typ
(
 ecs_champ_t * this_champ_def,
 int           dim_elt
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit
 *   les dfinitions des faces par dcomposition des champs des cellules
 *----------------------------------------------------------------------------*/

void ecs_champ_def__decompose_cel
(
 ecs_champ_t *vect_champ_fac[],
 ecs_champ_t *champ_def_cel
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit
 *   les dfinitions des artes par dcomposition des champs des faces
 *----------------------------------------------------------------------------*/

void ecs_champ_def__decompose_fac
(
 ecs_champ_t *vect_champ_are[],
 ecs_champ_t *champ_def_elt
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui realise la fusion des definitions des elements
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_champ_def__int_fusionne
(
 ecs_champ_t   * this_champ_def, /* <-> Reference sur champ des definitions   */
 size_t        * nbr_elt_cpct,
 ecs_tab_int_t * signe_elt       /* <-- Signe des elts apres tri de leur def. */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui realise la fusion des definitions des elements
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_champ_def__real_fusionne
(
 ecs_champ_t * this_champ_def, /* <-> Reference sur le champ des definitions */
 size_t      * nbr_elt_cpct
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit la liste des cellules attaches  une liste
 *  de faces fournie en argument.
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_champ_def__liste_cel_fac
(
 const ecs_int_t            nbr_fac,
       ecs_champ_t   *const champ_def_cel,
 const ecs_tab_int_t        liste_fac
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit la table de connectivite "faces -> sommets"
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ_def__cree_fac_som
(
 ecs_champ_t       *const champ_def_fac,
 ecs_champ_t       *const champ_def_are
) ;


/*----------------------------------------------------------------------------
 *  Fonction realisant le decoupage des faces polygonales en triangles
 *
 *  Le maillage doit tre en connectivit nodale.
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ_def__dec_poly_tria
(
 ecs_champ_t        *      vect_champ_fac[],
 ecs_champ_t        *const champ_def_som
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit un tableau de booleens conforme a une liste
 *   de sous-elements
 *  Un sous-element est a ECS_TRUE
 *   s'il intervient dans la definition des elements
 *----------------------------------------------------------------------------*/

void ecs_champ_def__cree_masque
(
 ecs_tab_bool_t        bool_sselt_select,
 ecs_champ_t    *const champ_def_elt
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie le nombre de faces de type "polygone"
 *  (base sur la dfinition de faces par plus de 4 artes)
 *----------------------------------------------------------------------------*/

size_t  ecs_champ_def__nbr_fac_poly
(
 ecs_champ_t  *const champ_def_fac
) ;


/*----------------------------------------------------------------------------
 *  Suppression des sommets ne participant pas  la connectivit
 * (renvoie le champ de renumrotation des sommets, ou NULL si aucune
 * renumrotation n'a t ncessaire).
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ_def__nettoie_nodal
(
 ecs_champ_t       *const champ_def_som,
 ecs_champ_t       *const champ_def_are,
 ecs_champ_t       *const champ_def_fac,
 ecs_champ_t       *const champ_def_cel
) ;


/*----------------------------------------------------------------------------
 *  Correction si ncessaire de l'orientation des lments en
 *   connectivit nodale.
 *----------------------------------------------------------------------------*/

void ecs_champ_def__orient_nodal
(
       ecs_champ_t    *const champ_def_som,   /*  -> Dfinition des sommets   */
       ecs_champ_t    *const champ_def_fac,   /*  -> Dfinition des faces     */
       ecs_champ_t    *const champ_def_cel,   /*  -> Dfinition des cellules  */
       ecs_tab_int_t  *const liste_cel_err,   /* <-  Cels. erreur (option)    */
       ecs_tab_int_t  *const liste_cel_cor,   /* <-  Cels. correct. (option)  */
 const ecs_bool_t            correc_orient    /*  -> Correction ou non        */
) ;


/*----------------------------------------------------------------------------
 *  Fusion des sommets confondus d'aprs la longueur des artes.
 * La connectivit des artes est mise  jour.
 *----------------------------------------------------------------------------*/

void ecs_champ_def__nettoie_som_are
(
 ecs_champ_t       *const champ_def_som,
 ecs_champ_t       *const champ_def_are
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui supprime les ventuelles artes dgnres
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ_def__nettoie_are
(
 ecs_champ_t       *const champ_def_are
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui supprime les ventuelles faces dgnres
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ_def__nettoie_fac
(
 ecs_champ_t       *const champ_def_fac
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui calcule les coordonnes minimales et maximales
 *----------------------------------------------------------------------------*/

void ecs_champ_def__calc_coo_ext
(
 ecs_champ_t   *const champ_som_def
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui modifie les coordonnes du maillage
 *----------------------------------------------------------------------------*/

void ecs_champ_def__transf_coo
(
 ecs_champ_t   *const champ_som_def,
 const double         matrice[3][4]
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui recolle les faces non conformes
 *
 *  Les listes des faces nouvelles ou modifies sont construites (et alloues)
 *  ici ; les structures liste_fac_new et liste_fac_mod correspondantes sont
 *  donc vides en entre ; idem pour liste_fac_err qui indiquera les indices
 *  des faces pour lesquelles le dcoupage en sous-faces a chou
 *
 *  On prend en entre soit une dfinition de type "visibilit" entre faces
 *   recoller (par exemple une filiation), ou alors une simple liste de
 *  faces slectionnes. L'un de vec_fac_vis et tab_fac_select doit donc
 *  tre  NULL, et l'autre non.
 *----------------------------------------------------------------------------*/

void ecs_champ_def__recolle
(
       ecs_champ_t       *const champ_def_fac,
       ecs_champ_t       *const champ_def_are,
       ecs_champ_t       *const champ_def_som,
       ecs_champ_t     * *const champ_fac_old_new,
       ecs_champ_t     * *const champ_fac_perio,
       ecs_champ_t       *const champ_fac_vis,
       ecs_tab_int_t     *const tab_fac_de_bord_select,
       ecs_tab_int_t     *const liste_fac_new,
       ecs_tab_int_t     *const liste_fac_mod,
       ecs_tab_int_t     *const liste_fac_err,
 const ecs_param_rc_t           param_rc
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie un tableau associant un type  chaque face, sous
 * forme de masque : 0 pour face isole, 1 ou 2 pour face de bord (1 si
 * cellule avec cette face normale sortante, 2 si cellule avec cette face
 * normale entrante), 1+2 = 3 pour face interne, et 4 ou plus pour tous
 * les autres cas, correspondant  une erreur de connectivit (+4 pour faces
 * voyant au moins deux cellules avec face normale sortante, +8 pour faces
 * voyant au moins deux cellules avec face normale entrante).
 *
 *  Le type de chaque face pourra tre modifi ultrieurement en fonction
 * des informations de priodicit.
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_champ_def__typ_fac_cel
(
 ecs_champ_t    *const champ_def_cel,
 ecs_champ_t    *const champ_def_fac
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie un tableau associant un type  chaque face les
 * numros des cellules dfinies par cette face (normale sortante,
 * puis normale entrante). On affecte une valeur 0 lorsqu'il n'y a pas de
 * cellule correspondante directe (la priodicit n'est donc pas prise en
 * compte  ce niveau).
 *
 * On suppose que la cohrence du maillage a dj t vridifie et
 * qu'aucune face n'appartient  plus d'une cellule par ct.
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_champ_def__fac_cel
(
 ecs_champ_t       *const champ_def_cel,
 ecs_champ_t       *const champ_def_fac
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie un tableau associant  chaque cellule un code
 * en fonction des erreurs de connectivit ventuelles associes  cette
 * cellule (0 si pas d'erreur, 1 si une des faces dfinissant cette cellule
 * s'appuie sur plusieurs cellules du mme ct).
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_champ_def__err_cel_connect
(
       ecs_champ_t    *const champ_def_cel,
 const ecs_tab_int_t  *const typ_fac_cel
) ;


#endif /* _ECS_CHAMP_DEF_H_ */
