#ifndef _ECS_CONNECT_PRIV_H_
#define _ECS_CONNECT_PRIV_H_

/*============================================================================
 *  Definition privee de la structure `_ecs_connect_t' decrivant une
 *  connectivite
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_entmail_publ.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_connect_publ.h"


/*============================================================================
 *                       Definition de macros
 *============================================================================*/


/*============================================================================
 *                       Definition de la structure
 *============================================================================*/


struct _ecs_connect_t {

  ecs_entmail_t     * entmail       ;  /* Pointeur sur l'entite de maillage   */
                                       /*  "mere"  de la connectivite         */
  ecs_entmail_t     * entmail_inf   ;  /* Pointeur sur l'entite de maillage   */
                                       /*  "fille" de la connectivite         */
                                       /*  (entite de dimension inferieure    */
                                       /*   a l'entite "mere")                */
  ECS_CONNECT_NAT_E   connect_nat_e ;  /* Nature de la connectivite indiquant */
                                       /*  le lien entre les 2 entites        */
                                       /*  (par etiquettes ou par indices)    */
} ;


/*=========================================================
 *
 *          Connectivites          | Entites   /  Entites
 *                                 |  meres       filles
 * ================================|========================
 *  ARE_SOM                        | Aretes    /  Sommets
 *  (Aretes -> Sommets)            |
 * --------------------------------|------------------------
 *  FAC_SOM                        | Faces     /  Sommets
 *  (Faces  -> Sommets)            |
 * --------------------------------|------------------------
 *  FAC_ARE                        | Faces     /  Aretes
 *  (Faces  -> Aretes)             |
 * --------------------------------|------------------------
 *  CEL_SOM                        | Cellules  /  Sommets
 *  (Cellules -> Sommets)          |
 * --------------------------------|------------------------
 *  CEL_FAC                        | Cellules  /  Faces
 *  (Cellules -> Faces)            |
 *
 *=========================================================*/

/*==============================================================
 *
 *   Type de connectivite   |             Description
 * -------------------------|------------------------------------
 *   ECS_CONNECT_NAT_INDEX  |      L'entite de maillage "mere"
 *                          |   depend des INDICES
 *                          |   de l'entite de maillage "fille"
 *                          |
 * -------------------------|------------------------------------
 *   ECS_CONNECT_NAT_LABEL  |      L'entite de maillage "mere"
 *                          |   depend des ETIQUETTES
 *                          |   de l'entite de maillage "fille"
 *                          |
 *
 *==============================================================*/


#endif /* _ECS_CONNECT_PRIV_H_ */

