#ifndef _ECS_CONNECT_PUBL_H_
#define _ECS_CONNECT_PUBL_H_

/*============================================================================
 *  Definition publique de la structure `ecs_connect_t' decrivant une
 *   connectivite
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                         Declaration de la structure
 *============================================================================*/

typedef struct _ecs_connect_t ecs_connect_t ;


/*============================================================================
 *                         Definition d'enumeration
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Definition d'enumeration liee au tableau des connectivites
 *----------------------------------------------------------------------------*/

typedef enum {

  ECS_CONNECT_ARE_SOM ,  /* Connectite: Aretes   definies par sommets        */
  ECS_CONNECT_FAC_SOM ,  /* Connectite: Faces    definies par sommets        */
  ECS_CONNECT_FAC_ARE ,  /* Connectite: Faces    definies par aretes         */
  ECS_CONNECT_CEL_SOM ,  /* Connectite: Cellules definies par sommets        */
  ECS_CONNECT_CEL_FAC ,  /* Connectite: Cellules definies par faces          */
  ECS_CONNECT_FIN        /* Nombre des connectites definies                  */

} ECS_CONNECT_E ;


#define ECS_CONNECT_DEB  ECS_CONNECT_ARE_SOM


typedef enum {

  ECS_CONNECT_NAT_INDEX ,
  ECS_CONNECT_NAT_LABEL

} ECS_CONNECT_NAT_E ;


typedef enum {

  ECS_CONNECT_TYP_NUL         ,
  ECS_CONNECT_TYP_NODALE      ,
  ECS_CONNECT_TYP_DESCENDANTE

} ECS_CONNECT_TYP_E ;


#endif /* _ECS_CONNECT_PUBL_H_ */
