#ifndef _ECS_ENTMAIL_PRIV_H_
#define _ECS_ENTMAIL_PRIV_H_

/*============================================================================
 *  Dfinition prive de la structure `_ecs_entmail_t' dcrivant
 *   une entit de maillage
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_champ_publ.h"

/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_entmail_publ.h"


/*============================================================================
 *                       Dfinition de macros
 *============================================================================*/


/*============================================================================
 *                       Dfinition de la structure
 *============================================================================*/

struct _ecs_entmail_t {

  ecs_champ_t        * champ[ECS_CHAMP_FIN] ;  /* Vecteur des pointeurs sur   */
                                               /* les ttes des listes        */
                                               /* chanes de champs          */

} ;


/*============================================================================
 *
 *                   Tableau des listes chanes de champs
 *
 *  --------------------------------------------------------------------------
 *  champs "principaux"  (obligatoirement dfinis pour une entit de maillage)
 *  --------------------------------------------------------------------------
 *
 *  champ  "dfinition"        - Identificateur `ECS_CHAMP_DEF'
 *                             - Liste chane rduite  1 champ + NULL
 *                             - Le champ contient la dfinition
 *                                des lments de l'entit de maillage courante
 *                               en fonction
 *                                des lments d'une entit de maillage
 *                                de dimension infrieure
 *
 *  champ  "type geomtrique"  - Identificateur `ECS_CHAMP_TYP'
 *                             - Obligatoire uniquement pour les cellules
 *                             - Liste chane rduite  1 champ + NULL
 *                             - Le champ contient le type gometrique
 *                                des lments
 *                               (arte, triangle, quadrilatre, ttradre,
 *                                prisme, hexadre, etc.)
 *
 *  --------------------------------------------------------------------------
 *  champs "auxiliaires" (ventuellement  dfinis pour une entit de maillage)
 *  --------------------------------------------------------------------------
 *
 *  champs "attribut"          - Identificateur `ECS_CHAMP_ATT'
 *                             - Liste chane pouvant avoir un nombre
 *                                quelconque de noeuds
 *                             - La liste contient les attributs qui peuvent
 *                                etre attachs aux lments
 *                                chaque attribut correspond un champ
 *                               Exemples:
 *                               . attribut "couleur"     des lments,
 *                               . attribut "groupe"
 *                                  auquels appartiennent les lments,
 *                               . attribut "etiquettes"  des lments,
 *                               . attribut "filiation"   des lments,
 *                               . etc.
 *
 *============================================================================*/


#endif /* _ECS_ENTMAIL_PRIV_H_ */

