#ifndef _ECS_FAMILLE_PUBL_H_
#define _ECS_FAMILLE_PUBL_H_

/*============================================================================
 *  Dfinition publique de la structure `ecs_famille_t' dcrivant une famille
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                         Dclaration de la structure
 *============================================================================*/

typedef struct _ecs_famille_t ecs_famille_t ;


/*============================================================================
 *                         Dfinition d'enumration
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Dfinition d'numration lie au tableau des familles
 *-------------------------------------------------------*/

typedef enum {

  ECS_FAMILLE_SOM ,  /* Entite sommet               */
  ECS_FAMILLE_ARE ,  /* Entite arete                */
  ECS_FAMILLE_FAC ,  /* Entite face                 */
  ECS_FAMILLE_CEL ,  /* Entite cellule              */
  ECS_FAMILLE_FIN    /* Nombre des entites definies */

} ECS_FAMILLE_E ;


#define ECS_FAMILLE_DEB  ECS_FAMILLE_SOM


/*============================================================================
 *                         Dfinition de macros
 *============================================================================*/


#endif /* _ECS_FAMILLE_PUBL_H_ */
