#ifndef _ECS_VEC_DEF_H_
#define _ECS_VEC_DEF_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associes aux structures `ecs_vec_int_t' et `ecs_vec_real_t' dcrivant
 *   les vecteurs indexes entier et rel
 *   et propres aux vecteurs indexes
 *      lies aux champs principaux de type "dfinition"
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_param_perio_glob.h"
#include "ecs_vec_int_publ.h"
#include "ecs_vec_real_publ.h"



/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction ralisant la dcomposition des cellules en faces
 *   sur les vecteurs `ecs_vec_int_t' associs aux champs principaux
 *----------------------------------------------------------------------------*/

void ecs_vec_def__decompose_cel
(
 ecs_vec_int_t **vec_def_fac,        /* <-- Dfinitions des faces             */
 ecs_vec_int_t **vec_cel_def_fac,    /* <-- Dfinitions des cellules par face */
 ecs_vec_int_t  *vec_def_cel         /* --> Dfinitions des cellules          */
) ;


/*----------------------------------------------------------------------------
 *  Fonction ralisant la dcomposition des faces en artes
 *   sur les vecteurs `ecs_vec_int_t' associs aux champs principaux
 *----------------------------------------------------------------------------*/

void ecs_vec_def__decompose_fac
(
 ecs_vec_int_t **vec_def_are,        /* <-- Dfinitions des artes            */
 ecs_vec_int_t **vec_fac_def_are,    /* <-- Dfinitions des faces par artes  */
 ecs_vec_int_t  *vec_def_fac         /* --> Dfinitions des faces             */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui ralise la fusion des dfinitions des lments
 *
 *  Les valeurs absolues sont tries si `bool_abs' est a `ECS_TRUE'
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_def__fusionne
(
 ecs_vec_int_t * *const this_vec_def_int,
 ecs_tab_int_t   *      signe_elt
) ;


/*----------------------------------------------------------------------------
 *  Suppression des sommets ne participant pas  la connectivit
 *   (renvoie le vecteur de renumrotation des sommets, ou NULL si aucune
 *   renumrotation n'a t ncessaire).
 *----------------------------------------------------------------------------*/

ecs_vec_int_t * ecs_vec_def__nettoie_nodal
(
       ecs_vec_real_t  *const vec_def_som,
 const ecs_vec_int_t   *const vec_def_are,
 const ecs_vec_int_t   *const vec_def_fac,
 const ecs_vec_int_t   *const vec_def_cel
) ;


/*----------------------------------------------------------------------------
 *  Correction si ncessaire de l'orientation des lments en
 *   connectivit nodale.
 *----------------------------------------------------------------------------*/

void ecs_vec_def__orient_nodal
(
       ecs_vec_real_t  *const vec_def_som,    /*  -> Df. sommets             */
 const ecs_vec_int_t   *const vec_def_fac,    /*  -> Df. faces               */
 const ecs_vec_int_t   *const vec_def_cel,    /*  -> Df. cellules            */
       ecs_tab_int_t   *const liste_cel_err,  /* <-  Cellules avec erreur     */
       ecs_tab_int_t   *const liste_cel_cor,  /* <-  Cellules corriges       */
 const ecs_bool_t             correc_orient   /*  -> Correction ou non        */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui calcule les coordonnes minimales et maximales
 *----------------------------------------------------------------------------*/

void ecs_vec_def__calc_coo_ext
(
 ecs_vec_real_t * vec_som
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui modifie les coordonnes du maillage
 *----------------------------------------------------------------------------*/

void ecs_vec_def__transf_coo
(
 ecs_vec_real_t  * vec_som,
 const double      matrice[3][4]
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui ralise la fusion des dfinitions des lments
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_real_def__fusionne
(
 ecs_vec_real_t * *const this_vec_def_real
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui fusionne des sommets quivalents
 *  Le pointeur sur un tableau de tolrances peut tre  NULL, dans quel cas
 *  on prendra le mme poids pour tous les sommets.
 *  Le pointeur sur le tableau liste_som_new peut aussi tre  NULL, si l'on
 *  n'est pas intress par la liste des sommets fusionns.
 *
 *  Remarque : le tableau d'quivalence (fusion) des sommets est construit de
 *             manire  ce qu' un sommet ne comportant pas d'quivalent
 *             o de plus petit indice parmi ses quivalents corresponde la
 *             valeur -1, alors qu'un un sommet possdant des quivalents de
 *             plus petit indice corresponde le plus grand indice parmi ces
 *             quivalents (ce qui constitue une sorte de liste chane).
 *----------------------------------------------------------------------------*/

ecs_vec_int_t * ecs_vec_def__fusion_som
(
       ecs_vec_int_t     *const vec_def_are,    /* <-> Df. artes            */
       ecs_vec_real_t    *const vec_def_som,    /* <-> Df. sommets           */
       ecs_tab_int_t     *const tab_equiv_som,  /* <-> Fusions de sommets     */
 const ecs_tab_real_t    *const dist_max_som,   /*  -> Tolrances             */
       ecs_tab_int_t     *const liste_som_new   /* <-  Liste sommets modifis */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie un tableau associant un type  chaque face, sous
 * forme de masque : 0 pour face isole, 1 ou 2 pour face de bord (1 si
 * cellule avec cette face normale sortante, 2 si cellule avec cette face
 * normale entrante), 1+2 = 3 pour face interne, et 4 ou plus pour tous
 * les autres cas, correspondant  une erreur de connectivit (+4 pour faces
 * voyant au moins deux cellules avec face normale sortante, +8 pour faces
 * voyant au moins deux cellules avec face normale entrante).
 *
 *  Le type de chaque face pourra tre modifi ultrieurement en fonction
 * des informations de priodicit.
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_def__typ_fac_cel
(
 const ecs_vec_int_t  *const vec_def_cel,
       size_t                nbr_fac
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie un tableau associant  chaque face les
 * numros des cellules dfinies par cette face (normale sortante,
 * puis normale entrante). On affecte une valeur 0 lorsqu'il n'y a pas de
 * cellule correspondante directe (la priodicit n'est donc pas prise en
 * compte  ce niveau).
 *
 * On suppose que la cohrence du maillage a dj t vridifie et
 * qu'aucune face n'appartient  plus d'une cellule par ct.
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_def__fac_cel
(
 const ecs_vec_int_t  *const vec_def_cel,
       size_t                nbr_fac
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie un tableau associant  chaque cellule un code
 * en fonction des erreurs de connectivit ventuelles associes  cette
 * cellule (0 si pas d'erreur, 1 si une des faces dfinissant cette cellule
 * s'appuie sur plusieurs cellules du mme ct).
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_def__err_cel_connect
(
 const ecs_vec_int_t  *const vec_def_cel,
 const ecs_tab_int_t  *const typ_fac_cel
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit la liste des cellules attaches  une liste
 *  de faces fournie en argument.
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_def__liste_cel_fac
(
       size_t                nbr_fac,
 const ecs_vec_int_t  *const vec_def_cel,
 const ecs_tab_int_t         liste_fac
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit la table de connectivit "faces -> sommets"
 *----------------------------------------------------------------------------*/

ecs_vec_int_t * ecs_vec_def__cree_fac_som
(
 const ecs_vec_int_t *const vec_def_fac,
 const ecs_vec_int_t *const vec_def_are
) ;


/*----------------------------------------------------------------------------
 *  Fonction prparant le dcoupage des faces polygonales en triangles
 *
 *  Les faces doivent tre dfinies en connectivit nodale.
 *
 *  Si un polygone  n sommets est decoup en triangles,
 *  on obtient n-2 triangles.
 *----------------------------------------------------------------------------*/

void ecs_vec_def__cpt_poly_tria
(
 const ecs_vec_int_t  *const vec_def_fac,      /*  -> dfinition des faces    */
       size_t         *const fac_nbr_som_max,  /* <-  nbr max sommets/face    */
       size_t         *const nbr_fac_new,      /* <-  nbr faces decoupes     */
       size_t         *const nbr_fac_val_new   /* <-  dim val faces decoupes */
) ;


/*----------------------------------------------------------------------------
 *  Fonction ralisant le dcoupage des faces polygonale en triangles
 *
 *  Les faces doivent tre dfinies en connectivit nodale.
 *----------------------------------------------------------------------------*/

ecs_vec_int_t * ecs_vec_def__dec_poly_tria
(
       ecs_vec_int_t      *const vec_def_fac_new,
 const ecs_vec_int_t      *const vec_def_fac,
 const ecs_vec_real_t     *const vec_def_som,
       size_t                    fac_nbr_som_max,
       size_t                    nbr_fac_new
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie le nombre de faces de type "polygone"
 *  (base sur la dfinition de faces par plus de 4 artes)
 *----------------------------------------------------------------------------*/

size_t ecs_vec_def__nbr_fac_poly
(
 const ecs_vec_int_t  *const vec_def_fac
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit un tableau de boolens conforme a une liste
 *   de sous-lments
 *  Un sous-lment est a `ECS_TRUE'
 *   s'il intervient dans la dfinition des lments
 *----------------------------------------------------------------------------*/

void ecs_vec_def__cree_masque
(
 const ecs_tab_bool_t        bool_sselt_select,
 const ecs_vec_int_t  *const vec_def_elt
) ;


/*----------------------------------------------------------------------------
 *  Fusion des sommets confondus appartenant  des mmes artes.
 *  La connectivit des artes est mise  jour.
 *----------------------------------------------------------------------------*/

ecs_vec_int_t * ecs_vec_def__nettoie_som_are
(
 ecs_vec_real_t  *const vec_def_som,
 ecs_vec_int_t   *const vec_def_are
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui supprime les ventuelles artes dgnres
 *----------------------------------------------------------------------------*/

ecs_vec_int_t * ecs_vec_def__nettoie_are
(
 ecs_vec_int_t   *const vec_def_are
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui supprime les ventuelles faces dgnres
 *----------------------------------------------------------------------------*/

ecs_vec_int_t  * ecs_vec_def__nettoie_fac
(
 ecs_vec_int_t   *const vec_def_fac
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui met  jour le tableau des fusions de sommets
 *
 *  Remarque : le tableau d'quivalence (fusion) des sommets est construit de
 *             manire  ce qu' un sommet ne comportant pas d'quivalent
 *             o de plus grand indice parmi ses quivalents corresponde la
 *             valeur -1, alors qu'un un sommet possdant des quivalents de
 *             plus grand indice corresponde le plus petit indice parmi ces
 *             quivalents (ce qui constitue une sorte de liste chane).
 *----------------------------------------------------------------------------*/

void ecs_vec_def__maj_equiv_som
(
 size_t                ind_som_0,
 size_t                ind_som_1,
 ecs_tab_int_t  *const tab_equiv_som
) ;


#endif /* _ECS_VEC_DEF_H_ */
