#ifndef _ECS_IDEAS_DEF_H_
#define _ECS_IDEAS_DEF_H_

/*============================================================================
 *  Dfinitions de macros et constantes
 *   servant  la lecture d'un fichier de maillage Ideas au format "universel"
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2008 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/



/*============================================================================
 *                       Definition de macros
 *                       Definition de constantes globales statiques
 *============================================================================*/


/* Rubriques IDEAS (dataset) */
/*===========================*/


/* Numeros de dataset */
/*--------------------*/

        /* Dataset pour les systmes de coordonnes   */
#define ECS_IDEAS_DATASET_SYS_COORD_2420                          2420
        /* Dataset pour les noeuds                    */
#define ECS_IDEAS_DATASET_NODES_2411                              2411
        /* Dataset pour les elements                  */
#define ECS_IDEAS_DATASET_ELEMENTS_2412                           2412
        /* Anciens datasets sur les groupes           */
#define ECS_IDEAS_DATASET_GROUPS_2430                             2430
#define ECS_IDEAS_DATASET_GROUPS_2432                             2432
#define ECS_IDEAS_DATASET_GROUPS_2435                             2435
#define ECS_IDEAS_DATASET_GROUPS_2452                             2452
#define ECS_IDEAS_DATASET_GROUPS_2467                             2467
        /*        Dataset sur les groupes             */
#define ECS_IDEAS_DATASET_GROUPS_2477                             2477


/* Chaine servant de separateur de dataset */
/*-----------------------------------------*/

#define ECS_IDEAS_SEPARATEUR_DATASET                        "    -1\n"


/* Couleurs */
/*==========*/

        /* Numero de la couleur par defaut                */
#define ECS_IDEAS_DEFAULT_COLOR                                     11


/* Liste des identificateurs de description des elements finis */
/*=============================================================*/

#define ECS_IDEAS_LINEAR_BEAM                                       21  /*  1 */
#define ECS_IDEAS_PARABOLIC_BEAM                                    24  /*  2 */
#define ECS_IDEAS_SHELL_LINEAR_TRI                                  91  /*  3 */
#define ECS_IDEAS_SHELL_PARABOLIC_TRI                               92  /*  4 */
#define ECS_IDEAS_SHELL_CUBIC_TRI                                   93  /*  5 */
#define ECS_IDEAS_SHELL_LINEAR_QUAD                                 94  /*  6 */
#define ECS_IDEAS_SHELL_PARABOLIC_QUAD                              95  /*  7 */
#define ECS_IDEAS_SHELL_CUBIC_QUAD                                  96  /*  8 */
#define ECS_IDEAS_SOLID_LINEAR_TETRA                               111  /*  9 */
#define ECS_IDEAS_SOLID_PARABOLIC_TETRA                            118  /* 10 */
#define ECS_IDEAS_SOLID_LINEAR_WEDGE                               112  /* 11 */
#define ECS_IDEAS_SOLID_PARABOLIC_WEDGE                            113  /* 12 */
#define ECS_IDEAS_SOLID_CUBIC_WEDGE                                114  /* 13 */
#define ECS_IDEAS_SOLID_LINEAR_BRICK                               115  /* 14 */
#define ECS_IDEAS_SOLID_PARABOLIC_BRICK                            116  /* 15 */
#define ECS_IDEAS_SOLID_CUBIC_BRICK                                117  /* 16 */

#define ECS_IDEAS_NBR_ELT_TYP                                       16

#define ECS_IDEAS_IGNORE                                            -1
#define ECS_IDEAS_UNHANDLED                                         -2
#define ECS_IDEAS_UNKNOWN                                           -3

/* Definition des elements */
/*=========================*/

         /* Nombre max de numeros de noeud par ligne      */
         /* pour la definition des elements               */
#define ECS_IDEAS_NBR_NODE_PER_LINE                                  8

/* Tableau donnant la liste des elements de type `beam' (poutre) */
/*---------------------------------------------------------------*/

#define ECS_IDEAS_NBR_ELT_BEAM                                       2

static const ecs_int_t
ecs_fic_ideas_elt_beam_liste_c[ECS_IDEAS_NBR_ELT_BEAM] = {
  ECS_IDEAS_LINEAR_BEAM    ,
  ECS_IDEAS_PARABOLIC_BEAM
}  ;

/* Tableau donnant la liste des elements              */
/* `paraboliques' ou `cubiques'                       */
/* qui sont transformes en leur equivalent `lineaire' */
/*----------------------------------------------------*/

#define ECS_IDEAS_ORDER_LINEAR                                       1
#define ECS_IDEAS_ORDER_PARABOLIC                                    2
#define ECS_IDEAS_ORDER_CUBIC                                        3

#define ECS_IDEAS_NBR_MAX_SOM                                        8

typedef struct {

  ecs_int_t     ideas_typ                     ; /* Type IDEAS de l'element    */
  ecs_elt_typ_t ecs_typ                       ; /* Type ECS   de l'element    */
  ecs_int_t     order                         ; /* Ordre      de l'element    */
  ecs_int_t     num_som[ECS_IDEAS_NBR_MAX_SOM]; /* Liste des num de sommet ECS*/

} ecs_fic_ideas_init_elt_t ;

static const ecs_fic_ideas_init_elt_t
ecs_fic_ideas_init_elt_liste_c[ECS_IDEAS_NBR_ELT_TYP] = {

  {                                            /* 1 */
    ECS_IDEAS_LINEAR_BEAM                            ,
    ECS_ELT_TYP_ARE                                  ,
    ECS_IDEAS_ORDER_LINEAR                           ,
    { 1, 2 }
  } ,
  {                                            /* 2 */
    ECS_IDEAS_PARABOLIC_BEAM                         ,
    ECS_ELT_TYP_ARE                                  ,
    ECS_IDEAS_ORDER_PARABOLIC                        ,
    { 1, 3 }
  } ,
  {                                            /* 3 */
    ECS_IDEAS_SHELL_LINEAR_TRI                       ,
    ECS_ELT_TYP_FAC_TRIA                             ,
    ECS_IDEAS_ORDER_LINEAR                           ,
    { 1, 2, 3 }
  } ,
  {                                            /* 4 */
    ECS_IDEAS_SHELL_PARABOLIC_TRI                    ,
    ECS_ELT_TYP_FAC_TRIA                             ,
    ECS_IDEAS_ORDER_PARABOLIC                        ,
    { 1, 3, 5 }
  } ,
  {                                            /* 5 */
    ECS_IDEAS_SHELL_CUBIC_TRI                        ,
    ECS_ELT_TYP_FAC_TRIA                             ,
    ECS_IDEAS_ORDER_CUBIC                            ,
    { 1, 4, 7 }
  } ,
  {                                            /* 6 */
    ECS_IDEAS_SHELL_LINEAR_QUAD                      ,
    ECS_ELT_TYP_FAC_QUAD                             ,
    ECS_IDEAS_ORDER_LINEAR                           ,
    { 1, 2, 3, 4 }
  } ,
  {                                            /* 7 */
    ECS_IDEAS_SHELL_PARABOLIC_QUAD                   ,
    ECS_ELT_TYP_FAC_QUAD                             ,
    ECS_IDEAS_ORDER_PARABOLIC                        ,
    { 1, 3, 5, 7 }
  } ,
  {                                            /* 8 */
    ECS_IDEAS_SHELL_CUBIC_QUAD                       ,
    ECS_ELT_TYP_FAC_QUAD                             ,
    ECS_IDEAS_ORDER_CUBIC                            ,
    { 1, 4, 7, 10 }
  } ,
  {                                            /* 9 */
    ECS_IDEAS_SOLID_LINEAR_TETRA                     ,
    ECS_ELT_TYP_CEL_TETRA                            ,
    ECS_IDEAS_ORDER_LINEAR                           ,
    { 1, 2, 3, 4 }
  } ,
  {                                           /* 10 */
    ECS_IDEAS_SOLID_PARABOLIC_TETRA                  ,
    ECS_ELT_TYP_CEL_TETRA                            ,
    ECS_IDEAS_ORDER_PARABOLIC                        ,
    { 1, 3, 5, 10 }
  } ,
  {                                           /* 11 */
    ECS_IDEAS_SOLID_LINEAR_WEDGE                     ,
    ECS_ELT_TYP_CEL_PRISM                            ,
    ECS_IDEAS_ORDER_LINEAR                           ,
    { 1, 2, 3, 4, 5, 6 }
  } ,
  {                                           /* 12 */
    ECS_IDEAS_SOLID_PARABOLIC_WEDGE                  ,
    ECS_ELT_TYP_CEL_PRISM                            ,
    ECS_IDEAS_ORDER_PARABOLIC                        ,
    { 1, 3, 5, 10, 12, 14 }
  } ,
  {                                           /* 13 */
    ECS_IDEAS_SOLID_CUBIC_WEDGE                      ,
    ECS_ELT_TYP_CEL_PRISM                            ,
    ECS_IDEAS_ORDER_CUBIC                            ,
    { 1, 4, 7, 16, 19, 22 }
  } ,
  {                                           /* 14 */
    ECS_IDEAS_SOLID_LINEAR_BRICK                     ,
    ECS_ELT_TYP_CEL_HEXA                             ,
    ECS_IDEAS_ORDER_LINEAR                           ,
    { 1, 2, 3, 4, 5, 6, 7, 8 }                       ,
  } ,
  {                                           /* 15 */
    ECS_IDEAS_SOLID_PARABOLIC_BRICK                  ,
    ECS_ELT_TYP_CEL_HEXA                             ,
    ECS_IDEAS_ORDER_PARABOLIC                        ,
    { 1, 3, 5, 7, 13, 15, 17, 19 }
  } ,
  {                                           /* 16 */
    ECS_IDEAS_SOLID_CUBIC_BRICK                      ,
    ECS_ELT_TYP_CEL_HEXA                             ,
    ECS_IDEAS_ORDER_CUBIC                            ,
    { 1, 4, 7, 10, 21, 24, 27, 30 }
  }

} ;


/* Definition des groupes */
/*========================*/

        /* Longueur des noms de groupe                    */
#define ECS_IDEAS_LEN_GROUP_NAME                                    40

        /* Nombre max d'entites par ligne                 */
        /* pour la definition des groupes                 */
#define ECS_IDEAS_NBR_GRP_ENT_PER_LINE2                              2
        /* Idem pour les anciens dataset                  */
#define ECS_IDEAS_NBR_GRP_ENT_PER_LINE4                              4


/* Codes des entites appartenant a un groupe */
/*-------------------------------------------*/

#define ECS_IDEAS_TYP_CODE_NODES                                     7
#define ECS_IDEAS_TYP_CODE_ELEMENTS                                  8



#endif /* _ECS_IDEAS_DEF_H_ */
