#ifndef _ECS_ELT_TYP_LISTE_H_
#define _ECS_ELT_TYP_LISTE_H_

/*============================================================================
 *  Dfinition d'un tableau constant statique
 *   dfinissant les types des lments reconnus par le code
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"


/*============================================================================
 *                       Dfinition du tableau constant statique
 *============================================================================*/

typedef struct {

  int  elt_typ ;
  int  som[4] ; /* 4 sommets max. pour les sous-lments */

} ecs_sous_elt_t ;


typedef struct {

  char            nom[11] ; /* Nom le plus long: polyhedron */
  int             nbr_som ;
  int             nbr_sous_elt ;
  ecs_sous_elt_t  sous_elt[6] ; /* 6 sous-lments max. */
} ecs_fic_elt_typ_t ;


static const ecs_fic_elt_typ_t ecs_fic_elt_typ_liste_c[ECS_ELT_TYP_FIN] = {

  {                                                /* ECS_ELT_TYP_NUL       0 */
    "",
    0 ,
    0 ,
    {
      {0,{0}}
    }
  } ,

  {                                                /* ECS_ELT_TYP_SOM       1 */
    "point",
    1 ,
    0 ,
    {
      {0,{0}}
    }
  } ,

  {                                                /* ECS_ELT_TYP_ARE       2 */
    "bar2",                                        /*                         */
    2 ,                                            /*                         */
    2 ,                                            /*                         */
    {                                              /*    1       2            */
      {ECS_ELT_TYP_SOM, { 1 }} ,                   /*    x-------x            */
      {ECS_ELT_TYP_SOM, { 2 }}                     /*                         */
    }
  } ,

  {                                                /* ECS_ELT_TYP_FAC_TRIA  3 */
    "tria3",                                       /*                         */
    3 ,                                            /*                         */
    3 ,                                            /*                         */
    {                                              /*        x 3              */
      {ECS_ELT_TYP_ARE  , { 1 , 2 }} ,             /*       / \               */
      {ECS_ELT_TYP_ARE  , { 2 , 3 }} ,             /*      /   \              */
      {ECS_ELT_TYP_ARE  , { 3 , 1 }}               /*     /     \             */
    }                                              /*  1 x-------x 2          */
  } ,

  {                                                /* ECS_ELT_TYP_FAC_QUAD  4 */
    "quad4",                                       /*                         */
    4 ,                                            /*                         */
    4 ,                                            /*                         */
    {                                              /*  4 x-------x 3          */
      {ECS_ELT_TYP_ARE  , { 1 , 2 }} ,             /*    |       |            */
      {ECS_ELT_TYP_ARE  , { 2 , 3 }} ,             /*    |       |            */
      {ECS_ELT_TYP_ARE  , { 3 , 4 }} ,             /*    |       |            */
      {ECS_ELT_TYP_ARE  , { 4 , 1 }}               /*  1 x-------x 2          */
    }                                              /*                         */
  } ,

  {                                                /* ECS_ELT_TYP_CEL_TETRA 5 */
    "tetra4",                                      /*                         */
    4 ,                                            /*        x 4              */
    4 ,                                            /*       /|\               */
    {                                              /*      / | \              */
      {ECS_ELT_TYP_FAC_TRIA, { 1 , 3 , 2 }} ,      /*     /  |  \             */
      {ECS_ELT_TYP_FAC_TRIA, { 1 , 2 , 4 }} ,      /*  1 x- -|- -x 3          */
      {ECS_ELT_TYP_FAC_TRIA, { 1 , 4 , 3 }} ,      /*     \  |  /             */
      {ECS_ELT_TYP_FAC_TRIA, { 2 , 3 , 4 }}        /*      \ | /              */
    }                                              /*       \|/               */
  } ,                                              /*        x 2              */

  {                                                /* ECS_ELT_TYP_CEL_PYRAM 6 */
    "pyramid5",                                    /*                         */
    5 ,                                            /*         5 x             */
    5 ,                                            /*          /|\            */
    {                                              /*         //| \           */
      {ECS_ELT_TYP_FAC_TRIA, { 1 , 2 , 5 }    } ,  /*        // |  \          */
      {ECS_ELT_TYP_FAC_TRIA, { 1 , 5 , 4 }    } ,  /*     4 x/--|---x 3       */
      {ECS_ELT_TYP_FAC_TRIA, { 2 , 3 , 5 }    } ,  /*      //   |  /          */
      {ECS_ELT_TYP_FAC_TRIA, { 3 , 4 , 5 }    } ,  /*     //    | /           */
      {ECS_ELT_TYP_FAC_QUAD, { 1 , 4 , 3 , 2 }}    /*  1 x-------x 2          */
    }
  } ,

  {                                                /* ECS_ELT_TYP_CEL_PRISM 7 */
    "penta6",                                      /*                         */
    6 ,                                            /*  4 x-------x 6          */
    5 ,                                            /*    |\     /|            */
    {                                              /*    | \   / |            */
      {ECS_ELT_TYP_FAC_TRIA, { 1 , 3 , 2 }    } ,  /*  1 x- \-/ -x 3          */
      {ECS_ELT_TYP_FAC_TRIA, { 4 , 5 , 6 }    } ,  /*     \ 5x  /             */
      {ECS_ELT_TYP_FAC_QUAD, { 1 , 2 , 5 , 4 }} ,  /*      \ | /              */
      {ECS_ELT_TYP_FAC_QUAD, { 1 , 4 , 6 , 3 }} ,  /*       \|/               */
      {ECS_ELT_TYP_FAC_QUAD, { 2 , 3 , 6 , 5 }}    /*        x 2              */
    }
  } ,

  {                                                /* ECS_ELT_TYP_CEL_HEXA  8 */
    "hexa8",                                       /*                         */
    8 ,                                            /*                         */
    6 ,                                            /*     8 x-------x 7       */
    {                                              /*      /|      /|         */
      {ECS_ELT_TYP_FAC_QUAD, { 1 , 4 , 3 , 2 }} ,  /*     / |     / |         */
      {ECS_ELT_TYP_FAC_QUAD, { 1 , 2 , 6 , 5 }} ,  /*  5 x-------x6 |         */
      {ECS_ELT_TYP_FAC_QUAD, { 1 , 5 , 8 , 4 }} ,  /*    | 4x----|--x 3       */
      {ECS_ELT_TYP_FAC_QUAD, { 2 , 3 , 7 , 6 }} ,  /*    | /     | /          */
      {ECS_ELT_TYP_FAC_QUAD, { 3 , 4 , 8 , 7 }} ,  /*    |/      |/           */
      {ECS_ELT_TYP_FAC_QUAD, { 5 , 6 , 7 , 8 }}    /*  1 x-------x 2          */
    }
  } ,

  {                                                /* ECS_ELT_TYP_FAC_POLY  9 */
    "polygon",                                     /*                         */
    0 ,
    0 ,
    {
      {0,{0}}
    }
  } ,

  {                                                /* ECS_ELT_TYP_CEL_POLY 10 */
    "polyhedron",                                  /*                         */
    0 ,
    0 ,
    {
      {0,{0}}
    }
  }

} ;


#endif /* _ECS_ELT_TYP_LISTE_H_ */
