dnl Copyright (C) 2008-2009 EDF
dnl
dnl This file is part of the Code_Saturne Preprocessor.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl Code_Saturne Preprocessor source distribution.

# ECS_AC_TEST_ADF
#----------------
# modifies or sets have_adf, ADF_LDFLAGS, and ADF_LIBS
# depending on libraries found

AC_DEFUN([ECS_AC_TEST_ADF], [

have_adf=no

AC_ARG_WITH(adf,
            [AS_HELP_STRING([--with-adf=DIR],
                            [specify prefix directory for ADF])],
            [if test "x$withval" = "x"; then
               with_adf=yes
             fi],
            [with_adf=check])

AC_ARG_WITH(adf-lib,
            [AS_HELP_STRING([--with-adf-lib=DIR],
                            [specify directory for ADF library])],
            [if test "x$with_adf" = "xcheck"; then
               with_adf=yes
             fi
             ADF_LDFLAGS="-L$with_adf_lib"],
            [if test "x$with_adf" != "xno" -a "x$with_adf" != "xyes" \
	          -a "x$with_adf" != "xcheck"; then
               ADF_LDFLAGS="-L$with_adf/lib"
             fi])


if test "x$with_adf" != "xno" ; then

  saved_LDFLAGS="$LDFLAGS"
  saved_LIBS="$LIBS"

  ADF_LIBS="-ladf"
  LDFLAGS="${LDFLAGS} ${ADF_LDFLAGS}"
  LIBS="${LIBS} ${ADF_LIBS}"

  AC_CHECK_LIB(adf, ADF_Database_Open, 
               [ AC_DEFINE([HAVE_ADF], 1, [ADF file support])
                 have_adf=yes
               ], 
               [if test "x$with_adf" != "xcheck" ; then
                  AC_MSG_FAILURE([ADF support is requested, but test for ADF failed!])
                else
                  AC_MSG_WARN([no ADF support])
                fi
               ],
               )

  if test "x$have_adf" = "xno"; then
    ADF_LIBS=""
  fi

  LDFLAGS="$saved_LDFLAGS"
  LIBS="$saved_LIBS"

  unset saved_LDFLAGS
  unset saved_LIBS

fi

AC_SUBST(ADF_LDFLAGS)
AC_SUBST(ADF_LIBS)

])dnl

