#ifndef _ECS_MAILLAGE_PRIV_H_
#define _ECS_MAILLAGE_PRIV_H_

/*============================================================================
 *  Definition privee de la structure `_ecs_maillage_t' decrivant un maillage
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_entmail.h"
#include "ecs_famille.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_maillage.h"


/*============================================================================
 *                       Definition de macros
 *============================================================================*/


/*============================================================================
 *                       Definition de la structure
 *============================================================================*/

typedef enum {

  ECS_MAILLAGE_CONNECT_NUL,
  ECS_MAILLAGE_CONNECT_NODALE,
  ECS_MAILLAGE_CONNECT_DESCENDANTE

} ecs_maillage_connect_typ_t;


struct _ecs_maillage_t {

  ecs_maillage_connect_typ_t typ_connect;    /* Type de connectivite          */

  ecs_entmail_t  *entmail[ECS_ENTMAIL_FIN];  /* Tabl. des entites de maillage */

  ecs_famille_t  *famille[ECS_FAMILLE_FIN];  /* Tableau des listes chainees   */
                                             /* des familles, par entite      */

} ;


/*============================================================================
 *
 *  .===========================================================.
 *  |                                                           |
 *  | Entites de maillage                                       |
 *  |                                                           |
 *  |===========================================================|
 *  | ECS_ENTMAIL_SOM  : sommets                                |
 *  |-----------------------------------------------------------|
 *  | ECS_ENTMAIL_FAC  : faces (surfaces a 3 sommets ou plus)   |
 *  |-----------------------------------------------------------|
 *  | ECS_ENTMAIL_CEL  : cellules (Volume  a 4 sommets ou plus) |
 *  `-----------------------------------------------------------'
 *
 *============================================================================*/


/*============================================================================
 *
 * Les valeurs des champs `famille' sont les numeros des familles
 *  numerotees a partir de `1' comme suit :
 *  - en commencant par les familles des cellules
 *  - puis          par les familles des faces
 *  - puis          par les familles des sommets
 *============================================================================*/


#endif /* _ECS_MAILLAGE_PRIV_H_ */
