/*
***************************************************************************
*
* Author: Teunis van Beelen
*
* Copyright (C) 2008, 2009, 2010 Teunis van Beelen
*
* teuniz@gmail.com
*
***************************************************************************
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation version 2 of the License.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
***************************************************************************
*
* This version of GPL is at http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
*
***************************************************************************
*/



#include "print_to_bdf.h"


#if defined(__APPLE__) || defined(__MACH__) || defined(__APPLE_CC__)

#define fseeko fseek
#define ftello ftell
#define fopeno fopen

#else

#define fseeko fseeko64
#define ftello ftello64
#define fopeno fopen64

#endif





void print_screen_to_bdf(UI_Mainwindow *mainwindow)
{
  int i, j, k, p,
      n=0,
      records,
      records_written,
      signalcomps,
      duration_factor[MAXFILES],
      temp=0,
      dig_value,
      bdfplus=0,
      tallen,
      annotationlist_nr=0,
      annotations_left=1,
      add_one_sec=0,
      add_one_sec_advanced=0,
      annot_smp_per_record=16,
      type,
      len;

  long long duration,
            smpls_written[MAXSIGNALS],
            s2,
            preamble=0,
            smpls_preamble[MAXSIGNALS],
            taltime=0,
            l_temp,
            referencetime;

  char path[1024],
       scratchpad[512],
       datrecduration[8],
       *viewbuf;

  double frequency,
         frequency2;

  FILE *outputfile;


  struct signalcompblock **signalcomp;

  union {
          signed int one_signed;
          signed short two_signed[2];
          unsigned char four[4];
        } wr_var;

  union {
          signed int one_signed;
          signed short two_signed[2];
          unsigned char four[4];
        } null_bytes[MAXSIGNALS];

  union {
          unsigned int one;
          signed int one_signed;
          unsigned short two[2];
          signed short two_signed[2];
          unsigned char four[4];
        } var;

struct annotationblock *annotations_pntr;

struct date_time_struct date_time;

/////////////////////////////////////////////////////////////////////////

  signalcomps = mainwindow->signalcomps;
  signalcomp = mainwindow->signalcomp;
  viewbuf = mainwindow->viewbuf;

  annotations_pntr = mainwindow->annotationlist[0];

  if((!mainwindow->files_open)||(!signalcomps))
  {
    UI_Messagewindow popuperror("Print to BDF", "Put a signal on the screen and try again.");
    return;
  }

  for(i=0; i<mainwindow->files_open; i++)
  {
    if(mainwindow->edfheaderlist[i]->discontinuous)
    {
      UI_Messagewindow popuperror("Print to BDF", "Sorry, discontinues BDF/EDF files can not be printed to BDF.\n");
      return;
    }

    if(mainwindow->edfheaderlist[i]->edfplus || mainwindow->edfheaderlist[i]->bdfplus)
    {
      bdfplus = 1;

      for(j=0; j<mainwindow->edfheaderlist[i]->nr_annot_chns; j++)
      {
        if(mainwindow->edfheaderlist[i]->edfparam[mainwindow->edfheaderlist[i]->annot_ch[j]].smp_per_record>annot_smp_per_record)
        {
          annot_smp_per_record = mainwindow->edfheaderlist[i]->edfparam[mainwindow->edfheaderlist[i]->annot_ch[j]].smp_per_record;
        }
      }
    }
  }

  annot_smp_per_record += 11;

  taltime = mainwindow->edfheaderlist[mainwindow->sel_viewtime]->starttime_offset;

  duration = 0;

  for(i=0; i<signalcomps; i++)
  {
    if(signalcomp[i]->edfhdr->long_data_record_duration>duration)
    {
      duration = signalcomp[i]->edfhdr->long_data_record_duration;
      n = i;
    }
  }

  fseeko(signalcomp[n]->edfhdr->file_hdl, 244LL, SEEK_SET);
  if(fread(datrecduration, 8, 1, signalcomp[n]->edfhdr->file_hdl)!=1)
  {
    UI_Messagewindow popuperror("Print to BDF", "Error while reading from inputfile.");
    return;
  }

  temp = 0;

  for(i=0; i<signalcomps; i++)
  {
    if(duration % signalcomp[i]->edfhdr->long_data_record_duration)
    {
      UI_Messagewindow popuperror("Print to BDF", "This combination of files can not be printed to EDF\n"
                                  "because the quotient of the datarecordblock durations is not an integer.");
      return;
    }

    duration_factor[signalcomp[i]->filenum] = duration / signalcomp[i]->edfhdr->long_data_record_duration;

    temp += signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].smp_per_record;
  }

  path[0] = 0;
  if(mainwindow->recent_savedir[0]!=0)
  {
    strcpy(path, mainwindow->recent_savedir);
    strcat(path, "/");
  }
  len = strlen(path);
  get_filename_from_path(path + len, mainwindow->edfheaderlist[mainwindow->sel_viewtime]->filename, 1024 - len);
  remove_extension_from_filename(path);
  strcat(path, "_screenprint.bdf");

  strcpy(path, QFileDialog::getSaveFileName(0, "Print to BDF", path, "BDF files (*.bdf *.BDF)").toLatin1().data());

  if(!strcmp(path, ""))
  {
    return;
  }

  get_directory_from_path(mainwindow->recent_savedir, path, 1024);

  if(mainwindow->file_is_opened(path))
  {
    UI_Messagewindow popuperror("Print to BDF", "Error, selected file is in use.");
    return;
  }

  outputfile = fopeno(path, "wb");
  if(outputfile==NULL)
  {
    UI_Messagewindow popuperror("Print to BDF", "Error, can not create a file for writing.");
    return;
  }

  referencetime = mainwindow->edfheaderlist[mainwindow->sel_viewtime]->utc_starttime;

  if(mainwindow->edfheaderlist[mainwindow->sel_viewtime]->viewtime<0)
  {
    if((-mainwindow->edfheaderlist[mainwindow->sel_viewtime]->viewtime) % TIME_DIMENSION)
    {
      preamble = TIME_DIMENSION - ((-mainwindow->edfheaderlist[mainwindow->sel_viewtime]->viewtime) % TIME_DIMENSION);

      referencetime--;

      add_one_sec = 1;

      add_one_sec_advanced = 1;
    }
  }
  else
  {
    preamble = mainwindow->edfheaderlist[mainwindow->sel_viewtime]->viewtime % TIME_DIMENSION;

    if(preamble)  add_one_sec = 1;
  }

  referencetime += (mainwindow->edfheaderlist[mainwindow->sel_viewtime]->viewtime / TIME_DIMENSION);

  utc_to_date_time(referencetime, &date_time);

/************************* write BDF-header ***************************************/

  fseeko(mainwindow->edfheaderlist[mainwindow->sel_viewtime]->file_hdl, 8LL, SEEK_SET);

  rewind(outputfile);

  if(bdfplus)
  {
    fputc(255, outputfile);
    fprintf(outputfile, "BIOSEMI");
    if(mainwindow->edfheaderlist[mainwindow->sel_viewtime]->edfplus || mainwindow->edfheaderlist[mainwindow->sel_viewtime]->bdfplus)
    {
      if(fread(scratchpad, 80, 1, mainwindow->edfheaderlist[mainwindow->sel_viewtime]->file_hdl)!=1)
      {
        UI_Messagewindow popuperror("Print to BDF", "Error while reading from inputfile.");
        fclose(outputfile);
        return;
      }

      if(fwrite(scratchpad, 80, 1, outputfile)!=1)
      {
        UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
        fclose(outputfile);
        return;
      }
    }
    else
    {
      fprintf(outputfile, "X X X X ");
      if(fread(scratchpad, 80, 1, mainwindow->edfheaderlist[mainwindow->sel_viewtime]->file_hdl)!=1)
      {
        UI_Messagewindow popuperror("Print to BDF", "Error while reading from inputfile.");
        fclose(outputfile);
        return;
      }

      if(fwrite(scratchpad, 72, 1, outputfile)!=1)
      {
        UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
        fclose(outputfile);
        return;
      }
    }

    fprintf(outputfile, "Startdate %02i-", date_time.day);

    switch(date_time.month)
    {
      case  1 : fprintf(outputfile, "JAN");
                break;
      case  2 : fprintf(outputfile, "FEB");
                break;
      case  3 : fprintf(outputfile, "MAR");
                break;
      case  4 : fprintf(outputfile, "APR");
                break;
      case  5 : fprintf(outputfile, "MAY");
                break;
      case  6 : fprintf(outputfile, "JUN");
                break;
      case  7 : fprintf(outputfile, "JUL");
                break;
      case  8 : fprintf(outputfile, "AUG");
                break;
      case  9 : fprintf(outputfile, "SEP");
                break;
      case 10 : fprintf(outputfile, "OCT");
                break;
      case 11 : fprintf(outputfile, "NOV");
                break;
      case 12 : fprintf(outputfile, "DEC");
                break;
      default : fprintf(outputfile, "ERR");
                break;
    }

    fprintf(outputfile, "-%04i ", date_time.year);

    if(mainwindow->edfheaderlist[mainwindow->sel_viewtime]->edfplus || mainwindow->edfheaderlist[mainwindow->sel_viewtime]->bdfplus)
    {
      if(fread(scratchpad, 80, 1, mainwindow->edfheaderlist[mainwindow->sel_viewtime]->file_hdl)!=1)
      {
        UI_Messagewindow popuperror("Print to BDF", "Error while reading from inputfile.");
        fclose(outputfile);
        return;
      }

      if(scratchpad[10]=='X')
      {
        if(fwrite(scratchpad + 12, 58, 1, outputfile)!=1)
        {
          UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
          fclose(outputfile);
          return;
        }
      }
      else
      {
        if(fwrite(scratchpad + 22, 58, 1, outputfile)!=1)
        {
          UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
          fclose(outputfile);
          return;
        }
      }
    }
    else
    {
      fprintf(outputfile, "X X X ");

      if(fread(scratchpad, 80, 1, mainwindow->edfheaderlist[mainwindow->sel_viewtime]->file_hdl)!=1)
      {
        UI_Messagewindow popuperror("Print to BDF", "Error while reading from inputfile.");
        fclose(outputfile);
        return;
      }

      if(fwrite(scratchpad + 28, 52, 1, outputfile)!=1)
      {
        UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
        fclose(outputfile);
        return;
      }
    }
  }
  else
  {
    if(fread(scratchpad, 160, 1, mainwindow->edfheaderlist[mainwindow->sel_viewtime]->file_hdl)!=1)
    {
      UI_Messagewindow popuperror("Print to BDF", "Error while reading from inputfile.");
      fclose(outputfile);
      return;
    }

    fputc(255, outputfile);

    fprintf(outputfile, "BIOSEMI");

    if(fwrite(scratchpad, 160, 1, outputfile)!=1)
    {
      UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
      fclose(outputfile);
      return;
    }
  }

  fprintf(outputfile,
          "%02i.%02i.%02i%02i.%02i.%02i",
          date_time.day,
          date_time.month,
          date_time.year % 100,
          date_time.hour,
          date_time.minute,
          date_time.second);

  fprintf(outputfile, "%-8i", (signalcomps + bdfplus) * 256 + 256);

  if(bdfplus)
  {
    fprintf(outputfile, "BDF+C");

    for(i=0; i<39; i++)  fputc(' ', outputfile);
  }
  else
  {
    for(i=0; i<44; i++)  fputc(' ', outputfile);
  }

  records = (int)(mainwindow->pagetime / duration);

  if(add_one_sec)
  {
    records += TIME_DIMENSION / duration;
  }

  fprintf(outputfile, "%-8i", records);

  if(fwrite(datrecduration, 8, 1, outputfile)!=1)
  {
    UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
    fclose(outputfile);
    return;
  }

  fprintf(outputfile, "%-4i", signalcomps + bdfplus);

  for(i=0; i<signalcomps; i++)
  {
    if(strncmp(signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].label, "EEG ", 4))
    {
      strcpy(scratchpad, signalcomp[i]->signallabel);
    }
    else
    {
      strcpy(scratchpad, "EEG ");
      strcat(scratchpad, signalcomp[i]->signallabel);
    }
    strcat(scratchpad, "                ");
    if(fwrite(scratchpad, 16, 1, outputfile)!=1)
    {
      UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
      fclose(outputfile);
      return;
    }
  }

  if(bdfplus)
  {
    if(fwrite("BDF Annotations ", 16, 1, outputfile)!=1)
    {
      UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
      fclose(outputfile);
      return;
    }
  }

  for(i=0; i<signalcomps; i++)
  {
    if(fwrite(signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].transducer, 80, 1, outputfile)!=1)
    {
      UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
      fclose(outputfile);
      return;
    }
  }

  if(bdfplus)
  {
    for(i=0; i<80; i++)  fputc(' ', outputfile);
  }

  for(i=0; i<signalcomps; i++)
  {
    if(fwrite(signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].physdimension, 8, 1, outputfile)!=1)
    {
      UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
      fclose(outputfile);
      return;
    }
  }

  if(bdfplus)
  {
    for(i=0; i<8; i++)  fputc(' ', outputfile);
  }

  for(i=0; i<signalcomps; i++)
  {
    fseeko(signalcomp[i]->edfhdr->file_hdl, (long long)((signalcomp[i]->edfsignal[0] * 8) + (104 * signalcomp[i]->edfhdr->edfsignals) + 256), SEEK_SET);
    if(fread(scratchpad, 8, 1, signalcomp[i]->edfhdr->file_hdl)!=1)
    {
      UI_Messagewindow popuperror("Print to BDF", "Error while reading from inputfile.");
      fclose(outputfile);
      return;
    }
    if(fwrite(scratchpad, 8, 1, outputfile)!=1)
    {
      UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
      fclose(outputfile);
      return;
    }
  }

  if(bdfplus)
  {
    if(fwrite("-1      ", 8, 1, outputfile)!=1)
    {
      UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
      fclose(outputfile);
      return;
    }
  }

  for(i=0; i<signalcomps; i++)
  {
    fseeko(signalcomp[i]->edfhdr->file_hdl, (long long)((signalcomp[i]->edfsignal[0] * 8) + (112 * signalcomp[i]->edfhdr->edfsignals) + 256), SEEK_SET);
    if(fread(scratchpad, 8, 1, signalcomp[i]->edfhdr->file_hdl)!=1)
    {
      UI_Messagewindow popuperror("Print to BDF", "Error while reading from inputfile.");
      fclose(outputfile);
      return;
    }
    if(fwrite(scratchpad, 8, 1, outputfile)!=1)
    {
      UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
      fclose(outputfile);
      return;
    }
  }

  if(bdfplus)
  {
    if(fwrite("1       ", 8, 1, outputfile)!=1)
    {
      UI_Messagewindow popuperror("Print to EDF", "Error while writing to outputfile.");
      fclose(outputfile);
      return;
    }
  }

  for(i=0; i<signalcomps; i++)
  {
    fprintf(outputfile, "%-8i", signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].dig_min);

    if(signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].dig_min<0)
    {
      null_bytes[i].one_signed = 0;
    }
    else
    {
      null_bytes[i].one_signed = signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].dig_min;
    }
  }

  if(bdfplus)
  {
    if(fwrite("-8388608", 8, 1, outputfile)!=1)
    {
      UI_Messagewindow popuperror("Print to EDF", "Error while writing to outputfile.");
      fclose(outputfile);
      return;
    }
  }

  for(i=0; i<signalcomps; i++)
  {
    fprintf(outputfile, "%-8i", signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].dig_max);
  }

  if(bdfplus)
  {
    if(fwrite("8388607 ", 8, 1, outputfile)!=1)
    {
      UI_Messagewindow popuperror("Print to EDF", "Error while writing to outputfile.");
      fclose(outputfile);
      return;
    }
  }

  for(i=0; i<signalcomps; i++)
  {
    strcpy(scratchpad, signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].prefilter);
    strcat(scratchpad, "                                                                                ");
    for(p = strlen(scratchpad) - 1; p>=0; p--)
    {
      if(scratchpad[p]!=' ')  break;
    }
    p++;
    if(p) p++;

    for(j=0; j<signalcomp[i]->filter_cnt; j++)
    {
      if(signalcomp[i]->filter[j]->is_LPF == 1)
      {
        p += sprintf(scratchpad + p, "LP:%f", signalcomp[i]->filter[j]->cutoff_frequency);
      }

      if(signalcomp[i]->filter[j]->is_LPF == 0)
      {
        p += sprintf(scratchpad + p, "HP:%f", signalcomp[i]->filter[j]->cutoff_frequency);
      }

      for(k=(p-1); k>0; k--)
      {
        if(scratchpad[k]!='0')  break;
      }

      if(scratchpad[k]=='.')  scratchpad[k] = 0;
      else  scratchpad[k+1] = 0;

      strcat(scratchpad, "Hz ");

      p = strlen(scratchpad);

      if(p>80)  break;
    }

    for(j=0; j<signalcomp[i]->fidfilter_cnt; j++)
    {
      type = signalcomp[i]->fidfilter_type[j];

      frequency = signalcomp[i]->fidfilter_freq[j];

      frequency2 = signalcomp[i]->fidfilter_freq2[j];

      if(type == 0)
      {
        p += sprintf(scratchpad + p, "HP:%f", frequency);
      }

      if(type == 1)
      {
        p += sprintf(scratchpad + p, "LP:%f", frequency);
      }

      if(type == 2)
      {
        p += sprintf(scratchpad + p, "N:%f", frequency);
      }

      if(type == 3)
      {
        p += sprintf(scratchpad + p, "BP:%f", frequency);
      }

      if(type == 4)
      {
        p += sprintf(scratchpad + p, "BS:%f", frequency);
      }

      for(k=(p-1); k>0; k--)
      {
        if(scratchpad[k]!='0')  break;
      }

      if(scratchpad[k]=='.')  scratchpad[k] = 0;
      else  scratchpad[k+1] = 0;

      p = strlen(scratchpad);

      if((type == 3) || (type == 4))
      {
        p += sprintf(scratchpad + p, "-%f", frequency2);

        for(k=(p-1); k>0; k--)
        {
          if(scratchpad[k]!='0')  break;
        }

        if(scratchpad[k]=='.')  scratchpad[k] = 0;
        else  scratchpad[k+1] = 0;
      }

      strcat(scratchpad, "Hz ");

      p = strlen(scratchpad);

      if(p>80)  break;
    }

    for(;p<81; p++)
    {
      scratchpad[p] = ' ';
    }

    if(fwrite(scratchpad, 80, 1, outputfile)!=1)
    {
      UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
      fclose(outputfile);
      return;
    }
  }

  if(bdfplus)
  {
    for(i=0; i<80; i++)  fputc(' ', outputfile);
  }

  for(i=0; i<signalcomps; i++)
  {
    fprintf(outputfile, "%-8i", signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].smp_per_record
     * duration_factor[signalcomp[i]->filenum]);
  }

  if(bdfplus)
  {
    fprintf(outputfile, "%-8i", annot_smp_per_record);
  }

  for(i=0; i<signalcomps; i++)
  {
    for(j=0; j<32; j++)  fputc(' ', outputfile);
  }

  if(bdfplus)
  {
    for(i=0; i<32; i++)  fputc(' ', outputfile);
  }

/////////////////////////////////////////////////////////////////////

  for(i=0; i<MAXSIGNALS; i++)  smpls_written[i] = 0;

  mainwindow->print_to_edf_active = 1;

  mainwindow->setup_viewbuf();

  viewbuf = mainwindow->viewbuf;

  if(viewbuf==NULL)
  {
    fclose(outputfile);
    return;
  }

  for(i=0; i<signalcomps; i++)
  {
    smpls_preamble[i] = preamble / (signalcomp[i]->edfhdr->long_data_record_duration / signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].smp_per_record);
  }

  QApplication::setOverrideCursor(Qt::WaitCursor);

  for(records_written=0; records_written<records; records_written++)
  {
    qApp->processEvents();

    for(i=0; i<signalcomps; i++)
    {
      for(k=0; k<signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].smp_per_record * duration_factor[signalcomp[i]->filenum]; k++)
      {
        if(smpls_preamble[i])
        {
          smpls_preamble[i]--;

          fputc(null_bytes[i].four[0], outputfile);
          fputc(null_bytes[i].four[1], outputfile);
          if(fputc(null_bytes[i].four[2], outputfile)==EOF)
          {
            QApplication::restoreOverrideCursor();
            UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
            fclose(outputfile);
            return;
          }
        }
        else
        {
          dig_value = 0;

          s2 = smpls_written[i] + signalcomp[i]->sample_timeoffset - signalcomp[i]->sample_start;

          for(j=0; j<signalcomp[i]->num_of_signals; j++)
          {
            if((smpls_written[i]<signalcomp[i]->sample_stop)&&(s2>=0))
            {
              if(signalcomp[i]->edfhdr->bdf)
              {
                var.two[0] = *((unsigned short *)(
                  viewbuf
                  + signalcomp[i]->viewbufoffset
                  + (signalcomp[i]->edfhdr->recordsize * (s2 / signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[j]].smp_per_record))
                  + signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[j]].buf_offset
                  + ((s2 % signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[j]].smp_per_record) * 3)));

                var.four[2] = *((unsigned char *)(
                  viewbuf
                  + signalcomp[i]->viewbufoffset
                  + (signalcomp[i]->edfhdr->recordsize * (s2 / signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[j]].smp_per_record))
                  + signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[j]].buf_offset
                  + ((s2 % signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[j]].smp_per_record) * 3)
                  + 2));

                if(var.four[2]&0x80)
                {
                  var.four[3] = 0xff;
                }
                else
                {
                  var.four[3] = 0x00;
                }

                temp = var.one_signed;
              }

              if(signalcomp[i]->edfhdr->edf)
              {
                temp = *(((short *)(
                  viewbuf
                  + signalcomp[i]->viewbufoffset
                  + (signalcomp[i]->edfhdr->recordsize * (s2 / signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[j]].smp_per_record))
                  + signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[j]].buf_offset))
                  + (s2 % signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[j]].smp_per_record));
              }

              temp += signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[j]].offset;
              temp *= signalcomp[i]->factor[j];

              temp -= signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[j]].offset;
            }
            else
            {
              temp = 0;
            }

            dig_value += temp;
          }

          for(p=0; p<signalcomp[i]->filter_cnt; p++)
          {
            if(smpls_written[i]==signalcomp[i]->sample_start)
            {
              if(mainwindow->edfheaderlist[signalcomp[i]->filenum]->viewtime==0)
              {
                reset_filter(dig_value, signalcomp[i]->filter[p]);
              }
              else
              {
                signalcomp[i]->filter[p]->old_input = signalcomp[i]->filterpreset_a[p];
                signalcomp[i]->filter[p]->old_output = signalcomp[i]->filterpreset_b[p];
              }
            }

            dig_value = first_order_filter(dig_value, signalcomp[i]->filter[p]);
          }

          for(p=0; p<signalcomp[i]->fidfilter_cnt; p++)
          {
            if(smpls_written[i]==signalcomp[i]->sample_start)
            {
              if(mainwindow->edfheaderlist[signalcomp[i]->filenum]->viewtime!=0)
              {
                memcpy(signalcomp[i]->fidbuf[p], signalcomp[i]->fidbuf2[p], fid_run_bufsize(signalcomp[i]->fid_run[p]));
              }
            }

            dig_value = signalcomp[i]->fidfuncp[p](signalcomp[i]->fidbuf[p], dig_value);
          }

          if((smpls_written[i]>=signalcomp[i]->sample_start)&&(smpls_written[i]<signalcomp[i]->sample_stop))
          {
            if(dig_value>signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].dig_max)
            {
              dig_value = signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].dig_max;
            }
            if(dig_value<signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].dig_min)
            {
              dig_value = signalcomp[i]->edfhdr->edfparam[signalcomp[i]->edfsignal[0]].dig_min;
            }

            wr_var.one_signed = dig_value;
            fputc(wr_var.four[0], outputfile);
            fputc(wr_var.four[1], outputfile);
            if(fputc(wr_var.four[2], outputfile)==EOF)
            {
              QApplication::restoreOverrideCursor();
              UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
              fclose(outputfile);
              return;
            }
          }
          else
          {
            fputc(null_bytes[i].four[0], outputfile);
            fputc(null_bytes[i].four[1], outputfile);
            if(fputc(null_bytes[i].four[2], outputfile)==EOF)
            {
              QApplication::restoreOverrideCursor();
              UI_Messagewindow popuperror("Print to BDF", "Error while writing to outputfile.");
              fclose(outputfile);
              return;
            }
          }

          smpls_written[i]++;
        }
      }
    }

    if(bdfplus)
    {
      tallen = fprintf(outputfile, "+%i.%07i",
      (int)(taltime / TIME_DIMENSION),
      (int)(taltime % TIME_DIMENSION));

      fputc(20, outputfile);
      fputc(20, outputfile);
      fputc(0, outputfile);

      tallen += 3;

      while(annotations_left)
      {
        while(!annotations_pntr)
        {
          annotationlist_nr++;
          if(annotationlist_nr>=mainwindow->files_open)
          {
            annotations_left = 0;
            annotations_pntr = NULL;

            break;
          }
          annotations_pntr = mainwindow->annotationlist[annotationlist_nr];
        }

        if(!annotations_left)  break;

        if(annotations_pntr)
        {
          l_temp = annotations_pntr->onset - mainwindow->edfheaderlist[annotationlist_nr]->viewtime;

          l_temp += (mainwindow->edfheaderlist[mainwindow->sel_viewtime]->viewtime%TIME_DIMENSION);

          if((mainwindow->edfheaderlist[mainwindow->sel_viewtime]->viewtime<0)&&(mainwindow->edfheaderlist[mainwindow->sel_viewtime]->viewtime%TIME_DIMENSION))
          {
            l_temp += TIME_DIMENSION;
          }

          if(annotationlist_nr!=mainwindow->sel_viewtime)
          {
            l_temp -= mainwindow->edfheaderlist[annotationlist_nr]->starttime_offset;
          }

          if((l_temp>=0)&&(l_temp<=mainwindow->pagetime))
          {
            tallen += fprintf(outputfile, "%+i.%07i",
            (int)(l_temp / TIME_DIMENSION),
            (int)(l_temp % TIME_DIMENSION));

            if(annotations_pntr->duration[0]!=0)
            {
              fputc(21, outputfile);
              tallen++;

              tallen += fprintf(outputfile, "%s", annotations_pntr->duration);
            }

            fputc(20, outputfile);
            tallen++;

            tallen += fprintf(outputfile, "%s", annotations_pntr->annotation);

            fputc(20, outputfile);
            fputc(0, outputfile);
            tallen += 2;

            annotations_pntr = annotations_pntr->next_annotation;

            break;
          }
          else
          {
            annotations_pntr = annotations_pntr->next_annotation;

            continue;
          }
        }
      }

      for(j=tallen; j<(annot_smp_per_record * 3); j++)
      {
        fputc(0, outputfile);
      }

      taltime += duration;
    }
  }

  QApplication::restoreOverrideCursor();

  fclose(outputfile);
}























