/* This file is part of EdiTeX, an editor of mathematical
 * expressions based on TeX syntax.
 * 
 * Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
 *                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project's home page
 * http://helm.cs.unibo.it/editex/
 * or send an email to <lpadovan@cs.unibo.it>
 */

#include <config.h>
#include <cassert>

#include "dom.hh"
#include "timer.hh"
#include "Diff.hh"
#include "TNode.hh"
#include "TDocument.hh"
#include "CMathMLFactoryXSLTDiff.hh"
#include "AMathMLConsumer.hh"

CMathMLFactoryXSLTDiff::CMathMLFactoryXSLTDiff(ALogger& l, const DOMX::XSLTStylesheet& s)
  : AMathMLFactory(l), style(s)
{
  DOM::DOMImplementation di;
  DOM::DocumentType dt;
  result = di.createDocument(MATHML_NS_URI, "m:math", dt);
}

void
CMathMLFactoryXSLTDiff::documentModified(TDocument& doc)
{
#if 0
  std::vector< std::pair<DOM::GdomeString, DOM::GdomeString> > dirtyId;
  if (TNode dirty = doc.dirtyNode()) 
    if (false && result.get_documentElement().hasAttribute("xref"))
      dirtyId.push_back(std::make_pair(DOM::GdomeString("id"),
				       DOM::GdomeString("'" + std::string(dirty["id"]) + "'")));
#endif
  long t0 = getTimer();
  DOM::Document res = style.apply(doc.document());
  long t1 = getTimer();
  assert(res);
  //cout << "*** THE TEX DOCUMENT" << endl;
  //style.save(doc.document(), stdout);
  //std::cout << "*** THE CURRENT DOCUMENT:" << std::endl;
  //if (result) style.save(result, stdout);
  //std::cout << "*** THE NEW DOCUMENT:" << std::endl;
  //style.save(res, stdout);
  //std::cout << "*** THE DIFF:" << std::endl;
  DOMX::Diff diff = DOMX::Diff::diff(result, res);
  //style.save(diff.document(), stdout);
  long t2 = getTimer();
  diff.patch();
  long t3 = getTimer();

  //std::cout << "=== APPLY = " << (t1 - t0) / 1000 << " DIFF = " << (t2 - t1) / 1000 << " PATCH = " << (t3 - t2) / 1000 << std::endl;

  doc.clearDirty();
}

bool
CMathMLFactoryXSLTDiff::subst(const DOM::Element& e1, const DOM::GdomeString& id, const DOM::Element& e2)
{
  assert(e1);
  assert(e2);
  if (e1.getAttribute("xref") == id)
    {
      DOMX::Diff diff = DOMX::Diff::diff(e1, e2);
      //style.save(diff.document(), stdout);
      diff.patch();
      return true;
    }
  else
    {
      DOM::Node p = e1.get_firstChild();
      while (p)
	{
	  while (p && p.get_nodeType() != DOM::Node::ELEMENT_NODE) p = p.get_nextSibling();
	  if (p)
	    if (subst(p, id, e2)) return true;
	    else p = p.get_nextSibling();
	}
      return false;
    }
}

