/*
Copyright (C) 2000-2002 Jos Roberto B. de A. Monteiro <jrm@autsens.com>
                        and Pedro Zorzenon Neto <pzn@autsens.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Do not forget to visit Free Software Foundation site: http://fsf.org

$Id: intelhex.h,v 1.2 2003/06/30 17:20:25 pzn Exp $
*/

#ifndef _INTELHEX_H
#define _INTELHEX_H

#include <stdio.h>

/*
 defining type 'inteldata':
  offset is the address offset
  datalen is the actual number of elements in data
  file is a pointer to the file/stream
  eof_found is set to 1 when :00000001FF if found (endoffile)
  */
typedef struct {
    unsigned char recdata[256];
    unsigned int offset;
    unsigned int reclen;
    FILE * file;
    int eof_found;
} inteldata;

/* mode = 1 -> open file for reading
 *        0 -> creates a new file for writing
 *
 * returns always 1. aborts the program if could not open file */
int intelhex_fileopen (inteldata *id, char *filename, int mode);

int intelhex_fileclose (inteldata *id);

/* intelhex_readline returns:
 1  = successfull read - data available
 0  = successfull read - eof_record found
      or did't read because eof_record had already been found
 >1 = unsuccessfull read, error sent to stdout
*/
int intelhex_readline (inteldata *id);

/* put data in inteldata->recdata
   put datalength in inteldata->reclen
   put load offset in inteldata->offset
   then execute intelhex_writeline instruction
*/
int intelhex_writeline (inteldata *id);

/* writes an eof record in the file */
void intelhex_writeeof (inteldata *id);

/* Usage example:

 *   READING AN INTELHEX FILE:

  inteldata ihex;
  int i;
  intelhex_fileopen ( &ihex, "filename.hex", 1);
  while ( intelhex_readline (&ihex)==1 ) {
    for (i=0; i<ihex.reclen; i++) {
      printf("Addr:%04X Value:%02X\n", ihex.offset+i, (int) ihex.recdata[i]);
    }
  }
  intelhex_fileclose (&ihex);

  *   WRITING AN INTELHEX FILE:

  inteldata ihex;
  int reclen=0x10;
  int size=16384, i, j;
  unsigned char mydata[16384];
  // take care... in this example size is multiple of reclen
  // you must take extra caution when it is not multiple
  intelhex_fileopen ( &ihex, "filename.hex", 0);
  for (i=0; i<size; i+=reclen) {
    ihex.offset=i;
    ihex.reclen=reclen;
    for (j=0; j<reclen; j++) {
      ihex.recdata[j]=mydata[i+j];
      printf("Addr:%04X Value:%02X\n", i+j, (int) ihex.recdata[j]);
    }
    intelhex_writeline (&ihex);
  }
  intelhex_writeeof (&ihex);
  intelhex_fileclose (&ihex);

  */

#endif
