/*
Copyright (C) 2002 Pedro Zorzenon Neto <pzn@autsens.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Do not forget to visit Free Software Foundation site: http://fsf.org

$Id: memory.h,v 1.2 2003/06/30 17:20:25 pzn Exp $
*/
#ifndef _MEMORY_H
#define _MEMORY_H

typedef struct memory {
  unsigned long int size;
  int * data;
} memory_t;

memory_t * memory_init(unsigned long int size);
void memory_destroy(memory_t* self);
void memory_fill (memory_t* self, int value);
int memory_read(memory_t* self, unsigned int addr);
void memory_write (memory_t* self, unsigned int addr, int value);
int memory_compare (memory_t* mem1, memory_t* mem2);

#endif
