/* Copyright (C) 2001 2002 2003 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef ADDRESSBOOK_H
#define ADDRESSBOOK_H

#include "prog_defs.h"

#include <vector>

#include <gtkmm/window.h>
#include <gtkmm/table.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/treeview.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treemodelcolumn.h>
#include <gtkmm/liststore.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/box.h>
#include <gtkmm/entry.h>
#include <gtkmm/label.h>
#include <gtkmm/tooltips.h>


class AddressListModelColumns: public Gtk::TreeModel::ColumnRecord {
  Gtk::TreeModelColumn<Glib::ustring> name;
  Gtk::TreeModelColumn<Glib::ustring> number;
  // private constructor - only Addressbook can create objects of this class
  AddressListModelColumns(void) {add(name); add(number);}
public:
  friend class AddressBook;
};

class AddressBook: public Gtk::Window {

  static int is_address_list;
  const int standard_size;
  Gtk::Window& parent;
  bool in_run_loop;
  Gtk::Table table;
  Gtk::Table list_table;
  Gtk::ScrolledWindow address_list_scroll_window;
  Gtk::Button add_button;
  Gtk::Button delete_button;
  Gtk::Button up_button;
  Gtk::Button down_button;
  Gtk::Button ok_button;
  Gtk::Button cancel_button;
  Gtk::HButtonBox button_box;
  AddressListModelColumns model_columns;
  Gtk::TreeView tree_view;
  Glib::RefPtr<Gtk::ListStore> list_store_r;
  Gtk::Tooltips tooltips;
  Glib::ustring result;
  void read_list(void);
  void save_list(void);
  void ok_slot(void);
  void finish(void);
  Glib::ustring get_number(void);
  void add_address_prompt(void);
  void add_address(const std::vector<Glib::ustring>& address);
  void delete_address_prompt(void);
  void delete_address(Gtk::TreeModel::iterator);
  void move_up(void);
  void move_down(void);

protected:
  virtual bool on_delete_event(GdkEventAny*);
public:
  SigC::Signal1<void, const Glib::ustring&> accepted;

  static int get_is_address_list(void) {return is_address_list;}
  Glib::ustring run(void);

  AddressBook(const int standard_size, Gtk::Window& window);
  ~AddressBook(void);
};

class AddressDialog: public Gtk::Window {

  bool in_run_loop;
  Gtk::Button ok_button;
  Gtk::Button cancel_button;
  Gtk::HButtonBox button_box;
  Gtk::HBox name_box;
  Gtk::HBox number_box;
  Gtk::Label name_label;
  Gtk::Label number_label;
  Gtk::Entry name_entry;
  Gtk::Entry number_entry;
  Gtk::Table table;
  Gtk::Window& parent;
protected:
  virtual bool on_delete_event(GdkEventAny*);
  virtual bool on_key_press_event(GdkEventKey*);
public:
  void selected(bool);
  SigC::Signal1<void, const std::vector<Glib::ustring>&> accepted;
  void run(void);
  AddressDialog(const int standard_size, Gtk::Window& window);
};

#endif
