/* Copyright (C) 2001 2002 2003 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef HELPFILE_H
#define HELPFILE_H

#include "prog_defs.h"

#include <gtkmm/window.h>
#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/textview.h>
#include <gtkmm/notebook.h>


class HelpEditor: public Gtk::TextView {
private:
  HelpEditor(void) {} // private class
                      // only HelpDialog can create an object
  friend class HelpDialog;
};

class HelpDialog: public Gtk::Window {
  HelpEditor sending_editbox;
  HelpEditor receiving_editbox;
  HelpEditor addressbook_editbox;
  HelpEditor fax_list_editbox;
  HelpEditor settings_editbox;

  Gtk::ScrolledWindow sending_scrolled_window;
  Gtk::ScrolledWindow receiving_scrolled_window;
  Gtk::ScrolledWindow addressbook_scrolled_window;
  Gtk::ScrolledWindow fax_list_scrolled_window;
  Gtk::ScrolledWindow settings_scrolled_window;

  Gtk::Button close_button;
  Gtk::HButtonBox button_box;
  Gtk::VBox vbox;
  Gtk::Notebook notebook;
  
  const char* get_sending_help(void);
  const char* get_receiving_help(void);
  const char* get_addressbook_help(void);
  const char* get_fax_list_help(void);
  const char* get_settings_help(void);

protected:
  virtual bool on_delete_event(GdkEventAny*);
  virtual bool on_key_press_event(GdkEventKey*);
public:
  void kill_dialog(void);
  HelpDialog(const int size);
};

#endif
