/* Copyright (C) 2001 2002 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef SETTINGS_HELP_H
#define SETTINGS_HELP_H

#include "prog_defs.h"

#include <vector>

#include <gtkmm/window.h>
#include <gtkmm/label.h>
#include <gtkmm/table.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>



class SettingsMessagesBase {

protected:
  // so some people don't like protected data -- tough, this
  // is a convenient implementation
  std::vector<Glib::ustring> captions;
  std::vector<Glib::ustring> messages;
public:
  Glib::ustring get_caption(std::vector<Glib::ustring>::size_type);
  Glib::ustring get_message(std::vector<Glib::ustring>::size_type);
  SettingsMessagesBase(std::vector<Glib::ustring>::size_type size): captions(size), messages(size) {}
};

class IdentityMessages: public SettingsMessagesBase {
public:
  enum {name = 0, number};
  IdentityMessages(void);
};

class ModemMessages: public SettingsMessagesBase {
public:
  enum {device = 0, lock, modem_class, dialmode, capabilities, rings};
  ModemMessages(void);
};

class ParmsMessages: public SettingsMessagesBase {
public:
  enum {init = 0, reset, extra_parms};
  ParmsMessages(void);
};

class PrintMessages: public SettingsMessagesBase {
public:
  enum {command = 0, shrink};
  PrintMessages(void);
};

class ViewMessages: public SettingsMessagesBase {
public:
  enum {ps_view_command = 0};
  ViewMessages(void);
};

class LoggingMessages: public SettingsMessagesBase {
public:
  enum {logfile = 0};
  LoggingMessages(void);
};

class PageMessages: public SettingsMessagesBase {
public:
  enum {page = 0, res};
  PageMessages(void);
};

class SettingsHelpDialog: public Gtk::Window {
  bool in_run_loop;
  Gtk::Button close_button;
  Gtk::HButtonBox button_box;
  Gtk::Label label;
  Gtk::Table table;
  Gtk::Window& parent;
  void kill_dialog(void);
protected:
  virtual bool on_delete_event(GdkEventAny*);
public:
  void run(void);
  SettingsHelpDialog(const int standard_size, const Glib::ustring& text,
		     const Glib::ustring& caption, Gtk::Window&);
};

#endif
