/* Copyright (C) 2005 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef IO_WATCH_H
#define IO_WATCH_H

/* The start_iowatch() function connects a Unix file descriptor to an
   event loop owned by a GMainContext object (normally the main
   program loop).  It saves the overhead of having to construct a
   GIOChannel object where the only thing wanted is to execute a
   callback when there is something to be read from a pipe, fifo or
   socket or a pipe or fifo can be written to.

   As this method has been written, an iowatch (WatchSource) object
   should not check for both input and output (in other words pass
   G_IO_IN or G_IO_OUT to the GIOCondition argument in
   start_iowatch(), but not a bitwise-ORed version of both).  If the
   same descriptor is used for both then there should be separate
   watches for reading and writing.  This could be changed however by
   making the callback slot take a GIOCondition argument, and sending
   the value of watch_source_p->poll_fd.revents to the callback
   function in io_watch_dispatch_func() so it can inspect it and
   decide whether the file descriptor is available for reading,
   writing or both.

   start_iowatch() returns the id of the WatchSource object (derived
   from GSource) in the main program context to which it is attached.
   The watch will be ended, and all resources connected with it
   deleted, either by the callback returning false or by calling
   g_source_remove() on the id returned by start_iowatch().
*/

#include "prog_defs.h"

#include <glib/gmain.h>
#include <glib/gtypes.h>
#include <glib/giochannel.h>

#include <sigc++/sigc++.h>

guint start_iowatch(int fd, const sigc::slot<bool>& callback,
		    GIOCondition io_condition, GMainContext* context_p = 0);

#endif
