/* Copyright (C) 2004 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef SEM_SYNC_H
#define SEM_SYNC_H

#include "prog_defs.h"

#include <semaphore.h>
#include <errno.h>

class SemSync {

  bool valid;
  sem_t sem;
public:
  
  bool is_valid(void) const {return valid;}
  int getvalue(void);
  int post(void) {return sem_post(&sem);}
  void wait(void);
  SemSync(unsigned int init_count = 0);
  ~SemSync(void);
};

inline int SemSync::getvalue(void) {
  int count;
  sem_getvalue(&sem, &count);
  return count;
}

inline void SemSync::wait(void) {

  while (sem_wait(&sem) == -1 && errno == EINTR);
}

inline SemSync::SemSync(unsigned int init_count): valid(false) {

  if(sem_init(&sem, 0, init_count) == 0) valid = true;
}

inline SemSync::~SemSync(void) {

  while (getvalue() < 1) post();
  sem_destroy(&sem);
}

#endif
