/* Copyright (C) 2005 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef UTF8_UTILS_H
#define UTF8_UTILS_H

#include "prog_defs.h"

#include <string>
#include <glib/gerror.h>

#include "shared_handle.h"

namespace Utf8 {

struct ConversionError {
  std::string message;
  ConversionError(GError* error_p): message((const char*)error_p->message) {}
};

std::string filename_from_utf8(const std::string& input);

std::string filename_to_utf8(const std::string& input); 

std::string locale_from_utf8(const std::string& input);

std::string locale_to_utf8(const std::string& input); 

inline std::string to_lower(const std::string& text) {
  GcharScopedHandle g_str_h(g_utf8_strdown(text.data(), text.size()));
  return std::string(g_str_h.get());
}

} // namespace Utf8_utils

#endif
