#& MODIF ENTETE  DATE 07/04/2009   AUTEUR COURTOIS M.COURTOIS 
# -*- coding: iso-8859-1 -*-
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS

# faire que la division soit toujours relle
from __future__ import division

__version__ = "$Name: V2_0_3_Aster $"
__Id__ = "$Id: cata.py,v 1.7.4.2 2010-06-03 08:50:35 pnoyret Exp $"

import Accas
from Accas import *
from Accas import _F
import Numeric
from math import sin,cos,tan,asin,acos,atan2,atan,sinh,cosh,tanh,exp,log,log10
from math import sqrt,pi
import ops

try:
  import aster
except:
  pass

# -----------------------------------------------------------------------------
JdC = JDC_CATA(code='ASTER',
               execmodul=None,
               regles = (AU_MOINS_UN('DEBUT','POURSUITE'),
                         AU_MOINS_UN('FIN'),
                         A_CLASSER(('DEBUT','POURSUITE'),'FIN')))
# Type le plus general
class entier   (ASSD):
   def __init__(self,valeur=None,**args):
      ASSD.__init__(self,**args)
      self.valeur=valeur

   def __adapt__(self,validator):
      if validator.name == "list":
         #validateur liste,cardinalit
         return (self,)
      elif validator.name == "type":
         #validateur type
         return validator.adapt(self.valeur or 0)
      else:
         #validateur into et valid
         return self

class reel(ASSD):
   def __init__(self,valeur=None,**args):
      ASSD.__init__(self,**args)
      self.valeur=valeur

   def __call__(self):
      return self.valeur

   def __adapt__(self,validator):
      if validator.name == "list":
         #validateur liste,cardinalit
         return (self,)
      elif validator.name == "type":
         #validateur type
         return validator.adapt(self.valeur or 0.)
      else:
         #validateur into et valid
         return self

# -----------------------------------------------------------------------------
# Type geometriques
class no  (GEOM):pass
class grno(GEOM):pass
class ma  (GEOM):pass
class grma(GEOM):pass

# -----------------------------------------------------------------------------
from SD.co_cabl_precont     import cabl_precont
from SD.co_cara_elem        import cara_elem
from SD.co_cham_mater       import cham_mater
from SD.co_char_acou        import char_acou
from SD.co_char_cine_acou   import char_cine_acou
from SD.co_char_cine_meca   import char_cine_meca
from SD.co_char_cine_ther   import char_cine_ther
from SD.co_char_meca        import char_meca
from SD.co_char_ther        import char_ther
from SD.co_compor           import compor_sdaster
from SD.co_courbe           import courbe_sdaster
from SD.co_fiss_xfem        import fiss_xfem
from SD.co_fond_fiss        import fond_fiss
from SD.co_interf_dyna_clas import interf_dyna_clas
from SD.co_gfibre           import gfibre_sdaster
from SD.co_listis           import listis_sdaster
from SD.co_melasflu         import melasflu_sdaster
from SD.co_mode_cycl        import mode_cycl
from SD.co_nume_ddl_gene    import nume_ddl_gene
from SD.co_nume_ddl         import nume_ddl_sdaster
from SD.co_sd_feti          import sd_feti_sdaster
from SD.co_spectre          import spectre_sdaster
from SD.co_surface          import surface_sdaster
from SD.co_tran_gene        import tran_gene
from SD.co_type_flui_stru   import type_flui_stru

# -----------------------------------------------------------------------------
# modeles :
from SD.co_modele      import modele_sdaster
from SD.co_modele_gene import modele_gene

# -----------------------------------------------------------------------------
# materiau
from SD.co_mater import mater_sdaster

# -----------------------------------------------------------------------------
# macro-elements :
from SD.co_macr_elem_dyna import macr_elem_dyna
from SD.co_macr_elem_stat import macr_elem_stat

# -----------------------------------------------------------------------------
# liste :
from SD.co_listr8 import listr8_sdaster

# -----------------------------------------------------------------------------
# maillage :
from SD.co_maillage  import maillage_sdaster
from SD.co_squelette import squelette

# -----------------------------------------------------------------------------
# champs
from SD.co_champ     import cham_gd_sdaster
from SD.co_cham_no   import cham_no_sdaster
from SD.co_carte     import carte_sdaster
from SD.co_cham_elem import cham_elem

# -----------------------------------------------------------------------------
# resultat : (evol_sdaster,mode_stat,mode_meca)
from SD.co_resultat     import resultat_sdaster, resultat_jeveux
from SD.co_resultat_dyn import resultat_dyn
from SD.co_base_modale  import base_modale

# -----------------------------------------------------------------------------
class acou_harmo    (resultat_dyn):pass
class dyna_harmo    (resultat_dyn):pass
class dyna_trans    (resultat_dyn):pass
class harm_gene     (resultat_dyn):pass
class mode_acou     (resultat_dyn):pass
class mode_flamb    (resultat_dyn):pass
class mode_gene     (resultat_dyn):pass

# -----------------------------------------------------------------------------
class comb_fourier  (resultat_sdaster):pass
class fourier_elas  (resultat_sdaster):pass
class fourier_ther  (resultat_sdaster):pass
class mult_elas     (resultat_sdaster):pass
class theta_geom    (resultat_sdaster):pass

# -----------------------------------------------------------------------------
# resultat_sdaster/evol_sdaster :
class evol_sdaster(resultat_sdaster):pass
class evol_char(evol_sdaster):pass
class evol_elas(evol_sdaster):pass
class evol_noli(evol_sdaster):pass
class evol_ther(evol_sdaster):pass
class evol_varc(evol_sdaster):pass

# -----------------------------------------------------------------------------
# resultat_sdaster/mode_stat :
class mode_stat(resultat_dyn):pass
class mode_stat_depl(mode_stat):pass
class mode_stat_acce(mode_stat):pass
class mode_stat_forc(mode_stat):pass

# -----------------------------------------------------------------------------
# resultat_sdaster/mode_meca :
class mode_meca(resultat_dyn):pass
class mode_meca_c(mode_meca):pass

# -----------------------------------------------------------------------------
# fonctions / nappe / para_sensi
from SD.co_fonction import fonction_sdaster, para_sensi, fonction_c, nappe_sdaster

# -----------------------------------------------------------------------------
# matr_asse :
from SD.co_matr_asse      import matr_asse
from SD.co_matr_asse_gene import matr_asse_gene
from SD.co_matr_asse_gene import matr_asse_gene_r
from SD.co_matr_asse_gene import matr_asse_gene_c

from SD.co_matr_asse_gd import matr_asse_gd, \
                               matr_asse_depl_r, matr_asse_depl_c, \
                               matr_asse_pres_r, matr_asse_pres_c, \
                               matr_asse_temp_r, matr_asse_temp_c

# -----------------------------------------------------------------------------
# matr_elem :
from SD.co_matr_elem import matr_elem, \
                            matr_elem_depl_r, matr_elem_depl_c, \
                                              matr_elem_pres_c, \
                            matr_elem_temp_r

# -----------------------------------------------------------------------------
# table :
from SD.co_table import table_sdaster, table_jeveux
from SD.co_table_fonction import table_fonction
from SD.co_table_container import table_container

# -----------------------------------------------------------------------------
# vect_asse_gene :
from SD.co_vect_asse_gene import vect_asse_gene

# -----------------------------------------------------------------------------
# vect_elem :
from SD.co_vect_elem import vect_elem, \
                            vect_elem_depl_r, \
                            vect_elem_pres_r, vect_elem_pres_c, \
                            vect_elem_temp_r

#& MODIF COMMUN  DATE 20/04/2009   AUTEUR PROIX J-M.PROIX 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PROIX J.M.PROIX
def C_COMP_INCR() : return FACT(statut='f',min=1,max='**',  #COMMUN#
           RELATION        =SIMP(statut='o',typ='TXM',defaut="ELAS",
                                 into=( "ELAS",            # RESP. : PROIX J.M.PROIX
                                        "ARME",            # RESP. : PEYRARD C.PEYRARD
                                        "ASSE_CORN",       # RESP. : PEYRARD C.PEYRARD
                                        "BARCELONE",       # RESP. : ELGHARIB J.ELGHARIB
                                        "BETON_DOUBLE_DP", # RESP. : ELGHARIB J.ELGHARIB
                                        "BETON_REGLE_PR",  # RESP. : NECS
                                        "BETON_UMLV_FP",   # RESP. : LEPAPE Y.LEPAPE
                                        "CAM_CLAY",        # RESP. : ELGHARIB J.ELGHARIB
                                        "CJS",             # RESP. : CHAVANT C.CHAVANT
                                        "CORR_ACIER",      # RESP. : LEPAPE Y.LEPAPE
                                        "CZM_EXP_REG",     # RESP. : LAVERNE J.LAVERNE
                                        "CZM_EXP",         # RESP. : LAVERNE J.LAVERNE
                                        "CZM_LIN_REG",     # RESP. : LAVERNE J.LAVERNE
                                        "CZM_OUV_MIX",     # RESP. : LAVERNE J.LAVERNE
                                        "CZM_TAC_MIX",     # RESP. : LAVERNE J.LAVERNE
                                        "DIS_BILI_ELAS",   # RESP. : FLEJOU J.L.FLEJOU
                                        "DIS_CHOC",        # RESP. : DEVESA G.DEVESA
                                        "DIS_ECRO_CINE",   # RESP. : FLEJOU J.L.FLEJOU
                                        "DIS_GOUJ2E_ELAS", # RESP. : ANGLES J.ANGLES
                                        "DIS_GOUJ2E_PLAS", # RESP. : ANGLES J.ANGLES
                                        "DIS_GRICRA",      # RESP. : FERNANDES R.FERNANDES
                                        "DIS_VISC",        # RESP. : FLEJOU J.L.FLEJOU
                                        "DRUCK_PRAGER",    # RESP. : FERNANDES R.FERNANDES
                                        "DRUCK_PRAG_N_A",  # RESP. : FERNANDES R.FERNANDES
                                        "ELAS_GONF",       # RESP. : GRANET S.GRANET
                                        "ELAS_HYPER",      # RESP. : ABBAS M.ABBAS
                                        "ENDO_FRAGILE",    # RESP. : MICHEL S.MICHEL
                                        "ENDO_ISOT_BETON", # RESP. : MICHEL S.MICHEL
                                        "ENDO_ORTH_BETON", # RESP. : MICHEL S.MICHEL
                                        "GATT_MONERIE",    # RESP. : DEBONNIERES P.DEBONNIERES
                                        "GLRC_DAMAGE",     # RESP. : MARKOVIC D.MARKOVIC
                                        "GLRC_DM",         # RESP. : MARKOVIC D.MARKOVIC
                                        "GRANGER_FP_INDT", # RESP. : ROSPARS C.ROSPARS
                                        "GRANGER_FP",      # RESP. : ROSPARS C.ROSPARS
                                        "GRANGER_FP_V",    # RESP. : ROSPARS C.ROSPARS
                                        "GRAN_IRRA_LOG",   # RESP. : FERNANDES R.FERNANDES
                                        "GRILLE_CINE_LINE",# RESP. : ROSPARS C.ROSPARS
                                        "GRILLE_ISOT_LINE",# RESP. : ROSPARS C.ROSPARS
                                        "GRILLE_PINTO_MEN",# RESP. : ROSPARS C.ROSPARS
                                        "HOEK_BROWN_EFF",  # RESP. : CHAVANT C.CHAVANT
                                        "HOEK_BROWN",      # RESP. : CHAVANT C.CHAVANT
                                        "HOEK_BROWN_TOT",  # RESP. : CHAVANT C.CHAVANT
                                        "HUJEUX",          # RESP. : FOUCAULT A.FOUCAULT
                                        "IRRAD3M",         # RESP. : FLEJOU J.L.FLEJOU
                                        "JOINT_BA",        # RESP. : MICHEL S.MICHEL
                                        "KIT_DDI",         # RESP. : CHAVANT C.CHAVANT
                                        "KIT_HHM",         # RESP. : GRANET S.GRANET
                                        "KIT_HH",          # RESP. : GRANET S.GRANET
                                        "KIT_HM",          # RESP. : GRANET S.GRANET
                                        "KIT_THHM",        # RESP. : GRANET S.GRANET
                                        "KIT_THH",         # RESP. : GRANET S.GRANET
                                        "KIT_THM",         # RESP. : GRANET S.GRANET
                                        "KIT_THV",         # RESP. : GRANET S.GRANET
                                        "LABORD_1D",       # RESP. : VOLDOIRE F.VOLDOIRE
                                        "LAIGLE",          # RESP. : ELGHARIB J.ELGHARIB
                                        "LEMAITRE_IRRA",   # RESP. : FERNANDES R.FERNANDES
                                        "LEMAITRE",        # RESP. : DEBONNIERES P.DEBONNIERES
                                        "LEMA_SEUIL",      # RESP. : LECLERC S.LECLERC
                                        "LETK",            # RESP. : ELGHARIB J.ELGHARIB
                                        "LMARC_IRRA",      # RESP. : FERNANDES R.FERNANDES
                                        "LMARC",           # RESP. : None
                                        "MAZARS",          # RESP. : MICHEL S.MICHEL
                                        "META_LEMA_ANI",   # RESP. : CANO V.CANO
                                        "META_P_CL_PT_RE", # RESP. : CANO V.CANO
                                        "META_P_CL_PT",    # RESP. : CANO V.CANO
                                        "META_P_CL_RE",    # RESP. : CANO V.CANO
                                        "META_P_CL",       # RESP. : CANO V.CANO
                                        "META_P_IL_PT_RE", # RESP. : CANO V.CANO
                                        "META_P_IL_PT",    # RESP. : CANO V.CANO
                                        "META_P_IL_RE",    # RESP. : CANO V.CANO
                                        "META_P_IL",       # RESP. : CANO V.CANO
                                        "META_P_INL_PT_RE",# RESP. : CANO V.CANO
                                        "META_P_INL_PT",   # RESP. : CANO V.CANO
                                        "META_P_INL_RE",   # RESP. : CANO V.CANO
                                        "META_P_INL",      # RESP. : CANO V.CANO
                                        "META_V_CL_PT_RE", # RESP. : CANO V.CANO
                                        "META_V_CL_PT",    # RESP. : CANO V.CANO
                                        "META_V_CL_RE",    # RESP. : CANO V.CANO
                                        "META_V_CL",       # RESP. : CANO V.CANO
                                        "META_V_IL_PT_RE", # RESP. : CANO V.CANO
                                        "META_V_IL_PT",    # RESP. : CANO V.CANO
                                        "META_V_IL_RE",    # RESP. : CANO V.CANO
                                        "META_V_IL",       # RESP. : CANO V.CANO
                                        "META_V_INL_PT_RE",# RESP. : CANO V.CANO
                                        "META_V_INL_PT",   # RESP. : CANO V.CANO
                                        "META_V_INL_RE",   # RESP. : CANO V.CANO
                                        "META_V_INL",      # RESP. : CANO V.CANO
                                        "MONOCRISTAL",     # RESP. : PROIX J.M.PROIX
                                        "MULTIFIBRE",      # RESP. : FLEJOU J.L.FLEJOU
                                        "NORTON_HOFF",     # RESP. : MICHEL S.MICHEL
                                        "PINTO_MENEGOTTO", # RESP. : ROSPARS C.ROSPARS
                                        "POLYCRISTAL",     # RESP. : PROIX J.M.PROIX
                                        "ROUSSELIER",      # RESP. : CANO V.CANO
                                        "ROUSS_PR",        # RESP. : PARROT A.PARROT
                                        "ROUSS_VISC",      # RESP. : CANO V.CANO
                                        "RUPT_FRAG",       # RESP. : LAVERNE J.LAVERNE
                                        "SANS",            # RESP. : MICHEL S.MICHEL
                                        "VENDOCHAB",       # RESP. : PROIX J.M.PROIX
                                        "VISC_CIN1_CHAB",  # RESP. : PROIX J.M.PROIX
                                        "VISC_CIN2_CHAB",  # RESP. : PROIX J.M.PROIX
                                        "VISC_CIN2_MEMO",  # RESP. : PROIX J.M.PROIX
                                        "VISC_IRRA_LOG",   # RESP. : FERNANDES R.FERNANDES
                                        "VISC_ISOT_LINE",  # RESP. : MICHEL S.MICHEL
                                        "VISC_ISOT_TRAC",  # RESP. : PROIX J.M.PROIX
                                        "VISCOCHAB",       # RESP. : GENIAUT S.GENIAUT
                                        "VISC_TAHERI",     # RESP. : TAHERI S.TAHERI
                                        "VMIS_ASYM_LINE",  # RESP. : PROIX J.M.PROIX
                                        "VMIS_CIN1_CHAB",  # RESP. : PROIX J.M.PROIX
                                        "VMIS_CIN2_CHAB",  # RESP. : PROIX J.M.PROIX
                                        "VMIS_CIN2_MEMO",  # RESP. : PROIX J.M.PROIX
                                        "VMIS_CINE_LINE",  # RESP. : PROIX J.M.PROIX
                                        "VMIS_ECMI_LINE",  # RESP. : PROIX J.M.PROIX
                                        "VMIS_ECMI_TRAC",  # RESP. : PROIX J.M.PROIX
                                        "VMIS_ISOT_LINE",  # RESP. : PROIX J.M.PROIX
                                        "VMIS_ISOT_PUIS",  # RESP. : PROIX J.M.PROIX
                                        "VMIS_ISOT_TRAC",  # RESP. : PROIX J.M.PROIX
                                        "VMIS_POU_FLEJOU", # RESP. : FLEJOU J.L.FLEJOU
                                        "VMIS_POU_LINE",   # RESP. : PROIX J.M.PROIX
                                        "ZMAT",            # RESP. : PROIX J.M.PROIX
                                     ) ),
           b_monox     = BLOC(condition = "RELATION == 'MONOCRISTAL' ",
                                 fr="SD issue de DEFI_COMPOR",
                   COMPOR =SIMP(statut='o',typ=compor_sdaster,max=1),),
           b_polyx     = BLOC(condition = "RELATION == 'POLYCRISTAL' ",
                                 fr="SD issue de DEFI_COMPOR",
                   COMPOR =SIMP(statut='o',typ=compor_sdaster,max=1),),
           b_zmat      = BLOC(condition = "RELATION == 'ZMAT' ",
                                 fr="Comportement de la bibliotheque Zmat",
                   NB_VARI =SIMP(statut='o',typ='I',max=1),
                   UNITE =SIMP(statut='o',typ='I',max=1),),

# KITs
           b_kit_ddi = BLOC(condition = "RELATION == 'KIT_DDI' ",
                            fr="relations de couplage fluage-plasticite",
               RELATION_KIT    =SIMP(statut='o',typ='TXM',min=2,max=2,validators=NoRepeat(),
                                 into=(
                                       "VMIS_CINE_LINE",
                                       "VMIS_ISOT_TRAC",
                                       "VMIS_ISOT_LINE",
                                       "VMIS_ISOT_PUIS",
                                       "GLRC_DM",
                                       "GRANGER_FP",
                                       "GRANGER_FP_INDT",
                                       "GRANGER_FP_V",
                                       "BETON_UMLV_FP",
                                       "ROUSS_PR",
                                       "BETON_DOUBLE_DP",
                                       "ENDO_ISOT_BETON",
                                       "MAZARS"
                                       ),),
                   ),
           b_kit_thm = BLOC(condition = "RELATION in ['KIT_HHM','KIT_HH','KIT_HM','KIT_THHM','KIT_THH','KIT_THM','KIT_THV']",
                            fr="lois de comportements thermo-hydro-mecaniques",
               RELATION_KIT    =SIMP(statut='o',typ='TXM',max=9,validators=NoRepeat(),
                                 into=(
# MECA
                                       "ELAS",
                                       "CJS",
                                       "HUJEUX",
                                       "CAM_CLAY",
                                       "BARCELONE",
                                       "LAIGLE",
                                       "LETK",
                                       "DRUCK_PRAGER",
                                       "DRUCK_PRAG_N_A",
                                       "ELAS_GONF",
                                       "HOEK_BROWN_EFF",
                                       "HOEK_BROWN_TOT",
                                       "MAZARS",
                                       "ENDO_ISOT_BETON",
# THMC
                                       "GAZ",
                                       "LIQU_SATU",
                                       "LIQU_GAZ_ATM",
                                       "LIQU_VAPE_GAZ",
                                       "LIQU_AD_GAZ_VAPE",
                                       "LIQU_VAPE",
                                       "LIQU_GAZ",
# HYDR
                                       "HYDR_UTIL",
                                       "HYDR_VGM",
                                       "HYDR",
                                       "HYDR_ENDO",
                                       ),),
                                       ),
           b_kit_meta = BLOC(condition = "RELATION in ('META_LEMA_ANI','META_P_CL_PT_RE','META_P_CL_PT','META_P_CL_RE','META_P_CL',\
       'META_P_IL_PT_RE','META_P_IL_PT','META_P_IL_RE','META_P_IL','META_P_INL_PT_RE','META_P_INL_PT','META_P_INL_RE','META_P_INL',\
           'META_V_CL_PT_RE','META_V_CL_PT','META_V_CL_RE','META_V_CL','META_V_IL_PT_RE','META_V_IL_PT','META_V_IL_RE','META_V_IL',\
           'META_V_INL_PT_RE','META_V_INL_PT','META_V_INL_RE','META_V_INL')",
                            fr="nombre de phases metallurgiques",
               RELATION_KIT    =SIMP(statut='o',typ='TXM',max=1,validators=NoRepeat(),
                                 into=("ACIER","ZIRC"),),
                                 ),

           DEFORMATION     =SIMP(statut='f',typ='TXM',defaut="PETIT",
                             into=("PETIT","PETIT_REAC","SIMO_MIEHE","GREEN_GR","GREEN","COROTATIONNEL",
                                   "REAC_GEOM","EULER_ALMANSI")),

           ALGO_C_PLAN     =SIMP(statut='f',typ='TXM',defaut="ANALYTIQUE",into=("DEBORST","ANALYTIQUE",)),
           RESI_DEBO_MAXI = SIMP(statut='f',typ='R',
                   fr="Critre d'arret absolu pour assurer la condition de contraintes planes",
           ),
           b_resideborst      = BLOC(condition = " RESI_DEBO_MAXI == None ",
           fr="Critre d'arret relatif pour assurer la condition de contraintes planes",
                            RESI_DEBO_RELA = SIMP(statut='f',typ='R',defaut= 1.0E-6),
                            ),
           ALGO_1D         =SIMP(statut='f',typ='TXM',defaut="ANALYTIQUE",into=("DEBORST","ANALYTIQUE",)),
           ITER_MAXI_DEBORST  =SIMP(statut='f',typ='I',defaut= 1),

           RESI_INTE_RELA  =SIMP(statut='f',typ='R',defaut= 1.0E-6),
           ITER_INTE_MAXI  =SIMP(statut='f',typ='I',defaut= 10 ),
           b_redec_local      = BLOC(condition = "DEFORMATION in ('PETIT','PETIT_REAC','GREEN')",
                        fr="Nombre de redcoupages internes du pas de temps",
               ITER_INTE_PAS   =SIMP(statut='f',typ='I',defaut= 0 ),
                   ),
           RESO_INTE       =SIMP(statut='f',typ='TXM',defaut="IMPLICITE",
                                 into=("RUNGE_KUTTA_2","RUNGE_KUTTA_4","IMPLICITE")),
           TYPE_MATR_TANG  =SIMP(statut='f',typ='TXM',into=("PERTURBATION","VERIFICATION","TANGENTE_SECANTE")),
           b_perturb      = BLOC(condition = " (TYPE_MATR_TANG != None) and (TYPE_MATR_TANG != 'TANGENTE_SECANTE') ",
                        fr="Calcul de la matrice tangente par perturbation, valeur de la perturbation",
                 VALE_PERT_RELA  =SIMP(statut='f',typ='R',defaut= 1.0E-5),
                                ),
           b_tangsec      = BLOC(condition = " TYPE_MATR_TANG == 'TANGENTE_SECANTE' ",
                        fr="Modification evolutive de la matrice tangente/secante",
                 SEUIL        =SIMP(statut='f',typ='R',defaut= 3. ),
                 AMPLITUDE    =SIMP(statut='f',typ='R',defaut= 1.5 ),
                 TAUX_RETOUR  =SIMP(statut='f',typ='R',defaut= 0.05 ),
                                ),
           PARM_THETA      =SIMP(statut='f',typ='R',defaut= 1. ),

           regles=(PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),

         ) ;
#& MODIF COMMUN  DATE 27/10/2009   AUTEUR TARDIEU N.TARDIEU 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2008  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DESOZA T.DESOZA
def C_CONTACT() : return FACT(statut='f',max='**',
           fr="Dfinit les zones soumises  des conditions de contact unilatral avec ou sans frottement",


           METHODE         =SIMP(statut='f',typ='TXM',defaut="CONTRAINTE",
                                 into  =("VERIF","CONTRAINTE","LAGRANGIEN","PENALISATION","CONTINUE","GCP","XFEM") ),
#
# OPTIONS D'APPARIEMENT
#

           b_notxfem         =BLOC(condition = "METHODE != 'XFEM' ",
                                   regles=(UN_PARMI('GROUP_MA_ESCL','MAILLE_ESCL'),
                                           UN_PARMI('GROUP_MA_MAIT','MAILLE_MAIT'),),

             GROUP_MA_MAIT   =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max='**'),
             MAILLE_MAIT     =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
             GROUP_MA_ESCL   =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max='**'),
             MAILLE_ESCL     =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),

             APPARIEMENT     =SIMP(statut='f',typ='TXM',defaut="MAIT_ESCL",
                                   into  =("NODAL","MAIT_ESCL")),

             LISSAGE         =SIMP(statut='f',typ='TXM',defaut="NON",
                                   into  =("OUI","NON")),

             NORMALE         =SIMP(statut='f',typ='TXM',defaut="MAIT",
                                   into  =("MAIT","MAIT_ESCL","ESCL"),),

             VECT_MAIT       =SIMP(statut='f',typ='TXM',defaut="AUTO",
                                   into  =("AUTO","FIXE","VECT_Y")),

             b_nmait_fixe    =BLOC(condition = "VECT_MAIT == 'FIXE'",
               MAIT_FIXE     =SIMP(statut='o',typ='R',min=3,max=3),
             ),

             b_nmait_vecty   =BLOC(condition = "VECT_MAIT == 'VECT_Y'",
               MAIT_VECT_Y   =SIMP(statut='o',typ='R',min=3,max=3),
             ),

             VECT_ESCL       =SIMP(statut='f',typ='TXM',defaut="AUTO",
                                   into  =("AUTO","FIXE","VECT_Y")),

             b_nescl_fixe    =BLOC(condition = "VECT_ESCL == 'FIXE'",
               ESCL_FIXE     =SIMP(statut='o',typ='R',min=3,max=3),
             ),

             b_nescl_vecty   =BLOC(condition = "VECT_ESCL == 'VECT_Y'",
               ESCL_VECT_Y   =SIMP(statut='o',typ='R',min=3,max=3),
             ),


             TYPE_APPA       =SIMP(statut='f',typ='TXM',defaut="PROCHE",
                                   into  =("PROCHE","FIXE")),

             b_appa_fixe     =BLOC(condition = "TYPE_APPA == 'FIXE'",
               DIRE_APPA     =SIMP(statut='f',typ='R',min=3,max=3),
             ),

             DIST_MAIT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             DIST_ESCL       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),

             TOLE_APPA       =SIMP(statut='f',typ='R'  ,defaut=-1.0),

           ),


           b_dist_struct   =BLOC(condition = "METHODE != 'CONTINUE' and METHODE != 'XFEM'",
             DIST_POUTRE   =SIMP(statut='f',typ='TXM',defaut="NON", into=("OUI","NON")),
             DIST_COQUE    =SIMP(statut='f',typ='TXM',defaut="NON", into=("OUI","NON")),
             b_cara        =BLOC(condition = "DIST_POUTRE == 'OUI' or DIST_COQUE == 'OUI'",
               CARA_ELEM     =SIMP(statut='o',typ=(cara_elem) ),
             ),
           ),

           TOLE_PROJ_EXT   =SIMP(statut='f',typ='R'  ,defaut=0.50),

#
# FIN OPTIONS D'APPARIEMENT
#

           b_xfem         =BLOC(condition = "METHODE == 'XFEM' ",
             FISS_MAIT      = SIMP(statut='o',typ=fiss_xfem,max=1),
             INTEGRATION    = SIMP(statut='f',typ='TXM',defaut="FPG4",into=("GAUSS","FPG2","FPG3","FPG4","FPG6",
                                               "FPG7","NOEUD","SIMPSON","SIMPSON1","NCOTES","NCOTES1","NCOTES2") ),
             COEF_REGU_CONT = SIMP(statut='f',typ='R',defaut=100.E+0),
             ITER_CONT_MAXI = SIMP(statut='f',typ='I',defaut=30),
             ITER_GEOM_MAXI  =SIMP(statut='f',typ='I',defaut=0),

             CONTACT_INIT   = SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ),
             ALGO_LAGR      = SIMP(statut='f',typ='TXM',defaut="VERSION1",into=("NON","VERSION1","VERSION2" , ) ),
             COEF_ECHELLE   = SIMP(statut='f',typ='R',defaut=1.E+6),
             FROTTEMENT     = SIMP(statut='f',typ='TXM',defaut="SANS",into=("SANS","COULOMB",) ),
             GLISSIERE      = SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
             b_frotxfem    =BLOC(condition = "FROTTEMENT == 'COULOMB' ",fr="Paramtres du frottement de Coulomb",
               COULOMB        = SIMP(statut='o',typ='R',),
               ITER_FROT_MAXI = SIMP(statut='f',typ='I',defaut=2),
               COEF_REGU_FROT = SIMP(statut='f',typ='R',defaut=100.E+0),
               SEUIL_INIT     = SIMP(statut='f',typ='R',defaut=0.E+0),
               ),
           ),



           b_verif         =BLOC(condition = "METHODE == 'VERIF' ",
                                 fr="Paramtres de la mthode sans calcul de contact",
                STOP_INTERP     =SIMP(statut='f',typ='TXM',defaut="NON",
                                      into=("OUI","NON")),
                TOLE_INTERP     =SIMP(statut='f',typ='R',defaut = 0.),

                GROUP_MA_FOND   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           ),

           b_active        =BLOC(condition = "METHODE == 'CONTRAINTE' ",
                                 fr="Paramtres de la mthode des contraintes actives (contact uniquement)",
                GLISSIERE       =SIMP(statut='f',typ='TXM',defaut="NON",
                                      into=("OUI","NON")),
                b_glissiere     =BLOC(condition = "GLISSIERE == 'OUI' ",
                      ALARME_JEU  =SIMP(statut='f',typ='R',defaut=0.),
                                 ),

                STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",
                                      into=("OUI","NON")),
                NB_RESOL        =SIMP(statut='f',typ='I', defaut=10 ),
                REAC_GEOM       =SIMP(statut='f',typ='TXM',defaut="AUTOMATIQUE",
                        into=("AUTOMATIQUE","CONTROLE","SANS")),

                b_reac_geom     =BLOC(condition = "REAC_GEOM == 'CONTROLE' ",
                                 fr="Paramtre de la ractualisation gomtrique",
                      NB_REAC_GEOM   =SIMP(statut='o',typ='I'),
                                 ),

                SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),

           ),
           b_lagrangien    =BLOC(condition = "METHODE == 'LAGRANGIEN' ",
                                 fr="Paramtres de la mthode Lagrangienne (contact avec ou sans frottement)",
                FROTTEMENT      =SIMP(statut='f',typ='TXM',defaut="SANS",into=("SANS","COULOMB",) ),
                STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",
                                      into=("OUI","NON")),
                NB_RESOL        =SIMP(statut='f',typ='I', defaut=10 ),
                ITER_MULT_MAXI  =SIMP(statut='f',typ='I'  ,defaut=4),

                REAC_GEOM       =SIMP(statut='f',typ='TXM',defaut="AUTOMATIQUE",
                                      into=("AUTOMATIQUE","CONTROLE","SANS")),

                b_reac_geom     =BLOC(condition = "REAC_GEOM == 'CONTROLE' ",fr="Paramtre de la ractualisation gomtrique",
                      NB_REAC_GEOM   =SIMP(statut='o',typ='I'),

                                 ),


                SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),

                b_frottement    =BLOC(condition = "FROTTEMENT == 'COULOMB' ",fr="Paramtres du frottement de Coulomb",
                     COULOMB         =SIMP(statut='o',typ='R',),
                     COEF_MATR_FROT  =SIMP(statut='f',typ='R',defaut=0.E+0),
                     ),),

           b_penalisation       =BLOC(condition = "METHODE == 'PENALISATION' ",
                                      fr="Paramtres de la mthode pnalise (contact avec ou sans frottement)",
                E_N             =SIMP(statut='f',typ='R'),
                FROTTEMENT      =SIMP(statut='f',typ='TXM',defaut="SANS",into=("SANS","COULOMB",) ),
                b_dualisation   =BLOC(condition = "E_N == None",
                  STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",
                                        into=("OUI","NON")),
                  NB_RESOL        =SIMP(statut='f',typ='I', defaut=10 ),
                  ITER_MULT_MAXI  =SIMP(statut='f',typ='I',defaut=4),
                ),

                REAC_GEOM       =SIMP(statut='f',typ='TXM',defaut="AUTOMATIQUE",
                                      into=("AUTOMATIQUE","CONTROLE","SANS")),

                b_reac_geom     =BLOC(condition = "REAC_GEOM == 'CONTROLE' ",fr="Paramtre de la ractualisation gomtrique",
                      NB_REAC_GEOM   =SIMP(statut='o',typ='I'),
                                 ),

                SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),



                b_frottement    =BLOC(condition = "FROTTEMENT == 'COULOMB' ",fr="Paramtres du frottement de Coulomb",
                     COULOMB         =SIMP(statut='o',typ='R',),
                     E_T             =SIMP(statut='o',typ='R',
                                           fr="Active la pnalisation sur le frottement et dfinit le coefficient de pnalisation"),
                     COEF_MATR_FROT  =SIMP(statut='f',typ='R',defaut=0.E+0),
                     ),),

           b_continue      =BLOC(condition = "METHODE == 'CONTINUE' ",
                                 fr="Paramtres de la mthode continue (contact avec ou sans frottement)",
#                regles=(UN_PARMI('GLISSIERE','FROTTEMENT'),),

# -------------------------------- CHOIX DE LA FORMULATION DE LA METHODE CONTINUE
                ALGO_CONT   =SIMP(statut='f',typ='TXM',defaut="LAGRANGIEN",into=("LAGRANGIEN","AUGMENTE","STABILISE"),),
                b_CONT_LAGR =BLOC(condition = "ALGO_CONT == 'LAGRANGIEN' ",fr="Parametres de la formulation Lagrangienne",
                                  COEF_REGU_CONT  =SIMP(statut='f',typ='R',defaut=100.E+0),),
                b_CONT_STAB =BLOC(condition = "ALGO_CONT == 'STABILISE' ",fr="Parametres du Lagrangien stabilis",
                                  COEF_REGU_CONT  =SIMP(statut='f',typ='R',defaut=100.E+0),
                                  COEF_STAB_CONT  =SIMP(statut='f',typ='R',defaut=100.E+0),),
                b_CONT_AUGM =BLOC(condition = "ALGO_CONT == 'AUGMENTE' ",fr="Parametres du Lagrangien augment",
                                  COEF_REGU_CONT  =SIMP(statut='f',typ='R',defaut=100.E+0),
                                  COEF_STAB_CONT  =SIMP(statut='f',typ='R',defaut=100.E+0),
                                  COEF_PENA_CONT  =SIMP(statut='f',typ='R',defaut=100.E+0),),
# --------------------------------
                GLISSIERE =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON"),),
# --------------------------------
                COMPLIANCE      =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ),
                b_compliance    =BLOC(condition = "COMPLIANCE == 'OUI' ",fr="Parametres de la compliance",
                                      ASPERITE =SIMP(statut='o',typ='R',),
                                      E_N      =SIMP(statut='o',typ='R',),
                                      E_V      =SIMP(statut='f',typ='R',defaut=0.E+0),),
# --------------------------------
                FOND_FISSURE    =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ),
                b_FOND_FISSURE  =BLOC(condition = "FOND_FISSURE == 'OUI' ",fr="TRAITEMENT EN FOND DE FISSURE",
                                      regles=(UN_PARMI('NOEUD_FOND','GROUP_NO_FOND','MAILLE_FOND','GROUP_MA_FOND'),),
                                      NOEUD_FOND    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                                      GROUP_NO_FOND =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                                      MAILLE_FOND   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                                      GROUP_MA_FOND =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),),
# --------------------------------
                RACCORD_LINE_QUAD=SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ),
                b_RACCORD_SURF   =BLOC(condition = "RACCORD_LINE_QUAD == 'OUI' ",fr="TRAITEMENT DU RACCORD SURFACIQUE",
                                       regles=(UN_PARMI('NOEUD_RACC','GROUP_NO_RACC'),),
                                       NOEUD_RACC    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                                       GROUP_NO_RACC =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),),
# -------------------------------- MOTS-CLEF CONTACT
                INTEGRATION      =SIMP(statut='f',typ='TXM',defaut="NOEUD",
                                       into=("GAUSS","NOEUD","SIMPSON","SIMPSON1","SIMPSON2",
                                             "NCOTES","NCOTES1","NCOTES2"),),
                FORMULATION      =SIMP(statut='f',typ='TXM',defaut="DEPL",into=("DEPL","VITE"),),

                ITER_GEOM_MAXI   =SIMP(statut='f',typ='I',defaut=2),
                ITER_CONT_MAXI   =SIMP(statut='f',typ='I',defaut=30),
                CONTACT_INIT     =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",),),
# -------------------------------- dtection automatique et exclusion des noeuds impliqus dans le pivot nul
                EXCLUSION_PIV_NUL=SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",),),
# -------------------------------- exclusion manuelle des noeuds impliqus dans le pivot nul;
#                                  prvaut sur la fonctionnalit prcdente sans pour autant interfrer avec elle
                SANS_NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                SANS_GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                regles        =(EXCLUS('SANS_NOEUD','SANS_GROUP_NO'),),
# -------------------------------- MOTS-CLEF FROTTEMENT
                FROTTEMENT      =SIMP(statut='f',typ='TXM',defaut="SANS",into=("SANS","COULOMB",) ),
                b_frottement    =BLOC(condition = "FROTTEMENT == 'COULOMB' ",fr="Paramtres du frottement de Coulomb",
                     ALGO_FROT       =SIMP(statut='f',typ='TXM',defaut="LAGRANGIEN",
                                      into=("LAGRANGIEN","AUGMENTE","STABILISE") ),
                     b_FROT_LAGR =BLOC(condition = "ALGO_FROT == 'LAGRANGIEN' ",fr="Parametres de la formulation Lagrangienne",
                                       COEF_REGU_FROT  =SIMP(statut='f',typ='R',defaut=100.E+0),),
                     b_FROT_STAB =BLOC(condition = "ALGO_FROT == 'STABILISE' ",fr="Parametres du Lagrangien stabilis",
                                       COEF_REGU_FROT  =SIMP(statut='f',typ='R',defaut=100.E+0),
                                       COEF_STAB_FROT  =SIMP(statut='f',typ='R',defaut=100.E+0),),
                     b_FROT_AUGM =BLOC(condition = "ALGO_FROT == 'AUGMENTE' ",fr="Parametres du Lagrangien augment",
                                       COEF_REGU_FROT  =SIMP(statut='f',typ='R',defaut=100.E+0),
                                       COEF_STAB_FROT  =SIMP(statut='f',typ='R',defaut=100.E+0),
                                       COEF_PENA_FROT  =SIMP(statut='f',typ='R',defaut=100.E+0),),
                     COULOMB            =SIMP(statut='o',typ='R',),
                     SANS_NOEUD_FR    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                     SANS_GROUP_NO_FR =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                     regles             =(EXCLUS('SANS_NOEUD_FR','SANS_GROUP_NO_FR'),),
                     b_sans_group_no_frot =BLOC(condition = "SANS_GROUP_NO_FR != None or SANS_NO_FR != None",
                                                fr="Direction(s) de frottement  exclure",
                                                EXCL_FROT_1 =SIMP(statut='f',typ='R',min=3,max=3),
                                                EXCL_FROT_2 =SIMP(statut='f',typ='R',min=3,max=3),),
                     ITER_FROT_MAXI =SIMP(statut='f',typ='I',defaut=2),
                     SEUIL_INIT     =SIMP(statut='f',typ='R',defaut=0.E+0),
                     USURE          =SIMP(statut='f',typ='TXM',defaut="SANS",into=("SANS","ARCHARD",),),
                     b_usure        =BLOC(condition = "USURE == 'ARCHARD' ",fr="Parametres de la loi d'usure d'Archard",
                                          K =SIMP(statut='o',typ='R',),
                                          H =SIMP(statut='o',typ='R',),),),),

           b_gcp        =BLOC(condition = "METHODE == 'GCP' ",
                                 fr="Paramtres de la mthode du gradient conjugu projet (contact uniquement)",
                RESI_ABSO       =SIMP(statut='o',typ='R',
                                      fr="Critre de convergence (niveau d'interpntration autoris)"),
                REAC_ITER       =SIMP(statut='f',typ='I',defaut=20, fr="Frquence de rinitialisation de la conjugaison"),
                ITER_GCP_MAXI   =SIMP(statut='f',typ='I',defaut=0, fr="Nombre d'itrations maximal pour le GCP"),
                REAC_GEOM       =SIMP(statut='f',typ='TXM',defaut="AUTOMATIQUE",
                                      into=("AUTOMATIQUE","CONTROLE","SANS")),

                b_reac_geom     =BLOC(condition = "REAC_GEOM == 'CONTROLE' ",fr="Paramtre de la ractualisation gomtrique",
                      NB_REAC_GEOM   =SIMP(statut='o',typ='I'),

                                 ),
                PRE_COND         =SIMP(statut='f',typ='TXM',defaut="SANS",
                      into=("DIRICHLET","SANS"),fr="Choix d'un prconditionneur (acclre la convergence)"),
                ITER_PRE_MAXI   =SIMP(statut='f',typ='I',defaut=0, fr="Nombre d'itrations maximal pour le prconditionneur"),
                COEF_RESI       =SIMP(statut='f',typ='R',defaut = 1.,
                                        fr="Critre_Convergence_Prconditionneur = COEF_RESI*Critre_Convergence_GCP",),
                RECH_LINEAIRE=SIMP(statut='f',typ='TXM',defaut="ADMISSIBLE",into=("ADMISSIBLE","NON_ADMISSIBLE"),
                                        fr="Autorise-t-on de sortir du domaine admissible lors de la recherche linaire",),
                SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           ),
         );



#& MODIF COMMUN  DATE 29/09/2009   AUTEUR GNICOLAS G.NICOLAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE VABHHTS J.PELLET
# ce fichier contient la liste des "into" possibles pour le mot cle NOM_CHAM
# c'est a dire les noms de champs des SD RESULTAT (DATA de la routine RSCRSD)
def C_NOM_CHAM_INTO() : return  ("ACCE",    #COMMUN#
                        "ACCE_ABSOLU",
                        "ALPH0_ELGA_EPSP",
                        "ALPHP_ELGA_ALPH0",
                        "ARCO_ELNO_SIGM",
                        "ARCO_NOEU_SIGM",
                        "COMPORTEMENT",
                        "COMPORTHER",
                        "CRIT_ELNO_RUPT",
                        "DCHA_ELGA_SIGM",
                        "DCHA_ELNO_SIGM",
                        "DCHA_NOEU_SIGM",
                        "DEDE_ELNO_DLDE",
                        "DEDE_NOEU_DLDE",
                        "DEGE_ELNO_DEPL",
                        "DEGE_NOEU_DEPL",
                        "DEPL",
                        "DEPL_ABSOLU",
                        "DESI_ELNO_DLSI",
                        "DESI_NOEU_DLSI",
                        "DETE_ELNO_DLTE",
                        "DETE_NOEU_DLTE",
                        "DURT_ELGA_META",
                        "DURT_ELNO_META",
                        "DURT_NOEU_META",
                        "ECIN_ELEM_DEPL",
                        "EFGE_ELNO_CART",
                        "EFGE_ELNO_DEPL",
                        "EFGE_NOEU_CART",
                        "EFGE_NOEU_DEPL",
                        "ENDO_ELGA",
                        "ENDO_ELNO_ELGA",
                        "ENDO_ELNO_SIGA",
                        "ENDO_ELNO_SINO",
                        "ENDO_NOEU_SINO",
                        "ENEL_ELGA",
                        "ENEL_ELNO_ELGA",
                        "ENEL_NOEU_ELGA",
                        "EPEQ_ELNO_TUYO",
                        "EPVC_ELGA",
                        "EPVC_ELNO",
                        "EPFD_ELGA",
                        "EPFD_ELNO",
                        "EPFP_ELGA",
                        "EPFP_ELNO",
                        "EPME_ELGA_DEPL",
                        "EPME_ELNO_DEPL",
                        "EPMG_ELGA_DEPL",
                        "EPMG_ELNO_DEPL",
                        "EPMG_NOEU_DEPL",
                        "EPOT_ELEM_DEPL",
                        "EPSA_ELNO",
                        "EPSA_NOEU",
                        "EPSG_ELGA_DEPL",
                        "EPSG_ELNO_DEPL",
                        "EPSG_NOEU_DEPL",
                        "EPSI_ELGA_DEPL",
                        "EPSI_ELNO_DEPL",
                        "EPSI_ELNO_TUYO",
                        "EPSI_NOEU_DEPL",
                        "EPSP_ELGA",
                        "EPSP_ELNO",
                        "EPSP_ELNO_ZAC",
                        "EPSP_NOEU",
                        "EPSP_NOEU_ZAC",
                        "EQUI_ELGA_EPME",
                        "EQUI_ELGA_EPSI",
                        "EQUI_ELGA_SIGM",
                        "EQUI_ELNO_EPME",
                        "EQUI_ELNO_EPSI",
                        "EQUI_ELNO_SIGM",
                        "EQUI_NOEU_EPME",
                        "EQUI_NOEU_EPSI",
                        "EQUI_NOEU_SIGM",
                        "ERRE_ELEM_SIGM",
                        "ERRE_ELEM_TEMP",
                        "ERRE_ELNO_ELEM",
                        "ERRE_NOEU_ELEM",
                        "ERZ1_ELEM_SIGM",
                        "ERZ2_ELEM_SIGM",
                        "QIRE_ELEM_SIGM",
                        "QIRE_ELNO_ELEM",
                        "QIRE_NOEU_ELEM",
                        "QIZ1_ELEM_SIGM",
                        "QIZ2_ELEM_SIGM",
                        "SING_ELEM",
                        "SING_ELNO_ELEM",
                        "ETOT_ELEM",
                        "ETOT_ELGA",
                        "ETOT_ELNO_ELGA",
                        "EXTR_ELGA_VARI",
                        "EXTR_ELNO_VARI",
                        "EXTR_NOEU_VARI",
                        "FLUX_ELGA_TEMP",
                        "FLUX_ELNO_TEMP",
                        "FLUX_NOEU_TEMP",
                        "FORC_NODA",
                        "FSUR_2D",
                        "FSUR_3D",
                        "FVOL_2D",
                        "FVOL_3D",
                        "GRAD_NOEU_THETA",
                        "HYDR_ELNO_ELGA",
                        "HYDR_NOEU_ELGA",
                        "INDI_LOCA_ELGA",
                        "INTE_ELNO_ACTI",
                        "INTE_ELNO_REAC",
                        "INTE_NOEU_ACTI",
                        "INTE_NOEU_REAC",
                        "IRRA",
                        "LANL_ELGA",
                        "META_ELGA_TEMP",
                        "META_ELNO_TEMP",
                        "META_NOEU_TEMP",
                        "MODE_FLAMB",
                        "PMPB_ELGA_SIEF",
                        "PMPB_ELNO_SIEF",
                        "PMPB_NOEU_SIEF",
                        "PRES",
                        "PRES_DBEL_DEPL",
                        "PRES_ELNO_DBEL",
                        "PRES_ELNO_IMAG",
                        "PRES_ELNO_REEL",
                        "PRES_NOEU_DBEL",
                        "PRES_NOEU_IMAG",
                        "PRES_NOEU_REEL",
                        "RADI_ELGA_SIGM",
                        "RADI_ELNO_SIGM",
                        "RADI_NOEU_SIGM",
                        "REAC_NODA",
                        "SIEF_ELGA",
                        "SIEF_ELGA_DEPL",
                        "SIEF_ELNO",
                        "SIEF_ELNO_ELGA",
                        "SIEF_NOEU",
                        "SIEF_NOEU_ELGA",
                        "SIEF_SENO_SEGA",
                        "SIEQ_ELNO_TUYO",
                        "SIGM_ELNO_CART",
                        "SIGM_ELNO_COQU",
                        "SIGM_ELNO_DEPL",
                        "SIGM_ELNO_SIEF",
                        "SIGM_ELNO_TUYO",
                        "SIGM_ELNO_ZAC",
                        "SIGM_NOEU_CART",
                        "SIGM_NOEU_COQU",
                        "SIGM_NOEU_DEPL",
                        "SIGM_NOEU_SIEF",
                        "SIGM_NOEU_ZAC",
                        "SIGM_NOZ1_ELGA",
                        "SIGM_NOZ2_ELGA",
                        "SIPO_ELNO_DEPL",
                        "SIPO_ELNO_SIEF",
                        "SIPO_NOEU_DEPL",
                        "SIPO_NOEU_SIEF",
                        "SIRE_ELNO_DEPL",
                        "SIRE_NOEU_DEPL",
                        "SOUR_ELGA_ELEC",
                        "TEMP",
                        "THETA",
                        "VALE_CONT",
                        "VALE_NCOU_MAXI",
                        "VARI_ELGA",
                        "VARI_ELGA_ZAC",
                        "VARI_ELNO",
                        "VARI_ELNO_COQU",
                        "VARI_ELNO_ELGA",
                        "VARI_ELNO_TUYO",
                        "VARI_NOEU",
                        "VARI_NOEU_ELGA",
                        "VITE",
                        "VITE_ABSOLU",
                        "VITE_VENT",
                        )
#& MODIF COMMUN  DATE 19/05/2008   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2005  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# ce fichier contient la liste des  noms des grandeurs de CODE_ASTER
def C_NOM_GRANDEUR() : return  ( #COMMUN# 
"ABSC_R",
"ADRSJEVE",
"ADRSJEVN",
"CAARPO",
"CACABL",
"CACOQU",
"CADISA",
"CADISK",
"CADISM",
"CAFI_R",
"CAGEBA",
"CAGEPO",
"CAGNBA",
"CAGNPO",
"CAMASS",
"CAORIE",
"CAPOUF",
"CARCRI",
"CASECT",
"CHLI_R",
"CODE_I",
"COEH_F",
"COEH_R",
"COMPOR",
"CORR_R",
"CRRU_R",
"DBEL_R",
"DCEL_I",
"DDLI_C",
"DDLI_F",
"DDLI_R",
"DDLM_C",
"DDLM_R",
"DEPL_C",
"DEPL_F",
"DEPL_R",
"DOMMAG",
"DURT_R",
"ENER_R",
"EPSI_F",
"EPSI_R",
"ERRE_R",
"FACY_R",
"FELECR",
"FISS_R",
"FLAPLA",
"FLUN_F",
"FLUN_R",
"FLUX_F",
"FLUX_R",
"FORC_C",
"FORC_F",
"FORC_R",
"FREQ_R",
"FTHM_F",
"FTHM_R",
"G",
"GEOM_R",
"G_DEPL_R",
"HARMON",
"HYDR_R",
"IMPE_C",
"IMPE_F",
"IMPE_R",
"IND_LOCA",
"INFC_R",
"INST_R",
"INTE_R",
"INTLOC",
"IRRA_R",
"ITECREL",
"ITEDEC",
"J",
"LISTMA",
"MACOMP",
"MASS_R",
"MATE_F",
"NBSP_I",
"NEUT_F",
"NEUT_I",
"NEUT_K16",
"NEUT_K24",
"NEUT_K8",
"NEUT_R",
"NUMC_I",
"NUMMOD",
"ONDE_F",
"ONDE_R",
"PESA_R",
"PILO_K",
"PILO_R",
"POSI",
"PREC",
"PRES_C",
"PRES_F",
"PRES_R",
"RAYO_F",
"RAYO_R",
"RCCM_K",
"RCCM_R",
"RESCREL",
"RICE_TRA",
"ROTA_R",
"SECTION",
"SIEF_C",
"SIEF_R",
"SIZZ_R",
"SOUR_F",
"SOUR_R",
"SPMA_R",
"STAOUDYN",
"TEMP_C",
"TEMP_F",
"TEMP_R",
"THETA",
"VALO_R",
"VANL_R",
"VAR2_R",
"VARI_R",
"VENTCX_F",
"VNOR_C",
"VNOR_F",
"VOISIN",
"WEIBULL",
"XCONTAC",
                                 )
#& MODIF COMMUN  DATE 29/03/2007   AUTEUR GRANET S.GRANET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2004  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# ce fichier contient la liste des PARA possibles pour les fonctions et les nappes
def C_PARA_FONCTION() : return  ( #COMMUN#
                   "DX","DY","DZ","DRX","DRY","DRZ","TEMP","TSEC",
                   "INST","X","Y","Z","EPSI","META","FREQ","PULS","DSP",
                   "AMOR","ABSC","SIGM","HYDR","SECH","PORO","SAT",
                   "PGAZ","PCAP","PLIQ","PVAP","PAD","VITE","ENDO",
                   "NORM","EPAIS","NEUT1","NEUT2",)
#& MODIF COMMUN  DATE 27/06/2005   AUTEUR D6BHHJP J.P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2004  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
#
# ce fichier contient la liste des "into" possibles pour le mot cle TYPE_CHAM
def C_TYPE_CHAM_INTO() : #COMMUN#
   l=[]
   for gd in C_NOM_GRANDEUR() :
        for typ in ("ELEM","ELNO","ELGA","CART","NOEU") :
             l.append(typ+"_"+gd)
   return tuple(l)

#& MODIF COMMANDE  DATE 23/10/2008   AUTEUR TORKHANI M.TORKHANI 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE FLEJOU J-L.FLEJOU
AFFE_CARA_ELEM=OPER(nom="AFFE_CARA_ELEM",op=  19,sd_prod=cara_elem,
                    fr="Affectation de caractristiques  des lments de structure",
                    reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
         regles=(AU_MOINS_UN('POUTRE','BARRE','COQUE','CABLE','DISCRET','DISCRET_2D','MASSIF',
                             'GRILLE','MULTIFIBRE','RIGI_PARASOL'),
                             PRESENT_PRESENT('MULTIFIBRE','GEOM_FIBRE'),),
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         INFO            =SIMP(statut='f',typ='I', defaut= 1 ,into=(1,2) ),
         VERIF           =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',into=("MAILLE","NOEUD") ),

#============================================================================
         POUTRE          =FACT(statut='f',max='**',
           regles=(UN_PARMI('MAILLE','GROUP_MA'),),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           SECTION         =SIMP(statut='o',typ='TXM' ,into=("GENERALE","RECTANGLE","CERCLE") ),
           PREC_AIRE       =SIMP(statut='f',typ='R',defaut=0.01),
           PREC_INERTIE    =SIMP(statut='f',typ='R',defaut=0.1),
           b_generale      =BLOC( condition = "SECTION=='GENERALE'",
             VARI_SECT       =SIMP(statut='f',typ='TXM',into=("CONSTANT","HOMOTHETIQUE"),defaut="CONSTANT"),
             b_constant      =BLOC( condition = "VARI_SECT=='CONSTANT'",
               CARA            =SIMP(statut='o',typ='TXM',validators=NoRepeat(),min=4 ,max=15,
                                 fr="A,IY,IZ,JX sont des paramtres obligatoires",
                                 into=("A","IY","IZ","AY","AZ","EY","EZ","JX","RY","RZ","RT",
                                       "JG","IYR2","IZR2","AI") ),
               VALE            =SIMP(statut='o',typ='R',min=4 ,max=15),
             ),
             b_homothetique  =BLOC( condition = "VARI_SECT=='HOMOTHETIQUE'",
               CARA            =SIMP(statut='o',typ='TXM',validators=NoRepeat(),min=8 ,max=30,
                                 fr="A1,A2,IY1,IY2,IZ1,IZ2,JX1,JX2 sont des paramtres obligatoires",
                                 into=("A1","IY1","IZ1","AY1","AZ1","EY1","EZ1","JX1","RY1",
                                       "RZ1","RT1","JG1","IYR21","IZR21","AI1",
                                       "A2","IY2","IZ2","AY2","AZ2","EY2","EZ2","JX2","RY2",
                                       "RZ2","RT2","JG2","IYR22","IZR22","AI2") ),
               VALE            =SIMP(statut='o',typ='R',min=8 ,max=30),
             ),
           ),
           b_rectangle     =BLOC( condition = "SECTION=='RECTANGLE'",
             VARI_SECT       =SIMP(statut='f',typ='TXM',into=("CONSTANT","HOMOTHETIQUE","AFFINE"),defaut="CONSTANT"),
             b_constant      =BLOC( condition = "VARI_SECT=='CONSTANT'",
               CARA            =SIMP(statut='o',typ='TXM',validators=NoRepeat(),min=1 ,max=4,
                                 into=("H","EP", "HY","HZ","EPY","EPZ") ),
               VALE            =SIMP(statut='o',typ='R',min=1 ,max=4),
             ),
             b_homothetique  =BLOC( condition = "VARI_SECT=='HOMOTHETIQUE'",
               CARA            =SIMP(statut='o',typ='TXM',validators=NoRepeat(),min=2 ,max=8,
                                     into=("H1","HZ1","HY1","EP1","EPY1","EPZ1",
                                           "H2","HZ2","HY2","EP2","EPY2","EPZ2") ),
               VALE            =SIMP(statut='o',typ='R',min=2 ,max=8),
             ),
             b_affine =BLOC( condition = "VARI_SECT=='AFFINE'",
               CARA            =SIMP(statut='o',typ='TXM',validators=NoRepeat(),min=3 ,max=6,
                                     into=("HY","EPY", "HZ1","EPZ1","HZ2","EPZ2") ),
               VALE            =SIMP(statut='o',typ='R',min=3 ,max=6),
             ),
           ),
           b_cercle        =BLOC( condition = "SECTION=='CERCLE'",
             VARI_SECT       =SIMP(statut='f',typ='TXM',into=("CONSTANT","HOMOTHETIQUE"),defaut="CONSTANT"),
             b_constant      =BLOC( condition = "VARI_SECT=='CONSTANT'",
               CARA            =SIMP(statut='o',typ='TXM',validators=NoRepeat(),min=1 ,max=2,
                                 fr="R est un paramtre obligatoire",
                                     into=("R","EP") ),
               VALE            =SIMP(statut='o',typ='R',min=1 ,max=2),
             ),
             b_homothetique  =BLOC( condition = "VARI_SECT=='HOMOTHETIQUE'",
               CARA            =SIMP(statut='o',typ='TXM',validators=NoRepeat(),min=2 ,max=4,
                                 fr="R1, R2 sont des paramtres obligatoires",
                                     into=("R1","R2","EP1","EP2") ),
               VALE            =SIMP(statut='o',typ='R',min=2 ,max=4),
             ),
             MODI_METRIQUE   =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
             FCX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
             TUYAU_NSEC      =SIMP(statut='f',typ='I',val_max=32,defaut=16),
             TUYAU_NCOU      =SIMP(statut='f',typ='I',val_max=10,defaut=3),
           ),
         ),

#============================================================================
         BARRE           =FACT(statut='f',max='**',
           regles=(UN_PARMI('MAILLE','GROUP_MA'),),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           SECTION         =SIMP(statut='o',typ='TXM',into=("GENERALE","RECTANGLE","CERCLE") ),
           b_generale      =BLOC( condition = "SECTION=='GENERALE'",
             CARA            =SIMP(statut='o',typ='TXM',into=("A",) ),
             VALE            =SIMP(statut='o',typ='R',min=1,max=1 ),
           ),
           b_rectangle     =BLOC( condition = "SECTION=='RECTANGLE'",
             CARA            =SIMP(statut='o',typ='TXM',into=("H","EP",
                                                              "HZ","HY","EPY","EPZ"),
                                                        validators=NoRepeat(),min=1,max=4 ),
             VALE            =SIMP(statut='o',typ='R',min=1,max=4 ),
           ),
           b_cercle        =BLOC( condition = "SECTION=='CERCLE'",
             CARA            =SIMP(statut='o',typ='TXM',validators=NoRepeat(),min=1,max=2,into=("R","EP") ),
             VALE            =SIMP(statut='o',typ='R',min=1,max=2 ),
           ),
           FCX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

#============================================================================
         COQUE           =FACT(statut='f',max='**',
           regles=(UN_PARMI('MAILLE','GROUP_MA' ),
                   PRESENT_PRESENT( 'EXCENTREMENT','INER_ROTA' ),
                   AU_MOINS_UN('EPAIS','EPAIS_F',),PRESENT_ABSENT('EPAIS','EPAIS_F',),
                   EXCLUS('ANGL_REP','VECTEUR'),),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           EPAIS           =SIMP(statut='f',typ='R' ),
           EPAIS_F         =SIMP(statut='f',typ=(para_sensi,),min=1 ,max=1 ),
           ANGL_REP        =SIMP(statut='f',typ='R',min=2,max=2),
           VECTEUR         =SIMP(statut='f',typ='R',min=3,max=3),
           A_CIS           =SIMP(statut='c',typ='R',defaut= 0.8333333E0),
           COEF_RIGI_DRZ   =SIMP(statut='f',typ='R',defaut= 1.0E-5 ),
           COQUE_NCOU      =SIMP(statut='f',typ='I',defaut= 1 ),
           EXCENTREMENT    =SIMP(statut='f',typ='R' ),
           INER_ROTA       =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MODI_METRIQUE   =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         ),

#============================================================================
         CABLE           =FACT(statut='f',max='**',
           regles=(UN_PARMI('MAILLE','GROUP_MA'),),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           N_INIT          =SIMP(statut='f',typ='R',defaut= 5000. ),
           SECTION         =SIMP(statut='f',typ='R' ),
           FCX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

#============================================================================
         DISCRET         =FACT(statut='f',max='**',
           REPERE          =SIMP(statut='f',typ='TXM',into=("LOCAL","GLOBAL") ),
           AMOR_HYST       =SIMP(statut='f',typ='R' ),
           SYME            =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           CARA            =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=1,
          fr="Affectation de matrices de rigidit, de masse ou d'amortissement  des mailles ou noeuds",
                                 into=("K_T_D_N","K_T_D_L","K_TR_D_N","K_TR_D_L",
                                       "K_T_N",  "K_T_L",  "K_TR_N",  "K_TR_L",
                                       "M_T_D_N","M_TR_D_N","M_T_N",
                                       "M_T_L",  "M_TR_N",  "M_TR_L",
                                       "A_T_D_N","A_TR_D_N","A_T_D_L","A_TR_D_L",
                                       "A_T_N",  "A_T_L",   "A_TR_N", "A_TR_L",
                                       "K_T_N_NS",  "K_T_L_NS",  "K_TR_N_NS",  "K_TR_L_NS",
                                       "M_T_N_NS",
                                       "M_T_L_NS",  "M_TR_N_NS",  "M_TR_L_NS",
                                       "A_T_N_NS",  "A_T_L_NS",  "A_TR_N_NS",  "A_TR_L_NS") ),

# affection des caractristiques de RIGIDITE/AMORTISSEMENT
              b_K_T_D_N  =BLOC(condition = "(CARA=='K_T_D_N')or(CARA=='A_T_D_N')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE     =SIMP(statut='f',typ='R',min=3 ,max=3 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=3 ,max=3 ),),
              b_K_T_D_L  =BLOC(condition = "(CARA=='K_T_D_L')or(CARA=='A_T_D_L')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=3 ,max=3 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=3 ,max=3 ),),
              b_K_TR_D_N =BLOC(condition = "(CARA=='K_TR_D_N')or(CARA=='A_TR_D_N')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=6 ,max=6 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=6 ,max=6 ),),
              b_K_TR_D_L =BLOC(condition = "(CARA=='K_TR_D_L')or(CARA=='A_TR_D_L')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=6 ,max=6 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=6 ,max=6 ),),
              b_K_T_N    =BLOC(condition = "(CARA=='K_T_N')or(CARA=='A_T_N')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=6 ,max=6 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=6 ,max=6 ),),
              b_K_T_L    =BLOC(condition = "(CARA=='K_T_L')or(CARA=='A_T_L')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=21,max=21),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=21 ,max=21 ),),
              b_K_TR_N   =BLOC(condition = "(CARA=='K_TR_N')or(CARA=='A_TR_N')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=21,max=21),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=21 ,max=21 ),),
              b_K_TR_L   =BLOC(condition = "(CARA=='K_TR_L')or(CARA=='A_TR_L')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=78,max=78),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=78 ,max=78 ),),
              b_K_T_N_NS    =BLOC(condition = "(CARA=='K_T_N_NS')or(CARA=='A_T_N_NS')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=9 ,max=9 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=9 ,max=9 ),),
              b_K_T_L_NS    =BLOC(condition = "(CARA=='K_T_L_NS')or(CARA=='A_T_L_NS')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=36,max=36),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=36 ,max=36 ),),
              b_K_TR_N_NS   =BLOC(condition = "(CARA=='K_TR_N_NS')or(CARA=='A_TR_N_NS')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=36,max=36),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=36 ,max=36 ),),
              b_K_TR_L_NS   =BLOC(condition = "(CARA=='K_TR_L_NS')or(CARA=='A_TR_L_NS')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=144,max=144),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=144 ,max=144 ),),

# affection des caractristiques de MASSE
              b_M_T_D_N  =BLOC(condition = "CARA=='M_T_D_N'",
          fr="NOEUD: 1 valeur de masse",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=1 ,max=1 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=1 ,max=1 ),),
              b_M_TR_D_N =BLOC(condition = "CARA=='M_TR_D_N'",
          fr="NOEUD: 1 valeur de masse, 6 valeurs du tenseur d'inertie, 3 composantes du vecteur d'excentricit",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=10,max=10),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=10 ,max=10 ),),
              b_M_T_N    =BLOC(condition = "CARA=='M_T_N'",
          fr="NOEUD: 6 valeurs de masse (triangulaire suprieure par colonne)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=6 ,max=6 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=6 ,max=6 ),),
              b_M_T_L    =BLOC(condition = "CARA=='M_T_L'",
          fr="SEGMENT: 21 valeurs de masse (triangulaire suprieure par colonne)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=21,max=21),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=21 ,max=21 ),),
              b_M_TR_N   =BLOC(condition = "CARA=='M_TR_N'",
          fr="NOEUD: 21 valeurs de masse (triangulaire suprieure par colonne)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=21,max=21),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=21 ,max=21 ),),
              b_M_TR_L   =BLOC(condition = "CARA=='M_TR_L'",
          fr="SEGMENT: 78 valeurs de masse (triangulaire suprieure par colonne)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=78,max=78),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=78 ,max=78 ),),
              b_M_T_N_NS    =BLOC(condition = "CARA=='M_T_N_NS'",
          fr="NOEUD: 9 valeurs de masse (pleine)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=9 ,max=9 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=9 ,max=9 ),),
              b_M_T_L_NS    =BLOC(condition = "CARA=='M_T_L_NS'",
          fr="SEGMENT: 36 valeurs de masse (pleine)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=36,max=36),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=36 ,max=36 ),),
              b_M_TR_N_NS   =BLOC(condition = "CARA=='M_TR_N_NS'",
          fr="NOEUD: 36 valeurs de masse (pleine)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=36,max=36),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=36 ,max=36 ),),
              b_M_TR_L_NS   =BLOC(condition = "CARA=='M_TR_L_NS'",
          fr="SEGMENT: 144 valeurs de masse (pleine)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=144,max=144),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=144 ,max=144 ),),
         ),

#============================================================================
         DISCRET_2D      =FACT(statut='f',max='**',
           REPERE          =SIMP(statut='f',typ='TXM',into=("LOCAL","GLOBAL") ),
           AMOR_HYST       =SIMP(statut='f',typ='R' ),
           SYME            =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           CARA            =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=1,
          fr="Affectation de matrices de rigidit, de masse ou d'amortissement  des mailles ou noeuds",
                                 into=("K_T_D_N","K_T_D_L","K_TR_D_N","K_TR_D_L",
                                       "K_T_N",  "K_T_L",  "K_TR_N",  "K_TR_L",
                                       "M_T_D_N","M_T_N",  "M_TR_D_N",
                                       "M_T_L",  "M_TR_N",  "M_TR_L",
                                       "A_T_D_N","A_TR_D_N","A_T_D_L","A_TR_D_L",
                                       "A_T_N",  "A_T_L",   "A_TR_N", "A_TR_L",
                                       "K_T_N_NS",  "K_T_L_NS",  "K_TR_N_NS",  "K_TR_L_NS",
                                       "M_T_N_NS",  "M_T_L_NS",  "M_TR_N_NS",  "M_TR_L_NS",
                                       "A_T_N_NS",  "A_T_L_NS",   "A_TR_N_NS", "A_TR_L_NS") ),

# affection des caractristiques de RIGIDITE/AMORTISSEMENT
              b_K_T_D_N  =BLOC(condition = "(CARA=='K_T_D_N')or(CARA=='A_T_D_N')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=2 ,max=2 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=2 ,max=2 ),),
              b_K_T_D_L  =BLOC(condition = "(CARA=='K_T_D_L')or(CARA=='A_T_D_L')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=2 ,max=2 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=2 ,max=2 ),),
              b_K_TR_D_N =BLOC(condition = "(CARA=='K_TR_D_N')or(CARA=='A_TR_D_N')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=3 ,max=3 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=3 ,max=3 ),),
              b_K_TR_D_L =BLOC(condition = "(CARA=='K_TR_D_L')or(CARA=='A_TR_D_L')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=3 ,max=3 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=3 ,max=3 ),),
              b_K_T_N    =BLOC(condition = "(CARA=='K_T_N')or(CARA=='A_T_N')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=3 ,max=3 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=3 ,max=3 ),),
              b_K_T_L    =BLOC(condition = "(CARA=='K_T_L')or(CARA=='A_T_L')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=10,max=10),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=10 ,max=10 ),),
              b_K_TR_N   =BLOC(condition = "(CARA=='K_TR_N')or(CARA=='A_TR_N')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=6 ,max=6),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=6 ,max=6 ),),
              b_K_TR_L   =BLOC(condition = "(CARA=='K_TR_L')or(CARA=='A_TR_L')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=21,max=21),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=21 ,max=21 ),),
              
              b_K_T_N_NS    =BLOC(condition = "(CARA=='K_T_N_NS')or(CARA=='A_T_N_NS')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=4 ,max=4 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=4 ,max=4 ),),
              b_K_T_L_NS    =BLOC(condition = "(CARA=='K_T_L_NS')or(CARA=='A_T_L_NS')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=16,max=16),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=16 ,max=16 ),),
              b_K_TR_N_NS   =BLOC(condition = "(CARA=='K_TR_N_NS')or(CARA=='A_TR_N_NS')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=9 ,max=9),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=9 ,max=9 ),),
              b_K_TR_L_NS   =BLOC(condition = "(CARA=='K_TR_L_NS')or(CARA=='A_TR_L_NS')",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=36,max=36),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=36 ,max=36 ),),

# affection des caractristiques de MASSE
              b_M_T_D_N  =BLOC(condition = "CARA=='M_T_D_N'",
          fr="NOEUD: 1 valeur de masse",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=1 ,max=1 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=1 ,max=1 ),),
              b_M_TR_D_N =BLOC(condition = "CARA=='M_TR_D_N'",
          fr="NOEUD: 1 valeur de masse(m), 1 valeur d'inertie(Izz), 2 composantes du vecteur d'excentricit(ex,ey) ",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=4 ,max=4 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=4 ,max=4 ),),
              b_M_T_N    =BLOC(condition = "CARA=='M_T_N'",
          fr="NOEUD: 3 valeurs de masse (triangulaire suprieure par colonne)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=3 ,max=3 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=3 ,max=3 ),),
              b_M_T_L    =BLOC(condition = "CARA=='M_T_L'",
          fr="SEGMENT: 10 valeurs de masse (triangulaire suprieure par colonne)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=10,max=10),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=10 ,max=10 ),),
              b_M_TR_N   =BLOC(condition = "CARA=='M_TR_N'",
          fr="NOEUD: 6 valeurs de masse (triangulaire suprieure par colonne)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=6 ,max=6 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=6 ,max=6 ),),
              b_M_TR_L   =BLOC(condition = "CARA=='M_TR_L'",
          fr="SEGMENT: 21 valeurs de masse (triangulaire suprieure par colonne)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=21,max=21),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=21 ,max=21 ),),
              b_M_T_N_NS    =BLOC(condition = "CARA=='M_T_N_NS'",
          fr="NOEUD: 4 valeurs de masse (triangulaire suprieure par colonne)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=4 ,max=4 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=4 ,max=4 ),),
              b_M_T_L_NS    =BLOC(condition = "CARA=='M_T_L_NS'",
          fr="SEGMENT: 16 valeurs de masse (triangulaire suprieure par colonne)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=16,max=16),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=16 ,max=16 ),),
              b_M_TR_N_NS   =BLOC(condition = "CARA=='M_TR_N_NS'",
          fr="NOEUD: 9 valeurs de masse (triangulaire suprieure par colonne)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               NOEUD    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               GROUP_NO =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=9 ,max=9 ),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=9 ,max=9 ),),
              b_M_TR_L_NS   =BLOC(condition = "CARA=='M_TR_L_NS'",
          fr="SEGMENT: 36 valeurs de masse (triangulaire suprieure par colonne)",
                               regles=(UN_PARMI('MAILLE','GROUP_MA'),
                                       AU_MOINS_UN('VALE','VALE_F',),PRESENT_ABSENT('VALE','VALE_F',),),
                               MAILLE   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                               GROUP_MA =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                               VALE =SIMP(statut='f',typ='R',min=36,max=36),
                               VALE_F =SIMP(statut='f',typ=(para_sensi,),min=36 ,max=36 ),),
         ),

#============================================================================
         ORIENTATION     =FACT(statut='f',max='**',
           regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO' ),),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           CARA            =SIMP(statut='o',typ='TXM',
                                 into=("VECT_Y","ANGL_VRIL","VECT_X_Y","ANGL_NAUT","GENE_TUYAU") ),
           VALE            =SIMP(statut='o',typ='R',max='**'),
           PRECISION       =SIMP(statut='f',typ='R',defaut= 1.0E-4 ),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
         ),

#============================================================================
         DEFI_ARC        =FACT(statut='f',max='**',
           regles=(UN_PARMI('MAILLE','GROUP_MA'),
                   UN_PARMI('ORIE_ARC','CENTRE','NOEUD_CENTRE','GROUP_NO_CENTRE',
                            'POIN_TANG','NOEUD_POIN_TANG','GROUP_NO_POIN_TG'),
                   PRESENT_PRESENT('ORIE_ARC','RAYON'),
                   EXCLUS('COEF_FLEX','COEF_FLEX_XY'),
                   EXCLUS('COEF_FLEX','COEF_FLEX_XZ'),
                   EXCLUS('INDI_SIGM','INDI_SIGM_XY'),
                   EXCLUS('INDI_SIGM','INDI_SIGM_XZ'),
                   PRESENT_PRESENT('COEF_FLEX_XY','COEF_FLEX_XZ'),
                   PRESENT_PRESENT('INDI_SIGM_XY','INDI_SIGM_XZ'),),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           ORIE_ARC        =SIMP(statut='f',typ='R'),
           CENTRE          =SIMP(statut='f',typ='R',max='**'),
           NOEUD_CENTRE    =SIMP(statut='f',typ=no),
           GROUP_NO_CENTRE =SIMP(statut='f',typ=grno),
           POIN_TANG       =SIMP(statut='f',typ='R',max='**'),
           NOEUD_POIN_TANG =SIMP(statut='f',typ=no),
           GROUP_NO_POIN_TG=SIMP(statut='f',typ=grno),
           RAYON           =SIMP(statut='f',typ='R'),
           COEF_FLEX       =SIMP(statut='f',typ='R'),
           INDI_SIGM       =SIMP(statut='f',typ='R'),
           COEF_FLEX_XY    =SIMP(statut='f',typ='R'),
           INDI_SIGM_XY    =SIMP(statut='f',typ='R'),
           COEF_FLEX_XZ    =SIMP(statut='f',typ='R'),
           INDI_SIGM_XZ    =SIMP(statut='f',typ='R'),
           PRECISION       =SIMP(statut='f',typ='R',defaut= 1.0E-3),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
         ),

#============================================================================
         MASSIF          =FACT(statut='f',max='**',
           regles=(UN_PARMI('MAILLE','GROUP_MA'),
                   UN_PARMI('ANGL_REP','ANGL_AXE','ANGL_EULER'),
                   EXCLUS('ANGL_REP','ANGL_EULER'),
                   EXCLUS('ANGL_REP','ANGL_AXE'),
                   EXCLUS('ANGL_REP','ORIG_AXE'),
                   PRESENT_PRESENT('ANGL_AXE','ORIG_AXE'), ),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           ANGL_REP        =SIMP(statut='f',typ='R',max=3),
           ANGL_EULER      =SIMP(statut='f',typ='R',min=3,max=3),
           ANGL_AXE        =SIMP(statut='f',typ='R',max=2),
           ORIG_AXE        =SIMP(statut='f',typ='R',max=3),
         ),


#============================================================================
         POUTRE_FLUI     =FACT(statut='f',max='**',
           regles=(UN_PARMI('MAILLE','GROUP_MA'),),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           B_T             =SIMP(statut='o',typ='R'),
           B_N             =SIMP(statut='o',typ='R'),
           B_TN            =SIMP(statut='o',typ='R',defaut= 0.E+0 ),
           A_FLUI          =SIMP(statut='o',typ='R'),
           A_CELL          =SIMP(statut='o',typ='R'),
           COEF_ECHELLE    =SIMP(statut='o',typ='R'),
         ),

#============================================================================
         GRILLE          =FACT(statut='f',max='**',
           regles=(UN_PARMI('MAILLE','GROUP_MA'),
                   EXCLUS('ANGL_REP','ORIG_AXE'),
                   ENSEMBLE('ORIG_AXE','AXE')),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           SECTION         =SIMP(statut='o',typ='R'),
           ANGL_REP        =SIMP(statut='f',typ='R',max=2),
           EXCENTREMENT    =SIMP(statut='f',typ='R'),
           ORIG_AXE        =SIMP(statut='f',typ='R',max='**'),
           AXE             =SIMP(statut='f',typ='R',max='**'),
           COEF_RIGI_DRZ   =SIMP(statut='f',typ='R',defaut= 1.0E-10 ),
           GRILLE_NCOU     =SIMP(statut='f',typ='I',defaut= 1,),
         ),

#============================================================================
         RIGI_PARASOL    =FACT(statut='f',max='**',
            regles=(UN_PARMI('COEF_GROUP','FONC_GROUP'),
                    UN_PARMI('COOR_CENTRE','NOEUD_CENTRE','GROUP_NO_CENTRE'),
                    EXCLUS('GROUP_MA_POI1','GROUP_MA_SEG2'),),
            GROUP_MA        =SIMP(statut='o',typ=ma,validators=NoRepeat(),max='**',
               fr="Surface servant  rpartir les caractristiques des discrets"),
            GROUP_MA_POI1   =SIMP(statut='f',typ=ma,validators=NoRepeat(),max=1,
               fr="Mailles de type point correspondant aux discrets"),
            GROUP_MA_SEG2   =SIMP(statut='f',typ=ma,validators=NoRepeat(),max=1,
               fr="Mailles de type seg2 correspondant aux discrets"),
            FONC_GROUP      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
            COEF_GROUP      =SIMP(statut='f',typ='R',max='**'),
            REPERE          =SIMP(statut='f',typ='TXM',into=("LOCAL","GLOBAL") ),
            CARA            =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=2,
                            into=("K_TR_D_N","K_T_D_N","K_TR_D_L","K_T_D_L",
                                  "A_TR_D_N","A_T_D_N","A_TR_D_L","A_T_D_L") ),
            VALE            =SIMP(statut='o',typ='R',max='**'),
            GROUP_NO_CENTRE =SIMP(statut='f',typ=grno),
            NOEUD_CENTRE    =SIMP(statut='f',typ=no),
            COOR_CENTRE     =SIMP(statut='f',typ='R',min=2,max=3),
            UNITE_EUROPLEXUS=SIMP(statut='f',typ='I'),
         ),

#============================================================================
         RIGI_MISS_3D    =FACT(statut='f',max='**',
           GROUP_MA_POI1   =SIMP(statut='o',typ=ma,max=1),
           GROUP_MA_SEG2   =SIMP(statut='f',typ=ma,max=1),
           FREQ_EXTR       =SIMP(statut='o',typ='R',max=1),
           UNITE_RESU_IMPE =SIMP(statut='f',typ='I',defaut=30),
         ),

#============================================================================
         GEOM_FIBRE = SIMP(statut='f',max=1,typ=gfibre_sdaster,
                   fr="Donner le nom de la SD regroupant tous les groupes de fibres (issue de DEFI_GEOM_FIBRE)"),
         MULTIFIBRE     =FACT(statut='f',max='**',
              regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),),

              GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),

              GROUP_FIBRE     =SIMP(statut='o',typ='TXM',max='**'),

         ),



) ;
#& MODIF COMMANDE  DATE 16/09/2008   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE None
AFFE_CHAR_ACOU=OPER(nom="AFFE_CHAR_ACOU",op=  68,sd_prod=char_acou,
                    fr="Affectation de charges et conditions aux limites acoustiques constantes",
                    reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
         regles=(AU_MOINS_UN('PRES_IMPO','VITE_FACE','IMPE_FACE','LIAISON_UNIF' ),),
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         VERI_DDL        =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         METHODE         =SIMP(statut='c',typ='TXM',fr="Stratgie de rsolution pour les pressions imposes",
                               into=('DUALISATION',),defaut='DUALISATION',),
                               # METHODE='ELIMINATION' est trait dans le fortran mais dangereux actuellement
         PRES_IMPO       =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           PRES            =SIMP(statut='o',typ='C' ),
         ),
         VITE_FACE       =FACT(statut='f',max='**',
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           VNOR            =SIMP(statut='o',typ='C' ),
         ),
         IMPE_FACE       =FACT(statut='f',max='**',
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           IMPE            =SIMP(statut='o',typ='C' ),
         ),
         LIAISON_UNIF    =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE' ),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           DDL             =SIMP(statut='o',typ='TXM',max='**'),
         ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
def affe_char_cine_prod(MECA_IMPO,THER_IMPO,ACOU_IMPO,EVOL_IMPO,**args):
  if MECA_IMPO != None  : return char_cine_meca
  if THER_IMPO != None  : return char_cine_ther
  if ACOU_IMPO != None  : return char_cine_acou
  if EVOL_IMPO != None  :
      if AsType(EVOL_IMPO) in (evol_elas,evol_noli) :
          return char_cine_meca
      elif AsType(EVOL_IMPO) in (evol_ther,) :
          return char_cine_ther
      else :
          raise AsException("Extension  faire ...")

  raise AsException("type de concept resultat non prevu")


AFFE_CHAR_CINE=OPER(nom="AFFE_CHAR_CINE",op= 101,sd_prod=affe_char_cine_prod
                    ,fr="Affectation de conditions aux limites cinmatiques constantes pour un traitement sans dualisation",
                     reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
         regles=(UN_PARMI('MECA_IMPO','THER_IMPO','ACOU_IMPO','EVOL_IMPO'),
                 ),
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         EVOL_IMPO  =SIMP(statut='f',typ=(evol_noli,evol_elas,evol_ther),fr="Pour imposer tous les ddls d'un evol_xxx"),
         MECA_IMPO       =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                   AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI',
                               'TEMP','PRE1','PRE2','UI2','UI3','VI2','VI3','WI2','WI3','UO2',
                               'UO3','VO2','VO3','WO2','WO3','UI4','UI5','VI4','VI5','WI4',
                               'WI5','UO4','UO5','VO4','VO5','WO4','WO5','UI6','UO6','VI6',
                               'VO6','WI6','WO6','WO','WI1','WO1','GONF','DCX','DCY','DCZ',
                               'H1X','H1Y','H1Z','E1X','E1Y','E1Z','E2X','E2Y','E2Z',
                               'E3X','E3Y','E3Z','E4X','E4Y','E4Z','V11','V12','V13','V21','V22',
                               'V23','V31','V32','V33','PRES11','PRES12','PRES13','PRES21',
                               'PRES22','PRES23','PRES31','PRES32','PRES33'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             DX              =SIMP(statut='f',typ='R' ),
             DY              =SIMP(statut='f',typ='R' ),
             DZ              =SIMP(statut='f',typ='R' ),
             DRX             =SIMP(statut='f',typ='R' ),
             DRY             =SIMP(statut='f',typ='R' ),
             DRZ             =SIMP(statut='f',typ='R' ),
             GRX             =SIMP(statut='f',typ='R' ),
             PRES            =SIMP(statut='f',typ='R' ),
             PHI             =SIMP(statut='f',typ='R' ),
             TEMP            =SIMP(statut='f',typ='R' ),
             PRE1            =SIMP(statut='f',typ='R' ),
             PRE2            =SIMP(statut='f',typ='R' ),
             UI2             =SIMP(statut='f',typ='R' ),
             UI3             =SIMP(statut='f',typ='R' ),
             UI4             =SIMP(statut='f',typ='R' ),
             UI5             =SIMP(statut='f',typ='R' ),
             UI6             =SIMP(statut='f',typ='R' ),
             UO2             =SIMP(statut='f',typ='R' ),
             UO3             =SIMP(statut='f',typ='R' ),
             UO4             =SIMP(statut='f',typ='R' ),
             UO5             =SIMP(statut='f',typ='R' ),
             UO6             =SIMP(statut='f',typ='R' ),
             VI2             =SIMP(statut='f',typ='R' ),
             VI3             =SIMP(statut='f',typ='R' ),
             VI4             =SIMP(statut='f',typ='R' ),
             VI5             =SIMP(statut='f',typ='R' ),
             VI6             =SIMP(statut='f',typ='R' ),
             VO2             =SIMP(statut='f',typ='R' ),
             VO3             =SIMP(statut='f',typ='R' ),
             VO4             =SIMP(statut='f',typ='R' ),
             VO5             =SIMP(statut='f',typ='R' ),
             VO6             =SIMP(statut='f',typ='R' ),
             WI2             =SIMP(statut='f',typ='R' ),
             WI3             =SIMP(statut='f',typ='R' ),
             WI4             =SIMP(statut='f',typ='R' ),
             WI5             =SIMP(statut='f',typ='R' ),
             WI6             =SIMP(statut='f',typ='R' ),
             WO2             =SIMP(statut='f',typ='R' ),
             WO3             =SIMP(statut='f',typ='R' ),
             WO4             =SIMP(statut='f',typ='R' ),
             WO5             =SIMP(statut='f',typ='R' ),
             WO6             =SIMP(statut='f',typ='R' ),
             WO              =SIMP(statut='f',typ='R' ),
             WI1             =SIMP(statut='f',typ='R' ),
             WO1             =SIMP(statut='f',typ='R' ),
             GONF            =SIMP(statut='f',typ='R' ),
             DCX             =SIMP(statut='f',typ='R' ),
             DCY             =SIMP(statut='f',typ='R' ),
             DCZ             =SIMP(statut='f',typ='R' ),
             H1X             =SIMP(statut='f',typ='R' ),
             H1Y             =SIMP(statut='f',typ='R' ),
             H1Z             =SIMP(statut='f',typ='R' ),
             E1X             =SIMP(statut='f',typ='R' ),
             E1Y             =SIMP(statut='f',typ='R' ),
             E1Z             =SIMP(statut='f',typ='R' ),
             E2X             =SIMP(statut='f',typ='R' ),
             E2Y             =SIMP(statut='f',typ='R' ),
             E2Z             =SIMP(statut='f',typ='R' ),
             E3X             =SIMP(statut='f',typ='R' ),
             E3Y             =SIMP(statut='f',typ='R' ),
             E3Z             =SIMP(statut='f',typ='R' ),
             E4X             =SIMP(statut='f',typ='R' ),
             E4Y             =SIMP(statut='f',typ='R' ),
             E4Z             =SIMP(statut='f',typ='R' ),
             V11             =SIMP(statut='f',typ='R' ),
             V12             =SIMP(statut='f',typ='R' ),
             V13             =SIMP(statut='f',typ='R' ),
             V21             =SIMP(statut='f',typ='R' ),
             V22             =SIMP(statut='f',typ='R' ),
             V23             =SIMP(statut='f',typ='R' ),
             V31             =SIMP(statut='f',typ='R' ),
             V32             =SIMP(statut='f',typ='R' ),
             V33             =SIMP(statut='f',typ='R' ),
             PRES11          =SIMP(statut='f',typ='R' ),
             PRES12          =SIMP(statut='f',typ='R' ),
             PRES13          =SIMP(statut='f',typ='R' ),
             PRES21          =SIMP(statut='f',typ='R' ),
             PRES22          =SIMP(statut='f',typ='R' ),
             PRES23          =SIMP(statut='f',typ='R' ),
             PRES31          =SIMP(statut='f',typ='R' ),
             PRES32          =SIMP(statut='f',typ='R' ),
             PRES33          =SIMP(statut='f',typ='R' ),
         ),
         THER_IMPO       =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                   AU_MOINS_UN('TEMP','TEMP_INF','TEMP_SUP'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           TEMP_SUP        =SIMP(statut='f',typ='R' ),
           TEMP            =SIMP(statut='f',typ='R' ),
           TEMP_INF        =SIMP(statut='f',typ='R' ),
         ),
         ACOU_IMPO       =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           PRES            =SIMP(statut='o',typ='C' ),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
def affe_char_cine_f_prod(MECA_IMPO,THER_IMPO,**args):
  if MECA_IMPO != None  : return char_cine_meca
  if THER_IMPO != None  : return char_cine_ther
  raise AsException("type de concept resultat non prevu")

AFFE_CHAR_CINE_F=OPER(nom="AFFE_CHAR_CINE_F",op= 101,sd_prod=affe_char_cine_f_prod,
                      fr="Affectation de conditions aux limites cinmatiques fonction d'un (ou plusieurs) paramtres"
                        +" pour un traitement sans dualisation",
                     reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
         regles=(UN_PARMI('MECA_IMPO','THER_IMPO')),
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         MECA_IMPO       =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                   AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','TEMP','PHI'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           DX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRY             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRZ             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           GRX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PHI             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),
         THER_IMPO       =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                   AU_MOINS_UN('TEMP','TEMP_INF','TEMP_SUP' ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           TEMP_SUP        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP_INF        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 06/05/2009   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
AFFE_CHAR_MECA=OPER(nom="AFFE_CHAR_MECA",op=   7,sd_prod=char_meca,
                    fr="Affectation de charges et conditions aux limites mcaniques constantes",
                     reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
         regles=(AU_MOINS_UN('DDL_IMPO','FACE_IMPO','CHAMNO_IMPO','LIAISON_DDL','LIAISON_XFEM','FORCE_NODALE',
                             'FORCE_FACE','FORCE_ARETE','FORCE_CONTOUR','FORCE_INTERNE',
                             'PRES_REP','FORCE_POUTRE','FORCE_COQUE','LIAISON_OBLIQUE',
                             'FORCE_ELEC','INTE_ELEC','PESANTEUR','ROTATION','IMPE_FACE',
                             'VITE_FACE','RELA_CINE_BP','EPSI_INIT','CONTACT',
                             'LIAISON_GROUP','LIAISON_UNIF','FLUX_THM_REP','LIAISON_SOLIDE',
                             'LIAISON_ELEM','ONDE_FLUI','LIAISON_CHAMNO','VECT_ASSE','LIAISON_COQUE',
                             'LIAISON_MAIL','LIAISON_CYCL','FORCE_TUYAU',
                             'EFFE_FOND','EVOL_CHAR','ARLEQUIN','DDL_POUTRE','GRAPPE_FLUIDE',
                             'LIAISON_UNILATER'),
                         ),
         VERI_NORM       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         MODELE          =SIMP(statut='o',typ=(modele_sdaster) ),
         EVOL_CHAR       =SIMP(statut='f',fr="Champ de pression issu d'un autre calcul",
                               typ=evol_char ),

         PESANTEUR       =SIMP(statut='f',typ='R',fr="Champ de pesanteur",min=4,max=4),
         METHODE         =SIMP(statut='c',typ='TXM',fr="Stratgie de rsolution pour les dplacements imposs",
                               into=('DUALISATION',),defaut='DUALISATION',),
                               # METHODE='ELIMINATION' est trait dans le fortran mais dangereux actuellement
         ROTATION        =SIMP(statut='f',typ='R',fr="Champ de rotation", min=4,max=4),
         b_rotation      =BLOC ( condition = "ROTATION != None",
           CENTRE          =SIMP(statut='f',typ='R',defaut=(0.,0.,0.),max=3),),

         DDL_IMPO        =FACT(statut='f',max='**',
             fr="Impose  des noeuds une ou plusieurs valeurs de dplacement (ou de certaines grandeurs asscocies)",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                     AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI',
                                 'TEMP','PRE1','PRE2','UI2','UI3','VI2','VI3','WI2','WI3','UO2',
                                 'UO3','VO2','VO3','WO2','WO3','UI4','UI5','VI4','VI5','WI4',
                                 'WI5','UO4','UO5','VO4','VO5','WO4','WO5','UI6','UO6','VI6',
                                 'VO6','WI6','WO6','WO','WI1','WO1','GONF','LIAISON','DCX',
                                 'DCY','DCZ','H1X','H1Y','H1Z','E1X','E1Y','E1Z','E2X','E2Y','E2Z',
                                 'E3X','E3Y','E3Z','E4X','E4Y','E4Z','LAGS_C','V11','V12','V13','V21','V22',
                                 'V23','V31','V32','V33','PRES11','PRES12','PRES13','PRES21','PRES22','PRES23',
                                 'PRES31','PRES32','PRES33',),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             LIAISON         =SIMP(statut='f',typ='TXM',into=('ENCASTRE',)),
             DX              =SIMP(statut='f',typ='R' ),
             DY              =SIMP(statut='f',typ='R' ),
             DZ              =SIMP(statut='f',typ='R' ),
             DRX             =SIMP(statut='f',typ='R' ),
             DRY             =SIMP(statut='f',typ='R' ),
             DRZ             =SIMP(statut='f',typ='R' ),
             GRX             =SIMP(statut='f',typ='R' ),
             PRES            =SIMP(statut='f',typ='R' ),
             PHI             =SIMP(statut='f',typ='R' ),
             TEMP            =SIMP(statut='f',typ='R' ),
             PRE1            =SIMP(statut='f',typ='R' ),
             PRE2            =SIMP(statut='f',typ='R' ),
             UI2             =SIMP(statut='f',typ='R' ),
             UI3             =SIMP(statut='f',typ='R' ),
             UI4             =SIMP(statut='f',typ='R' ),
             UI5             =SIMP(statut='f',typ='R' ),
             UI6             =SIMP(statut='f',typ='R' ),
             UO2             =SIMP(statut='f',typ='R' ),
             UO3             =SIMP(statut='f',typ='R' ),
             UO4             =SIMP(statut='f',typ='R' ),
             UO5             =SIMP(statut='f',typ='R' ),
             UO6             =SIMP(statut='f',typ='R' ),
             VI2             =SIMP(statut='f',typ='R' ),
             VI3             =SIMP(statut='f',typ='R' ),
             VI4             =SIMP(statut='f',typ='R' ),
             VI5             =SIMP(statut='f',typ='R' ),
             VI6             =SIMP(statut='f',typ='R' ),
             VO2             =SIMP(statut='f',typ='R' ),
             VO3             =SIMP(statut='f',typ='R' ),
             VO4             =SIMP(statut='f',typ='R' ),
             VO5             =SIMP(statut='f',typ='R' ),
             VO6             =SIMP(statut='f',typ='R' ),
             WI2             =SIMP(statut='f',typ='R' ),
             WI3             =SIMP(statut='f',typ='R' ),
             WI4             =SIMP(statut='f',typ='R' ),
             WI5             =SIMP(statut='f',typ='R' ),
             WI6             =SIMP(statut='f',typ='R' ),
             WO2             =SIMP(statut='f',typ='R' ),
             WO3             =SIMP(statut='f',typ='R' ),
             WO4             =SIMP(statut='f',typ='R' ),
             WO5             =SIMP(statut='f',typ='R' ),
             WO6             =SIMP(statut='f',typ='R' ),
             WO              =SIMP(statut='f',typ='R' ),
             WI1             =SIMP(statut='f',typ='R' ),
             WO1             =SIMP(statut='f',typ='R' ),
             GONF            =SIMP(statut='f',typ='R' ),
             DCX             =SIMP(statut='f',typ='R' ),
             DCY             =SIMP(statut='f',typ='R' ),
             DCZ             =SIMP(statut='f',typ='R' ),
             H1X             =SIMP(statut='f',typ='R' ),
             H1Y             =SIMP(statut='f',typ='R' ),
             H1Z             =SIMP(statut='f',typ='R' ),
             E1X             =SIMP(statut='f',typ='R' ),
             E1Y             =SIMP(statut='f',typ='R' ),
             E1Z             =SIMP(statut='f',typ='R' ),
             E2X             =SIMP(statut='f',typ='R' ),
             E2Y             =SIMP(statut='f',typ='R' ),
             E2Z             =SIMP(statut='f',typ='R' ),
             E3X             =SIMP(statut='f',typ='R' ),
             E3Y             =SIMP(statut='f',typ='R' ),
             E3Z             =SIMP(statut='f',typ='R' ),
             E4X             =SIMP(statut='f',typ='R' ),
             E4Y             =SIMP(statut='f',typ='R' ),
             E4Z             =SIMP(statut='f',typ='R' ),
             LAGS_C          =SIMP(statut='f',typ='R' ),
             V11             =SIMP(statut='f',typ='R' ),
             V12             =SIMP(statut='f',typ='R' ),
             V13             =SIMP(statut='f',typ='R' ),
             V21             =SIMP(statut='f',typ='R' ),
             V22             =SIMP(statut='f',typ='R' ),
             V23             =SIMP(statut='f',typ='R' ),
             V31             =SIMP(statut='f',typ='R' ),
             V32             =SIMP(statut='f',typ='R' ),
             V33             =SIMP(statut='f',typ='R' ),
             PRES11          =SIMP(statut='f',typ='R' ),
             PRES12          =SIMP(statut='f',typ='R' ),
             PRES13          =SIMP(statut='f',typ='R' ),
             PRES21          =SIMP(statut='f',typ='R' ),
             PRES22          =SIMP(statut='f',typ='R' ),
             PRES23          =SIMP(statut='f',typ='R' ),
             PRES31          =SIMP(statut='f',typ='R' ),
             PRES32          =SIMP(statut='f',typ='R' ),
             PRES33          =SIMP(statut='f',typ='R' ),
           ),



         DDL_POUTRE    =FACT(statut='f',max='**',
             fr="Bloque des DDLs dans un repre local d'une poutre",
             regles=(AU_MOINS_UN('GROUP_NO','NOEUD'),
                     AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ'),
                     UN_PARMI('VECT_Y','ANGL_VRIL'),),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             DX              =SIMP(statut='f',typ='R' ),
             DY              =SIMP(statut='f',typ='R' ),
             DZ              =SIMP(statut='f',typ='R' ),
             DRX             =SIMP(statut='f',typ='R' ),
             DRY             =SIMP(statut='f',typ='R' ),
             DRZ             =SIMP(statut='f',typ='R' ),
#  dfinition du repre local
             VECT_Y          =SIMP(statut='f',typ='R',min=3,max=3),
             ANGL_VRIL       =SIMP(statut='f',typ='R',),
#  restriction sur les mailles servant  dfinir le repre local
             GROUP_MA        =SIMP(statut='f',typ=grma,),
             MAILLE          =SIMP(statut='f',typ=ma,),
                            ),



           FACE_IMPO       =FACT(statut='f',max='**',
             fr="Impose  tous les noeuds d'une face une ou plusieurs valeurs de dplacement (ou de certaines grandeurs associes)",
             regles=(UN_PARMI('GROUP_MA','MAILLE',),
                     AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI',
                                 'TEMP','PRE1','PRE2','DNOR','DTAN'),
                     EXCLUS('DNOR','DX'),
                     EXCLUS('DNOR','DY'),
                     EXCLUS('DNOR','DZ'),
                     EXCLUS('DNOR','DRX'),
                     EXCLUS('DNOR','DRY'),
                     EXCLUS('DNOR','DRZ'),
                     EXCLUS('DTAN','DX'),
                     EXCLUS('DTAN','DY'),
                     EXCLUS('DTAN','DZ'),
                     EXCLUS('DTAN','DRX'),
                     EXCLUS('DTAN','DRY'),
                     EXCLUS('DTAN','DRZ'),),
#  rajout d'un mot cl REPERE :/ LOCAL /GLOBAL
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_MA   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             SANS_MAILLE     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             DX              =SIMP(statut='f',typ='R' ),
             DY              =SIMP(statut='f',typ='R' ),
             DZ              =SIMP(statut='f',typ='R' ),
             DRX             =SIMP(statut='f',typ='R' ),
             DRY             =SIMP(statut='f',typ='R' ),
             DRZ             =SIMP(statut='f',typ='R' ),
             DNOR            =SIMP(statut='f',typ='R' ),
             DTAN            =SIMP(statut='f',typ='R' ),
             GRX             =SIMP(statut='f',typ='R' ),
             PRES            =SIMP(statut='f',typ='R' ),
             PHI             =SIMP(statut='f',typ='R' ),
             TEMP            =SIMP(statut='f',typ='R' ),
             PRE1            =SIMP(statut='f',typ='R' ),
             PRE2            =SIMP(statut='f',typ='R' ),
           ),

         CHAMNO_IMPO  =FACT(statut='f',max='**',
             fr="Impose des DDLs aux valeurs d'un concept cham_no_sdaster",
#  type de cham_no_sdaster CO()
             CHAM_NO         =SIMP(statut='o',typ=cham_no_sdaster), #CO()
             COEF_MULT       =SIMP(statut='o',typ='R' ),
             NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
           ),


           LIAISON_DDL     =FACT(statut='f',max='**',
             fr="Dfinit une relation linaire entre des DDLs de deux ou plusieurs noeuds",
             regles=(UN_PARMI('GROUP_NO','NOEUD'),),
             GROUP_NO        =SIMP(statut='f',typ=grno ,max='**'),
             NOEUD           =SIMP(statut='f',typ=no   ,max='**'),
             DDL             =SIMP(statut='o',typ='TXM',max='**'),
             COEF_MULT       =SIMP(statut='o',typ='R'  ,max='**'),
             COEF_IMPO       =SIMP(statut='o',typ='R' ),
           ),

           LIAISON_OBLIQUE =FACT(statut='f',max='**',
             fr="Applique  des noeuds la meme valeur de dplacement dfinie composante par composante"
              +" dans un repre oblique quelconque",
             regles=(UN_PARMI('GROUP_NO','NOEUD'),
                     UN_PARMI('DX','DY','DZ','DRX','DRY','DRZ'),),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             ANGL_NAUT       =SIMP(statut='o',typ='R',max=3),
             DX              =SIMP(statut='f',typ='R' ),
             DY              =SIMP(statut='f',typ='R' ),
             DZ              =SIMP(statut='f',typ='R' ),
             DRX             =SIMP(statut='f',typ='R' ),
             DRY             =SIMP(statut='f',typ='R' ),
             DRZ             =SIMP(statut='f',typ='R' ),
           ),

           LIAISON_GROUP   =FACT(statut='f',max='**',
             fr="Dfinit la meme relation linaire entre certains DDLs de couples de noeuds",
             regles=(UN_PARMI('GROUP_MA_1','MAILLE_1','GROUP_NO_1','NOEUD_1'),
                     UN_PARMI('GROUP_MA_2','MAILLE_2','GROUP_NO_2','NOEUD_2'),
                     EXCLUS('GROUP_MA_1','GROUP_NO_2'),
                     EXCLUS('GROUP_MA_1','NOEUD_2'),
                     EXCLUS('GROUP_NO_1','GROUP_MA_2'),
                     EXCLUS('GROUP_NO_1','MAILLE_2'),
                     EXCLUS('MAILLE_1','GROUP_NO_2'),
                     EXCLUS('MAILLE_1','NOEUD_2'),
                     EXCLUS('NOEUD_1','GROUP_MA_2'),
                     EXCLUS('NOEUD_1','MAILLE_2'),
                     EXCLUS('SANS_NOEUD','SANS_GROUP_NO'),),

               GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
               MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
               GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
               MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
               GROUP_NO_1      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
               NOEUD_1         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
               GROUP_NO_2      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
               NOEUD_2         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),

             SANS_NOEUD      =SIMP(statut='f',typ=no   ,validators=NoRepeat(),max='**'),
             SANS_GROUP_NO   =SIMP(statut='f',typ=grno ,validators=NoRepeat(),max='**'),
             DDL_1           =SIMP(statut='o',typ='TXM',max='**'),
             COEF_MULT_1     =SIMP(statut='o',typ='R'  ,max='**'),
             DDL_2           =SIMP(statut='o',typ='TXM',max='**'),
             COEF_MULT_2     =SIMP(statut='o',typ='R'  ,max='**'),
             COEF_IMPO       =SIMP(statut='o',typ='R' ),
             SOMMET          =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             TRAN            =SIMP(statut='f',typ='R',max=3),
             ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
             CENTRE          =SIMP(statut='f',typ='R',max=3),
           ),

           LIAISON_MAIL    =FACT(statut='f',max='**',
             fr="Dfinit des relations linaires permettant de recoller deux bords d'une structure",
             regles=(AU_MOINS_UN('GROUP_MA_MAIT','MAILLE_MAIT'),
                     AU_MOINS_UN('GROUP_MA_ESCL','MAILLE_ESCL','GROUP_NO_ESCL','NOEUD_ESCL'),
                     PRESENT_PRESENT('DDL_MAIT','DDL_ESCL'),),
              GROUP_MA_MAIT   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_MAIT     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
              GROUP_MA_ESCL   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_ESCL     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
              GROUP_NO_ESCL   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
              NOEUD_ESCL      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
              TRAN            =SIMP(statut='f',typ='R',max=3 ),
              ANGL_NAUT       =SIMP(statut='f',typ='R',max=3 ),
              CENTRE          =SIMP(statut='f',typ='R',max=3 ),
              DDL_MAIT        =SIMP(statut='f',typ='TXM',into=("DNOR",) ),
              DDL_ESCL        =SIMP(statut='f',typ='TXM',into=("DNOR",) ),
              ELIM_MULT       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         ),

           LIAISON_CYCL    =FACT(statut='f',max='**',
             fr="Dfinit des relations linaires permettant de recoller les bords de deux parties symtriquement cycliques",
             regles=(AU_MOINS_UN('GROUP_MA_MAIT1','MAILLE_MAIT1'),
                     AU_MOINS_UN('GROUP_MA_ESCL','MAILLE_ESCL','GROUP_NO_ESCL','NOEUD_ESCL'),
                     PRESENT_PRESENT('DDL_MAIT','DDL_ESCL'),
                     ),
              GROUP_MA_MAIT1   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_MAIT1     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
              GROUP_MA_MAIT2   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_MAIT2     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
              GROUP_MA_ESCL   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_ESCL     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
              GROUP_NO_ESCL   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
              NOEUD_ESCL     =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
              TRAN            =SIMP(statut='f',typ='R',max=3 ),
              ANGL_NAUT       =SIMP(statut='f',typ='R',max=3 ),
              CENTRE          =SIMP(statut='f',typ='R',max=3 ),
              COEF_MAIT1            =SIMP(statut='f',typ='R',max=1 ),
              COEF_MAIT2            =SIMP(statut='f',typ='R',max=1 ),
              COEF_ESCL            =SIMP(statut='f',typ='R',max=1 ),
              DDL_MAIT        =SIMP(statut='f',typ='TXM',into=("DNOR",) ),
              DDL_ESCL        =SIMP(statut='f',typ='TXM',into=("DNOR",) ),
         ),


           LIAISON_SOLIDE  =FACT(statut='f',max='**',
             fr="Modlise une partie indformable d'une structure."
              +" Les mots cls TRAN et ANGL_NAUT permettent d'imposer le dplacement de la partie indformable.",
             regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),
                     ENSEMBLE('CENTRE','ANGL_NAUT'),),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             TRAN            =SIMP(statut='f',typ='R',max=3 ),
             ANGL_NAUT       =SIMP(statut='f',typ='R',max=3 ),
             CENTRE          =SIMP(statut='f',typ='R',max=3 ),
             DIST_MIN        =SIMP(statut='f',typ='R'),
             NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
           ),

           LIAISON_ELEM    =FACT(statut='f',max='**',
             fr="Modlise le raccord d'une partie massive 3D avec une poutre ou avec un tuyau, le raccord d'une coque"
              +" avec une poutre ou avec un tuyau",
             regles=(UN_PARMI('GROUP_MA_1','MAILLE_1'),
                     UN_PARMI('GROUP_NO_2','NOEUD_2'),),
             OPTION          =SIMP(statut='o',typ='TXM',into=("3D_TUYAU","3D_POU","COQ_POU","COQ_TUYAU") ),
             GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_NO_2      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD_2         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
             CARA_ELEM       =SIMP(statut='f',typ=(cara_elem) ),
             AXE_POUTRE      =SIMP(statut='f',typ='R',max=3),
             ANGL_MAX        =SIMP(statut='f',typ='R',defaut= 1. ),
           ),

           LIAISON_UNIF    =FACT(statut='f',max='**',
             fr="Impose une meme valeur (inconnue)  des DDLs d'un ensemble de noeuds",
             regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             DDL             =SIMP(statut='o',typ='TXM',max='**'),
           ),

         LIAISON_CHAMNO  =FACT(statut='f',max='**',
             fr="Dfinit une relation linaire entre tous les DDLs prsents dans un concept CHAM_NO",
#  type de cham_no_sdaster CO()
             CHAM_NO         =SIMP(statut='o',typ=cham_no_sdaster), #CO()
             COEF_IMPO       =SIMP(statut='o',typ='R' ),
             NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
           ),

         LIAISON_XFEM      =SIMP(statut='f',typ='TXM',into=("OUI","NON"),defaut="NON" ),

         CONTACT_XFEM      =SIMP(statut='f',typ=char_meca,min=1,max=1,),


#         SIMP(statut='f',typ='TXM',defaut="NON" ),

         VECT_ASSE       =SIMP(statut='f',typ=cham_no_sdaster ),
#
# LIAISON UNILATERALE
#
         LIAISON_UNILATER=FACT(statut='f',max='**',
           fr="Dfinit les zones soumises  des conditions de liaison unilaterale (inegalite sur un DDL)",
           regles=(UN_PARMI('GROUP_MA','MAILLE','GROUP_NO','NOEUD'),),

           GROUP_MA        =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno ,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no   ,validators=NoRepeat(),max='**'),

           SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),

           NB_RESOL        =SIMP(statut='f',typ='I', defaut=10 ),

           NOM_CMP         =SIMP(statut='o',typ='TXM',max='**'),

           COEF_IMPO       =SIMP(statut='f',typ='R'),
           COEF_MULT       =SIMP(statut='f',typ='R',max='**'),

           METHODE         =SIMP(statut='f',typ='TXM',defaut="CONTRAINTE",
                                 into=("CONTRAINTE",) ),


        ),
#
# CONTACT
#
         CONTACT         = C_CONTACT(),
#
# FORCES
#
         FORCE_NODALE    =FACT(statut='f',fr="Applique  des noeuds des forces nodales",max='**',
           regles=(AU_MOINS_UN('GROUP_NO','NOEUD'),
                   AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ' ),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           FX              =SIMP(statut='f',typ='R' ),
           FY              =SIMP(statut='f',typ='R' ),
           FZ              =SIMP(statut='f',typ='R' ),
           MX              =SIMP(statut='f',typ='R' ),
           MY              =SIMP(statut='f',typ='R' ),
           MZ              =SIMP(statut='f',typ='R' ),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
         ),

         FORCE_FACE      =FACT(statut='f',max='**',
             fr="Applique des forces surfaciques sur une face d'lment volumique",
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FX','FY','FZ'),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             FX              =SIMP(statut='f',typ='R' ),
             FY              =SIMP(statut='f',typ='R' ),
             FZ              =SIMP(statut='f',typ='R' ),
           ),

         FORCE_ARETE     =FACT(statut='f',max='**',
         fr="Applique des forces liniques  une arete d'lment volumique ou de coque",
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE',),
                     AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ' ),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             FX              =SIMP(statut='f',typ='R' ),
             FY              =SIMP(statut='f',typ='R' ),
             FZ              =SIMP(statut='f',typ='R' ),
             MX              =SIMP(statut='f',typ='R' ),
             MY              =SIMP(statut='f',typ='R' ),
             MZ              =SIMP(statut='f',typ='R' ),
           ),

         FORCE_CONTOUR   =FACT(statut='f',max='**',
             fr="Applique des forces liniques au bord d'un domaine 2D ou AXIS ou AXIS_FOURIER",
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ'),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             FX              =SIMP(statut='f',typ='R' ),
             FY              =SIMP(statut='f',typ='R' ),
             FZ              =SIMP(statut='f',typ='R' ),
             MX              =SIMP(statut='f',typ='R' ),
             MY              =SIMP(statut='f',typ='R' ),
             MZ              =SIMP(statut='f',typ='R' ),
           ),

         FORCE_INTERNE   =FACT(statut='f',max='**',
             fr="Applique des forces volumiques (2D ou 3D)  un domaine volumique",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FX','FY','FZ' ),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             FX              =SIMP(statut='f',typ='R' ),
             FY              =SIMP(statut='f',typ='R' ),
             FZ              =SIMP(statut='f',typ='R' ),
           ),

         SIGM_INTERNE   =FACT(statut='f',max='**',
             fr="Applique des contraintes volumiques (2D ou 3D)  un domaine volumique",
             #INST            =SIMP(statut='f',typ='R' ),
             SIGM            =SIMP(statut='o',typ=(cham_elem,carte_sdaster)),
           ),

         PRES_REP        =FACT(statut='f',max='**',
             fr="Applique une pression  un domaine de milieu continu 2D ou 3D, ou  un domaine de coques et tuyaux",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','FISSURE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE','FISSURE'),
                     AU_MOINS_UN('PRES','CISA_2D' ),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             FISSURE         =SIMP(statut='f',typ=fiss_xfem,min=1,max=100,),
             PRES            =SIMP(statut='f',typ='R' ),
             CISA_2D         =SIMP(statut='f',typ='R' ),
           ),

         EFFE_FOND       =FACT(statut='f',max='**',
           fr="Calcul l'effet de fond sur une branche de tuyauterie (modlisation 3D) soumise  une pression",
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),),
           GROUP_MA_INT    =SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           PRES            =SIMP(statut='o',typ='R' ),
         ),

         EPSI_INIT       =FACT(statut='f',max='**',
             fr="Applique un chargement de dformation initiale  un lment 2D, 3D ou de structure",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('EPXX','EPYY','EPZZ','EPXY','EPXZ','EPYZ','EPX',
                                 'KY','KZ','EXX','EYY','EXY','KXX','KYY','KXY'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             EPXX            =SIMP(statut='f',typ='R' ),
             EPYY            =SIMP(statut='f',typ='R' ),
             EPZZ            =SIMP(statut='f',typ='R' ),
             EPXY            =SIMP(statut='f',typ='R' ),
             EPXZ            =SIMP(statut='f',typ='R' ),
             EPYZ            =SIMP(statut='f',typ='R' ),
             EPX             =SIMP(statut='f',typ='R' ),
             KY              =SIMP(statut='f',typ='R' ),
             KZ              =SIMP(statut='f',typ='R' ),
             EXX             =SIMP(statut='f',typ='R' ),
             EYY             =SIMP(statut='f',typ='R' ),
             EXY             =SIMP(statut='f',typ='R' ),
             KXX             =SIMP(statut='f',typ='R' ),
             KYY             =SIMP(statut='f',typ='R' ),
             KXY             =SIMP(statut='f',typ='R' ),
           ),

         ARLEQUIN        =FACT(statut='f',min=1,max='**',
           fr="Dfinit les paramtres de la mthode Arlequin",
           GROUP_MA_1     =SIMP(statut='o',typ=grma,max='**'),
           GROUP_MA_2     =SIMP(statut='o',typ=grma,max='**'),
           GROUP_MA_COLL  =SIMP(statut='f',typ=grma,max='**'),
           CARA_ELEM      =SIMP(statut='f',typ=cara_elem ),
           COND_LIM       =SIMP(statut='f',typ=char_meca ),
           COLLAGE        =SIMP(statut='f',typ='TXM',defaut="GROSSIER",into=("GROSSIER","FIN","GROUP_MA_1","GROUP_MA_2"),),
           regles         =(UN_PARMI('POIDS_1','POIDS_2','POIDS_GROSSIER','POIDS_FIN',),),
           POIDS_1        =SIMP(statut='f',typ='R'),
           POIDS_2        =SIMP(statut='f',typ='R'),
           POIDS_GROSSIER =SIMP(statut='f',typ='R'),
           UNITE_GMSH     =SIMP(statut='f',typ='I',defaut=0,max=1),
           POIDS_FIN      =SIMP(statut='f',typ='R'),),

        FORCE_POUTRE    =FACT(statut='f',max='**',
             fr="Applique des forces liniques sur des lments de type poutre",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FX','FY','FZ','N','VY','VZ'),
                     PRESENT_ABSENT('FX','N','VY','VZ'),
                     PRESENT_ABSENT('FY','N','VY','VZ'),
                     PRESENT_ABSENT('FZ','N','VY','VZ'),
                     PRESENT_ABSENT('N','FX','FY','FZ'),
                     PRESENT_ABSENT('VY','FX','FY','FZ'),
                     PRESENT_ABSENT('VZ','FX','FY','FZ'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FORCE",into=("VENT","FORCE",) ),
#  rajour d'un mot cl REPERE :/ LOCAL /GLOBAL
               FX              =SIMP(statut='f',typ='R' ),
               FY              =SIMP(statut='f',typ='R' ),
               FZ              =SIMP(statut='f',typ='R' ),

               N               =SIMP(statut='f',typ='R' ),
               VY              =SIMP(statut='f',typ='R' ),
               VZ              =SIMP(statut='f',typ='R' ),

           ),

         FORCE_TUYAU     =FACT(statut='f',max='**',
             fr="Applique une pression sur des lments TUYAU",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             PRES            =SIMP(statut='f',typ='R' ),
           ),

         FORCE_COQUE     =FACT(statut='f',max='**',
             fr="Applique des forces surfaciques sur des lments de types coques",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('FX','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('FY','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('FZ','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('MX','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('MY','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('MZ','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('F1','FX','FY','FZ','MX','MY','MZ','PRES'),
                     PRESENT_ABSENT('F2','FX','FY','FZ','MX','MY','MZ','PRES'),
                     PRESENT_ABSENT('F3','FX','FY','FZ','MX','MY','MZ','PRES'),
                     PRESENT_ABSENT('MF1','FX','FY','FZ','MX','MY','MZ','PRES'),
                     PRESENT_ABSENT('MF2','FX','FY','FZ','MX','MY','MZ','PRES'),
                     PRESENT_ABSENT('PRES','FX','FY','FZ','MX','MY','MZ','F1','F2','F3','MF1','MF2'),),
#  rajour d'un mot cl REPERE :/ LOCAL /GLOBAL
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),

               FX              =SIMP(statut='f',typ='R' ),
               FY              =SIMP(statut='f',typ='R' ),
               FZ              =SIMP(statut='f',typ='R' ),
               MX              =SIMP(statut='f',typ='R' ),
               MY              =SIMP(statut='f',typ='R' ),
               MZ              =SIMP(statut='f',typ='R' ),

               F1              =SIMP(statut='f',typ='R' ),
               F2              =SIMP(statut='f',typ='R' ),
               F3              =SIMP(statut='f',typ='R' ),
               MF1             =SIMP(statut='f',typ='R' ),
               MF2             =SIMP(statut='f',typ='R' ),

             PRES            =SIMP(statut='f',typ='R' ),
             PLAN            =SIMP(statut='f',typ='TXM',defaut="MAIL",into=("SUP","INF","MOY","MAIL",) ),
           ),


           GRAPPE_FLUIDE   =FACT(statut='f',max='**',
             fr="Dfinit les donnes de calcul des forces fluides lors des tudes de chute de grappe",
             regles=(EXCLUS('GROUP_NO_EXTR','NOEUD_EXTR'),
                     EXCLUS('GROUP_NO_ORIG','NOEUD_ORIG'),
                     PRESENT_PRESENT('CARA_HYDR','VALE_HYDR'),
                     PRESENT_PRESENT('CARA_GRAPPE','VALE_GRAPPE'),
                     PRESENT_PRESENT('CARA_COMMANDE','VALE_COMMANDE'),
                     PRESENT_PRESENT('CARA_MANCHETTE','VALE_MANCHETTE'),
                     PRESENT_PRESENT('CARA_GUIDE','VALE_GUIDE'),
                     PRESENT_PRESENT('CARA_ASSEMBLAGE','VALE_ASSEMBLAGE'),
                     PRESENT_PRESENT('CARA_PDC','VALE_PDC'),),
             GROUP_MA        =SIMP(statut='f',typ=grma,max=1),
             GROUP_NO_EXTR   =SIMP(statut='f',typ=grno,max=1),
             NOEUD_EXTR      =SIMP(statut='f',typ=no,max=1),
             GROUP_NO_ORIG   =SIMP(statut='f',typ=grno,max=1),
             NOEUD_ORIG      =SIMP(statut='f',typ=no,max=1),
             Z0              =SIMP(statut='f',typ='R' ),
             CARA_HYDR       =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',
                                 fr="dfinition des donnes hydrauliques",
                                 into=("Q","ROC","ROD","ROP","ROM","ROML","ROG","NUC","NUM",
                                       "NUML","NUG","P2","P3","P4","CGG","G") ),
             VALE_HYDR       =SIMP(statut='f',typ='R',max='**',
                                 fr="valeurs des donnes hydrauliques",),
             CARA_GRAPPE     =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',
                                 fr="dfinition des donnes gomtriques de la grappe",
                                 into=("M","DTIGE","DTMOY","ROTIGE","LTIGE","LLT","LCT",
                                       "VARAI","RORAI","DCRAY","ROCRAY","LCRAY","LCHUT",
                                       "CFCM","CFCI","CFCG","HRUGC","HRUGTC","NCA") ),
             VALE_GRAPPE     =SIMP(statut='f',typ='R',max='**',
                                 fr="valeurs des donnes gomtriques de la grappe",),
             CARA_COMMANDE   =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',
                                 fr="dfinition des donnes gomtriques du mcanisme de commande",
                                 into=("LI","LML","LG","LIG","DIML","DEML","DCSP",
                                       "DG","HRUGML","HRUGCSP","HRUGG") ),
             VALE_COMMANDE   =SIMP(statut='f',typ='R',max='**',
                                 fr="valeurs des donnes gomtriques du mcanisme de commande",),
             CARA_MANCHETTE  =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',
                                 fr="dfinition des donnes gomtriques de la manchette et son adaptateur",
                                 into=("LM","LA","LIM","DIMT","DEMT","DCMT","VMT",
                                       "ROMT","DA","HRUGM","HRUGA") ),
             VALE_MANCHETTE  =SIMP(statut='f',typ='R',max='**',
                                 fr="valeurs des donnes gomtriques de la manchette et son adaptateur",),
             CARA_GUIDE      =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',
                                 fr="dfinition des donnes gomtriques des tubes guides",
                                 into=("NRET","L0","L1","L2","L3","L4","DTG","DR",
                                       "DOR","D0","D00","HRUGTG") ),
             VALE_GUIDE      =SIMP(statut='f',typ='R',max='**',
                                 fr="valeurs des donnes gomtriques des tubes guides",),
             CARA_ASSEMBLAGE =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',
                                 fr="dfinition des donnes gomtriques des assemblages",
                                 into=("SASS","DCC","DTI","NGM","NGMDP","KM","KS","KI",
                                       "KES","KEI","KF") ),
             VALE_ASSEMBLAGE =SIMP(statut='f',typ='R',max='**',
                                 fr="valeurs des donnes gomtriques des assemblages",),
             CARA_PDC        =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',
                                 fr="dfinition des coefficients de perte de charge singulire",
                                 into=("CD0","CD1","CD2","CDELARG","CDRET","CDM","CDA","CDML",
                                       "CDI","CDG") ),
             VALE_PDC        =SIMP(statut='f',typ='R',max='**',
                                 fr="valeurs des coefficients de perte de charge singulire",),
             DIRE_FORC_FPLAQ  =SIMP(statut='f',typ='R',min=3,max=3,
                                 fr="direction d'application de la force de plaquage",),
             UNITE_IMPR_FORCE =SIMP(statut='f',typ='I',
                                 fr="unit d'impression des forces",),
             UNITE_IMPR_NOEUD =SIMP(statut='f',typ='I',
                                 fr="unit d'impression des noeuds par zone",),
           ),

           LIAISON_COQUE   =FACT(statut='f',max='**',
             fr="Permet de reprsenter le raccord entre des lments de coques au moyen des relations linaires",
             GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_NO_1      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD_1         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_NO_2      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD_2         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
           ),

         RELA_CINE_BP    =FACT(statut='f',max='**',
           fr="Etablir des relations cinmatiques permettant de relier les noeuds cable aux noeuds du bton, et spcifier"
              +" la prise en compte des contraintes initiales dans les cables",
           CABLE_BP        =SIMP(statut='o',typ=cabl_precont ),
           SIGM_BPEL       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
           RELA_CINE       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           DIST_MIN        =SIMP(statut='f',typ='R'),
         ),

         FORCE_ELEC      =FACT(statut='f',max='**',
             fr="Appliquer la force de LAPLACE agissant sur un conducteur principal, due  la prsence d'un conducteur"
                 +" secondaire droit",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),

             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),

             POSITION        =SIMP(statut='f',typ='TXM',fr="Direction prdfinie",into=("PARA","INFI","FINI",) ),
             b_fxyz  =BLOC ( condition = "POSITION == None",
                  FX   =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
                  FY   =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
                  FZ   =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
                       ),

             b_para     =BLOC ( condition = "POSITION == 'PARA'",
               regles=(UN_PARMI('TRANS','DIST'),),
               TRANS           =SIMP(statut='f',typ='R',max=3),
               DIST            =SIMP(statut='f',typ='R' ),
               b_point2        =BLOC ( condition = "DIST != None",
                 POINT2           =SIMP(statut='o',typ='R',max=3),
               ),
             ),
             b_fini_infi     =BLOC ( condition = "(POSITION == 'FINI') or (POSITION == 'INFI')",
               POINT1          =SIMP(statut='o',typ='R',max=3),
               POINT2          =SIMP(statut='o',typ='R',max=3),
             ),
           ),




        INTE_ELEC       =FACT(statut='f',max='**',
             fr="Appliquer la force de LAPLACE agissant sur un conducteur principal, due  la prsence d'un conducteur"
               +" secondaire non ncessairement droit",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('GROUP_MA_2','MAILLE_2','TRANS','SYME'),
                     EXCLUS('TRANS','SYME'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             TRANS           =SIMP(statut='f',typ='R' ,max='**'),
             SYME            =SIMP(statut='f',typ='R' ,max='**'),
           ),


         IMPE_FACE       =FACT(statut='f',fr="Applique une impdance acoustique  une face",max='**',
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE' ),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             IMPE            =SIMP(statut='o',typ='R' ),
           ),

         VITE_FACE       =FACT(statut='f',fr="Impose des vitesses normales  une face (phnomne ACOUSTIQUE), ",max='**',
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             VNOR            =SIMP(statut='o',typ='R' ),
           ),



         ONDE_FLUI       =FACT(statut='f',max='**',
             fr="Applique une amplitude de pression d'onde incidente sinusoidale arrivant normalement  une face",
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             PRES            =SIMP(statut='o',typ='R' ),
           ),

         FLUX_THM_REP    =FACT(statut='f',max='**',
             fr="Applique  un domaine de milieu continu 2D ou 3D un flux de chaleur et/ou un apport de masse fluide"
                 +" (flux hydraulique)",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FLUN','FLUN_HYDR1','FLUN_HYDR2'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             FLUN            =SIMP(statut='f',typ='R' ),
             FLUN_HYDR1      =SIMP(statut='f',typ='R' ),
             FLUN_HYDR2      =SIMP(statut='f',typ='R' ),
           ),

         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;


#& MODIF COMMANDE  DATE 16/09/2008   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
AFFE_CHAR_MECA_C=OPER(nom="AFFE_CHAR_MECA_C",op=   7,sd_prod=char_meca,
                     fr="Affectation de charges et conditions aux limites mcaniques complexes",
                     reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
         regles=(AU_MOINS_UN('DDL_IMPO','FORCE_POUTRE','LIAISON_DDL', ),),
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         VERI_DDL        =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         METHODE         =SIMP(statut='c',typ='TXM',fr="Stratgie de rsolution pour les dplacements imposs",
                               into=('DUALISATION',),defaut='DUALISATION',),
                               # METHODE='ELIMINATION' est trait dans le fortran mais dangereux actuellement
         DDL_IMPO        =FACT(statut='f',max='**',
           fr="Impose  des noeuds une ou plusieurs valeurs de dplacement (ou de certaines grandeurs asscocies)",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD',),
                   AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI','LIAISON', ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           LIAISON         =SIMP(statut='f',typ='TXM',into=('ENCASTRE',)),
           DX              =SIMP(statut='f',typ='C' ),
           DY              =SIMP(statut='f',typ='C' ),
           DZ              =SIMP(statut='f',typ='C' ),
           DRX             =SIMP(statut='f',typ='C' ),
           DRY             =SIMP(statut='f',typ='C' ),
           DRZ             =SIMP(statut='f',typ='C' ),
           GRX             =SIMP(statut='f',typ='C' ),
           PRES            =SIMP(statut='f',typ='C' ),
           PHI             =SIMP(statut='f',typ='C' ),
         ),
         FORCE_POUTRE    =FACT(statut='f',max='**',
           fr="Applique des forces liniques sur des lments de type poutre",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FX','FY','FZ','N','VY','VZ',),
                   PRESENT_ABSENT('FX','N','VY','VZ',),
                   PRESENT_ABSENT('FY','N','VY','VZ',),
                   PRESENT_ABSENT('FZ','N','VY','VZ',),
                   PRESENT_ABSENT('N','FX','FY','FZ',),
                   PRESENT_ABSENT('VY', 'FX','FY','FZ',),
                   PRESENT_ABSENT('VZ','FX','FY','FZ', ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FORCE",into=("VENT","FORCE") ),
           FX              =SIMP(statut='f',typ='C' ),
           FY              =SIMP(statut='f',typ='C' ),
           FZ              =SIMP(statut='f',typ='C' ),
           N               =SIMP(statut='f',typ='C' ),
           VY              =SIMP(statut='f',typ='C' ),
           VZ              =SIMP(statut='f',typ='C' ),
         ),
         LIAISON_DDL     =FACT(statut='f',max='**',
           fr="Dfinit une relation linaire entre les DDLs de deux ou plusieurs noeuds",
           regles=(UN_PARMI('GROUP_NO','NOEUD', ),),
           GROUP_NO        =SIMP(statut='f',typ=grno,max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,max='**'),
           DDL             =SIMP(statut='o',typ='TXM',max='**'),
           COEF_MULT       =SIMP(statut='o',typ='R'  ,max='**'),
           COEF_IMPO       =SIMP(statut='o',typ='C' ),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 06/05/2009   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
AFFE_CHAR_MECA_F=OPER(nom="AFFE_CHAR_MECA_F",op=7,sd_prod=char_meca,
                      fr="Affectation de charges et conditions aux limites mcaniques fonction d'un (ou plusieurs) paramtres",
                      reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
        regles=(AU_MOINS_UN('DDL_IMPO','FACE_IMPO','LIAISON_DDL','FORCE_NODALE',
                            'FORCE_FACE','FORCE_ARETE','FORCE_CONTOUR','FORCE_INTERNE',
                            'PRES_REP','FORCE_POUTRE','VITE_FACE','IMPE_FACE','ONDE_PLANE',
                            'LIAISON_OBLIQUE','EPSI_INIT','LIAISON_GROUP','LIAISON_UNIF',
                            'LIAISON_SOLIDE','FORCE_COQUE','LIAISON_COQUE','FORCE_TUYAU',
                            'EFFE_FOND','FLUX_THM_REP','LIAISON_UNILATER'),),
         VERI_DDL        =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         VERI_NORM       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         MODELE          =SIMP(statut='o',typ=modele_sdaster),
         METHODE         =SIMP(statut='c',typ='TXM',fr="Stratgie de rsolution pour les dplacements imposs",
                               into=('DUALISATION',),defaut='DUALISATION',),
                               # METHODE='ELIMINATION' est trait dans le fortran mais dangereux actuellement

         DDL_IMPO        =FACT(statut='f',max='**',
           fr="Impose  des noeuds une ou plusieurs valeurs de dplacement (ou de certaines grandeurs asscocies) fournies"
               +" par l'intermdiaire d'un concept fonction ",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                   AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI',
                               'TEMP','PRE1','PRE2','LIAISON','DCX','DCY','DCZ','H1X',
                               'H1Y','H1Z','E1X','E1Y','E1Z','E2X','E2Y','E2Z',
                               'E3X','E3Y','E3Z','E4X','E4Y','E4Z','LAGS_C'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           LIAISON         =SIMP(statut='f',typ='TXM',into=('ENCASTRE',)),
           DX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRY             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRZ             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           GRX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PHI             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRE1            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRE2            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DCX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DCY             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DCZ             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           H1X             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           H1Y             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           H1Z             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E1X             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E1Y             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E1Z             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E2X             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E2Y             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E2Z             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E3X             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E3Y             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E3Z             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E4X             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E4Y             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E4Z             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           LAGS_C          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         FACE_IMPO       =FACT(statut='f',max='**',
           fr="Impose  tous les noeuds d'une face une ou plusieurs valeurs de dplacement (ou de certaines grandeurs associes)"
              +" fournies par l'intrmdiaire d'un concept fonction",
           regles=(UN_PARMI('GROUP_MA','MAILLE'),
                   AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI','TEMP','PRE1','PRE2','DNOR','DTAN'),
                   EXCLUS('DNOR','DX'),
                   EXCLUS('DNOR','DY'),
                   EXCLUS('DNOR','DZ'),
                   EXCLUS('DNOR','DRX'),
                   EXCLUS('DNOR','DRY'),
                   EXCLUS('DNOR','DRZ'),
                   EXCLUS('DTAN','DX'),
                   EXCLUS('DTAN','DY'),
                   EXCLUS('DTAN','DZ'),
                   EXCLUS('DTAN','DRX'),
                   EXCLUS('DTAN','DRY'),
                   EXCLUS('DTAN','DRZ'),),
#  rajout d un mot cle REPERE : / GLOBAL / LOCAL
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           SANS_GROUP_MA   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           SANS_MAILLE     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           DX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRY             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRZ             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           GRX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PHI             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRE1            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRE2            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DNOR            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DTAN            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         LIAISON_DDL     =FACT(statut='f',max='**',
           fr="Dfinit une relation linaire entre des DDLs de deux ou plusieurs noeuds, les valeurs sont fournies par"
               +" l'intermediaire d'un concept de type fonction",
           regles=(UN_PARMI('GROUP_NO','NOEUD'),UN_PARMI('COEF_MULT','COEF_MULT_FONC'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,max='**'),
           DDL             =SIMP(statut='o',typ='TXM',max='**'),
           COEF_MULT       =SIMP(statut='f',typ='R',max='**'),
           COEF_MULT_FONC  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),max='**'),
           COEF_IMPO       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         LIAISON_OBLIQUE =FACT(statut='f',max='**',
           fr="Applique  des noeuds la meme valeur de dplacement dfinie composante par composante dans un repre oblique"
              +" quelconque, les valeurs sont fournis par l'intermdiaire d'un concept fonction",
           regles=(UN_PARMI('GROUP_NO','NOEUD'),
                   UN_PARMI('DX','DY','DZ','DRX','DRY','DRZ'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,max='**'),
           ANGL_NAUT       =SIMP(statut='o',typ='R',max=3),
           DX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRY             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRZ             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         LIAISON_GROUP   =FACT(statut='f',max='**',
           fr="Dfinit la meme relation linaire entre certains DDLs de couples de noeuds, les valeurs sont fournies par"
               +" l'intermdiaire de concept fonction",
           regles=(UN_PARMI('GROUP_MA_1','MAILLE_1','GROUP_NO_1','NOEUD_1'),
                   UN_PARMI('GROUP_MA_2','MAILLE_2','GROUP_NO_2','NOEUD_2'),
                   EXCLUS('GROUP_MA_1','GROUP_NO_2'),
                   EXCLUS('GROUP_MA_1','NOEUD_2'),
                   EXCLUS('GROUP_NO_1','GROUP_MA_2'),
                   EXCLUS('GROUP_NO_1','MAILLE_2'),
                   EXCLUS('MAILLE_1','GROUP_NO_2'),
                   EXCLUS('MAILLE_1','NOEUD_2'),
                   EXCLUS('NOEUD_1','GROUP_MA_2'),
                   EXCLUS('NOEUD_1','MAILLE_2'),
                   EXCLUS('SANS_NOEUD','SANS_GROUP_NO'),),
           GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_1      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_1         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_2      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_2         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           DDL_1           =SIMP(statut='o',typ='TXM',max='**'),
           COEF_MULT_1     =SIMP(statut='o',typ='R',max='**'),
           DDL_2           =SIMP(statut='o',typ='TXM',max='**'),
           COEF_MULT_2     =SIMP(statut='o',typ='R',max='**'),
           COEF_IMPO       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           SOMMET          =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           TRAN            =SIMP(statut='f',typ='R',max=3),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
           CENTRE          =SIMP(statut='f',typ='R',max=3),
         ),
#
# LIAISON UNILATERALE
#
         LIAISON_UNILATER=FACT(statut='f',max='**',
           fr="Dfinit les zones soumises  des conditions de liaison unilaterale (inegalite sur un DDL)",
           regles=(UN_PARMI('GROUP_MA','MAILLE','GROUP_NO','NOEUD'),),

           GROUP_MA        =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno ,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no   ,validators=NoRepeat(),max='**'),

           SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),

           NB_RESOL        =SIMP(statut='f',typ='I', defaut=10 ),

           NOM_CMP         =SIMP(statut='o',typ='TXM',max='**'),

           COEF_IMPO       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           COEF_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),max='**'),

           METHODE         =SIMP(statut='f',typ='TXM',defaut="CONTRAINTE",
                                 into=("CONTRAINTE",) ),


        ),

          LIAISON_UNIF    =FACT(statut='f',max='**',
           fr="Impose une meme valeur (inconnue)  des DDLs d'un ensemble de noeuds",
           regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           DDL             =SIMP(statut='o',typ='TXM',max='**'),
         ),


         LIAISON_SOLIDE  =FACT(statut='f',max='**',
           fr="Modlise une partie indformable d'une structure."
            +" Les mots cls TRAN et ANGL_NAUT permettent d'imposer le dplacement de la partie indformable.",
           regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),
                   ENSEMBLE('CENTRE','ANGL_NAUT'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           TRAN            =SIMP(statut='f',typ='R',max=3 ),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max=3 ),
           CENTRE          =SIMP(statut='f',typ='R',max=3 ),
           DIST_MIN        =SIMP(statut='f',typ='R'),
           NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
         ),



         FORCE_NODALE    =FACT(statut='f',max='**',
           fr="Applique  des noeuds des forces nodales dont les valeurs des composantes sont fournies par l'intermdiaire"
               +" d'un concept fonction",
           regles=(UN_PARMI('GROUP_NO','NOEUD'),
                   AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           FX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           ANGL_NAUT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),max=3 ),
         ),

         FORCE_FACE      =FACT(statut='f',max='**',
           fr="Applique des forces surfaciques sur une face d'lment volumique dont les valeurs des composantes sont fournies"
               +" par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FX','FY','FZ'),),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),
         FORCE_ARETE     =FACT(statut='f',max='**',
           fr="Applique des forces liniques  une arete d'lment volumique ou de coque dont les valeurs des composantes sont"
               +" fournies par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ'),),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),
         FORCE_CONTOUR   =FACT(statut='f',max='**',
           fr="Applique des forces liniques au bord d'un domaine 2D ou AXIS ou AXIS_FOURIER, dont les valeurs des composantes"
               +" sont fournies par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ'),),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         FORCE_INTERNE   =FACT(statut='f',max='**',
           fr="Applique des forces volumiques (2D ou 3D)  un domaine volumique, dont les valeurs des composantes sont fournies"
               +" par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FX','FY','FZ'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         PRES_REP        =FACT(statut='f',max='**',
           fr="Applique une pression  un domaine de milieu continu 2D ou 3D ou  un domaine de coques et tuyaux, dont les"
               +" valeurs imposes (pression et/ou cisaillement) sont fournies par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','FISSURE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE','FISSURE'),
                   AU_MOINS_UN('PRES','CISA_2D'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FISSURE         =SIMP(statut='f',typ=fiss_xfem,min=1,max=100,),
           PRES            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           CISA_2D         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         EFFE_FOND       =FACT(statut='f',max='**',
           fr="Calcul l'effet de fond sur une branche de tuyauterie (modlisation 3D) soumise"
               +"  une pression dont la valeur est fournie par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),),
           GROUP_MA_INT    =SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           PRES            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         EPSI_INIT       =FACT(statut='f',max='**',
           fr="Applique un chargement de dformation initiale  un lment 2D, 3D ou de structure dont les composantes"
               +" du tenseur de dformation sont fournies par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('EPXX','EPYY','EPZZ','EPXY','EPXZ','EPYZ'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           EPXX            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           EPYY            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           EPZZ            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           EPXY            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           EPXZ            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           EPYZ            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         FORCE_POUTRE    =FACT(statut='f',max='**',
           fr="Applique des forces liniques sur des lments de type poutre dont les valeurs sont fournies par"
               +" l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FX','FY','FZ','N','VY','VZ'),
                   PRESENT_ABSENT('FX','N','VY','VZ'),
                   PRESENT_ABSENT('FY','N','VY','VZ'),
                   PRESENT_ABSENT('FZ','N','VY','VZ'),
                   PRESENT_ABSENT('N','FX','FY','FZ'),
                   PRESENT_ABSENT('VY','FX','FY','FZ'),
                   PRESENT_ABSENT('VZ','FX','FY','FZ'),),
#  rajout d un mot cle REPERE : / GLOBAL / LOCAL
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FORCE",into=("VENT","FORCE") ),
           FX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           N               =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         FORCE_TUYAU     =FACT(statut='f',max='**',
           fr="Applique une pression sur des lments TUYAU, la valeur est fournie par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           PRES            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         FORCE_COQUE     =FACT(statut='f',max='**',
           fr="Applique des forces surfaciques sur des lments de types coques dont les valeurs sont fournies par"
               +" l'intermdiaires d'un concept fonction",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ','PRES','F1','F2','F3','MF1','MF2'),
                   PRESENT_ABSENT('FX','PRES','F1','F2','F3','MF1','MF2'),
                   PRESENT_ABSENT('FY','PRES','F1','F2','F3','MF1','MF2'),
                   PRESENT_ABSENT('FZ','PRES','F1','F2','F3','MF1','MF2'),
                   PRESENT_ABSENT('MX','PRES','F1','F2','F3','MF1','MF2'),
                   PRESENT_ABSENT('MY','PRES','F1','F2','F3','MF1','MF2'),
                   PRESENT_ABSENT('MZ','PRES','F1','F2','F3','MF1','MF2'),
                   PRESENT_ABSENT('F1','PRES','FX','FY','FZ','MX','MY','MZ'),
                   PRESENT_ABSENT('F2','PRES','FX','FY','FZ','MX','MY','MZ'),
                   PRESENT_ABSENT('F3','PRES','FX','FY','FZ','MX','MY','MZ'),
                   PRESENT_ABSENT('MF1','PRES','FX','FY','FZ','MX','MY','MZ'),
                   PRESENT_ABSENT('MF2','PRES','FX','FY','FZ','MX','MY','MZ'),
                   PRESENT_ABSENT('PRES','FX','FY','FZ','MX','MY','MZ','F1','F2','F3','MF1','MF2'),),
#  rajout d un mot cle REPERE : / GLOBAL / LOCAL
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           F1              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           F2              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           F3              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MF1             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MF2             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PLAN            =SIMP(statut='f',typ='TXM',defaut="MAIL",
                                 into=("SUP","INF","MOY","MAIL") ),
         ),

         LIAISON_COQUE   =FACT(statut='f',max='**',
           fr="Permet de reprsenter le raccord entre des lments de coques au moyen des relations linaires",
           GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_1      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_1         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_2      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_2         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES",) ),
         ),


         VITE_FACE       =FACT(statut='f',max='**',
           fr="Impose des vitesses normales  une face (phnomne ACOUSTIQUE) dont les valeurs sont fournies par"
               +" l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('GROUP_MA','MAILLE'),),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           VNOR            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),
         IMPE_FACE       =FACT(statut='f',max='**',
           fr="Applique  une face une impdance acoustique dont la valeur est fournie par l'intermdiaire"
               +" d'un concept fonction",
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('GROUP_MA','MAILLE'),),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           IMPE            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),
         ONDE_PLANE      =FACT(statut='f',max='**',
           fr="Impose un chargement sismique par onde plane dont la valeur est fournie par l'intermdiaire"
               +" d'un concept fonction",
           DIRECTION       =SIMP(statut='o',typ='R',max='**'),
           TYPE_ONDE       =SIMP(statut='o',typ='TXM' ),
           FONC_SIGNAL     =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DIST_ORIG       =SIMP(statut='o',typ='R' ),
         ),



         FLUX_THM_REP    =FACT(statut='f',max='**',
           fr="Applique  un domaine continue 2D ou 3D un flux de chaleur et/ou un apport de masse fluide (flux hydraulique)"
               +" dont les valeurs des flux sont fournies par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FLUN','FLUN_HYDR1','FLUN_HYDR2'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FLUN            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUN_HYDR1      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUN_HYDR2      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;


#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE None
AFFE_CHAR_OPS011=OPER(nom="AFFE_CHAR_OPS011",op= 190,sd_prod=char_ther,
                      fr="Affectation de charges et conditions limites thermiques spcifique  CARA_TORSION",
                      reentrant='n',
            UIinfo={"groupes":("Outils mtier",)},
         regles=(AU_MOINS_UN('CARA_TORSION', ),),
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         VERI_DDL        =SIMP(statut='f',typ='TXM',defaut="OUI",
                               into=("OUI","NON") ),
         CARA_TORSION    =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 16/09/2008   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
AFFE_CHAR_THER=OPER(nom="AFFE_CHAR_THER",op=34,sd_prod=char_ther
                    ,fr="Affectation de charges et conditions aux limites thermiques constantes",
                    reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
      regles=(AU_MOINS_UN('TEMP_IMPO','SOURCE','FLUX_REP','ECHANGE',
                          'ECHANGE_PAROI','GRAD_TEMP_INIT','LIAISON_DDL','LIAISON_GROUP',
                          'LIAISON_UNIF','LIAISON_CHAMNO','RAYONNEMENT','LIAISON_MAIL' ),),
         MODELE          =SIMP(statut='o',typ=(modele_sdaster) ),
         METHODE         =SIMP(statut='c',typ='TXM',fr="Stratgie de rsolution pour les tempratures imposes",
                               into=('DUALISATION',),defaut='DUALISATION',),
                               # METHODE='ELIMINATION' est trait dans le fortran mais dangereux actuellement

         TEMP_IMPO       =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                   AU_MOINS_UN('TEMP_SUP','TEMP','TEMP_INF'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           TEMP            =SIMP(statut='f',typ='R'),
           TEMP_INF        =SIMP(statut='f',typ='R'),
           TEMP_SUP        =SIMP(statut='f',typ='R'), ),

         FLUX_REP        =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_PRESENT('CARA_TORSION','GROUP_MA'),
                   AU_MOINS_UN('FLUN','FLUN_INF','FLUN_SUP','CARA_TORSION') ),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FLUN            =SIMP(statut='f',typ='R'),
           FLUN_INF        =SIMP(statut='f',typ='R'),
           FLUN_SUP        =SIMP(statut='f',typ='R'),
           CARA_TORSION    =SIMP(statut='f',typ=table_sdaster),
         ),


         RAYONNEMENT     =FACT(statut='f',max='**',
           fr="Attention, exprimer les tempratures en Celsius si rayonnement",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           SIGMA           =SIMP(statut='o',typ='R'),
           EPSILON         =SIMP(statut='o',typ='R'),
           TEMP_EXT        =SIMP(statut='o',typ='R'),
         ),

         ECHANGE         =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('COEF_H','COEF_H_INF','COEF_H_SUP'),
                   ENSEMBLE('COEF_H','TEMP_EXT',),
                   ENSEMBLE('COEF_H_INF','TEMP_EXT_INF'),
                             ENSEMBLE('COEF_H_SUP','TEMP_EXT_SUP'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           COEF_H          =SIMP(statut='f',typ='R'),
           TEMP_EXT        =SIMP(statut='f',typ='R'),
           COEF_H_INF      =SIMP(statut='f',typ='R'),
           TEMP_EXT_INF    =SIMP(statut='f',typ='R'),
           COEF_H_SUP      =SIMP(statut='f',typ='R'),
           TEMP_EXT_SUP    =SIMP(statut='f',typ='R'),
         ),

         SOURCE          =FACT(statut='f',max='**',
           regles=(UN_PARMI('SOUR','SOUR_CALCULEE',),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('SOUR_CALCULEE','TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           SOUR            =SIMP(statut='f',typ='R'),
           SOUR_CALCULEE   =SIMP(statut='f',typ=(cham_elem) ),
         ),

         GRAD_TEMP_INIT  =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FLUX_X','FLUX_Y','FLUX_Z'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FLUX_X          =SIMP(statut='f',typ='R' ),
           FLUX_Y          =SIMP(statut='f',typ='R' ),
           FLUX_Z          =SIMP(statut='f',typ='R' ),
                         ),

         LIAISON_DDL     =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_NO','NOEUD', ),),
           GROUP_NO        =SIMP(statut='f',typ=grno,max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,max='**'),
           DDL             =SIMP(statut='f',typ='TXM',max='**',
                                 into=("TEMP","TEMP_INF","TEMP_SUP") ),
           COEF_MULT       =SIMP(statut='o',typ='R',max='**'),
           COEF_IMPO       =SIMP(statut='o',typ='R' ),
         ),

         LIAISON_GROUP   =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_MA_1','MAILLE_1','GROUP_NO_1','NOEUD_1'),
                   UN_PARMI('GROUP_MA_2','MAILLE_2','GROUP_NO_2','NOEUD_2'),
                             EXCLUS('GROUP_MA_1','GROUP_NO_2'),
                             EXCLUS('GROUP_MA_1','NOEUD_2'),
                   EXCLUS('GROUP_NO_1','GROUP_MA_2'),
                             EXCLUS('GROUP_NO_1','MAILLE_2'),
                             EXCLUS('MAILLE_1','GROUP_NO_2'),
                             EXCLUS('MAILLE_1','NOEUD_2'),
                             EXCLUS('NOEUD_1','GROUP_MA_2'),
                             EXCLUS('NOEUD_1','MAILLE_2'),
                             EXCLUS('SANS_NOEUD','SANS_GROUP_NO'),),
           GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_1      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_1         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_2      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_2         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           DDL_1           =SIMP(statut='f',typ='TXM',max='**',defaut="TEMP",
                                 into=("TEMP","TEMP_INF","TEMP_SUP") ),
           COEF_MULT_1     =SIMP(statut='o',typ='R',max='**'),
           DDL_2           =SIMP(statut='f',typ='TXM',max='**',defaut="TEMP",
                                 into=("TEMP","TEMP_INF","TEMP_SUP",) ),
           COEF_MULT_2     =SIMP(statut='o',typ='R',max='**'),
           COEF_IMPO       =SIMP(statut='o',typ='R' ),
           SOMMET          =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           TRAN            =SIMP(statut='f',typ='R',max='**'),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max='**'),
           CENTRE          =SIMP(statut='f',typ='R',max='**'),
         ),

         LIAISON_MAIL    =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('GROUP_MA_MAIT','MAILLE_MAIT'),
                   AU_MOINS_UN('GROUP_MA_ESCL','MAILLE_ESCL','GROUP_NO_ESCL',
                               'NOEUD_ESCL'),),
           GROUP_MA_MAIT   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_MAIT     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA_ESCL   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_ESCL     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_ESCL   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_ESCL      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           TRAN            =SIMP(statut='f',typ='R',max='**' ),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max='**' ),
           CENTRE          =SIMP(statut='f',typ='R',max='**' ),
           ELIM_MULT       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         ),

         ECHANGE_PAROI   =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_MA_1','MAILLE_1'),
                   UN_PARMI('GROUP_MA_2','MAILLE_2'),),
           GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           COEF_H          =SIMP(statut='f',typ='R'),
           TRAN            =SIMP(statut='f',typ='R',min=2,max=3),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
           CENTRE          =SIMP(statut='f',typ='R',min=2,max=3),
                         ),

         LIAISON_UNIF    =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           DDL             =SIMP(statut='f',typ='TXM',max='**',defaut="TEMP",
                                 into=("TEMP","TEMP_INF","TEMP_SUP") ),
         ),

         LIAISON_CHAMNO  =FACT(statut='f',max='**',
           CHAM_NO         =SIMP(statut='o',typ=cham_no_sdaster),# CO()# "il faut definir une structure de donnee generique chamno"
           COEF_IMPO       =SIMP(statut='o',typ='R' ),
           NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
         ),

         CONVECTION      =FACT(statut='f',max='**',
           VITESSE         =SIMP(statut='o',typ=(cham_no_sdaster) ),
         ),


         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 16/09/2008   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
AFFE_CHAR_THER_F=OPER(nom="AFFE_CHAR_THER_F",op=34,sd_prod=char_ther,
                     fr="Affectation de charges et conditions aux limites thermiques fonction d'un (ou plusieurs)"
                         +" paramtres (temps, ...)",
                     reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
      regles=(AU_MOINS_UN('TEMP_IMPO','SOURCE','FLUX_REP','FLUX_NL','ECHANGE',
                          'ECHANGE_PAROI','LIAISON_DDL','LIAISON_GROUP','LIAISON_UNIF',
                          'GRAD_TEMP_INIT','RAYONNEMENT'),),
         MODELE          =SIMP(statut='o',typ=(modele_sdaster) ),

         TEMP_IMPO       =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                   AU_MOINS_UN('TEMP_SUP','TEMP','TEMP_INF'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           DDL             =SIMP(statut='f',typ='TXM',into=("TEMP",) ),
           TEMP            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP_INF        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP_SUP        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         FLUX_REP        =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FLUN','FLUN_INF','FLUN_SUP','FLUX_X','FLUX_Y','FLUX_Z'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FLUN            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUN_INF        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUN_SUP        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUX_X          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUX_Y          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUX_Z          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         FLUX_NL         =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FLUN            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),


         RAYONNEMENT     =FACT(statut='f',max='**',
           fr="Attention, exprimer les tempratures en Celsius si rayonnement",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           SIGMA           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           EPSILON         =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP_EXT        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),



         ECHANGE         =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('COEF_H','COEF_H_INF','COEF_H_SUP'),
                   ENSEMBLE('COEF_H','TEMP_EXT'),
                   ENSEMBLE('COEF_H_INF','TEMP_EXT_INF'),
                   ENSEMBLE('COEF_H_SUP','TEMP_EXT_SUP'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           COEF_H          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP_EXT        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           COEF_H_INF      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP_EXT_INF    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           COEF_H_SUP      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP_EXT_SUP    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),


         SOURCE          =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           SOUR            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         GRAD_TEMP_INIT  =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FLUX_X','FLUX_Y','FLUX_Z'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FLUX_X          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUX_Y          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUX_Z          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         ECHANGE_PAROI   =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_MA_1','MAILLE_1'),
                        UN_PARMI('GROUP_MA_2','MAILLE_2'),),
           GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           COEF_H          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TRAN            =SIMP(statut='f',typ='R',min=2,max=3),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
           CENTRE          =SIMP(statut='f',typ='R',min=2,max=3),
         ),

        LIAISON_DDL     =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_NO','NOEUD'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,max='**'),
           DDL             =SIMP(statut='f',typ='TXM',max='**',into=("TEMP","TEMP_INF","TEMP_SUP") ),
           COEF_MULT       =SIMP(statut='o',typ='R',max='**'),
           COEF_IMPO       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         LIAISON_GROUP   =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_MA_1','MAILLE_1','GROUP_NO_1','NOEUD_1'),
                   UN_PARMI('GROUP_MA_2','MAILLE_2','GROUP_NO_2','NOEUD_2'),
                             EXCLUS('GROUP_MA_1','GROUP_NO_2'),
                        EXCLUS('GROUP_MA_1','NOEUD_2'),
                   EXCLUS('GROUP_NO_1','GROUP_MA_2'),
                        EXCLUS('GROUP_NO_1','MAILLE_2'),
                        EXCLUS('MAILLE_1','GROUP_NO_2'),
                        EXCLUS('MAILLE_1','NOEUD_2'),
                        EXCLUS('NOEUD_1','GROUP_MA_2'),
                        EXCLUS('NOEUD_1','MAILLE_2'),
                        EXCLUS('SANS_NOEUD','SANS_GROUP_NO'),),
           GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_1      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_1         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_2      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_2         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           DDL_1           =SIMP(statut='f',typ='TXM',max='**',defaut="TEMP",
                                 into=("TEMP","TEMP_INF","TEMP_SUP") ),
           COEF_MULT_1     =SIMP(statut='o',typ='R',max='**'),
           DDL_2           =SIMP(statut='f',typ='TXM',max='**',defaut="TEMP",
                                 into=("TEMP","TEMP_INF","TEMP_SUP") ),
           COEF_MULT_2     =SIMP(statut='o',typ='R',max='**'),
           COEF_IMPO       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           SOMMET          =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           TRAN            =SIMP(statut='f',typ='R',max='**'),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max='**'),
           CENTRE          =SIMP(statut='f',typ='R',max='**'),
         ),

         LIAISON_UNIF    =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           DDL             =SIMP(statut='f',typ='TXM',defaut="TEMP",
                                 into=("TEMP","TEMP_INF","TEMP_SUP") ),
         ),

         CONVECTION      =FACT(statut='f',max='**',
           VITESSE         =SIMP(statut='o',typ=cham_no_sdaster ),
         ),

         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 22/07/2008   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
AFFE_MATERIAU=OPER(nom="AFFE_MATERIAU",op=6,sd_prod=cham_mater,
                   fr="Affecter des matriaux  des zones gomtriques d'un maillage",
                         reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
         MAILLAGE        =SIMP(statut='o',typ=maillage_sdaster),
         MODELE          =SIMP(statut='f',typ=modele_sdaster),

         #  affectation du nom du matriau (par mailles):
         #  ----------------------------------------------
         AFFE            =FACT(statut='o',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           MATER           =SIMP(statut='o',typ=mater_sdaster,max=30),
         ),

         #  affectation du nom du matriau (par noeuds):
         #  ----------------------------------------------
         AFFE_NOEUD        =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           MATER           =SIMP(statut='o',typ=mater_sdaster,max=1),
         ),

         #  affectation de comportement (multifibres pour l'instant):
         #  ----------------------------------------------
         AFFE_COMPOR        =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           COMPOR          =SIMP(statut='o',typ=compor_sdaster,max=1),
         ),

         #  affectation des variables de commande :
         #  --------------------------------------------------
         # un mot cl cach qui ne sert qu' boucler sur les VARC possibles :
         LIST_NOM_VARC =SIMP(statut='c',typ='TXM', defaut=("TEMP","CORR","IRRA","HYDR","SECH","EPSA",
                                                           "M_ACIER","M_ZIRC","NEUT1","NEUT2")),

         AFFE_VARC    =FACT(statut='f',max='**',
          regles=(PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                  PRESENT_ABSENT('GROUP_MA','TOUT'),
                  PRESENT_ABSENT('MAILLE','TOUT'),
                  AU_MOINS_UN('EVOL','CHAMP_GD','VALE_REF'),
                  EXCLUS('EVOL','CHAMP_GD'),
                  ),

          TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ), # [dfaut]
          GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
          MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),

          NOM_VARC        =SIMP(statut='o',typ='TXM', into=("TEMP","CORR","IRRA","HYDR","SECH","M_ACIER","M_ZIRC",
                                                            "EPSA","NEUT1","NEUT2")),
          CHAMP_GD        =SIMP(statut='f',typ=cham_gd_sdaster,),
          EVOL            =SIMP(statut='f',typ=evol_sdaster,),

          B_EVOL          =BLOC(condition="EVOL!=None",
              NOM_CHAM      =SIMP(statut='f',typ='TXM'),
              PROL_DROITE   =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
              PROL_GAUCHE   =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
              FONC_INST     =SIMP(statut='f',typ=(fonction_sdaster,formule)),
          ),
          VALE_REF          =SIMP(statut='f',typ='R'),
         ),

         #  mots cls cachs pour les variables de commande NEUTi :
         #  -------------------------------------------------------
         VARC_NEUT1   =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="NEUT1"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="NEUT_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("X1")),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("NEUT1")),
         ),
         VARC_NEUT2   =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="NEUT2"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="NEUT_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("X1")),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("NEUT2")),
         ),

         #  mots cls cachs pour variable de commande TEMP :
         #  --------------------------------------------------
         VARC_TEMP    =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="TEMP"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="TEMP_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("TEMP",)),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("TEMP",)),
           VALE_DEF        =SIMP(statut='c',typ='R',max=1,min=1,defaut=(0.,)),
         ),

         #  mots cls cachs pour variable de commande SECH :
         #  --------------------------------------------------
         VARC_SECH    =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="SECH"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="TEMP_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("TEMP",)),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("SECH",)),
         ),

         #  mots cls cachs pour variable de commande HYDR :
         #  --------------------------------------------------
         VARC_HYDR    =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="HYDR"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="HYDR_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("HYDR",)),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("HYDR",)),
         ),

         #  mots cls cachs pour variable de commande CORR :
         #  --------------------------------------------------
         VARC_CORR    =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="CORR"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="CORR_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("CORR",)),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("CORR",)),
         ),

         #  mots cls cachs pour variable de commande IRRA :
         #  --------------------------------------------------
         VARC_IRRA    =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="IRRA"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="IRRA_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("IRRA",)),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("IRRA",)),
         ),

         #  mots cls cachs pour variable de commande EPSA :
         #  --------------------------------------------------
         VARC_EPSA    =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="EPSA"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="EPSI_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=6,min=6,defaut=("EPXX","EPYY","EPZZ","EPXY","EPXZ","EPYZ",)),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=6,min=6,defaut=("EPSAXX","EPSAYY","EPSAZZ","EPSAXY","EPSAXZ","EPSAYZ",)),
         ),
         #  mots cls cachs pour variable de commande metallurgique ACIER :
         #  -----------------------------------------------------------------
         VARC_M_ACIER  =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="M_ACIER"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="VARI_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=7,min=7,defaut=("V1","V2","V3","V4","V5","V6","V7")),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=7,min=7,defaut=("PFERRITE","PPERLITE","PBAINITE",
                                                                          "PMARTENS","TAUSTE","TRANSF","TACIER",)),
         ),
         #  mots cls cachs pour variable de commande metallurgique ZIRCALOY :
         #  --------------------------------------------------------------------
         VARC_M_ZIRC  =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="M_ZIRC"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="VARI_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=4,min=4,defaut=("V1","V2","V3","V4")),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=4,min=4,defaut=("ALPHPUR","ALPHBETA","TZIRC","TEMPS")),
         ),

         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
)  ;


#& MODIF COMMANDE  DATE 01/09/2008   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
AFFE_MODELE=OPER(nom="AFFE_MODELE",op=18,sd_prod=modele_sdaster,
            UIinfo={"groupes":("Modlisation",)},
                 fr="Dfinir le phnomne physique modlis et le type d'lments finis sur le maillage",reentrant='n',
         regles=(AU_MOINS_UN('AFFE','AFFE_SOUS_STRUC'),),
         MAILLAGE        =SIMP(statut='o',typ=(maillage_sdaster) ),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
         VERIF           =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max=2,into=("MAILLE","NOEUD") ),
#
#====
# Dfinition des grandeurs caractristiques
#====
#
         GRANDEUR_CARA =FACT(statut='f',max=1,
         fr="Grandeurs caractristiques pour l'adimensionnement des indicateurs d'erreur HM",
         ang="Characteristic data for HM error estimators adimensionalisation",
#
            LONGUEUR      =SIMP(statut='f',typ='R',val_min=0,
                                fr ="Longueur caractristique",
                                ang="Characteristic length",),
            PRESSION      =SIMP(statut='f',typ='R',val_min=0,
                                fr ="Pression caractristique",
                                ang="Characteristic pressure",),
            TEMPERATURE   =SIMP(statut='f',typ='R',val_min=0,
                                fr ="Temprature caractristique",
                                ang="Characteristic temperature",),),
#
         AFFE_SOUS_STRUC =FACT(statut='f',
           regles=(UN_PARMI('TOUT','SUPER_MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           SUPER_MAILLE    =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
           PHENOMENE       =SIMP(statut='f',typ='TXM',defaut="MECANIQUE",into=("MECANIQUE",) ),
         ),
         AFFE            =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','GROUP_NO','MAILLE','NOEUD'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           PHENOMENE       =SIMP(statut='o',typ='TXM',
                                 into=("MECANIQUE","THERMIQUE","ACOUSTIQUE") ),
                b_mecanique     =BLOC( condition = "PHENOMENE=='MECANIQUE'",
                                        fr="modlisations mcaniques",
                    MODELISATION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',into=(
                                  "2D_DIS_T",        # RESP. : FLEJOU J.L.FLEJOU
                                  "2D_DIS_TR",       # RESP. : FLEJOU J.L.FLEJOU
                                  "2D_FLUI_ABSO",    # RESP. : DEVESA G.DEVESA
                                  "2D_FLUI_PESA",    # RESP. : GREFFET N.GREFFET
                                  "2D_FLUI_STRU",    # RESP. : GREFFET N.GREFFET
                                  "2D_FLUIDE",       # RESP. : GREFFET N.GREFFET
                                  "3D",              # RESP. : DESROCHES X.DESROCHES
                                  "3D_ABSO",         # RESP. : DEVESA G.DEVESA
                                  "3D_FAISCEAU",     # RESP. : VOLDOIRE F.VOLDOIRE
                                  "3D_FLUI_ABSO",    # RESP. : DEVESA G.DEVESA
                                  "3D_FLUIDE",       # RESP. : GREFFET N.GREFFET
                                  "3D_INCO",         # RESP. : MICHEL S.MICHEL
                                  "3D_INCO_GD",      # RESP. : MICHEL S.MICHEL
                                  "3D_SI",           # RESP. : DESROCHES X.DESROCHES
                                  "3D_GRAD_EPSI",    # RESP. : MICHEL S.MICHEL
                                  "3D_GRAD_VARI",    # RESP. : MICHEL S.MICHEL
                                  "3D_XFEM_CONT",    # RESP. : GENIAUT S.GENIAUT
                                  "3D_JOINT",        # RESP. : LAVERNE J.LAVERNE
                                  "3D_INTERFACE",    # RESP. : LAVERNE J.LAVERNE
                                  "AXIS",            # RESP. : LEFEBVRE J.P.LEFEBVRE
                                  "AXIS_FLUI_STRU",  # RESP. : GREFFET N.GREFFET
                                  "AXIS_FLUIDE",     # RESP. : GREFFET N.GREFFET
                                  "AXIS_FOURIER",    # RESP. : DESROCHES X.DESROCHES
                                  "AXIS_INCO",       # RESP. : MICHEL S.MICHEL
                                  "AXIS_INCO_GD",    # RESP. : MICHEL S.MICHEL
                                  "AXIS_SI",         # RESP. : DESROCHES X.DESROCHES
                                  "AXIS_GRAD_VARI",  # RESP. : MICHEL S.MICHEL
                                  "AXIS_JOINT",      # RESP. : LAVERNE J.LAVERNE
                                  "AXIS_INTERFACE",  # RESP. : LAVERNE J.LAVERNE
                                  "AXIS_ELDI",       # RESP. : LAVERNE J.LAVERNE
                                  "BARRE",           # RESP. : FLEJOU J.L.FLEJOU
                                  "2D_BARRE",        # RESP. : FLEJOU J.L.FLEJOU
                                  "C_PLAN",          # RESP. : LEFEBVRE J.P.LEFEBVRE
                                  "C_PLAN_XFEM_CONT",# RESP. : GENIAUT S.GENIAUT
                                  "C_PLAN_SI",       # RESP. : DESROCHES X.DESROCHES
                                  "C_PLAN_GRAD_EPSI",# RESP. : MICHEL S.MICHEL
                                  "CABLE",           # RESP. : FLEJOU J.L.FLEJOU
                                  "CABLE_POULIE",    # RESP. : None
                                  "COQUE_3D",        # RESP. : DESROCHES X.DESROCHES
                                  "COQUE_AXIS",      # RESP. : DESROCHES X.DESROCHES
                                  "COQUE_C_PLAN",    # RESP. : DESROCHES X.DESROCHES
                                  "COQUE_D_PLAN",    # RESP. : DESROCHES X.DESROCHES
                                  "D_PLAN",          # RESP. : LEFEBVRE J.P.LEFEBVRE
                                  "D_PLAN_XFEM_CONT",# RESP. : GENIAUT S.GENIAUT
                                  "D_PLAN_GRAD_EPSI",# RESP. : MICHEL S.MICHEL
                                  "D_PLAN_GRAD_VARI",# RESP. : MICHEL S.MICHEL
                                  "PLAN_JOINT",      # RESP. : LAVERNE J.LAVERNE
                                  "PLAN_INTERFACE",  # RESP. : LAVERNE J.LAVERNE
                                  "PLAN_ELDI",       # RESP. : LAVERNE J.LAVERNE
                                  "D_PLAN_ABSO",     # RESP. : DEVESA G.DEVESA
                                  "D_PLAN_INCO",     # RESP. : MICHEL S.MICHEL
                                  "D_PLAN_INCO_GD",  # RESP. : MICHEL S.MICHEL
                                  "D_PLAN_SI",       # RESP. : DESROCHES X.DESROCHES
                                  "DIS_T",           # RESP. : FLEJOU J.L.FLEJOU
                                  "DIS_TR",          # RESP. : FLEJOU J.L.FLEJOU
                                  "DKT",             # RESP. : DESROCHES X.DESROCHES
                                  "DKTG",            # RESP. : MARKOVIC D.MARKOVIC
                                  "DST",             # RESP. : DESROCHES X.DESROCHES
                                  "FLUI_STRU",       # RESP. : GREFFET N.GREFFET
                                  "GRILLE_EXCENTRE", # RESP. : ROSPARS C.ROSPARS
                                  "GRILLE_MEMBRANE", # RESP. : ROSPARS C.ROSPARS
                                  "POU_C_T",         # RESP. : FLEJOU J.L.FLEJOU
                                  "POU_D_E",         # RESP. : FLEJOU J.L.FLEJOU
                                  "POU_D_EM",        # RESP. : FLEJOU J.L.FLEJOU
                                  "POU_D_T",         # RESP. : FLEJOU J.L.FLEJOU
                                  "POU_D_T_GD",      # RESP. : FLEJOU J.L.FLEJOU
                                  "POU_D_TG",        # RESP. : FLEJOU J.L.FLEJOU
                                  "POU_D_TGM",       # RESP. : FLEJOU J.L.FLEJOU
                                  "Q4G",             # RESP. : DESROCHES X.DESROCHES
                                  "TUYAU_3M",        # RESP. : PROIX J.M.PROIX
                                  "TUYAU_6M",        # RESP. : PROIX J.M.PROIX
                                  "SHB8",            # RESP. : DESROCHES X.DESROCHES
                                  "D_PLAN_HHM",      # RESP. : GRANET S.GRANET
                                  "D_PLAN_HM",       # RESP. : GRANET S.GRANET
                                  "D_PLAN_THH",      # RESP. : GRANET S.GRANET
                                  "D_PLAN_THHM",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_THM",      # RESP. : GRANET S.GRANET
                                  "D_PLAN_HHMD",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_HH2MD",    # RESP. : GRANET S.GRANET
                                  "D_PLAN_HMD",      # RESP. : GRANET S.GRANET
                                  "D_PLAN_THHD",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_THH2D",    # RESP. : GRANET S.GRANET
                                  "D_PLAN_THVD",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_THH2MD",   # RESP. : GRANET S.GRANET
                                  "D_PLAN_THHMD",    # RESP. : GRANET S.GRANET
                                  "D_PLAN_THMD",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_HHMS",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_HH2MS",    # RESP. : GRANET S.GRANET
                                  "D_PLAN_HMS",      # RESP. : GRANET S.GRANET
                                  "D_PLAN_THHS",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_THH2S",    # RESP. : GRANET S.GRANET
                                  "D_PLAN_THVS",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_THH2MS",   # RESP. : GRANET S.GRANET
                                  "D_PLAN_THHMS",    # RESP. : GRANET S.GRANET
                                  "D_PLAN_THMS",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_HM_P",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_HHD",      # RESP. : GRANET S.GRANET
                                  "D_PLAN_HHS",      # RESP. : GRANET S.GRANET
                                  "D_PLAN_HH2D",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_HH2S",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_2DG",      # RESP. : GRANET S.GRANET
                                  "D_PLAN_DIL",      # RESP. : GRANET S.GRANET
                                  "AXIS_THH",        # RESP. : GRANET S.GRANET
                                  "AXIS_THHM",       # RESP. : GRANET S.GRANET
                                  "AXIS_THM",        # RESP. : GRANET S.GRANET
                                  "AXIS_HHM",        # RESP. : GRANET S.GRANET
                                  "AXIS_HM",         # RESP. : GRANET S.GRANET
                                  "AXIS_HH2MD",      # RESP. : GRANET S.GRANET
                                  "AXIS_HHMD",       # RESP. : GRANET S.GRANET
                                  "AXIS_HMD",        # RESP. : GRANET S.GRANET
                                  "AXIS_THHD",       # RESP. : GRANET S.GRANET
                                  "AXIS_THH2D",      # RESP. : GRANET S.GRANET
                                  "AXIS_THVD",       # RESP. : GRANET S.GRANET
                                  "AXIS_THHMD",      # RESP. : GRANET S.GRANET
                                  "AXIS_THH2MD",     # RESP. : GRANET S.GRANET
                                  "AXIS_THMD",       # RESP. : GRANET S.GRANET
                                  "AXIS_HH2MS",      # RESP. : GRANET S.GRANET
                                  "AXIS_HHMS",       # RESP. : GRANET S.GRANET
                                  "AXIS_HMS",        # RESP. : GRANET S.GRANET
                                  "AXIS_THHS",       # RESP. : GRANET S.GRANET
                                  "AXIS_THH2S",      # RESP. : GRANET S.GRANET
                                  "AXIS_THVS",       # RESP. : GRANET S.GRANET
                                  "AXIS_THHMS",      # RESP. : GRANET S.GRANET
                                  "AXIS_THH2MS",     # RESP. : GRANET S.GRANET
                                  "AXIS_THMS",       # RESP. : GRANET S.GRANET
                                  "AXIS_HHD",        # RESP. : GRANET S.GRANET
                                  "AXIS_HHS",        # RESP. : GRANET S.GRANET
                                  "AXIS_HH2D",       # RESP. : GRANET S.GRANET
                                  "AXIS_HH2S",       # RESP. : GRANET S.GRANET
                                  "3D_HHM" ,         # RESP. : GRANET S.GRANET
                                  "3D_HM",           # RESP. : GRANET S.GRANET
                                  "3D_THH",          # RESP. : GRANET S.GRANET
                                  "3D_THV",          # RESP. : GRANET S.GRANET
                                  "3D_THHM",         # RESP. : GRANET S.GRANET
                                  "3D_THM",          # RESP. : GRANET S.GRANET
                                  "3D_HHMD",         # RESP. : GRANET S.GRANET
                                  "3D_HMD",          # RESP. : GRANET S.GRANET
                                  "3D_THHD",         # RESP. : GRANET S.GRANET
                                  "3D_THVD",         # RESP. : GRANET S.GRANET
                                  "3D_THHMD",        # RESP. : GRANET S.GRANET
                                  "3D_THMD",         # RESP. : GRANET S.GRANET
                                  "3D_HHMS",         # RESP. : GRANET S.GRANET
                                  "3D_HMS",          # RESP. : GRANET S.GRANET
                                  "3D_THHS",         # RESP. : GRANET S.GRANET
                                  "3D_THVS",         # RESP. : GRANET S.GRANET
                                  "3D_THHMS",        # RESP. : GRANET S.GRANET
                                  "3D_THMS",         # RESP. : GRANET S.GRANET
                                  "3D_THH2MD",       # RESP. : GRANET S.GRANET
                                  "3D_THH2MS",       # RESP. : GRANET S.GRANET
                                  "3D_HH2MD",        # RESP. : GRANET S.GRANET
                                  "3D_HH2MS",        # RESP. : GRANET S.GRANET
                                  "3D_THH2S",        # RESP. : GRANET S.GRANET
                                  "3D_THH2D",        # RESP. : GRANET S.GRANET
                                  "3D_HHD",          # RESP. : GRANET S.GRANET
                                  "3D_HHS",          # RESP. : GRANET S.GRANET
                                  "3D_HH2D",         # RESP. : GRANET S.GRANET
                                  "3D_HH2S",         # RESP. : GRANET S.GRANET
                                  "VF1",             # RESP. : GRANET S.GRANET
                                                                     )  )  ),

                b_thermique     =BLOC( condition = "PHENOMENE=='THERMIQUE'",
                                        fr="modlisations thermiques",
                    MODELISATION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',into=(
                                  "3D",              # RESP. : DURAND C.DURAND
                                  "3D_DIAG",         # RESP. : DURAND C.DURAND
                                  "AXIS",            # RESP. : DURAND C.DURAND
                                  "AXIS_DIAG",       # RESP. : DURAND C.DURAND
                                  "AXIS_FOURIER",    # RESP. : DESROCHES X.DESROCHES
                                  "COQUE",           # RESP. : DESROCHES X.DESROCHES
                                  "COQUE_AXIS",      # RESP. : DESROCHES X.DESROCHES
                                  "COQUE_PLAN",      # RESP. : DESROCHES X.DESROCHES
                                  "PLAN",            # RESP. : DURAND C.DURAND
                                  "PLAN_DIAG",       # RESP. : DURAND C.DURAND
                                                                      ),),),

                b_acoustique    =BLOC( condition = "PHENOMENE=='ACOUSTIQUE'",
                                        fr="modlisations acoustiques",
                     MODELISATION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',into=(
                                  "3D",              # RESP. : None
                                  "PLAN"             # RESP. : None
                                                                       ), ),),

         ),

         VERI_JACOBIEN  =SIMP(statut='f',typ='TXM',into=('OUI','NON'),defaut='OUI',
                              fr ="Vrification de la forme des mailles (jacobiens tous de meme signe).",),
) ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE
AIDE=PROC(nom="AIDE",op=42,
       UIinfo={"groupes":("Modlisation",)},
       fr="Interroger et imprimer une documentation partielle sur les noms des concepts dj dfinis et sur les couples"
           +" (type d'lments, option) disponibles dans la version.",
       regles=(AU_MOINS_UN('CONCEPT','TYPE_ELEM', ),),
       UNITE       =SIMP(statut='f',typ='I',defaut=8),  
       TYPE_ELEM   =FACT(fr="couple type_elem option",statut='f',
         INITEL       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ),
                        ),
       CONCEPT     =FACT(statut='f',max='**',
         NOM          =SIMP(fr="liste des noms de concept",statut='f',typ='TXM',validators=NoRepeat(),max='**',defaut="*"),
         OPTION       =SIMP(fr="option d'dition de concept",statut='f',typ='TXM',defaut="TOUT_TYPE",
                                 into=("TOUT_TYPE","CREER","A_CREER",) ),
         ),
) ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE PELLET J.PELLET
ASSE_MAILLAGE=OPER(nom="ASSE_MAILLAGE",op= 105,sd_prod=maillage_sdaster,
                   fr="Assembler deux maillages pour en former un nouveau",
                   reentrant='n',
                   UIinfo={"groupes":("Maillage",)},
         MAILLAGE_1 =  SIMP(statut='o',typ=maillage_sdaster,),
         MAILLAGE_2 =  SIMP(statut='o',typ=maillage_sdaster,),
         OPERATION  =  SIMP(statut='o',typ='TXM',into=("SOUS_STR","SUPERPOSE","COLLAGE"),),
         b_collage  =  BLOC(condition = "OPERATION == 'COLLAGE'",
           COLLAGE  =  FACT(statut='o',
              GROUP_MA_1     =SIMP(statut='o',typ=grma),
              GROUP_MA_2     =SIMP(statut='o',typ=grma),
                             ),
                           ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE BODEL C.BODEL
def asse_matr_gene_prod(METHODE,**args):
    if   (METHODE=="INITIAL") : return matr_asse_gene_r
    elif (args['OPTION']=="RIGI_GENE_C") : return matr_asse_gene_c
    else : return matr_asse_gene_r

ASSE_MATR_GENE=OPER(nom="ASSE_MATR_GENE",op= 128,sd_prod=asse_matr_gene_prod,
                    fr="Assemblage des matrices gnralises de macro lments pour construction de la matrice globale gnralise",
                    reentrant='n',
            UIinfo={"groupes":("Matrices/vecteurs",)},
         NUME_DDL_GENE   =SIMP(statut='o',typ=nume_ddl_gene ),
         METHODE          =SIMP(statut='f',typ='TXM',defaut="CLASSIQUE",into=("CLASSIQUE","INITIAL") ),
         b_option     =BLOC(condition = "METHODE == 'CLASSIQUE'",
           OPTION          =SIMP(statut='o',typ='TXM',into=("RIGI_GENE","RIGI_GENE_C","MASS_GENE","AMOR_GENE") ),
           ),
)  ;
#& MODIF COMMANDE  DATE 06/10/2008   AUTEUR DEVESA G.DEVESA 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE PELLET J.PELLET
def asse_matrice_prod(MATR_ELEM,**args):
  if AsType(MATR_ELEM) == matr_elem_depl_r : return matr_asse_depl_r
  if AsType(MATR_ELEM) == matr_elem_depl_c : return matr_asse_depl_c
  if AsType(MATR_ELEM) == matr_elem_temp_r : return matr_asse_temp_r
  if AsType(MATR_ELEM) == matr_elem_pres_c : return matr_asse_pres_c
  raise AsException("type de concept resultat non prevu")

ASSE_MATRICE=OPER(nom="ASSE_MATRICE",op=12,sd_prod=asse_matrice_prod,
                  fr="Construction d'une matrice assemble",reentrant='n',
            UIinfo={"groupes":("Matrices/vecteurs",)},
         MATR_ELEM       =SIMP(statut='o',
                               typ=(matr_elem_depl_r,matr_elem_depl_c,matr_elem_temp_r,matr_elem_pres_c) ),
         NUME_DDL        =SIMP(statut='o',typ=nume_ddl_sdaster),
         SYME            =SIMP(statut='f',typ='TXM',into=("OUI",) ),         
         CHAR_CINE       =SIMP(statut='f',typ=(char_cine_meca,char_cine_ther,char_cine_acou) ),
         INFO            =SIMP(statut='f',typ='I',into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE PELLET J.PELLET

ASSE_VECTEUR=OPER(nom="ASSE_VECTEUR",op=13,sd_prod=cham_no_sdaster,
                  fr="Construire un champ aux noeuds par assemblage de vecteurs lmentaires",reentrant='n',
            UIinfo={"groupes":("Matrices/vecteurs",)},
         VECT_ELEM       =SIMP(statut='o',typ=vect_elem,max='**'),
         NUME_DDL        =SIMP(statut='o',typ=nume_ddl_sdaster ),
         INFO            =SIMP(statut='f',typ='I',into=(1,2,) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE BODEL C.BODEL
ASSE_VECT_GENE=OPER(nom="ASSE_VECT_GENE",op= 140,sd_prod=vect_asse_gene,
                    fr="Projection des chargements sur la base modale d'une sous structure",
                    reentrant='n',
            UIinfo={"groupes":("Matrices/vecteurs",)},
         NUME_DDL_GENE   =SIMP(statut='o',typ=nume_ddl_gene ),
         METHODE          =SIMP(statut='f',typ='TXM',defaut="CLASSIQUE",into=("CLASSIQUE","INITIAL") ),
         b_nume     =BLOC(condition = "METHODE == 'CLASSIQUE'",
             CHAR_SOUS_STRUC =FACT(statut='o',max='**',
             SOUS_STRUC      =SIMP(statut='o',typ='TXM' ),
             VECT_ASSE       =SIMP(statut='o',typ=cham_no_sdaster ),
           ),
         ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE DEVESA G.DEVESA
CALC_AMOR_MODAL=OPER(nom="CALC_AMOR_MODAL",op= 172,sd_prod=listr8_sdaster,
                     fr="Cration d'une liste d'amortissements modaux calculs selon la rgle du RCC-G",
                     reentrant='n',
            UIinfo={"groupes":("Rsolution",)},
         ENER_SOL        =FACT(statut='o',
           regles=(UN_PARMI('GROUP_NO_RADIER','GROUP_MA_RADIER'),
                   PRESENT_ABSENT('COEF_GROUP','FONC_GROUP'),
#  Peut-on remplacer les deux rgles suivantes par un ENSEMBLE_('KRX','KRY','KRZ')
                   PRESENT_PRESENT('KRX','KRY'),
                   PRESENT_PRESENT('KRX','KRZ'),
                   PRESENT_ABSENT('COOR_CENTRE','NOEUD_CENTRE'),
                   PRESENT_ABSENT('GROUP_NO_CENTRE','NOEUD_CENTRE'),
                   PRESENT_ABSENT('GROUP_NO_CENTRE','COOR_CENTRE'),),
           METHODE         =SIMP(statut='f',typ='TXM',defaut="DEPL",into=("DEPL","RIGI_PARASOL") ),
           MODE_MECA       =SIMP(statut='o',typ=mode_meca ),
           GROUP_NO_RADIER =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           GROUP_MA_RADIER =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           FONC_GROUP      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           COEF_GROUP      =SIMP(statut='f',typ='R',max='**'),
           KX              =SIMP(statut='o',typ='R' ),
           KY              =SIMP(statut='o',typ='R' ),
           KZ              =SIMP(statut='o',typ='R' ),
           KRX             =SIMP(statut='f',typ='R' ),
           KRY             =SIMP(statut='f',typ='R' ),
           KRZ             =SIMP(statut='f',typ='R' ),
           GROUP_NO_CENTRE =SIMP(statut='f',typ=grno),
           NOEUD_CENTRE    =SIMP(statut='f',typ=no),
           COOR_CENTRE     =SIMP(statut='f',typ='R',max=3),
         ),
         AMOR_INTERNE    =FACT(statut='o',
           ENER_POT        =SIMP(statut='o',typ=table_sdaster ),
           GROUP_MA        =SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**'),
           AMOR_REDUIT     =SIMP(statut='o',typ='R',max='**'),
         ),
         AMOR_SOL        =FACT(statut='o',
           AMOR_REDUIT     =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           FONC_AMOR_GEO   =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule),max='**' ),
           HOMOGENE        =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           SEUIL           =SIMP(statut='f',typ='R',defaut= 0.3 ),
         ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE ASSIRE A.ASSIRE

CALC_CHAM_ELEM=OPER(nom="CALC_CHAM_ELEM",op=38,sd_prod=cham_elem,
                    fr="Calculer un champ lmentaire en thermique et en accoustique  partir de champs dj calculs",
                    reentrant='n',
            UIinfo={"groupes":("Post traitements",)},
         MODELE          =SIMP(statut='o',typ=modele_sdaster),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater),
         CARA_ELEM       =SIMP(statut='f',typ=cara_elem),

         regles=(EXCLUS('TOUT','GROUP_MA',),EXCLUS('TOUT','MAILLE',),),
         TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
         GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
         MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),

#
#
#  introduire un mot cle de type modelisation : mcanique,thermique,...
#

         OPTION          =SIMP(statut='o',typ='TXM',
                               into=("FLUX_ELGA_TEMP","FLUX_ELNO_TEMP",
                                     "PRES_ELNO_DBEL","PRES_ELNO_REEL","PRES_ELNO_IMAG",
                                     "COOR_ELGA"), ),

         b_thermique  =BLOC(condition="OPTION in ('FLUX_ELNO_TEMP','FLUX_ELGA_TEMP',)",
           TEMP            =SIMP(statut='o',typ=(cham_no_sdaster,)),
         ),

         b_acoustique  =BLOC(condition="OPTION in ('PRES_ELNO_DBEL','PRES_ELNO_REEL','PRES_ELNO_IMAG',)",
           PRES            =SIMP(statut='o',typ=(cham_no_sdaster,)),
         ),



         EXCIT           =FACT(statut='f',max='**',
               regles=(EXCLUS('FONC_MULT','COEF_MULT', ),),
               CHARGE          =SIMP(statut='o',typ=(char_meca,char_ther,char_acou)),
               FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
               COEF_MULT       =SIMP(statut='f',typ='R'), ),

         INST            =SIMP(statut='f',typ='R',defaut= 0.E+0),
         ACCE            =SIMP(statut='f',typ=cham_no_sdaster),
         NUME_COUCHE     =SIMP(statut='f',typ='I',defaut= 1),
         NIVE_COUCHE     =SIMP(statut='f',typ='TXM',defaut="MOY",into=("SUP","INF","MOY") ),
         MODE_FOURIER    =SIMP(statut='f',typ='I',defaut= 0 ),
         ANGLE           =SIMP(statut='f',typ='I',defaut= 0),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE PELLET J.PELLET

CALC_CHAR_CINE=OPER(nom="CALC_CHAR_CINE",op= 102,sd_prod=cham_no_sdaster,
                    fr="Calcul des seconds membres associs  des charges cinmatiques (conditions aux limites non dualises)",
                    reentrant='n',
            UIinfo={"groupes":("Matrices/vecteurs",)},
         NUME_DDL        =SIMP(statut='o',typ=nume_ddl_sdaster ),
         CHAR_CINE       =SIMP(statut='o',typ=(char_cine_meca,char_cine_ther,char_cine_acou ),validators=NoRepeat(),max='**' ),
         INST            =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2 ) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE DEVESA G.DEVESA
def calc_char_seisme_prod(MATR_MASS,**args ):
  if AsType(MATR_MASS) == matr_asse_depl_r : return cham_no_sdaster
  raise AsException("type de concept resultat non prevu")

CALC_CHAR_SEISME=OPER(nom="CALC_CHAR_SEISME",op=  92,sd_prod=calc_char_seisme_prod,
                      reentrant='n',fr="Calcul du chargement sismique",
            UIinfo={"groupes":("Matrices/vecteurs",)},
         regles=(UN_PARMI('MONO_APPUI','MODE_STAT' ),),
         MATR_MASS       =SIMP(statut='o',typ=matr_asse_depl_r,fr="Matrice de masse" ),
         DIRECTION       =SIMP(statut='o',typ='R',max=6,fr="Directions du sisme impos"),
         MONO_APPUI      =SIMP(statut='f',typ='TXM',into=("OUI",) ),         
         MODE_STAT       =SIMP(statut='f',typ=(mode_stat_depl,mode_stat_acce,mode_stat_forc,) ),
         b_mode_stat     =BLOC ( condition = "MODE_STAT != None",
           regles=(UN_PARMI('NOEUD','GROUP_NO' ),),
           NOEUD           =SIMP(statut='f',typ=no,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 05/05/2010   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2009  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE BOTTONI M.BOTTONI

from Macro.calc_ecrevisse_ops import calc_ecrevisse_ops

def calc_ecrevisse_prod(self,CHARGE_MECA,CHARGE_THER1,CHARGE_THER2,TABLE,DEBIT,**args):

  self.type_sdprod(CHARGE_MECA,char_meca)
  self.type_sdprod(CHARGE_THER1,char_ther)
  self.type_sdprod(CHARGE_THER2,char_ther)
  self.type_sdprod(TABLE,table_sdaster)
  self.type_sdprod(DEBIT,table_sdaster)
  return None



CALC_ECREVISSE=MACRO(nom="CALC_ECREVISSE",op=calc_ecrevisse_ops,sd_prod=calc_ecrevisse_prod,reentrant='n',
                     UIinfo={"groupes":("Outils metier",)},fr="Procedure de couplage avec Ecrevisse",

        regles             = (UN_PARMI('LOGICIEL','VERSION'),),

#      CONCEPTS SORTANTS : 2 CHARGEMENTS THERMIQUE + 1 MECANIQUE + 2 TABLES POUR LE POST-TRAITEMENT
#      ********************************************
         CHARGE_MECA        =SIMP(statut='o',typ=CO),
         CHARGE_THER1       =SIMP(statut='o',typ=CO),
         CHARGE_THER2       =SIMP(statut='o',typ=CO),
         TABLE              =SIMP(statut='o',typ=CO),
         DEBIT              =SIMP(statut='o',typ=CO),


#      MODELES MECANIQUES
#      ********************************************
         MODELE_MECA        =SIMP(statut='o',typ=modele_sdaster),
         MODELE_THER        =SIMP(statut='o',typ=modele_sdaster),


#      DONNEES GEOMETRIQUES RELATIVES AUX RESULTATS
#      ********************************************
         RESULTAT           =FACT(statut='o',min=1,max=1,
           MECANIQUE           =SIMP(statut='o',typ=resultat_sdaster),
           THERMIQUE           =SIMP(statut='o',typ=resultat_sdaster),
           regles=(EXCLUS('NUME_ORDRE','INST'),),
           NUME_ORDRE          =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
           INST                =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
         ),

#      DONNEES GEOMETRIQUES RELATIVES A LA FISSURE
#      *******************************************

         FISSURE            =FACT(statut='o',min=1,max='**',
           PREFIXE_FICHIER     =SIMP(statut='f',typ='TXM',validators=LongStr(1,8),),
           GROUP_MA            =SIMP(statut='o',typ=grma,validators=NoRepeat(),min=2,max=2,
                                     fr="Groupe(s) des noeuds definissant les levres de la fissure"),
           GROUP_NO_ORIG       =SIMP(statut='o',typ=grno,validators=NoRepeat(),min=2,max=2),
           GROUP_NO_EXTR       =SIMP(statut='o',typ=grno,validators=NoRepeat(),min=2,max=2),
           ZETA                =SIMP(statut='o',typ='R',fr="Coefficient de la perte de charge singuliere a l'entree [zeta]" ),
           RUGOSITE            =SIMP(statut='o',typ='R',fr="Rugosite absolu (metres) [eps]" ),
           OUVERT_REMANENTE    =SIMP(statut='o',typ='R',val_min=0.,fr="Ouverture remanente"),
           TORTUOSITE          =SIMP(statut='f',typ='R',defaut=1.0, val_min=0., val_max=1.0,
                                       fr="Coefficient de tortuosite de la fissure" ),
           SECTION             =SIMP(statut='o',typ='TXM',into=("ELLIPSE","RECTANGLE"),fr="Type de section [is]" ),
           b_section_ellipse   =BLOC(condition="SECTION=='ELLIPSE'",fr="Fissure a section elliptique",
             LISTE_COTES_BL      =SIMP(statut='f',typ='R',max='**',
                                       fr="Liste des cotes des points definissant le petit axe de la section",
                                       validators=NoRepeat() ),
             LISTE_VAL_BL        =SIMP(statut='o',typ='R',max='**',
                                       fr="Liste des valeurs des points definissant le petit axe de la section", ),
           ),
           b_section_rectangle =BLOC(condition="SECTION=='RECTANGLE'",fr="Fissure a section rectangulaire",
             LISTE_COTES_BL      =SIMP(statut='f',typ='R',max='**',
                                       fr="Liste des cotes des points definissant la largeur de la section",
                                       validators=NoRepeat() ),
             LISTE_VAL_BL        =SIMP(statut='o',typ='R',max='**',
                                       fr="Liste des valeurs des points definissant la largeur de la section", ),
           ),
         ),


#      DONNEES RELATIVES A L"ECOULEMENT
#      ********************************

         ECOULEMENT         =FACT(statut='o',min=1,max=1,
           PRES_ENTREE         =SIMP(statut='o',typ='R',fr="Pression de stagnation a l'entree (Pa) [pe]" ),
           PRES_SORTIE         =SIMP(statut='o',typ='R',fr="Pression de stagnation a la sortie (Pa) [ps]" ),
           FLUIDE_ENTREE       =SIMP(statut='o',typ='I',into=(1,2,3,4,5,6),fr="Condition du fluide a l'entree [iflow]" ),
           b_condition_1       =BLOC(condition="FLUIDE_ENTREE==1",fr="Eau sous-refroidie ou saturee",
             TEMP_ENTREE         =SIMP(statut='o',typ='R',fr="Temperature a l'entree (degres C) [te]" ),
           ),
           b_condition_2       =BLOC(condition="FLUIDE_ENTREE==2",fr="Fluide diphasique",
             TITR_MASS           =SIMP(statut='o',typ='R',fr="Titre massique eau vap/eau tot a l'entree [xe]" ),
           ),
           b_condition_3       =BLOC(condition="FLUIDE_ENTREE==3",fr="Vapeur saturee ou surchauffee",
             TEMP_ENTREE         =SIMP(statut='o',typ='R',fr="Temperature a l'entree (degres C) [te]" ),
           ),
           b_condition_4       =BLOC(condition="FLUIDE_ENTREE==4",fr="Air + vapeur surchauffee",
             TEMP_ENTREE         =SIMP(statut='o',typ='R',fr="Temperature a l'entree (degres C) [te]" ),
             PRES_PART           =SIMP(statut='o',typ='R',fr="Pression partielle air en entree (Pa) [pae]" ),
           ),
           b_condition_5       =BLOC(condition="FLUIDE_ENTREE==5",fr="Air + vapeur saturee",
             TITR_MASS           =SIMP(statut='o',typ='R',fr="Titre massique eau vap/eau tot a l'entree [xe]" ),
             PRES_PART           =SIMP(statut='o',typ='R',fr="Pression partielle air en entree (Pa) [pae]" ),
           ),
           b_condition_6       =BLOC(condition="FLUIDE_ENTREE==6",fr="Air seul",
             TEMP_ENTREE         =SIMP(statut='o',typ='R',fr="Temperature a l'entree (degres C) [te]" ),
           ),
         ),


#      CHOIX DES MODELES
#      *****************

         MODELE_ECRE        =FACT(statut='o',min=1,max=1,
           IVENAC              =SIMP(statut='f', typ='I', into=(0,1), defaut=0,
                                     fr="Calcul ECREVISSE avec prise en compte de la vena contracta"),
           ECOULEMENT          =SIMP(statut='o',typ='TXM',into=("SATURATION","GELE"),
                                     fr="Type de modele d'ecoulement diphasique [imod]" ),
           b_ecou_gele         =BLOC(condition="ECOULEMENT=='GELE'",fr="Modele d'ecoulement gele",
             PRESS_EBULLITION    =SIMP(statut='o',typ='R',fr="Pression d'ebullition [corrp*psat(t)]" ),
           ),
           FROTTEMENT          =SIMP(statut='o',typ='I',into=(-3,-2,-1,0,1,2,3),fr="Correlation de frottement [ifrot]" ),
           b_frottement        =BLOC(condition="FROTTEMENT<0",fr="Modele d'ecoulement gele",
             REYNOLDS_LIM        =SIMP(statut='o',typ='R',fr="Coefficient de Reynolds limite [relim]" ),
             FROTTEMENT_LIM      =SIMP(statut='o',typ='R',fr="Coefficient de frottement impose [frtlim]" ),
           ),

           TRANSFERT_CHAL      =SIMP(statut='o',typ='I',into=(-2,-1,0,1,2),fr="Transfert de chaleur [ichal]" ),
           b_transchal         =BLOC(condition="TRANSFERT_CHAL<0", fr="Cas diphasique",
             XMINCH              =SIMP(statut='o',typ='R',fr="Titre massique gazeux min [xminch]"),
             XMAXCH              =SIMP(statut='o',typ='R',fr="Titre massique gazeux max [xmaxch]"),
           ),
         ),


#      DONNEES RELATIVES A LA CONVERGENCE NUMERIQUE
#      ********************************************

         CONVERGENCE        =FACT(statut='o',min=1,max=1,
           KGTEST              =SIMP(statut='f',typ='R',val_min=0.E+0,val_max=1.E+0,defaut= 0.5E+0,
                                     fr="Parametre de l'algorithme iteratif [kgtest]" ),
           ITER_GLOB_MAXI      =SIMP(statut='f',typ='I',defaut= 400,
                                     fr="Nombre maximum d'iterations de la methode de Newton [itnmax]" ),
           CRIT_CONV_DEBI      =SIMP(statut='f',typ='R',val_min=0.E+0,val_max=1.E+0,defaut= 1.E-5,
                                     fr="Critere de convergence en debit [precdb]" ),
         ),

#      GENERAL
#      *******

         COURBES            =SIMP(statut='f',typ='TXM',into=("INTERACTIF","POSTSCRIPT","AUCUNE"),defaut="AUCUNE",
                                  fr="Generation eventuelle des courbes" ),
         LOGICIEL           =SIMP(statut='f',typ='TXM',validators=LongStr(1,255),),
         VERSION            =SIMP(statut='f',typ='TXM',defaut="3.1.2",into = ("3.1.1","3.1.2")),
         ENTETE             =SIMP(statut='f',typ='TXM',max='**',defaut="Titre du calcul Ecrevisse" ),
         IMPRESSION         =SIMP(statut='f',typ='TXM',defaut='NON',into=( 'OUI','NON') ),
         INFO               =SIMP(statut='f',typ='I',defaut= 1,into=(1,2) ),

)  ;
#& MODIF COMMANDE  DATE 09/11/2009   AUTEUR LEBOUVIER F.LEBOUVIER 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ASSIRE A.ASSIRE
def calc_elem_prod(RESULTAT,**args):
   if AsType(RESULTAT) != None : return AsType(RESULTAT)
   raise AsException("type de concept resultat non prevu")

CALC_ELEM=OPER(nom="CALC_ELEM",op=58,sd_prod=calc_elem_prod,reentrant='f',
            UIinfo={"groupes":("Post traitements",)},
            fr="Complter ou crer un rsultat en calculant des champs par lments (contraintes, dformations,... )",
     MODELE          =SIMP(statut='f',typ=modele_sdaster),
     CHAM_MATER      =SIMP(statut='f',typ=cham_mater),
     CARA_ELEM       =SIMP(statut='f',typ=cara_elem),

     RESULTAT        =SIMP(statut='o',typ=resultat_sdaster,
                                      fr="Rsultat d'une commande globale"),

     regles=(EXCLUS('TOUT_ORDRE','NUME_ORDRE','INST','FREQ','NUME_MODE',
                    'NOEUD_CMP','LIST_INST','LIST_FREQ','LIST_ORDRE','NOM_CAS'),
             CONCEPT_SENSIBLE("SEPARE"),
             DERIVABLE('RESULTAT'),),
     TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
     NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
     NUME_MODE       =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
     NOEUD_CMP       =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**'),
     NOM_CAS         =SIMP(statut='f',typ='TXM' ),
     INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
     FREQ            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
     LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
     LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster),
     CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",) ),
     b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
         PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6),),
     b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
         PRECISION       =SIMP(statut='o',typ='R'),),
     LIST_ORDRE      =SIMP(statut='f',typ=listis_sdaster),
     TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
     GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**',
                           fr="le calcul ne sera effectu que sur ces mailles l"),
     MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**',
                           fr="le calcul ne sera effectu que sur ces mailles l"),

#    definition d'un repere local

     REPE_COQUE      =FACT(statut='f',max='**',
                           fr="dfiniton du lieu de post-traitement",
                           regles=EXCLUS('ANGL_REP','VECTEUR'),
          TOUT         =SIMP(statut='f',typ='TXM',into=("OUI",) ),
          GROUP_MA     =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**',),
          MAILLE       =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**',),

          NUME_COUCHE  =SIMP(statut='f',typ='I',defaut= 1,
                             fr="numero de couche dans l'paisseur de la coque ou du tuyau" ),
          NIVE_COUCHE  =SIMP(statut='f',typ='TXM',defaut="MOY",into=("SUP","INF","MOY"),
                             fr="position dans l'paisseur de la coque, ou de la couche" ),

          ANGLE        =SIMP(statut='f',typ='I',defaut= 0,
                             fr="angle de dpouillement pour les tuyaux, en degres  partir de la gnratrice" ),

          PLAN         =SIMP(statut='f',typ='TXM',defaut="MAIL",into=("SUP","INF","MOY","MAIL"),
                               fr="Plan de calcul pour les plaques excentres" ),

          ANGL_REP     =SIMP(statut='f',typ='R',min=2,max=2,
                           fr="dfinition du repere de post-traitement, par dfaut ANGL_REP=(0.,0.)"),
          VECTEUR      =SIMP(statut='f',typ='R',min=3,max=3,
                           fr="dfinition du repere de post-traitement, par dfaut VECTEUR=(1.,0.,0.)"),
                            ),

#    options pour des resultats lineaires

     b_lineaire =BLOC( condition = "AsType(RESULTAT) in (evol_elas,dyna_trans,dyna_harmo,mode_meca,\
                                                               mode_stat,mode_stat_depl,mode_stat_acce,mode_stat_forc,\
                                                               mult_elas,fourier_elas,base_modale,mode_flamb)",
                                                               fr="options mecaniques lineaires",
          TYPE_OPTION =SIMP(statut='f',typ='TXM',defaut='TOUTES',fr="type d'options mecaniques lineaires",
                           into=("SIGM_MASSIF","SIGM_STRUCT","EPSI","ENER","CRIT","DERIVEES",
                                 "INDI_ERREUR","AUTRES","TOUTES"),
                           ),
          b_toutes=BLOC( condition = "TYPE_OPTION == 'TOUTES'",fr="toutes les options evol elas",
               OPTION =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',defaut="SIEF_ELNO_ELGA",
                              #  contraintes
                           into=( "SIEF_ELNO_ELGA","SIGM_ELNO_DEPL","SIEF_ELGA_DEPL",
                                  "SIPO_ELNO_DEPL","EFGE_ELNO_DEPL","EFGE_ELNO_CART","SIGM_ELNO_CART",
                                  "SIGM_ELNO_SIEF","SIPO_ELNO_SIEF","SIGM_ELNO_TUYO","ARCO_ELNO_SIGM",
                              # dformations
                                 "EPSI_ELNO_DEPL","EPSI_ELGA_DEPL","EPSG_ELGA_DEPL","EPSG_ELNO_DEPL",
                                 "EPME_ELNO_DEPL","EPME_ELGA_DEPL","DEGE_ELNO_DEPL","EPSI_ELNO_TUYO",
                                 "EPVC_ELNO","EPVC_ELGA",
                              #  ENER
                                 "EPOT_ELEM_DEPL","ECIN_ELEM_DEPL","ENEL_ELGA","ENEL_ELNO_ELGA",
                                 "ETOT_ELGA","ETOT_ELNO_ELGA","ETOT_ELEM",
                              #  estimateurs erreur
                                 "SIGM_NOZ1_ELGA","ERZ1_ELEM_SIGM","SIGM_NOZ2_ELGA","ERZ2_ELEM_SIGM",
                                 "SIRE_ELNO_DEPL","ERRE_ELEM_SIGM","ERRE_ELNO_ELEM",
                                 "QIRE_ELEM_SIGM","QIRE_ELNO_ELEM","QIZ1_ELEM_SIGM","QIZ2_ELEM_SIGM",
                                 "SING_ELEM","SING_ELNO_ELEM",
                              #  CRIT
                                 "EQUI_ELNO_SIGM","EQUI_ELGA_SIGM","CRIT_ELNO_RUPT",
                                 "EQUI_ELNO_EPSI","EQUI_ELGA_EPSI","EQUI_ELNO_EPME","EQUI_ELGA_EPME",
                                 "ENDO_ELGA","ENDO_ELNO_ELGA",
                                 "ENDO_ELNO_SIGA","ENDO_ELNO_SINO","SIEQ_ELNO_TUYO","EPEQ_ELNO_TUYO",
                              #  derivees
                                 "DEUL_ELGA_DEPL","DEDE_ELNO_DLDE","DESI_ELNO_DLSI",
                              #  autres
                                 "VALE_NCOU_MAXI","PRES_DBEL_DEPL"),),

               NOM_CHAM  =SIMP(statut='f',typ='TXM',fr="nom du champ pour VALE_NCOU_MAXI", ),
               NOM_CMP   =SIMP(statut='f',typ='TXM',fr="nom de la composante pour VALE_NCOU_MAXI",  ),

                b_erre_qi =BLOC(condition = "OPTION in ('QIRE_ELEM_SIGM','QIZ1_ELEM_SIGM','QIZ2_ELEM_SIGM') or \
                                        (type(OPTION)==type(()) and 'QIRE_ELEM_SIGM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ1_ELEM_SIGM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ2_ELEM_SIGM' in OPTION)",
                    RESU_DUAL=SIMP(statut='o',typ=evol_elas,fr="resultat du probleme dual"),),

               b_sing =BLOC(condition= "OPTION == 'SING_ELEM' or \
                               (type(OPTION)==type(()) and  'SING_ELEM' in OPTION)",
                    PREC_ERR=SIMP(statut='o',typ='R',val_min= 0.,
                                  fr="precision demandee pour calculer la carte de taille des elements"),
                    TYPE_ESTI=SIMP(statut='f',typ='TXM',into=("ERRE_ELEM_SIGM","ERZ1_ELEM_SIGM","ERZ2_ELEM_SIGM",
                                                              "QIRE_ELEM_SIGM","QIZ1_ELEM_SIGM","QIZ2_ELEM_SIGM",),
                                   fr="choix de l'estimateur d'erreur"),),

               EXCIT           =FACT(statut='f',max='**',
                                     fr="Charges contenant les tempratures, les efforts rpartis pour les poutres...",
                                     regles=(EXCLUS('FONC_MULT','FONC_MULT_C','COEF_MULT','COEF_MULT_C'),),
                    CHARGE          =SIMP(statut='o',typ=(char_meca,char_cine_meca) ),
                    FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                    FONC_MULT_C     =SIMP(statut='f',typ=fonction_c),
                    COEF_MULT       =SIMP(statut='f',typ='R'),
                    COEF_MULT_C     =SIMP(statut='f',typ='C'),
                    PHAS_DEG        =SIMP(statut='f',typ='R'),
                    PUIS_PULS       =SIMP(statut='f',typ='I'),
                    TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE",into=("FIXE",),),),


                            ),
#             fin bloc b_toutes

          b_sigm_massif =BLOC( condition = "TYPE_OPTION == 'SIGM_MASSIF'",
                                     fr="options de contraintes elasticite 2D et 3D",
              OPTION =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',defaut='SIEF_ELNO_ELGA',
                            fr="option de calcul des contraintes",
                           into=( "SIEF_ELNO_ELGA","SIGM_ELNO_DEPL","SIEF_ELGA_DEPL",),),

                    b_charge =BLOC( condition = "OPTION in ('SIGM_ELNO_DEPL','SIEF_ELGA_DEPL',) or \
                                      (type(OPTION)==type(()) and  'SIGM_ELNO_DEPL' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'SIEF_ELGA_DEPL' in OPTION ) ",
                                      fr="charge contenant les temperatures ou autre charge",
                         EXCIT           =FACT(statut='f',max='**',
                         CHARGE          =SIMP(statut='o',typ=(char_meca,char_cine_meca) ),),
                                    ),
                                  ),

          b_sigm_struct =BLOC( condition = "TYPE_OPTION == 'SIGM_STRUCT'",
                                      fr="options de contraintes elasticite poutres, coques, tuyaux",
               OPTION =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',defaut='SIEF_ELNO_ELGA',
                            fr="option de calcul des contraintes ou efforts generalises",
                            into=( "SIEF_ELNO_ELGA","SIGM_ELNO_DEPL","SIEF_ELGA_DEPL","SIGM_ELNO_TUYO",
                                   "SIPO_ELNO_DEPL","EFGE_ELNO_DEPL","EFGE_ELNO_CART","SIGM_ELNO_CART",
                                   "SIGM_ELNO_SIEF","SIPO_ELNO_SIEF"),),

               b_charge =BLOC( condition = "OPTION in ('SIGM_ELNO_DEPL','SIEF_ELGA_DEPL',\
                                                       'SIPO_ELNO_DEPL','EFGE_ELNO_DEPL',) or \
                                            (type(OPTION)==type(()) and  'SIGM_ELNO_DEPL' in OPTION ) or \
                                            (type(OPTION)==type(()) and  'SIEF_ELGA_DEPL' in OPTION ) or \
                                            (type(OPTION)==type(()) and  'SIPO_ELNO_DEPL' in OPTION ) or \
                                            (type(OPTION)==type(()) and  'EFGE_ELNO_DEPL' in OPTION ) ",
                                            fr="charge contenant les temperatures ou les efforts rpartis (poutres) ou autre",
                    EXCIT           =FACT(statut='f',max='**',
                                          regles=(EXCLUS('FONC_MULT','FONC_MULT_C','COEF_MULT','COEF_MULT_C'),),
                         CHARGE          =SIMP(statut='f',typ=(char_meca,char_cine_meca) ),
                         FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                         FONC_MULT_C     =SIMP(statut='f',typ=fonction_c),
                         COEF_MULT       =SIMP(statut='f',typ='R'),
                         COEF_MULT_C     =SIMP(statut='f',typ='C'),
                         PHAS_DEG        =SIMP(statut='f',typ='R'),
                         PUIS_PULS       =SIMP(statut='f',typ='I'),
                         TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE",into=("FIXE",),),),
                             ),


                            ),
#          fin bloc contraintes struct

          b_epsi         =BLOC( condition = "TYPE_OPTION=='EPSI'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("EPSI_ELNO_DEPL","EPSI_ELGA_DEPL","EPME_ELNO_DEPL","EPME_ELGA_DEPL",
                                 "DEGE_ELNO_DEPL","EPSI_ELNO_TUYO","EPVC_ELNO","EPVC_ELGA",),
                                 ),
b_charge =BLOC( condition = "OPTION in ('EPME_ELNO_DEPL','EPSI_ELGA_DEPL','EPME_ELGA_DEPL','EPSI_ELNO_DEPL','EPSI_ELNO_TUYO' ) or \
                                      (type(OPTION)==type(()) and  'EPSI_ELNO_DEPL' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'EPSI_ELNO_TUYO' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'EPSI_ELGA_DEPL' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'EPME_ELNO_DEPL' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'EPME_ELGA_DEPL' in OPTION ) ",
                                      fr="charge contenant les temperatures",
                    EXCIT           =FACT(statut='f',max='**',
                         CHARGE          =SIMP(statut='o',typ=(char_meca,char_ther,char_acou,char_cine_meca) ),),
                                 ),
                                       ),
          b_ener         =BLOC( condition = "TYPE_OPTION=='ENER'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("EPOT_ELEM_DEPL","ECIN_ELEM_DEPL","ENEL_ELGA","ENEL_ELNO_ELGA",
                                 "ETOT_ELGA","ETOT_ELNO_ELGA","ETOT_ELEM",),
                                 ),
               b_charge =BLOC( condition = "OPTION in ('EPOT_ELEM_DEPL','ECIN_ELEM_DEPL','ENEL_ELGA','ENEL_ELNO_ELGA',) or \
                                      (type(OPTION)==type(()) and  'EPOT_ELEM_DEPL' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'ENEL_ELGA' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'ENEL_ELNO_ELGA' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'ECIN_ELEM_DEPL' in OPTION ) ",
                                      fr="charge contenant les temperatures",
                    EXCIT           =FACT(statut='f',max='**',
                         CHARGE          =SIMP(statut='f',typ=(char_meca,char_ther,char_acou,char_cine_meca) ),),
                              ),
                                 ),

          b_crit         =BLOC( condition = "TYPE_OPTION=='CRIT'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("EQUI_ELNO_SIGM","EQUI_ELGA_SIGM",
                                 "EQUI_ELNO_EPSI","EQUI_ELGA_EPSI","EQUI_ELNO_EPME","EQUI_ELGA_EPME",
                                 "ENDO_ELGA","ENDO_ELNO_ELGA",
                                 "ENDO_ELNO_SIGA","ENDO_ELNO_SINO","CRIT_ELNO_RUPT","SIEQ_ELNO_TUYO","EPEQ_ELNO_TUYO",
                                 ) ),
                EXCIT           =FACT(statut='f',max='**',fr="charge contenant les temperatures",
                     CHARGE          =SIMP(statut='o',typ=(char_meca,char_ther,char_acou) ),),
                                 ),

          b_derivees         =BLOC( condition = "TYPE_OPTION=='DERIVEES'",
                  OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("DEUL_ELGA_DEPL","DEDE_ELNO_DLDE","DESI_ELNO_DLSI",
                                 ) ),),

          b_autres         =BLOC( condition = "TYPE_OPTION=='AUTRES'",
                  OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("VALE_NCOU_MAXI","PRES_DBEL_DEPL",
                                 ) ),
               b_maxi    =BLOC( condition = "OPTION=='VALE_NCOU_MAXI' or \
                                (type(OPTION)==type(()) and 'VALE_NCOU_MAXI' in OPTION)",
                    NOM_CHAM  =SIMP(statut='o',typ='TXM',fr="Nom du champ pour VALE_NCOU_MAXI" ),
                    NOM_CMP   =SIMP(statut='o',typ='TXM',fr="Nom de la composante pour VALE_NCOU_MAXI"),),
                                 ),

          b_indi_erreur        =BLOC( condition = "TYPE_OPTION=='INDI_ERREUR'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',defaut="ERRE_ELEM_SIGM",
                           into=("SIGM_NOZ1_ELGA","ERZ1_ELEM_SIGM","SIGM_NOZ2_ELGA","ERZ2_ELEM_SIGM",
                                 "SIRE_ELNO_DEPL","ERRE_ELEM_SIGM","ERRE_ELNO_ELEM",
                                 "QIRE_ELEM_SIGM","QIRE_ELNO_ELEM","QIZ1_ELEM_SIGM","QIZ2_ELEM_SIGM",
                                 "SING_ELEM","SING_ELNO_ELEM",
                                 )),

               b_erre_qi =BLOC(condition = "OPTION in ('QIRE_ELEM_SIGM','QIZ1_ELEM_SIGM','QIZ2_ELEM_SIGM') or \
                                        (type(OPTION)==type(()) and 'QIRE_ELEM_SIGM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ1_ELEM_SIGM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ2_ELEM_SIGM' in OPTION)",
                    RESU_DUAL=SIMP(statut='o',typ=evol_elas,fr="resultat du probleme dual"),),

               b_sing =BLOC(condition= "OPTION == 'SING_ELEM' or \
                               (type(OPTION)==type(()) and  'SING_ELEM' in OPTION)",
                    PREC_ERR=SIMP(statut='o',typ='R',val_min= 0.,
                                  fr="precision demandee pour calculer la carte de taille des elements" ),
                    TYPE_ESTI=SIMP(statut='f',typ='TXM',into=("ERRE_ELEM_SIGM","ERZ1_ELEM_SIGM","ERZ2_ELEM_SIGM",
                                                              "QIRE_ELEM_SIGM","QIZ1_ELEM_SIGM","QIZ2_ELEM_SIGM",),
                                   fr="choix de l'estimateur d'erreur"),),

               EXCIT           =FACT(statut='f',max='**',fr="charge contenant les temperatures",
                     CHARGE          =SIMP(statut='o',typ=(char_meca,char_ther,char_acou) ),),
                                 ),
                                 ),
#    fin bloc lineaire

#    statique ou dynamique non lineaire : evol_noli
     b_noli          =BLOC( condition = "AsType(RESULTAT) == evol_noli",fr="options mecaniques non lineaires",
          TYPE_OPTION =SIMP(statut='f',typ='TXM',defaut='TOUTES',fr="type d'options mecaniques non lineaires",
                           into=("SIGM_MASSIF","SIGM_STRUCT","EPSI","ENER","CRIT",
                                 "VARI","INDI_ERREUR","TOUTES","AUTRES"),
                          ),
          b_toutes =BLOC( condition = "TYPE_OPTION == 'TOUTES'",fr="toutes les options evol elas",
               OPTION      =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=( "SIEF_ELNO_ELGA",
                                  "SIGM_ELNO_TUYO","SIGM_ELNO_COQU","ARCO_ELNO_SIGM",
                                  "SIGM_ELNO_SIEF","SIPO_ELNO_SIEF","EFGE_ELNO_CART",
                                  # EPSI
                                  "EPSI_ELNO_DEPL","EPSI_ELGA_DEPL","EPSG_ELNO_DEPL","EPSG_ELGA_DEPL",
                                 "EPME_ELNO_DEPL","EPME_ELGA_DEPL","EPMG_ELNO_DEPL","EPMG_ELGA_DEPL",
                                 "DEGE_ELNO_DEPL","EPSI_ELNO_TUYO",
                                 "EPSP_ELNO","EPSP_ELGA",
                                 "EPFD_ELNO","EPFD_ELGA","EPVC_ELNO","EPVC_ELGA",
                                 "EPFP_ELNO","EPFP_ELGA",
                                 "VARI_ELNO_ELGA","VARI_ELNO_TUYO","VARI_ELNO_COQU","CRIT_ELNO_RUPT",
                                 "EXTR_ELGA_VARI","EXTR_ELNO_VARI",
                                 # CRIT
                                 "EQUI_ELNO_SIGM","EQUI_ELGA_SIGM","SIEQ_ELNO_TUYO","EPEQ_ELNO_TUYO",
                                 "ERRE_ELEM_SIGM","ERRE_ELNO_ELEM","ERZ1_ELEM_SIGM","ERZ2_ELEM_SIGM",
                                 "QIRE_ELEM_SIGM","QIRE_ELNO_ELEM","QIZ1_ELEM_SIGM","QIZ2_ELEM_SIGM",
                                 "EQUI_ELNO_EPSI","EQUI_ELGA_EPSI","EQUI_ELNO_EPME","EQUI_ELGA_EPME",
                                 "DCHA_ELNO_SIGM","DCHA_ELGA_SIGM","RADI_ELNO_SIGM","RADI_ELGA_SIGM",
                                 "ENDO_ELGA","ENDO_ELNO_ELGA","INDI_LOCA_ELGA","SING_ELEM",
                                 "SING_ELNO_ELEM","ENDO_ELNO_SIGA","ENDO_ELNO_SINO",
                                 "PMPB_ELNO_SIEF","PMPB_ELGA_SIEF","ENEL_ELGA","ENEL_ELNO_ELGA",
                                 "ETOT_ELGA","ETOT_ELNO_ELGA","ETOT_ELEM","VALE_NCOU_MAXI"),
                               ),
               NORME =SIMP(statut='f',typ='TXM',defaut="VMIS",
                                 into=("VMIS","TOTAL","VMIS_CINE","TOTAL_CINE"),
                                 fr="Type de norme pour les options RADI_ et DCHA_"),

               NOM_CHAM  =SIMP(statut='f',typ='TXM',fr="Nom du champ pour VALE_NCOU_MAXI"),
               NOM_CMP   =SIMP(statut='f',typ='TXM',fr="Nom de la composante pour VALE_NCOU_MAXI"),

               b_erre_qi =BLOC(condition = "OPTION in ('QIRE_ELEM_SIGM','QIZ1_ELEM_SIGM','QIZ2_ELEM_SIGM') or \
                                        (type(OPTION)==type(()) and 'QIRE_ELEM_SIGM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ1_ELEM_SIGM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ2_ELEM_SIGM' in OPTION)",
                    RESU_DUAL=SIMP(statut='o',typ=(evol_elas,evol_noli),fr="resultat du probleme dual"),),

               b_sing =BLOC(condition= "OPTION == 'SING_ELEM' or \
                               (type(OPTION)==type(()) and  'SING_ELEM' in OPTION)",
                    PREC_ERR=SIMP(statut='o',typ='R',val_min= 0.,
                                  fr="precision demandee pour calculer la carte de taille des elements" ),
                    TYPE_ESTI=SIMP(statut='f',typ='TXM',into=("ERRE_ELEM_SIGM","ERZ1_ELEM_SIGM","ERZ2_ELEM_SIGM",
                                                              "QIRE_ELEM_SIGM","QIZ1_ELEM_SIGM","QIZ2_ELEM_SIGM",),
                                   fr="choix de l'estimateur d'erreur"),),


               b_extr = BLOC( condition = "OPTION in ('EXTR_ELNO_VARI','EXTR_ELGA_VARI')",
                             NOM_VARI =SIMP(statut='o',typ='TXM',min= 1,max=1,fr="nom de la variable  extraire",
                         into=("DPORO","DRHOLQ","DPVP","SATLIQ","EVP","IND_ETA","D","IND_END","TEMP_MAX","GAMP","PCR",
                               "SEUIL_HYD","IND_HYD","PCOHE","COMP_ROC","SEUIL_ISO","ANG_DEV","X11","X22","X33","X12","X13","X23",
                               "DIST_DEV","DEV_SUR_CRIT","DIST_ISO","NB_ITER","ARRET","NB_REDE","SIGNE",
                               "RDEV_1","RDEV_2","RDEV_3","RISO","EPSIVPLA","IND_1","IND_2","IND_3","IND_4",),),
                            ),
               EXCIT           =FACT(statut='f',max='**',
                                      regles=(EXCLUS('FONC_MULT','FONC_MULT_C','COEF_MULT','COEF_MULT_C'),),
                    CHARGE          =SIMP(statut='o',typ=char_meca ),
                    FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                    FONC_MULT_C     =SIMP(statut='f',typ=fonction_c),
                    COEF_MULT       =SIMP(statut='f',typ='R'),
                    COEF_MULT_C     =SIMP(statut='f',typ='C'),
                    PHAS_DEG        =SIMP(statut='f',typ='R'),
                    PUIS_PULS       =SIMP(statut='f',typ='I'),
                    TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE",into=("FIXE",),),),
                         ),

          b_sigm_massif =BLOC( condition = "TYPE_OPTION == 'SIGM_MASSIF'",
                                      fr="options de contraintes non lin 2D et 3D",
               OPTION =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                              #  contraintes
                           into=( "SIEF_ELNO_ELGA",),),
                            ),

          b_sigm_struct =BLOC( condition = "TYPE_OPTION == 'SIGM_STRUCT'",
                                       fr="options de contraintes non lin poutres, coques",
               OPTION =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                              #  contraintes
                           into=( "SIEF_ELNO_ELGA","EFGE_ELNO_CART","SIGM_ELNO_TUYO","SIGM_ELNO_COQU",
                           "SIGM_ELNO_SIEF","SIPO_ELNO_SIEF",),),
                             ),

          b_epsi         =BLOC( condition = "TYPE_OPTION=='EPSI'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=( "EPSI_ELNO_DEPL","EPSI_ELGA_DEPL","EPSG_ELNO_DEPL","EPSG_ELGA_DEPL",
                                 "EPME_ELNO_DEPL","EPME_ELGA_DEPL","EPMG_ELNO_DEPL","EPMG_ELGA_DEPL",
                                 "EPSP_ELNO","EPSP_ELGA","DEGE_ELNO_DEPL","EPVC_ELNO","EPVC_ELGA",
                                 "EPFD_ELNO","EPFD_ELGA","EPFP_ELNO","EPFP_ELGA"),
                                 ),
               EXCIT           =FACT(statut='f',max='**',fr="charge contenant les temperatures",
                    CHARGE          =SIMP(statut='o',typ=(char_meca,char_ther,char_acou) ),),
                                 ),
         b_epstuyo       =BLOC( condition = "OPTION == 'EPSI_ELNO_TUYO' or \
                                  (type(OPTION)==type(()) and  'EPSI_ELNO_TUYO' in OPTION) ",
              EXCIT           =FACT(statut='f',max='**',fr="charge contenant les temperatures",
                    CHARGE          =SIMP(statut='o',typ=(char_meca,char_ther,char_acou) ),),
                               ),

          b_vari         =BLOC( condition = "TYPE_OPTION=='VARI'",
                                       fr="Calcul et extraction des variables internes",
                   OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                                   into=("VARI_ELNO_ELGA","VARI_ELNO_TUYO","VARI_ELNO_COQU",
                                         "EXTR_ELGA_VARI","EXTR_ELNO_VARI"),
                                 ),
          b_extr         =BLOC( condition = "OPTION in ('EXTR_ELNO_VARI','EXTR_ELGA_VARI')",
                   NOM_VARI =SIMP(statut='o',typ='TXM',min= 1,max=1,fr="nom de la variable  extraire",
                         into=("DPORO","DRHOLQ","DPVP","SATLIQ","EVP","IND_ETA","D","IND_END","TEMP_MAX","GAMP","PCR",
                               "SEUIL_HYD","IND_HYD","PCOHE","COMP_ROC","SEUIL_ISO","ANG_DEV","X11","X22","X33","X12","X13","X23",
                               "DIST_DEV","DEV_SUR_CRIT","DIST_ISO","NB_ITER","ARRET","NB_REDE","SIGNE",
                               "RDEV_1","RDEV_2","RDEV_3","RISO","EPSIVPLA","IND_1","IND_2","IND_3","IND_4"),),
                            ),
                           ),

          b_ener         =BLOC( condition = "TYPE_OPTION=='ENER'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("ETOT_ELGA","ETOT_ELNO_ELGA","ETOT_ELEM","ENEL_ELGA","ENEL_ELNO_ELGA",),
                                 ),
               EXCIT           =FACT(statut='f',max='**',fr="charge contenant les temperatures",
                    CHARGE          =SIMP(statut='o',typ=(char_meca,char_ther,char_acou) ),),
                                 ),

          b_crit         =BLOC( condition = "TYPE_OPTION=='CRIT'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("EQUI_ELNO_SIGM","EQUI_ELGA_SIGM",
                                 "EQUI_ELNO_EPSI","EQUI_ELGA_EPSI","EQUI_ELNO_EPME","EQUI_ELGA_EPME",
                                 "ENDO_ELNO_SIGA","ENDO_ELNO_SINO","CRIT_ELNO_RUPT",
                                 "ENDO_ELGA","ENDO_ELNO_ELGA",
                                 "PMPB_ELNO_SIEF","PMPB_ELGA_SIEF","SIEQ_ELNO_TUYO","EPEQ_ELNO_TUYO",
                                 ) ),
                                 ),

          b_autres         =BLOC( condition = "TYPE_OPTION=='AUTRES'",
                  OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("VALE_NCOU_MAXI",) ),
               b_maxi    =BLOC( condition = "OPTION=='VALE_NCOU_MAXI' or \
                                (type(OPTION)==type(()) and 'VALE_NCOU_MAXI' in OPTION)",
                    NOM_CHAM  =SIMP(statut='o',typ='TXM',fr="Nom du champ pour VALE_NCOU_MAXI" ),
                    NOM_CMP   =SIMP(statut='o',typ='TXM',fr="Nom de la composante pour VALE_NCOU_MAXI"),),
                                 ),

          b_indi_erreur         =BLOC( condition = "TYPE_OPTION=='INDI_ERREUR'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',defaut="ERRE_ELEM_SIGM",
                           into=("ERRE_ELEM_SIGM","ERRE_ELNO_ELEM","ERZ1_ELEM_SIGM","ERZ2_ELEM_SIGM",
                                 "DCHA_ELNO_SIGM","DCHA_ELGA_SIGM","RADI_ELNO_SIGM","RADI_ELGA_SIGM",
                                 "QIRE_ELEM_SIGM","QIRE_ELNO_ELEM","QIZ1_ELEM_SIGM","QIZ2_ELEM_SIGM",
                                 "SING_ELEM","SING_ELNO_ELEM",) ),

               b_erre_qi =BLOC(condition = "OPTION in ('QIRE_ELEM_SIGM','QIZ1_ELEM_SIGM','QIZ2_ELEM_SIGM') or \
                                        (type(OPTION)==type(()) and 'QIRE_ELEM_SIGM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ1_ELEM_SIGM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ2_ELEM_SIGM' in OPTION)",
                RESU_DUAL    =SIMP(statut='o',typ=(evol_elas,evol_noli),fr="resultat du probleme dual")),

               b_sing =BLOC(condition= "OPTION == 'SING_ELEM' or \
                               (type(OPTION)==type(()) and  'SING_ELEM' in OPTION)",
                    PREC_ERR=SIMP(statut='o',typ='R',val_min= 0.,
                                  fr="precision demandee pour calculer la carte de taille des elements" ),
                    TYPE_ESTI=SIMP(statut='f',typ='TXM',into=("ERRE_ELEM_SIGM","ERZ1_ELEM_SIGM","ERZ2_ELEM_SIGM",
                                                              "QIRE_ELEM_SIGM","QIZ1_ELEM_SIGM","QIZ2_ELEM_SIGM",),
                                   fr="choix de l'estimateur d'erreur"),),

               b_indic = BLOC( condition ="OPTION in ('DCHA_ELNO_SIGM','DCHA_ELGA_SIGM','RADI_ELNO_SIGM','RADI_ELGA_SIGM') or\
                                            (type(OPTION)==type(()) and 'DCHA_ELNO_SIGM' in OPTION) or\
                                            (type(OPTION)==type(()) and 'DCHA_ELGA_SIGM' in OPTION) or\
                                            (type(OPTION)==type(()) and 'RADI_ELNO_SIGM' in OPTION) or\
                                            (type(OPTION)==type(()) and 'RADI_ELGA_SIGM' in OPTION) ",
                    NORME =SIMP(statut='f',typ='TXM',defaut="VMIS",
                                 into=("VMIS","TOTAL","VMIS_CINE","TOTAL_CINE") ),
                                 ),
                                 ),
                                 ),
#          fin bloc evol_noli

#           thermique : evol_ther, fourier_ther
     b_ther          =BLOC( condition = "AsType(RESULTAT) in (evol_ther,fourier_ther,)" ,fr="options thermiques",
          OPTION          =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("DEUL_ELGA_TEMP","DETE_ELNO_DLTE","FLUX_ELGA_TEMP","FLUX_ELNO_TEMP",
                                  "HYDR_ELNO_ELGA","DURT_ELGA_META","DURT_ELNO_META",
                                  "SOUR_ELGA_ELEC","ERRE_ELEM_TEMP","ERRE_ELNO_ELEM",),),
               EXCIT           =FACT(statut='f',max='**',
                    regles=(EXCLUS('FONC_MULT','FONC_MULT_C','COEF_MULT','COEF_MULT_C'),),
                    CHARGE          =SIMP(statut='o',typ=char_ther ),
                    FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                    FONC_MULT_C     =SIMP(statut='f',typ=fonction_c),
                    COEF_MULT       =SIMP(statut='f',typ='R'),
                    COEF_MULT_C     =SIMP(statut='f',typ='C'),
                    PHAS_DEG        =SIMP(statut='f',typ='R'),
                    PUIS_PULS       =SIMP(statut='f',typ='I'),
                    TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE",into=("FIXE",),),
                                     ),
                                 ),

#    acoustique
     b_acou          =BLOC( condition = "AsType(RESULTAT) in (acou_harmo,mode_acou,)",fr="options acoustiques",
          OPTION          =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("PRES_ELNO_DBEL","PRES_ELNO_REEL","PRES_ELNO_IMAG",
                                 "INTE_ELNO_ACTI","INTE_ELNO_REAC",
                                 ),),
          EXCIT           =FACT(statut='f',max='**',
                regles=(EXCLUS('FONC_MULT','FONC_MULT_C','COEF_MULT','COEF_MULT_C'),),
                CHARGE          =SIMP(statut='o',typ=char_acou ),
                FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                FONC_MULT_C     =SIMP(statut='f',typ=fonction_c),
                COEF_MULT       =SIMP(statut='f',typ='R'),
                COEF_MULT_C     =SIMP(statut='f',typ='C'),
                PHAS_DEG        =SIMP(statut='f',typ='R'),
                PUIS_PULS       =SIMP(statut='f',typ='I'),
                TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE",into=("FIXE",),),),
                                 ),


#    Choix du solveur (utilis actuellement pour estimateur d'erreur ZZ1) :
     SOLVEUR         =FACT(statut='d', fr="Mthode de rsolution des systmes linaires",
     METHODE         =SIMP(statut='f',typ='TXM',defaut="MULT_FRONT",into=("LDLT","MUMPS","MULT_FRONT",) ),


       b_ldlt          =BLOC(condition = "METHODE == 'LDLT' ",fr="Paramtres de la mthode LDLT",
         RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("RCMK","SANS") ),
         NPREC           =SIMP(statut='f',typ='I',defaut=8),
         STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
       ),

       b_mult_front    =BLOC(condition = "METHODE == 'MULT_FRONT' ",fr="Paramtres de la mthode multi frontale",
         RENUM           =SIMP(statut='f',typ='TXM',defaut="METIS",into=("MD","MDA","METIS") ),
         NPREC           =SIMP(statut='f',typ='I',defaut=8),
         STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
       ),


       b_mumps        =BLOC(condition = "METHODE == 'MUMPS' ",fr="Paramtres de la mthode MUMPS",
         TYPE_RESOL      =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("NONSYM","SYMGEN","SYMDEF","AUTO")),
         PRETRAITEMENTS  =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO")),
         RENUM           =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("AMD","AMF","PORD","METIS","QAMD","AUTO")),
         ELIM_LAGR2      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
         PCENT_PIVOT     =SIMP(statut='f',typ='I',defaut=10,),
         RESI_RELA       =SIMP(statut='f',typ='R',defaut=-1.0,),
         PARALLELISME    =SIMP(statut='f',typ='TXM',defaut="CENTRALISE",
                               into=("CENTRALISE","DISTRIBUE_MC","DISTRIBUE_MD","DISTRIBUE_SD")),
         PARTITION       =SIMP(statut='f',typ=sd_feti_sdaster),
         CHARGE_PROC0_MA =SIMP(statut='f',typ='I',defaut=100,val_min=0),
         CHARGE_PROC0_SD =SIMP(statut='f',typ='I',defaut=0,val_min=0),
         OUT_OF_CORE     =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
         ),
     ),



     SENSIBILITE     =SIMP(statut='f',typ=(para_sensi,theta_geom),validators=NoRepeat(),max='**',
                           fr="Liste des paramtres de sensibilit.",
                           ang="List of sensitivity parameters"),
     INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
     TITRE           =SIMP(statut='f',typ='TXM',max='**'),
) ;
#& MODIF COMMANDE  DATE 03/02/2010   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2008  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================

# RESPONSABLE NISTOR I.NISTOR

from Macro.calc_essai_ops import calc_essai_ops

def calc_essai_prod(self,RESU_IDENTIFICATION, RESU_MODIFSTRU,**args):

    if RESU_IDENTIFICATION != None:
        for res in RESU_IDENTIFICATION:
            self.type_sdprod(res['TABLE'],table_fonction)


    MTYPES = {
        'MODELE'    : modele_sdaster,
        'MODE_MECA' : mode_meca,
        'NUME_DDL'  : nume_ddl_sdaster,
        'MAILLAGE'  : maillage_sdaster,
        'MASS_MECA' : matr_asse_depl_r,
        'RIGI_MECA' : matr_asse_depl_r,
        'AMOR_MECA' : matr_asse_depl_r,
        'MACR_ELEM' : macr_elem_stat,
        'PROJ_MESU' : mode_gene,
        'BASE_ES' : base_modale,
        'BASE_LMME' : mode_meca,
        'MODE_STA' : mode_stat_forc,
              }
    if RESU_MODIFSTRU != None:
        for res in RESU_MODIFSTRU:
            for mc, typ in MTYPES.items():
                if res[mc]:
                    self.type_sdprod(res[mc], typ)
    return None


CALC_ESSAI = MACRO(nom       = 'CALC_ESSAI',
                   op        = calc_essai_ops,
                   sd_prod   = calc_essai_prod,
                   reentrant = 'n',
                   UIinfo    = {"groupes":("Outils mtier",)},
                   fr        = "Outil de post-traitement interactif pour Meidee ",
                   INTERACTIF  = SIMP( statut='f',typ='TXM',into=('OUI','NON'),defaut='OUI' ),
                   RESU_IDENTIFICATION = FACT( statut='f',max='**',
                                               TABLE = SIMP(statut='f', typ=CO),
                                             ),
                   RESU_MODIFSTRU = FACT( statut='f', max=1,
                                          MODELE=SIMP(statut='f',typ=CO,defaut=None),
                                          MODE_MECA=SIMP(statut='f',typ=CO,defaut=None),
                                          MAILLAGE=SIMP(statut='f',typ=CO,defaut=None),
                                          NUME_DDL=SIMP(statut='f',typ=CO,defaut=None),
                                          MASS_MECA=SIMP(statut='f',typ=CO,defaut=None),
                                          RIGI_MECA=SIMP(statut='f',typ=CO,defaut=None),
                                          AMOR_MECA=SIMP(statut='f',typ=CO,defaut=None),
                                          MACR_ELEM=SIMP(statut='f',typ=CO,defaut=None),
                                          PROJ_MESU=SIMP(statut='f',typ=CO,defaut=None),
                                          BASE_ES=SIMP(statut='f',typ=CO,defaut=None),
                                          BASE_LMME=SIMP(statut='f',typ=CO,defaut=None),
                                          MODE_STA=SIMP(statut='f',typ=CO,defaut=None),
                                         ),

                   b_inter    = BLOC( condition="INTERACTIF=='NON'",

                             EXPANSION        = FACT( statut='f',max='**',
                                                      CALCUL           = SIMP(statut='o',typ=mode_meca),
                                                      NUME_MODE_CALCUL = SIMP(statut='f',typ='I',validators=NoRepeat(),
                                                                              max='**',defaut=0),
                                                      MESURE           = SIMP(statut='o',typ=mode_meca),
                                                      NUME_MODE_MESURE = SIMP(statut='f',typ='I',validators=NoRepeat(),
                                                                              max='**',defaut=0),
                                                      RESOLUTION       = SIMP(statut='f',typ='TXM',defaut='SVD',into=('SVD','LU')),
                                                      b_reso           = BLOC(condition = "RESOLUTION=='SVD'",
                                                                              EPS = SIMP(statut='f',typ='R', defaut = 0.)
                                                                       )
                                                    ),
                             IDENTIFICATION   = FACT( statut='f',max='**',   
                                                      ALPHA   = SIMP(statut='f',typ='R', defaut = 0.),
                                                      EPS     = SIMP(statut='f',typ='R', defaut = 0.),
                                                      OBSERVABILITE  = SIMP(statut='o',typ=(mode_meca, base_modale)),
                                                      COMMANDABILITE = SIMP(statut='o',typ=(mode_meca, base_modale)),
                                                      INTE_SPEC      = SIMP(statut='o',typ=table_sdaster),
                                                      RESU_EXPANSION = SIMP(statut='f',typ='TXM',defaut='NON',into=('OUI','NON')),
                                                      BASE           = SIMP(statut='o',typ=mode_meca),
                                                     ),
                             MODIFSTRUCT = FACT( statut='f', max=1,
                                                 MESURE = SIMP(statut='o', typ=mode_meca),
                                                 MODELE_SUP = SIMP(statut='o', typ=modele_sdaster),
                                                 MATR_RIGI = SIMP(statut='o', typ=matr_asse_depl_r),
                                                 RESOLUTION = SIMP(statut='f', typ='TXM',
                                                               into=('ES', 'LMME'), defaut='ES'),
                                                 b_resol = BLOC( condition = "RESOLUTION=='LMME'",
                                                                 MATR_MASS = SIMP(statut='o', typ=matr_asse_depl_r),
                                                                ),
                                                 NUME_MODE_MESU   = SIMP(statut='o', typ='I',max='**'),
                                                 NUME_MODE_CALCUL = SIMP(statut='o', typ='I',max='**'),
                                                 MODELE_MODIF = SIMP(statut='o', typ=modele_sdaster),
                                               ),

                             # Si on realise une modification structurale, on donne les DDL capteurs et interface
                             b_modif   = BLOC( condition="MODIFSTRUCT!=None",
                                   GROUP_NO_CAPTEURS  = FACT( statut='f', max='**',
                                                              GROUP_NO = SIMP(statut='o',typ='TXM', max='**'),
                                                              NOM_CMP  = SIMP(statut='o',typ='TXM', max='**'),
                                                            ),
                                   GROUP_NO_EXTERIEUR = FACT( statut='f', max='**',
                                                              GROUP_NO = SIMP(statut='o',typ='TXM', max='**'),
                                                              NOM_CMP  = SIMP(statut='o',typ='TXM', max='**'),
                                                            ),
                                               ),
                                          ),
                        );

#& MODIF COMMANDE  DATE 28/04/2009   AUTEUR ASSIRE A.ASSIRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2008  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ASSIRE A.ASSIRE
from Macro.calc_europlexus_ops import calc_europlexus_ops

import types

def calc_europlexus_prod(self,COURBE=None,**args):
  if COURBE is not None:
      self.type_sdprod(args['TABLE_COURBE'],table_sdaster) 
  return evol_noli

CALC_EUROPLEXUS = MACRO(nom="CALC_EUROPLEXUS",op=calc_europlexus_ops,sd_prod=calc_europlexus_prod,
        reentrant='n',
        #UIinfo={"groupes":("Dynamique rapide",)},
        fr="Chainage Code_Aster-Europlexus",

        LOGICIEL = SIMP(statut='f', typ='TXM', defaut='/home/europlex/EPXD/EUROPLEXUS_GESTION/runepx_d'),

        MODELE     = SIMP(statut='o',typ=modele_sdaster),
        CARA_ELEM  = SIMP(statut='o',typ=cara_elem),

        FONC_PARASOL = FACT(statut='f',
           NFKT       = SIMP(statut='f',typ=(fonction_sdaster,)),
           NFKR       = SIMP(statut='f',typ=(fonction_sdaster,)),
           GROUP_MA   = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           ),


        CHAM_MATER = SIMP(statut='o',typ=cham_mater),

        EXCIT      = FACT(statut='o',max='**',
           CHARGE         = SIMP(statut='o',typ=(char_meca,)),
           FONC_MULT      = SIMP(statut='o',typ=(fonction_sdaster,)),
          ),

        DIME = FACT(statut='o', regles=(AU_MOINS_UN('UNITE_DIME','Q4GS','FORCE',
                                                    'PT6L','ZONE','POUT','ECRO',
                                                    'APPU','BLOQ','PRESS','PMAT',
                                                    'DKT3','DEPL','FNOM','TABLE','FTAB',
                                                    'MTTI','NEPE','LIAI',), ),                   
           UNITE_DIME=SIMP(statut='f',typ='I'),

           Q4GS  = SIMP(statut='f',typ='I'),
           FORCE = SIMP(statut='f',typ='I'),
           PT6L  = SIMP(statut='f',typ='I'),
           ZONE  = SIMP(statut='f',typ='I'),
           POUT  = SIMP(statut='f',typ='I'),
           ECRO  = SIMP(statut='f',typ='I'),
           APPU  = SIMP(statut='f',typ='I'),
           BLOQ  = SIMP(statut='f',typ='I'),
           PRESS = SIMP(statut='f',typ='I',min=2,max=2,),
           PMAT  = SIMP(statut='f',typ='I'),
           DKT3  = SIMP(statut='f',typ='I'),
           DEPL  = SIMP(statut='f',typ='I'),
           FNOM  = SIMP(statut='f',typ='I'),
           TABLE = SIMP(statut='f',typ='I',min=2,max=2,),
           FTAB  = SIMP(statut='f',typ='I'),
           MTTI  = SIMP(statut='f',typ='I'),
           NEPE  = SIMP(statut='f',typ='I'),
           LIAI  = SIMP(statut='f',typ='I'),
             ),

        CALCUL = FACT(statut='o',
           TYPE_DISCRETISATION  = SIMP(statut='o',typ='TXM',defaut='AUTO',into=('AUTO','UTIL')),
           INST_FIN             = SIMP(statut='o',typ='R'),
           INST_INIT            = SIMP(statut='o',typ='R'),
           NMAX                 = SIMP(statut='f',typ='R'),

           b_auto =BLOC( condition = "TYPE_DISCRETISATION=='AUTO'",
              CSTAB  = SIMP(statut='o',typ='R',max='**',defaut=0.3),
#              DTMAX  = SIMP(statut='f',typ='R',max='**'),
                       ),

           b_util =BLOC( condition = "TYPE_DISCRETISATION=='UTIL'",
              PASFIX   = SIMP(statut='o',typ='R',max='**'),
                       ),
           ),


        OBSERVATION     =FACT(statut='f',max='**',
           SUIVI_DDL       = SIMP(statut='o',typ='TXM',defaut="OUI",max=1,into=("OUI","NON")),
        b_suivi          =BLOC(condition = "SUIVI_DDL == 'OUI' ",
                               regles=( AU_MOINS_UN('PAS_NBRE','PAS_INST',), 
                                        EXCLUS('PAS_NBRE','PAS_INST',), 
                                        EXCLUS('GROUP_NO','TOUT_GROUP_NO',), 
                                        EXCLUS('GROUP_MA','TOUT_GROUP_MA',), ),
           NOM_CHAM        = SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**', defaut = ('DEPL',), 
                                  into=('DEPL','VITE','ACCE','SIEF_ELGA','EPSI_ELGA','VARI_ELGA'),),
           PAS_INST        = SIMP(statut='f',typ='R'),
           PAS_NBRE        = SIMP(statut='f',typ='I'),
           GROUP_NO        = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           GROUP_MA        = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           TOUT_GROUP_NO   = SIMP(statut='f',typ='TXM',into=('OUI',),),
           TOUT_GROUP_MA   = SIMP(statut='f',typ='TXM',into=('OUI',),),
                             ),
        ),


        ARCHIVAGE        =FACT(statut='f', regles=( AU_MOINS_UN('PAS_NBRE','PAS_INST',), EXCLUS('PAS_NBRE','PAS_INST',), ),
           PAS_INST     = SIMP(statut='f',typ='R'),
           PAS_NBRE     = SIMP(statut='f',typ='I'),
           CONT_GENER   = SIMP(statut='o',typ='TXM',defaut="NON",max=1,into=("OUI","NON")),
                             ),                
        COURBE  =  FACT(statut='f',max='**', regles=(EXCLUS('GROUP_NO','GROUP_MA')),
           UNITE_ALIT = SIMP(statut='f',typ='I'),
            NOM_CHAM   = SIMP(statut='f',typ='TXM'),
            NOM_CMP    = SIMP(statut='f',typ='TXM'),
#             NOEUD      = SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**'),
#             MAILLE     = SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**'),
            GROUP_NO   = SIMP(statut='f',typ=grno,validators=NoRepeat(),max=1),
            GROUP_MA   = SIMP(statut='f',typ=grma,validators=NoRepeat(),max=1),

            b_maille = BLOC(condition = "GROUP_MA != None", regles=(AU_MOINS_UN('NUM_GAUSS')),
              NUM_GAUSS = SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),),
         ),
        b_courbe = BLOC(condition = "COURBE != None",
                        regles=(AU_MOINS_UN('PAS_NBRE_COURBE','PAS_INST_COURBE',),
                                AU_MOINS_UN('TABLE_COURBE',)),          
          PAS_INST_COURBE      = SIMP(statut='f',typ='R'),
          PAS_NBRE_COURBE       = SIMP(statut='f',typ='I'),
                  TABLE_COURBE      = SIMP(statut='f', typ=CO),
          ),
        DOMAINES = FACT(statut='f',max='**',
             GROUP_MA = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             IDENTIFIANT =  SIMP(statut='f',typ='I'),), 
        INTERFACES = FACT(statut='f',max='**',
             GROUP_MA_1 = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             GROUP_MA_2 = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             TOLE        =  SIMP(statut='f',typ='R'),
             IDENT_DOMAINE_1  = SIMP(statut='f',typ='I'), 
             IDENT_DOMAINE_2  = SIMP(statut='f',typ='I'),),

         INFO            =SIMP(statut='f',typ='I',defaut=1,into=( 1, 2 ) ),
        ) ;
#& MODIF COMMANDE  DATE 12/11/2009   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE ANGLES J.ANGLES
def calc_fatigue_prod(TYPE_CALCUL,OPTION,**args):
  if TYPE_CALCUL == "CUMUL_DOMMAGE" : return cham_elem
  if TYPE_CALCUL == "FATIGUE_MULTI" and OPTION == "DOMA_ELGA": return cham_elem
  if TYPE_CALCUL == "FATIGUE_MULTI" and OPTION == "DOMA_NOEUD": return cham_no_sdaster
  raise AsException("type de calcul non prevu")

CALC_FATIGUE=OPER(nom="CALC_FATIGUE",op= 151,sd_prod=calc_fatigue_prod,reentrant='n',
                  fr="Calculer un champ de dommage de fatigue subit par une structure et dterminer le plan critique"
                      +" dans lequel le cisaillement est maximal.",
            UIinfo={"groupes":("Post traitements",)},

         TYPE_CALCUL = SIMP(statut='o',typ='TXM',
                               into=("CUMUL_DOMMAGE","FATIGUE_MULTI",) ),

         b_cumul_domma   =BLOC(condition = "TYPE_CALCUL == 'CUMUL_DOMMAGE'",
                               fr="Calcul d un champ de dommage subi par une structure.",
           regles=(PRESENT_PRESENT('DOMMAGE','MATER', ),),
           OPTION          =SIMP(statut='o',typ='TXM',
                                 into=("DOMA_ELNO_SIGM","DOMA_ELGA_SIGM",
                                       "DOMA_ELNO_EPSI","DOMA_ELGA_EPSI",
                                       "DOMA_ELNO_EPME","DOMA_ELGA_EPME") ),
           
             b_sigm   =BLOC(condition = "OPTION == 'DOMA_ELNO_SIGM' or OPTION == 'DOMA_ELGA_SIGM'",
                               fr="Calcul a partir d un champ de contraintes.",
               HISTOIRE        =FACT(statut='o',
               RESULTAT        =SIMP(statut='o',typ=(evol_elas,dyna_trans,
                                                   evol_noli) ),
               EQUI_GD         =SIMP(statut='f',typ='TXM',defaut="VMIS_SG",
                                 into=("VMIS_SG",) ),
                                   ),
                           ),
             b_epsi   =BLOC(condition = "OPTION != 'DOMA_ELNO_SIGM' and OPTION != 'DOMA_ELGA_SIGM'",
                               fr="Calcul a partir d un champ de dformations.",
               HISTOIRE        =FACT(statut='o',
               RESULTAT        =SIMP(statut='o',typ=(evol_elas,dyna_trans,
                                                   evol_noli) ),
               EQUI_GD         =SIMP(statut='o',typ='TXM',defaut="INVA_2_SG",
                                 into=("INVA_2_SG",) ),
                                    ),
                           ),
           DOMMAGE         =SIMP(statut='o',typ='TXM',
                               into=("WOHLER","MANSON_COFFIN","TAHERI_MANSON",
                                     "TAHERI_MIXTE",) ),
           MATER           =SIMP(statut='o',typ=(mater_sdaster) ),
           TAHERI_NAPPE    =SIMP(statut='f',typ=(nappe_sdaster,formule) ),
           TAHERI_FONC     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         b_fatigue_multi   =BLOC(condition = "TYPE_CALCUL == 'FATIGUE_MULTI'",
                                 fr="Plan critique dans le cas de la fatigue multiaxiale  grand nombre de cycles.",
           TYPE_CHARGE   =SIMP(statut='o',typ='TXM',into=("PERIODIQUE","NON_PERIODIQUE") ),
           OPTION        =SIMP(statut='o',typ='TXM',into=("DOMA_ELGA","DOMA_NOEUD") ),
           RESULTAT      =SIMP(statut='o',typ=(evol_elas, evol_noli) ),
           CHAM_MATER    =SIMP(statut='o',typ=(cham_mater) ),
           MAILLAGE      =SIMP(statut='o',typ=maillage_sdaster ),
           regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),),
           GROUP_MA      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**' ),
           MAILLE        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**' ),
           GROUP_NO      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**' ),
           NOEUD         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**' ),
           COEF_PREECROU =SIMP(statut='f',typ='R',defaut= 1.0E+0),
           b_period       =BLOC(condition = "TYPE_CHARGE == 'PERIODIQUE'",
               CRITERE       =SIMP(statut='o',typ='TXM',into=("MATAKE_MODI_AC","DANG_VAN_MODI_AC","VMIS_TRESCA") ),
               b_fati_p  =BLOC(condition = "(CRITERE == 'MATAKE_MODI_AC' or CRITERE == 'DANG_VAN_MODI_AC')",
                   METHODE       =SIMP(statut='o',typ='TXM',into=("CERCLE_EXACT",) ),
               ),
           ),
           b_non_period   =BLOC(condition = "TYPE_CHARGE == 'NON_PERIODIQUE'",
               CRITERE       =SIMP(statut='o',typ='TXM',
                                   into=("MATAKE_MODI_AV","DANG_VAN_MODI_AV","FATESOCI_MODI_AV","VMIS_TRESCA") ),
               b_fati_np  =BLOC(condition = 
                               "(CRITERE == 'MATAKE_MODI_AV' or CRITERE == 'DANG_VAN_MODI_AV' or CRITERE == 'FATESOCI_MODI_AV')",
                   PROJECTION    =SIMP(statut='o',typ='TXM',into=("UN_AXE", "DEUX_AXES") ),
                   DELTA_OSCI    =SIMP(statut='f',typ='R',defaut= 0.0E+0),  
               ),
           ),
         ),

         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE ADOBES A.ADOBES
CALC_FLUI_STRU=OPER(nom="CALC_FLUI_STRU",op= 144,sd_prod=melasflu_sdaster,
                    reentrant='n',
                    fr="Calculer les paramtres modaux d'une structure soumise  un coulement",
            UIinfo={"groupes":("Matrices/vecteurs",)},
         VITE_FLUI       =FACT(statut='f',
                               fr="Dfinir la plage de vitesse fluide tudie",
           VITE_MIN        =SIMP(statut='f',typ='R' ),
           VITE_MAX        =SIMP(statut='f',typ='R' ),
           NB_POIN         =SIMP(statut='f',typ='I' ),
         ),
         BASE_MODALE     =FACT(statut='o',
                               
           regles=(AU_MOINS_UN('AMOR_REDUIT','AMOR_UNIF','AMOR_REDUIT_CONN'),),
           MODE_MECA       =SIMP(statut='o',typ=mode_meca ),
           NUME_ORDRE      =SIMP(statut='f',typ='I',max='**'),
           AMOR_REDUIT     =SIMP(statut='f',typ='R',max='**',val_min=0.E+00),
           AMOR_UNIF       =SIMP(statut='f',typ='R',val_min=0.E+00 ),
           AMOR_REDUIT_CONN=SIMP(statut='f',typ='R',max='**',val_min=0.E+00),
         ),
         TYPE_FLUI_STRU  =SIMP(statut='o',typ=type_flui_stru ),
         IMPRESSION      =FACT(statut='f',
                               fr="Choix des informations  imprimer dans le fichier RESULTAT",
           PARA_COUPLAGE   =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           DEFORMEE        =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS
def calc_fonc_interp_prod(FONCTION, NOM_PARA_FONC, **args):
   if   AsType(FONCTION) == nappe_sdaster:
      return nappe_sdaster
   elif AsType(FONCTION) == fonction_sdaster:
      return fonction_sdaster
   elif AsType(FONCTION) == fonction_c:
      return fonction_c
   elif AsType(FONCTION) == formule_c:
      return fonction_c
   elif AsType(FONCTION) == formule:
      if NOM_PARA_FONC != None:
         return nappe_sdaster
      return fonction_sdaster
   elif AsType(FONCTION) == para_sensi:
      return para_sensi
   raise AsException("type de concept resultat non prevu")

CALC_FONC_INTERP=OPER(nom="CALC_FONC_INTERP",op= 134,sd_prod=calc_fonc_interp_prod,
                      docu="U4.32.01-e",reentrant='n',
           fr="Dfinit une fonction (ou une nappe)  partir d'une fonction FORMULE  1 ou 2 variables",
           UIinfo={"groupes":("Fonction",)},
         regles=(UN_PARMI('VALE_PARA','LIST_PARA'),),
         FONCTION        =SIMP(statut='o',typ=(formule,fonction_sdaster,nappe_sdaster,fonction_c) ),
         VALE_PARA       =SIMP(statut='f',typ='R',max='**'),
         LIST_PARA       =SIMP(statut='f',typ=listr8_sdaster ),
         NOM_RESU        =SIMP(statut='f',typ='TXM'),
         NOM_PARA        =SIMP(statut='f',typ='TXM'),
         INTERPOL        =SIMP(statut='f',typ='TXM',max=2,into=("NON","LIN","LOG") ),
         PROL_DROITE     =SIMP(statut='f',typ='TXM',into=("EXCLU","CONSTANT","LINEAIRE") ),
         PROL_GAUCHE     =SIMP(statut='f',typ='TXM',into=("EXCLU","CONSTANT","LINEAIRE") ),
         NOM_PARA_FONC   =SIMP(statut='f',typ='TXM'),
         b_eval_nappe    =BLOC(condition = "NOM_PARA_FONC != None",             
            regles=(UN_PARMI('VALE_PARA_FONC','LIST_PARA_FONC'),),
            VALE_PARA_FONC  =SIMP(statut='f',typ='R',max='**'),
            LIST_PARA_FONC  =SIMP(statut='f',typ=listr8_sdaster ),
            INTERPOL_FONC   =SIMP(statut='f',typ='TXM',max=2,into=("NON","LIN","LOG")),
            PROL_DROITE_FONC=SIMP(statut='f',typ='TXM',into=("EXCLU","CONSTANT","LINEAIRE") ),
            PROL_GAUCHE_FONC=SIMP(statut='f',typ='TXM',into=("EXCLU","CONSTANT","LINEAIRE") ),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2 ) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS
from Macro.calc_fonction_ops import calc_fonction_ops
def calc_fonction_prod(self,DERIVE,EXTRACTION,INTEGRE,INVERSE,COMB,COMB_C,
                       ENVELOPPE,FRACTILE,SPEC_OSCI,ASSE,FFT,COMPOSE,CORR_ACCE,PUISSANCE,
                       LISS_ENVELOP,ABS, **args):

   if (INTEGRE     != None): return fonction_sdaster
   if (DERIVE      != None): return fonction_sdaster
   if (INVERSE     != None): return fonction_sdaster
   if (COMB        != None): 
      type_vale=AsType(COMB[0]['FONCTION'])
      for mcfact in COMB :
          if(AsType(mcfact['FONCTION'])!=type_vale):
             raise AsException("CALC_FONCTION/COMB : pas de types htrognes nappe/fonction")
      return type_vale
   if (COMB_C      != None):
      vale=COMB_C[0]['FONCTION']
      if(AsType(vale) == nappe_sdaster):
         for mcfact in COMB_C[1:] :
             if(AsType(mcfact['FONCTION'])!=nappe_sdaster):
                raise AsException("CALC_FONCTION/COMB_C : pas de types htrognes nappe/fonction")
         return nappe_sdaster
      else:
         for mcfact in COMB_C :
             if(AsType(mcfact['FONCTION'])==nappe_sdaster):
                raise AsException("CALC_FONCTION/COMB_C : pas de types htrognes nappe/fonction")
         return fonction_c
   if (ENVELOPPE   != None): return AsType(ENVELOPPE[0]['FONCTION'])
   if (FRACTILE    != None): return AsType(FRACTILE[0] ['FONCTION'])
   if (EXTRACTION  != None): return fonction_sdaster
   if (SPEC_OSCI   != None): return nappe_sdaster
   if (COMPOSE     != None): return fonction_sdaster
   if (ASSE        != None): return fonction_sdaster
   if (FFT         != None):
      vale=FFT[0]['FONCTION']
      if (AsType(vale) == fonction_sdaster )  : return fonction_c
      if (AsType(vale) == fonction_c) : return fonction_sdaster
   if (CORR_ACCE   != None): return fonction_sdaster
   if (LISS_ENVELOP!= None): return nappe_sdaster
   if (PUISSANCE   != None): return AsType(PUISSANCE[0]['FONCTION'])
   if (ABS         != None): return fonction_sdaster
   raise AsException("type de concept resultat non prevu")

CALC_FONCTION=MACRO(nom="CALC_FONCTION",op=calc_fonction_ops,sd_prod=calc_fonction_prod
                    ,fr="Effectue des oprations mathmatiques sur des concepts de type fonction",
                     reentrant='n',
            UIinfo={"groupes":("Fonction",)},
         regles=(UN_PARMI('DERIVE','INTEGRE','SPEC_OSCI','COMB','COMB_C','ENVELOPPE',
                          'COMPOSE','EXTRACTION','ASSE','FFT','CORR_ACCE', 'PUISSANCE',
                          'LISS_ENVELOP','INVERSE','ABS','FRACTILE'),),
         FFT             =FACT(statut='f',fr="Transforme de Fourier ou de son inverse",
           FONCTION        =SIMP(statut='o',typ=(fonction_sdaster,fonction_c) ),
           METHODE         =SIMP(statut='f',typ='TXM',defaut="PROL_ZERO",into=("PROL_ZERO","TRONCATURE","COMPLET") ),
           b_syme          =BLOC ( condition = " AsType(FONCTION)==fonction_c ",
             SYME           =SIMP(statut='f',typ='TXM',into=('OUI','NON'),defaut='OUI' ),  
           ),
         ),
         DERIVE          =FACT(statut='f',fr="Drive d une fonction",
           METHODE         =SIMP(statut='f',typ='TXM',defaut="DIFF_CENTREE",into=("DIFF_CENTREE",) ),
           FONCTION        =SIMP(statut='o',typ=fonction_sdaster ),
         ),
         INTEGRE         =FACT(statut='f',fr="Intgrale d'une fonction",
           METHODE         =SIMP(statut='f',typ='TXM',defaut="TRAPEZE",into=("SIMPSON","TRAPEZE") ),
           FONCTION        =SIMP(statut='o',typ=fonction_sdaster),
           COEF            =SIMP(statut='f',typ='R',defaut= 0.E+0,fr="Valeur de la constante d intgration" ),
         ),
         LISS_ENVELOP    = FACT(statut='f',fr="Lissage d une enveloppe",
           NAPPE           =SIMP(statut='o',typ=nappe_sdaster ),
           FREQ_MIN        =SIMP(statut='f',typ='R',defaut =0.2),
           FREQ_MAX        =SIMP(statut='f',typ='R',defaut =35.5),
           ELARG           =SIMP(statut='f',typ='R',defaut =0.1 ),
           TOLE_LISS       =SIMP(statut='f',typ='R',defaut =0.25 ),
         ),
         SPEC_OSCI       =FACT(statut='f',fr="Spectre d'oscillateur",
           METHODE         =SIMP(statut='f',typ='TXM',defaut="NIGAM",into=("NIGAM",) ),
           FONCTION        =SIMP(statut='o',typ=fonction_sdaster ),
           AMOR_REDUIT     =SIMP(statut='f',typ='R',max='**'),
           LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster ),
           FREQ            =SIMP(statut='f',typ='R',max='**'),
           NORME           =SIMP(statut='o',typ='R',fr="Valeur de la norme du spectre d oscillateur" ),
           NATURE          =SIMP(statut='f',typ='TXM',defaut="ACCE",into=("DEPL","VITE","ACCE") ),
           NATURE_FONC     =SIMP(statut='f',typ='TXM',defaut="ACCE",into=("DEPL","VITE","ACCE") ),
         ),
         ABS             =FACT(statut='f',fr="Valeur absolue d'une fonction",
           FONCTION        =SIMP(statut='o',typ=fonction_sdaster,),
         ),
         COMB            =FACT(statut='f',max='**',fr="Combinaison linaire relle de fonctions",
           FONCTION        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster) ),
           COEF            =SIMP(statut='o',typ='R',fr="Coefficient rel de la combinaison linaire associe  la fonction" ),
         ),
         COMB_C          =FACT(statut='f',max='**',fr="Combinaison linaire complexe de fonctions",
           regles=(UN_PARMI('COEF_R','COEF_C'),),
           FONCTION        =SIMP(statut='o',typ=(fonction_sdaster,fonction_c,nappe_sdaster) ),
           COEF_R          =SIMP(statut='f',typ='R',fr="Coefficient rel de la combinaison linaire associe  la fonction" ),
           COEF_C          =SIMP(statut='f',typ='C',fr="Coefficient complexe de la combinaison linaire associe  la fonction" ),
         ),
         b_comb          =BLOC ( condition = " (COMB != None) or (COMB_C != None)",
             LIST_PARA      =SIMP(statut='f',typ=listr8_sdaster ),  
         ),
         COMPOSE         =FACT(statut='f',fr="Composition de deux fonctions FONC_RESU(FONC_PARA)",
           FONC_RESU       =SIMP(statut='o',typ=fonction_sdaster),
           FONC_PARA       =SIMP(statut='o',typ=fonction_sdaster),
         ),
         EXTRACTION      =FACT(statut='f',fr="Extraction sur une fonction complexe",
           FONCTION        =SIMP(statut='o',typ=fonction_c),
           PARTIE          =SIMP(statut='o',typ='TXM',into=("REEL","IMAG","MODULE","PHASE"),fr="Partie  extraire"),
         ),
         ENVELOPPE       =FACT(statut='f',fr="Enveloppe d une famille de fonctions",
           FONCTION        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster),max='**' ),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="SUP",into=("SUP","INF"),fr="Type de l enveloppe" ),
         ),
         FRACTILE        =FACT(statut='f',fr="Fractile d une famille de fonctions ou de nappes",
           FONCTION        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster),max='**' ),
           FRACT           =SIMP(statut='o',typ='R',defaut=1.,val_min=0.,val_max=1.,fr="Valeur du fractile" ),
         ),
         ASSE            =FACT(statut='f',fr="Concatenation de fonctions",
           FONCTION        =SIMP(statut='o',typ=fonction_sdaster,min=2,max=2 ),
           SURCHARGE       =SIMP(statut='f',typ='TXM',defaut="DROITE",into=("DROITE","GAUCHE")),
         ),
         CORR_ACCE       =FACT(statut='f',fr="Correction d un accelerogramme reel",
            CORR_DEPL       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
            FONCTION        =SIMP(statut='o',typ=fonction_sdaster ),
         ),
         PUISSANCE       =FACT(statut='f',fr="Fonction leve  une puissance",
            FONCTION      =SIMP(statut='o', typ=(fonction_sdaster,nappe_sdaster) ),
            EXPOSANT      =SIMP(statut='f', typ='I', defaut=1 ),
         ),
         INVERSE         =FACT(statut='f',fr="Inverse d'une fonction",
            FONCTION      =SIMP(statut='o', typ=fonction_sdaster),
         ),     
         NOM_PARA        =SIMP(statut='f',typ='TXM',into=C_PARA_FONCTION() ),
         NOM_RESU        =SIMP(statut='f',typ='TXM' ),
         INTERPOL        =SIMP(statut='f',typ='TXM',max=2,into=("NON","LIN","LOG") ),
         PROL_DROITE     =SIMP(statut='f',typ='TXM',into=("CONSTANT","LINEAIRE","EXCLU") ),
         PROL_GAUCHE     =SIMP(statut='f',typ='TXM',into=("CONSTANT","LINEAIRE","EXCLU") ),
         NOM_PARA_FONC   =SIMP(statut='f',typ='TXM',into=C_PARA_FONCTION() ),
         INTERPOL_FONC   =SIMP(statut='f',typ='TXM',max=2,into=("NON","LIN","LOG") ),
         PROL_DROITE_FONC=SIMP(statut='f',typ='TXM',into=("CONSTANT","LINEAIRE","EXCLU") ),
         PROL_GAUCHE_FONC=SIMP(statut='f',typ='TXM',into=("CONSTANT","LINEAIRE","EXCLU") ),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
)
#& MODIF COMMANDE  DATE 24/03/2009   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE GREFFET N.GREFFET
CALC_FORC_AJOU=OPER(nom="CALC_FORC_AJOU",op=199,sd_prod=vect_asse_gene,
                   fr="Calculer l'effet de surpression hydrodynamique due au mouvement d'entrainement de la structure"
                       +" en analyse sismique",
                   reentrant ='n',
            UIinfo={"groupes":("Matrices/vecteurs",)},

        regles=(EXCLUS('MODE_MECA','MODELE_GENE'),
                PRESENT_PRESENT( 'MODELE_GENE','NUME_DDL_GENE'),
                UN_PARMI('MONO_APPUI', 'NOEUD','GROUP_NO'),
                UN_PARMI('MONO_APPUI','MODE_STAT')),

         MODELE_FLUIDE   =SIMP(statut='o',typ=modele_sdaster ),
         MODELE_INTERFACE=SIMP(statut='o',typ=modele_sdaster ),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater ),
         CHARGE          =SIMP(statut='o',typ=char_ther ),
         MODE_MECA       =SIMP(statut='f',typ=mode_meca ),
         MODELE_GENE     =SIMP(statut='f',typ=modele_gene ),
         NUME_DDL_GENE   =SIMP(statut='f',typ=nume_ddl_gene ),
         DIST_REFE       =SIMP(statut='f',typ='R',defaut= 1.E-2 ),
         AVEC_MODE_STAT  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         NUME_MODE_MECA  =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
         POTENTIEL       =SIMP(statut='f',typ=evol_ther ),
         NOEUD_DOUBLE    =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),

         DIRECTION       =SIMP(statut='o',typ='R',max=3),
         MONO_APPUI      =SIMP(statut='f',typ='TXM',into=("OUI",),),
         NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
         GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
         MODE_STAT       =SIMP(statut='f',typ=(mode_stat_depl,mode_stat_acce,mode_stat_forc,),),

         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2 ) ),

         SOLVEUR         =FACT(statut='d',
           METHODE         =SIMP(statut='f',typ='TXM',defaut="MULT_FRONT",into=("MULT_FRONT","LDLT","GCPC","MUMPS","PETSC") ),
           b_mult_front    = BLOC ( condition = "METHODE == 'MULT_FRONT' ",fr="Paramtres de la mthode multi frontale",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="METIS",into=("MD","MDA","METIS") ),
           ),
           b_ldlt          =BLOC( condition = "METHODE == 'LDLT' ",fr="Paramtres de la mthode LDLT",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("RCMK","SANS") ),
           ),
           b_ldlt_mult     =BLOC( condition = "METHODE == 'LDLT' or METHODE == 'MULT_FRONT' ",
                                   fr="Paramtres relatifs  la non iversibilit de la matrice  factorise",
             NPREC           =SIMP(statut='f',typ='I',defaut= 8 ),
             STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           ),
           b_gcpc          =BLOC (condition = "METHODE == 'GCPC' ", fr="Paramtres de la mthode du gradient conjugu",
             PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC",),defaut="LDLT_INC" ),
             NIVE_REMPLISSAGE=SIMP(statut='f',typ='I',defaut=0),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
             NMAX_ITER       =SIMP(statut='f',typ='I',defaut= 0 ),
           ),
           b_mumps        =BLOC(condition = "METHODE == 'MUMPS' ",fr="Paramtres de la mthode MUMPS",
             TYPE_RESOL      =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("NONSYM","SYMGEN","SYMDEF","AUTO")),
             PRETRAITEMENTS  =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO")),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("AMD","AMF","PORD","METIS","QAMD","AUTO")),
             ELIM_LAGR2      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
             PCENT_PIVOT     =SIMP(statut='f',typ='I',defaut=10,),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut=1.0E-6,),
             PARALLELISME    =SIMP(statut='f',typ='TXM',defaut="CENTRALISE",
                                   into=("CENTRALISE","DISTRIBUE_MC","DISTRIBUE_MD","DISTRIBUE_SD")),
             PARTITION       =SIMP(statut='f',typ=sd_feti_sdaster),
             CHARGE_PROC0_MA =SIMP(statut='f',typ='I',defaut=100,val_min=0),
             CHARGE_PROC0_SD =SIMP(statut='f',typ='I',defaut=0,val_min=0),
             OUT_OF_CORE     =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
             ),

           b_petsc          =BLOC(condition = "METHODE == 'PETSC' ",fr="Paramtres de la mthode PETSC",
             ALGORITHME      =SIMP(statut='f',typ='TXM',into=("BCGS","BICG","CG","CR","GMRES","TFQMR",),defaut="CG" ),
             PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC","JACOBI","SOR"),defaut="LDLT_INC" ),
             b_petsc_ilu     =BLOC(condition = "PRE_COND == 'LDLT_INC' ",
               NIVE_REMPLISSAGE = SIMP(statut='f',typ='I',defaut= 0 ),
               REMPLISSAGE      = SIMP(statut='f',typ='R',defaut= 1.0),
             ),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
             NMAX_ITER       =SIMP(statut='f',typ='I',defaut= -1 ),
           ),
                           ),

           ) ;
#& MODIF COMMANDE  DATE 20/10/2008   AUTEUR GALENNE E.GALENNE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2006  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE GALENNE E.GALENNE
CALC_G=OPER(nom="CALC_G",op=100,sd_prod=table_sdaster,
            fr="Calcul du taux de restitution d'nergie par la mthode theta en thermo-lasticit"
                        +" et les facteurs d'intensit de contraintes.",
                    reentrant='f',
            UIinfo={"groupes":("Post traitements",)},
         regles=(EXCLUS('COMP_ELAS','COMP_INCR'),
                 CONCEPT_SENSIBLE("ENSEMBLE"),
                 REUSE_SENSIBLE(),
                 DERIVABLE('RESULTAT'),),

         THETA          =FACT(statut='o',
           THETA           =SIMP(statut='f',typ=(theta_geom,cham_no_sdaster),),
           FOND_FISS       =SIMP(statut='f',typ=fond_fiss,max=1),
           FISSURE         =SIMP(statut='f',typ=fiss_xfem,max=1),
           DTAN_ORIG       =SIMP(statut='f',typ='R',max='**'),
           DTAN_EXTR       =SIMP(statut='f',typ='R',max='**'),
           NB_POINT_FOND   =SIMP(statut='f',typ='I',val_min=2),
           regles=(EXCLUS('FOND_FISS','FISSURE'),
                 EXCLUS('FOND_FISS','NB_POINT_FOND'),
                 EXCLUS('FOND_FISS','DTAN_ORIG'),
                 EXCLUS('FOND_FISS','DTAN_EXTR'),),
          b_theta        =BLOC(condition="THETA == None",fr="calcul de theta",
            regles=(UN_PARMI('R_INF','R_INF_FO'),
                 PRESENT_PRESENT('R_INF','R_SUP'),
                PRESENT_PRESENT('R_INF_FO','R_SUP_FO'), ),
             NUME_FOND        =SIMP(statut='f',typ='I',defaut=1),
             R_INF           =SIMP(statut='f',typ='R'),
             R_SUP           =SIMP(statut='f',typ='R'),
             MODULE          =SIMP(statut='f',typ='R',defaut=1.),
             DIRE_THETA      =SIMP(statut='f',typ=cham_no_sdaster ),
             DIRECTION       =SIMP(statut='f',typ='R',max=3,min=3),
             R_INF_FO        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R_SUP_FO        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),             
             MODULE_FO       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ),
            ),

         RESULTAT        =SIMP(statut='o',typ=(evol_elas,evol_noli,dyna_trans,mode_meca,mult_elas),),

         b_no_mult          =BLOC(condition="(AsType(RESULTAT) != mult_elas)",
         regles=(EXCLUS('TOUT_ORDRE','NUME_ORDRE','LIST_ORDRE','INST','LIST_INST',
                  'TOUT_MODE','NUME_MODE','LIST_MODE','FREQ','LIST_FREQ'),),
            
            TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
            NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
            LIST_ORDRE      =SIMP(statut='f',typ=listis_sdaster),
            INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
            LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
            TOUT_MODE       =SIMP(statut='f',typ='TXM',into=("OUI",) ),
            NUME_MODE       =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
            LIST_MODE       =SIMP(statut='f',typ=listis_sdaster),
            LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster),
            FREQ            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
       
           b_acce_reel     =BLOC(condition="(INST != None)or(LIST_INST != None)or(FREQ != None)or(LIST_FREQ != None)",
              CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
                  b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                      PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
                  b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                      PRECISION       =SIMP(statut='o',typ='R'),),
            ),
         ),

         b_mult_elas     =BLOC(condition="(AsType(RESULTAT) == mult_elas)",
            NOM_CAS         =SIMP(statut='f',typ='TXM',validators=NoRepeat() ),
         ),

        
         EXCIT           =FACT(statut='f',max='**',
               CHARGE          =SIMP(statut='f',typ=(char_meca,char_cine_meca)),
               FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
               TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE",into=("FIXE",) ),
         ),
         SYME_CHAR       =SIMP(statut='f',typ='TXM',defaut="SANS",into=("SYME","ANTI","SANS") ),
 
         COMP_ELAS       =FACT(statut='f',
               RELATION        =SIMP(statut='f',typ='TXM',defaut="ELAS",
                                     into=("ELAS","ELAS_VMIS_LINE","ELAS_VMIS_TRAC","ELAS_VMIS_PUIS") ),
               CALCUL_CONTRAINTE =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
               DEFORMATION     =SIMP(statut='f',typ='TXM',defaut="PETIT",into=("PETIT","GREEN") ),
      regles=(PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
               TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
               GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
               MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
         ),  
         COMP_INCR       =FACT(statut='f',
               RELATION        =SIMP(statut='f',typ='TXM',defaut="ELAS",
                                     into=("ELAS","VMIS_ISOT_TRAC","VMIS_ISOT_LINE","VMIS_CINE_LINE","ELAS_VMIS_PUIS") ),
               DEFORMATION     =SIMP(statut='f',typ='TXM',defaut="PETIT",into=("PETIT","PETIT_REAC") ),
      regles=(PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
               TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
               GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
               MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
         ),
         ETAT_INIT       =FACT(statut='f',
           SIGM            =SIMP(statut='f',typ=cham_elem),
           DEPL            =SIMP(statut='f',typ=cham_no_sdaster),
         ),
          
         LISSAGE         =FACT(statut='d',
           DEGRE           =SIMP(statut='f',typ='I',defaut=5,into=(0,1,2,3,4,5,6,7) ),
           LISSAGE_THETA   =SIMP(statut='f',typ='TXM',defaut="LEGENDRE",into=("LEGENDRE","LAGRANGE","LAGRANGE_REGU"),),
           LISSAGE_G       =SIMP(statut='f',typ='TXM',defaut="LEGENDRE",into=("LEGENDRE","LAGRANGE",
                                 "LAGRANGE_NO_NO","LAGRANGE_REGU"),),
         ),

         OPTION          =SIMP(statut='o',typ='TXM',max=1,defaut='CALC_G',
              into=("CALC_G","CALC_G_GLOB","CALC_K_G","K_G_MODA","G_MAX","G_MAX_GLOB","G_BILI",
                    "G_BILI_GLOB","CALC_K_MAX"),),

         b_g_max    =BLOC(condition="(OPTION=='G_MAX') or (OPTION=='G_MAX_GLOB')",
           BORNES          =FACT(statut='o',max='**',
                NUME_ORDRE     =SIMP(statut='o',typ='I'),
                VALE_MIN       =SIMP(statut='o',typ='R'),
                VALE_MAX       =SIMP(statut='o',typ='R'),
                                ),
         ),
         b_k_max    =BLOC(condition="(OPTION=='CALC_K_MAX')",
           SIGNES          =FACT(statut='o',max=1,
                CHARGE_S       =SIMP(statut='o',typ='I',validators=NoRepeat(),max='**'),
                CHARGE_NS      =SIMP(statut='o',typ='I',validators=NoRepeat(),max='**'),
                                ),
         ),

         SENSIBILITE     =SIMP(statut='f',typ=(para_sensi,theta_geom),validators=NoRepeat(),max='**',
                           fr="Liste des paramtres de sensibilit.",
                           ang="List of sensitivity parameters"),

         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
);
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE ZENTNER I.ZENTNER
CALC_INTE_SPEC=OPER(nom="CALC_INTE_SPEC",op= 120,sd_prod=table_fonction,
                    fr="Calcul d'une matrice interspectrale  partir d'une fonction du temps",
                    reentrant='n',
            UIinfo={"groupes":("Fonction",)},
         INST_INIT       =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
         INST_FIN        =SIMP(statut='o',typ='R' ),
         DUREE_ANALYSE   =SIMP(statut='f',typ='R' ),
         DUREE_DECALAGE  =SIMP(statut='f',typ='R' ),
         NB_POIN         =SIMP(statut='o',typ='I' ),
         FONCTION        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule),max='**' ),
         TITRE           =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**'),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 24/03/2009   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE GREFFET N.GREFFET
CALC_MATR_AJOU=OPER(nom="CALC_MATR_AJOU",op= 152,sd_prod=matr_asse_gene_r,
                    fr="Calcul des matrices de masse, d'amortissement ou de rigidit ajouts",
                    reentrant='n',
            UIinfo={"groupes":("Matrices/vecteurs",)},
         regles=(EXCLUS('MODE_MECA','CHAM_NO','MODELE_GENE'),
                 PRESENT_ABSENT('NUME_DDL_GENE','CHAM_NO'),
                 PRESENT_PRESENT('MODELE_GENE','NUME_DDL_GENE'),),
         MODELE_FLUIDE   =SIMP(statut='o',typ=modele_sdaster ),
         MODELE_INTERFACE=SIMP(statut='o',typ=modele_sdaster ),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater ),
         CHARGE          =SIMP(statut='o',typ=char_ther ),
         MODE_MECA       =SIMP(statut='f',typ=mode_meca ),
         CHAM_NO         =SIMP(statut='f',typ=cham_no_sdaster ),
         MODELE_GENE     =SIMP(statut='f',typ=modele_gene ),
         NUME_DDL_GENE   =SIMP(statut='f',typ=nume_ddl_gene ),
         DIST_REFE       =SIMP(statut='f',typ='R',defaut= 1.E-2 ),
         AVEC_MODE_STAT  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         NUME_MODE_MECA  =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
         OPTION          =SIMP(statut='o',typ='TXM',into=("MASS_AJOU","AMOR_AJOU","RIGI_AJOU") ),
         POTENTIEL       =SIMP(statut='f',typ=evol_ther ),
         NOEUD_DOUBLE    =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2 ) ),

         SOLVEUR         =FACT(statut='d',
           METHODE         =SIMP(statut='f',typ='TXM',defaut="MULT_FRONT",into=("MULT_FRONT","LDLT","GCPC","MUMPS","PETSC") ),
           b_mult_front    = BLOC ( condition = "METHODE == 'MULT_FRONT' ",fr="Paramtres de la mthode multi frontale",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="METIS",into=("MD","MDA","METIS") ),
           ),
           b_ldlt          =BLOC( condition = "METHODE == 'LDLT' ",fr="Paramtres de la mthode LDLT",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("RCMK","SANS") ),
           ),
           b_ldlt_mult     =BLOC( condition = "METHODE == 'LDLT' or METHODE == 'MULT_FRONT' ",
                                   fr="Paramtres relatifs  la non iversibilit de la matrice  factorise",
             NPREC           =SIMP(statut='f',typ='I',defaut= 8 ),
             STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           ),
           b_gcpc          =BLOC (condition = "METHODE == 'GCPC' ", fr="Paramtres de la mthode du gradient conjugu",
             PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC",),defaut="LDLT_INC" ),
             NIVE_REMPLISSAGE=SIMP(statut='f',typ='I',defaut=0),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
             NMAX_ITER       =SIMP(statut='f',typ='I',defaut= 0 ),
           ),
           b_mumps        =BLOC(condition = "METHODE == 'MUMPS' ",fr="Paramtres de la mthode MUMPS",
             TYPE_RESOL      =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("NONSYM","SYMGEN","SYMDEF","AUTO")),
             PRETRAITEMENTS  =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO")),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("AMD","AMF","PORD","METIS","QAMD","AUTO")),
             ELIM_LAGR2      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
             PCENT_PIVOT     =SIMP(statut='f',typ='I',defaut=10,),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut=1.0E-6,),
             PARALLELISME    =SIMP(statut='f',typ='TXM',defaut="CENTRALISE",
                                   into=("CENTRALISE","DISTRIBUE_MC","DISTRIBUE_MD","DISTRIBUE_SD")),
             PARTITION       =SIMP(statut='f',typ=sd_feti_sdaster),
             CHARGE_PROC0_MA =SIMP(statut='f',typ='I',defaut=100,val_min=0),
             CHARGE_PROC0_SD =SIMP(statut='f',typ='I',defaut=0,val_min=0),
             OUT_OF_CORE     =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
             ),

           b_petsc          =BLOC(condition = "METHODE == 'PETSC' ",fr="Paramtres de la mthode PETSC",
             ALGORITHME      =SIMP(statut='f',typ='TXM',into=("BCGS","BICG","CG","CR","GMRES","TFQMR",),defaut="CG" ),
             PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC","JACOBI","SOR"),defaut="LDLT_INC" ),
             b_petsc_ilu     =BLOC(condition = "PRE_COND == 'LDLT_INC' ",
               NIVE_REMPLISSAGE = SIMP(statut='f',typ='I',defaut= 0 ),
               REMPLISSAGE      = SIMP(statut='f',typ='R',defaut= 1.0),
             ),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
             NMAX_ITER       =SIMP(statut='f',typ='I',defaut= -1 ),
           ),
         ),
)  ;
#& MODIF COMMANDE  DATE 06/10/2009   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
def calc_matr_elem_prod(OPTION,**args):
  if OPTION == "RIGI_MECA"        : return matr_elem_depl_r
  if OPTION == "RIGI_FLUI_STRU"   : return matr_elem_depl_r
  if OPTION == "MASS_MECA"        : return matr_elem_depl_r
  if OPTION == "MASS_FLUI_STRU"   : return matr_elem_depl_r
  if OPTION == "RIGI_GEOM"        : return matr_elem_depl_r
  if OPTION == "RIGI_ROTA"        : return matr_elem_depl_r
  if OPTION == "MECA_GYRO"        : return matr_elem_depl_r
  if OPTION == "AMOR_MECA"        : return matr_elem_depl_r
  if OPTION == "IMPE_MECA"        : return matr_elem_depl_r
  if OPTION == "ONDE_FLUI"        : return matr_elem_depl_r
  if OPTION == "AMOR_MECA_ABSO"   : return matr_elem_depl_r
  if OPTION == "RIGI_MECA_HYST"   : return matr_elem_depl_c
  if OPTION == "RIGI_THER"        : return matr_elem_temp_r
  if OPTION == "MASS_THER"        : return matr_elem_temp_r
  if OPTION == "MASS_MECA_DIAG"   : return matr_elem_depl_r
  if OPTION == "RIGI_ACOU"        : return matr_elem_pres_c
  if OPTION == "MASS_ACOU"        : return matr_elem_pres_c
  if OPTION == "AMOR_ACOU"        : return matr_elem_pres_c
  raise AsException("type de concept resultat non prevu")

CALC_MATR_ELEM=OPER(nom="CALC_MATR_ELEM",op=   9,sd_prod=calc_matr_elem_prod
                    ,fr="Calcul des matrices lmentaires",reentrant='n',
            UIinfo={"groupes":("Matrices/vecteurs",)},

         OPTION          =SIMP(statut='o',typ='TXM',
                               into=("RIGI_MECA","MASS_MECA","RIGI_GEOM",
                                     "AMOR_MECA","RIGI_THER","MASS_THER","IMPE_MECA",
                                     "ONDE_FLUI","AMOR_MECA_ABSO","MASS_FLUI_STRU","RIGI_FLUI_STRU",
                                     "RIGI_ROTA","MECA_GYRO","MASS_MECA_DIAG","RIGI_ACOU",
                                     "MASS_ACOU","AMOR_ACOU","RIGI_MECA_HYST") ),
         MODELE            =SIMP(statut='o',typ=modele_sdaster ),

         # mots cls facultatifs que l'on a du mal  mettre dans les blocs
         # sans gener MACRO_MATR_ASSE :
         #------------------------------------------------------------------
         INST=SIMP(statut='f',typ='R',defaut= 0.E+0 ),


         b_rigi_meca = BLOC( condition = "OPTION=='RIGI_MECA'",
           CHAM_MATER      =SIMP(statut='f',typ=cham_mater ),
           CARA_ELEM       =SIMP(statut='f',typ=cara_elem ),
           MODE_FOURIER    =SIMP(statut='f',typ='I',defaut= 0 ),
           CHARGE          =SIMP(statut='f',typ=char_meca,validators=NoRepeat(),max='**' ),
         ),

         b_mass_meca   =BLOC(condition = "(OPTION=='MASS_MECA') or (OPTION=='MASS_MECA_DIAG')",
           CHAM_MATER      =SIMP(statut='f',typ=cham_mater ),
           CARA_ELEM       =SIMP(statut='f',typ=cara_elem ),
           CHARGE          =SIMP(statut='f',typ=char_meca,validators=NoRepeat(),max='**'),
         ),

         b_rigi_geom       =BLOC(condition = "OPTION=='RIGI_GEOM'",
           CARA_ELEM         =SIMP(statut='f',typ=cara_elem ),
           SIEF_ELGA         =SIMP(statut='o',typ=cham_elem ),
           MODE_FOURIER      =SIMP(statut='f',typ='I',defaut= 0 ),
         ),

         b_rigi_rota       =BLOC(condition = "OPTION=='RIGI_ROTA'",
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CHARGE            =SIMP(statut='o',typ=char_meca,validators=NoRepeat(),max='**' ),
         ),

         b_meca_gyro = BLOC( condition = "OPTION=='MECA_GYRO'",
           CHAM_MATER      =SIMP(statut='f',typ=cham_mater ),
           CARA_ELEM       =SIMP(statut='o',typ=cara_elem ),
           CHARGE          =SIMP(statut='f',typ=char_meca,validators=NoRepeat(),max='**' ),
         ),

         b_amor_meca       =BLOC(condition = "OPTION=='AMOR_MECA'",
           regles=(AU_MOINS_UN('CARA_ELEM','RIGI_MECA'),
                   ENSEMBLE('RIGI_MECA','MASS_MECA','CHAM_MATER'), ),
           CARA_ELEM         =SIMP(statut='f',typ=cara_elem ),
           CHAM_MATER        =SIMP(statut='f',typ=cham_mater ),
           RIGI_MECA         =SIMP(statut='f',typ=matr_elem_depl_r ),
           MASS_MECA         =SIMP(statut='f',typ=matr_elem_depl_r ),
           CHARGE            =SIMP(statut='f',typ=char_meca,validators=NoRepeat(),max='**'),
         ),

         b_amor_meca_abso  =BLOC(condition = "OPTION=='AMOR_MECA_ABSO'",
           regles=(AU_MOINS_UN('CARA_ELEM','RIGI_MECA'),
                   ENSEMBLE('RIGI_MECA','MASS_MECA','CHAM_MATER'), ),
           CARA_ELEM         =SIMP(statut='f',typ=cara_elem ),
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           RIGI_MECA         =SIMP(statut='f',typ=matr_elem_depl_r ),
           MASS_MECA         =SIMP(statut='f',typ=matr_elem_depl_r ),
           CHARGE            =SIMP(statut='f',typ=char_meca,validators=NoRepeat(),max='**'),
         ),

         b_rigi_meca_hyst  =BLOC( condition = "OPTION=='RIGI_MECA_HYST'",
           CHARGE            =SIMP(statut='f',typ=char_meca ,validators=NoRepeat(),max='**' ),
           CHAM_MATER        =SIMP(statut='f',typ=cham_mater ),
           CARA_ELEM         =SIMP(statut='f',typ=cara_elem ),
           RIGI_MECA         =SIMP(statut='o',typ=matr_elem_depl_r ),
         ),

         b_rigi_ther       =BLOC(condition = "OPTION=='RIGI_THER'",
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CARA_ELEM         =SIMP(statut='f',typ=cara_elem ),
           MODE_FOURIER      =SIMP(statut='f',typ='I',defaut= 0 ),
           CHARGE            =SIMP(statut='f',typ=char_ther,validators=NoRepeat(),max='**' ),
         ),

         b_mass_ther       =BLOC(condition = "OPTION=='MASS_THER'",
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CARA_ELEM         =SIMP(statut='f',typ=cara_elem ),
           CHARGE            =SIMP(statut='f',typ=char_ther ,validators=NoRepeat(),max='**' ),
         ),

         b_rigi_acou       =BLOC(condition = "OPTION=='RIGI_ACOU'",
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CHARGE            =SIMP(statut='f',typ=char_acou ,validators=NoRepeat(),max='**' ),
         ),

         b_mass_acou       =BLOC(condition = "(OPTION=='MASS_ACOU') or (OPTION=='AMOR_ACOU')",
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CHARGE            =SIMP(statut='f',typ=char_acou ,validators=NoRepeat(),max='**' ),
         ),

         b_rigi_flui       =BLOC(condition = "OPTION=='RIGI_FLUI_STRU'",
           CARA_ELEM         =SIMP(statut='o',typ=cara_elem ),
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CHARGE            =SIMP(statut='o',typ=char_meca ,validators=NoRepeat(),max='**' ),
         ),

         b_mass_flui       =BLOC(condition = "OPTION=='MASS_FLUI_STRU'",
           CARA_ELEM         =SIMP(statut='o',typ=cara_elem ),
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CHARGE            =SIMP(statut='o',typ=char_meca ,validators=NoRepeat(),max='**'),
         ),

         b_impe_meca       =BLOC(condition = "(OPTION=='IMPE_MECA') or (OPTION=='ONDE_FLUI')",
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CHARGE            =SIMP(statut='o',typ=char_meca,validators=NoRepeat(),max='**' ),
         ),
)  ;
#& MODIF COMMANDE  DATE 30/09/2008   AUTEUR REZETTE C.REZETTE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE CANO V.CANO
CALC_META=OPER(nom="CALC_META",op=194,sd_prod=evol_ther,reentrant='o',
            UIinfo={"groupes":("Post traitements",)},
               fr="Calcule l'volution mtallurgique  partir du rsultat d'un calcul thermique",
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater ),
         RESULTAT        =SIMP(statut='o',typ=evol_ther ),
         ETAT_INIT       =FACT(statut='o',
            regles=(UN_PARMI('EVOL_THER', 'META_INIT_ELNO'),),
            EVOL_THER       =SIMP(statut='f',typ=evol_ther ),
            META_INIT_ELNO  =SIMP(statut='f',typ=carte_sdaster ),
            b_etat     =BLOC(condition="EVOL_THER != None",
               regles=(UN_PARMI('NUME_INIT', 'INST_INIT',),),
               NUME_INIT       =SIMP(statut='f',typ='I'),
               INST_INIT       =SIMP(statut='f',typ='R'),
               b_inst     =BLOC(condition="INST_INIT != None",
                  CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",),),
                  b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                      PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
                  b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                      PRECISION       =SIMP(statut='o',typ='R',),),
               ),
            ),
         ),
         COMP_INCR       =FACT(statut='o',max=1,
           RELATION        =SIMP(statut='o',typ='TXM',into=("ACIER","ZIRC",) ),
           ACIER           =SIMP(statut='c',typ='I',defaut=7,into=(7,) ),
           ZIRC            =SIMP(statut='c',typ='I',defaut=4,into=(4,) ),
      regles=(PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma, validators=NoRepeat(), max='**'),
           MAILLE          =SIMP(statut='f',typ=ma, validators=NoRepeat(), max='**'),
         ),
         OPTION          =SIMP(statut='f',typ='TXM'     
                             ,into=("META_ELNO_TEMP",) ),
)  ;
#& MODIF COMMANDE  DATE 27/04/2009   AUTEUR NISTOR I.NISTOR 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2008  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================

# RESPONSABLE NISTOR I.NISTOR

from Macro.calc_modal_ops import calc_modal_ops

def calc_modal_prod(self,AMORTISSEMENT,**args):
  if AMORTISSEMENT=="NON": return mode_meca
  if AMORTISSEMENT=="OUI": return mode_meca_c
  raise AsException("type de concept resultat non prevu")


CALC_MODAL=MACRO(nom="CALC_MODAL",op=calc_modal_ops,
            UIinfo={"groupes":("Rsolution",)},
                      sd_prod=calc_modal_prod,
                    fr="Calcul des modes propres reels ou complexes dans une seule commande",
         MODELE          =SIMP(statut='o',typ=modele_sdaster),
         AMORTISSEMENT    =SIMP(statut='f',typ='TXM',into=("OUI","NON"),defaut="NON" ),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater),
         INST            =SIMP(statut='f',typ='R',defaut=0.),
         CARA_ELEM       =SIMP(statut='f',typ=cara_elem),
         CHARGE          =SIMP(statut='f',typ=char_meca,validators=NoRepeat(),max='**'),  
         SOLVEUR         =FACT(statut='d',
           METHODE         =SIMP(statut='f',typ='TXM',defaut="MULT_FRONT",into=("MULT_FRONT","LDLT") ),
         b_mult_front    =BLOC(condition="METHODE=='MULT_FRONT'",fr="Paramtres associs  la mthode multifrontale",
           RENUM           =SIMP(statut='f',typ='TXM',into=("MD","MDA","METIS"),defaut="METIS" ),
         ),
         b_ldlt          =BLOC(condition="METHODE=='LDLT'",fr="Paramtres associs  la mthode LDLT",
           RENUM           =SIMP(statut='f',typ='TXM',into=("RCMK","SANS"),defaut="RCMK"  ),
         ),),
         METHODE         =SIMP(statut='f',typ='TXM',defaut="SORENSEN",
                               into=("TRI_DIAG","JACOBI","SORENSEN","QZ") ),
         b_tri_diag =BLOC(condition = "METHODE == 'TRI_DIAG'",
           PREC_ORTHO      =SIMP(statut='f',typ='R',defaut= 1.E-12,val_min=0.E+0 ),
           NMAX_ITER_ORTHO =SIMP(statut='f',typ='I',defaut= 5,val_min=0 ),
           PREC_LANCZOS    =SIMP(statut='f',typ='R',defaut= 1.E-8,val_min=0.E+0 ),
           NMAX_ITER_QR    =SIMP(statut='f',typ='I',defaut= 30,val_min=0 ), 
         ),
         b_jacobi =BLOC(condition = "METHODE == 'JACOBI'",
           PREC_BATHE      =SIMP(statut='f',typ='R',defaut= 1.E-10,val_min=0.E+0 ),
           NMAX_ITER_BATHE =SIMP(statut='f',typ='I',defaut= 40,val_min=0 ),
           PREC_JACOBI     =SIMP(statut='f',typ='R',defaut= 1.E-2,val_min=0.E+0 ),
           NMAX_ITER_JACOBI=SIMP(statut='f',typ='I',defaut= 12,val_min=0 ),
         ),
         b_sorensen =BLOC(condition = "METHODE == 'SORENSEN'",
           PREC_SOREN      =SIMP(statut='f',typ='R',defaut= 0.E+0,val_min=0.E+0 ),  
           NMAX_ITER_SOREN =SIMP(statut='f',typ='I',defaut= 20,val_min=0 ),  
           PARA_ORTHO_SOREN=SIMP(statut='f',typ='R',defaut= 0.717,val_min=0.E+0 ),
         ),
         b_qz =BLOC(condition = "METHODE == 'QZ'",
           TYPE_QZ      =SIMP(statut='f',typ='TXM',defaut="QZ_SIMPLE",into=("QZ_QR","QZ_SIMPLE","QZ_EQUI") ),  
         ), 
         MODE_RIGIDE          =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON"),
                               fr="Calcul des modes de corps rigide, uniquement pour la mthode TRI_DIAG" ),
         CALC_FREQ       =FACT(statut='d',min=0,
             OPTION      =SIMP(statut='f',typ='TXM',defaut="PLUS_PETITE",into=("PLUS_PETITE","BANDE","CENTRE","TOUT"),
                                   fr="Choix de l option et par consquent du shift du problme modal" ),
             b_plus_petite =BLOC(condition = "OPTION == 'PLUS_PETITE'",fr="Recherche des plus petites valeurs propres",
               NMAX_FREQ       =SIMP(statut='f',typ='I',defaut= 10,val_min=0 ),
             ),
             b_centre       =BLOC(condition = "OPTION == 'CENTRE'",
                                  fr="Recherche des valeurs propres les plus proches d une valeur donne",
               FREQ            =SIMP(statut='o',typ='R',
                                     fr="Frquence autour de laquelle on cherche les frquences propres"),
               AMOR_REDUIT     =SIMP(statut='f',typ='R',),
               NMAX_FREQ       =SIMP(statut='f',typ='I',defaut= 10,val_min=0 ),
             ),
             b_bande         =BLOC(condition = "(OPTION == 'BANDE')",
                                   fr="Recherche des valeurs propres dans une bande donne",
               FREQ            =SIMP(statut='o',typ='R',min=2,validators=NoRepeat(),max=2,
                                     fr="Valeur des deux frquences dlimitant la bande de recherche"),
             ),           
             APPROCHE        =SIMP(statut='f',typ='TXM',defaut="REEL",into=("REEL","IMAG","COMPLEXE"),
                                   fr="Choix du pseudo-produit scalaire pour la rsolution du problme quadratique" ),           
             regles=(EXCLUS('DIM_SOUS_ESPACE','COEF_DIM_ESPACE'),),
             DIM_SOUS_ESPACE =SIMP(statut='f',typ='I' ),
             COEF_DIM_ESPACE =SIMP(statut='f',typ='I' ),
             NPREC_SOLVEUR   =SIMP(statut='f',typ='I',defaut= 8,val_min=0 ),
             NMAX_ITER_SHIFT =SIMP(statut='f',typ='I',defaut= 5,val_min=0 ),
             PREC_SHIFT      =SIMP(statut='f',typ='R',defaut= 5.E-2,val_min=0.E+0 ),
             SEUIL_FREQ      =SIMP(statut='f',typ='R',defaut= 1.E-2,val_min=0.E+0 ),
             STOP_FREQ_VIDE  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           ),

        VERI_MODE       =FACT(statut='d',min=0,
           STOP_ERREUR     =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           PREC_SHIFT      =SIMP(statut='f',typ='R',defaut= 5.E-3,val_min=0.E+0 ),
           SEUIL           =SIMP(statut='f',typ='R',defaut= 1.E-6,val_min=0.E+0,
                                 fr="Valeur limite admise pour l ereur a posteriori des modes" ),
           STURM           =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         ),

         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2)),
)  ;
#& MODIF COMMANDE  DATE 09/11/2009   AUTEUR LEBOUVIER F.LEBOUVIER 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
def calc_no_prod(RESULTAT,**args):
   if AsType(RESULTAT) != None : return AsType(RESULTAT)
   raise AsException("type de concept resultat non prevu")

CALC_NO=OPER(nom="CALC_NO",op= 106,sd_prod=calc_no_prod,reentrant='f',
            fr="Enrichir une SD Rsultat par des champs aux noeuds calculs  partir de champs aux lments valus aux noeuds",
            UIinfo={"groupes":("Post traitements",)},
         RESULTAT        =SIMP(statut='o',typ=resultat_sdaster),
         SENSIBILITE     =SIMP(statut='f',typ=(para_sensi,theta_geom),validators=NoRepeat(),max='**',
                               fr="Liste des paramtres de sensibilit.",
                               ang="List of sensitivity parameters"),

         regles=(EXCLUS('TOUT_ORDRE','NUME_ORDRE','INST','FREQ','NUME_MODE',
                        'NOEUD_CMP','LIST_INST','LIST_FREQ','LIST_ORDRE','NOM_CAS'),
                 CONCEPT_SENSIBLE("SEPARE"),
                 DERIVABLE('RESULTAT'),),
         TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
         NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
         NUME_MODE       =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
         NOEUD_CMP       =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**'),
         NOM_CAS         =SIMP(statut='f',typ='TXM' ),
         INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
         FREQ            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
         LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
         LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster),
         LIST_ORDRE      =SIMP(statut='f',typ=listis_sdaster),
         CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",),),
         b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
         b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
             PRECISION       =SIMP(statut='o',typ='R',),),
         OPTION          =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                               into=("FORC_NODA","REAC_NODA",
                                     "FORC_NODA_NONL",
                                     "DCHA_NOEU_SIGM",
                                     "DEGE_NOEU_DEPL",
                                     "DETE_NOEU_DLTE",
                                     "DEDE_NOEU_DLDE",
                                     "DESI_NOEU_DLSI",
                                     "DURT_NOEU_META",
                                     "EFGE_NOEU_CART","EFGE_NOEU_DEPL",
                                     "ENDO_NOEU_SINO",
                                     "ENEL_NOEU_ELGA",
                                     "EPMG_NOEU_DEPL",
                                     "EPSA_NOEU",
                                     "EPSG_NOEU_DEPL",
                                     "EPSI_NOEU_DEPL",
                                     "EPSP_NOEU"     ,"EPSP_NOEU_ZAC",
                                     "EPVC_NOEU","EPFD_NOEU","EPFP_NOEU","EPFP_NOEU",
                                     "EQUI_NOEU_EPME","EQUI_NOEU_EPSI","EQUI_NOEU_SIGM",
                                     "ERRE_NOEU_ELEM","QIRE_NOEU_ELEM",
                                     "FLUX_NOEU_TEMP",
                                     "HYDR_NOEU_ELGA",
                                     "INTE_NOEU_ACTI","INTE_NOEU_REAC",
                                     "META_NOEU_TEMP",
                                     "PMPB_NOEU_SIEF",
                                     "PRES_NOEU_DBEL","PRES_NOEU_IMAG","PRES_NOEU_REEL",
                                     "RADI_NOEU_SIGM",
                                     "SIEF_NOEU"     ,"SIEF_NOEU_ELGA",
                                     "SIGM_NOEU_CART","SIGM_NOEU_COQU","SIGM_NOEU_DEPL",
                                     "SIGM_NOEU_SIEF","SIGM_NOEU_ZAC",
                                     "SIPO_NOEU_DEPL","SIPO_NOEU_SIEF",
                                     "SIRE_NOEU_DEPL",
                                     "VARI_NOEU","EXTR_NOEU_VARI","VARI_NOEU_ELGA",
                                     "ARCO_NOEU_SIGM",) ),

         b_forc_reac     =BLOC(condition = """(OPTION == 'FORC_NODA') or (type(OPTION) == type(()) and 'FORC_NODA' in OPTION) or\
 (OPTION == 'REAC_NODA') or (type(OPTION) == type(()) and 'REAC_NODA' in OPTION)""",
             MODELE          =SIMP(statut='f',typ=modele_sdaster),
         ),
         b_forc_nonl     =BLOC(condition = """(OPTION == 'FORC_NODA_NONL')""",
             MODELE          =SIMP(statut='f',typ=modele_sdaster),
             COMP_INCR       =C_COMP_INCR(),
         ),
         
         CHAM_MATER      =SIMP(statut='f',typ=cham_mater),
         CARA_ELEM       =SIMP(statut='f',typ=cara_elem),
         EXCIT           =FACT(statut='f',max='**',
           CHARGE          =SIMP(statut='f',typ=(char_meca,char_ther,char_acou,char_cine_meca) ),
           FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE_CSTE",
                                 into=("FIXE_CSTE","FIXE_PILO","SUIV") ),
         ),
         TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
         GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
         MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
         GROUP_MA_RESU   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
         MAILLE_RESU     =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
         GROUP_NO_RESU   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
         NOEUD_RESU      =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
)  ;
#& MODIF COMMANDE  DATE 24/03/2009   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE MICHEL S.MICHEL

from Macro.calc_precont_ops import calc_precont_ops


# ===========================================================================
#           CATALOGUE DE LA MACRO "CALC_PRECONT"
#           -----------------------------------------
# USAGE :
#
#
# ===========================================================================

CALC_PRECONT=MACRO(nom="CALC_PRECONT",op=calc_precont_ops,sd_prod=evol_noli,
                   fr="Imposer la tension dfinie par le BPEL dans les cables",
                   reentrant='f',UIinfo={"groupe":("Modlisation",)},
         reuse =SIMP(statut='f',typ='evol_noli'),
         MODELE           =SIMP(statut='o',typ=modele_sdaster),
         CHAM_MATER       =SIMP(statut='o',typ=cham_mater),
         CARA_ELEM        =SIMP(statut='o',typ=cara_elem),
         CABLE_BP         =SIMP(statut='o',typ=cabl_precont,validators=NoRepeat(),max='**'),
         CABLE_BP_INACTIF =SIMP(statut='f',typ=cabl_precont,validators=NoRepeat(),max='**'),
         INCREMENT        =FACT(statut='o',
           LIST_INST       =SIMP(statut='o',typ=listr8_sdaster),
           INST_INIT       =SIMP(statut='f',typ='R'),
           INST_FIN        =SIMP(statut='f',typ='R'),
           PRECISION       =SIMP(statut='f',typ='R',defaut=1.0E-6 ),
           # DEBUT DE BLOC POUR LA SUBDIVISION DES PAS DE TEMPS
           SUBD_METHODE    =SIMP( statut='f',typ='TXM',
              into =("AUCUNE","UNIFORME","EXTRAPOLE"),
              defaut="AUCUNE",
              fr="Mthode de subdivision des pas de temps en cas de non-convergence"
           ),
           b_subd_unif=BLOC(condition = "SUBD_METHODE == 'UNIFORME'",
             regles=(AU_MOINS_UN('SUBD_NIVEAU','SUBD_PAS_MINI'),),
             SUBD_COEF_PAS_1=SIMP(statut='f',typ='R',defaut=1.0,val_min=0.0,
                fr="Coefficient multiplicateur de la 1re subdivision"),
             SUBD_PAS       =SIMP(statut='f',typ='I',defaut=4,val_min=2,
                fr="Nombre de subdivision d'un pas de temps"),
             SUBD_NIVEAU=SIMP(statut='f',typ='I',val_min=2,
                fr="Nombre maximum de niveau de subdivision d'un pas de temps"),
             SUBD_PAS_MINI=SIMP(statut='f',typ='R',val_min=0.0,
                fr="Pas de temps en dessous duquel on ne subdivise plus"),
           ),
           b_subd_extr=BLOC(condition = "SUBD_METHODE == 'EXTRAPOLE'",
             regles=(AU_MOINS_UN('SUBD_NIVEAU','SUBD_PAS_MINI'),),
             SUBD_OPTION    =SIMP(statut='f',typ='TXM',
                into =("IGNORE_PREMIERES","GARDE_DERNIERES",),
                defaut="IGNORE_PREMIERES",
                fr="Technique d'extrapolation : les 1ere itrations sont ignores ou les dernires sont gardes"),
             SUBD_ITER_IGNO =SIMP(statut='c',typ='I',defaut=3,val_min=0,
                fr="Les n premires itrations sont ignores pour l'extrapolation"),
             SUBD_ITER_FIN  =SIMP(statut='c',typ='I',defaut=8,val_min=3,
                fr="Seules les n dernires itrations sont prises pour l'extrapolation"),
             SUBD_PAS       =SIMP(statut='c',typ='I',defaut=4,val_min=2,
                fr="Nombre de subdivision d'un pas de temps en cas divergence"),
             SUBD_NIVEAU=SIMP(statut='f',typ='I',val_min=2,
                fr="Nombre maximum de niveau de subdivision d'un pas de temps"),
             SUBD_PAS_MINI=SIMP(statut='f',typ='R',val_min=0.0,
                fr="Pas de temps en dessous duquel on ne subdivise plus"),
             SUBD_ITER_PLUS =SIMP(statut='c',typ='I',defaut=50,val_min=20,
                fr="% itration autorise en plus"),
           ),
           # FIN DE BLOC POUR LA SUBDIVISION DES PAS DE TEMPS
         ),

         NEWTON          =FACT(statut='d',
            REAC_INCR       =SIMP(statut='f',typ='I',defaut= 1 ),
            PREDICTION      =SIMP(statut='f',typ='TXM',into=("DEPL_CALCULE","TANGENTE","ELASTIQUE","EXTRAPOL") ),
            MATRICE         =SIMP(statut='f',typ='TXM',defaut="TANGENTE",into=("TANGENTE","ELASTIQUE") ),
            PAS_MINI_ELAS   =SIMP(statut='f',typ='R',defaut=0.0E+0),
            REAC_ITER       =SIMP(statut='f',typ='I',defaut=0),
            EVOL_NOLI       =SIMP(statut='f',typ=evol_noli),
          ),
         RECH_LINEAIRE   =FACT(statut='f',
           RESI_LINE_RELA  =SIMP(statut='f',typ='R',defaut= 1.0E-1 ),
           ITER_LINE_MAXI  =SIMP(statut='f',typ='I',defaut= 3),
         ),
          CONVERGENCE     =FACT(statut='d',
            RESI_GLOB_MAXI  =SIMP(statut='f',typ='R'),
            RESI_GLOB_RELA  =SIMP(statut='f',typ='R'),
            ITER_GLOB_MAXI  =SIMP(statut='f',typ='I',defaut=10),
            ITER_GLOB_ELAS  =SIMP(statut='f',typ='I',defaut=25),
            ARRET           =SIMP(statut='f',typ='TXM',defaut="OUI"),
          ),
          ETAT_INIT       =FACT(statut='f',
            regles=(AU_MOINS_UN('EVOL_NOLI','DEPL','SIGM','VARI',),
                    EXCLUS('EVOL_NOLI','DEPL',),
                    EXCLUS('EVOL_NOLI','SIGM',),
                    EXCLUS('EVOL_NOLI','VARI',),
                    EXCLUS('NUME_ORDRE','INST'), ),
            DEPL            =SIMP(statut='f',typ=cham_no_sdaster),
            SIGM            =SIMP(statut='f',typ=(carte_sdaster,cham_elem)),
            VARI            =SIMP(statut='f',typ=cham_elem),
            EVOL_NOLI       =SIMP(statut='f',typ=evol_noli),
            NUME_ORDRE      =SIMP(statut='f',typ='I'),
            INST            =SIMP(statut='f',typ='R'),
            CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
            b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
            b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                PRECISION       =SIMP(statut='o',typ='R',),),
            NUME_DIDI       =SIMP(statut='f',typ='I'),
            INST_ETAT_INIT  =SIMP(statut='f',typ='R'),
          ),
          SOLVEUR         =FACT(statut='d',
            METHODE         =SIMP(statut='f',typ='TXM',defaut="MULT_FRONT",into=("MULT_FRONT","LDLT","GCPC","MUMPS","PETSC") ),
            b_mult_front    =BLOC(condition = "METHODE == 'MULT_FRONT' ",fr="Paramtres de la mthode multi frontale",
              RENUM           =SIMP(statut='f',typ='TXM',defaut="METIS",into=("MD","MDA","METIS") ),
            ),
            b_ldlt         =BLOC(condition = "METHODE == 'LDLT' ",fr="Paramtres de la mthode LDLT",
              RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("RCMK","SANS") ),
            ),
            b_ldlt_mult    =BLOC(condition = "METHODE == 'LDLT' or METHODE == 'MULT_FRONT' ",
                                    fr="Paramtres relatifs  la non inversibilit de la matrice  factorise",
              NPREC           =SIMP(statut='f',typ='I',defaut= 8 ),
              STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON","DECOUPE") ),
            ),
            b_gcpc         =BLOC(condition = "METHODE == 'GCPC' ", fr="Paramtres de la mthode du gradient conjugu",
              PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC",),defaut="LDLT_INC" ),
              NIVE_REMPLISSAGE=SIMP(statut='f',typ='I',defaut= 0 ),
              RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
              RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
              NMAX_ITER       =SIMP(statut='f',typ='I',defaut= 0 ),
            ),
            b_mumps        =BLOC(condition = "METHODE == 'MUMPS' ",fr="Paramtres de la mthode MUMPS",
              TYPE_RESOL      =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("NONSYM","SYMGEN","SYMDEF","AUTO")),
              PRETRAITEMENTS  =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO")),
              RENUM           =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("AMD","AMF","PORD","METIS","QAMD","AUTO")),
              ELIM_LAGR2      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
              PCENT_PIVOT     =SIMP(statut='f',typ='I',defaut=10,),
              RESI_RELA       =SIMP(statut='f',typ='R',defaut=1.0E-6,),
              PARALLELISME    =SIMP(statut='f',typ='TXM',defaut="CENTRALISE",
                                    into=("CENTRALISE","DISTRIBUE_MC","DISTRIBUE_MD","DISTRIBUE_SD")),
              PARTITION       =SIMP(statut='f',typ=sd_feti_sdaster),
              CHARGE_PROC0_MA =SIMP(statut='f',typ='I',defaut=100,val_min=0),
              CHARGE_PROC0_SD =SIMP(statut='f',typ='I',defaut=0,val_min=0),
              OUT_OF_CORE     =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
              ),

            b_petsc          =BLOC(condition = "METHODE == 'PETSC' ",fr="Paramtres de la mthode PETSC",
              ALGORITHME      =SIMP(statut='f',typ='TXM',into=("BCGS","BICG","CG","CR","GMRES","TFQMR",),defaut="CG" ),
              PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC","JACOBI","SOR"),defaut="LDLT_INC" ),
              b_petsc_ilu     =BLOC(condition = "PRE_COND == 'LDLT_INC' ",
                NIVE_REMPLISSAGE = SIMP(statut='f',typ='I',defaut= 0 ),
                REMPLISSAGE      = SIMP(statut='f',typ='R',defaut= 1.0),
              ),
              RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
              RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
              NMAX_ITER       =SIMP(statut='f',typ='I',defaut= -1 ),
            ),
            SYME            =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
          ),
          INFO            =SIMP(statut='f',typ='I',into=(1,2) ),
          TITRE           =SIMP(statut='f',typ='TXM',max='**' ),

          EXCIT           =FACT(statut='o',max='**',
            CHARGE          =SIMP(statut='o',typ=char_meca),
          ),

         COMP_INCR       =C_COMP_INCR(),
  )  ;
#& MODIF COMMANDE  DATE 21/10/2008   AUTEUR CORUS M.CORUS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2008  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================

# RESPONSABLE CORUS M.CORUS

from Macro.calc_spec_ops import calc_spec_ops

CALC_SPEC=MACRO(nom="CALC_SPEC",op= calc_spec_ops,sd_prod=table_fonction,
                     reentrant='n',
                     fr="Calcule une matrice interspectrale ou des fonctions de transferts",
                     UIinfo={"groupes":("Fonction",)},
         TAB_ECHANT      =FACT(statut='f',
           NOM_TAB         =SIMP(statut='o',typ=table_sdaster),
           LONGUEUR_ECH    =FACT(statut='f',
             DUREE           =SIMP(statut='f',typ='R'),
             POURCENT        =SIMP(statut='f',typ='R'),
             NB_PTS          =SIMP(statut='f',typ='I'),
                              ),
           RECOUVREMENT  =FACT(statut='f',
             DUREE           =SIMP(statut='f',typ='R'),
             POURCENT        =SIMP(statut='f',typ='R'),
             NB_PTS          =SIMP(statut='f',typ='I'),
                                ),
                              ),
         ECHANT          =FACT(statut='f',max='**',
           NUME_ORDRE_I    =SIMP(statut='o',typ='I' ),
           NUME_MES        =SIMP(statut='o',typ='I' ),
           FONCTION        =SIMP(statut='o',typ=fonction_sdaster),
                              ),
#-- Cas de la matrice interspectrale --#
         INTERSPE        =FACT(statut='f',
           FENETRE         =SIMP(statut='f',typ='TXM',defaut="RECT",into=("RECT","HAMM","HANN","EXPO","PART",)),
           BLOC_DEFI_FENE  =BLOC(condition = "FENETRE == 'EXPO' or FENETRE == 'PART' ", 
#             DEFI_FENE       =SIMP(statut='f',typ='R',max='**'),
                                 ),
                              ),
#-- Cas des transferts - estimateurs H1 / H2 / Hv + Coherence --#
         TRANSFERT       =FACT(statut='f',
           ESTIM           =SIMP(statut='f',typ='TXM',defaut="H1",into=("H1","H2","CO",)),
           REFER           =SIMP(statut='o',typ='I',max='**'),
           FENETRE         =SIMP(statut='f',typ='TXM',defaut="RECT",into=("RECT","HAMM","HANN","EXPO","PART",)),
           DEFI_FENE       =SIMP(statut='f',typ='R',max='**'),

                              ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
);
#& MODIF COMMANDE  DATE 30/06/2009   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2005  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# -*- coding: iso-8859-1 -*-
# RESPONSABLE COURTOIS M.COURTOIS

def calc_table_prod(self, TABLE, ACTION, **kargs):
   """Typage du concept produit.
   """
   l_typ = [AsType(TABLE),]
   for mcf in ACTION:
      dmc = mcf.cree_dict_valeurs(mcf.mc_liste)
      if dmc.get('TABLE') != None:
         l_typ.append(AsType(dmc['TABLE']))
   # une table_fonction tant une table
   if table_fonction in l_typ:
      return table_fonction
   else:
      return table_sdaster


from Macro.calc_table_ops import calc_table_ops

CALC_TABLE=MACRO(nom="CALC_TABLE",op=calc_table_ops, sd_prod=calc_table_prod,
                 fr="Oprations sur une table",
                 reentrant='f',
   regles=(DERIVABLE('TABLE'),),
   TABLE  = SIMP(statut='o',typ=table_sdaster),
   ACTION = FACT(statut='o', max='**',
                    fr = "Suite des oprations  effectuer sur la table",
      OPERATION = SIMP(statut='o', typ='TXM',
                  into=('FILTRE', 'EXTR', 'RENOMME', 'TRI', 'COMB', 'AJOUT', 'OPER',)),
      
      b_filtre = BLOC(condition="OPERATION == 'FILTRE'",
                      fr="Slectionne les lignes de la table vrifiant un critre",
         NOM_PARA  = SIMP(statut='o',typ='TXM'),
         CRIT_COMP = SIMP(statut='f',typ='TXM',defaut="EQ",
                          into=('EQ','NE','GT','LT','GE','LE','REGEXP',
                                'VIDE','NON_VIDE','MAXI','ABS_MAXI','MINI','ABS_MINI'),),
         b_vale = BLOC(condition = "(CRIT_COMP in ('EQ','NE','GT','LT','GE','LE'))",
            regles=(UN_PARMI('VALE','VALE_I','VALE_K','VALE_C',),),
            VALE   = SIMP(statut='f',typ='R',max='**'),
            VALE_I = SIMP(statut='f',typ='I',max='**'),
            VALE_C = SIMP(statut='f',typ='C',max='**'),
            VALE_K = SIMP(statut='f',typ='TXM',max='**'),
         ),
         b_regexp = BLOC(condition = "CRIT_COMP == 'REGEXP'",
            VALE_K = SIMP(statut='o',typ='TXM',max='**'),
         ),
         b_crit = BLOC(condition = "CRIT_COMP in ('EQ','NE')",
            CRITERE   = SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
            PRECISION = SIMP(statut='f',typ='R',defaut= 1.0E-3 ),
         ),
      ),
      
      b_extr = BLOC(condition="OPERATION ==  'EXTR'",
                    fr="Extrait une ou plusieurs colonnes de la table",
         NOM_PARA = SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                         fr="Noms des colonnes  extraire"),
      ),
   
      b_renomme = BLOC(condition="OPERATION == 'RENOMME'",
                       fr="Renomme un ou plusieurs paramtres de la table",
         NOM_PARA = SIMP(statut='o', typ='TXM', validators=NoRepeat(), min=2, max=2,
                         fr="Couple (ancien nom du paramtre, nouveau nom du paramtre)",),
      ),
   
      b_tri = BLOC(condition="OPERATION == 'TRI'",
                   fr="Ordonne les lignes de la table selon les valeurs d'un ou plusieurs paramtres",
         NOM_PARA = SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**'),
         ORDRE    = SIMP(statut='f',typ='TXM',defaut="CROISSANT",
                         into=("CROISSANT","DECROISSANT") ),
      ),
      
      b_comb = BLOC(condition="OPERATION == 'COMB'",
                    fr="Combine deux tables ayant ventuellement des paramtres communs",
         TABLE    = SIMP(statut='o',typ=table_sdaster,
                         fr="Table dont les colonnes vont venir surcharger la table initiale"),
         NOM_PARA = SIMP(statut='f',typ='TXM',max='**',
                         fr="Noms des paramtres dont les valeurs doivent etre identiques dans les deux tables "\
                            "pour que les colonnes soient combines"),
      ),
      
      b_append = BLOC(condition="OPERATION == 'AJOUT'",
                    fr="Ajoute une ligne  la table initiale",
         NOM_PARA = SIMP(statut='o',typ='TXM',max='**',
                         fr="Noms des paramtres dont les valeurs sont fournies sous VALE"),
         VALE     = SIMP(statut='o',typ=assd,max='**', fr='Valeurs des paramtres'),
      ),
      
      b_oper = BLOC(condition="OPERATION == 'OPER'",
                    fr="Applique une formule dans laquelle les variables sont les paramtres de la table",
         FORMULE  = SIMP(statut='o',typ=formule,
                         fr="Formule  appliquer aux colonnes de la table"),
         NOM_PARA = SIMP(statut='o',typ='TXM',
                         fr="Nom de la nouvelle colonne"),
      ),
   ),
   
   SENSIBILITE = SIMP(statut='f',typ=(para_sensi,theta_geom),max=1,
                      fr="Paramtre de sensibilit",
                      ang="Sensitivity parameter"),
   TITRE = SIMP(statut='f',typ='TXM',max='**',
                fr="Titre de la table produite"),
   INFO  = SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
)
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE GALENNE E.GALENNE
CALC_THETA=OPER(nom="CALC_THETA",op=54,sd_prod=theta_geom,reentrant='n',
            UIinfo={"groupes":("Post traitements",)},
                fr="Dfinir un champ theta pour le calcul du taux de restitution d'nergie"
                    +" ou des facteurs d'intensit de contraintes",
         regles=(UN_PARMI('THETA_2D','THETA_3D','THETA_BANDE'),
                 PRESENT_ABSENT('THETA_2D','DIRE_THETA'),
                 EXCLUS('DIRECTION','DIRE_THETA'),),
         OPTION          =SIMP(statut='f',typ='TXM',defaut="COURONNE",into=("COURONNE","BANDE") ),
         MODELE          =SIMP(statut='o',typ=(modele_sdaster) ),
         THETA_3D        =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_NO','NOEUD'),
                   UN_PARMI('MODULE','MODULE_FO'),
                   ENSEMBLE('MODULE','R_INF','R_SUP'),
                   ENSEMBLE('MODULE_FO','R_INF_FO','R_SUP_FO'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           MODULE          =SIMP(statut='f',typ='R'),
           R_INF           =SIMP(statut='f',typ='R'),
           R_SUP           =SIMP(statut='f',typ='R'),
           MODULE_FO       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           R_INF_FO        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           R_SUP_FO        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                         ),
         b_theta_3d     =BLOC(condition="THETA_3D != None",
           FOND_FISS       =SIMP(statut='o',typ=fond_fiss),),
         DIRE_THETA      =SIMP(statut='f',typ=cham_no_sdaster ),
         DIRECTION       =SIMP(statut='f',typ='R',max='**'),
         THETA_2D        =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_NO','NOEUD'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           MODULE          =SIMP(statut='o',typ='R'),
           R_INF           =SIMP(statut='o',typ='R'),
           R_SUP           =SIMP(statut='o',typ='R'),
         ),
         THETA_BANDE     =FACT(statut='f',max='**',
           MODULE          =SIMP(statut='o',typ='R'),
           R_INF           =SIMP(statut='o',typ='R'),
           R_SUP           =SIMP(statut='o',typ='R'),
         ),
         GRAD_NOEU_THETA =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         IMPRESSION      =FACT(statut='f',
           UNITE           =SIMP(statut='f',typ='I',defaut=8),  
           FORMAT          =SIMP(statut='f',typ='TXM',defaut="EXCEL",into=("EXCEL","AGRAF") ),
         ),
)  ;
#& MODIF COMMANDE  DATE 07/04/2009   AUTEUR ABBAS M.ABBAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2007  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ABBAS M.ABBAS

CALCUL=OPER(nom="CALCUL",op=26,sd_prod=table_container,reentrant='f',
            UIinfo={"groupes":("Rsolution",)},
            fr="Calculer des objets lmentaires comme une matrice tangente, intgrer une loi de comportement, etc...",
     OPTION          =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',defaut="COMPORTEMENT",
                           into=( "COMPORTEMENT","MATR_TANG_ELEM","FORC_INT_ELEM"),),
     MODELE          =SIMP(statut='o',typ=modele_sdaster),
     CARA_ELEM       =SIMP(statut='f',typ=cara_elem),
     CHAM_MATER      =SIMP(statut='o',typ=cham_mater),
     TABLE           =SIMP(statut='f',typ=table_container),
     EXCIT           =FACT(statut='o',max='**',
       CHARGE          =SIMP(statut='o',typ=(char_meca,char_cine_meca)),
       FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
       TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE_CSTE",
                                 into=("FIXE_CSTE",)),

     ),
     DEPL            =SIMP(statut='o',typ=cham_no_sdaster ),
     INCR_DEPL       =SIMP(statut='o',typ=cham_no_sdaster ),
     SIGM            =SIMP(statut='o',typ=cham_elem),
     VARI            =SIMP(statut='o',typ=cham_elem),
     INCREMENT       =FACT(statut='o',
          LIST_INST       =SIMP(statut='o',typ=listr8_sdaster),
          NUME_ORDRE      =SIMP(statut='o',typ='I'),),
     COMP_INCR       =C_COMP_INCR(),
     COMP_ELAS       =FACT(statut='f',max='**',
          RESI_INTE_RELA  =SIMP(statut='f',typ='R',defaut= 1.0E-6),
          ITER_INTE_MAXI  =SIMP(statut='f',typ='I',defaut= 10 ),
          ITER_INTE_PAS   =SIMP(statut='f',typ='I',defaut= 0 ),
          RESO_INTE       =SIMP(statut='f',typ='TXM',defaut="IMPLICITE",
                                into=("RUNGE_KUTTA_2","RUNGE_KUTTA_4","IMPLICITE")),
          RELATION        =SIMP(statut='o',typ='TXM',defaut="ELAS",
                                into=("ELAS","ELAS_VMIS_LINE","ELAS_VMIS_TRAC",
                                     "ELAS_POUTRE_GR","CABLE","ELAS_HYPER")),
          DEFORMATION     =SIMP(statut='f',typ='TXM',defaut="PETIT" ,into=("PETIT","GREEN","GREEN_GR",) ),),
     INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
) ;

#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE PELLET J.PELLET
def calc_vect_elem_prod(OPTION,**args):
  if OPTION == "CHAR_MECA" :      return vect_elem_depl_r
  if OPTION == "CHAR_THER" :      return vect_elem_temp_r
  if OPTION == "CHAR_ACOU" :      return vect_elem_pres_c
  if OPTION == "FORC_NODA" :      return vect_elem_depl_r
  raise AsException("type de concept resultat non prevu")

CALC_VECT_ELEM=OPER(nom="CALC_VECT_ELEM",op=8,sd_prod=calc_vect_elem_prod,reentrant='n',
            UIinfo={"groupes":("Matrices/vecteurs",)},
                    fr="Calcul des seconds membres lmentaires",
         OPTION          =SIMP(statut='o',typ='TXM',into=("CHAR_MECA","CHAR_THER","CHAR_ACOU",
                                                           "FORC_NODA") ),
         b_char_meca     =BLOC(condition = "OPTION=='CHAR_MECA'",
           regles=(AU_MOINS_UN('CHARGE','MODELE'),),
           CHARGE          =SIMP(statut='f',typ=char_meca,validators=NoRepeat(),max='**'),
           MODELE          =SIMP(statut='f',typ=modele_sdaster),
           b_charge     =BLOC(condition = "CHARGE != None", fr="modle ne contenant pas de sous-structure",
              CHAM_MATER   =SIMP(statut='f',typ=cham_mater),
              CARA_ELEM    =SIMP(statut='f',typ=cara_elem),
              INST         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
              MODE_FOURIER =SIMP(statut='f',typ='I',defaut= 0 ),
           ),  
           b_modele     =BLOC(condition = "(MODELE != None)",fr="modle contenant une sous-structure",
              SOUS_STRUC      =FACT(statut='o',min=01,
                regles=(UN_PARMI('TOUT','SUPER_MAILLE'),),
                CAS_CHARGE  =SIMP(statut='o',typ='TXM' ),
                TOUT        =SIMP(statut='f',typ='TXM',into=("OUI",) ),
                SUPER_MAILLE=SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**',),
              ),
           ),
         ),
         b_char_ther     =BLOC(condition = "OPTION=='CHAR_THER'",
           CARA_ELEM        =SIMP(statut='f',typ=cara_elem),
           CHARGE           =SIMP(statut='o',typ=char_ther,validators=NoRepeat(),max='**'),
           INST             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
         ),
              
         b_char_acou     =BLOC(condition = "OPTION=='CHAR_ACOU'",
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater),
           CHARGE            =SIMP(statut='o',typ=char_acou,validators=NoRepeat(),max='**'),
         ),
         
         b_forc_noda     =BLOC(condition = "OPTION=='FORC_NODA'",
           SIEF_ELGA         =SIMP(statut='o',typ=cham_elem),
           CARA_ELEM         =SIMP(statut='f',typ=cara_elem),
           MODELE            =SIMP(statut='f',typ=modele_sdaster),
         ),       
) ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
COMB_FOURIER=OPER(nom="COMB_FOURIER",op= 161,sd_prod=comb_fourier,
                  reentrant='n',fr="Recombiner les modes de Fourier d'une SD Rsultat dans des directions particulires",
            UIinfo={"groupes":("Post traitements",)},
         RESULTAT        =SIMP(statut='o',typ=(fourier_elas,fourier_ther),),
         ANGL            =SIMP(statut='o',typ='R',max='**'),
         NOM_CHAM        =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=6,
             into=("DEPL","REAC_NODA","SIEF_ELGA_DEPL","EPSI_ELNO_DEPL","SIGM_ELNO_DEPL","TEMP","FLUX_ELNO_TEMP"),),
) ;
#& MODIF COMMANDE  DATE 08/12/2008   AUTEUR SELLENET N.SELLENET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE SELLENET N.SELLENET
def comb_matr_asse_prod(COMB_R,COMB_C,CALC_AMOR_GENE,**args):
  if COMB_C != None:
    type_mat = AsType(COMB_C[0]['MATR_ASSE'])
    if type_mat in  (matr_asse_depl_c,matr_asse_depl_r) : return matr_asse_depl_c
    if type_mat in  (matr_asse_gene_c,matr_asse_gene_r) : return matr_asse_gene_c
    if type_mat in  (matr_asse_temp_c,matr_asse_temp_r) : return matr_asse_temp_c
    if type_mat in  (matr_asse_pres_c,matr_asse_pres_r) : return matr_asse_pres_c
  elif COMB_R != None:
    type_mat = AsType(COMB_R[0]['MATR_ASSE'])
    if type_mat in  (matr_asse_depl_c,matr_asse_depl_r) : return matr_asse_depl_r
    if type_mat in  (matr_asse_temp_c,matr_asse_temp_r) : return matr_asse_temp_r
    if type_mat in  (matr_asse_pres_c,matr_asse_pres_r) : return matr_asse_pres_r
    if type_mat in  (matr_asse_gene_c,matr_asse_gene_r) : return matr_asse_gene_r
  elif CALC_AMOR_GENE != None: return matr_asse_gene_r
  raise AsException("type de concept resultat non prevu")

COMB_MATR_ASSE=OPER(nom="COMB_MATR_ASSE",op=  31,sd_prod=comb_matr_asse_prod,
                    fr="Effectuer la combinaison linaire de matrices assembles",
                    reentrant='f',
            UIinfo={"groupes":("Rsultats et champs",)},
         regles=(UN_PARMI('COMB_R','COMB_C','CALC_AMOR_GENE' ),),
         COMB_R          =FACT(statut='f',max='**',
           PARTIE          =SIMP(statut='f',typ='TXM',into=("REEL","IMAG") ),
           MATR_ASSE       =SIMP(statut='o',typ=(matr_asse_depl_r,matr_asse_depl_c,matr_asse_temp_r,matr_asse_temp_c
                                                ,matr_asse_pres_r,matr_asse_pres_c,matr_asse_gene_r,matr_asse_gene_c ) ),
           COEF_R          =SIMP(statut='o',typ='R' ),
         ),
         COMB_C          =FACT(statut='f',max='**',
           regles=(UN_PARMI('COEF_R','COEF_C' ),),
           MATR_ASSE       =SIMP(statut='o',typ=(matr_asse_depl_r,matr_asse_depl_c,matr_asse_temp_r,matr_asse_temp_c
                                                ,matr_asse_pres_r,matr_asse_pres_c,matr_asse_gene_r,matr_asse_gene_c ) ),
           COEF_R          =SIMP(statut='f',typ='R' ),
           COEF_C          =SIMP(statut='f',typ='C' ),
         ),
         CALC_AMOR_GENE   =FACT(statut='f',
           RIGI_GENE    = SIMP(statut='o', typ=matr_asse_gene_r),
           MASS_GENE    = SIMP(statut='o', typ=matr_asse_gene_r),
           regles=(UN_PARMI('AMOR_REDUIT','LIST_AMOR' ),),
           AMOR_REDUIT  = SIMP(statut='f',typ='R',max='**'),
           LIST_AMOR    = SIMP(statut='f',typ=listr8_sdaster ),
         ),
         SANS_CMP        =SIMP(statut='f',typ='TXM',into=("LAGR",) ),
)  ;
#& MODIF COMMANDE  DATE 12/11/2009   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE AUDEBERT S.AUDEBERT
COMB_SISM_MODAL=OPER(nom="COMB_SISM_MODAL",op= 109,sd_prod=mode_stat,
                     fr="Rponse sismique par recombinaison modale par une mthode spectrale",
                     reentrant='n',
            UIinfo={"groupes":("Post traitements",)},
         regles=(EXCLUS('TOUT_ORDRE','NUME_ORDRE','FREQ','NUME_MODE','LIST_FREQ','LIST_ORDRE'),
                 UN_PARMI('AMOR_REDUIT','LIST_AMOR','AMOR_GENE' ),),
         MODE_MECA       =SIMP(statut='o',typ=mode_meca ),
         TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
         NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
         LIST_ORDRE      =SIMP(statut='f',typ=listis_sdaster ),
         NUME_MODE       =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
         FREQ            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
         LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster ),
         b_freq          =BLOC(condition = "FREQ != None or LIST_FREQ != None",
           PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-3 ),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
         ),
         MODE_CORR       =SIMP(statut='f',typ=mode_stat_acce ),
         
         AMOR_REDUIT     =SIMP(statut='f',typ='R',max='**'),
         LIST_AMOR       =SIMP(statut='f',typ=listr8_sdaster ),
         AMOR_GENE       =SIMP(statut='f',typ=matr_asse_gene_r ),
         
         MASS_INER       =SIMP(statut='f',typ=table_sdaster ),
         CORR_FREQ       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         
         EXCIT           =FACT(statut='o',max='**',
           regles=(UN_PARMI('MONO_APPUI','NOEUD','GROUP_NO'),
                   UN_PARMI('AXE','TRI_AXE','TRI_SPEC' ),
                   UN_PARMI('MONO_APPUI','MULTI_APPUI' ),),
           
           MONO_APPUI      =SIMP(statut='f',typ='TXM',into=("OUI",),
                                 fr="excitation impose unique" ),
           MULTI_APPUI =SIMP(statut='f',typ='TXM',into=("CORRELE","DECORRELE",),
                                 fr="excitations dcorrls en multi-appuis: cumul sur les modes puis sur les appuis" ),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           AXE             =SIMP(statut='f',typ='R',max=3,fr="Excitation suivant un seul axe",),
           TRI_AXE         =SIMP(statut='f',typ='R',max=3,fr="Excitation suivant les trois axes mais avec le meme spectre",),
           TRI_SPEC        =SIMP(statut='f',typ='TXM',into=("OUI",),
                                 fr="Excitation suivant les trois axes  avec trois spectres"),
           b_axe           =BLOC(condition = "AXE != None",fr="Excitation suivant un seul axe",
             SPEC_OSCI       =SIMP(statut='o',typ=(nappe_sdaster,formule),),
             ECHELLE         =SIMP(statut='f',typ='R',),
           ),
           b_tri_axe       =BLOC(condition = "TRI_AXE != None",fr="Excitation suivant les trois axes mais avec le meme spectre",
             SPEC_OSCI       =SIMP(statut='o',typ=(nappe_sdaster,formule),),
             ECHELLE         =SIMP(statut='f',typ='R',),
           ),
           b_tri_spec      =BLOC(condition = "TRI_SPEC != None",fr="Excitation suivant les trois axes  avec trois spectres",
             SPEC_OSCI       =SIMP(statut='o',typ=(nappe_sdaster,formule),min=3,max=3 ),
             ECHELLE         =SIMP(statut='f',typ='R',min=3,max=3),
           ),       
           NATURE          =SIMP(statut='f',typ='TXM',defaut="ACCE",into=("ACCE","VITE","DEPL") ),
         ),
         COMB_MODE       =FACT(statut='o',
           TYPE            =SIMP(statut='o',typ='TXM',into=("SRSS","CQC","DSC","ABS","DPC") ),
           DUREE           =SIMP(statut='f',typ='R' ),
         ),
         COMB_DIRECTION  =FACT(statut='f',
           TYPE            =SIMP(statut='f',typ='TXM',into=("QUAD","NEWMARK") ),
         ),
         COMB_MULT_APPUI =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','NOEUD','GROUP_NO' ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           TYPE_COMBI      =SIMP(statut='f',typ='TXM',into=("QUAD","LINE",) ),
         ),
         COMB_DEPL_APPUI=FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','LIST_CAS'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",)),
           LIST_CAS       =SIMP(statut='f',typ='I',max='**'),
           TYPE_COMBI      =SIMP(statut='f',typ='TXM',into=("QUAD","LINE","ABS") ),
         ),
         DEPL_MULT_APPUI =FACT(statut='f',max='**',
           regles=(UN_PARMI('NOEUD','GROUP_NO'),
                   AU_MOINS_UN('DX','DY','DZ' ),),
           NOM_CAS         =SIMP(statut='o',typ='TXM',max='**'),
           NUME_CAS        =SIMP(statut='o',typ='I',max='**'),
           MODE_STAT       =SIMP(statut='f',typ=(mode_stat_depl,), ),
           NOEUD_REFE      =SIMP(statut='f',typ=no),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           DX              =SIMP(statut='f',typ='R' ),
           DY              =SIMP(statut='f',typ='R' ),
           DZ              =SIMP(statut='f',typ='R' ),
         ),
         OPTION          =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=9,
                               into=("DEPL","VITE","ACCE_ABSOLU","SIGM_ELNO_DEPL","SIEF_ELGA_DEPL",
                                     "EFGE_ELNO_DEPL","REAC_NODA","FORC_NODA","EFGE_ELNO_CART",
                                     "SIPO_ELNO_DEPL") ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2 ) ),
         IMPRESSION      =FACT(statut='f',max='**',
           regles=(EXCLUS('TOUT','NIVEAU'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           NIVEAU          =SIMP(statut='f',typ='TXM',into=("SPEC_OSCI","MASS_EFFE","MAXI_GENE"),validators=NoRepeat(),max=3 ),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 30/09/2008   AUTEUR REZETTE C.REZETTE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
def crea_champ_prod(TYPE_CHAM,**args):
  if TYPE_CHAM[0:5] == "CART_" :
     return carte_sdaster
  elif TYPE_CHAM[0:5] == "NOEU_" :
     return cham_no_sdaster
  elif TYPE_CHAM[0:2] == "EL"    :
     return cham_elem
  else :
     raise AsException("type de concept resultat_sdaster non prevu")


CREA_CHAMP=OPER(nom="CREA_CHAMP",op= 195,sd_prod=crea_champ_prod,
                fr="Cration d'un champ ",reentrant='f',
            UIinfo={"groupes":("Rsultats et champs",)},
         TYPE_CHAM       =SIMP(statut='o',typ='TXM',into=C_TYPE_CHAM_INTO()),
      # TYPE_CHAM doit etre de la forme : CART_xx, NOEU_xx, ELEM_xx, ELGA_xx ou ELNO_xx
      # ou xx est le nom d'une grandeur dfinie dans le catalogue des grandeurs
#        SI CREATION D'UN CHAM_NO, POUR IMPOSER LA NUMEROTATION DES DDLS :
#        ------------------------------------------------------------------
         regles=(EXCLUS('NUME_DDL','CHAM_NO',)),
         NUME_DDL        =SIMP(statut='f',typ=(nume_ddl_sdaster) ),
         CHAM_NO         =SIMP(statut='f',typ=(cham_no_sdaster) ),

#        SI CREATION D'UN CHAM_ELEM, POUR aider a l'allocation du champ :
#        (PAR DEFAUT : TOU_INI_ELNO/_ELGA/_ELEM)
#        ------------------------------------------------------------------
         OPTION         =SIMP(statut='f',typ='TXM'),

         OPERATION       =SIMP(statut='o',typ='TXM',into=("AFFE","ASSE","EVAL","EXTR","DISC","NORMALE","R2C","C2R") ),

#        ------------------------------------------------------------------
         b_norm          =BLOC(condition = "OPERATION == 'NORMALE'",
                               regles=(AU_MOINS_UN('GROUP_MA','MAILLE',),),
             MODELE          =SIMP(statut='o',typ=(modele_sdaster) ),
             GROUP_MA        =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
                             ),
#        ------------------------------------------------------------------
         b_affe          =BLOC(condition = "OPERATION == 'AFFE'",
             regles=(UN_PARMI('MAILLAGE','MODELE'),),
             MAILLAGE        =SIMP(statut='f',typ=(maillage_sdaster) ),
             MODELE          =SIMP(statut='f',typ=(modele_sdaster) ),
             b_affe_modele   =BLOC(condition = "MODELE != None",
                 PROL_ZERO       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ), ),
             AFFE            =FACT(statut='o',max='**',
                regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD',),
                        UN_PARMI('VALE','VALE_I','VALE_C','VALE_F', ),),
                TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
                GROUP_MA        =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max='**'),
                MAILLE          =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
                GROUP_NO        =SIMP(statut='f',typ=grno ,validators=NoRepeat(),max='**'),
                NOEUD           =SIMP(statut='f',typ=no   ,validators=NoRepeat(),max='**'),
                NOM_CMP         =SIMP(statut='o',typ='TXM',max='**'),
                VALE            =SIMP(statut='f',typ='R',max='**' ),
                VALE_I          =SIMP(statut='f',typ='I',max='**' ),
                VALE_C          =SIMP(statut='f',typ='C',max='**' ),
                VALE_F          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),max='**'),
                                   ),
                             ),
#        ------------------------------------------------------------------
         b_asse          =BLOC(condition = "OPERATION == 'ASSE'",
             regles=(UN_PARMI('MAILLAGE','MODELE'),),
             MAILLAGE        =SIMP(statut='f',typ=(maillage_sdaster) ),
             MODELE          =SIMP(statut='f',typ=(modele_sdaster) ),
             b_asse_modele   =BLOC(condition = "MODELE != None",
                 PROL_ZERO       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ), ),
             ASSE            =FACT(statut='o',max='**',
                regles=(AU_MOINS_UN('TOUT','GROUP_MA','GROUP_NO','MAILLE','NOEUD',),
                PRESENT_PRESENT('NOM_CMP_RESU','NOM_CMP', ),),
                TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
                GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                CHAM_GD         =SIMP(statut='o',typ=cham_gd_sdaster),
                NOM_CMP         =SIMP(statut='f',typ='TXM',max='**' ),
                NOM_CMP_RESU    =SIMP(statut='f',typ='TXM',max='**' ),
                CUMUL           =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ),
                COEF_R          =SIMP(statut='f',typ='R',defaut= 1. ),
                COEF_C          =SIMP(statut='f',typ='C',max=1),
                                    ),
                             ),
#        ------------------------------------------------------------------
         b_eval          =BLOC(condition = "OPERATION == 'EVAL'",
             CHAM_F          =SIMP(statut='o',typ=cham_gd_sdaster),
             CHAM_PARA       =SIMP(statut='o',typ=cham_gd_sdaster,max='**'),
                             ),
#        ------------------------------------------------------------------
         b_r2c           =BLOC(condition = "OPERATION == 'R2C'",
             CHAM_GD          =SIMP(statut='o',typ=cham_gd_sdaster),
                             ),
#        ------------------------------------------------------------------
         b_c2r           =BLOC(condition = "OPERATION == 'C2R'",
             CHAM_GD          =SIMP(statut='o',typ=cham_gd_sdaster),
             PARTIE           =SIMP(statut='o',typ='TXM',into=('REEL','IMAG','MODULE','PHASE'),),
                             ),
#        ------------------------------------------------------------------
         b_disc          =BLOC(condition = "OPERATION == 'DISC'",
             MODELE          =SIMP(statut='f',typ=(modele_sdaster) ),
             PROL_ZERO       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ),
             CHAM_GD         =SIMP(statut='o',typ=cham_gd_sdaster),
                             ),
#        ------------------------------------------------------------------
         b_extr          =BLOC(condition = "OPERATION == 'EXTR'",
             regles=(AU_MOINS_UN('MAILLAGE','FISSURE','RESULTAT','TABLE'),),
             MAILLAGE        =SIMP(statut='f',typ=(maillage_sdaster) ),
             FISSURE         =SIMP(statut='f',typ=(fiss_xfem) ),
             RESULTAT        =SIMP(statut='f',typ=(resultat_sdaster) ),
             TABLE           =SIMP(statut='f',typ=(table_sdaster),min=1,max=1),
             b_extr_maillage =BLOC(condition = "MAILLAGE != None and TABLE == None",
                 NOM_CHAM        =SIMP(statut='o',typ='TXM',into=("GEOMETRIE",)),
             ),
             b_extr_fissure  =BLOC(condition = "FISSURE != None",
                 NOM_CHAM        =SIMP(statut='o',typ='TXM',into=("LTNO","LNNO","GRLTNO","GRLNNO","STNO","STNOR","BASLOC")),
             ),
             b_extr_table    =BLOC(condition = "TABLE != None",
                      regles=( EXCLUS('MODELE','MAILLAGE'),
                               EXCLUS('PROL_ZERO','MAILLAGE'),),
                      MAILLAGE        =SIMP(statut='f',typ=(maillage_sdaster),),
                      MODELE          =SIMP(statut='f',typ=(modele_sdaster),),
                      OPTION          =SIMP(statut='f',typ='TXM'),
                      PROL_ZERO       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ),
                 ),
             b_extr_resultat =BLOC(condition = "RESULTAT != None",
                 regles=(DERIVABLE('RESULTAT'),),
                 SENSIBILITE     =SIMP(statut='f',typ=(para_sensi,theta_geom),
                                   fr="Paramtre de sensibilit.",
                                   ang="Sensitivity parameter"),
                 NOM_CHAM        =SIMP(statut='o',typ='TXM',into=C_NOM_CHAM_INTO()),
                 TYPE_MAXI       =SIMP(statut='f',typ='TXM',into=("MAXI","MINI","MAXI_ABS","MINI_ABS","NORM_TRAN",) ),

                 # si TYPE_MAXI, on spcifie en gnral plusieurs numros d'ordre :
                 b_type_maxi =BLOC(condition = "TYPE_MAXI != None",
                      TYPE_RESU       =SIMP(statut='o',typ='TXM',defaut="VALE",into=("VALE","INST",) ),

                      regles=(EXCLUS('TOUT_ORDRE','LIST_INST','LIST_FREQ','NUME_ORDRE','INST',
                                      'FREQ','NUME_MODE','NOEUD_CMP','NOM_CAS','ANGL'),),
                      TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
                      LIST_INST       =SIMP(statut='f',typ=(listr8_sdaster) ),
                      LIST_FREQ       =SIMP(statut='f',typ=(listr8_sdaster) ),
                      NUME_ORDRE      =SIMP(statut='f',typ='I',max='**'),
                      INST            =SIMP(statut='f',typ='R',max='**'),
                      FREQ            =SIMP(statut='f',typ='R',max='**'),
                      NUME_MODE       =SIMP(statut='f',typ='I',max='**'),
                      NOEUD_CMP       =SIMP(statut='f',typ='TXM',max='**'),
                      NOM_CAS         =SIMP(statut='f',typ='TXM',max='**'),
                      ANGL            =SIMP(statut='f',typ='R',max='**'),
                 ),

                 # si .not. TYPE_MAXI, on ne doit spcifier qu'un seul numro d'ordre :
                 b_non_type_maxi =BLOC(condition = "TYPE_MAXI == None",
                      regles=(EXCLUS('NUME_ORDRE','INST','FREQ','NUME_MODE','NOEUD_CMP','NOM_CAS','ANGL'),),
                      NUME_ORDRE      =SIMP(statut='f',typ='I'),
                      INST            =SIMP(statut='f',typ='R'),
                      FREQ            =SIMP(statut='f',typ='R'),
                      NUME_MODE       =SIMP(statut='f',typ='I'),
                      NOEUD_CMP       =SIMP(statut='f',typ='TXM',max=2),
                      NOM_CAS         =SIMP(statut='f',typ='TXM'),
                      ANGL            =SIMP(statut='f',typ='R'),

                      INTERPOL        =SIMP(statut='f',typ='TXM',defaut="NON",into=("NON","LIN",) ),
                 ),

                 CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",) ),
                 b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                     PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
                 b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                     PRECISION       =SIMP(statut='o',typ='R',),),

         ),  # fin bloc b_extr


               ),
# FIN DU CATALOGUE : INFO,TITRE ET TYPAGE DU RESULTAT :
#-----------------------------------------------------
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=(1,2,) ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**' ),
)  ;
#& MODIF COMMANDE  DATE 30/06/2008   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
CREA_MAILLAGE=OPER(nom="CREA_MAILLAGE",op= 167,sd_prod=maillage_sdaster,
            reentrant='n',fr="Cre un maillage  partir d'un maillage existant",
            UIinfo={"groupes":("Maillage",)},
         regles=(EXCLUS('COQU_VOLU', 'CREA_FISS', 'CREA_GROUP_MA', 'CREA_MAILLE', 'CREA_POI1',
                        'DETR_GROUP_MA', 'ECLA_PG', 'HEXA20_27', 'LINE_QUAD', 'MODI_MAILLE',
                        'QUAD_LINE', 'REPERE','RESTREINT'),),



         # le MAILLAGE est inutile si ECLA_PG
         MAILLAGE        =SIMP(statut='f',typ=maillage_sdaster ),

         CREA_POI1       =FACT(statut='f',max='**',fr="Cration de mailles de type POI1  partir de noeuds",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD' ),),
           NOM_GROUP_MA    =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
         ),
         CREA_MAILLE     =FACT(statut='f',max='**',fr="Duplication de mailles",
           regles=(AU_MOINS_UN('TOUT','MAILLE','GROUP_MA'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           PREF_MAILLE     =SIMP(statut='o',typ='TXM' ),
           PREF_NUME       =SIMP(statut='f',typ='I' ),
         ),
         CREA_GROUP_MA   =FACT(statut='f',max='**',fr="Duplication de mailles et cration de groupes de mailles",
           regles=(AU_MOINS_UN('TOUT','MAILLE','GROUP_MA' ),),
           NOM             =SIMP(statut='o',typ='TXM'),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           PREF_MAILLE     =SIMP(statut='o',typ='TXM' ),
           PREF_NUME       =SIMP(statut='f',typ='I' ),
         ),
         DETR_GROUP_MA   =FACT(statut='f',fr="Destruction de groupes de mailles",
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           NB_MAILLE       =SIMP(statut='f',typ='I',defaut= 0,
                                 fr="Nombre minimal de mailles que doit contenir le groupe pour etre dtruit",  ),
         ),
         RESTREINT   =FACT(statut='f',fr="Restreindre un maillage  des groupes de mailles",max=1,
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE',),),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
           TOUT_GROUP_MA   =SIMP(statut='f',typ='TXM',defaut='NON',into=('OUI','NON'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           TOUT_GROUP_NO   =SIMP(statut='f',typ='TXM',defaut='NON',into=('OUI','NON'),),
         ),
         COQU_VOLU   =FACT(statut='f',
                           fr="Creation de mailles volumiques  partir de mailles surfaciques",
           NOM             =SIMP(statut='o',typ='TXM'),
           GROUP_MA        =SIMP(statut='o',typ=grma,validators=NoRepeat(),max ='**'),
           EPAIS           =SIMP(statut='o',typ='R' ),
           PREF_MAILLE     =SIMP(statut='f',typ='TXM',defaut="MS" ),
           PREF_NOEUD      =SIMP(statut='f',typ='TXM',defaut="NS" ),
           PREF_NUME       =SIMP(statut='f',typ='I'  ,defaut=1 ),
           PLAN            =SIMP(statut='o',typ='TXM',into=("SUP","MOY","INF")),
           b_MOY =BLOC(condition = "PLAN == 'MOY'",
             TRANSLATION   =SIMP(statut='o',typ='TXM',into=("SUP","INF") ),
           ),
         ),
         MODI_MAILLE     =FACT(statut='f',max='**',fr="Modification du type de mailles",
           regles=(AU_MOINS_UN('TOUT','MAILLE','GROUP_MA' ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma  ,validators=NoRepeat(),max='**'),
           OPTION          =SIMP(statut='o',typ='TXM',into=("TRIA6_7","QUAD8_9","SEG3_4","QUAD_TRIA3"),
                                 fr="Choix de la transformation" ),
           b_NOS =BLOC(condition = "OPTION == 'TRIA6_7'  or  OPTION == 'QUAD8_9'  or  OPTION == 'SEG3_4'",
             PREF_NOEUD      =SIMP(statut='f',typ='TXM',defaut="NS"),
             PREF_NUME       =SIMP(statut='f',typ='I',defaut= 1 ),
           ),
           b_QTR =BLOC(condition = "OPTION == 'QUAD_TRIA3'",
             PREF_MAILLE     =SIMP(statut='f',typ='TXM',defaut="MS" ),
             PREF_NUME       =SIMP(statut='f',typ='I',defaut= 1 ),
           ),
         ),
         CREA_FISS = FACT(statut='f',max='**',fr="Creation d'une fissure potentielle avec elts de joint ou elts  disc",
           NOM             =SIMP(statut='o',typ='TXM'),
           GROUP_NO_1      =SIMP(statut='o',typ=grno),
           GROUP_NO_2      =SIMP(statut='o',typ=grno),
           PREF_MAILLE     =SIMP(statut='o',typ='TXM'),
           PREF_NUME       =SIMP(statut='f',typ='I',defaut=1 ),
         ),
         LINE_QUAD     =FACT(statut='f',fr="Passage linaire -> quadratique",
           regles=(AU_MOINS_UN('TOUT','MAILLE','GROUP_MA' ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma  ,validators=NoRepeat(),max='**'),
           PREF_NOEUD      =SIMP(statut='f',typ='TXM',defaut="NS"),
           PREF_NUME       =SIMP(statut='f',typ='I',defaut= 1 ),
         ),
         HEXA20_27     =FACT(statut='f',fr="Passage HEXA20 -> HEXA27",
           regles=(AU_MOINS_UN('TOUT','MAILLE','GROUP_MA' ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma  ,validators=NoRepeat(),max='**'),
           PREF_NOEUD      =SIMP(statut='f',typ='TXM',defaut="NS"),
           PREF_NUME       =SIMP(statut='f',typ='I',defaut= 1 ),
         ),
         QUAD_LINE     =FACT(statut='f',fr="Passage quadratique -> linaire",
           regles=(AU_MOINS_UN('TOUT','MAILLE','GROUP_MA' ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma  ,validators=NoRepeat(),max='**'),
         ),
         REPERE          =FACT(statut='f',max='**',
                               fr="changement de repre servant  dterminer les caractristiques d'une section de poutre",
           TABLE           =SIMP(statut='o',typ=table_sdaster,
                                 fr="Nom de la table contenant les caractristiques de la section de poutre" ),
           NOM_ORIG        =SIMP(statut='f',typ='TXM',into=("CDG","TORSION"),fr="Origine du nouveau repre" ),
           NOM_ROTA        =SIMP(statut='f',typ='TXM',into=("INERTIE",),fr="Direction du repre"  ),
           b_cdg =BLOC(condition = "NOM_ORIG == 'CDG'",
             GROUP_MA        =SIMP(statut='f',typ=grma,
                                   fr="Nom du groupe de mailles dont le centre de gravit sera l origine du nouveau repre"),
           ),
         ),
         ECLA_PG         =FACT(statut='f',
                               fr="Eclatement des mailles en petites mailles contenant chacune un seul point de gauss",
           MODELE          =SIMP(statut='o',typ=modele_sdaster ),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           SHRINK          =SIMP(statut='f',typ='R',defaut= 0.9, fr="Facteur de rduction" ),
           TAILLE_MIN      =SIMP(statut='f',typ='R',defaut= 0.0, fr="Taille minimale d'un cot" ),
           NOM_CHAM        =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**'),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
#
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 20/10/2008   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE
def crea_resu_prod(TYPE_RESU,**args):
  if TYPE_RESU == "EVOL_ELAS"    : return evol_elas
  if TYPE_RESU == "EVOL_NOLI"    : return evol_noli
  if TYPE_RESU == "EVOL_THER"    : return evol_ther
  if TYPE_RESU == "MULT_ELAS"    : return mult_elas
  if TYPE_RESU == "MODE_MECA"    : return mode_meca
  if TYPE_RESU == "FOURIER_ELAS" : return fourier_elas
  if TYPE_RESU == "FOURIER_THER" : return fourier_ther
  if TYPE_RESU == "EVOL_VARC"    : return evol_varc
  if TYPE_RESU == "EVOL_CHAR"    : return evol_char
  raise AsException("type de concept resultat non prevu")

CREA_RESU=OPER(nom="CREA_RESU",op=124,sd_prod=crea_resu_prod,reentrant='f',
            UIinfo={"groupes":("Modlisation",)},
               fr="Crer ou enrichir une structure de donnees resultat  partir de champs aux noeuds",

         OPERATION =SIMP(statut='o',typ='TXM',into=("AFFE","ASSE","ECLA_PG","PERM_CHAM","PROL_RTZ","PREP_VRC1","PREP_VRC2",),
                         fr="choix de la fonction a activer",),


         # Cration par affectation de champs :
         #-------------------------------------
         b_affe       =BLOC(condition = "OPERATION == 'AFFE'",

           TYPE_RESU    =SIMP(statut='o',position='global',typ='TXM',into=("MODE_MECA","MULT_ELAS","EVOL_ELAS","EVOL_NOLI",
                                                        "FOURIER_ELAS","EVOL_THER","EVOL_VARC","EVOL_CHAR","FOURIER_THER") ),
           NOM_CHAM     =SIMP(statut='o',typ='TXM',into=C_NOM_CHAM_INTO()),

           b_mode       =BLOC(condition = "TYPE_RESU == 'MODE_MECA'",
             MATR_A         =SIMP(statut='f',typ=matr_asse_depl_r,),
             MATR_B         =SIMP(statut='f',typ=matr_asse_depl_r,),
           ),

           AFFE         =FACT(statut='o',max='**',
             CHAM_GD       =SIMP(statut='o',typ=(cham_gd_sdaster)),
             MODELE        =SIMP(statut='f',typ=modele_sdaster),
             CHAM_MATER    =SIMP(statut='f',typ=cham_mater),
             CARA_ELEM     =SIMP(statut='f',typ=cara_elem),

             b_mult_elas     =BLOC(condition = "TYPE_RESU == 'MULT_ELAS' ",
                NOM_CAS         =SIMP(statut='f',typ='TXM' ),
             ),
             b_evol          =BLOC(condition = "((TYPE_RESU=='EVOL_ELAS') or (TYPE_RESU=='EVOL_NOLI') or (TYPE_RESU=='EVOL_THER')\
                                                                          or (TYPE_RESU=='EVOL_VARC') or (TYPE_RESU=='EVOL_CHAR'))",
                regles=(UN_PARMI('INST','LIST_INST'),),
                INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
                LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
                NUME_INIT       =SIMP(statut='f',typ='I', val_min=1),
                NUME_FIN        =SIMP(statut='f',typ='I', val_min=1),
                PRECISION       =SIMP(statut='f',typ='R',defaut= 0.0 ),
                CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
             ),
             b_fourier       =BLOC(condition = "((TYPE_RESU == 'FOURIER_ELAS') or (TYPE_RESU == 'FOURIER_THER')) ",
                NUME_MODE       =SIMP(statut='f',typ='I'),
                TYPE_MODE       =SIMP(statut='f',typ='TXM',defaut="SYME",into=("SYME","ANTI","TOUS") ),
             ),
             b_mode       =BLOC(condition = "TYPE_RESU == 'MODE_MECA'",
                NUME_MODE       =SIMP(statut='f',typ='I'),
                FREQ            =SIMP(statut='f',typ='R'),
             ),
           ),
         ),


         # Cration par assemblage d'evol_ther :
         #-----------------------------------------
         b_asse       =BLOC(condition = "OPERATION == 'ASSE'",
           TYPE_RESU    =SIMP(statut='o',position='global',typ='TXM',into=("EVOL_THER",) ),
           ASSE         =FACT(statut='o',max='**',
             RESULTAT       =SIMP(statut='o',typ=evol_ther),
             TRANSLATION    =SIMP(statut='f',typ='R',defaut= 0. ),
           ),
         ),


         b_ecla_pg    =BLOC(condition = "OPERATION == 'ECLA_PG'",

           TYPE_RESU       =SIMP(statut='o',typ='TXM',into=("EVOL_ELAS","EVOL_NOLI","EVOL_THER"), ),

           ECLA_PG         =FACT(statut='o',
             regles=(EXCLUS('TOUT_ORDRE','NUME_ORDRE','INST','LIST_INST','LIST_ORDRE'),),
             NOM_CHAM        =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**'),
             MODELE_INIT     =SIMP(statut='o',typ=modele_sdaster),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             RESU_INIT       =SIMP(statut='o',typ=resultat_sdaster),
             MAILLAGE        =SIMP(statut='o',typ=maillage_sdaster),
             TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
             LIST_ORDRE      =SIMP(statut='f',typ=listis_sdaster),
             INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
             LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
             CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",),),
             b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                 PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
             b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                 PRECISION       =SIMP(statut='o',typ='R',),),
           ),
         ),


         b_perm_cham =BLOC(condition = "OPERATION == 'PERM_CHAM'",

           TYPE_RESU       =SIMP(statut='o',typ='TXM',into=("EVOL_NOLI",) ),
           NOM_CHAM        =SIMP(statut='f',typ='TXM',into=("DEPL","SIEF_ELGA","VARI_ELGA",),validators=NoRepeat(),max='**' ),
           RESU_INIT       =SIMP(statut='o',typ=evol_noli),
           INST_INIT       =SIMP(statut='f',typ='R'),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",),),
           b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
               PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
           b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
               PRECISION       =SIMP(statut='o',typ='R',),),
           MAILLAGE_INIT   =SIMP(statut='o',typ=maillage_sdaster,),
           RESU_FINAL      =SIMP(statut='o',typ=evol_noli,),
           MAILLAGE_FINAL  =SIMP(statut='o',typ=maillage_sdaster,),
           PERM_CHAM       =FACT(statut='o',max='**',
              GROUP_MA_FINAL =SIMP(statut='o',typ=grma),
              GROUP_MA_INIT  =SIMP(statut='o',typ=grma),
              TRAN           =SIMP(statut='o',typ='R',min=3,max=3),
              PRECISION      =SIMP(statut='f',typ='R',defaut=1.0E-3),
           ),
         ),

         b_prol_rtz   =BLOC(condition = "OPERATION == 'PROL_RTZ'",

           TYPE_RESU       =SIMP(statut='o',typ='TXM',into=("EVOL_THER",) ),

           PROL_RTZ        =FACT(statut='o',
              regles=(EXCLUS('INST','LIST_INST'),),
              MAILLAGE_FINAL  =SIMP(statut='o',typ=maillage_sdaster,),
              TABLE           =SIMP(statut='o',typ=table_sdaster,fr="Table issue de post_releve_t"),
              INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
              LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
              b_acce_reel     =BLOC(condition="(INST != None)or(LIST_INST != None)",
                 CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",),),
                 b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                     PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
                 b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                     PRECISION       =SIMP(statut='o',typ='R',),),
              ),
              PROL_DROITE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU",),),
              PROL_GAUCHE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU",),),
              REPERE          =SIMP(statut='o',typ='TXM',into=("CYLINDRIQUE",),),
              ORIGINE         =SIMP(statut='o',typ='R',min=3,max=3),
              AXE_Z           =SIMP(statut='o',typ='R',min=3,max=3),
           ),
         ),

         b_prep_vrc1      =BLOC(condition = "OPERATION == 'PREP_VRC1'",
           # calculer la temprature dans les couches des coques multicouche  partir d'un champ de fonctions
           # de fonctions du temps et de l'espace (paisseur)

           TYPE_RESU    =SIMP(statut='o',position='global',typ='TXM',into=( "EVOL_THER",) ),

           PREP_VRC1        =FACT(statut='o',max=1,
             CHAM_GD       =SIMP(statut='o',typ=(cham_gd_sdaster)), # carte de fonctions du temps et de l'paisseur
             MODELE        =SIMP(statut='o',typ=modele_sdaster),    # modle mcanique contenant les coques multicouche
             CARA_ELEM     =SIMP(statut='o',typ=cara_elem),         # CARA_ELEM pour connaitre EPAIS et COQU_NCOU
             INST          =SIMP(statut='o',typ='R',validators=NoRepeat(),max='**'),
           ),
         ),

         b_prep_vrc2      =BLOC(condition = "OPERATION == 'PREP_VRC2'",
           # calculer la temprature dans les couches des coques multicouche  partir d'un evol_ther "coque"
           # contenant TEMP/TEMP_INF/TEMP_SUP

           TYPE_RESU    =SIMP(statut='o',position='global',typ='TXM',into=( "EVOL_THER",) ),

           PREP_VRC2        =FACT(statut='o',max=1,
             EVOL_THER     =SIMP(statut='o',typ=(evol_ther)),       # evol_ther de type "coque" (TEMP/TEMP_INF/TEMP_SUP)
             MODELE        =SIMP(statut='o',typ=modele_sdaster),    # modle mcanique contenant les coques multicouche
             CARA_ELEM     =SIMP(statut='o',typ=cara_elem),         # CARA_ELEM pour connaitre EPAIS et COQU_NCOU
           ),
         ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS

def crea_table_prod(TYPE_TABLE, **args):
   """Typage du concept rsultat
   """
   if TYPE_TABLE == 'TABLE_FONCTION':
      return table_fonction
   else:
      return table_sdaster

CREA_TABLE=OPER(nom="CREA_TABLE",op=36,sd_prod=crea_table_prod,
                fr="Cration d'une table  partir d'une fonction ou de deux listes",
                reentrant='f',UIinfo={"groupes":("Table",)},

           regles=(EXCLUS('FONCTION','LISTE'),),

           LISTE=FACT(statut='f',max='**',
                 fr="Creation d'une table a partir de listes",
                 regles=(UN_PARMI('LISTE_I','LISTE_R','LISTE_K')), 
                        PARA     =SIMP(statut='o',typ='TXM'),
                        TYPE_K   =SIMP(statut='f',typ='TXM',defaut='K8',
                                    into=('K8','K16','K24')),
                        NUME_LIGN=SIMP(statut='f',typ='I',max='**'),
                        LISTE_I  =SIMP(statut='f',typ='I',max='**'),
                        LISTE_R  =SIMP(statut='f',typ='R',max='**'),
                        LISTE_K  =SIMP(statut='f',typ='TXM', max='**'),
           ),
           FONCTION=FACT(statut='f',
                    fr="Creation d'une table a partir d'une fonction",
                        FONCTION=SIMP(statut='o',typ=(fonction_c,fonction_sdaster)),
                        PARA=SIMP(statut='f',typ='TXM',min=2,max=2),
           ),
           b_fonction = BLOC(condition='FONCTION != None',
               regles=(CONCEPT_SENSIBLE('SEPARE'), REUSE_SENSIBLE(),
                       DERIVABLE('FONCTION'),),
               SENSIBILITE = SIMP(statut='f',typ=(para_sensi,theta_geom),validators=NoRepeat(),max='**',
                                    fr="Liste des paramtres de sensibilit.",
                                    ang="List of sensitivity parameters"),
           ),
           TYPE_TABLE = SIMP(statut='f', typ='TXM', defaut="TABLE",
                             into=('TABLE', 'TABLE_FONCTION'),),
           
           TITRE=SIMP(statut='f',typ='TXM',max='**'),
)  ;



#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2007  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE

DEBUG=PROC(nom="DEBUG",op=137,
            UIinfo={"groupes":("Utilitaires",)},
               fr="Permettre de changer entre 2 commandes quelques variables globales de debug",

     SDVERI          =SIMP(fr="vrifie la conformit des SD produites par les commandes",
                           statut='f',typ='TXM',into=('OUI','NON')),
     JXVERI          =SIMP(fr="vrifie l intgrit de la segmentation mmoire",
                           statut='f',typ='TXM',into=('OUI','NON')),
     JEVEUX          =SIMP(fr="force les dchargement sur disque",
                           statut='f',typ='TXM',into=('OUI','NON')),
     IMPR_MACRO      =SIMP(fr="affichage des sous-commandes produites par les macros dans le fichier mess",
                           statut='f',typ='TXM',into=("OUI","NON")),
 );
#& MODIF COMMANDE  DATE 07/10/2008   AUTEUR COURTOIS M.COURTOIS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE
DEBUT=MACRO(nom="DEBUT",op=ops.build_debut ,repetable='n',
            UIinfo={"groupes":("Gestion du travail",)},
           fr="Ouverture d'une tude. Allocation des ressources mmoire et disque et fichiers",
          sd_prod=ops.DEBUT,

         PAR_LOT         =SIMP(fr="mode de traitement des commandes",statut='f',typ='TXM',
                           into=("OUI","NON"),defaut="OUI"),
         IMPR_MACRO      =SIMP(fr="affichage des sous-commandes produites par les macros dans le fichier mess",
                           statut='f',typ='TXM',into=("OUI","NON"),defaut="NON"),
#         FORMAT_HDF      =SIMP(fr="sauvegarde de la base GLOBALE au format HDF",statut='f',
#                               typ='TXM',defaut="NON",into=("OUI","NON",) ),
         BASE            =FACT(fr="dfinition des paramtres associs aux bases JEVEUX",
                               statut='f',min=1,max=2,
           FICHIER         =SIMP(fr="nom de la base",statut='o',typ='TXM',
                                 into=('GLOBALE','VOLATILE'),),
           TITRE           =SIMP(statut='f',typ='TXM'),
           CAS             =SIMP(statut='f',typ='TXM'),
           NMAX_ENRE       =SIMP(fr="nombre maximum d enregistrements",statut='f',typ='I'),
           LONG_ENRE       =SIMP(fr="longueur des enregistrements",statut='f',typ='I'),
           LONG_REPE       =SIMP(fr="longueur du rpertoire",statut='f',typ='I'),
         ),

         IMPRESSION      =FACT(statut='f',min=1,max=3,
           FICHIER         =SIMP(statut='o',typ='TXM'),
           UNITE           =SIMP(statut='o',typ='I'),
         ),

         CATALOGUE       =FACT(statut='f',min=1,max=10,
           FICHIER         =SIMP(statut='o',typ='TXM'),
           TITRE           =SIMP(statut='f',typ='TXM'),
           UNITE           =SIMP(statut='f',typ='I'),
         ),

         CODE            =FACT(fr="dfinition d'un nom pour l'ensemble d'une tude",
                               statut='f',min=1,max=1,
           NOM             =SIMP(statut='o',typ='TXM'),
           NIV_PUB_WEB     =SIMP(statut='o',typ='TXM',into=('INTERNET','INTRANET')),
           VISU_EFICAS     =SIMP(statut='f',typ='TXM',into=('OUI','NON'),defaut='OUI'),
         ),

         ERREUR          =FACT(fr="comportement en cas d'erreur",statut='f',min=1,max=1,
           ERREUR_F        =SIMP(statut='f',typ='TXM',into=('ABORT','EXCEPTION'),),
         ),

         DEBUG           =FACT(fr="option de dboggage reserve aux dveloppeurs",
                               statut='f',min=1,max=1,
           JXVERI          =SIMP(fr="vrifie l intgrit de la segmentation mmoire",
                                 statut='f',typ='TXM',into=('OUI','NON'),defaut='NON'),
           SDVERI          =SIMP(fr="vrifie la conformit des SD produites par les commandes",
                                 statut='f',typ='TXM',into=('OUI','NON')),
           JEVEUX          =SIMP(fr="force les dchargement sur disque",
                                 statut='f',typ='TXM',into=('OUI','NON'),defaut='NON'),
           ENVIMA          =SIMP(fr="imprime les valeurs dfinies dans ENVIMA",
                                 statut='f',typ='TXM',into=('TEST',)),
         ),

         MEMOIRE         =FACT(fr="mode de gestion mmoire utilis",statut='d',min=1,max=1,
           GESTION         =SIMP(statut='f',typ='TXM',into=('COMPACTE','RAPIDE'),defaut='RAPIDE'),
           TYPE_ALLOCATION =SIMP(statut='f',typ='I',into=(1,2,3,4),defaut=1),
           TAILLE          =SIMP(statut='f',typ='I'),
           TAILLE_BLOC     =SIMP(statut='f',typ='R',defaut=800.),
           PARTITION       =SIMP(statut='f',typ='R'),
           DYNAMIQUE       =SIMP(statut='f',typ='I',defaut=1),
         ),
 
         RESERVE_CPU     =FACT(fr="reserve de temps pour terminer une execution",statut='d',max=1,
           regles=(EXCLUS('VALE','POURCENTAGE'),),
#          par dfaut VALE fixe  10. dans le FORTRAN si CODE prsent
           VALE            =SIMP(statut='f',typ='I',val_min=0,),
#          par dfaut 10% dans le FORTRAN
           POURCENTAGE     =SIMP(statut='f',typ='R',val_min=0.,val_max=1.0),
#          valeur en secondes de la rserve maximum borne  900 secondes
           BORNE           =SIMP(statut='f',typ='I',val_min=0,defaut=900),),

         IGNORE_ALARM = SIMP(statut='f', typ='TXM', max='**', fr="Alarmes que l'utilisateur souhaite dlibrment ignorer"),

);
#& MODIF COMMANDE  DATE 22/07/2008   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE NISTOR I.NISTOR
DEFI_BASE_MODALE=OPER(nom="DEFI_BASE_MODALE",op=  99,sd_prod=base_modale,
                     reentrant='f',
                     fr="Dfinit la base d'une sous-structuration dynamique ou d'une recombinaison modale",
            UIinfo={"groupes":("Matrices/vecteurs",)},
         regles=(UN_PARMI('CLASSIQUE','RITZ','DIAG_MASS','ORTHO_BASE'),),
         CLASSIQUE       =FACT(statut='f',
           INTERF_DYNA     =SIMP(statut='o',typ=interf_dyna_clas ),
           MODE_MECA       =SIMP(statut='o',typ=mode_meca,max='**' ),
           NMAX_MODE       =SIMP(statut='f',typ='I',defaut= 10 ),
         ),
         RITZ            =FACT(statut='f',max='**',
           regles=(UN_PARMI('MODE_STAT','MODE_MECA','MULT_ELAS','BASE_MODALE'),),
           MODE_MECA       =SIMP(statut='f',typ=mode_meca,max='**'  ),
           NMAX_MODE       =SIMP(statut='f',typ='I',defaut= 999 ),
           MODE_STAT       =SIMP(statut='f',typ=(mode_stat_depl,mode_stat_acce,mode_stat_forc,) ),
           MULT_ELAS       =SIMP(statut='f',typ=mult_elas ),
           BASE_MODALE     =SIMP(statut='f',typ=base_modale ),
         ),
         b_ritz          =BLOC(condition = "RITZ != None",
           INTERF_DYNA     =SIMP(statut='f',typ=interf_dyna_clas ),
           NUME_REF        =SIMP(statut='o',typ=nume_ddl_sdaster ),
           ORTHO           =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON"),
                               fr="Reorthonormalisation de la base de Ritz" ),
           b_ortho          =BLOC(condition = "ORTHO == 'OUI' ",
             MATRICE          =SIMP(statut='o',typ=(matr_asse_depl_r,matr_asse_depl_c,matr_asse_gene_r,matr_asse_pres_r ) ),
               ),
         ),
        DIAG_MASS        =FACT(statut='f',max='**',
           MODE_MECA       =SIMP(statut='o',typ=mode_meca,max='**'  ),
           MODE_STAT       =SIMP(statut='o',typ=(mode_stat_depl,mode_stat_acce,mode_stat_forc,) ),
         ),
        ORTHO_BASE        =FACT(statut='f',max='**',
           BASE       =SIMP(statut='o',typ=(mode_meca,mode_stat_depl,mode_stat_acce,mode_stat_forc,mult_elas,base_modale)),
           MATRICE    =SIMP(statut='o',typ=(matr_asse_depl_r,matr_asse_depl_c,matr_asse_gene_r,matr_asse_pres_r ) ),
         ),


         SOLVEUR         =FACT(statut='d', fr="Mthode de rsolution des systmes linaires",
         METHODE         =SIMP(statut='f',typ='TXM',defaut="MULT_FRONT",into=("LDLT","MULT_FRONT",) ),
         # remarque : on ne peut pas utiliser MUMPS tant qu'il ne sait pas faire STOP_SINGULIER="NON"

           b_ldlt          =BLOC(condition = "METHODE == 'LDLT' ",fr="Paramtres de la mthode LDLT",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("RCMK","SANS") ),
             NPREC           =SIMP(statut='f',typ='I',defaut=8),
             STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
           ),

           b_mult_front    =BLOC(condition = "METHODE == 'MULT_FRONT' ",fr="Paramtres de la mthode multi frontale",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="METIS",into=("MD","MDA","METIS") ),
             NPREC           =SIMP(statut='f',typ='I',defaut=8),
             STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
           ),
         ),



         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE MICHEL S.MICHEL

from Macro.defi_cable_bp_ops import defi_cable_bp_ops

# ===========================================================================
#           CATALOGUE DE LA MACRO "DEFI_CABLE_BP"
#           -----------------------------------------
#
# USAGE :
# Entre :
#  - MODELE
#  - CABLE
#  - CHAM_MATER
#  - CARA_ELEM
#  - GROUP_MA_BETON
#  - DEFI_CABLE
#  - TENSION_INIT
#  - RECUL_ANCRAGE
#  - RELAXATION
#  - CONE
#      RAYON
#      LONGUEUR
#      PRESENT          OUI ou NON deux fois
#  - TITRE
#  - INFO               1 / 2
#
# ===========================================================================

DEFI_CABLE_BP=MACRO(nom="DEFI_CABLE_BP",op=defi_cable_bp_ops,sd_prod=cabl_precont,
                   fr="Calculer les profils initiaux de tension le long des cables de prcontrainte d'une structure en bton",
                   reentrant='n',UIinfo={"groupe":("Modlisation",)},
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater ),
         CARA_ELEM       =SIMP(statut='o',typ=cara_elem ),
         GROUP_MA_BETON  =SIMP(statut='o',typ=grma,max='**'),
         DEFI_CABLE      =FACT(statut='o',max='**',
           regles=(UN_PARMI('MAILLE','GROUP_MA'),
                   UN_PARMI('NOEUD_ANCRAGE','GROUP_NO_ANCRAGE'),),
           MAILLE          =SIMP(statut='f',typ=ma,min=2,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma),
           NOEUD_ANCRAGE   =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max=2),
           GROUP_NO_ANCRAGE=SIMP(statut='f',typ=grno,validators=NoRepeat(),max=2),
         ),
         TYPE_ANCRAGE    =SIMP(statut='o',typ='TXM',min=2,max=2,into=("ACTIF","PASSIF") ),
         TENSION_INIT    =SIMP(statut='o',typ='R',val_min=0.E+0 ),  
         RECUL_ANCRAGE   =SIMP(statut='o',typ='R',val_min=0.E+0 ),  
         RELAXATION      =FACT(statut='f',min=0,
           R_J             =SIMP(statut='o',typ='R',val_min=0.E+0 ),  
         ),
         CONE            =FACT(statut='f',
           RAYON             =SIMP(statut='o',typ='R',val_min=0.E+0 ),  
           LONGUEUR          =SIMP(statut='o',typ='R',val_min=0.E+0 ),  
           PRESENT           =SIMP(statut='o',typ='TXM',min=2,max=2,into=("OUI","NON") ),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**' ),  
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE MICHEL S.MICHEL

DEFI_CABLE_OP=OPER(nom="DEFI_CABLE_OP",op= 180,sd_prod=cabl_precont,reentrant='n',
            fr="Dfinit les profils initiaux de tension d'une structure en bton le long des cables de prcontrainte"
               +" (utilise par la macro DEFI_CABLE_BP)",
            UIinfo={"groupes":("Modlisation",)},
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater ),
         CARA_ELEM       =SIMP(statut='o',typ=cara_elem ),
         GROUP_MA_BETON  =SIMP(statut='o',typ=grma,max='**'),
         DEFI_CABLE      =FACT(statut='o',max='**',
           regles=(UN_PARMI('MAILLE','GROUP_MA'),
                   UN_PARMI('NOEUD_ANCRAGE','GROUP_NO_ANCRAGE'),),
           MAILLE          =SIMP(statut='f',typ=ma,min=2,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma),
           NOEUD_ANCRAGE   =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max=2),
           GROUP_NO_ANCRAGE=SIMP(statut='f',typ=grno,validators=NoRepeat(),max=2),
           GROUP_NO_FUT    =SIMP(statut='f',typ=grno,validators=NoRepeat(),max=2),
         ),
         TYPE_ANCRAGE    =SIMP(statut='o',typ='TXM',min=2,max=2,into=("ACTIF","PASSIF") ),
         TENSION_INIT    =SIMP(statut='o',typ='R',val_min=0.E+0 ),  
         RECUL_ANCRAGE   =SIMP(statut='o',typ='R',val_min=0.E+0 ),  
         RELAXATION      =FACT(statut='f',min=0,
           R_J             =SIMP(statut='o',typ='R',val_min=0.E+0 ),  
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**' ),  
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
         CONE            =FACT(statut='f',min=0,
           RAYON             =SIMP(statut='o',typ='R',val_min=0.E+0 ),  
           LONGUEUR          =SIMP(statut='o',typ='R',val_min=0.E+0, defaut=0.E+0 ),  
           PRESENT           =SIMP(statut='o',typ='TXM',min=2,max=2,into=("OUI","NON") ),
         ),
)  ;
#& MODIF COMMANDE  DATE 30/06/2008   AUTEUR PROIX J-M.PROIX 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2004  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PROIX J.M.PROIX
DEFI_COMPOR=OPER(nom="DEFI_COMPOR",op=59,sd_prod=compor_sdaster,
                   fr="Dfinir le comportement d'un monocristal, d'un polycristal ou de groupes de fibres",
                   reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
# on exclut MULTIFBRE de MONOCRISTAL ou POLYCRISTAL car la structure de donnes n'est pas organise pareil pour ces cas
                  regles=(UN_PARMI('MONOCRISTAL','POLYCRISTAL','MULTIFIBRE'),
                 PRESENT_PRESENT('MULTIFIBRE','GEOM_FIBRE','MATER_SECT'),
                         ),
          MONOCRISTAL    =FACT(statut='f', max='**',
             MATER           =SIMP(statut='o', typ=mater_sdaster, max=1),
             ECOULEMENT      =SIMP(statut='o', typ='TXM', max=1,
                   fr="Donner le nom du mot-cl facteur de DEFI_MATERIAU prcisant le type d'coulement viscoplastique"),
             ECRO_ISOT       =SIMP(statut='o', typ='TXM', max=1,
                   fr="Donner le nom du mot-cl facteur de DEFI_MATERIAU prcisant le type d'crouissage isotrope"),
             ECRO_CINE       =SIMP(statut='o', typ='TXM', max=1,
                   fr="Donner le nom du mot-cl facteur de DEFI_MATERIAU prcisant le type d'crouissage cinmatique"),
             ELAS            =SIMP(statut='f', typ='TXM', max=1,
                   fr="Donner le nom du mot-cl facteur de DEFI_MATERIAU prcisant le comportement lastique (un et un seul)"),
             FAMI_SYST_GLIS  =SIMP(statut='o',typ='TXM', max=1,
                                into=('BASAL', 'PRISMATIQUE', 'OCTAEDRIQUE', 'PYRAMIDAL1',
                                'PYRAMIDAL2', 'CUBIQUE1', 'CUBIQUE2', 'MACLAGE', 'JOINT_GRAIN', 'RL', 'UNIAXIAL','BCC24'),),
                                ),


          POLYCRISTAL    =FACT(statut='f', max='**',
           regles=(UN_PARMI('ANGL_REP','ANGL_EULER'),),
             MONOCRISTAL     =SIMP(statut='o', typ=compor_sdaster, max=1),
             FRAC_VOL  =SIMP(statut='o', typ='R', max=1,fr="fraction volumique de la phase correspondant au monocristal"),
             ANGL_REP  =SIMP(statut='f',typ='R',max=3,fr="orientation du monocristal : 3 angles nautiques en degrs"),
             ANGL_EULER=SIMP(statut='f',typ='R',max=3,fr="orientation du monocristal : 3 angles d'Euler   en degrs"),
                                ),


          b_poly      =BLOC( condition = "POLYCRISTAL!='None'",
          LOCALISATION     =SIMP(statut='f', typ='TXM', max=1, into=('BZ', 'BETA', 'RL',),
                fr="Donner le nom de la rgle de localisation"),

           b_beta      =BLOC( condition = "LOCALISATION=='BETA'",
             DL            =SIMP(statut='o',typ='R',max=1),
             DA            =SIMP(statut='o',typ='R',max=1),
             ),
             ),

#####################################################################################
          GEOM_FIBRE = SIMP(statut='f',max=1,typ=gfibre_sdaster,
                   fr="Donner le nom du concept regroupant tous les groupes de fibres (issu de DEFI_GEOM_FIBRE)"),
          MATER_SECT = SIMP(statut='f',max=1,typ=mater_sdaster,
                   fr="Donner le nom du materiau pour les caracteristiques homogeneisees sur la section"),
          MULTIFIBRE    = FACT(statut='f',max='**',
          GROUP_FIBRE        =SIMP(statut='o', typ='TXM', max='**'),
             MATER           =SIMP(statut='o', typ=mater_sdaster, max=1,
                                   fr="Donner le nom du materiau pour le groupe de fibres"),
             ALGO_1D         =SIMP(statut='f',typ='TXM',defaut="ANALYTIQUE",into=("DEBORST","ANALYTIQUE",)),
             DEFORMATION      =SIMP(statut='f',typ='TXM',defaut="PETIT",
                                     into=("PETIT","PETIT_REAC","REAC_GEOM")),
             RELATION        =SIMP(statut='f', typ='TXM', max=1,defaut="ELAS",
#                                   into=c_relation_into,
                                  fr="Donner le nom de la relation incrementale pour le groupe de fibres",
                                 into=(
                                        "ELAS",
                                        "ELAS_HYPER",
                                        "VMIS_ISOT_TRAC",
                                        "VISC_ISOT_TRAC",
                                        "VMIS_ISOT_LINE",
                                        "VISC_ISOT_LINE",
                                        "VMIS_ISOT_PUIS",
                                        "VMIS_ECMI_TRAC",
                                        "VMIS_ECMI_LINE",
                                        "LABORD_1D",
                                        "ENDO_FRAGILE",
                                        "ENDO_ISOT_BETON",
                                        "ENDO_ORTH_BETON",
                                        "BETON_REGLE_PR",
                                        "MAZARS",
                                        "RUPT_FRAG",
                                        "VMIS_CINE_LINE",
                                        "VISC_TAHERI",
                                        "VISCOCHAB",
                                        "VMIS_CIN1_CHAB",
                                        "VMIS_CIN2_CHAB",
                                        "VISC_CIN1_CHAB",
                                        "VISC_CIN2_CHAB",
                                        "ROUSSELIER",
                                        "ROUSS_PR",
                                        "ROUSS_VISC",
                                        "NORTON_HOFF",
                                        "LEMAITRE",
                                        "VENDOCHAB",
                                        "DRUCK_PRAGER",
                                        "DRUCK_PRAG_N_A",
                                        "GRANGER_FP",
                                        "GRANGER_FP_INDT",
                                        "GRANGER_FP_V",
                                        "BETON_UMLV_FP",
                                        "BETON_DOUBLE_DP",
                                        "KIT_DDI",
                                        "SANS",
                                        "CORR_ACIER",
                                        "ZMAT",
                                        "GRAN_IRRA_LOG",
                                     ) ),
           RELATION_KIT    =SIMP(statut='f',typ='TXM',max='**',validators=NoRepeat(),
                                 into=(
# MECA KIT_DDI
                                       "VMIS_ISOT_TRAC",
                                       "VMIS_ISOT_LINE",
                                       "VMIS_ISOT_CINE",
                                       "VMIS_ISOT_PUIS",
                                       "GRANGER_FP",
                                       "GRANGER_FP_INDT",
                                       "GRANGER_FP_V",
                                       "BETON_UMLV_FP",
                                       "ROUSS_PR",
                                       "NADAI_B",
                                       "BETON_DOUBLE_DP",
                                       ),),
# on pourrait ajouter TOUT_GROUP_FIBRE

                                ) );

#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS
DEFI_CONSTANTE=OPER(nom="DEFI_CONSTANTE",op=   2,sd_prod=fonction_sdaster,
                    fr="Dfinir la valeur d'une grandeur invariante",
                    reentrant='n',
            UIinfo={"groupes":("Fonction",)},
         NOM_RESU        =SIMP(statut='f',typ='TXM',defaut="TOUTRESU"),
         VALE            =SIMP(statut='o',typ='R',),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
DEFI_COQU_MULT=OPER(nom="DEFI_COQU_MULT",op=56,sd_prod=mater_sdaster,reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
                    fr="Dterminer les caractristiques matriaux homognises d'une coque multicouche  partir"
                        +" des caractristiques de chaque couche",
         COUCHE          =FACT(statut='o',max='**',
           EPAIS           =SIMP(statut='o',typ='R',val_min=0.E+0 ),
           MATER           =SIMP(statut='o',typ=(mater_sdaster) ),
           ORIENTATION     =SIMP(statut='f',typ='R',defaut= 0.E+0,
                                 val_min=-90.E+0,val_max=90.E+0   ),
         ),
         IMPRESSION      =FACT(statut='f',
           UNITE           =SIMP(statut='f',typ='I',defaut=8),  
         ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE
def DEFIC_prod(self,ACTION,UNITE,**args):
  if ACTION == "ASSOCIER" or ACTION == "RESERVER":
    if UNITE != None :
      return
    else :
      return entier
  elif ACTION == "LIBERER"  :
    return
  else :
    raise AsException("ACTION non prevue : %s" % ACTION)

DEFI_FICHIER=MACRO(nom="DEFI_FICHIER",op=ops.build_DEFI_FICHIER,sd_prod=DEFIC_prod,reentrant='n',
                  UIinfo={"groupes":("Gestion du travail",)},
                  fr="Ouvre ou ferme un fichier associ  un numro d'unit logique",

            ACTION        =SIMP(statut='f',typ='TXM',into=("ASSOCIER","LIBERER","RESERVER"),defaut="ASSOCIER"),

            b_associer    =BLOC(condition = "ACTION == 'ASSOCIER'",
                                fr="Paramtres pour l'ouverture du fichier",
                                regles=(AU_MOINS_UN('FICHIER','UNITE'),),
               UNITE      =SIMP(statut='f',typ='I' ,val_min=1),
               FICHIER    =SIMP(statut='f',typ='TXM',validators=LongStr(1,255)),
               TYPE       =SIMP(statut='f',typ='TXM',into=("ASCII","BINARY","LIBRE"),defaut="ASCII"),

               b_type_ascii  =BLOC(condition = "TYPE == 'ASCII'",fr="Paramtres pour le type ASCII",
                  ACCES      =SIMP(statut='f',typ='TXM',into=("NEW","APPEND","OLD"),defaut="NEW"),
               ),
               b_type_autre  =BLOC(condition = "TYPE != 'ASCII'",fr="Paramtres pour les types BINARY et LIBRE",
                  ACCES      =SIMP(statut='f',typ='TXM',into=("NEW","OLD"),defaut="NEW"),
               ),
            ),

            b_reserver    =BLOC(condition = "ACTION == 'RESERVER'",
                                fr="Paramtres pour la rservation de l'unit du fichier",
                                regles=(AU_MOINS_UN('FICHIER','UNITE'),),
               UNITE      =SIMP(statut='f',typ='I' ,val_min=1),
               FICHIER    =SIMP(statut='f',typ='TXM',validators=LongStr(1,255)),
               TYPE       =SIMP(statut='f',typ='TXM',into=("ASCII",),defaut="ASCII"),
               ACCES      =SIMP(statut='f',typ='TXM',into=("APPEND",),defaut="APPEND"),
            ),

            b_liberer    =BLOC(condition = "ACTION == 'LIBERER'",
                               fr="Paramtres pour la fermeture du fichier",
                               regles=(UN_PARMI('FICHIER','UNITE'),),
                  UNITE         =SIMP(statut='f',typ='I' ,val_min=1),
                  FICHIER   =SIMP(statut='f',typ='TXM',validators=LongStr(1,255)),
           ),

           INFO          =SIMP(statut='f',typ='I',into=(1,2) ),           
           )
#& MODIF COMMANDE  DATE 14/10/2008   AUTEUR GENIAUT S.GENIAUT 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2004  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE GENIAUT S.GENIAUT

DEFI_FISS_XFEM=OPER(nom="DEFI_FISS_XFEM",op=  41,sd_prod=fiss_xfem,reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
               fr="Dfinition des caratristiques d'une fissure avec X-FEM",

    MODELE                =SIMP(statut='o',typ=modele_sdaster),
    DEFI_FISS             =FACT(statut='o',max=01,
      regles              =(UN_PARMI('GROUP_MA_FISS','FONC_LT','FORM_FISS'),
                            ENSEMBLE('FONC_LT','FONC_LN'),
                            ENSEMBLE('GROUP_MA_FISS','GROUP_MA_FOND')),
      FONC_LT             =SIMP(statut='f',typ=(fonction_sdaster,formule) ),
      FONC_LN             =SIMP(statut='f',typ=(fonction_sdaster,formule) ),
      GROUP_MA_FISS       =SIMP(statut='f',typ=grma,max=01),
      GROUP_MA_FOND       =SIMP(statut='f',typ=grma),
      FORM_FISS           =SIMP(statut='f',typ='TXM',into=("ELLIPSE","CYLINDRE","DEMI_PLAN","SEGMENT","DEMI_DROITE") ),
      b_ellipse           =BLOC(condition = "FORM_FISS == 'ELLIPSE' ",fr="Paramtres de la fissure elliptique",           
           DEMI_GRAND_AXE =SIMP(statut='o',typ='R',val_min=0.E+0),
           DEMI_PETIT_AXE =SIMP(statut='o',typ='R',val_min=0.E+0),
           CENTRE         =SIMP(statut='o',typ='R',min=3,max=3),
           VECT_X         =SIMP(statut='o',typ='R',min=3,max=3),
           VECT_Y         =SIMP(statut='o',typ='R',min=3,max=3),
           COTE_FISS      =SIMP(statut='f',typ='TXM',defaut="IN",into=("IN","OUT",) ),    ),
      b_cylindre          =BLOC(condition = "FORM_FISS == 'CYLINDRE' ",fr="Paramtres de la fissure cylindrique",
           DEMI_GRAND_AXE =SIMP(statut='o',typ='R',val_min=0.E+0),
           DEMI_PETIT_AXE =SIMP(statut='o',typ='R',val_min=0.E+0),
           CENTRE         =SIMP(statut='o',typ='R',min=3,max=3),
           VECT_X         =SIMP(statut='o',typ='R',min=3,max=3),
           VECT_Y         =SIMP(statut='o',typ='R',min=3,max=3),),
      b_demiplan         =BLOC(condition = "FORM_FISS == 'DEMI_PLAN' ",fr="Paramtres de la fissure plane  front droit", 
           PFON           =SIMP(statut='o',typ='R',min=3,max=3),
           NORMALE        =SIMP(statut='o',typ='R',min=3,max=3),
           DTAN           =SIMP(statut='o',typ='R',min=3,max=3),),
      b_segment           =BLOC(condition = "FORM_FISS == 'SEGMENT' ",fr="Paramtres de la fissure 2D segment",
           PFON_ORIG      =SIMP(statut='o',typ='R',min=3,max=3),
           PFON_EXTR      =SIMP(statut='o',typ='R',min=3,max=3),),
      b_demidroite         =BLOC(condition = "FORM_FISS == 'DEMI_DROITE' ",fr="Paramtres de la fissure 2D demi-droite",
           PFON           =SIMP(statut='o',typ='R',min=3,max=3),
           DTAN           =SIMP(statut='o',typ='R',min=3,max=3),),
      b_droite            =BLOC(condition = "FORM_FISS == 'DROITE' ",fr="Paramtres de l'interface 2D (fissure traversante)",
           POINT          =SIMP(statut='o',typ='R',min=3,max=3),
           DTAN           =SIMP(statut='o',typ='R',min=3,max=3),),
      b_inclusion         =BLOC(condition = "FORM_FISS == 'INCLUSION' ",fr="Paramtres de l'interface 2D (inclusion)",
           DEMI_GRAND_AXE =SIMP(statut='o',typ='R',val_min=0.E+0),
           DEMI_PETIT_AXE =SIMP(statut='o',typ='R',val_min=0.E+0),
           CENTRE         =SIMP(statut='o',typ='R',min=3,max=3),
           VECT_X         =SIMP(statut='o',typ='R',min=3,max=3),
           VECT_Y         =SIMP(statut='o',typ='R',min=3,max=3),),
    ),
    GROUP_MA_ENRI         =SIMP(statut='o',typ=grma,max=01),
    TYPE_ENRI_FOND        =SIMP(statut='f',typ='TXM',into=("TOPOLOGIQUE","GEOMETRIQUE"),defaut="TOPOLOGIQUE" ),
      b_enri_geom         =BLOC(condition = "TYPE_ENRI_FOND == 'GEOMETRIQUE' ",fr="Paramtres de l enrichissement geometrique",
           RAYON_ENRI     =SIMP(statut='f',typ='R',val_min=0.E+0),

        b_enri_couches    =BLOC(condition = "(RAYON_ENRI == None) ",fr="Paramtres de l enrichissement  n couches",
           NB_COUCHES     =SIMP(statut='f',typ='I',defaut=4,val_min=1),
                          ),
                        
                          ),

    ORIE_FOND             =FACT(statut='f',max=01,
      PFON_INI            =SIMP(statut='o',typ='R',max=03),
      VECT_ORIE           =SIMP(statut='o',typ='R',max=03),
      POINT_ORIG          =SIMP(statut='o',typ='R',max=03),
    ),
    INFO                  =SIMP(statut='f',typ='I',defaut= 1,into=(1,2,3,) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE ADOBES A.ADOBES
DEFI_FLUI_STRU=OPER(nom="DEFI_FLUI_STRU",op= 143,sd_prod=type_flui_stru,
                    reentrant='n',fr="Dfinit les caractristiques ncessaires  l'tude dynamique d'une structure sous coulement",
            UIinfo={"groupes":("Maillage",)},
         regles=(  UN_PARMI('FAISCEAU_TRANS','GRAPPE','FAISCEAU_AXIAL','COQUE_COAX',),),
         FAISCEAU_TRANS  =FACT(statut='f',max='**',
           regles=(  ENSEMBLE('CSTE_CONNORS','NB_CONNORS','RHO_TUBE'),),
           COUPLAGE        =SIMP(statut='f',typ='TXM',into=("OUI","NON") ),
           CARA_ELEM       =SIMP(statut='f',typ=cara_elem ),
           PROF_VITE_FLUI  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PROF_RHO_F_INT  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PROF_RHO_F_EXT  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           NOM_CMP         =SIMP(statut='f',typ='TXM',into=("DX","DY","DZ") ),
           COEF_MASS_AJOU  =SIMP(statut='f',typ='R' ),
           TYPE_PAS        =SIMP(statut='f',typ='TXM',into=("CARRE_LIGN","TRIA_LIGN") ),
           TYPE_RESEAU     =SIMP(statut='f',typ='I' ),
           UNITE_CD        =SIMP(statut='f',typ='I',defaut=70),
           UNITE_CK        =SIMP(statut='f',typ='I',defaut=71),            
           PAS             =SIMP(statut='f',typ='R' ),
           CSTE_CONNORS    =SIMP(statut='f',typ='R',min=2,max=2,val_min=0.E+00),
           NB_CONNORS      =SIMP(statut='f',typ='I',val_min=2,),
           RHO_TUBE        =SIMP(statut='f',typ='R' ),
         ),
         GRAPPE          =FACT(statut='f',
           regles=(ENSEMBLE('GRAPPE_2','NOEUD','CARA_ELEM','MODELE','RHO_FLUI',),
                   PRESENT_PRESENT('COEF_MASS_AJOU','GRAPPE_2', ),),
#  peut on crer un bloc a partir de la valeur de couplage  
           COUPLAGE        =SIMP(statut='o',typ='TXM',into=("OUI","NON") ),
           GRAPPE_2        =SIMP(statut='f',typ='TXM',
                                 into=("ASC_CEN","ASC_EXC","DES_CEN","DES_EXC") ),
           NOEUD           =SIMP(statut='f',typ=no),
           CARA_ELEM       =SIMP(statut='f',typ=cara_elem ),
           MODELE          =SIMP(statut='f',typ=modele_sdaster ),
           COEF_MASS_AJOU  =SIMP(statut='f',typ='R' ),
           RHO_FLUI        =SIMP(statut='f',typ='R' ),
           UNITE_CA        =SIMP(statut='f',typ='I',defaut=70),
           UNITE_KA        =SIMP(statut='f',typ='I',defaut=71),            
         ),
         FAISCEAU_AXIAL  =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_MA','TRI_GROUP_MA'),
                   UN_PARMI('CARA_ELEM','RAYON_TUBE'),
                   ENSEMBLE('RAYON_TUBE','COOR_TUBE'),
                   PRESENT_ABSENT('RAYON_TUBE','TRI_GROUP_MA'),
                   ENSEMBLE('CARA_PAROI','VALE_PAROI'),
                   ENSEMBLE('LONG_TYPG','LARG_TYPG','EPAI_TYPG','RUGO_TYPG','COEF_TRAI_TYPG','COEF_DPOR_TYPG',
                            'COOR_GRILLE','TYPE_GRILLE', ),),
#  on doit pouvoir mettre des blocs conditionnels mais pas assez d infos pour le faire                            
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           TRI_GROUP_MA    =SIMP(statut='f',typ='TXM' ),
           VECT_X          =SIMP(statut='f',typ='R',max=3),
           PROF_RHO_FLUI   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PROF_VISC_CINE  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           CARA_ELEM       =SIMP(statut='f',typ=cara_elem ),
           RAYON_TUBE      =SIMP(statut='f',typ='R' ),
           COOR_TUBE       =SIMP(statut='f',typ='R',max='**'),
           PESANTEUR       =SIMP(statut='f',typ='R',min=4,max=4),
           RUGO_TUBE       =SIMP(statut='f',typ='R' ),
           CARA_PAROI      =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max=5,
                                 into=("YC","ZC","R","HY","HZ") ),
           VALE_PAROI      =SIMP(statut='f',typ='R',max=5),
           ANGL_VRIL       =SIMP(statut='f',typ='R' ),
           LONG_TYPG       =SIMP(statut='f',typ='R',max='**',val_min=0.E+0),
           LARG_TYPG       =SIMP(statut='f',typ='R',max='**',val_min=0.E+0),
           EPAI_TYPG       =SIMP(statut='f',typ='R',max='**',val_min=0.E+0),
           RUGO_TYPG       =SIMP(statut='f',typ='R',max='**',val_min=0.E+0),
           COEF_TRAI_TYPG  =SIMP(statut='f',typ='R',max='**',val_min=0.E+0),
           COEF_DPOR_TYPG  =SIMP(statut='f',typ='R',max='**'),
           COOR_GRILLE     =SIMP(statut='f',typ='R',max='**'),
           TYPE_GRILLE     =SIMP(statut='f',typ='I',max='**'),
         ),
         COQUE_COAX      =FACT(statut='f',
           MASS_AJOU       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           GROUP_MA_INT    =SIMP(statut='o',typ=grma),
           GROUP_MA_EXT    =SIMP(statut='o',typ=grma),
           VECT_X          =SIMP(statut='o',typ='R',max='**'),
           CARA_ELEM       =SIMP(statut='o',typ=cara_elem ),
           MATER_INT       =SIMP(statut='o',typ=mater_sdaster ),
           MATER_EXT       =SIMP(statut='o',typ=mater_sdaster ),
           RHO_FLUI        =SIMP(statut='o',typ='R' ),
           VISC_CINE       =SIMP(statut='o',typ='R' ),
           RUGOSITE        =SIMP(statut='o',typ='R' ),
           PDC_MOY_1       =SIMP(statut='o',typ='R' ),
           PDC_DYN_1       =SIMP(statut='o',typ='R' ),
           PDC_MOY_2       =SIMP(statut='o',typ='R' ),
           PDC_DYN_2       =SIMP(statut='o',typ='R' ),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 09/02/2010   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE PEYRARD C.PEYRARD

from Macro.defi_fonc_elec_ops import defi_fonc_elec_ops

DEFI_FONC_ELEC=MACRO(nom="DEFI_FONC_ELEC",op=defi_fonc_elec_ops,sd_prod=fonction_sdaster,reentrant='n',
            UIinfo={"groupes":("Outils mtier",)},
                    fr="Dfinir une fonction du temps intervenant dans le calcul des forces de LAPLACE",
      regles=(UN_PARMI('COUR_PRIN','COUR'),
              EXCLUS('COUR','COUR_SECO'), ),
         FREQ            =SIMP(statut='f',typ='R',defaut= 50.),
         SIGNAL          =SIMP(statut='f',typ='TXM',defaut="COMPLET",into=("COMPLET","CONTINU") ),
         COUR            =FACT(statut='f',max='**',
         fr="Dfinition du courant de court-circuit",
           regles=(UN_PARMI('PHI_CC_1','INTC_CC_1'),
                   UN_PARMI('PHI_CC_2','INTC_CC_2'),),
           INTE_CC_1       =SIMP(statut='o',typ='R'),
           TAU_CC_1        =SIMP(statut='o',typ='R'),
           PHI_CC_1        =SIMP(statut='f',typ='R'),
           INTC_CC_1       =SIMP(statut='f',typ='R'),
           INTE_CC_2       =SIMP(statut='o',typ='R'),
           TAU_CC_2        =SIMP(statut='o',typ='R'),
           PHI_CC_2        =SIMP(statut='f',typ='R'),
           INTC_CC_2       =SIMP(statut='f',typ='R'),
           INST_CC_INIT    =SIMP(statut='o',typ='R'),
           INST_CC_FIN     =SIMP(statut='o',typ='R'),
         ),
         COUR_PRIN       =FACT(statut='f',
         fr="Dfinition du courant de court-circuit avec renclenchement",
           regles=(UN_PARMI('PHI_CC_1','INTC_CC_1'),),
           INTE_CC_1       =SIMP(statut='o',typ='R'),
           TAU_CC_1        =SIMP(statut='o',typ='R'),
           PHI_CC_1        =SIMP(statut='f',typ='R'),
           INTC_CC_1       =SIMP(statut='f',typ='R'),
           INTE_RENC_1     =SIMP(statut='f',typ='R'),
           TAU_RENC_1      =SIMP(statut='f',typ='R'),
           PHI_RENC_1      =SIMP(statut='f',typ='R'),
           INST_CC_INIT    =SIMP(statut='o',typ='R'),
           INST_CC_FIN     =SIMP(statut='o',typ='R'),
           INST_RENC_INIT  =SIMP(statut='f',typ='R',defaut= 0.0E+0),
           INST_RENC_FIN   =SIMP(statut='f',typ='R',defaut= 0.0E+0),
         ),
         COUR_SECO       =FACT(statut='f',max='**',
         fr="Dfinition du courant de court-circuit avec un intervalle de temps diffrent de celui de COUR_PRIN",
           regles=(UN_PARMI('PHI_CC_2','INTC_CC_2'),),
           INTE_CC_2       =SIMP(statut='o',typ='R'),
           TAU_CC_2        =SIMP(statut='o',typ='R'),
           PHI_CC_2        =SIMP(statut='f',typ='R'),
           INTC_CC_2       =SIMP(statut='f',typ='R'),
           INTE_RENC_2     =SIMP(statut='f',typ='R'),
           TAU_RENC_2      =SIMP(statut='f',typ='R'),
           PHI_RENC_2      =SIMP(statut='f',typ='R'),
           DIST            =SIMP(statut='f',typ='R',defaut=1.0E+0),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
)
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE ADOBES A.ADOBES
DEFI_FONC_FLUI=OPER(nom="DEFI_FONC_FLUI",op= 142,sd_prod=fonction_sdaster,
                    reentrant='n',
            fr="Dfinit un profil de vitesse d'coulement fluide le long d'une poutre",
            UIinfo={"groupes":("Fonction",)},
         MAILLAGE        =SIMP(statut='o',typ=(maillage_sdaster) ),
         NOEUD_INIT      =SIMP(statut='o',typ=no),
         NOEUD_FIN       =SIMP(statut='o',typ=no),
         VITE            =FACT(statut='o',
           VALE            =SIMP(statut='f',typ='R',defaut= 1. ),
           PROFIL          =SIMP(statut='o',typ='TXM',into=("UNIFORME","LEONARD") ),
           NB_BAV          =SIMP(statut='f',typ='I',defaut= 0,into=( 0 , 2 , 3 ) ),
         ),
         INTERPOL        =SIMP(statut='f',typ='TXM',max=2,defaut="LIN",
                               into=("NON","LIN","LOG") ),
         PROL_DROITE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",
                               into=("CONSTANT","LINEAIRE","EXCLU") ),
         PROL_GAUCHE     =SIMP(statut='f',typ='TXM' ,defaut="EXCLU",
                               into=("CONSTANT","LINEAIRE","EXCLU") ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2 ) ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS
def defi_fonction_prod(VALE,VALE_PARA,VALE_C,NOEUD_PARA,ABSCISSE,**args):
  if VALE       != None  : return fonction_sdaster
  if VALE_C     != None  : return fonction_c
  if VALE_PARA  != None  : return fonction_sdaster
  if ABSCISSE   != None  : return fonction_sdaster
  if NOEUD_PARA != None  : return fonction_sdaster
  raise AsException("type de concept resultat non prevu")

DEFI_FONCTION=OPER(nom="DEFI_FONCTION",op=3,sd_prod=defi_fonction_prod
                    ,fr="Dfinit une fonction relle ou complexe d'une variable relle",
                     reentrant='n',
            UIinfo={"groupes":("Fonction",)},
         regles=(UN_PARMI('VALE','VALE_C','VALE_PARA','NOEUD_PARA','ABSCISSE'),),
         NOM_PARA        =SIMP(statut='o',typ='TXM',into=C_PARA_FONCTION() ),
         NOM_RESU        =SIMP(statut='f',typ='TXM',defaut="TOUTRESU"),
         VALE            =SIMP(statut='f',typ='R',min=2,max='**',
                               fr ="Fonction relle dfinie par une liste de couples (abscisse,ordonne)"),
         ABSCISSE        =SIMP(statut='f',typ='R',min=2,max='**',
                               fr ="Liste d abscisses d une fonction relle"),
         VALE_C          =SIMP(statut='f',typ='R',min=2,max='**',
                               fr ="Fonction complexe dfinie par une liste de couples"),
         VALE_PARA       =SIMP(statut='f',typ=listr8_sdaster,
                               fr ="Fonction relle dfinie par deux concepts de type listr8" ),
         b_vale_para     =BLOC(condition = "VALE_PARA != None",
           VALE_FONC       =SIMP(statut='o',typ=listr8_sdaster ),
         ),
         b_abscisse      =BLOC(condition = "ABSCISSE != None",
           ORDONNEE        =SIMP(statut='o',typ='R',min=2,max='**',
                               fr ="Liste d ordonnes d une fonction relle"),
         ),
         NOEUD_PARA      =SIMP(statut='f',typ=no,max='**',
                               fr ="Fonction relle dfinie par une liste de noeuds et un maillage"),
         b_noeud_para    =BLOC(condition = "NOEUD_PARA != None",
           MAILLAGE        =SIMP(statut='o',typ=maillage_sdaster ),
           VALE_Y          =SIMP(statut='o',typ='R',max='**'),
         ),

         INTERPOL        =SIMP(statut='f',typ='TXM',max=2,defaut="LIN",into=("NON","LIN","LOG") ),
         PROL_DROITE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
         PROL_GAUCHE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
         VERIF           =SIMP(statut='f',typ='TXM',defaut="CROISSANT",into=("CROISSANT","NON") ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE GALENNE E.GALENNE
DEFI_FOND_FISS=OPER(nom="DEFI_FOND_FISS",op=55,sd_prod=fond_fiss,reentrant='n',
            UIinfo={"groupes":("Post traitements",)},
                    fr="Dfinition de lvres et d'un fond de fissure en 3D",
         regles=(UN_PARMI('FOND_FISS','FOND_FERME','FOND_INF'),
                 EXCLUS('FOND_FERME','DTAN_ORIG'),
                 EXCLUS('FOND_FERME','DTAN_EXTR'),
                      EXCLUS('FOND_FERME','VECT_GRNO_ORIG'),
                      EXCLUS('FOND_FERME','VECT_GRNO_EXTR'),
                 UN_PARMI('LEVRE_SUP','NORMALE'),
                      EXCLUS('LEVRE_INF','NORMALE'),
                 ENSEMBLE('DTAN_ORIG','DTAN_EXTR'),
                 ENSEMBLE('FOND_SUP','FOND_INF'),
                 EXCLUS('FOND_INF','FOND_FISS'),
                 EXCLUS('FOND_INF','FOND_FERME'),
                      ENSEMBLE('VECT_GRNO_ORIG','VECT_GRNO_EXTR'),
                      EXCLUS('DTAN_ORIG','VECT_GRNO_ORIG'),
                      EXCLUS('DTAN_EXTR','VECT_GRNO_EXTR') ,),
           MAILLAGE        =SIMP(statut='o',typ=maillage_sdaster ),
           FOND_FISS       =FACT(statut='f',
             regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),
                     EXCLUS('NOEUD_ORIG','GROUP_NO_ORIG'),
                          EXCLUS('NOEUD_EXTR','GROUP_NO_EXTR'),),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
#   mettre  jour le max vaut-il 1  
             NOEUD_ORIG      =SIMP(statut='f',typ=no,),
             GROUP_NO_ORIG   =SIMP(statut='f',typ=grno,),
             NOEUD_EXTR      =SIMP(statut='f',typ=no,),
             GROUP_NO_EXTR   =SIMP(statut='f',typ=grno,),
           ),
           FOND_FERME      =FACT(statut='f',
             regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),
                          EXCLUS('NOEUD_ORIG','GROUP_NO_ORIG'),),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             NOEUD_ORIG      =SIMP(statut='f',typ=no,),
             GROUP_NO_ORIG   =SIMP(statut='f',typ=grno,),
             MAILLE_ORIG     =SIMP(statut='f',typ=ma,),
             GROUP_MA_ORIG   =SIMP(statut='f',typ=ma,),
           ),
           FOND_INF       =FACT(statut='f',
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             NOEUD_ORIG      =SIMP(statut='f',typ=no,),
             GROUP_NO_ORIG   =SIMP(statut='f',typ=grno,),
             NOEUD_EXTR      =SIMP(statut='f',typ=no,),
             GROUP_NO_EXTR   =SIMP(statut='f',typ=grno,),
           ),
           FOND_SUP       =FACT(statut='f',
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'), 
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             NOEUD_ORIG      =SIMP(statut='f',typ=no,),
             GROUP_NO_ORIG   =SIMP(statut='f',typ=grno,),
             NOEUD_EXTR      =SIMP(statut='f',typ=no,),
             GROUP_NO_EXTR   =SIMP(statut='f',typ=grno,),
           ),
           LEVRE_SUP       =FACT(statut='f',
             regles=(UN_PARMI('GROUP_MA','MAILLE'),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           ),
           LEVRE_INF       =FACT(statut='f',
             regles=(UN_PARMI('GROUP_MA','MAILLE', ),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           ),
           NORMALE         =SIMP(statut='f',typ='R',max='**'),
           PREC_NORM       =SIMP(statut='f',typ='R',defaut=0.1),
           DTAN_ORIG       =SIMP(statut='f',typ='R',max='**'),
           DTAN_EXTR       =SIMP(statut='f',typ='R',max='**'),
           VECT_GRNO_ORIG  =SIMP(statut='f',typ=grno,validators=NoRepeat(),max=2),
           VECT_GRNO_EXTR  =SIMP(statut='f',typ=grno,validators=NoRepeat(),max=2),
           INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2007  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE FLEJOU J.L.FLEJOU
# 
DEFI_GEOM_FIBRE=OPER(nom="DEFI_GEOM_FIBRE",op=  119, sd_prod=gfibre_sdaster,
                    fr="Definition des groupes de fibres pour les elements multifibres",
                    reentrant='n',
            UIinfo={"groupes":("Modelisation",)},
         regles=(AU_MOINS_UN('SECTION','FIBRE'),),

         INFO       =SIMP(statut='f',typ='I', defaut= 1 ,into=(1,2) ),
#============================================================================
         SECTION     =FACT(statut='f',max='**',
              regles=(AU_MOINS_UN('TOUT_SECT','GROUP_MA_SECT','MAILLE_SECT'),
                      PRESENT_ABSENT('TOUT_SECT','GROUP_MA_SECT','MAILLE_SECT'),),

              GROUP_FIBRE       =SIMP(statut='o',typ='TXM',min=1,max=1),
              TOUT_SECT         =SIMP(statut='f',typ='TXM',into=("OUI",) ),
              GROUP_MA_SECT     =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_SECT       =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),

              MAILLAGE_SECT     =SIMP(statut='o',typ=maillage_sdaster),
              COOR_AXE_POUTRE   =SIMP(statut='o',typ='R',min=2,max=2),
         ),


#============================================================================
         FIBRE     =FACT(statut='f',max='**',
              GROUP_FIBRE       =SIMP(statut='o',typ='TXM',min=1,max=1),
              CARA              =SIMP(statut='f',typ='TXM',defaut='SURFACE',into=('SURFACE','DIAMETRE',)),
              VALE              =SIMP(statut='o',typ='R',max='**'),
              COOR_AXE_POUTRE   =SIMP(statut='o',typ='R',min=2,max=2),
          ),


) ;
#& MODIF COMMANDE  DATE 20/04/2009   AUTEUR SFAYOLLE S.FAYOLLE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2008  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE SFAYOLLE S.FAYOLLE
DEFI_GLRC=OPER(nom="DEFI_GLRC",op=57,sd_prod=mater_sdaster,reentrant='f',
            UIinfo={"groupes":("Modelisation",)},
                    fr="Determiner les caracteristiques du beton arme homogeneisees a partir des proprietes du beton et de  "
                        +" plusieurs types d'armature",
         reuse = SIMP(statut='f',typ=mater_sdaster), 
         BETON          =FACT(statut='o',max=1,
           MATER           =SIMP(statut='o',typ=(mater_sdaster) ),
           EPAIS           =SIMP(statut='o',typ='R',val_min=0.E+0 ),
           GAMMA           =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=1.E+0),
           QP1             =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=1.E+0),
           QP2             =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=1.E+0),

           C1N1            =SIMP(statut='o',typ='R',val_min=0.E+0),
           C1N2            =SIMP(statut='o',typ='R',val_min=0.E+0),
           C1N3            =SIMP(statut='o',typ='R',val_min=0.E+0),
           C2N1            =SIMP(statut='o',typ='R',val_min=0.E+0),
           C2N2            =SIMP(statut='o',typ='R',val_min=0.E+0),
           C2N3            =SIMP(statut='o',typ='R',val_min=0.E+0),
           C1M1            =SIMP(statut='o',typ='R',val_min=0.E+0),
           C1M2            =SIMP(statut='o',typ='R',val_min=0.E+0),
           C1M3            =SIMP(statut='o',typ='R',val_min=0.E+0),
           C2M1            =SIMP(statut='o',typ='R',val_min=0.E+0),
           C2M2            =SIMP(statut='o',typ='R',val_min=0.E+0),
           C2M3            =SIMP(statut='o',typ='R',val_min=0.E+0),

           OMT             =SIMP(statut='f',typ='R',val_min=0.E+0,defaut=0.0E+0),
           EAT             =SIMP(statut='f',typ='R',val_min=0.E+0,defaut=0.0E+0),
           BT1             =SIMP(statut='f',typ='R',val_min=0.E+0,defaut=0.0E+0),
           BT2             =SIMP(statut='f',typ='R',val_min=0.E+0,defaut=0.0E+0),

           MP1X            =SIMP(statut='f',typ=('R',listr8_sdaster)),
           MP2X            =SIMP(statut='f',typ=('R',listr8_sdaster)),
           MP1Y            =SIMP(statut='f',typ=('R',listr8_sdaster)),
           MP2Y            =SIMP(statut='f',typ=('R',listr8_sdaster)),
         ),
         NAPPE     =FACT(statut='o',max=10,
           MATER           =SIMP(statut='o',typ=(mater_sdaster) ),
           OMX             =SIMP(statut='o',typ='R',val_min=0.E+0),
           OMY             =SIMP(statut='o',typ='R',val_min=0.E+0),
           RX              =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=1.E+0),
           RY              =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=1.E+0),
         ),
         CABLE_PREC   =FACT(statut='f',max=1,
           MATER           =SIMP(statut='o',typ=(mater_sdaster) ),
           OMX             =SIMP(statut='o',typ='R',val_min=0.E+0),
           OMY             =SIMP(statut='o',typ='R',val_min=0.E+0),
           RX              =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=1.E+0),
           RY              =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=1.E+0),
           PREX            =SIMP(statut='o',typ='R'),
           PREY            =SIMP(statut='o',typ='R'),
         ),
         LINER           =FACT(statut='f',max=10,
           MATER           =SIMP(statut='o',typ=(mater_sdaster) ),
           OML             =SIMP(statut='o',typ='R',val_min=0.E+0),
           RLR             =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=1.E+0),
         ),
         IMPRESSION      =FACT(statut='f',
           UNITE           =SIMP(statut='f',typ='I',defaut=8),
         ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
def defi_group_prod(MAILLAGE,**args):
  if AsType(MAILLAGE) == maillage_sdaster : return maillage_sdaster
  if AsType(MAILLAGE) == squelette : return squelette
  raise AsException("type de concept resultat non prevu")

DEFI_GROUP=OPER(nom="DEFI_GROUP",op= 104,sd_prod=defi_group_prod,
                fr="Dfinition de nouveaux groupes de noeuds et/ou de mailles dans un concept maillage",
                reentrant='o',
            UIinfo={"groupes":("Maillage",)},
         regles=(AU_MOINS_UN('CREA_GROUP_MA','CREA_GROUP_NO','DETR_GROUP_NO','DETR_GROUP_MA'),),
         MAILLAGE        =SIMP(statut='o',typ=(maillage_sdaster,squelette) ),
         DETR_GROUP_MA   =FACT(statut='f',max='**',
           NOM             =SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**'),),
         DETR_GROUP_NO   =FACT(statut='f',max='**',
           NOM             =SIMP(statut='o',typ=grno,validators=NoRepeat(),max='**'),),
         CREA_GROUP_MA   =FACT(statut='f',max='**',

regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE','INTERSEC','UNION','DIFFE','OPTION'),),
#  quel est le concept attendu deriere NOM
           NOM             =SIMP(statut='o',typ=grma),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           INTERSEC        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           UNION           =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           DIFFE           =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           OPTION          =SIMP(statut='f',typ='TXM',into=("FACE_NORMALE","SPHERE","CYLINDRE","BANDE","APPUI_LACHE") ),
           b_group_ma      =BLOC(condition = "GROUP_MA != None",
             regles=(EXCLUS('POSITION','NUME_INIT'),),
             NUME_INIT       =SIMP(statut='f',typ='I'),
             POSITION        =SIMP(statut='f',typ='TXM',into=("INIT","FIN","MILIEU") ),
             b_nume_init   =BLOC(condition = "NUME_INIT != None",
               NUME_FIN        =SIMP(statut='f',typ='I' ),
             ),
           ),
           b_face_normale  =BLOC(condition = "OPTION == 'FACE_NORMALE'",
             regles=(UN_PARMI('ANGL_NAUT','VECT_NORMALE'),),
             ANGL_NAUT       =SIMP(statut='f',typ='R',max=2),
             VECT_NORMALE    =SIMP(statut='f',typ='R',max=3),
             ANGL_PREC       =SIMP(statut='f',typ='R',defaut= 0.5 ),
             VERI_SIGNE      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           ),
           b_sphere        =BLOC(condition = "OPTION == 'SPHERE'",
             regles=(UN_PARMI('POINT','NOEUD_CENTRE','GROUP_NO_CENTRE'),),
             POINT           =SIMP(statut='f',typ='R',max=3),
             NOEUD_CENTRE    =SIMP(statut='f',typ=no),
             GROUP_NO_CENTRE =SIMP(statut='f',typ=grno),
             RAYON           =SIMP(statut='o',typ='R' ),
           ),
           b_cylindre      =BLOC(condition = "OPTION == 'CYLINDRE'",
             regles=(UN_PARMI('POINT','NOEUD_CENTRE','GROUP_NO_CENTRE'),
                     UN_PARMI('ANGL_NAUT','VECT_NORMALE'),),
             POINT           =SIMP(statut='f',typ='R',max=3),
             NOEUD_CENTRE    =SIMP(statut='f',typ=no),
             GROUP_NO_CENTRE =SIMP(statut='f',typ=grno),
             RAYON           =SIMP(statut='o',typ='R' ),
             ANGL_NAUT       =SIMP(statut='f',typ='R',max=2),
             VECT_NORMALE    =SIMP(statut='f',typ='R',max=3),
           ),
           b_bande         =BLOC(condition = "OPTION == 'BANDE'",
             regles=(UN_PARMI('POINT','NOEUD_CENTRE','GROUP_NO_CENTRE'),
                     UN_PARMI('ANGL_NAUT','VECT_NORMALE'),),
             POINT           =SIMP(statut='f',typ='R' ,max=3),
             NOEUD_CENTRE    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max=1),
             GROUP_NO_CENTRE =SIMP(statut='f',typ=grno,validators=NoRepeat(),max=1),
             DIST            =SIMP(statut='o',typ='R' ),
             ANGL_NAUT       =SIMP(statut='f',typ='R',max=2),
             VECT_NORMALE    =SIMP(statut='f',typ='R',max=3),
           ),
           b_app_lache         =BLOC(condition = "OPTION == 'APPUI_LACHE'",
             regles=(UN_PARMI('NOEUD','GROUP_NO'),),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           ),
         ),
         CREA_GROUP_NO   =FACT(statut='f',max='**',
           OPTION          =SIMP(statut='f',typ='TXM',into=("ENV_SPHERE","ENV_CYLINDRE","PLAN",
                                               "SEGM_DROI_ORDO","NOEUD_ORDO","TUNNEL") ),

           b_option =BLOC(condition = "OPTION == None" ,
                          regles=(UN_PARMI('TOUT_GROUP_MA','GROUP_MA','GROUP_NO','NOEUD',
                                                           'INTERSEC','UNION','DIFFE'),),
              TOUT_GROUP_MA   =SIMP(statut='f',typ='TXM',into=("OUI",) ),
              GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
              NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
              INTERSEC        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
              UNION           =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
              DIFFE           =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),

              b_nom_group_ma  =BLOC(condition = "GROUP_MA != None",
                NOM           = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                CRIT_NOEUD    = SIMP(statut='f',typ='TXM',defaut="TOUS",
                                  into=("TOUS","SOMMET","MILIEU","CENTRE"),),
              ),
              b_group_no      =BLOC(condition = "GROUP_NO != None",
                                    regles=(EXCLUS('POSITION','NUME_INIT'),),
                NUME_INIT       =SIMP(statut='f',typ='I'),
                POSITION        =SIMP(statut='f',typ='TXM',into=("INIT","FIN","MILIEU") ),
                b_nume_init     =BLOC(condition = "NUME_INIT != None",
                  NUME_FIN        =SIMP(statut='f',typ='I' ),
                ),
              ),
              b_nom =BLOC(condition = "GROUP_MA == None and TOUT_GROUP_MA == None" ,
                NOM             =SIMP(statut='o',typ=geom),
              ),
           ),

           b_env_sphere    =BLOC(condition = "OPTION == 'ENV_SPHERE'",
             regles=(UN_PARMI('POINT','NOEUD_CENTRE','GROUP_NO_CENTRE'),),
             NOM             =SIMP(statut='o',typ=geom),
             POINT           =SIMP(statut='f',typ='R' ,max=3),
             NOEUD_CENTRE    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max=1),
             GROUP_NO_CENTRE =SIMP(statut='f',typ=grno,validators=NoRepeat(),max=1),
             RAYON           =SIMP(statut='o',typ='R' ),
             PRECISION       =SIMP(statut='o',typ='R' ),
           ),
           b_env_cylindre  =BLOC(condition = "OPTION == 'ENV_CYLINDRE'",
             regles=(UN_PARMI('POINT','NOEUD_CENTRE','GROUP_NO_CENTRE'),
                     UN_PARMI('ANGL_NAUT','VECT_NORMALE'),),
             NOM             =SIMP(statut='o',typ=geom),
             POINT           =SIMP(statut='f',typ='R' ,max=3),
             NOEUD_CENTRE    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max=1),
             GROUP_NO_CENTRE =SIMP(statut='f',typ=grno,validators=NoRepeat(),max=1),
             RAYON           =SIMP(statut='o',typ='R' ),
             ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
             VECT_NORMALE    =SIMP(statut='f',typ='R',max=3),
             PRECISION       =SIMP(statut='o',typ='R' ),
           ),
           b_env_plan      =BLOC(condition = "OPTION == 'PLAN'",
             regles=(UN_PARMI('POINT','NOEUD_CENTRE','GROUP_NO_CENTRE'),
                     UN_PARMI('ANGL_NAUT','VECT_NORMALE'),),
             NOM             =SIMP(statut='o',typ=geom),
             POINT           =SIMP(statut='f',typ='R' ,max=3),
             NOEUD_CENTRE    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max=1),
             GROUP_NO_CENTRE =SIMP(statut='f',typ=grno,validators=NoRepeat(),max=1),
             ANGL_NAUT       =SIMP(statut='f',typ='R' ,max=3),
             VECT_NORMALE    =SIMP(statut='f',typ='R' ,max=3),
             PRECISION       =SIMP(statut='o',typ='R' ),
           ),
           b_segm_droi_ordo=BLOC(condition = "OPTION == 'SEGM_DROI_ORDO'",
             regles=(AU_MOINS_UN('NOEUD','GROUP_NO'),
                     UN_PARMI('NOEUD_ORIG','GROUP_NO_ORIG'),
                     UN_PARMI('NOEUD_EXTR','GROUP_NO_EXTR'),),
             NOM             =SIMP(statut='o',typ=geom),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD_ORIG      =SIMP(statut='f',typ=no),
             GROUP_NO_ORIG   =SIMP(statut='f',typ=grno),
             NOEUD_EXTR      =SIMP(statut='f',typ=no),
             GROUP_NO_EXTR   =SIMP(statut='f',typ=grno),
             PRECISION       =SIMP(statut='o',typ='R' ),
             CRITERE         =SIMP(statut='o',typ='TXM',into=("ABSOLU","RELATIF") ),
           ),
           b_noeud_ordo    =BLOC(condition = "OPTION == 'NOEUD_ORDO'",
             regles=(EXCLUS('NOEUD_ORIG','GROUP_NO_ORIG'),
                     EXCLUS('NOEUD_EXTR','GROUP_NO_EXTR'),),
             NOM             =SIMP(statut='o',typ=geom),
             GROUP_MA        =SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**'),
             NOEUD_ORIG      =SIMP(statut='f',typ=no),
             GROUP_NO_ORIG   =SIMP(statut='f',typ=grno),
             NOEUD_EXTR      =SIMP(statut='f',typ=no),
             GROUP_NO_EXTR   =SIMP(statut='f',typ=grno),
           ),
           b_tunnel    =BLOC(condition = "OPTION == 'TUNNEL'",
             regles=(AU_MOINS_UN ('TOUT','GROUP_MA','MAILLE'),
                     EXCLUS('NOEUD_ORIG','GROUP_NO_ORIG'),
                     AU_MOINS_UN ('GROUP_MA_AXE','MAILLE_AXE'),),
             NOM             =SIMP(statut='o',typ=geom),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_MA_AXE    =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE_AXE      =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             NOEUD_ORIG      =SIMP(statut='f',typ=no),
             GROUP_NO_ORIG   =SIMP(statut='f',typ=grno),
             RAYON           =SIMP(statut='o',typ='R'),
             LONGUEUR        =SIMP(statut='f',typ='R'),
           ),
         ),
         ALARME          =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         INFO            =SIMP(statut='f',typ='I',into=( 1 , 2 ) ),
)  ;
#& MODIF COMMANDE  DATE 06/05/2008   AUTEUR CORUS M.CORUS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE CORUS M.CORUS

DEFI_INTERF_DYNA=OPER(nom="DEFI_INTERF_DYNA",op=  98,sd_prod=interf_dyna_clas,
                      reentrant='n',
            UIinfo={"groupes":("Matrices/vecteurs",)},
            fr="Dfinir les interfaces d'une structure et leur affecter un type",
         NUME_DDL        =SIMP(statut='o',typ=nume_ddl_sdaster ),
         INTERFACE       =FACT(statut='o',max='**',
           regles=(ENSEMBLE('NOM','TYPE'),
#  erreur doc U sur la condition qui suit
                   UN_PARMI('NOEUD','GROUP_NO'),),
           NOM             =SIMP(statut='f',typ='TXM' ),
           TYPE            =SIMP(statut='f',typ='TXM',into=("MNEAL","CRAIGB","CB_HARMO","AUCUN") ),
           NOEUD           =SIMP(statut='f',typ=no,max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,max='**'),
#           DDL_ACTIF       =SIMP(statut='f',typ='TXM',max='**'),
           MASQUE          =SIMP(statut='f',typ='TXM',max='**'),
         ),
         FREQ            =SIMP(statut='f',typ='R',defaut= 1.),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE ZENTNER I.ZENTNER
from Macro.defi_inte_spec_ops import defi_inte_spec_ops

DEFI_INTE_SPEC=MACRO(nom="DEFI_INTE_SPEC",op= defi_inte_spec_ops,sd_prod=table_fonction,
                     reentrant='n',
                     fr="Dfinit une matrice interspectrale",
                     UIinfo={"groupes":("Fonction",)},

         DIMENSION       =SIMP(statut='f',typ='I',defaut= 1 ),

         PAR_FONCTION    =FACT(statut='f',max='**',
           NUME_ORDRE_I    =SIMP(statut='o',typ='I' ),
           NUME_ORDRE_J    =SIMP(statut='o',typ='I' ),
           FONCTION        =SIMP(statut='o',typ=fonction_c ),
         ),
         KANAI_TAJIMI    =FACT(statut='f',max='**',
           regles=(EXCLUS('VALE_R','VALE_C'),),
           NUME_ORDRE_I    =SIMP(statut='o',typ='I' ),
           NUME_ORDRE_J    =SIMP(statut='o',typ='I' ),
           FREQ_MIN        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           FREQ_MAX        =SIMP(statut='f',typ='R',defaut= 100. ),
           PAS             =SIMP(statut='f',typ='R',defaut= 1. ),
           AMOR_REDUIT     =SIMP(statut='f',typ='R',defaut= 0.6 ),
           FREQ_MOY        =SIMP(statut='f',typ='R',defaut= 5. ),
           VALE_R          =SIMP(statut='f',typ='R' ),
           VALE_C          =SIMP(statut='f',typ='C' ),
           INTERPOL        =SIMP(statut='f',typ='TXM',max=2,defaut="LIN",into=("NON","LIN","LOG") ),
           PROL_DROITE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
           PROL_GAUCHE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
         ),
         CONSTANT        =FACT(statut='f',max='**',
           regles=(EXCLUS('VALE_R','VALE_C'),),
           NUME_ORDRE_I    =SIMP(statut='o',typ='I' ),
           NUME_ORDRE_J    =SIMP(statut='o',typ='I' ),
           FREQ_MIN        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           FREQ_MAX        =SIMP(statut='f',typ='R',defaut= 100. ),
           PAS             =SIMP(statut='f',typ='R',defaut= 1. ),
           VALE_R          =SIMP(statut='f',typ='R' ),
           VALE_C          =SIMP(statut='f',typ='C' ),
           INTERPOL        =SIMP(statut='f',typ='TXM',max=2,defaut="LIN",into=("NON","LIN","LOG") ),
           PROL_DROITE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
           PROL_GAUCHE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),               
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS
DEFI_LIST_ENTI=OPER(nom="DEFI_LIST_ENTI",op=22,sd_prod=listis_sdaster,
                    fr="Dfinir une liste d'entiers strictement croissante",
                    reentrant='n',
            UIinfo={"groupes":("Fonction",)},

         OPERATION    =SIMP(statut='o',typ='TXM',defaut='DEFI',into=('DEFI','NUME_ORDRE',)),


         # dfinition d'une liste d'entiers
         #----------------------------------
         b_defi       =BLOC(condition = "OPERATION == 'DEFI'",
             regles=(UN_PARMI('VALE','DEBUT'),
                     EXCLUS('VALE','INTERVALLE'),),
             VALE            =SIMP(statut='f',typ='I',max='**'),
             DEBUT           =SIMP(statut='f',typ='I'),
             INTERVALLE      =FACT(statut='f',max='**',
                 regles=(UN_PARMI('NOMBRE','PAS'),),
                 JUSQU_A         =SIMP(statut='o',typ='I'),
                 NOMBRE          =SIMP(statut='f',typ='I',val_min=1,),
                 PAS             =SIMP(statut='f',typ='I',val_min=1,),
             ),
         ),


         # extraction d'une liste de nume_ordre dans une sd_resultat :
         #------------------------------------------------------------
         b_extr       =BLOC(condition = "OPERATION == 'NUME_ORDRE'",
             RESULTAT        =SIMP(statut='o',typ=resultat_sdaster),
             PARAMETRE       =SIMP(statut='o',typ='TXM',),
             INTERV_R        =SIMP(statut='o',typ='R',min=2,max=2),
         ),


         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2)),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS
DEFI_LIST_REEL=OPER(nom="DEFI_LIST_REEL",op=24,sd_prod=listr8_sdaster,
                    fr="Dfinir une liste de rels strictement croissante",
                    reentrant='n',
            UIinfo={"groupes":("Fonction",)},
         regles=(UN_PARMI('VALE','DEBUT',),
                 EXCLUS('VALE','INTERVALLE'),
                 ENSEMBLE('DEBUT','INTERVALLE')),
         VALE            =SIMP(statut='f',typ='R',max='**'),
         DEBUT           =SIMP(statut='f',typ='R'),
         INTERVALLE      =FACT(statut='f',max='**',
           regles=(UN_PARMI('NOMBRE','PAS'),),
           JUSQU_A         =SIMP(statut='o',typ='R'),
           NOMBRE          =SIMP(statut='f',typ='I'),
           PAS             =SIMP(statut='f',typ='R'),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2)),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE PELLET J.PELLET
DEFI_MAILLAGE=OPER(nom="DEFI_MAILLAGE",op=  88,sd_prod=maillage_sdaster,
                   fr="Dfinition d'un nouveau maillage  partir de macro-lments",
                   reentrant='n',
            UIinfo={"groupes":("Maillage",)},
         DEFI_SUPER_MAILLE =FACT(statut='o',max='**',
           MACR_ELEM       =SIMP(statut='o',typ=(macr_elem_stat,macr_elem_dyna),max='**' ),
           SUPER_MAILLE    =SIMP(statut='f',typ=ma,max='**'),
           TRAN            =SIMP(statut='f',typ='R',max=3),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
           b_angl_naut     =BLOC(condition = "ANGL_NAUT != None",
             CENTRE          =SIMP(statut='f',typ='R',max=3),
           ),
         ),
         RECO_GLOBAL     =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','SUPER_MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           SUPER_MAILLE    =SIMP(statut='f',typ=ma,max='**'),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
           PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-3 ),
         ),
         RECO_SUPER_MAILLE =FACT(statut='f',max='**',
           SUPER_MAILLE    =SIMP(statut='o',typ=ma,max='**'),
           GROUP_NO        =SIMP(statut='o',typ=grno,max='**'),
           OPTION          =SIMP(statut='f',typ='TXM',defaut="GEOMETRIQUE",into=("GEOMETRIQUE","NOEUD_A_NOEUD","INVERSE") ),
           geometrique     =BLOC(condition = "OPTION == 'GEOMETRIQUE'",
             CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-3 ),
           ),
         ),
         DEFI_NOEUD      =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','NOEUD_INIT'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",),
                                 fr="Renommage de tous les noeuds" ),
           NOEUD_INIT      =SIMP(statut='f',typ=no,
                                 fr="Renommage d un seul noeud"),                     
           b_tout          =BLOC(condition = "TOUT != None",
             PREFIXE         =SIMP(statut='f',typ='TXM' ),
             INDEX           =SIMP(statut='o',typ='I',max='**'),
           ),
           b_noeud_init    =BLOC(condition = "NOEUD_INIT != None",
             SUPER_MAILLE    =SIMP(statut='o',typ=ma),
             NOEUD_FIN       =SIMP(statut='o',typ=no),
           ),        
         ),
         DEFI_GROUP_NO   =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','SUPER_MAILLE'),
                AU_MOINS_UN('INDEX','GROUP_NO_FIN'),
                   ENSEMBLE('GROUP_NO_INIT','GROUP_NO_FIN'),),
#  la regle ancien catalogue AU_MOINS_UN__: ( INDEX , GROUP_NO_FIN ) incoherente avec doc U           
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",),
                                 fr="Cration de plusieurs groupes de noeuds" ),
           SUPER_MAILLE    =SIMP(statut='f',typ=ma,
                                 fr="Cration de plusieurs groupes de noeuds"),
           GROUP_NO_INIT   =SIMP(statut='f',typ=grno,
                                 fr="Cration d un seul groupe de noeuds"),
           PREFIXE         =SIMP(statut='f',typ='TXM' ),
           INDEX           =SIMP(statut='f',typ='I',max='**'),
           GROUP_NO_FIN    =SIMP(statut='f',typ=grno),
         ),
)  ;
#& MODIF COMMANDE  DATE 22/12/2008   AUTEUR PROIX J-M.PROIX 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE
DEFI_MATERIAU=OPER(nom="DEFI_MATERIAU",op=5,sd_prod=mater_sdaster,
                   fr="Dfinition des paramtres dcrivant le comportement d un matriau",
                   reentrant='f',
            UIinfo={"groupes":("Modlisation",)},
       regles=(EXCLUS('ELAS','ELAS_FO','ELAS_FLUI','ELAS_ISTR','ELAS_ISTR_FO','ELAS_ORTH',
                      'ELAS_ORTH_FO','ELAS_COQUE','ELAS_COQUE_FO',
                      'ELAS_HYPER','ELAS_2NDG',),
               EXCLUS('THER','THER_FO','THER_ORTH','THER_NL'),
               EXCLUS('ECRO_LINE','ECRO_LINE_FO','ECRO_PUIS'),
               EXCLUS('TAHERI','TAHERI_FO'),
               EXCLUS('ROUSSELIER','ROUSSELIER_FO'),
               EXCLUS('VISC_SINH','VISC_SINH_FO'),
               PRESENT_PRESENT('ROUSSELIER','TRACTION'),
               PRESENT_PRESENT('ROUSSELIER_FO','TRACTION'),
               EXCLUS('CIN1_CHAB','CIN1_CHAB_FO'),
               EXCLUS('CIN2_CHAB','CIN2_CHAB_FO'),
               EXCLUS('VISCOCHAB','VISCOCHAB_FO'),
               EXCLUS('LEMAITRE','LEMAITRE_FO','VISC_IRRA_LOG',
               'LEMA_SEUIL','LEMA_SEUIL_FO','LEMAITRE_IRRA','LMARC_IRRA',),
               EXCLUS('LMARC','LMARC_FO'),
               EXCLUS('META_LEMA_ANI','META_LEMA_ANI_FO'),
               EXCLUS('VMIS_POUTRE','VMIS_POUTRE_FO'),
               EXCLUS('VENDOCHAB','VENDOCHAB_FO'),
               PRESENT_PRESENT('BPEL_ACIER','ELAS'),
               EXCLUS('RCCM','RCCM_FO'),
               EXCLUS('WEIBULL','WEIBULL_FO'),
               PRESENT_PRESENT('LAIGLE','ELAS'),
               PRESENT_PRESENT('LETK','ELAS'),
               PRESENT_PRESENT('DRUCK_PRAGER','ELAS'),
               PRESENT_PRESENT('ELAS_GONF','ELAS'),
               PRESENT_PRESENT('HOEK_BROWN','ELAS'),
               EXCLUS('MAZARS','MAZARS_FO'),
               PRESENT_PRESENT('JOINT_BA','ELAS'),
               PRESENT_PRESENT('CABLE','ELAS'),
               ),
           MATER      =SIMP(statut='f',typ=mater_sdaster),
#
# comportement lastique
#
           ELAS            =FACT(statut='f',
             E               =SIMP(statut='o',typ='R',val_min=0.E+0),
             NU              =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=0.5E+0),
             RHO             =SIMP(statut='f',typ='R'),
             ALPHA           =SIMP(statut='f',typ='R'),
             AMOR_ALPHA      =SIMP(statut='f',typ='R'),
             AMOR_BETA       =SIMP(statut='f',typ='R'),
             AMOR_HYST       =SIMP(statut='f',typ='R'),
           ),
           ELAS_FO         =FACT(statut='f',
             regles=(PRESENT_PRESENT('ALPHA','TEMP_DEF_ALPHA'),),
             E               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO             =SIMP(statut='f',typ='R'),
             TEMP_DEF_ALPHA  =SIMP(statut='f',typ='R'),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.),
             ALPHA           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_ALPHA      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_BETA       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_HYST       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K_DESSIC        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             B_ENDOGE        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             FONC_DESORP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP","INST","HYDR","SECH","NEUT1","NEUT2",) ),
           ),
           ELAS_FLUI       =FACT(statut='f',
             E               =SIMP(statut='o',typ='R'),
             NU              =SIMP(statut='o',typ='R'),
             RHO             =SIMP(statut='o',typ='R'),
             PROF_RHO_F_INT  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PROF_RHO_F_EXT  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COEF_MASS_AJOU  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("ABSC",) ),
           ),
           ELAS_ISTR       =FACT(statut='f',
             E_L             =SIMP(statut='o',typ='R'),
             E_N             =SIMP(statut='o',typ='R'),
             NU_LT           =SIMP(statut='o',typ='R'),
             NU_LN           =SIMP(statut='o',typ='R'),
             G_LN            =SIMP(statut='o',typ='R'),
             RHO             =SIMP(statut='f',typ='R'),
             ALPHA_L         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             ALPHA_N         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           ELAS_ISTR_FO    =FACT(statut='f',
             regles=(
                      PRESENT_PRESENT('ALPHA_L','TEMP_DEF_ALPHA'),
                      PRESENT_PRESENT('ALPHA_N','TEMP_DEF_ALPHA'),
                    ),
             E_L             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             E_N             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_LT           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_LN           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_LN            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO             =SIMP(statut='f',typ='R'),
             TEMP_DEF_ALPHA  =SIMP(statut='f',typ='R'),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.),
             ALPHA_L         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALPHA_N         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP","INST")),
           ),
           ELAS_ORTH       =FACT(statut='f',
             E_L             =SIMP(statut='o',typ='R'),
             E_T             =SIMP(statut='o',typ='R'),
             E_N             =SIMP(statut='f',typ='R'),
             NU_LT           =SIMP(statut='o',typ='R'),
             NU_LN           =SIMP(statut='f',typ='R'),
             NU_TN           =SIMP(statut='f',typ='R'),
             G_LT            =SIMP(statut='o',typ='R'),
             G_LN            =SIMP(statut='f',typ='R'),
             G_TN            =SIMP(statut='f',typ='R'),
             RHO             =SIMP(statut='f',typ='R'),
             ALPHA_L         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             ALPHA_T         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             ALPHA_N         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             XT              =SIMP(statut='f',typ='R',defaut= 1. ),
             XC              =SIMP(statut='f',typ='R',defaut= 1. ),
             YT              =SIMP(statut='f',typ='R',defaut= 1. ),
             YC              =SIMP(statut='f',typ='R',defaut= 1. ),
             S_LT            =SIMP(statut='f',typ='R',defaut= 1. ),
             AMOR_ALPHA      =SIMP(statut='f',typ='R'),
             AMOR_BETA       =SIMP(statut='f',typ='R'),
             AMOR_HYST       =SIMP(statut='f',typ='R'),
           ),
           ELAS_ORTH_FO    =FACT(statut='f',
             regles=(
                      PRESENT_PRESENT('ALPHA_L','TEMP_DEF_ALPHA'),
                      PRESENT_PRESENT('ALPHA_N','TEMP_DEF_ALPHA'),
                      PRESENT_PRESENT('ALPHA_T','TEMP_DEF_ALPHA'),
                    ),
             E_L             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             E_T             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             E_N             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_LT           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_LN           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_TN           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_LT            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_LN            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_TN            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO             =SIMP(statut='f',typ='R'),
             TEMP_DEF_ALPHA  =SIMP(statut='f',typ='R'),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1. ),
             ALPHA_L         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALPHA_T         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALPHA_N         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP","INST",) ),
             AMOR_ALPHA      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_BETA       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_HYST       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ELAS_HYPER      =FACT(statut='f',
                                 regles=(UN_PARMI('K','NU'),),
             C10             =SIMP(statut='f',typ='R',defaut=0.0),
             C01             =SIMP(statut='o',typ='R'),
             C20             =SIMP(statut='f',typ='R',defaut=0.0),
             K               =SIMP(statut='f',typ='R'),
             RHO             =SIMP(statut='f',typ='R',defaut=0.0),
             NU              =SIMP(statut='f',typ='R',val_min=-1.E+0,val_max=0.5E+0),
           ),
           ELAS_COQUE      =FACT(statut='f',
             regles=(EXCLUS('MEMB_L','M_LLLL',),
                     PRESENT_PRESENT('MEMB_L','MEMB_LT', 'MEMB_T','MEMB_G_LT','FLEX_L','FLEX_LT',
                                     'FLEX_T','FLEX_G_LT','CISA_L','CISA_T',),
                     PRESENT_PRESENT('M_LLLL','M_LLTT','M_LLLT','M_TTTT','M_TTLT','M_LTLT','F_LLLL',
                                     'F_LLTT','F_LLLT','F_TTTT','F_TTLT','F_LTLT','MF_LLLL',
                                     'MF_LLTT','MF_LLLT','MF_TTTT','MF_TTLT','MF_LTLT','MC_LLLZ',
                                     'MC_LLTZ','MC_TTLZ','MC_TTTZ','MC_LTLZ','MC_LTTZ','FC_LLLZ',
                                     'FC_LLTZ','FC_TTLZ','FC_TTTZ','FC_LTLZ','FC_LTTZ','C_LZLZ',
                                     'C_LZTZ','C_TZTZ'),),
             MEMB_L          =SIMP(statut='f',typ='R'),
             MEMB_LT         =SIMP(statut='f',typ='R'),
             MEMB_T          =SIMP(statut='f',typ='R'),
             MEMB_G_LT       =SIMP(statut='f',typ='R'),
             FLEX_L          =SIMP(statut='f',typ='R'),
             FLEX_LT         =SIMP(statut='f',typ='R'),
             FLEX_T          =SIMP(statut='f',typ='R'),
             FLEX_G_LT       =SIMP(statut='f',typ='R'),
             CISA_L          =SIMP(statut='f',typ='R'),
             CISA_T          =SIMP(statut='f',typ='R'),
             M_LLLL          =SIMP(statut='f',typ='R'),
             M_LLTT          =SIMP(statut='f',typ='R'),
             M_LLLT          =SIMP(statut='f',typ='R'),
             M_TTTT          =SIMP(statut='f',typ='R'),
             M_TTLT          =SIMP(statut='f',typ='R'),
             M_LTLT          =SIMP(statut='f',typ='R'),
             F_LLLL          =SIMP(statut='f',typ='R'),
             F_LLTT          =SIMP(statut='f',typ='R'),
             F_LLLT          =SIMP(statut='f',typ='R'),
             F_TTTT          =SIMP(statut='f',typ='R'),
             F_TTLT          =SIMP(statut='f',typ='R'),
             F_LTLT          =SIMP(statut='f',typ='R'),
             MF_LLLL         =SIMP(statut='f',typ='R'),
             MF_LLTT         =SIMP(statut='f',typ='R'),
             MF_LLLT         =SIMP(statut='f',typ='R'),
             MF_TTTT         =SIMP(statut='f',typ='R'),
             MF_TTLT         =SIMP(statut='f',typ='R'),
             MF_LTLT         =SIMP(statut='f',typ='R'),
             MC_LLLZ         =SIMP(statut='f',typ='R'),
             MC_LLTZ         =SIMP(statut='f',typ='R'),
             MC_TTLZ         =SIMP(statut='f',typ='R'),
             MC_TTTZ         =SIMP(statut='f',typ='R'),
             MC_LTLZ         =SIMP(statut='f',typ='R'),
             MC_LTTZ         =SIMP(statut='f',typ='R'),
             FC_LLLZ         =SIMP(statut='f',typ='R'),
             FC_LLTZ         =SIMP(statut='f',typ='R'),
             FC_TTLZ         =SIMP(statut='f',typ='R'),
             FC_TTTZ         =SIMP(statut='f',typ='R'),
             FC_LTLZ         =SIMP(statut='f',typ='R'),
             FC_LTTZ         =SIMP(statut='f',typ='R'),
             C_LZLZ          =SIMP(statut='f',typ='R'),
             C_LZTZ          =SIMP(statut='f',typ='R'),
             C_TZTZ          =SIMP(statut='f',typ='R'),
             RHO             =SIMP(statut='f',typ='R'),
             ALPHA           =SIMP(statut='f',typ='R'),
           ),
           ELAS_COQUE_FO   =FACT(statut='f',
             regles=(EXCLUS('MEMB_L','M_LLLL',),
                     PRESENT_PRESENT('MEMB_L','MEMB_LT','MEMB_T','MEMB_G_LT','FLEX_L','FLEX_LT',
                                     'FLEX_T','FLEX_G_LT','CISA_L','CISA_T',),
                     PRESENT_PRESENT('M_LLLL','M_LLTT','M_LLLT','M_TTTT','M_TTLT','M_LTLT','F_LLLL',
                                     'F_LLTT','F_LLLT','F_TTTT','F_TTLT','F_LTLT','MF_LLLL','MF_LLTT',
                                     'MF_LLLT','MF_TTTT','MF_TTLT','MF_LTLT','MC_LLLZ','MC_LLTZ',
                                     'MC_TTLZ','MC_TTTZ','MC_LTLZ','MC_LTTZ','FC_LLLZ','FC_LLTZ',
                                     'FC_TTLZ','FC_TTTZ','FC_LTLZ','FC_LTTZ','C_LZLZ','C_LZTZ','C_TZTZ'),),
             MEMB_L          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MEMB_LT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MEMB_T          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MEMB_G_LT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FLEX_L          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FLEX_LT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FLEX_T          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FLEX_G_LT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CISA_L          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CISA_T          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_LLLL          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_LLTT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_LLLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_TTTT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_TTLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_LTLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_LLLL          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_LLTT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_LLLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_TTTT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_TTLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_LTLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_LLLL         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_LLTT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_LLLT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_TTTT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_TTLT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_LTLT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_LLLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_LLTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_TTLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_TTTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_LTLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_LTTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_LLLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_LLTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_TTLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_TTTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_LTLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_LTTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_LZLZ          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_LZTZ          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_TZTZ          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO             =SIMP(statut='f',typ='R'),
             ALPHA           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP","INST") ),
           ),
           ELAS_2NDG        =FACT(statut='f',
             A1              =SIMP(statut='o',typ='R'),
             A2              =SIMP(statut='f',typ='R'),
             A3              =SIMP(statut='f',typ='R'),
             A4              =SIMP(statut='f',typ='R'),
             A5              =SIMP(statut='f',typ='R'),
           ),
           CABLE           =FACT(statut='f',
             EC_SUR_E        =SIMP(statut='f',typ='R',defaut= 1.E-4 ),
           ),
#
# comportement mcanique non linaire
#
           TRACTION        =FACT(statut='f',
             SIGM            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("EPSI","TEMP","HYDR","SECH",) ),
           ),
           ECRO_LINE       =FACT(statut='f',
             D_SIGM_EPSI     =SIMP(statut='o',typ='R',),
             SY              =SIMP(statut='o',typ='R',),
           ),
           ECRO_LINE_FO    =FACT(statut='f',
             D_SIGM_EPSI     =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SY              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           ECRO_PUIS       =FACT(statut='f',
             SY              =SIMP(statut='o',typ='R',),
             A_PUIS          =SIMP(statut='o',typ='R',val_min=0.0),
             N_PUIS          =SIMP(statut='o',typ='R',val_min=1.E-6),
           ),
           ECRO_PUIS_FO    =FACT(statut='f',
             SY              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_PUIS          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             N_PUIS          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           BETON_ECRO_LINE =FACT(statut='f',
             D_SIGM_EPSI     =SIMP(statut='o',typ='R'),
             SYT             =SIMP(statut='o',typ='R'),
             SYC             =SIMP(statut='f',typ='R'),
           ),
           BETON_REGLE_PR =FACT(statut='f',
             D_SIGM_EPSI     =SIMP(statut='o',typ='R'),
             SYT             =SIMP(statut='o',typ='R'),
             SYC             =SIMP(statut='f',typ='R'),
             EPSC            =SIMP(statut='f',typ='R'),
             N               =SIMP(statut='f',typ='R'),
           ),
           ENDO_ORTH_BETON  =FACT(statut='f',
             ALPHA            =SIMP(statut='f',typ='R',defaut=0.9),
             K0               =SIMP(statut='o',typ='R'),
             K1               =SIMP(statut='o',typ='R'),
             K2               =SIMP(statut='f',typ='R',defaut=7.E-4),
             ECROB            =SIMP(statut='o',typ='R'),
             ECROD            =SIMP(statut='o',typ='R'),
           ),
           PRAGER          =FACT(statut='f',
             C               =SIMP(statut='o',typ='R'),
           ),
           PRAGER_FO       =FACT(statut='f',
             C               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           ECRO_FLEJOU     =FACT(statut='f',
             EP              =SIMP(statut='o',typ='R'),
             SY              =SIMP(statut='o',typ='R'),
             SU              =SIMP(statut='o',typ='R'),
             PUISS           =SIMP(statut='o',typ='R'),
           ),
           TAHERI          =FACT(statut='f',
             R_0             =SIMP(statut='o',typ='R'),
             ALPHA           =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
             A               =SIMP(statut='o',typ='R'),
             B               =SIMP(statut='o',typ='R'),
             C1              =SIMP(statut='o',typ='R'),
             C_INF           =SIMP(statut='o',typ='R'),
             S               =SIMP(statut='o',typ='R'),
           ),
           TAHERI_FO       =FACT(statut='f',
             R_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALPHA           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C1              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_INF           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             S               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           ROUSSELIER      =FACT(statut='f',
             D               =SIMP(statut='o',typ='R'),
             SIGM_1          =SIMP(statut='o',typ='R'),
             PORO_INIT       =SIMP(statut='o',typ='R'),
             PORO_CRIT       =SIMP(statut='f',typ='R',defaut= 1. ),
             PORO_ACCE       =SIMP(statut='f',typ='R',defaut= 1. ),
             PORO_LIMI       =SIMP(statut='f',typ='R',defaut= 0.999 ),
             D_SIGM_EPSI_NORM=SIMP(statut='f',typ='R',defaut= 1. ),
             AN              =SIMP(statut='f',typ='R',defaut= 0. ),
             DP_MAXI         =SIMP(statut='f',typ='R',defaut= 0.1),
             BETA            =SIMP(statut='f',typ='R',defaut=0.85),
           ),
           ROUSSELIER_FO   =FACT(statut='f',
             D               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_1          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PORO_INIT       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PORO_CRIT       =SIMP(statut='f',typ='R',defaut= 1. ),
             PORO_ACCE       =SIMP(statut='f',typ='R',defaut= 1. ),
             PORO_LIMI       =SIMP(statut='f',typ='R',defaut= 0.999 ),
             D_SIGM_EPSI_NORM=SIMP(statut='f',typ='R',defaut= 1. ),
             AN              =SIMP(statut='f',typ='R',defaut= 0. ),
             DP_MAXI         =SIMP(statut='f',typ='R',defaut= 0.1),
             BETA            =SIMP(statut='f',typ='R',defaut=0.85),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           VISC_SINH      =FACT(statut='f',
             SIGM_0          =SIMP(statut='o',typ='R'),
             EPSI_0          =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
           ),
           VISC_SINH_FO      =FACT(statut='f',
             SIGM_0          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             EPSI_0          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           CIN1_CHAB  =FACT(statut='f',
             R_0             =SIMP(statut='o',typ='R'),
             R_I             =SIMP(statut='f',typ='R'),
             B               =SIMP(statut='f',typ='R',defaut= 0.0E+0),
             C_I             =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='f',typ='R',defaut= 1.0E+0),
             W               =SIMP(statut='f',typ='R',defaut= 0.0E+0),
             G_0             =SIMP(statut='o',typ='R'),
             A_I             =SIMP(statut='f',typ='R',defaut= 1.0E+0),
           ),
           CIN1_CHAB_FO  =FACT(statut='f',
             R_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             W               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",)),
           ),
           CIN2_CHAB  =FACT(statut='f',
             R_0             =SIMP(statut='o',typ='R'),
             R_I             =SIMP(statut='f',typ='R'),
             B               =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             C1_I            =SIMP(statut='o',typ='R'),
             C2_I            =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='f',typ='R',defaut= 1.),
             W               =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             G1_0            =SIMP(statut='o',typ='R'),
             G2_0            =SIMP(statut='o',typ='R'),
             A_I             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
           ),
           CIN2_CHAB_FO  =FACT(statut='f',
             R_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C1_I            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C2_I            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             W               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G1_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G2_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           MEMO_ECRO       =FACT(statut='f',
             MU              =SIMP(statut='o',typ='R'),
             Q_M             =SIMP(statut='o',typ='R'),
             Q_0             =SIMP(statut='o',typ='R'),
             ETA             =SIMP(statut='f',typ='R',defaut= 0.5E+0 ),
           ),
           MEMO_ECRO_FO        =FACT(statut='f',
             MU              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q_M             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ETA             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           VISCOCHAB       =FACT(statut='f',
             K_0             =SIMP(statut='o',typ='R'),
             A_K             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             A_R             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             K               =SIMP(statut='o',typ='R'),
             N               =SIMP(statut='o',typ='R'),
             ALP             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             B               =SIMP(statut='f',typ='R'),
             M_R             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             G_R             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             MU              =SIMP(statut='o',typ='R',defaut= 0.E+0 ),
             Q_M             =SIMP(statut='o',typ='R'),
             Q_0             =SIMP(statut='o',typ='R'),
             QR_0            =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             ETA             =SIMP(statut='f',typ='R',defaut= 0.5E+0 ),
             C1              =SIMP(statut='o',typ='R'),
             M_1             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             D1              =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             G_X1            =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             G1_0            =SIMP(statut='o',typ='R'),
             C2              =SIMP(statut='o',typ='R'),
             M_2             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             D2              =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             G_X2            =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             G2_0            =SIMP(statut='o',typ='R'),
             A_I             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
           ),
           VISCOCHAB_FO    =FACT(statut='f',
             K_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_K             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_R             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             N               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALP             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_R             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_R             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MU              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q_M             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             QR_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ETA             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C1              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_1             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D1              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_X1            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G1_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C2              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_2             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D2              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_X2            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G2_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           LEMAITRE        =FACT(statut='f',
             N               =SIMP(statut='o',typ='R'),
             UN_SUR_K        =SIMP(statut='o',typ='R'),
             UN_SUR_M        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           LEMAITRE_IRRA    =FACT(statut='f',
             N               =SIMP(statut='o',typ='R'),
             UN_SUR_K        =SIMP(statut='o',typ='R'),
             UN_SUR_M        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             QSR_K           =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             BETA            =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             PHI_ZERO        =SIMP(statut='f',typ='R',defaut= 1.E+20),
             L               =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             GRAN_A          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             GRAN_B          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             GRAN_S          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           LMARC_IRRA       =FACT(statut='f',
             DE_0            =SIMP(statut='o',typ='R'),
             R_0             =SIMP(statut='o',typ='R'),
             N               =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='o',typ='R'),
             Y_I             =SIMP(statut='o',typ='R'),
             Y_0             =SIMP(statut='o',typ='R'),
             B               =SIMP(statut='o',typ='R'),
             A_0             =SIMP(statut='o',typ='R'),
             RM              =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
             P               =SIMP(statut='o',typ='R'),
             P1              =SIMP(statut='o',typ='R'),
             P2              =SIMP(statut='o',typ='R'),
             M11             =SIMP(statut='o',typ='R'),
             M22             =SIMP(statut='o',typ='R'),
             M33             =SIMP(statut='o',typ='R'),
             M66             =SIMP(statut='o',typ='R'),
             N11             =SIMP(statut='o',typ='R'),
             N22             =SIMP(statut='o',typ='R'),
             N33             =SIMP(statut='o',typ='R'),
             N66             =SIMP(statut='o',typ='R'),
             Q11             =SIMP(statut='o',typ='R'),
             Q22             =SIMP(statut='o',typ='R'),
             Q33             =SIMP(statut='o',typ='R'),
             Q66             =SIMP(statut='o',typ='R'),
             R11             =SIMP(statut='o',typ='R'),
             R22             =SIMP(statut='o',typ='R'),
             R33             =SIMP(statut='o',typ='R'),
             R66             =SIMP(statut='o',typ='R'),
             GRAN_A          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             GRAN_B          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             GRAN_S          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
          VISC_IRRA_LOG    =FACT(statut='f',
             A               =SIMP(statut='f',typ='R',defaut= 1.28E-1),
             B               =SIMP(statut='f',typ='R',defaut= 0.01159),
             CSTE_TPS        =SIMP(statut='f',typ='R',defaut= 0.3540),
             ENER_ACT        =SIMP(statut='f',typ='R',defaut= 5000.),
             FLUX_PHI        =SIMP(statut='o',typ='R',),
           ),
          GRAN_IRRA_LOG    =FACT(statut='f',
             A               =SIMP(statut='f',typ='R',defaut= 1.28E-1),
             B               =SIMP(statut='f',typ='R',defaut= 0.01159),
             CSTE_TPS        =SIMP(statut='f',typ='R',defaut= 0.3540),
             ENER_ACT        =SIMP(statut='f',typ='R',defaut= 5000.),
             FLUX_PHI        =SIMP(statut='o',typ='R',),
             GRAN_A          =SIMP(statut='f',typ='R',defaut= 0.E+0),
             GRAN_B          =SIMP(statut='f',typ='R',defaut= 0.E+0),
             GRAN_S          =SIMP(statut='f',typ='R',defaut= 0.E+0),
           ),
          LEMA_SEUIL   =FACT(statut='f',
             A               =SIMP(statut='o',typ='R',),
             S               =SIMP(statut='o',typ='R',),
           ),
          LEMA_SEUIL_FO=FACT(statut='f',
             A               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             S               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
         IRRAD3M=FACT(statut='f',
               R02      =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
               EPSI_U   =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
               RM       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
               AI0      =SIMP(statut='o',typ='R',val_min=0.0),
               ZETA_F   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
               ETAI_S   =SIMP(statut='o',typ='R',val_min=0.0),
               RG0      =SIMP(statut='o',typ='R',val_min=0.0),
               ALPHA    =SIMP(statut='o',typ='R',val_min=0.0),
               PHI0     =SIMP(statut='o',typ='R',val_min=0.0),
               KAPPA    =SIMP(statut='f',typ='R',val_min=0.0,defaut=0.8,val_max=1.0),
               ZETA_G   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
               TOLER_ET =SIMP(statut='c',typ='R',val_min=0.0,defaut=0.15 ),
               VERI_P   =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP","IRRA") ),
         ),
           LEMAITRE_FO     =FACT(statut='f',
             N               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             UN_SUR_K        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             UN_SUR_M        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           LMARC           =FACT(statut='f',
             DE_0            =SIMP(statut='o',typ='R'),
             R_0             =SIMP(statut='o',typ='R'),
             N               =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='o',typ='R'),
             Y_I             =SIMP(statut='o',typ='R'),
             Y_0             =SIMP(statut='o',typ='R'),
             B               =SIMP(statut='o',typ='R'),
             A_0             =SIMP(statut='o',typ='R'),
             RM              =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
             P               =SIMP(statut='o',typ='R'),
             P1              =SIMP(statut='o',typ='R'),
             P2              =SIMP(statut='o',typ='R'),
             M11             =SIMP(statut='o',typ='R'),
             M22             =SIMP(statut='o',typ='R'),
             M33             =SIMP(statut='o',typ='R'),
             M66             =SIMP(statut='o',typ='R'),
             N11             =SIMP(statut='o',typ='R'),
             N22             =SIMP(statut='o',typ='R'),
             N33             =SIMP(statut='o',typ='R'),
             N66             =SIMP(statut='o',typ='R'),
             Q11             =SIMP(statut='o',typ='R'),
             Q22             =SIMP(statut='o',typ='R'),
             Q33             =SIMP(statut='o',typ='R'),
             Q66             =SIMP(statut='o',typ='R'),
             R11             =SIMP(statut='o',typ='R'),
             R22             =SIMP(statut='o',typ='R'),
             R33             =SIMP(statut='o',typ='R'),
             R66             =SIMP(statut='o',typ='R'),
           ),
           LMARC_FO        =FACT(statut='f',
             DE_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             N               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Y_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Y_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RM              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             P               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             P1              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             P2              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M11             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M22             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M33             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M66             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             N11             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             N22             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             N33             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             N66             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q11             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q22             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q33             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q66             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R11             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R22             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R33             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R66             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
             META_LEMA_ANI     =FACT(statut='f',
             F1_A            =SIMP(statut='o',typ='R'),
             F2_A            =SIMP(statut='o',typ='R'),
             C_A             =SIMP(statut='o',typ='R'),
             F1_M            =SIMP(statut='o',typ='R'),
             F2_M            =SIMP(statut='o',typ='R'),
             C_M             =SIMP(statut='o',typ='R'),
             F1_N            =SIMP(statut='o',typ='R'),
             F2_N            =SIMP(statut='o',typ='R'),
             C_N             =SIMP(statut='o',typ='R'),
             F1_Q            =SIMP(statut='o',typ='R'),
             F2_Q            =SIMP(statut='o',typ='R'),
             C_Q             =SIMP(statut='o',typ='R'),
             F_MRR_RR        =SIMP(statut='o',typ='R'),
             C_MRR_RR        =SIMP(statut='o',typ='R'),
             F_MTT_TT        =SIMP(statut='o',typ='R'),
             C_MTT_TT        =SIMP(statut='o',typ='R'),
             F_MZZ_ZZ        =SIMP(statut='o',typ='R'),
             C_MZZ_ZZ        =SIMP(statut='o',typ='R'),
             F_MRT_RT        =SIMP(statut='o',typ='R'),
             C_MRT_RT        =SIMP(statut='o',typ='R'),
             F_MRZ_RZ        =SIMP(statut='o',typ='R'),
             C_MRZ_RZ        =SIMP(statut='o',typ='R'),
             F_MTZ_TZ        =SIMP(statut='o',typ='R'),
             C_MTZ_TZ        =SIMP(statut='o',typ='R'),
           ),
             META_LEMA_ANI_FO  =FACT(statut='f',
             F1_A            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_A            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_A             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_M            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_M            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_M             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_N            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_N            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_N             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_Q            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_Q            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_Q             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MRR_RR        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MRR_RR        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MTT_TT        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MTT_TT        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MZZ_ZZ        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MZZ_ZZ        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MRT_RT        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MRT_RT        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MRZ_RZ        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MRZ_RZ        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MTZ_TZ        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MTZ_TZ        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           VMIS_POUTRE     =FACT(statut='f',
             NP              =SIMP(statut='o',typ='R'),
             MEY             =SIMP(statut='o',typ='R'),
             MPY             =SIMP(statut='o',typ='R'),
             CAY             =SIMP(statut='o',typ='R'),
             CBY             =SIMP(statut='o',typ='R'),
             MEZ             =SIMP(statut='o',typ='R'),
             MPZ             =SIMP(statut='o',typ='R'),
             CAZ             =SIMP(statut='o',typ='R'),
             CBZ             =SIMP(statut='o',typ='R'),
             MPX             =SIMP(statut='o',typ='R'),
           ),
           VMIS_POUTRE_FO  =FACT(statut='f',
             NP              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MEY             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MPY             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CAY             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CBY             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MEZ             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MPZ             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CAZ             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CBZ             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MPX             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           ARME            =FACT(statut='f',
             KYE             =SIMP(statut='o',typ='R'),
             DLE             =SIMP(statut='o',typ='R'),
             KYP             =SIMP(statut='o',typ='R'),
             DLP             =SIMP(statut='o',typ='R'),
             KYG             =SIMP(statut='o',typ='R'),
           ),
           ASSE_CORN       =FACT(statut='f',
             NU_1            =SIMP(statut='o',typ='R'),
             MU_1            =SIMP(statut='o',typ='R'),
             DXU_1           =SIMP(statut='o',typ='R'),
             DRYU_1          =SIMP(statut='o',typ='R'),
             C_1             =SIMP(statut='o',typ='R'),
             NU_2            =SIMP(statut='o',typ='R'),
             MU_2            =SIMP(statut='o',typ='R'),
             DXU_2           =SIMP(statut='o',typ='R'),
             DRYU_2          =SIMP(statut='o',typ='R'),
             C_2             =SIMP(statut='o',typ='R'),
             KY              =SIMP(statut='o',typ='R'),
             KZ              =SIMP(statut='o',typ='R'),
             KRX             =SIMP(statut='o',typ='R'),
             KRZ             =SIMP(statut='o',typ='R'),
             R_P0            =SIMP(statut='f',typ='R',defaut= 1.E+4 ),
           ),
           DIS_CONTACT     =FACT(statut='f',
             RIGI_NOR        =SIMP(statut='f',typ='R' ),
             RIGI_TAN        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             AMOR_NOR        =SIMP(statut='f',typ='R' ),
             AMOR_TAN        =SIMP(statut='f',typ='R' ),
             COULOMB         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             DIST_1          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             DIST_2          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             JEU             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           DIS_GRICRA    =FACT(statut='f',
             KN_AX       =SIMP(statut='o',typ='R' ),
             KT_AX       =SIMP(statut='o',typ='R' ),
             COUL_AX     =SIMP(statut='o',typ='R' ),
             F_SER       =SIMP(statut='f',typ='R' ),
             F_SER_FO    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ET_AX       =SIMP(statut='f',typ='R',defaut=1.e-7 ),
             ET_ROT      =SIMP(statut='f',typ='R',defaut=1.e-7 ),
             ANG1        =SIMP(statut='f',typ='R' ),
             ANG2        =SIMP(statut='f',typ='R' ),
             PEN1        =SIMP(statut='f',typ='R' ),
             PEN2        =SIMP(statut='f',typ='R' ),
             PEN3        =SIMP(statut='f',typ='R' ),
             ANG1_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ANG2_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PEN1_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PEN2_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PEN3_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             regles=(EXCLUS('ANG1','ANG1_FO',),
                     UN_PARMI('ANG1','ANG1_FO',),
                     EXCLUS('F_SER','F_SER_FO',),
                     UN_PARMI('F_SER','F_SER_FO',),
                     PRESENT_PRESENT('ANG1','ANG2','PEN1','PEN2','PEN3',),
                     PRESENT_PRESENT('ANG1_FO','ANG2_FO','PEN1_FO','PEN2_FO','PEN3_FO',),
                                     ),
             VERI_P      =SIMP(statut='c',typ='TXM',max='**',defaut=("DRZ","INST","TEMP",) ),
           ),
           NADAI_B         =FACT(statut='f',
             F_C             =SIMP(statut='o',typ='R',val_min=0.E+0),
             F_T             =SIMP(statut='o',typ='R',val_min=0.E+0),
             CRIT_E_C        =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=1.E+0),
             EPSP_P_C        =SIMP(statut='o',typ='R',val_min=0.E+0),
             EPSP_R_C        =SIMP(statut='o',typ='R',val_min=0.E+0),
             EPSI_R_T        =SIMP(statut='o',typ='R',val_min=0.E+0),
             FAC_T_C         =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=1.E+0),
           ),
           BETON_DOUBLE_DP =FACT(statut='f',
             F_C             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_T             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COEF_BIAX       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ENER_COMP_RUPT  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ENER_TRAC_RUPT  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COEF_ELAS_COMP  =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=100.E+0),
             LONG_CARA       =SIMP(statut='f',typ='R',val_min=0.E+0),
             ECRO_COMP_P_PIC =SIMP(statut='f',typ='TXM',defaut="LINEAIRE",into=("LINEAIRE","PARABOLE") ),
             ECRO_TRAC_P_PIC =SIMP(statut='f',typ='TXM',defaut="LINEAIRE",into=("LINEAIRE","EXPONENT") ),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP","INST","HYDR","SECH",) ),
           ),
           LABORD_1D=FACT(statut='f',min=0 ,
             Y01             =SIMP(statut='o',typ='R'),
             Y02             =SIMP(statut='o',typ='R'),
             A1              =SIMP(statut='o',typ='R'),
             A2              =SIMP(statut='o',typ='R'),
             B1              =SIMP(statut='o',typ='R'),
             B2              =SIMP(statut='o',typ='R'),
             BETA1           =SIMP(statut='o',typ='R'),
             BETA2           =SIMP(statut='o',typ='R'),
             SIGF            =SIMP(statut='o',typ='R'),
           ),
         MAZARS=FACT(statut='f',min=0 ,
             EPSD0           =SIMP(statut='o',typ='R'),
             BETA            =SIMP(statut='o',typ='R'),
             AC              =SIMP(statut='o',typ='R'),
             BC              =SIMP(statut='o',typ='R'),
             AT              =SIMP(statut='o',typ='R'),
             BT              =SIMP(statut='o',typ='R'),
             CHI             =SIMP(statut='f',typ='R',val_min=0.0E+0,val_max=1.0E+0),
           ),
         MAZARS_FO=FACT(statut='f',min=0 ,
             EPSD0           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BETA            =SIMP(statut='o',typ='R'),
             AC              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BC              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AT              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BT              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP","SECH","HYDR") ),
             CHI             =SIMP(statut='f',typ='R'),
           ),
         JOINT_BA=FACT(statut='f',min=0 ,max=1,
             HPEN            =SIMP(statut='o',typ='R',defaut= 1.E+0,val_min=0.E+0),
             GTT             =SIMP(statut='o',typ='R',val_min=0.E+0),
             GAMD0           =SIMP(statut='o',typ='R',val_min=1.E-4,val_max=1.E-1),
             AD1             =SIMP(statut='o',typ='R',val_min=0.E+0),
             BD1             =SIMP(statut='o',typ='R',defaut= 5.E-1,val_min=1.E-1),
             GAMD2           =SIMP(statut='o',typ='R',val_min=1.E-4,val_max=1.E+0),
             AD2             =SIMP(statut='o',typ='R',val_min=0.E+0),
             BD2             =SIMP(statut='o',typ='R',defaut= 1.E+0,val_min=1.E-1),
             VIFROT          =SIMP(statut='o',typ='R',val_min=0.E+0),
             FA              =SIMP(statut='o',typ='R',val_min=0.E+0),
             FC              =SIMP(statut='o',typ='R',val_min=0.E+0),
             EPSTR0          =SIMP(statut='o',typ='R',val_min=1.E-4,val_max=1.E+0),
             ADN             =SIMP(statut='o',typ='R',val_min=0.E+0),
             BDN             =SIMP(statut='o',typ='R',defaut= 1.E+0,val_min=1.E-1),
           ),
          VENDOCHAB       =FACT(statut='f',
             S               =SIMP(statut='o',typ='R',defaut= 0.E+0),
             ALPHA_D         =SIMP(statut='o',typ='R',defaut= 0.E+0),
             BETA_D          =SIMP(statut='o',typ='R',defaut= 0.E+0),
             N               =SIMP(statut='o',typ='R'),
             UN_SUR_M        =SIMP(statut='o',typ='R',defaut= 0.E+0),
             UN_SUR_K        =SIMP(statut='o',typ='R'),
             R_D             =SIMP(statut='o',typ='R'),
             A_D             =SIMP(statut='o',typ='R'),
             K_D             =SIMP(statut='o',typ='R'),
           ),
           VENDOCHAB_FO    =FACT(statut='f',
             S               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALPHA_D         =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BETA_D          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             N               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             UN_SUR_M        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             UN_SUR_K        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R_D             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_D             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K_D             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP","X",) ),
           ),
           PINTO_MENEGOTTO =FACT(statut='f',
             SY              =SIMP(statut='o',typ='R'),
             EPSI_ULTM       =SIMP(statut='o',typ='R'),
             SIGM_ULTM       =SIMP(statut='o',typ='R'),
             ELAN            =SIMP(statut='f',typ='R',defaut= 4. ),
             EPSP_HARD       =SIMP(statut='o',typ='R'),
             R_PM            =SIMP(statut='f',typ='R',defaut= 20. ),
             EP_SUR_E        =SIMP(statut='f',typ='R'),
             A1_PM           =SIMP(statut='f',typ='R',defaut= 18.5 ),
             A2_PM           =SIMP(statut='f',typ='R',defaut= 0.15 ),
             A6_PM           =SIMP(statut='f',typ='R',defaut= 620. ),
             C_PM            =SIMP(statut='f',typ='R',defaut= 0.5 ),
             A_PM            =SIMP(statut='f',typ='R',defaut= 6.0E-3 ),
           ),
           BPEL_BETON      =FACT(statut='f',
             PERT_FLUA       =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             PERT_RETR       =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           BPEL_ACIER      =FACT(statut='f',
            regles=(PRESENT_PRESENT('RELAX_1000','F_PRG',),
                     PRESENT_PRESENT('MU0_RELAX','F_PRG',),),
             RELAX_1000      =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             MU0_RELAX       =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             F_PRG           =SIMP(statut='f',typ='R'),
             FROT_COURB      =SIMP(statut='f',typ='R',defaut=0.E+0),
             FROT_LINE       =SIMP(statut='f',typ='R',defaut=0.E+0),
           ),
           CAM_CLAY      =FACT(statut='f',
             MU              =SIMP(statut='o',typ='R'),
             PORO            =SIMP(statut='o',typ='R'),
             LAMBDA          =SIMP(statut='o',typ='R'),
             KAPA            =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
             PRES_CRIT       =SIMP(statut='o',typ='R'),
             KCAM            =SIMP(statut='f',typ='R',val_min=0.E+0),
             PTRAC           =SIMP(statut='f',typ='R',val_max=0.E+0),
               regles=(PRESENT_PRESENT('PTRAC','KCAM',),),
           ),
           BARCELONE      =FACT(statut='f',
             MU              =SIMP(statut='o',typ='R'),
             PORO            =SIMP(statut='o',typ='R'),
             LAMBDA          =SIMP(statut='o',typ='R'),
             KAPA            =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
             PRES_CRIT       =SIMP(statut='o',typ='R'),
             PA            =SIMP(statut='o',typ='R'),
             R             =SIMP(statut='o',typ='R'),
             BETA          =SIMP(statut='o',typ='R'),
             KC            =SIMP(statut='o',typ='R'),
             PC0_INIT      =SIMP(statut='o',typ='R'),
             KAPAS         =SIMP(statut='o',typ='R'),
             LAMBDAS       =SIMP(statut='o',typ='R'),
             ALPHAB        =SIMP(statut='f',typ='R'),
           ),
           CJS             =FACT(statut='f',
             BETA_CJS        =SIMP(statut='o',typ='R'),
             RM              =SIMP(statut='o',typ='R'),
             N_CJS           =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             KP              =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             RC              =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             A_CJS           =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             B_CJS           =SIMP(statut='f',typ='R',defaut= 1.0E+25 ),
             C_CJS           =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             GAMMA_CJS       =SIMP(statut='o',typ='R'),
             MU_CJS          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             PCO             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             PA              =SIMP(statut='o',typ='R'),
             Q_INIT          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             R_INIT          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           HUJEUX   =FACT(statut='f',
             N      =SIMP(statut='o',typ='R' ),
             BETA   =SIMP(statut='o',typ='R' ),
             B      =SIMP(statut='o',typ='R' ),
             D      =SIMP(statut='o',typ='R' ),
             PHI    =SIMP(statut='o',typ='R' ),
             ANGDIL =SIMP(statut='o',typ='R' ),
             PCO    =SIMP(statut='o',typ='R' ),
             PREF   =SIMP(statut='o',typ='R' ),
             ACYC   =SIMP(statut='o',typ='R' ),
             AMON   =SIMP(statut='o',typ='R' ),
             CCYC   =SIMP(statut='o',typ='R' ),
             CMON   =SIMP(statut='o',typ='R' ),
             RD_ELA =SIMP(statut='o',typ='R' ),
             RI_ELA =SIMP(statut='o',typ='R' ),
             RHYS   =SIMP(statut='o',typ='R' ),
             RMOB   =SIMP(statut='o',typ='R' ),
             XM     =SIMP(statut='o',typ='R' ),
             RD_CYC =SIMP(statut='o',typ='R' ),
             RI_CYC =SIMP(statut='o',typ='R' ),
             DILA   =SIMP(statut='o',typ='R' ),
             PTRAC  =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           ECRO_ASYM_LINE  =FACT(statut='f',
             DC_SIGM_EPSI    =SIMP(statut='o',typ='R'),
             SY_C            =SIMP(statut='o',typ='R'),
             DT_SIGM_EPSI    =SIMP(statut='o',typ='R'),
             SY_T            =SIMP(statut='o',typ='R'),
           ),
           GRANGER_FP      =FACT(statut='f',
             J1              =SIMP(statut='f',typ='R'),
             J2              =SIMP(statut='f',typ='R'),
             J3              =SIMP(statut='f',typ='R'),
             J4              =SIMP(statut='f',typ='R'),
             J5              =SIMP(statut='f',typ='R'),
             J6              =SIMP(statut='f',typ='R'),
             J7              =SIMP(statut='f',typ='R'),
             J8              =SIMP(statut='f',typ='R'),
             TAUX_1          =SIMP(statut='f',typ='R'),
             TAUX_2          =SIMP(statut='f',typ='R'),
             TAUX_3          =SIMP(statut='f',typ='R'),
             TAUX_4          =SIMP(statut='f',typ='R'),
             TAUX_5          =SIMP(statut='f',typ='R'),
             TAUX_6          =SIMP(statut='f',typ='R'),
             TAUX_7          =SIMP(statut='f',typ='R'),
             TAUX_8          =SIMP(statut='f',typ='R'),
             QSR_K           =SIMP(statut='f',typ='R'),
           ),
           GRANGER_FP_INDT =FACT(statut='f',
             J1              =SIMP(statut='f',typ='R'),
             J2              =SIMP(statut='f',typ='R'),
             J3              =SIMP(statut='f',typ='R'),
             J4              =SIMP(statut='f',typ='R'),
             J5              =SIMP(statut='f',typ='R'),
             J6              =SIMP(statut='f',typ='R'),
             J7              =SIMP(statut='f',typ='R'),
             J8              =SIMP(statut='f',typ='R'),
             TAUX_1          =SIMP(statut='f',typ='R'),
             TAUX_2          =SIMP(statut='f',typ='R'),
             TAUX_3          =SIMP(statut='f',typ='R'),
             TAUX_4          =SIMP(statut='f',typ='R'),
             TAUX_5          =SIMP(statut='f',typ='R'),
             TAUX_6          =SIMP(statut='f',typ='R'),
             TAUX_7          =SIMP(statut='f',typ='R'),
             TAUX_8          =SIMP(statut='f',typ='R'),
           ),
           V_GRANGER_FP    =FACT(statut='f',
             QSR_VEIL        =SIMP(statut='f',typ='R'),
             FONC_V          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("INST",) ),
           ),
           BETON_UMLV_FP   =FACT(statut='f',min=0 ,
             K_RS            =SIMP(statut='o',typ='R'),
             ETA_RS          =SIMP(statut='o',typ='R'),
             K_IS            =SIMP(statut='o',typ='R'),
             ETA_IS          =SIMP(statut='o',typ='R'),
             K_RD            =SIMP(statut='o',typ='R'),
             ETA_RD          =SIMP(statut='o',typ='R'),
             ETA_ID          =SIMP(statut='o',typ='R'),
             ETA_FD          =SIMP(statut='f',typ='R'),
           ),
           GLRC_DM         =FACT(statut='f',min=0,max=1,
             GAMMA_T         =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=1.E+0),
             GAMMA_F         =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=1.E+0),
             SYT             =SIMP(statut='o',typ='R',val_min=0.E+0),
             SYF             =SIMP(statut='o',typ='R',val_min=0.E+0),
             EF              =SIMP(statut='f',typ='R',val_min=0.E+0),
             NUF             =SIMP(statut='f',typ='R',val_min=0.E+0,val_max=0.5+0),
           ),
           GATT_MONERIE    =FACT(statut='f',min=0,max=1,
             D_GRAIN         =SIMP(statut='o',typ='R',val_min=0.E+0),
             PORO_INIT       =SIMP(statut='o',typ='R',val_min=0.E+0),
             EPSI_01         =SIMP(statut='o',typ='R',defaut= 2.7252E-10,val_min=0.E+0),
             EPSI_02         =SIMP(statut='o',typ='R',defaut= 9.1440E-41,val_min=0.E+0),
           ),
           CORR_ACIER   =FACT(statut='f',min=0 ,max=1,
             D_CORR           =SIMP(statut='o',typ='R'),
             ECRO_K           =SIMP(statut='o',typ='R'),
             ECRO_M           =SIMP(statut='o',typ='R'),
             SY              =SIMP(statut='o',typ='R'),
             ),
# Discrets non-linaires : dbut
         DIS_ECRO_CINE  =FACT(statut='f',
            fr="Loi pour les discrets avec rouissage cinematique.",
            regles=(PRESENT_PRESENT('LIMY_DX','KCIN_DX',),PRESENT_PRESENT('PUIS_DX','LIMU_DX',),
                    PRESENT_PRESENT('LIMY_DY','KCIN_DY',),PRESENT_PRESENT('PUIS_DY','LIMU_DY',),
                    PRESENT_PRESENT('LIMY_DZ','KCIN_DZ',),PRESENT_PRESENT('PUIS_DZ','LIMU_DZ',),
                    PRESENT_PRESENT('LIMY_RX','KCIN_RX',),PRESENT_PRESENT('PUIS_RX','LIMU_RX',),
                    PRESENT_PRESENT('LIMY_RY','KCIN_RY',),PRESENT_PRESENT('PUIS_RY','LIMU_RY',),
                    PRESENT_PRESENT('LIMY_RZ','KCIN_RZ',),PRESENT_PRESENT('PUIS_RZ','LIMU_RZ',),),
            LIMY_DX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Effort limite lastique suivant l'axe local x de l'lment."),
            LIMY_DY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Effort limite lastique suivant l'axe local y de l'lment."),
            LIMY_DZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Effort limite lastique suivant l'axe local z de l'lment."),
            LIMY_RX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Moment limite lastique suivant l'axe local x de l'lment."),
            LIMY_RY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Moment limite lastique suivant l'axe local y de l'lment."),
            LIMY_RZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Moment limite lastique suivant l'axe local z de l'lment."),
            KCIN_DX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Raideur suivant l'axe local x de l'lment."),
            KCIN_DY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Raideur suivant l'axe local y de l'lment."),
            KCIN_DZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Raideur suivant l'axe local z de l'lment."),
            KCIN_RX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Raideur suivant l'axe local Rx de l'lment."),
            KCIN_RY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Raideur suivant l'axe local Ry de l'lment."),
            KCIN_RZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Raideur suivant l'axe local Rz de l'lment."),
            LIMU_DX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Effort limite suivant l'axe local x de l'lment."),
            LIMU_DY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Effort limite suivant l'axe local y de l'lment."),
            LIMU_DZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Effort limite suivant l'axe local z de l'lment."),
            LIMU_RX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Moment limite suivant l'axe local x de l'lment."),
            LIMU_RY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Moment limite suivant l'axe local y de l'lment."),
            LIMU_RZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Moment limite suivant l'axe local z de l'lment."),
            PUIS_DX =SIMP(statut='f',typ='R',val_min = 1.0,
               fr="Coefficient de non-linarit suivant l'axe local x de l'lment."),
            PUIS_DY =SIMP(statut='f',typ='R',val_min = 1.0,
               fr="Coefficient de non-linarit suivant l'axe local y de l'lment."),
            PUIS_DZ =SIMP(statut='f',typ='R',val_min = 1.0,
               fr="Coefficient de non-linarit suivant l'axe local z de l'lment."),
            PUIS_RX =SIMP(statut='f',typ='R',val_min = 1.0,
               fr="Coefficient de non-linarit suivant l'axe local Rx de l'lment."),
            PUIS_RY =SIMP(statut='f',typ='R',val_min = 1.0,
               fr="Coefficient de non-linarit suivant l'axe local Ry de l'lment."),
            PUIS_RZ =SIMP(statut='f',typ='R',val_min = 1.0,
               fr="Coefficient de non-linarit suivant l'axe local Rz de l'lment."),
         ),
         DIS_VISC  =FACT(statut='f',
            fr="Loi pour un discret de type amortisseur visqueux.",
            regles=(PRESENT_PRESENT('PUIS_DX','COEF_DX',),
                    PRESENT_PRESENT('PUIS_DY','COEF_DY',),
                    PRESENT_PRESENT('PUIS_DZ','COEF_DZ',),
                    PRESENT_PRESENT('PUIS_RX','COEF_RX',),
                    PRESENT_PRESENT('PUIS_RY','COEF_RY',),
                    PRESENT_PRESENT('PUIS_RZ','COEF_RZ',),
                    ),
            PUIS_DX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Puissance dans la direction locale Dx de l'lment."),
            PUIS_DY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Puissance dans la direction locale Dy de l'lment."),
            PUIS_DZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Puissance dans la direction locale Dz de l'lment."),
            PUIS_RX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Puissance autour de la direction locale Rx de l'lment."),
            PUIS_RY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Puissance autour de la direction locale Ry de l'lment."),
            PUIS_RZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Puissance autour de la direction locale Rz de l'lment."),
            COEF_DX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Coefficient C dans la direction locale Dx de l'lment."),
            COEF_DY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Coefficient C dans la direction locale Dy de l'lment."),
            COEF_DZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Coefficient C dans la direction locale Dz de l'lment."),
            COEF_RX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Coefficient C autour de la direction locale Rx de l'lment."),
            COEF_RY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Coefficient C autour de la direction locale Ry de l'lment."),
            COEF_RZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Coefficient C autour de la direction locale Rz de l'lment."),
         ),
         DIS_BILI_ELAS  =FACT(statut='f',
            fr="Loi bi-linaire pour les discrets.",
            regles=(PRESENT_PRESENT('KDEB_DX','KFIN_DX','FPRE_DX',),
                    PRESENT_PRESENT('KDEB_DY','KFIN_DY','FPRE_DY',),
                    PRESENT_PRESENT('KDEB_DZ','KFIN_DZ','FPRE_DZ',),),
            KDEB_DX =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr="Raideur dbut suivant l'axe local x de l'lment."),
            KDEB_DY =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr="Raideur dbut suivant l'axe local y de l'lment."),
            KDEB_DZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr="Raideur dbut  suivant l'axe local z de l'lment."),
            KFIN_DX =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr="Raideur fin l'axe local x de l'lment."),
            KFIN_DY =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr="Raideur fin l'axe local y de l'lment."),
            KFIN_DZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr="Raideur fin l'axe local z de l'lment."),
            FPRE_DX =SIMP(statut='f',typ='R',
               fr="Effort de prserrage suivant l'axe local x de l'lment."),
            FPRE_DY =SIMP(statut='f',typ='R',
               fr="Effort de prserrage suivant l'axe local y de l'lment."),
            FPRE_DZ =SIMP(statut='f',typ='R',
               fr="Effort de prserrage suivant l'axe local z de l'lment."),
            VERI_P  =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",)),
         ),
# Discrets non-linaires : fin
#
# comportement thermique
#
           THER_NL         =FACT(statut='f',
             regles=(UN_PARMI('BETA','RHO_CP', ),),
             LAMBDA          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BETA            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO_CP          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           THER_HYDR       =FACT(statut='f',
             LAMBDA          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BETA            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AFFINITE        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CHALHYDR        =SIMP(statut='o',typ='R'),
             QSR_K           =SIMP(statut='o',typ='R'),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("HYDR","TEMP",) ),
           ),
           THER            =FACT(statut='f',
             LAMBDA          =SIMP(statut='o',typ='R'),
             RHO_CP          =SIMP(statut='f',typ='R'),
           ),
           THER_FO         =FACT(statut='f',
             LAMBDA          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO_CP          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("INST",) ),
           ),
           THER_ORTH       =FACT(statut='f',
             LAMBDA_L        =SIMP(statut='o',typ='R'),
             LAMBDA_T        =SIMP(statut='o',typ='R'),
             LAMBDA_N        =SIMP(statut='f',typ='R'),
             RHO_CP          =SIMP(statut='f',typ='R'),
           ),
           THER_COQUE      =FACT(statut='f',
             COND_LMM        =SIMP(statut='o',typ='R'),
             COND_TMM        =SIMP(statut='o',typ='R'),
             COND_LMP        =SIMP(statut='o',typ='R'),
             COND_TMP        =SIMP(statut='o',typ='R'),
             COND_LPP        =SIMP(statut='o',typ='R'),
             COND_TPP        =SIMP(statut='o',typ='R'),
             COND_LSI        =SIMP(statut='o',typ='R'),
             COND_TSI        =SIMP(statut='o',typ='R'),
             COND_NMM        =SIMP(statut='o',typ='R'),
             COND_NMP        =SIMP(statut='o',typ='R'),
             COND_NPP        =SIMP(statut='o',typ='R'),
             COND_NSI        =SIMP(statut='o',typ='R'),
             CMAS_MM         =SIMP(statut='f',typ='R'),
             CMAS_MP         =SIMP(statut='f',typ='R'),
             CMAS_PP         =SIMP(statut='f',typ='R'),
             CMAS_SI         =SIMP(statut='f',typ='R'),
           ),
           THER_COQUE_FO   =FACT(statut='f',
             COND_LMM        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_TMM        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_LMP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_TMP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_LPP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_TPP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_LSI        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_TSI        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_NMM        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_NMP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_NPP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_NSI        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CMAS_MM         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CMAS_MP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CMAS_PP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CMAS_SI         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           SECH_GRANGER    =FACT(statut='f',
             A               =SIMP(statut='o',typ='R'),
             B               =SIMP(statut='o',typ='R'),
             QSR_K           =SIMP(statut='o',typ='R'),
             TEMP_0_C        =SIMP(statut='o',typ='R'),
           ),
           SECH_MENSI      =FACT(statut='f',
             A               =SIMP(statut='o',typ='R'),
             B               =SIMP(statut='o',typ='R'),
           ),
           SECH_BAZANT     =FACT(statut='f',
             D1              =SIMP(statut='o',typ='R'),
             ALPHA_BAZANT    =SIMP(statut='o',typ='R'),
             N               =SIMP(statut='o',typ='R'),
             FONC_DESORP     =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           SECH_NAPPE      =FACT(statut='f',
             FONCTION        =SIMP(statut='o',typ=(nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP","TSEC",) ),
           ),
#
# comportement mtallurgique
#
           META_ACIER      =FACT(statut='f',
             TRC             =SIMP(statut='o',typ=(table_sdaster) ),
             AR3             =SIMP(statut='o',typ='R'),
             ALPHA           =SIMP(statut='o',typ='R'),
             MS0             =SIMP(statut='o',typ='R'),
             AC1             =SIMP(statut='o',typ='R'),
             AC3             =SIMP(statut='o',typ='R'),
             TAUX_1          =SIMP(statut='o',typ='R'),
             TAUX_3          =SIMP(statut='o',typ='R'),
             LAMBDA0         =SIMP(statut='f',typ='R'),
             QSR_K           =SIMP(statut='f',typ='R'),
             D10             =SIMP(statut='f',typ='R'),
             WSR_K           =SIMP(statut='f',typ='R'),
           ),
           META_ZIRC       =FACT(statut='f',
             TDEQ            =SIMP(statut='o',typ='R'),
             N               =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='o',typ='R'),
             T1C             =SIMP(statut='o',typ='R'),
             T2C             =SIMP(statut='o',typ='R'),
             AC              =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
             QSR_K           =SIMP(statut='o',typ='R'),
             T1R             =SIMP(statut='o',typ='R'),
             T2R             =SIMP(statut='o',typ='R'),
             AR              =SIMP(statut='o',typ='R'),
             BR              =SIMP(statut='o',typ='R'),
           ),
           DURT_META       =FACT(statut='f',
             F1_DURT         =SIMP(statut='o',typ='R'),
             F2_DURT         =SIMP(statut='o',typ='R'),
             F3_DURT         =SIMP(statut='o',typ='R'),
             F4_DURT         =SIMP(statut='o',typ='R'),
             C_DURT          =SIMP(statut='o',typ='R'),
           ),
           ELAS_META       =FACT(statut='f',
             E               =SIMP(statut='o',typ='R'),
             NU              =SIMP(statut='o',typ='R'),
             F_ALPHA         =SIMP(statut='o',typ='R'),
             C_ALPHA         =SIMP(statut='o',typ='R'),
             PHASE_REFE      =SIMP(statut='o',typ='TXM',into=("CHAUD","FROID")),
             EPSF_EPSC_TREF  =SIMP(statut='o',typ='R'),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.0E+0),
             F1_SY           =SIMP(statut='f',typ='R'),
             F2_SY           =SIMP(statut='f',typ='R'),
             F3_SY           =SIMP(statut='f',typ='R'),
             F4_SY           =SIMP(statut='f',typ='R'),
             C_SY            =SIMP(statut='f',typ='R'),
             SY_MELANGE      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_S_VP         =SIMP(statut='f',typ='R'),
             F2_S_VP         =SIMP(statut='f',typ='R'),
             F3_S_VP         =SIMP(statut='f',typ='R'),
             F4_S_VP         =SIMP(statut='f',typ='R'),
             C_S_VP          =SIMP(statut='f',typ='R' ),
             S_VP_MELANGE    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("META",)),
           ),
           ELAS_META_FO    =FACT(statut='f',
             regles=(
                      PRESENT_PRESENT('F_ALPHA','TEMP_DEF_ALPHA'),
                      PRESENT_PRESENT('C_ALPHA','TEMP_DEF_ALPHA'),
                    ),
             E               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_ALPHA         =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_ALPHA         =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PHASE_REFE      =SIMP(statut='o',typ='TXM',into=("CHAUD","FROID")),
             EPSF_EPSC_TREF  =SIMP(statut='o',typ='R'),
             TEMP_DEF_ALPHA  =SIMP(statut='f',typ='R'),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.0E+0),
             F1_SY           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_SY           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_SY           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_SY           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_SY            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SY_MELANGE      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_S_VP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_S_VP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_S_VP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_S_VP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_S_VP          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             S_VP_MELANGE    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP","META",)),
           ),
           META_ECRO_LINE  =FACT(statut='f',
             F1_D_SIGM_EPSI  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_D_SIGM_EPSI  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_D_SIGM_EPSI  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_D_SIGM_EPSI  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_D_SIGM_EPSI   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",)),
           ),
           META_TRACTION   =FACT(statut='f',
             SIGM_F1         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_F2         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_F3         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_F4         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_C          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("EPSI","TEMP",)),
           ),
           META_VISC_FO    =FACT(statut='f',
             F1_ETA          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_N            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_C            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_M            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_ETA          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_N            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_C            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_M            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_ETA          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_N            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_C            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_M            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_ETA          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_N            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_C            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_M            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_ETA           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_N             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_C             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_M             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           META_PT         =FACT(statut='f',
             F1_K            =SIMP(statut='f',typ='R'),
             F2_K            =SIMP(statut='f',typ='R'),
             F3_K            =SIMP(statut='f',typ='R'),
             F4_K            =SIMP(statut='f',typ='R'),
             F1_D_F_META     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_D_F_META     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_D_F_META     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_D_F_META     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP","META",) ),
           ),
           META_RE         =FACT(statut='f',
             C_F1_THETA      =SIMP(statut='f',typ='R'),
             C_F2_THETA      =SIMP(statut='f',typ='R'),
             C_F3_THETA      =SIMP(statut='f',typ='R'),
             C_F4_THETA      =SIMP(statut='f',typ='R'),
             F1_C_THETA      =SIMP(statut='f',typ='R'),
             F2_C_THETA      =SIMP(statut='f',typ='R'),
             F3_C_THETA      =SIMP(statut='f',typ='R'),
             F4_C_THETA      =SIMP(statut='f',typ='R'),
           ),
#
# comportement fluide
#
           FLUIDE          =FACT(statut='f',
             regles=(EXCLUS('CELE_C','CELE_R'),),
             RHO             =SIMP(statut='o',typ='R'),
             CELE_C          =SIMP(statut='f',typ='C'),
             CELE_R          =SIMP(statut='f',typ='R'),
           ),
# =================================================================================
# COMPORTEMENT THERMO_HYDRO_MECANIQUE
# LES DONNEES NECESSAIRES A LA DEFINITION DU MATERIAU SONT DEPENDANTES
# DE LA LOI DE COUPLAGE THM DE LA RELATION
# LE COMPORTEMENT DE COUPLAGE COMP_THM N EST VALABLE QUE POUR LES LOIS
# DE COUPLAGE : LIQU_SATU,LIQU_GAZ,GAZ,LIQU_GAZ_ATM,LIQU_VAPE_GAZ,LIQU_VAPE
# ET LIQU_AD_GAZ_VAPE
# LA CORRESPONDANCE AVEC LES VARIABLES CACHEES EST LA SUIVANTE :
# 1 -->  LIQU_SATU
# 2 -->  GAZ
# 3 -->  LIQU_VAPE
# 4 -->  LIQU_VAPE_GAZ
# 5 -->  LIQU_GAZ
# 6 -->  LIQU_GAZ_ATM
# 9 -->  LIQU_AD_GAZ_VAPE
# =================================================================================
           COMP_THM        = SIMP(statut='f', typ='TXM',
                                  into = ( "LIQU_SATU"     ,
                                           "LIQU_GAZ"      ,
                                           "GAZ"           ,
                                           "LIQU_GAZ_ATM"  ,
                                           "LIQU_VAPE_GAZ" ,
                                           "LIQU_VAPE"     ,
                                           "LIQU_AD_GAZ_VAPE" ,
                                          ) ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_SATU -------------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU -----------------------------------------------
# =================================================================================
           b_liqusatu      = BLOC(condition = "COMP_THM == 'LIQU_SATU' ",
                                 fr="Paramtres ncessaires pour une loi de couplage de type LIQU_SATU",
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1          = SIMP(statut='o',typ='R'),
                                           PORO          = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP          = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE2          = SIMP(statut='f',typ='R'),
                                           PRES_VAPE     = SIMP(statut='f',typ='R'),
                                           DEGR_SATU     = SIMP(statut='f',typ='R'),
                                           PRES_ATMO     = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 1.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO           = SIMP(statut='o',typ='R'),
                                           BIOT_COEF     = SIMP(statut='o',typ='R'),
                                           PESA_X        = SIMP(statut='o',typ='R'),
                                           PESA_Y        = SIMP(statut='o',typ='R'),
                                           PESA_Z        = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP            = SIMP(statut='f',typ='R'),
                                           PERM_IN       = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                                           regles = (EXCLUS('PERM_IN','PERM_END','PERMIN_X',),
                                                            PRESENT_PRESENT('PERMIN_X','PERMIN_Y','PERMIN_Z',), ),
                                           PERMIN_X      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Y      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Z      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT   = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ         = SIMP(statut='f',typ='R'),
                                           EMMAG           = SIMP(statut='f',typ='R'),
                                           SATU_PRES       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU=SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           SIGMA_T         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SIGMA_T       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_G_INTR     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CHAL_VAPO       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
         VERI_P          =SIMP(statut='c',typ='TXM',defaut=("TEMP","SAT","PORO","PGAZ","PCAP","ENDO",) ),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO           = SIMP(statut='o',typ='R'),
                                           UN_SUR_K      = SIMP(statut='o',typ='R'),
                                           VISC          = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP   = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA         = SIMP(statut='f',typ='R'),
                                           CP            = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                           VERI_P        = SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
                                         ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_GAZ         =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
           ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_VAPE_GAZ    =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
           ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_GAZ --------------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_GAZ --------------------------------------
# =================================================================================
           b_liqugaz      = BLOC(condition = "COMP_THM == 'LIQU_GAZ' ",
                                 fr="Paramtres ncessaires pour une loi de couplage de type LIQU_GAZ",
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PRE2             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           PRES_VAPE        = SIMP(statut='f',typ='R'),
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
                                           PRES_ATMO        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 5.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='o',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---Van Genhuchten et Muallen-----------------------------------------------------------------------------

                                           VG_N    = SIMP(statut='f',typ='R'),
                                           VG_SR    = SIMP(statut='f',typ='R'),
                                           VG_PR   = SIMP(statut='f',typ='R'),
                                           VG_SMAX = SIMP(statut='f',typ='R'),
                                           VG_SATUR = SIMP(statut='f',typ='R'),
#
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                           PERM_IN          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_X      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Y      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Z      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT   = SIMP(statut='f',typ='R'),
#
                                  regles = (EXCLUS('PERM_IN','PERM_END','PERMIN_X',),
                                            PRESENT_PRESENT('PERMIN_X','PERMIN_Y','PERMIN_Z',),
                                            ENSEMBLE('SATU_PRES','D_SATU_PRES','PERM_LIQU','D_PERM_LIQU_SATU',
                                                            'PERM_GAZ','D_PERM_SATU_GAZ','D_PERM_PRES_GAZ',),
                                            ENSEMBLE('VG_N','VG_SR','VG_PR','VG_SMAX','VG_SATUR',),
                                            UN_PARMI('VG_N','SATU_PRES'),
                                           ),

# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG           = SIMP(statut='f',typ='R'),
                                           SIGMA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SIGMA_T        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_G_INTR      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CHAL_VAPO        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
          VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP","SAT","PORO","PGAZ","PCAP","ENDO",) ),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ='R'),
                                           CP               = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                           VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL        = SIMP(statut='o',typ='R'),
                                           VISC            = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP     = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP              = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                           VERI_P          = SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
                                             ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_VAPE_GAZ    =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
           ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE GAZ -------------------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_GAZ ------------------------------------------------
# =================================================================================
           b_gaz          = BLOC(condition = "COMP_THM == 'GAZ' ",
                                 fr="Paramtres ncessaires pour une loi de couplage de type GAZ",
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='o',typ='R'),
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE2             = SIMP(statut='f',typ='R'),
                                           PRES_VAPE        = SIMP(statut='f',typ='R'),
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
                                           PRES_ATMO        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 2.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='o',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                           PERM_IN          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                                           regles = (EXCLUS('PERM_IN','PERM_END','PERMIN_X',),
                                                            PRESENT_PRESENT('PERMIN_X','PERMIN_Y','PERMIN_Z',), ),
                                           PERMIN_X      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Y      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Z      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT   = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG           = SIMP(statut='f',typ='R'),
                                           SATU_PRES       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU=SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           SIGMA_T         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SIGMA_T       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_G_INTR     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CHAL_VAPO       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
            VERI_P          =SIMP(statut='c',typ='TXM',defaut=("TEMP","SAT","PORO","PGAZ","PCAP","ENDO",) ),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                           VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
                                             ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_LIQU        =FACT(statut='f',
             RHO             =SIMP(statut='f',typ='R'),
             UN_SUR_K        =SIMP(statut='f',typ='R'),
             ALPHA           =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COEF_HENRY      =SIMP(statut='f',typ='R'),
             VERI_P          =SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
           ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_VAPE_GAZ    =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
           ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_GAZ_ATM ----------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_GAZ --------------------------------------
# =================================================================================
           b_liqugazatm   = BLOC(condition = "COMP_THM == 'LIQU_GAZ_ATM' ",
                                 fr="Paramtres ncessaires pour une loi de couplage de type LIQU_GAZ_ATM",
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE2             = SIMP(statut='f',typ='R'),
                                           PRES_VAPE        = SIMP(statut='f',typ='R'),
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
                                           PRES_ATMO        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 6.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='o',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                           PERM_IN          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                                           regles = (EXCLUS('PERM_IN','PERM_END','PERMIN_X',),
                                                            PRESENT_PRESENT('PERMIN_X','PERMIN_Y','PERMIN_Z',), ),
                                           PERMIN_X      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Y      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Z      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT   = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
             EMMAG           = SIMP(statut='f',typ='R'),
             R_GAZ           =SIMP(statut='f',typ='R'),
             PERM_GAZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_PERM_SATU_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_PERM_PRES_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGMA_T         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_SIGMA_T       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PERM_G_INTR     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CHAL_VAPO       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
             VERI_P          =SIMP(statut='c',typ='TXM',defaut=("TEMP","SAT","PORO","PGAZ","PCAP","ENDO",) ),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ='R'),
                                           CP               = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                           VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
                                             ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='f',
                                           MASS_MOL         = SIMP(statut='f',typ='R'),
                                           VISC             = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CP               = SIMP(statut='f',typ='R'),
                                           VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
                                             ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_VAPE_GAZ    =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
           ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_VAPE_GAZ ---------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_GAZ, THM_VAPE_GAZ ------------------------
# =================================================================================
           b_liquvapegaz  = BLOC(condition = "COMP_THM == 'LIQU_VAPE_GAZ' ",
                                 fr="Paramtres ncessaires pour une loi de couplage de type LIQU_VAPE_GAZ",
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PRE2             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
                                           PRES_VAPE        = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
                                           PRES_ATMO        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 4.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='o',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---Van Genhuchten et Muallen-----------------------------------------------------------------------------

                                           VG_N     = SIMP(statut='f',typ='R'),
                                           VG_SR    = SIMP(statut='f',typ='R'),
                                           VG_PR    = SIMP(statut='f',typ='R'),
                                           VG_SMAX  = SIMP(statut='f',typ='R'),
                                           VG_SATUR = SIMP(statut='f',typ='R'),
#
                                           FICKV_T          = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                           PERM_IN          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_X      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Y      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Z      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT   = SIMP(statut='f',typ='R'),
#
                                  regles = (EXCLUS('PERM_IN','PERM_END','PERMIN_X',),
                                            PRESENT_PRESENT('PERMIN_X','PERMIN_Y','PERMIN_Z',),
                                            ENSEMBLE('SATU_PRES','D_SATU_PRES','PERM_LIQU','D_PERM_LIQU_SATU',
                                                            'PERM_GAZ','D_PERM_SATU_GAZ','D_PERM_PRES_GAZ',),
                                            ENSEMBLE('VG_N','VG_SR','VG_PR','VG_SMAX','VG_SATUR',),
                                            UN_PARMI('VG_N','SATU_PRES'),
                                           ),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVE   ----------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG            = SIMP(statut='f',typ='R'),
                                           SIGMA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SIGMA_T        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_G_INTR      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CHAL_VAPO        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
         VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP","SAT" ,"PORO","PGAZ","PCAP","ENDO","PVAP","PLIQ","PAD",) ),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ='R'),
                                           CP               = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                           VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                           VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_VAPE_GAZ = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           CP               = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                           VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
                                             ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_AD_GAZ_VAPE -------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_GAZ, THM_VAPE_GAZ THM_AIR_DISSOUS---------
# =================================================================================
           b_liquadvape  = BLOC(condition = "COMP_THM == 'LIQU_AD_GAZ_VAPE' ",
                                 fr="Paramtres ncessaires pour une loi de couplage de type LIQU_AD_GAZ_VAPE",
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PRE2             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
                                           PRES_VAPE        = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
                                           PRES_ATMO        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 9.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='o',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---Van Genhuchten et Muallen-----------------------------------------------------------------------------
                                           VG_N     = SIMP(statut='f',typ='R'),
                                           VG_SR    = SIMP(statut='f',typ='R'),
                                           VG_PR    = SIMP(statut='f',typ='R'),
                                           VG_SMAX  = SIMP(statut='f',typ='R'),
                                           VG_SATUR = SIMP(statut='f',typ='R'),
#
                                           FICKV_T          = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                           PERM_IN          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_X      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Y      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Z      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT   = SIMP(statut='f',typ='R'),
#
                                  regles = (EXCLUS('PERM_IN','PERM_END','PERMIN_X',),
                                            PRESENT_PRESENT('PERMIN_X','PERMIN_Y','PERMIN_Z',),
                                            ENSEMBLE('SATU_PRES','D_SATU_PRES','PERM_LIQU','D_PERM_LIQU_SATU',
                                                            'PERM_GAZ','D_PERM_SATU_GAZ','D_PERM_PRES_GAZ',),
                                            ENSEMBLE('VG_N','VG_SR','VG_PR','VG_SMAX','VG_SATUR',),
                                            UN_PARMI('VG_N','SATU_PRES'),
                                           ),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG            = SIMP(statut='f',typ='R'),
                                           SIGMA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SIGMA_T        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_G_INTR      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CHAL_VAPO        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
#
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
         VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP","SAT","PORO","PGAZ","PCAP","ENDO","PVAP","PLIQ","PAD",) ),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ='R'),
                                           CP               = SIMP(statut='f',typ='R'),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                           VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                           VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_VAPE_GAZ = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           CP               = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                           VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_AIR_DISS = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='o',typ='R'),
                                           COEF_HENRY       = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           VERI_P      = SIMP(statut='c',typ='TXM',defaut=("TEMP",),),
                                             ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_VAPE -------------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_VAPE_GAZ ---------------------------------
# =================================================================================
           b_liquvape  = BLOC(condition = "COMP_THM == 'LIQU_VAPE' ",
                                 fr="Paramtres ncessaires pour une loi de couplage de type LIQU_VAPE",
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
                                           PRES_VAPE        = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE2             = SIMP(statut='f',typ='R'),
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
                                           PRES_ATMO        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 3.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='o',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---Van Genhuchten et Muallen-----------------------------------------------------------------------------

                                           VG_N    = SIMP(statut='f',typ='R'),
                                           VG_SR    = SIMP(statut='f',typ='R'),
                                           VG_PR   = SIMP(statut='f',typ='R'),
                                           VG_SMAX = SIMP(statut='f',typ='R'),
                                           VG_SATUR = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                           PERM_IN          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_X      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Y      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Z      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT   = SIMP(statut='f',typ='R'),
#
                                  regles = (EXCLUS('PERM_IN','PERM_END','PERMIN_X',),
                                            PRESENT_PRESENT('PERMIN_X','PERMIN_Y','PERMIN_Z',),
                                            ENSEMBLE('SATU_PRES','D_SATU_PRES','PERM_LIQU','D_PERM_LIQU_SATU',
                                                            'PERM_GAZ','D_PERM_SATU_GAZ','D_PERM_PRES_GAZ',),
                                            ENSEMBLE('VG_N','VG_SR','VG_PR','VG_SMAX','VG_SATUR',),
                                            UN_PARMI('VG_N','SATU_PRES'),
                                           ),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG            = SIMP(statut='f',typ='R'),
                                           SIGMA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SIGMA_T        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_G_INTR      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CHAL_VAPO        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
            VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP","SAT","PORO","PGAZ","PCAP","ENDO",) ),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ='R'),
                                           CP               = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_VAPE_GAZ = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           CP               = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                           VERI_P           = SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
                                             ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_GAZ         =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',defaut=("TEMP",)),
           ),
                                 ),
# courbes et coefficients associs  la fatigue et au dommage
#
           FATIGUE         =FACT(statut='f',
             regles=(PRESENT_ABSENT('WOHLER','A_BASQUIN','BETA_BASQUIN'),
                     PRESENT_ABSENT('WOHLER','A0','A1','A2','A3','SL'),
                     PRESENT_ABSENT('A_BASQUIN','A0','A1','A2','A3','SL'),
                     ENSEMBLE('A_BASQUIN','BETA_BASQUIN'),
                     ENSEMBLE('A0','A1','A2','A3','SL'),
                     PRESENT_PRESENT('A0','E_REFE'),
                     ENSEMBLE('D0','TAU0'),),
             WOHLER          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_BASQUIN       =SIMP(statut='f',typ='R'),
             BETA_BASQUIN    =SIMP(statut='f',typ='R'),
             A0              =SIMP(statut='f',typ='R'),
             A1              =SIMP(statut='f',typ='R'),
             A2              =SIMP(statut='f',typ='R'),
             A3              =SIMP(statut='f',typ='R'),
             SL              =SIMP(statut='f',typ='R'),
             MANSON_COFFIN   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             E_REFE          =SIMP(statut='f',typ='R'),
             D0              =SIMP(statut='f',typ='R'),
             TAU0            =SIMP(statut='f',typ='R'),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("SIGM","EPSI",) ),
           ),
           DOMMA_LEMAITRE  =FACT(statut='f',
             S               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             EPSP_SEUIL      =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             EXP_S           =SIMP(statut='f',typ='R',val_min=0.0E0,defaut=1.0),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           CISA_PLAN_CRIT  =FACT(statut='f',
             CRITERE       =SIMP(statut='o',typ='TXM',into=("MATAKE_MODI_AC",
                                                            "DANG_VAN_MODI_AC",
                                                            "DANG_VAN_MODI_AV",
                                                            "MATAKE_MODI_AV",
                                                            "FATESOCI_MODI_AV",
                                                            ) ),

             b_critere_matake =BLOC(condition="CRITERE=='MATAKE_MODI_AC' or CRITERE=='MATAKE_MODI_AV'",
                         fr="Cisaillement plan critique critre de matake pour les cas amplitude constante et amplitude variable",
               MATAKE_A         =SIMP(statut='o',typ='R'),
               MATAKE_B         =SIMP(statut='o',typ='R'),
               COEF_FLEX_TORS   =SIMP(statut='o',typ='R',val_min=1.0E0,val_max=1.7321E0),
             ),

             b_critere_dang_van =BLOC(condition="(CRITERE=='DANG_VAN_MODI_AC' or CRITERE=='DANG_VAN_MODI_AV')",
                                 fr="Critre de Dang Van modifi pour les cas amplitude constante et amplitude variable",
               D_VAN_A            =SIMP(statut='o',typ='R'),
               D_VAN_B            =SIMP(statut='o',typ='R'),
               COEF_CISA_TRAC     =SIMP(statut='o',typ='R',val_min=1.0E0,val_max=1.7321E0),
             ),

             b_critere_fate_soci =BLOC(condition="CRITERE=='FATESOCI_MODI_AV'",
                               fr="Critre de Fatemi et Socie, en lasticit ou lastoplasticit, pour le cas amplitude variable",
               FATSOC_A           =SIMP(statut='o',typ='R'),
               COEF_CISA_TRAC     =SIMP(statut='o',typ='R',val_min=1.0E0,val_max=1.7321E0),
             ),
           ),
#
# autres comportements ...
#
           WEIBULL         =FACT(statut='f',
             M               =SIMP(statut='o',typ='R'),
             VOLU_REFE       =SIMP(statut='o',typ='R'),
             SIGM_REFE       =SIMP(statut='o',typ='R'),
             SEUIL_EPSP_CUMU =SIMP(statut='f',typ='R',defaut= 1.0E-6),
           ),
           WEIBULL_FO      =FACT(statut='f',
             M               =SIMP(statut='o',typ='R'),
             VOLU_REFE       =SIMP(statut='o',typ='R'),
             SIGM_CNV        =SIMP(statut='o',typ='R'),
             SIGM_REFE       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SEUIL_EPSP_CUMU =SIMP(statut='f',typ='R',defaut= 1.0E-6),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           NON_LOCAL       =FACT(statut='f',
             regles=(AU_MOINS_UN('LONG_CARA','C_GONF','PENA_LAGR',),),
             LONG_CARA       =SIMP(statut='f',typ='R'),
             PENA_LAGR       =SIMP(statut='f',typ='R',defaut= 1.0E3),
             C_GONF          =SIMP(statut='f',typ='R'),
             COEF_RIGI_MINI  =SIMP(statut='f',typ='R'),
           ),
           RUPT_FRAG       =FACT(statut='f',
             GC              =SIMP(statut='o',typ='R'),
             SIGM_C          =SIMP(statut='f',typ='R'),
             PENA_ADHERENCE  =SIMP(statut='f',typ='R',val_min=1.E-12,val_max=1.E+0),
             PENA_CONTACT    =SIMP(statut='f',typ='R',defaut=1.),
             PENA_LAGR       =SIMP(statut='f',typ='R',defaut=1.0E2,val_min=1.01E+0),
             RIGI_GLIS       =SIMP(statut='f',typ='R',defaut=1.0E1),
           ),
           RUPT_FRAG_FO   =FACT(statut='f',
             GC              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_C          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PENA_ADHERENCE  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PENA_CONTACT    =SIMP(statut='f',typ='R',defaut=1.),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           RCCM            =FACT(statut='f',
             regles=(ENSEMBLE('A_AMORC','B_AMORC','D_AMORC','R_AMORC'),),
             SY_02           =SIMP(statut='f',typ='R'),
             SM              =SIMP(statut='f',typ='R'),
             SU              =SIMP(statut='f',typ='R'),
             SC              =SIMP(statut='f',typ='R'),
             SH              =SIMP(statut='f',typ='R'),
             N_KE            =SIMP(statut='f',typ='R'),
             M_KE            =SIMP(statut='f',typ='R'),
             A_AMORC         =SIMP(statut='f',typ='R'),
             B_AMORC         =SIMP(statut='f',typ='R'),
             D_AMORC         =SIMP(statut='f',typ='R'),
             R_AMORC         =SIMP(statut='f',typ='R'),
           ),
           RCCM_FO         =FACT(statut='f',
             regles=(ENSEMBLE('A_AMORC','B_AMORC','D_AMORC','R_AMORC'),),
             SY_02           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SM              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SU              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             S               =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             N_KE            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_KE            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_AMORC         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B_AMORC         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_AMORC         =SIMP(statut='f',typ='R'),
             R_AMORC         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             VERI_P          =SIMP(statut='c',typ='TXM',max='**',defaut=("TEMP",) ),
           ),
           LAIGLE          =FACT(statut='f',
             GAMMA_ULT       =SIMP(statut='o',typ='R'),
             GAMMA_E         =SIMP(statut='o',typ='R'),
             M_ULT           =SIMP(statut='o',typ='R'),
             M_E             =SIMP(statut='o',typ='R'),
             A_E             =SIMP(statut='o',typ='R'),
             M_PIC           =SIMP(statut='o',typ='R'),
             A_PIC           =SIMP(statut='o',typ='R'),
             ETA             =SIMP(statut='o',typ='R'),
             SIGMA_C         =SIMP(statut='o',typ='R'),
             GAMMA           =SIMP(statut='o',typ='R'),
             KSI             =SIMP(statut='o',typ='R'),
             GAMMA_CJS       =SIMP(statut='o',typ='R'),
             SIGMA_P1        =SIMP(statut='o',typ='R'),
             PA              =SIMP(statut='o',typ='R'),
           ),
           LETK          =FACT(statut='f',
             PA         =SIMP(statut='o',typ='R',fr="pression atmospherique"),
             NELAS      =SIMP(statut='o',typ='R',fr="exposant de la loi de variation des modules K et G"),
             SIGMA_C    =SIMP(statut='o',typ='R',fr="rsistance en compression simple "),
             H0_EXT     =SIMP(statut='o',typ='R',fr="parametre pilotant la rsistance en extension"),
             GAMMA_CJS  =SIMP(statut='o',typ='R',fr="parametre de forme du critere ds le plan deviatoire entre 0 et 1."),
             XAMS       =SIMP(statut='o',typ='R',fr="parametre non nul intervenant dans les lois d'ecrouissage pre pic"),
             ETA        =SIMP(statut='o',typ='R',fr="parametre non nul intervenant dans les lois d'ecrouissage post pic"),
             A_0        =SIMP(statut='o',typ='R',fr="a de la limite d'lasticit initiale"),
             A_E        =SIMP(statut='o',typ='R',fr="a de la limite de clivage ou seuil intermdiaire"),
             A_PIC      =SIMP(statut='o',typ='R',fr="a du seuil de pic"),
             S_0        =SIMP(statut='o',typ='R',fr="s de la limite d'lasticit initiale"),
             M_0        =SIMP(statut='o',typ='R',fr="m de la limite d'lasticit initiale"),
             M_E        =SIMP(statut='o',typ='R',fr="m de la limite de clivage ou seuil intermdiaire"),
             M_PIC      =SIMP(statut='o',typ='R',fr="m du seuil de pic"),
             M_ULT      =SIMP(statut='o',typ='R',fr="m du seuil residuel"),
             XI_ULT     =SIMP(statut='o',typ='R',fr="niveau d ecrouissage pour atteindre le seuil residuel"),
             XI_E       =SIMP(statut='o',typ='R',fr="niveau d ecrouissage pour atteindre le seuil de clivage"),
             XI_PIC     =SIMP(statut='o',typ='R',fr="niveau d ecrouissage pour atteindre le seuil de pic"),
             MV_MAX     =SIMP(statut='o',typ='R',fr="m du seuil viscoplastique maximal"),
             XIV_MAX    =SIMP(statut='o',typ='R',fr="niveau d ecrouissage pour atteindre le seuil viscoplastique maximal"),
             A          =SIMP(statut='o',typ='R',fr="parametre carcaterisant l amplitude de la vitesse de fluage"),
             N          =SIMP(statut='o',typ='R',fr="parametre intervenant dans la formule pilotant la cinetique de fluage"),
             SIGMA_P1   =SIMP(statut='o',typ='R',fr="SIG min de l intersection du seuil de pic et intermediaire "),
             MU0_V      =SIMP(statut='o',typ='R',fr="relatif  l angle de dilatance des mecanismes pre pic et viscoplastique"),
             XI0_V      =SIMP(statut='o',typ='R',fr="relatif  l angle de dilatance des mecanismes pre pic et viscoplastique"),
             MU1        =SIMP(statut='o',typ='R',fr="relatif  l angle de dilatance du mecanisme post pic "),
             XI1        =SIMP(statut='o',typ='R',fr="relatif  l angle de dilatance du mecanisme post pic "),
           ),
           DRUCK_PRAGER  =FACT(statut='f',
             ALPHA           =SIMP(statut='o',typ='R'),
             SY              =SIMP(statut='o',typ='R'),
             P_ULTM          =SIMP(statut='o',typ='R'),
             ECROUISSAGE = SIMP(statut='o',typ='TXM',into=("LINEAIRE","PARABOLIQUE")),
             b_lineaire =BLOC(condition="ECROUISSAGE=='LINEAIRE'",
                                    fr="Loi de comportement de type Drucker Prager avec un ecrouissage lineaire",
                    H               =SIMP(statut='o',typ='R'),
                    TYPE_DP         =SIMP(statut='c',typ='R',defaut= 1.0,),
             ),
             b_parabolique =BLOC(condition="ECROUISSAGE=='PARABOLIQUE'",
                                    fr="Loi de comportement de type Drucker Prager avec un ecrouissage parabolique",
                    SY_ULTM         =SIMP(statut='o',typ='R'),
                    TYPE_DP         =SIMP(statut='c',typ='R',defaut= 2.0,),
             ),
             DILAT           =SIMP(statut='f',typ='R',defaut=0.0),
           ),
             HOEK_BROWN          =FACT(statut='f',
             GAMMA_RUP       =SIMP(statut='o',typ='R'),
             GAMMA_RES       =SIMP(statut='o',typ='R'),
             S_END           =SIMP(statut='o',typ='R'),
             S_RUP           =SIMP(statut='o',typ='R'),
             M_END           =SIMP(statut='o',typ='R'),
             M_RUP           =SIMP(statut='o',typ='R'),
             BETA            =SIMP(statut='o',typ='R'),
             ALPHAHB         =SIMP(statut='o',typ='R'),
             PHI_RUP         =SIMP(statut='o',typ='R'),
             PHI_RES         =SIMP(statut='o',typ='R'),
             PHI_END         =SIMP(statut='f',typ='R'),
           ),
             ELAS_GONF             =FACT(statut='f',
             BETAM           =SIMP(statut='o',typ='R'),
             PREF            =SIMP(statut='o',typ='R'),
           ),
####  MONOCRISTAL

           ECOU_VISC1      =FACT(statut='f',
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             N               =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='o',typ='R'),
             C               =SIMP(statut='o',typ='R'),
           ),
           ECOU_VISC2      =FACT(statut='f',
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             N               =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='o',typ='R'),
             C               =SIMP(statut='o',typ='R'),
             D               =SIMP(statut='o',typ='R'),
             A               =SIMP(statut='o',typ='R'),
           ),
           ECOU_VISC3      =FACT(statut='f',
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             K               =SIMP(statut='o',typ='R',fr="Constante de Boltzmann, en eV/K"),
             TAUMU           =SIMP(statut='o',typ='R',fr="Seuil d ecoulement, en unite de contraintes"),
             GAMMA0          =SIMP(statut='o',typ='R',fr="Vitesse d ecoulement initiale"),
             DELTAV          =SIMP(statut='o',typ='R',fr="Volume d activation"),
             DELTAG0         =SIMP(statut='o',typ='R',fr="Gain d energie lie au franchissement d obstacle"),
           ),
           KOCKS_RAUCH      =FACT(statut='f',
              regles=(UN_PARMI('H','H1'),
                      PRESENT_PRESENT('H1','H2','H3','H4'),
                      PRESENT_ABSENT('H','H1','H2','H3','H4','H5','H6'),
                      ),
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             K               =SIMP(statut='o',typ='R',fr="Constante de Boltzmann, en eV/K"),
             TAUR            =SIMP(statut='o',typ='R',fr="Contraintes de cisaillement  T=0K, en unite de contraintes"),
             TAU0            =SIMP(statut='o',typ='R',fr="Contraintes critique initiale de cisaillement, en unite de contraintes"),
             GAMMA0          =SIMP(statut='o',typ='R',fr="Vitesse d ecoulement initiale"),
             DELTAG0         =SIMP(statut='o',typ='R',fr="Gain d energie lie au franchissement d obstacle"),
             BSD             =SIMP(statut='o',typ='R',fr="fonction de la taille du grain B/D"),
             GCB             =SIMP(statut='o',typ='R',fr="distance critique d'annihilation GC/B"),
             KDCS            =SIMP(statut='o',typ='R',fr="Parametre relatif  la direction principale de la dislocation"),
             P               =SIMP(statut='o',typ='R',fr="Parametre materiau dpendant de la forme de l'obstacle"),
             Q               =SIMP(statut='o',typ='R',fr="Parametre materiau dpendant de la forme de l'obstacle"),
             H               =SIMP(statut='f',typ='R'),
             H1              =SIMP(statut='f',typ='R'),
             H2              =SIMP(statut='f',typ='R'),
             H3              =SIMP(statut='f',typ='R'),
             H4              =SIMP(statut='f',typ='R'),
             H5              =SIMP(statut='f',typ='R'),
             H6              =SIMP(statut='f',typ='R'),
           ),
           ECRO_ISOT1      =FACT(statut='f',
              regles=(UN_PARMI('H','H1'),
                      PRESENT_PRESENT('H1','H2','H3','H4'),
                      PRESENT_ABSENT('H','H1','H2','H3','H4','H5','H6'),
                      ),
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECRO_ISOT",),),
             R_0             =SIMP(statut='o',typ='R'),
             Q               =SIMP(statut='o',typ='R'),
             B               =SIMP(statut='o',typ='R'),
             H               =SIMP(statut='f',typ='R'),
             H1              =SIMP(statut='f',typ='R'),
             H2              =SIMP(statut='f',typ='R'),
             H3              =SIMP(statut='f',typ='R'),
             H4              =SIMP(statut='f',typ='R'),
             H5              =SIMP(statut='f',typ='R'),
             H6              =SIMP(statut='f',typ='R'),
           ),
           ECRO_ISOT2      =FACT(statut='f',
              regles=(UN_PARMI('H','H1'),
                      PRESENT_PRESENT('H1','H2','H3','H4'),
                      PRESENT_ABSENT('H','H1','H2','H3','H4','H5','H6'),
                      ),
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECRO_ISOT",),),
             R_0             =SIMP(statut='o',typ='R'),
             Q1              =SIMP(statut='o',typ='R'),
             B1              =SIMP(statut='o',typ='R'),
             H               =SIMP(statut='f',typ='R'),
             H1              =SIMP(statut='f',typ='R'),
             H2              =SIMP(statut='f',typ='R'),
             H3              =SIMP(statut='f',typ='R'),
             H4              =SIMP(statut='f',typ='R'),
             H5              =SIMP(statut='f',typ='R'),
             H6              =SIMP(statut='f',typ='R'),
             Q2              =SIMP(statut='o',typ='R'),
             B2              =SIMP(statut='o',typ='R'),
           ),
           ECRO_CINE1      =FACT(statut='f',
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECRO_CINE",),),
             D               =SIMP(statut='o',typ='R'),
           ),
           ECRO_CINE2      =FACT(statut='f',
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECRO_CINE",),),
             D               =SIMP(statut='o',typ='R'),
             GM              =SIMP(statut='o',typ='R'),
             PM              =SIMP(statut='o',typ='R'),
             C               =SIMP(statut='o',typ='R'),
           ),

####  MONOCRISTAL

           DRUCK_PRAGER_FO  =FACT(statut='f',
             ALPHA           =SIMP(statut='o',typ=(fonction_sdaster,formule)),
             SY              =SIMP(statut='o',typ=(fonction_sdaster,formule)),
             P_ULTM          =SIMP(statut='o',typ=(fonction_sdaster,formule)),
             ECROUISSAGE = SIMP(statut='o',typ='TXM',into=("LINEAIRE","PARABOLIQUE")),
             b_lineaire =BLOC(condition="ECROUISSAGE=='LINEAIRE'",
                                    fr="Loi de comportement de type Drucker Prager avec un ecrouissage lineaire",
                    H               =SIMP(statut='o',typ=(fonction_sdaster,formule)),
                    TYPE_DP         =SIMP(statut='c',typ='R',defaut= 1.0,),
             ),
             b_parabolique =BLOC(condition="ECROUISSAGE=='PARABOLIQUE'",
                                    fr="Loi de comportement de type Drucker Prager avec un ecrouissage parabolique",
                    SY_ULTM         =SIMP(statut='o',typ=(fonction_sdaster,formule)),
                    TYPE_DP         =SIMP(statut='c',typ='R',defaut= 2.0,),
             ),
            DILAT           =SIMP(statut='f',typ='R',defaut=0.0),
           ),


           INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE BODEL C.BODEL
DEFI_MODELE_GENE=OPER(nom="DEFI_MODELE_GENE",op= 126,sd_prod=modele_gene,
                      reentrant='n',
            fr="Crer la structure globale  partir des sous-structures en sous-structuration dynamique", 
            UIinfo={"groupes":("Matrices/vecteurs",)},
         SOUS_STRUC      =FACT(statut='o',max='**',
           NOM             =SIMP(statut='o',typ='TXM' ),
           MACR_ELEM_DYNA  =SIMP(statut='o',typ=macr_elem_dyna ),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
           TRANS           =SIMP(statut='f',typ='R',max=3),
         ),
         LIAISON         =FACT(statut='o',max='**',
           SOUS_STRUC_1    =SIMP(statut='o',typ='TXM' ),
           INTERFACE_1     =SIMP(statut='o',typ='TXM' ),
           SOUS_STRUC_2    =SIMP(statut='o',typ='TXM' ),
           INTERFACE_2     =SIMP(statut='o',typ='TXM' ),
           regles=(EXCLUS('GROUP_MA_MAIT_1','GROUP_MA_MAIT_2','MAILLE_MAIT_2'),
                   EXCLUS('MAILLE_MAIT_1','GROUP_MA_MAIT_2','MAILLE_MAIT_2'),),
           GROUP_MA_MAIT_1   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_MAIT_1     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA_MAIT_2   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_MAIT_2     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           OPTION            =SIMP(statut='f',typ='TXM',defaut="CLASSIQUE",into=("REDUIT","CLASSIQUE") ),
         ),
         VERIF           =FACT(statut='f',max='**',
#  dans la doc U stop_erreur est obligatoire         
           STOP_ERREUR     =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-3 ),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS
DEFI_NAPPE=OPER(nom="DEFI_NAPPE",op=4,sd_prod=nappe_sdaster,
                fr="Dfinir une fonction relle de deux variables relles",
                reentrant='n',UIinfo={"groupes":("Fonction",)},
         regles=(UN_PARMI('FONCTION','DEFI_FONCTION'),
                 EXCLUS('FONCTION','NOM_PARA_FONC',),
                 ENSEMBLE('NOM_PARA_FONC','DEFI_FONCTION'),),
         NOM_PARA        =SIMP(statut='o',typ='TXM',into=C_PARA_FONCTION() ),
         NOM_RESU        =SIMP(statut='f',typ='TXM',defaut="TOUTRESU"),       
         PARA            =SIMP(statut='o',typ='R',max='**'),
         FONCTION        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),max='**' ),
         NOM_PARA_FONC   =SIMP(statut='f',typ='TXM',into=C_PARA_FONCTION() ),
         DEFI_FONCTION   =FACT(statut='f',max='**',
           VALE            =SIMP(statut='o',typ='R',max='**'),
           INTERPOL        =SIMP(statut='f',typ='TXM',max=2,defaut="LIN",into=("NON","LIN","LOG") ),
           PROL_DROITE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
           PROL_GAUCHE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
         ),
         INTERPOL        =SIMP(statut='f',typ='TXM',max=2,defaut="LIN",into=("NON","LIN","LOG") ),
         PROL_DROITE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
         PROL_GAUCHE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
         VERIF           =SIMP(statut='f',typ='TXM',into=("CROISSANT",) ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE KHAM M.KHAM
DEFI_OBSTACLE=OPER(nom="DEFI_OBSTACLE",op=  73,sd_prod=table_fonction,
                   fr="Dfinition d'un obstacle plan perpendiculaire  une structure filaire",
                   reentrant='n',
         UIinfo={"groupes":("Modlisation",)},
         TYPE            =SIMP(statut='o',typ='TXM',defaut="CERCLE",
                             into=("CERCLE","PLAN_Y","PLAN_Z","DISCRET",
                             "BI_CERCLE","BI_PLAN_Y","BI_PLAN_Z","BI_CERC_INT",
                             "CRAYON_900","CRAYON_1300","GUID_A_CARTE_900",
                             "GUID_B_CARTE_900","GUID_C_CARTE_900",
                             "GUID_D_CARTE_900","GUID_E_CARTE_900",
                             "GUID_F_CARTE_900","GUID_A_CARTE_1300",
                             "GUID_B_CARTE_1300","GUID_C_CARTE_1300",
                             "GUID_D_CARTE_1300","GUID_E_CARTE_1300",
                             "GUID_F_CARTE_1300","GUID_A_CARSP_900",
                             "GUID_B_CARSP_900","GUID_C_CARSP_900",
                             "GUID_D_CARSP_900","GUID_E_CARSP_900",
                             "GUID_F_CARSP_900","GUID_A_CARSP_1300",
                             "GUID_B_CARSP_1300","GUID_C_CARSP_1300",
                             "GUID_D_CARSP_1300","GUID_E_CARSP_1300",
                             "GUID_F_CARSP_1300","GUID_A_GCONT_900",
                             "GUID_B_GCONT_900","GUID_C_GCONT_900",
                             "GUID_D_GCONT_900","GUID_E_GCONT_900",
                             "GUID_F_GCONT_900","GUID_A_GCONT_1300",
                             "GUID_B_GCONT_1300","GUID_C_GCONT_1300",
                             "GUID_D_GCONT_1300","GUID_E_GCONT_1300",
                             "GUID_F_GCONT_1300","GUID_A_GCOMB_900",
                             "GUID_B_GCOMB_900","GUID_C_GCOMB_900",
                             "GUID_D_GCOMB_900","GUID_E_GCOMB_900",
                             "GUID_F_GCOMB_900","GUID_A_GCOMB_1300",
                             "GUID_B_GCOMB_1300","GUID_C_GCOMB_1300",
                             "GUID_D_GCOMB_1300","GUID_E_GCOMB_1300",
                             "GUID_F_GCOMB_1300",) ),
         VALE            =SIMP(statut='f',typ='R',max='**'),
         VERIF           =SIMP(statut='f',typ='TXM',defaut="FERME"),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE GNICOLAS G.NICOLAS
DEFI_PARA_SENSI=OPER(nom="DEFI_PARA_SENSI",op=   2,sd_prod=para_sensi,
                    fr="Dfinition d'un paramtre de sensibilit",
                    ang="Definition of a sensitive parameter",
                    reentrant='n',
            UIinfo={"groupes":("Fonction",)},
         NOM_RESU        =SIMP(statut='c',typ='TXM',into=("TOUTRESU",),defaut="TOUTRESU",
                               fr="Nom du concept cr",
                               ang="Name of the concept"),
         VALE            =SIMP(statut='o',typ='R',
                               fr="Valeur du parametre",
                               ang="Value of the parameter"),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 18/11/2009   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2004  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ASSIRE A.ASSIRE

from Macro.defi_part_feti_ops import defi_part_feti_ops

DEFI_PART_FETI=MACRO(nom="DEFI_PART_FETI",op=defi_part_feti_ops,sd_prod=sd_feti_sdaster,
                     reentrant='n',UIinfo={"groupe":("Maillage",)},
                     fr="Creation partitionnement en sous-domaines pour FETI",
         regles=(UN_PARMI('MAILLAGE','MODELE'),PRESENT_PRESENT('MODELE','EXCIT'),),

         NB_PART         =SIMP(statut='o',typ='I',val_min=2),
         MAILLAGE        =SIMP(statut='f',typ=maillage_sdaster),
         MODELE          =SIMP(statut='f',typ=modele_sdaster),
         EXCIT           =FACT(statut='f',max='**',
           CHARGE          =SIMP(statut='f',typ=(char_meca,char_cine_meca)),),

         # Methode de partitionnement
         METHODE         =SIMP(statut='f',typ='TXM',into=("PMETIS","SCOTCH","KMETIS",), defaut="SCOTCH" ),
         
         LOGICIEL      =SIMP(statut='f',typ='TXM'),

         # Corrige les problemes possibles de non-connexite des sous-domaines
         CORRECTION_CONNEX    =SIMP(statut='f',typ='TXM',defaut='NON',into=('OUI','NON')),

         # Permet de grouper des mailles dans un meme sous-doamine
         GROUPAGE        =FACT(statut='f',max='**',
           GROUP_MA       =SIMP(statut='o',typ=grma,),
                          ),
         # Permet d'appliquer des poids sur certaines mailles
         POIDS_MAILLES   =FACT(statut='f',max='**',
           GROUP_MA       =SIMP(statut='o',typ=grma,),
           POIDS          =SIMP(statut='f',typ='I',val_min=2),
                          ),
         # Prefixe pour le nom des group_ma definissant les sous-domaines 
         NOM_GROUP_MA    =SIMP(statut='f',typ='TXM',defaut='SD' ),

         # Traiter les mailles de bords (elles sont enlevees du graphe puis reinjectees)
         TRAITER_BORDS   =SIMP(statut='f',typ='TXM',defaut='OUI',into=('OUI','NON') ),
         
         # Si le mot-cl suivant est renseign, cre de nouveau group_ma a partir des bords
         # Note : le calcul FETI sera impossible
         b_traiter_bords =BLOC(condition="TRAITER_BORDS == 'OUI'", fr="Cre t on des nouveaux group_ma",
           NOM_GROUP_MA_BORD  =SIMP(statut='f',typ='TXM'),
             ),

         INFO            =SIMP(statut='f',typ='I',into=(1, 2), defaut=1),
);
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2004  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ASSIRE A.ASSIRE

DEFI_PART_OPS=OPER(nom="DEFI_PART_OPS",op=21,sd_prod=sd_feti_sdaster,
                    fr="Creation partitionnement en sous-domaines pour FETI",
                    docu="U4.23.05",reentrant='n',
                    UIinfo={"groupes":("Rsolution",)},
         MODELE          =SIMP(statut='o',typ=(modele_sdaster) ),
         MAILLAGE        =SIMP(statut='f',typ=(maillage_sdaster) ),
         NOM             =SIMP(statut='f',typ='TXM',defaut='SD'),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2,3,4) ),
         DEFI          =FACT(statut='f',max='**',
           GROUP_MA        =SIMP(statut='o',typ=grma),
           GROUP_MA_BORD   =SIMP(statut='f',typ=grma),
         ),
         EXCIT           =FACT(statut='f',max='**',
           CHARGE          =SIMP(statut='f',typ=(char_meca,char_cine_meca)),
         ),
);
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2005  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ASSIRE A.ASSIRE

DEFI_PART_PA_OPS=PROC(nom="DEFI_PART_PA_OPS",op=29,
                    fr="Creation partitionnement en sous-domaines pour FETI",
                    docu="U4.00.00",
                    UIinfo={"groupes":("Rsolution",)},
         MAILLAGE        =SIMP(statut='o',typ=(maillage_sdaster,squelette) ),
         MODELE          =SIMP(statut='f',typ=(modele_sdaster)),
         NB_PART         =SIMP(statut='o',typ='I',),

         # Methode de partitionnement
         METHODE         =SIMP(statut='f',typ='TXM',into=("PMETIS","SCOTCH","KMETIS",), defaut="SCOTCH" ),
         
         LOGICIEL      =SIMP(statut='f',typ='TXM'),

         # Corrige les problemes possibles de non-connexite des sous-domaines
         CORRECTION_CONNEX    =SIMP(statut='f',typ='TXM',defaut='NON',into=('OUI','NON')),

         # Permet de grouper des mailles dans un meme sous-doamine
         GROUPAGE        =FACT(statut='f',max='**',
           GROUP_MA       =SIMP(statut='o',typ=grma,),
                          ),
         # Permet d'appliquer des poids sur certaines mailles
         POIDS_MAILLES   =FACT(statut='f',max='**',
           GROUP_MA       =SIMP(statut='o',typ=grma,),
           POIDS          =SIMP(statut='f',typ='I'),
                          ),
         # Prefixe pour le nom des group_ma definissant les sous-domaines 
         NOM_GROUP_MA    =SIMP(statut='f',typ='TXM',defaut='SD' ),

         # Traiter les mailles de bords (elles sont enlevees du graphe puis reinjectees)
         TRAITER_BORDS   =SIMP(statut='f',typ='TXM',defaut='OUI',into=('OUI','NON') ),

         # Si le mot-cl suivant est renseign, cre de nouveau group_ma a partir des bords
         # Note : le calcul FETI sera impossible
         b_traiter_bords =BLOC(condition="TRAITER_BORDS == 'OUI'", fr="Cre t on des nouveaux group_ma",
           NOM_GROUP_MA_BORD  =SIMP(statut='f',typ='TXM'),
             ),

         INFO            =SIMP(statut='f',typ='I',into=(1, 2), defaut=1),

);
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE ADOBES A.ADOBES
DEFI_SPEC_TURB=OPER(nom="DEFI_SPEC_TURB",op= 145,sd_prod=spectre_sdaster,
                    fr="Dfinition d'un spectre d'excitation turbulente",
                    reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
         regles=(UN_PARMI('SPEC_LONG_COR_1','SPEC_LONG_COR_2','SPEC_LONG_COR_3',
                          'SPEC_LONG_COR_4','SPEC_CORR_CONV_1','SPEC_CORR_CONV_2',
                          'SPEC_FONC_FORME','SPEC_EXCI_POINT'),),
         SPEC_LONG_COR_1 =FACT(statut='f',
           LONG_COR        =SIMP(statut='o',typ='R' ),
           PROF_VITE_FLUI  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VISC_CINE       =SIMP(statut='o',typ='R' ),
         ),
         SPEC_LONG_COR_2 =FACT(statut='f',
           regles=(ENSEMBLE('FREQ_COUP','PHI0','BETA' ),),
           LONG_COR        =SIMP(statut='o',typ='R' ),
           PROF_VITE_FLUI  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FREQ_COUP       =SIMP(statut='f',typ='R',defaut= 0.1 ),
           PHI0            =SIMP(statut='f',typ='R',defaut= 1.5E-3 ),
           BETA            =SIMP(statut='f',typ='R',defaut= 2.7 ),
         ),
         SPEC_LONG_COR_3 =FACT(statut='f',
           regles=(ENSEMBLE('PHI0_1','BETA_1','PHI0_2','BETA_2','FREQ_COUP'),),
           LONG_COR        =SIMP(statut='o',typ='R' ),
           PROF_VITE_FLUI  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FREQ_COUP       =SIMP(statut='f',typ='R',defaut= 0.2 ),
           PHI0_1          =SIMP(statut='f',typ='R',defaut= 5.E-3 ),
           BETA_1          =SIMP(statut='f',typ='R',defaut= 0.5 ),
           PHI0_2          =SIMP(statut='f',typ='R',defaut= 4.E-5 ),
           BETA_2          =SIMP(statut='f',typ='R',defaut= 3.5 ),
         ),
         SPEC_LONG_COR_4 =FACT(statut='f',
           regles=(ENSEMBLE('BETA','GAMMA'),),
           LONG_COR        =SIMP(statut='o',typ='R' ),
           PROF_VITE_FLUI  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TAUX_VIDE       =SIMP(statut='o',typ='R' ),
           BETA            =SIMP(statut='f',typ='R',defaut= 2. ),
           GAMMA           =SIMP(statut='f',typ='R',defaut= 4. ),
         ),
         SPEC_CORR_CONV_1=FACT(statut='f',
           LONG_COR_1      =SIMP(statut='o',typ='R' ),
           LONG_COR_2      =SIMP(statut='f',typ='R' ),
           VITE_FLUI       =SIMP(statut='o',typ='R' ),
           RHO_FLUI        =SIMP(statut='o',typ='R' ),
           FREQ_COUP       =SIMP(statut='f',typ='R' ),
           K               =SIMP(statut='f',typ='R',defaut= 5.8E-3 ),
           D_FLUI          =SIMP(statut='o',typ='R' ),
           COEF_VITE_FLUI_A=SIMP(statut='f',typ='R' ),
           COEF_VITE_FLUI_O=SIMP(statut='f',typ='R' ),
           METHODE         =SIMP(statut='f',typ='TXM',defaut="GENERALE",
                                 into=("AU_YANG","GENERALE","CORCOS") ),
         ),
         SPEC_CORR_CONV_2=FACT(statut='f',
           FONCTION        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VITE_FLUI       =SIMP(statut='o',typ='R' ),
           FREQ_COUP       =SIMP(statut='f',typ='R' ),
           METHODE         =SIMP(statut='f',typ='TXM',defaut="GENERALE",
                                 into=("AU_YANG","GENERALE","CORCOS",) ),
           COEF_VITE_FLUI_A=SIMP(statut='f',typ='R' ),
           COEF_VITE_FLUI_O=SIMP(statut='f',typ='R' ),
         ),
         SPEC_FONC_FORME =FACT(statut='f',
           regles=(UN_PARMI('INTE_SPEC','GRAPPE_1'),
                   ENSEMBLE('INTE_SPEC','FONCTION'),),
           INTE_SPEC       =SIMP(statut='f',typ=table_fonction),
           FONCTION        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),max='**'),
           GRAPPE_1        =SIMP(statut='f',typ='TXM',into=("DEBIT_180","DEBIT_300",) ),
           NOEUD           =SIMP(statut='o',typ=no),
           CARA_ELEM       =SIMP(statut='o',typ=cara_elem ),
           MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         ),
         SPEC_EXCI_POINT =FACT(statut='f',
           regles=(UN_PARMI('INTE_SPEC','GRAPPE_2'),),
           INTE_SPEC       =SIMP(statut='f',typ=table_fonction),
           GRAPPE_2        =SIMP(statut='f',typ='TXM',
                                 into=("ASC_CEN","ASC_EXC","DES_CEN","DES_EXC",) ),
#  Quels sont les statuts des mots cles  l interieur des deux blocs qui suivent
           b_inte_spec =BLOC(condition = "INTE_SPEC != None",
             NATURE          =SIMP(statut='o',typ='TXM',max='**',into=("FORCE","MOMENT",) ),
             ANGL            =SIMP(statut='o',typ='R',max='**'),
             NOEUD           =SIMP(statut='o',typ=no,max='**'),
           ),
           b_grappe_2      =BLOC(condition = "GRAPPE_2 != None",
             RHO_FLUI        =SIMP(statut='o',typ='R' ),
             NOEUD           =SIMP(statut='o',typ=no),
           ),
           CARA_ELEM       =SIMP(statut='o',typ=cara_elem ),
           MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE BODEL C.BODEL
DEFI_SQUELETTE=OPER(nom="DEFI_SQUELETTE",op= 110,sd_prod=squelette,
                    fr="Dfinit un maillage pour visualiser les rsultats d'une sous-structuration dynamique",
                    reentrant='n',
            UIinfo={"groupes":("Maillage",)},
         regles=(UN_PARMI('CYCLIQUE','MODELE_GENE','MAILLAGE'),
                 PRESENT_PRESENT('CYCLIQUE','SECTEUR'),
                 EXCLUS('SOUS_STRUC','SECTEUR'),
                 PRESENT_PRESENT('NOM_GROUP_MA','MODELE_GENE'),
                 PRESENT_PRESENT('NOM_GROUP_MA','SOUS_STRUC'),),
         CYCLIQUE    =FACT(statut='f',max='**',
           regles=(UN_PARMI('MODE_CYCL','MAILLAGE'),
                   PRESENT_PRESENT('NB_SECTEUR','MAILLAGE'),),
           MODE_CYCL       =SIMP(statut='f',typ=mode_cycl ),
           NB_SECTEUR      =SIMP(statut='f',typ='I',validators=NoRepeat(),max=1 ),
           MAILLAGE        =SIMP(statut='f',typ=maillage_sdaster ),
         ),
         MODELE_GENE     =SIMP(statut='f',typ=modele_gene ),
         SQUELETTE       =SIMP(statut='f',typ=squelette ),
         RECO_GLOBAL     =FACT(statut='f',max='**',
           regles=(EXCLUS('TOUT','GROUP_NO_1'),
                   PRESENT_PRESENT('GROUP_NO_1','GROUP_NO_2'),
                   PRESENT_PRESENT('GROUP_NO_1','SOUS_STRUC_1'),
                   PRESENT_PRESENT('GROUP_NO_2','SOUS_STRUC_2'),
                   PRESENT_PRESENT('SOUS_STRUC_1','SOUS_STRUC_2'),),
           TOUT            =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI",) ),
           GROUP_NO_1      =SIMP(statut='f',typ=grno),
           SOUS_STRUC_1    =SIMP(statut='f',typ='TXM' ),
           GROUP_NO_2      =SIMP(statut='f',typ=grno),
           SOUS_STRUC_2    =SIMP(statut='f',typ='TXM' ),
           PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-3 ),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
           DIST_REFE       =SIMP(statut='f',typ='R' ),
         ),
         NOM_GROUP_MA    =FACT(statut='f',max='**',
           NOM             =SIMP(statut='o',typ='TXM' ),
           SOUS_STRUC      =SIMP(statut='o',typ='TXM' ),
           GROUP_MA        =SIMP(statut='o',typ=grma),
         ),
         EXCLUSIF        =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         MAILLAGE        =SIMP(statut='f',typ=maillage_sdaster ),
         MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
         GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
         TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
         TRANS           =SIMP(statut='f',typ='R',min=3,max=3),
         ANGL_NAUT       =SIMP(statut='f',typ='R',min=3,max=3),
         SOUS_STRUC      =FACT(statut='f',max='**',
           NOM             =SIMP(statut='f',typ='TXM' ),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
         ),
         SECTEUR         =FACT(statut='f',max='**',
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE CANO V.CANO
DEFI_TRC=OPER(nom="DEFI_TRC",op=94,sd_prod=table_sdaster,reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
              fr="Dfinir d'un diagramme de transformations en refroidissement continu (TRC) de rfrence d'un acier"
                +" pour les calculs mtallurgiques.",
         HIST_EXP        =FACT(statut='o',max='**',
           VALE            =SIMP(statut='o',typ='R',max='**'),
         ),
         TEMP_MS         =FACT(statut='o',max='**',
           SEUIL           =SIMP(statut='o',typ='R'),
           AKM             =SIMP(statut='o',typ='R'),
           BKM             =SIMP(statut='o',typ='R'),
           TPLM            =SIMP(statut='o',typ='R'),
         ),
         GRAIN_AUST      =FACT(statut='f',max='**',
           DREF           =SIMP(statut='f',typ='R'),
           A              =SIMP(statut='f',typ='R'),
         ),
)  ;
#& MODIF COMMANDE  DATE 21/10/2008   AUTEUR NISTOR I.NISTOR 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE PELLET J.PELLET
def depl_interne_prod(DEPL_GLOBAL,**args ):
    if AsType(DEPL_GLOBAL)     == cham_no_sdaster: return cham_no_sdaster
    if AsType(DEPL_GLOBAL)     == evol_elas      : return evol_elas
    if AsType(DEPL_GLOBAL)     == dyna_trans     : return dyna_trans
    if AsType(DEPL_GLOBAL)     == dyna_harmo     : return dyna_harmo
    if AsType(DEPL_GLOBAL)     == mode_meca      : return mode_meca
    if AsType(DEPL_GLOBAL)     == mode_meca_c    : return mode_meca_c
    if AsType(DEPL_GLOBAL)     == base_modale    : return base_modale
    raise AsException("type de concept resultat non prevu")

DEPL_INTERNE=OPER(nom="DEPL_INTERNE",op=89,sd_prod=depl_interne_prod,reentrant='n',
            UIinfo={"groupes":("Matrices/vecteurs",)},
                  fr="Calculer le champ de dplacement  l'intrieur d'une sous-structure statique",
         DEPL_GLOBAL     =SIMP(statut='o',typ=(cham_no_sdaster,mode_meca,mode_meca_c,base_modale,evol_elas,dyna_trans,dyna_harmo),),
         SUPER_MAILLE    =SIMP(statut='o',typ=ma,),
         NOM_CAS         =SIMP(statut='f',typ='TXM',defaut=" "),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE
DETRUIRE=MACRO(nom="DETRUIRE",op=-7,
            UIinfo={"groupes":("Gestion du travail",)},
              fr="Dtruit des concepts utilisateurs dans la base GLOBALE ou des objets JEVEUX",
             op_init=ops.detruire,
             regles=(UN_PARMI('CONCEPT','OBJET',),),
            CONCEPT     =FACT(statut='f',max='**',
                regles=(DERIVABLE('NOM'),),
                NOM         =SIMP(statut='o',typ=assd,validators=NoRepeat(),max='**'),
                SENSIBILITE =SIMP(statut='f',typ=(para_sensi,theta_geom),validators=NoRepeat(),
                                 fr="Paramtre de sensibilit.",
                                 ang="Sensitivity parameter",max='**'),
            ),
            OBJET  =FACT(statut='f',max='**',
               CLASSE      =SIMP(statut='f',typ='TXM',into=('G','V','L'),defaut='G'),  
               CHAINE      =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**'),
               POSITION    =SIMP(statut='f',typ='I'  ,max='**'),
            ),
            ALARME        =SIMP(statut='f',typ='TXM',into=('OUI','NON'),defaut='OUI',),
            INFO          =SIMP(statut='f',typ='I',into=(1,2),defaut=2, ),           
);
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE ZENTNER I.ZENTNER
DYNA_ALEA_MODAL=OPER(nom="DYNA_ALEA_MODAL",op= 131,sd_prod=table_fonction,
                     fr="Calcul de la rponse spectrale d'une structure linaire sous une excitation connue par sa DSP",
                     reentrant='n',
            UIinfo={"groupes":("Rsolution",)},
         BASE_MODALE     =FACT(statut='o',
           regles=(UN_PARMI('NUME_ORDRE','BANDE'),),
           MODE_MECA       =SIMP(statut='o',typ=mode_meca ),
           BANDE           =SIMP(statut='f',typ='R',validators=NoRepeat(),max=2),
           NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
           b_bande =BLOC(condition = "BANDE != None",
             AMOR_UNIF       =SIMP(statut='o',typ='R' ),
           ),
           b_nume_ordre =BLOC(condition = "NUME_ORDRE != None",
             AMOR_REDUIT     =SIMP(statut='o',typ='R',max='**'),
           ),
         ),
         MODE_STAT       =SIMP(statut='f',typ=(mode_stat_depl,mode_stat_acce,mode_stat_forc,)),
# MODE_STAT devrait etre dans EXCIT car est utile et obligatoire que si NOM_CMP=depl_r, on pourrait
# ainsi rajouter un bloc du genre  b_mod_stat= BLOC(condition = "(GRANDEUR == None) or (GRANDEUR == 'DEPL_R')",        
         EXCIT           =FACT(statut='o',
           INTE_SPEC       =SIMP(statut='o',typ=table_fonction),
           NUME_VITE_FLUI  =SIMP(statut='f',typ='I' ),
           OPTION          =SIMP(statut='f',typ='TXM',defaut="TOUT",into=("TOUT","DIAG",) ),
           MODAL           =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
           b_modal_non = BLOC(condition = "(MODAL == None) or (MODAL == 'NON')",           
             regles=(UN_PARMI('NOEUD_I','NUME_ORDRE_I'),),
             NUME_ORDRE_I    =SIMP(statut='f',typ='I',max='**'),
             NOEUD_I         =SIMP(statut='f',typ=no,max='**'),
             b_nume_ordre_i  =BLOC(condition = "NUME_ORDRE_I != None",
               regles=(EXCLUS('CHAM_NO','NOEUD'),),
# on devrait rajouter EXCLUS('GRANDEUR','CHAM_NO') pour eviter ambiguite car CHAM_NO => GRANDEUR='EFFO'
# cela impliquerait d'enlever la valeur par defaut a GRANDEUR            
               NUME_ORDRE_J    =SIMP(statut='o',typ='I',max='**'),
               CHAM_NO         =SIMP(statut='f',typ=cham_no_sdaster),
               NOEUD           =SIMP(statut='f',typ=no,max='**'),
               b_noeud         =BLOC(condition = "NOEUD != None",
                  NOM_CMP         =SIMP(statut='o',typ='TXM',max='**'),
                ),  
               GRANDEUR        =SIMP(statut='f',typ='TXM',defaut="DEPL_R",
                           into=("DEPL_R","EFFO","SOUR_DEBI_VOLU","SOUR_DEBI_MASS","SOUR_PRESS","SOUR_FORCE")),
# que se passe-t-il en cas d'incompatibilite entre GRANDEUR et NOM_CMP  
               DERIVATION      =SIMP(statut='f',typ='I',defaut= 0,into=( 0 , 1 , 2 ) ),
             ),           
             b_noeud_i       =BLOC(condition = "NOEUD_I != None",
               NOEUD_J         =SIMP(statut='o',typ=no,max='**'),
               NOM_CMP_I       =SIMP(statut='o',typ='TXM',max='**'),
               NOM_CMP_J       =SIMP(statut='o',typ='TXM',max='**'),
               NOEUD           =SIMP(statut='o',typ=no,max='**'),
               NOM_CMP         =SIMP(statut='o',typ='TXM',max='**'),
# ne serait-il pas bien que NOEUD et NOM_CMP soient facultatifs, car l'information peut etre contenue dans
# NOEUD_I, NOM_CMP_I ...  => modif. du Fortran
               GRANDEUR        =SIMP(statut='f',typ='TXM',defaut="DEPL_R",
                           into=("DEPL_R","EFFO","SOUR_DEBI_VOLU","SOUR_DEBI_MASS","SOUR_PRESS","SOUR_FORCE")),
# que se passe-t-il en cas d'incompatibilite entre GRANDEUR et NOM_CMP_I  
               DERIVATION      =SIMP(statut='f',typ='I',defaut= 0,into=( 0 , 1 , 2 ) ),
             ),
           ),  
           b_modal_oui = BLOC(condition = "(MODAL == 'OUI')",
# dans ce cas, y-a-t-il vraiment la possibilite d'une matrice interspectrale avec plusieurs termes
             NUME_ORDRE_I    =SIMP(statut='o',typ='I',max='**'),
             NUME_ORDRE_J    =SIMP(statut='o',typ='I',max='**'),
             GRANDEUR        =SIMP(statut='f',typ='TXM',defaut="DEPL_R",
                           into=("DEPL_R","EFFO","SOUR_DEBI_VOLU","SOUR_DEBI_MASS","SOUR_PRESS","SOUR_FORCE")),
             DERIVATION      =SIMP(statut='f',typ='I',defaut= 0,into=( 0 , 1 , 2 ) ),
# dans le cas MODAL=OUI, GRANDEUR peut-il etre different de EFFO et doit il etre impose a EFFO   On devrait
# pouvoir supprimer GRANDEUR et DERIVATION ici   
           ),  
                    
         ),
         REPONSE         =FACT(statut='f',
           regles=( ENSEMBLE('FREQ_MIN','FREQ_MAX'),),
           DERIVATION      =SIMP(statut='f',typ='I',defaut= 0,into=( 0 , 1 , 2 ,) ),
           OPTION          =SIMP(statut='f',typ='TXM',defaut="TOUT",into=("TOUT","DIAG") ),
           FREQ_MIN        =SIMP(statut='f',typ='R' ),
           FREQ_MAX        =SIMP(statut='f',typ='R' ),
           PAS             =SIMP(statut='f',typ='R' ),
           b_defaut_freq   =BLOC(condition = "FREQ_MIN == NONE",
              FREQ_EXCIT      =SIMP(statut='f',typ='TXM',defaut="AVEC",into=("AVEC","SANS") ),
              NB_POIN_MODE    =SIMP(statut='f',typ='I',defaut= 50 ),
           ),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2008  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ZENTNER I.ZENTNER
from Macro.dyna_iss_vari_ops import dyna_iss_vari_ops
#
DYNA_ISS_VARI=MACRO(nom="DYNA_ISS_VARI",op=dyna_iss_vari_ops ,sd_prod=table_fonction,
                    fr="Calcul du spectre de rponse ou de la reponse temporelle sismique incoherente par decomposition spectrale",
                    reentrant='n',
                    UIinfo={"groupes":("Outils mtier",)},        
         NOM_CMP         =SIMP(statut='o',typ='TXM',into=("DX","DY","DZ") ),
         PRECISION       =SIMP(statut='f',typ='R',defaut=0.999 ),
         INTERF           =FACT(statut='o',
            GROUP_NO_INTERF =SIMP(statut='o',typ=grma ,max='**'), 
            MODE_INTERF  =SIMP(statut='o',typ='TXM',into=("CORP_RIGI","TOUT")),
         ),      
         MATR_COHE       =FACT(statut='o',
            VITE_ONDE       =SIMP(statut='o',typ='R'),
            PARA_ALPHA     =SIMP(statut='f',typ='R',defaut=0.5),           
         ),
#        FONC_MULT     =SIMP(statut='f',typ='R' ),
         FREQ_INIT       =SIMP(statut='o',typ='R' ),
         NB_FREQ       =SIMP(statut='o',typ='I' ),
         PAS             =SIMP(statut='o',typ='R' ),     
#        LIST_FREQ        =SIMP(statut='o',typ='liste' ),  
         UNITE_RESU_FORC = SIMP(statut='f',typ='I',defaut=33),
         UNITE_RESU_IMPE  = SIMP(statut='f',typ='I',defaut=32), 
         TYPE             = SIMP(statut='f',typ='TXM',into=("BINAIRE","ASCII"), defaut="ASCII"),
#
         MATR_GENE         = FACT(statut='o',
            MATR_MASS     = SIMP(statut='o',typ=(matr_asse_gene_r ) ),
            MATR_RIGI     = SIMP(statut='o',typ=(matr_asse_gene_r,matr_asse_gene_c ) ),
            MATR_AMOR     = SIMP(statut='f',typ=(matr_asse_gene_r,matr_asse_gene_c ) ), 
         ),         
#         
#         OPTION        =SIMP(statut='f',typ='TXM',into=("TOUT","DIAG"),defaut="TOUT"),
#             
         INFO           =SIMP(statut='f',typ='I' ,defaut=1,into=( 1 , 2)),
         )  ;
#& MODIF COMMANDE  DATE 24/03/2009   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ANDRIAM H.ANDRIAMBOLOLONA
def dyna_line_harm_prod(MATR_RIGI,**args):
   if (AsType(MATR_RIGI) == matr_asse_depl_r) : return dyna_harmo
   elif (AsType(MATR_RIGI) == matr_asse_depl_c) : return dyna_harmo
   elif (AsType(MATR_RIGI) == matr_asse_pres_c) : return acou_harmo
   elif (AsType(MATR_RIGI) == matr_asse_gene_r) : return harm_gene
   elif (AsType(MATR_RIGI) == matr_asse_gene_c) : return harm_gene
   raise AsException("type de concept resultat non prevu")

DYNA_LINE_HARM=OPER(nom="DYNA_LINE_HARM",op=  60,sd_prod=dyna_line_harm_prod,
                    fr="Calcul de la rponse dynamique complexe d'un systme  une excitation harmonique",
                    reentrant='f',
            UIinfo={"groupes":("Rsolution",)},
         regles=(PRESENT_ABSENT('AMOR_REDUIT','MATR_AMOR'),
                 PRESENT_ABSENT('AMOR_REDUIT','LIST_AMOR'),
                 PRESENT_ABSENT('MATR_AMOR','LIST_AMOR'),
                 UN_PARMI('FREQ','LIST_FREQ'),
                 CONCEPT_SENSIBLE('ENSEMBLE'),),
         CHAM_MATER      =SIMP(statut='f',typ=cham_mater ),
         CARA_ELEM       =SIMP(statut='f',typ=cara_elem ),
         MATR_MASS       =SIMP(statut='o',typ=(matr_asse_depl_r,matr_asse_pres_c,matr_asse_gene_r ) ),
         MATR_RIGI       =SIMP(statut='o',typ=(matr_asse_depl_r,matr_asse_depl_c,matr_asse_pres_c
                                              ,matr_asse_gene_r,matr_asse_gene_c ) ),
         MATR_AMOR       =SIMP(statut='f',typ=(matr_asse_depl_r,matr_asse_pres_c,matr_asse_gene_r ) ),
         AMOR_REDUIT     =SIMP(statut='f',typ='R',max='**'),
         LIST_AMOR       =SIMP(statut='f',typ=listr8_sdaster ),
         MATR_IMPE_PHI   =SIMP(statut='f',typ=(matr_asse_depl_r,matr_asse_gene_r) ),
         FREQ            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
         LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster ),
         TOUT_CHAM       =SIMP(statut='f',typ='TXM',into=("OUI",)),
         NOM_CHAM        =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max=3,into=("DEPL","VITE","ACCE") ),
         b_reuse =BLOC(condition = "reuse",fr="en mode concept reentrant : RESULTAT obligatoire",
             RESULTAT      =SIMP(statut='o',typ=(dyna_harmo,harm_gene)),
         ),
         EXCIT           =FACT(statut='o',max='**',
           regles=(UN_PARMI('VECT_ASSE','CHARGE'),
                   UN_PARMI('FONC_MULT','FONC_MULT_C','COEF_MULT','COEF_MULT_C'),
                  ),
           VECT_ASSE       =SIMP(statut='f',position='global',typ=(cham_no_sdaster,vect_asse_gene) ),
           CHARGE          =SIMP(statut='f',position='global', typ=char_meca ),
           TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE",into=("FIXE",) ),
           FONC_MULT_C     =SIMP(statut='f',typ=(fonction_c,formule_c) ),
           COEF_MULT_C     =SIMP(statut='f',typ='C' ),
           FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           COEF_MULT       =SIMP(statut='f',typ='R' ),
           PHAS_DEG        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           PUIS_PULS       =SIMP(statut='f',typ='I',defaut= 0 ),
         ),
         b_modele_char =BLOC(condition = " CHARGE != None ",
                       MODELE    =SIMP(statut='o',typ=modele_sdaster ),
                       ),
         b_modele_vect =BLOC(condition = " VECT_ASSE != None ",
                       MODELE    =SIMP(statut='f',typ=modele_sdaster ),
                       ),
         EXCIT_RESU      =FACT(statut='f',max='**',
           RESULTAT        =SIMP(statut='o',typ=(dyna_harmo,harm_gene)),
           COEF_MULT_C     =SIMP(statut='o',typ='C' ),
         ),
         b_matr_gene =BLOC(condition = "AsType(MATR_MASS) in (matr_asse_gene_r,)",
                           fr="Methode de resolution matrice generalisee",
          SOLVEUR         =FACT(statut='d',
           METHODE         =SIMP(statut='f',typ='TXM',defaut="LDLT",into=("LDLT","MUMPS",) ),

           b_ldlt_gene      =BLOC(condition = "METHODE == 'LDLT' ",fr="Paramtres de la mthode LDLT",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("RCMK","SANS") ),
             NPREC           =SIMP(statut='f',typ='I',defaut=8),
             STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           ),

           b_mumps_gene     =BLOC(condition = "METHODE == 'MUMPS' ",fr="Paramtres de la mthode MUMPS",
             TYPE_RESOL      =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("NONSYM","SYMGEN","SYMDEF","AUTO")),
             PRETRAITEMENTS  =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO")),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("AMD","AMF","PORD","METIS","QAMD","AUTO")),
             ELIM_LAGR2      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
             PCENT_PIVOT     =SIMP(statut='f',typ='I',defaut=10,),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut=-1.0,),
             PARALLELISME    =SIMP(statut='f',typ='TXM',defaut="CENTRALISE",
                                       into=("CENTRALISE","DISTRIBUE_MAILLE","DISTRIBUE_SD")),
             PARTITION       =SIMP(statut='f',typ=sd_feti_sdaster),
             CHARGE_PROC0_MA =SIMP(statut='f',typ='I',defaut=0,val_min=0),
             CHARGE_PROC0_SD =SIMP(statut='f',typ='I',defaut=0,val_min=0),
             OUT_OF_CORE     =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
           ),
          ),
         ),

         b_matr_phys =BLOC(condition = "AsType(MATR_MASS) in (matr_asse_depl_r,matr_asse_pres_c,)",
                           fr="Methode de resolution matrice sur ddl physique",
          SOLVEUR         =FACT(statut='d',
           METHODE         =SIMP(statut='f',typ='TXM',defaut="MULT_FRONT",into=("MULT_FRONT","LDLT","MUMPS",) ),

           b_mult_front_phys=BLOC(condition = "METHODE == 'MULT_FRONT' ",fr="Paramtres de la mthode multi frontale",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="METIS",into=("MD","MDA","METIS") ),
             NPREC           =SIMP(statut='f',typ='I',defaut=8),
             STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           ),

           b_ldlt_phys      =BLOC(condition = "METHODE == 'LDLT' ",fr="Paramtres de la mthode LDLT",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("RCMK","SANS") ),
             NPREC           =SIMP(statut='f',typ='I',defaut=8),
             STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           ),

           b_mumps_phys     =BLOC(condition = "METHODE == 'MUMPS' ",fr="Paramtres de la mthode MUMPS",
             TYPE_RESOL      =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("NONSYM","SYMGEN","SYMDEF","AUTO")),
             PRETRAITEMENTS  =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO")),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("AMD","AMF","PORD","METIS","QAMD","AUTO")),
             ELIM_LAGR2      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
             PCENT_PIVOT     =SIMP(statut='f',typ='I',defaut=10,),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut=-1.0,),
             PARALLELISME    =SIMP(statut='f',typ='TXM',defaut="CENTRALISE",
                                       into=("CENTRALISE","DISTRIBUE_MAILLE","DISTRIBUE_SD")),
             PARTITION       =SIMP(statut='f',typ=sd_feti_sdaster),
             CHARGE_PROC0_MA =SIMP(statut='f',typ='I',defaut=0,val_min=0),
             CHARGE_PROC0_SD =SIMP(statut='f',typ='I',defaut=0,val_min=0),
             OUT_OF_CORE      =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
             ),
          ),
         ),

         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         SENSIBILITE     =SIMP(statut='f',typ=(para_sensi,theta_geom),validators=NoRepeat(),max='**',
                               fr="Liste des paramtres de sensibilit.",
                               ang="List of sensitivity parameters"),
)  ;
# Rajouter test icompatibilite vect_asse et sensibilite
# Peut-on aussi rajouter ici le test d incompatibilite charge complexe - derivation
#  presents dans le Fortran
#& MODIF COMMANDE  DATE 06/10/2008   AUTEUR DEVESA G.DEVESA 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE BOYERE E.BOYERE
DYNA_LINE_TRAN=OPER(nom="DYNA_LINE_TRAN",op=  48,sd_prod=dyna_trans,
                    fr="Calcul de la rponse dynamique transitoire  une excitation temporelle quelconque",
                    reentrant='f',
            UIinfo={"groupes":("Rsolution",)},
#         regles=(UN_PARMI('WILSON','DIFF_CENTRE','ADAPT'),),
         regles=(UN_PARMI('NEWMARK','WILSON','DIFF_CENTRE','ADAPT'),
                 CONCEPT_SENSIBLE('ENSEMBLE'),),
         MODELE          =SIMP(statut='f',typ=modele_sdaster ),
         CHAM_MATER      =SIMP(statut='f',typ=cham_mater ),
         CARA_ELEM       =SIMP(statut='f',typ=cara_elem ),
         MATR_MASS       =SIMP(statut='o',typ=matr_asse_depl_r ),
         MATR_RIGI       =SIMP(statut='o',typ=matr_asse_depl_r ),
         MATR_AMOR       =SIMP(statut='f',typ=matr_asse_depl_r ),
         MODE_STAT       =SIMP(statut='f',typ=(mode_stat_depl,mode_stat_acce,mode_stat_forc,) ),
         NEWMARK         =FACT(statut='f',
           ALPHA           =SIMP(statut='f',typ='R',defaut= 0.25 ),
           DELTA           =SIMP(statut='f',typ='R',defaut= 0.5 ),
         ),
         WILSON          =FACT(statut='f',
           THETA           =SIMP(statut='f',typ='R',defaut= 1.4 ),
         ),
         DIFF_CENTRE     =FACT(statut='f',
         ),
         ADAPT           =FACT(statut='f',
         ),
         ETAT_INIT       =FACT(statut='f',
           regles=(AU_MOINS_UN('DYNA_TRANS', 'DEPL_INIT', 'VITE_INIT', 'ACCE_INIT'),
                   PRESENT_ABSENT('DYNA_TRANS', 'DEPL_INIT', 'VITE_INIT', 'ACCE_INIT'),),
           DYNA_TRANS      =SIMP(statut='f',typ=dyna_trans ),
           b_dyna_trans    =BLOC(condition = "DYNA_TRANS != None",
             regles=(EXCLUS('NUME_INIT','INST_INIT' ),),
             NUME_INIT       =SIMP(statut='f',typ='I' ),
             INST_INIT       =SIMP(statut='f',typ='R' ),
             b_inst_init     =BLOC(condition = "INST_INIT != None",
               CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
               b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                   PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
               b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                   PRECISION       =SIMP(statut='o',typ='R',),),
             ),
           ),
           DEPL_INIT       =SIMP(statut='f',typ=cham_no_sdaster),
           VITE_INIT       =SIMP(statut='f',typ=cham_no_sdaster),
           ACCE_INIT       =SIMP(statut='f',typ=cham_no_sdaster),
         ),
         EXCIT           =FACT(statut='f',max='**',
           regles=(UN_PARMI('CHARGE','VECT_ASSE'),
                   EXCLUS('CHARGE','COEF_MULT'),
                   EXCLUS('FONC_MULT','COEF_MULT'),
                   EXCLUS('ACCE','COEF_MULT'),
                   PRESENT_ABSENT('ACCE','FONC_MULT'),
                   PRESENT_PRESENT('ACCE','VITE','DEPL'),
                   # PRESENT_ABSENT('MULT_APPUI','FONC_MULT'),
                   ),
           VECT_ASSE       =SIMP(statut='f',typ=cham_no_sdaster),
           CHARGE          =SIMP(statut='f',typ=char_meca ),
           FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           COEF_MULT       =SIMP(statut='f',typ='R' ),
           TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE",into=("FIXE",) ),
           ACCE            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VITE            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DEPL            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MULT_APPUI      =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
           DIRECTION       =SIMP(statut='f',typ='R',max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
         ),
         EXCIT_RESU      =FACT(statut='f',max='**',
           RESULTAT        =SIMP(statut='o',typ=dyna_trans ),
           COEF_MULT       =SIMP(statut='o',typ='R' ),
         ),
         AMOR_MODAL      =FACT(statut='f',
           MODE_MECA       =SIMP(statut='f',typ=mode_meca ),
           AMOR_REDUIT     =SIMP(statut='f',typ='R',max='**'),
           NB_MODE         =SIMP(statut='f',typ='I',defaut= 9999 ),
         ),

         SOLVEUR         =FACT(statut='d',
         METHODE         =SIMP(statut='f',typ='TXM',defaut="MULT_FRONT",into=("MULT_FRONT","LDLT","GCPC","MUMPS","PETSC") ),

           b_mult_front    =BLOC(condition = "METHODE == 'MULT_FRONT' ",fr="Paramtres de la mthode multi frontale",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="METIS",into=("MD","MDA","METIS") ),
           ),

           b_ldlt          =BLOC(condition = "METHODE == 'LDLT' ",fr="Paramtres de la mthode LDLT",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("RCMK","SANS") ),
           ),

           b_ldlt_mult     =BLOC(condition = "METHODE == 'LDLT' or METHODE == 'MULT_FRONT'",
                                   fr="Paramtres relatifs  la non inversibilit de la matrice  factorise",
             NPREC           =SIMP(statut='f',typ='I',defaut=8),
             STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           ),

           b_gcpc         =BLOC(condition = "METHODE == 'GCPC' ", fr="Paramtres de la mthode du gradient conjugu",
             PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC",),defaut="LDLT_INC" ),
             NIVE_REMPLISSAGE=SIMP(statut='f',typ='I',defaut= 0 ),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut=1.E-6),
             NMAX_ITER       =SIMP(statut='f',typ='I',defaut= 0 ),
           ),
           b_mumps        =BLOC(condition = "METHODE == 'MUMPS' ",fr="Paramtres de la mthode MUMPS",
             TYPE_RESOL      =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("NONSYM","SYMGEN","SYMDEF","AUTO")),
             PRETRAITEMENTS  =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO")),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("AMD","AMF","PORD","METIS","QAMD","AUTO")),
             ELIM_LAGR2      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
             PCENT_PIVOT     =SIMP(statut='f',typ='I',defaut=10,),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut=-1.0,),
             PARALLELISME    =SIMP(statut='f',typ='TXM',defaut="CENTRALISE",into=("CENTRALISE","CENTRALISE")),
             OUT_OF_CORE     =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
             ),

           b_petsc          =BLOC(condition = "METHODE == 'PETSC' ",fr="Paramtres de la mthode PETSC",
             ALGORITHME      =SIMP(statut='f',typ='TXM',into=("BCGS","BICG","CG","CR","GMRES","TFQMR",),defaut="CG" ),
             PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC","JACOBI","SOR"),defaut="LDLT_INC" ),
             b_petsc_ilu     =BLOC(condition = "PRE_COND == 'LDLT_INC' ",
               NIVE_REMPLISSAGE = SIMP(statut='f',typ='I',defaut= 0 ),
               REMPLISSAGE      = SIMP(statut='f',typ='R',defaut= 1.0),
             ),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
             NMAX_ITER       =SIMP(statut='f',typ='I',defaut= -1 ),
           ),
         ),

         INCREMENT       =FACT(statut='o',max='**',
           regles=(UN_PARMI('LIST_INST','FONC_INST','PAS'),),
           LIST_INST       =SIMP(statut='f',typ=listr8_sdaster ),
           FONC_INST       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PAS             =SIMP(statut='f',typ='R' ),
           b_pas           =BLOC(condition = "PAS != None",
               INST_INIT       =SIMP(statut='f',typ='R' ),
               INST_FIN        =SIMP(statut='f',typ='R' ),
           ),
           b_list_fonc     =BLOC(condition = "LIST_INST != None or FONC_INST != None",
               regles=(EXCLUS('INST_FIN','NUME_FIN'),),
               NUME_FIN        =SIMP(statut='f',typ='I' ),
               INST_FIN        =SIMP(statut='f',typ='R' ),
           ),
           VITE_MIN        =SIMP(statut='f',typ='TXM',defaut="NORM",into=("MAXI","NORM") ),
           COEF_MULT_PAS   =SIMP(statut='f',typ='R',defaut= 1.1 ),
           COEF_DIVI_PAS   =SIMP(statut='f',typ='R',defaut= 1.33334 ),
           PAS_LIMI_RELA   =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
           NB_POIN_PERIODE =SIMP(statut='f',typ='I',defaut= 50 ),
           NMAX_ITER_PAS   =SIMP(statut='f',typ='I',defaut= 16 ),
           PAS_CALCUL      =SIMP(statut='f',typ='I',defaut= 1 ),
         ),
         ARCHIVAGE       =FACT(statut='f',
           regles=(UN_PARMI('LIST_ARCH','PAS_ARCH', ),),
           LIST_ARCH       =SIMP(statut='f',typ=listis_sdaster ),
           PAS_ARCH        =SIMP(statut='f',typ='I' ),
           CHAM_EXCLU      =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',into=("DEPL","VITE","ACCE") ),
         ),
         SENSIBILITE     =SIMP(statut='f',typ=(para_sensi,theta_geom),validators=NoRepeat(),max='**',
                               fr="Liste des paramtres de sensibilit.",
                               ang="List of sensitivity parameters",
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2009   AUTEUR ABBAS M.ABBAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE GREFFET N.GREFFET
#
DYNA_NON_LINE=OPER(nom="DYNA_NON_LINE",op= 70,sd_prod=evol_noli,reentrant='f',
            fr="Calcul de l'volution dynamique d'une structure dont le matriau ou la gomtrie ont un comportement non linaire",
            UIinfo={"groupes":("Rsolution",)},
         regles=(AU_MOINS_UN('COMP_INCR','COMP_ELAS',),
                 CONCEPT_SENSIBLE('ENSEMBLE'),),
         MODELE          =SIMP(statut='o',typ=modele_sdaster),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater),
         MODE_STAT       =SIMP(statut='f',typ=(mode_stat_depl,mode_stat_acce,mode_stat_forc,)),
         CARA_ELEM       =SIMP(statut='f',typ=cara_elem),
         MASS_DIAG       =SIMP(statut='f',typ='TXM',into=("OUI","NON",) ),
         EXCIT           =FACT(statut='o',max='**',
           regles=(PRESENT_ABSENT('FONC_MULT','ACCE'),
                   PRESENT_PRESENT('ACCE','VITE','DEPL'),
                   # PRESENT_ABSENT('MULT_APPUI','FONC_MULT'),
                   ),
           TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE_CSTE",
                                 into=("FIXE_CSTE","SUIV","DIDI")),
           CHARGE          =SIMP(statut='o',typ=(char_meca,char_cine_meca)),
           FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           DEPL            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ACCE            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           VITE            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           MULT_APPUI      =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
           DIRECTION       =SIMP(statut='f',typ='R',max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
         ),
         EXCIT_GENE      =FACT(statut='f',max='**',
           FONC_MULT       =SIMP(statut='f',typ=fonction_sdaster,max='**' ),
           VECT_GENE       =SIMP(statut='f',typ=vect_asse_gene,max='**' ),
         ),
         SOUS_STRUC      =FACT(statut='f',min=01,max='**',
                regles=(UN_PARMI('TOUT','SUPER_MAILLE'),),
                CAS_CHARGE  =SIMP(statut='o',typ='TXM' ),
                TOUT        =SIMP(statut='f',typ='TXM',into=("OUI",) ),
                SUPER_MAILLE=SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**',),
                FONC_MULT   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
              ),
         AMOR_MODAL      =FACT(statut='f',
           regles=(EXCLUS('AMOR_REDUIT','LIST_AMOR'),),
           MODE_MECA       =SIMP(statut='f',typ=mode_meca),
           AMOR_REDUIT     =SIMP(statut='f',typ='R',max='**' ),
           LIST_AMOR       =SIMP(statut='f',typ=listr8_sdaster ),
           NB_MODE         =SIMP(statut='f',typ='I',defaut= 9999 ),
           REAC_VITE       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         ),
         PROJ_MODAL      =FACT(statut='f',max='**',
           MODE_MECA       =SIMP(statut='o',typ=(mode_meca,base_modale)),
           NB_MODE         =SIMP(statut='f',typ='I',defaut= 9999 ),
           regles=(PRESENT_PRESENT('MASS_GENE','RIGI_GENE'),),
           MASS_GENE       =SIMP(statut='f',typ=matr_asse_gene_r),
           RIGI_GENE       =SIMP(statut='f',typ=matr_asse_gene_r),
           AMOR_GENE       =SIMP(statut='f',typ=matr_asse_gene_r),
         ),
         COMP_INCR       =C_COMP_INCR(),
         COMP_ELAS       =FACT(statut='f',max='**',
           RELATION        =SIMP(statut='o',typ='TXM',defaut="ELAS",
                                 into=("ELAS","ELAS_VMIS_LINE","ELAS_VMIS_TRAC","ELAS_VMIS_PUIS",
                                      "ELAS_POUTRE_GR","CABLE","ELAS_HYPER")),
           DEFORMATION     =SIMP(statut='f',typ='TXM',defaut="PETIT" ,into=("PETIT","GREEN","GREEN_GR",) ),
      regles=(PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           RESI_INTE_RELA  =SIMP(statut='f',typ='R',defaut= 1.0E-6),
           ITER_INTE_MAXI  =SIMP(statut='f',typ='I',defaut= 10 ),
           ITER_INTE_PAS   =SIMP(statut='f',typ='I',defaut= 0 ),
           RESO_INTE       =SIMP(statut='f',typ='TXM',defaut="IMPLICITE",
                                 into=("RUNGE_KUTTA_2","RUNGE_KUTTA_4","IMPLICITE")),
         ),
#-------------------------------------------------------------------
         b_reuse =BLOC(condition = "reuse",fr="en mode concept reentrant : ETAT_INIT obligatoire",
         ETAT_INIT       =FACT(statut='o',
           regles=(AU_MOINS_UN('EVOL_NOLI','DEPL','VITE','ACCE','SIGM','VARI',),
                   EXCLUS('EVOL_NOLI','DEPL',),
                   EXCLUS('EVOL_NOLI','VITE'),
                   EXCLUS('EVOL_NOLI','ACCE'),
                   EXCLUS('EVOL_NOLI','SIGM',),
                   EXCLUS('EVOL_NOLI','VARI',),
                   EXCLUS('NUME_ORDRE','INST'), ),
           DEPL            =SIMP(statut='f',typ=cham_no_sdaster),
           VITE            =SIMP(statut='f',typ=cham_no_sdaster),
           ACCE            =SIMP(statut='f',typ=cham_no_sdaster),
           SIGM            =SIMP(statut='f',typ=(cham_elem,carte_sdaster)),
           VARI            =SIMP(statut='f',typ=cham_elem),
           EVOL_NOLI       =SIMP(statut='f',typ=evol_noli),
           NUME_ORDRE      =SIMP(statut='f',typ='I'),
           INST            =SIMP(statut='f',typ='R'),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
           b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
               PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
           b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
               PRECISION       =SIMP(statut='o',typ='R',),),
           NUME_DIDI       =SIMP(statut='f',typ='I'),
           INST_ETAT_INIT  =SIMP(statut='f',typ='R'),
         ),),
         b_not_reuse =BLOC(condition = "not reuse",fr="en mode concept non reentrant : ETAT_INIT facultatif",
         ETAT_INIT       =FACT(statut='f',
           regles=(AU_MOINS_UN('EVOL_NOLI','DEPL','VITE','ACCE','SIGM','VARI',),
                   EXCLUS('EVOL_NOLI','DEPL',),
                   EXCLUS('EVOL_NOLI','VITE'),
                   EXCLUS('EVOL_NOLI','ACCE'),
                   EXCLUS('EVOL_NOLI','SIGM',),
                   EXCLUS('EVOL_NOLI','VARI',),
                   EXCLUS('NUME_ORDRE','INST'), ),
           DEPL            =SIMP(statut='f',typ=cham_no_sdaster),
           VITE            =SIMP(statut='f',typ=cham_no_sdaster),
           ACCE            =SIMP(statut='f',typ=cham_no_sdaster),
           SIGM            =SIMP(statut='f',typ=(cham_elem,carte_sdaster)),
           VARI            =SIMP(statut='f',typ=cham_elem),
           EVOL_NOLI       =SIMP(statut='f',typ=evol_noli),
           NUME_ORDRE      =SIMP(statut='f',typ='I'),
           INST            =SIMP(statut='f',typ='R'),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
           b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
               PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
           b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
               PRECISION       =SIMP(statut='o',typ='R',),),
           NUME_DIDI       =SIMP(statut='f',typ='I'),
           INST_ETAT_INIT  =SIMP(statut='f',typ='R'),
         ),),
#-------------------------------------------------------------------
         INCREMENT       =FACT(statut='o',
           regles=(EXCLUS('NUME_INST_INIT','INST_INIT'),
                   EXCLUS('NUME_INST_FIN','INST_FIN'),),
           LIST_INST       =SIMP(statut='o',typ=listr8_sdaster),
           NUME_INST_INIT  =SIMP(statut='f',typ='I'),
           INST_INIT       =SIMP(statut='f',typ='R'),
           NUME_INST_FIN   =SIMP(statut='f',typ='I'),
           INST_FIN        =SIMP(statut='f',typ='R'),
           PRECISION       =SIMP(statut='f',typ='R',defaut=1.0E-6 ),
           # DEBUT DE BLOC POUR LA SUBDIVISION DES PAS DE TEMPS
           SUBD_METHODE    =SIMP( statut='f',typ='TXM',
              into =("AUCUNE","UNIFORME","EXTRAPOLE"),
              defaut="UNIFORME",
              fr="Mthode de subdivision des pas de temps en cas de non-convergence"
           ),
           b_subd_unif=BLOC(condition = "SUBD_METHODE == 'UNIFORME'",
             regles=(AU_MOINS_UN('SUBD_NIVEAU','SUBD_PAS_MINI'),),
             SUBD_COEF_PAS_1=SIMP(statut='f',typ='R',defaut=1.0,val_min=0.0,
                fr="Coefficient multiplicateur de la 1re subdivision"),
             SUBD_PAS       =SIMP(statut='f',typ='I',defaut=4,val_min=2,
                fr="Nombre de subdivision d'un pas de temps"),
             SUBD_NIVEAU=SIMP(statut='f',typ='I',val_min=2,defaut=3,
                fr="Nombre maximum de niveau de subdivision d'un pas de temps"),
             SUBD_PAS_MINI=SIMP(statut='f',typ='R',val_min=0.0,
                fr="Pas de temps en dessous duquel on ne subdivise plus"),
           ),
           b_subd_extr=BLOC(condition = "SUBD_METHODE == 'EXTRAPOLE'",
             regles=(AU_MOINS_UN('SUBD_NIVEAU','SUBD_PAS_MINI'),),
             SUBD_OPTION    =SIMP(statut='f',typ='TXM',
                into =("IGNORE_PREMIERES","GARDE_DERNIERES",),
                defaut="IGNORE_PREMIERES",
                fr="Technique d'extrapolation : les 1ere itrations sont ignores ou les dernires sont gardes"),
             SUBD_ITER_IGNO =SIMP(statut='c',typ='I',defaut=3,val_min=0,
                fr="Les n premires itrations sont ignores pour l'extrapolation"),
             SUBD_ITER_FIN  =SIMP(statut='c',typ='I',defaut=8,val_min=3,
                fr="Seules les n dernires itrations sont prises pour l'extrapolation"),
             SUBD_PAS       =SIMP(statut='c',typ='I',defaut=4,val_min=2,
                fr="Nombre de subdivision d'un pas de temps en cas divergence"),
             SUBD_NIVEAU=SIMP(statut='f',typ='I',val_min=2,
                fr="Nombre maximum de niveau de subdivision d'un pas de temps"),
             SUBD_PAS_MINI=SIMP(statut='f',typ='R',val_min=0.0,
                fr="Pas de temps en dessous duquel on ne subdivise plus"),
             SUBD_ITER_PLUS =SIMP(statut='c',typ='I',defaut=50,val_min=20,
                fr="% itration autorise en plus"),
           ),
           # FIN DE BLOC POUR LA SUBDIVISION DES PAS DE TEMPS
         ),
#-------------------------------------------------------------------
         SCHEMA_TEMPS     =FACT(statut='o',
            SCHEMA          =SIMP(statut='o',min=1,max=1,typ='TXM',
                                  into=("DIFF_CENT","TCHAMWA","NEWMARK","HHT","THETA_METHODE"),),
            b_tchamwa = BLOC(condition="SCHEMA=='TCHAMWA'",
               PHI          =SIMP(statut='f',typ='R',defaut= 1.05),),

            b_newmark = BLOC(condition="SCHEMA=='NEWMARK'",
               BETA         =SIMP(statut='f',typ='R',defaut= 0.25),
               GAMMA        =SIMP(statut='f',typ='R',defaut= 0.5),),

            b_hht     = BLOC(condition="SCHEMA=='HHT'",
               ALPHA        =SIMP(statut='f',typ='R',defaut= -0.3 ),
               MODI_EQUI    =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON"),),),

            b_theta   = BLOC(condition="SCHEMA=='THETA_METHODE'",
               THETA         =SIMP(statut='f',typ='R',defaut= 1.,val_min=0.5,val_max=1. ),),

            b_explicit= BLOC(condition="SCHEMA=='TCHAMWA'or SCHEMA=='DIFF_CENT'",
               STOP_CFL     =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON"),),
               FORMULATION  =SIMP(statut='o',typ='TXM',into=("ACCELERATION",),),),

            b_implicit= BLOC(condition="SCHEMA!='TCHAMWA'and SCHEMA!='DIFF_CENT'",
               FORMULATION  =SIMP(statut='o',max=1,typ='TXM',into=("DEPLACEMENT","VITESSE","ACCELERATION"),),),
         ),
         NEWTON          =FACT(statut='d',
           REAC_INCR       =SIMP(statut='f',typ='I',defaut= 1,val_min=0 ),
           PREDICTION      =SIMP(statut='f',typ='TXM',into=("TANGENTE","ELASTIQUE") ),
           MATRICE         =SIMP(statut='f',typ='TXM',defaut="TANGENTE",into=("TANGENTE","ELASTIQUE") ),
           REAC_ITER       =SIMP(statut='f',typ='I',defaut= 0,val_min=0),
           REAC_ITER_ELAS  =SIMP(statut='f',typ='I',defaut=0,val_min=0),
           PAS_MINI_ELAS   =SIMP(statut='f',typ='R',defaut=0.0E+0),
         ),
         SOLVEUR         =FACT(statut='d',
           METHODE=SIMP(statut='f',typ='TXM',defaut="MULT_FRONT",into=("MULT_FRONT","LDLT","GCPC","MUMPS","FETI","PETSC") ),
           b_mult_front    =BLOC(condition= "METHODE == 'MULT_FRONT' ",fr="Paramtres de la mthode multi frontale",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="METIS",into=("MD","MDA","METIS") ),
           ),
           b_ldlt          =BLOC(condition= "METHODE == 'LDLT'",fr="Paramtres de la mthode LDLT",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("RCMK","SANS") ),
           ),
           b_ldlt_mult     =BLOC(condition="METHODE == 'LDLT' or METHODE == 'MULT_FRONT'",
                                   fr="Paramtres relatifs  la non inversibilit de la matrice  factorise",
             NPREC           =SIMP(statut='f',typ='I',defaut= 8 ),
             STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON","DECOUPE") ),
           ),
           b_mumps        =BLOC(condition = "METHODE == 'MUMPS' ",fr="Paramtres de la mthode MUMPS",
             TYPE_RESOL      =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("NONSYM","SYMGEN","SYMDEF","AUTO")),
             PRETRAITEMENTS  =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO")),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("AMD","AMF","PORD","METIS","QAMD","AUTO")),
             ELIM_LAGR2      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
             PCENT_PIVOT     =SIMP(statut='f',typ='I',defaut=10,),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut=-1.0,),
             PARALLELISME    =SIMP(statut='f',typ='TXM',defaut="CENTRALISE",
                                   into=("CENTRALISE","DISTRIBUE_MC","DISTRIBUE_MD","DISTRIBUE_SD")),
             PARTITION       =SIMP(statut='f',typ=sd_feti_sdaster),
             CHARGE_PROC0_MA =SIMP(statut='f',typ='I',defaut=100,val_min=0),
             CHARGE_PROC0_SD =SIMP(statut='f',typ='I',defaut=0,val_min=0),
             OUT_OF_CORE     =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
             ),
           b_gcpc          =BLOC(condition="METHODE == 'GCPC'",fr="Paramtres de la mthode du gradient conjugu",
             PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC",),defaut="LDLT_INC" ),
             NIVE_REMPLISSAGE=SIMP(statut='f',typ='I',defaut=0),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
             NMAX_ITER       =SIMP(statut='f',typ='I',defaut= 0 ),
           ),
           b_petsc          =BLOC(condition = "METHODE == 'PETSC' ",fr="Paramtres de la mthode PETSC",
             ALGORITHME      =SIMP(statut='f',typ='TXM',into=("BCGS","BICG","CG","CR","GMRES","TFQMR",),defaut="CG" ),
             PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC","JACOBI","SOR"),defaut="LDLT_INC" ),
             b_petsc_ilu     =BLOC(condition = "PRE_COND == 'LDLT_INC' ",
              NIVE_REMPLISSAGE = SIMP(statut='f',typ='I',defaut= 0 ),
              REMPLISSAGE      = SIMP(statut='f',typ='R',defaut= 1.0),
             ),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.E-6),
             NMAX_ITER       =SIMP(statut='f',typ='I',defaut= -1 ),
           ),
           SYME            =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         ),
#-------------------------------------------------------------------
         CONVERGENCE     =FACT(statut='d',
           regles=(PRESENT_ABSENT('RESI_REFE_RELA','RESI_GLOB_MAXI','RESI_GLOB_RELA'),),
           b_refe_rela    =BLOC(condition = "RESI_REFE_RELA != None",
             regles=(AU_MOINS_UN('SIGM_REFE','EPSI_REFE','FLUX_THER_REFE',
                                  'FLUX_HYD1_REFE','FLUX_HYD2_REFE','VARI_REFE'),),
             SIGM_REFE       =SIMP(statut='f',typ='R'),
             EPSI_REFE       =SIMP(statut='f',typ='R'),
             FLUX_THER_REFE  =SIMP(statut='f',typ='R'),
             FLUX_HYD1_REFE  =SIMP(statut='f',typ='R'),
             FLUX_HYD2_REFE  =SIMP(statut='f',typ='R'),
             VARI_REFE       =SIMP(statut='f',typ='R'),
           ),
           RESI_REFE_RELA  =SIMP(statut='f',typ='R'),
           RESI_GLOB_MAXI  =SIMP(statut='f',typ='R'),
           RESI_GLOB_RELA  =SIMP(statut='f',typ='R'),
           ITER_GLOB_MAXI  =SIMP(statut='f',typ='I',defaut=10),
           ITER_GLOB_ELAS  =SIMP(statut='f',typ='I',defaut=25),
           TYPE            =SIMP(statut='f',typ='TXM',defaut="PIC",into=("PIC","PLATEAU")),
           b_plateau    =BLOC(condition = "TYPE == 'PLATEAU' ",

             PLATEAU_ITER    =SIMP(statut='f',typ='I',defaut=3, val_min =2),
             PLATEAU_RELA    =SIMP(statut='f',typ='R',defaut=1E-3),
           ),
           ARRET           =SIMP(statut='f',typ='TXM',defaut="OUI"),

         ),
#-------------------------------------------------------------------
         OBSERVATION     =FACT(statut='f',max='**',
           NOM_CMP         =SIMP(statut='o',typ='TXM',max='**' ),
           SUIVI_DDL       =SIMP(statut='f',typ='TXM',defaut="NON",max=1,into=("OUI","NON")),
         b_suivi          =BLOC(condition = "SUIVI_DDL == 'OUI' ",
                                regles=(UN_PARMI('NOEUD','MAILLE','GROUP_NO','GROUP_MA','VALE_MIN','VALE_MAX'),
                                                  PRESENT_PRESENT('MAILLE','POINT'),),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             POINT           =SIMP(statut='f',typ='I' ,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             NOM_CHAM        =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                                   into=("DEPL","VITE","ACCE","SIEF_ELGA",
                                         "VARI_ELGA","FORC_NODA","DEPL_ABSOLU","VITE_ABSOLU","ACCE_ABSOLU",)),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             NUME_SUIVI      =SIMP(statut='o',typ='I' ,min=1,max=4),
             VALE_MAX        =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max=1,into=("OUI",) ),
             VALE_MIN        =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max=1,into=("OUI",) ),),
         b_non_suivi      =BLOC(condition = "SUIVI_DDL == 'NON' ",
                                regles=(UN_PARMI('NOEUD','GROUP_NO','MAILLE'),PRESENT_PRESENT('MAILLE','POINT'),),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             POINT           =SIMP(statut='f',typ='I' ,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             NOM_CHAM        =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',into=("DEPL","VITE","ACCE","SIEF_ELGA",
                                              "VARI_ELGA","DEPL_ABSOLU","VITE_ABSOLU","ACCE_ABSOLU")),
             INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**' ),
             LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
             PAS_OBSE        =SIMP(statut='f',typ='I'),
             LIST_ARCH       =SIMP(statut='f',typ=listis_sdaster),
             CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
             b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
             b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                PRECISION       =SIMP(statut='o',typ='R',),),),
         ),

         AFFICHAGE      = FACT(statut='f',max=16,

            UNITE       = SIMP(statut='f',typ='I',val_min=1),

            LONG_R      = SIMP(statut='f',typ='I',defaut=12,val_min=1,val_max=12),
            PREC_R      = SIMP(statut='f',typ='I',defaut=5, val_min=1,val_max=8),
            LONG_I      = SIMP(statut='f',typ='I',defaut=6, val_min=1,val_max=12),

            NOM_COLONNE = SIMP(statut='o',typ='TXM',defaut="STANDARD",
                                into=("STANDARD","MINIMUM",
                                      "ITER_NEWT",
                                      "INCR_TPS",
                                      "RESI_RELA","RELA_NOEU",
                                      "RESI_MAXI","MAXI_NOEU",
                                      "RESI_REFE","REFE_NOEU",
                                      "RELI_ITER","RELI_COEF",
                                      "PILO_PARA",
                                      "MATR_ASSE",
                                      "ITER_DEBO",
                                      "CTCD_ITER","CTCD_GEOM","CTCD_NOEU",
                                      "CTCC_GEOM","CTCC_FROT","CTCC_CONT",
                                      "SUIV_1","SUIV_2","SUIV_3","SUIV_4",
                                     ),
                               ),
            b_residu    = BLOC(condition = " NOM_COLONNE == 'RESI_RELA' or \
                    NOM_COLONNE == 'RESI_MAXI' or\
                    NOM_COLONNE == 'RESI_REFE' or\
                    NOM_COLONNE == 'CTCD_GEOM' or\
                    NOM_COLONNE == 'STANDARD' ",
                            INFO_RESIDU = SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
                          ),
         ),
#-------------------------------------------------------------------
         ARCHIVAGE       =FACT(statut='f',
           regles=(EXCLUS('PAS_ARCH','LIST_INST','INST'),
                   EXCLUS('ARCH_ETAT_INIT','NUME_INIT'), ),
           LIST_INST       =SIMP(statut='f',typ=(listr8_sdaster) ),
           INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**' ),
           PAS_ARCH        =SIMP(statut='f',typ='I' ),
           PRECISION       =SIMP(statut='f',typ='R',defaut= 1.0E-6),
           ARCH_ETAT_INIT  =SIMP(statut='f',typ='TXM',into=("OUI",)),
           NUME_INIT       =SIMP(statut='f',typ='I'),
           DETR_NUME_SUIV  =SIMP(statut='f',typ='TXM',into=("OUI",)),
           CHAM_EXCLU      =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',
           into=("DEPL","SIEF_ELGA","VARI_ELGA","ACCE","VITE",)),
         ),

#-------------------------------------------------------------------
         CRIT_FLAMB     =FACT(statut='f',min=1,max=1,
           NB_FREQ         =SIMP(statut='f',typ='I',max=1,defaut=3),
           CHAR_CRIT       =SIMP(statut='f',typ='R',min=2,max=2,defaut=(-10.0,10.),
                            fr="Valeur des deux charges critiques dlimitant la bande de recherche en HPP"),
           INST_CALCUL       =SIMP(statut='f',typ='TXM',defaut="LISTE_ARCHIVAGE",into=("LISTE_ARCHIVAGE","TOUT_PAS",) ),
         ),
         MODE_VIBR     =FACT(statut='f',min=1,max=1,
           MATR_RIGI        =SIMP(statut='f',typ='TXM',defaut="ELASTIQUE",into=("ELASTIQUE","TANGENTE","SECANTE",) ),
           NB_FREQ          =SIMP(statut='f',typ='I',max=1,defaut=3,
                            fr="Nombre de frquences propres  calculer"),
           BANDE            =SIMP(statut='f',typ='R',min=2,max=2,
                            fr="Valeur des deux frquences dlimitant la bande de recherche",),
           INST_CALCUL       =SIMP(statut='f',typ='TXM',defaut="LISTE_ARCHIVAGE",into=("LISTE_ARCHIVAGE","TOUT_PAS",) ),
         ),
#-------------------------------------------------------------------
           SENSIBILITE     =SIMP(statut='f',typ=(para_sensi,theta_geom),validators=NoRepeat(),max='**',
                               fr="Liste des paramtres de sensibilit",
                               ang="List of sensitivity parameters"),
#-------------------------------------------------------------------
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE ADOBES A.ADOBES
DYNA_SPEC_MODAL=OPER(nom="DYNA_SPEC_MODAL",op= 147,sd_prod=table_fonction,
                     fr="Calcul de la rponse par recombinaison modale d'une structure linaire pour une excitation alatoire",
                     reentrant='n',
            UIinfo={"groupes":("Rsolution",)},
         BASE_ELAS_FLUI  =SIMP(statut='o',typ=melasflu_sdaster ),
         EXCIT           =FACT(statut='o',
           INTE_SPEC_GENE  =SIMP(statut='o',typ=table_fonction),
         ),
         OPTION          =SIMP(statut='f',typ='TXM',defaut="TOUT",into=("TOUT","DIAG") ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 02/06/2009   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE BOYERE E.BOYERE
DYNA_TRAN_MODAL=OPER(nom="DYNA_TRAN_MODAL",op=  74,sd_prod=tran_gene,
                     fr="Calcul de la rponse dynamique transitoire d'un systme amorti ou non en coordones gnralises"
                        +" par superposition modale ou par sous structuration",
                     reentrant='f',
            UIinfo={"groupes":("Rsolution",)},
      regles=(EXCLUS('AMOR_REDUIT','AMOR_GENE','LIST_AMOR'),
              PRESENT_ABSENT('MODE_STAT','MODE_CORR'),),
         METHODE         =SIMP(statut='f',typ='TXM',defaut="EULER",
                               into=("EULER","NEWMARK","DEVOGE","ADAPT","ITMI") ),
         MASS_GENE       =SIMP(statut='o',typ=matr_asse_gene_r ),
         RIGI_GENE       =SIMP(statut='o',typ=matr_asse_gene_r ),
         AMOR_GENE       =SIMP(statut='f',typ=matr_asse_gene_r ),
         AMOR_REDUIT     =SIMP(statut='f',typ='R',max='**'),
         LIST_AMOR       =SIMP(statut='f',typ=listr8_sdaster ),
         MODE_STAT       =SIMP(statut='f',typ=(mode_stat_depl,mode_stat_acce,mode_stat_forc) ),
         MODE_CORR       =SIMP(statut='f',typ=(mult_elas,mode_stat_acce) ,),

         ETAT_INIT       =FACT(statut='f',
           regles=(EXCLUS('RESU_GENE','DEPL_INIT_GENE'),
                   EXCLUS('RESU_GENE','VITE_INIT_GENE'),),
           RESU_GENE       =SIMP(statut='f',typ=tran_gene ),
           b_resu_gene     =BLOC(condition = "RESU_GENE != None",
             INST_INIT       =SIMP(statut='f',typ='R' ),
             CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",),),
             b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
             b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                PRECISION       =SIMP(statut='o',typ='R',),),
           ),
           DEPL_INIT_GENE  =SIMP(statut='f',typ=vect_asse_gene ),
           VITE_INIT_GENE  =SIMP(statut='f',typ=vect_asse_gene ),
         ),
         INCREMENT       =FACT(statut='o',max='**',
           INST_INIT       =SIMP(statut='f',typ='R' ),
           INST_FIN        =SIMP(statut='o',typ='R' ),
           PAS             =SIMP(statut='f',typ='R' ),
           VERI_PAS        =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           VITE_MIN        =SIMP(statut='f',typ='TXM',defaut="NORM",into=("MAXI","NORM") ),
           COEF_MULT_PAS   =SIMP(statut='f',typ='R',defaut= 1.1 ),
           COEF_DIVI_PAS   =SIMP(statut='f',typ='R',defaut= 1.3333334 ),
           PAS_LIMI_RELA   =SIMP(statut='f',typ='R',defaut= 1.0E-6 ),
           NB_POIN_PERIODE =SIMP(statut='f',typ='I',defaut= 50 ),
           NMAX_ITER_PAS   =SIMP(statut='f',typ='I',defaut= 16 ),
         ),
         ARCHIVAGE       =FACT(statut='f',
           regles=(UN_PARMI('LIST_ARCH','PAS_ARCH'),),
           LIST_ARCH       =SIMP(statut='f',typ=listis_sdaster ),
           PAS_ARCH        =SIMP(statut='f',typ='I' ),
         ),

         NMAX_ITER       =SIMP(statut='f',typ='I',defaut= 20 ),
         RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.0E-3 ),
         LAMBDA          =SIMP(statut='f',typ='R',defaut= 10. ),

         EXCIT           =FACT(statut='f',max='**',
           regles=(UN_PARMI('FONC_MULT','COEF_MULT','ACCE'),
                   PRESENT_PRESENT('ACCE','VITE','DEPL'),
                   PRESENT_PRESENT('D_FONC_DT','D_FONC_DT2'),
                   PRESENT_ABSENT('NUME_ORDRE','VECT_GENE','COEF_MULT'),
                   EXCLUS('MULT_APPUI','CORR_STAT'),
                   PRESENT_ABSENT('MULT_APPUI','COEF_MULT'),
                   PRESENT_ABSENT('MULT_APPUI','FONC_MULT'),),
           VECT_GENE       =SIMP(statut='f',typ=vect_asse_gene ),
           NUME_ORDRE      =SIMP(statut='f',typ='I' ),
           FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           COEF_MULT       =SIMP(statut='f',typ='R' ),
           ACCE            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VITE            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DEPL            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MULT_APPUI      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           DIRECTION       =SIMP(statut='f',typ='R',max='**'),
           b_loca          =BLOC(condition= "DIRECTION != None",
             regles=(EXCLUS('NOEUD','GROUP_NO'),),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           ),
           CORR_STAT       =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           D_FONC_DT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           D_FONC_DT2      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),
         CHOC            =FACT(statut='f',max='**',
           regles=(UN_PARMI('MAILLE','GROUP_MA','NOEUD_1','GROUP_NO_1' ),
                   EXCLUS('NOEUD_2','GROUP_NO_2'),
                   PRESENT_ABSENT('GROUP_MA','NOEUD_2','GROUP_NO_2'),
                   PRESENT_ABSENT('MAILLE','NOEUD_2','GROUP_NO_2'),),
           INTITULE        =SIMP(statut='f',typ='TXM' ),
           GROUP_MA        =SIMP(statut='f',typ=grma,max='**'),
           MAILLE          =SIMP(statut='f',typ=ma,max='**'),
           NOEUD_1         =SIMP(statut='f',typ=no),
           NOEUD_2         =SIMP(statut='f',typ=no),
           GROUP_NO_1      =SIMP(statut='f',typ=grno),
           GROUP_NO_2      =SIMP(statut='f',typ=grno),
           OBSTACLE        =SIMP(statut='o',typ=table_fonction),
           ORIG_OBST       =SIMP(statut='f',typ='R',min=3,max=3),
           NORM_OBST       =SIMP(statut='o',typ='R',min=3,max=3),
           ANGL_VRIL       =SIMP(statut='f',typ='R' ),
           JEU             =SIMP(statut='f',typ='R',defaut= 1. ),
           DIST_1          =SIMP(statut='f',typ='R',val_min=0.E+0 ),
           DIST_2          =SIMP(statut='f',typ='R',val_min=0.E+0 ),
           SOUS_STRUC_1    =SIMP(statut='f',typ='TXM' ),
           SOUS_STRUC_2    =SIMP(statut='f',typ='TXM' ),
           REPERE          =SIMP(statut='f',typ='TXM',defaut="GLOBAL"),
           RIGI_NOR        =SIMP(statut='f',typ='R' ),
           AMOR_NOR        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           RIGI_TAN        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           AMOR_TAN        =SIMP(statut='f',typ='R' ),
           COULOMB         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),

           LAME_FLUIDE     =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
           b_lame          =BLOC(condition="LAME_FLUIDE=='OUI'",
               ALPHA           =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
               BETA            =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
               CHI             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
               DELTA           =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
         ),
         VERI_CHOC       =FACT(statut='f',max='**',
           STOP_CRITERE    =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           SEUIL           =SIMP(statut='f',typ='R',defaut= 0.5 ),
         ),
         FLAMBAGE        =FACT(statut='f',max='**',
           regles=(UN_PARMI('NOEUD_1','GROUP_NO_1'),
                   EXCLUS('NOEUD_2','GROUP_NO_2'),),
           NOEUD_1         =SIMP(statut='f',typ=no),
           NOEUD_2         =SIMP(statut='f',typ=no),
           GROUP_NO_1      =SIMP(statut='f',typ=grno),
           GROUP_NO_2      =SIMP(statut='f',typ=grno),
           OBSTACLE        =SIMP(statut='o',typ=table_fonction),
           ORIG_OBST       =SIMP(statut='f',typ='R',max='**'),
           NORM_OBST       =SIMP(statut='o',typ='R',max='**'),
           ANGL_VRIL       =SIMP(statut='f',typ='R' ),
           JEU             =SIMP(statut='f',typ='R',defaut= 1. ),
           DIST_1          =SIMP(statut='f',typ='R' ),
           DIST_2          =SIMP(statut='f',typ='R' ),
           REPERE          =SIMP(statut='f',typ='TXM',defaut="GLOBAL"),
           RIGI_NOR        =SIMP(statut='f',typ='R' ),
           FNOR_CRIT       =SIMP(statut='f',typ='R' ),
           FNOR_POST_FL    =SIMP(statut='f',typ='R' ),
           RIGI_NOR_POST_FL=SIMP(statut='f',typ='R' ),
         ),
         ANTI_SISM       =FACT(statut='f',max='**',
           regles=(UN_PARMI('NOEUD_1','GROUP_NO_1'),
                   UN_PARMI('NOEUD_2','GROUP_NO_2'),),
           NOEUD_1         =SIMP(statut='f',typ=no),
           NOEUD_2         =SIMP(statut='f',typ=no),
           GROUP_NO_1      =SIMP(statut='f',typ=grno),
           GROUP_NO_2      =SIMP(statut='f',typ=grno),
           RIGI_K1         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           RIGI_K2         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           SEUIL_FX        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           C               =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           PUIS_ALPHA      =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           DX_MAX          =SIMP(statut='f',typ='R',defaut= 1. ),
         ),
         RELA_EFFO_DEPL  =FACT(statut='f',max='**',
           NOEUD           =SIMP(statut='o',typ=no),
           SOUS_STRUC      =SIMP(statut='f',typ='TXM' ),
           NOM_CMP         =SIMP(statut='f',typ='TXM' ),
           RELATION        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),
         RELA_TRANSIS    =FACT(statut='f',max='**',
           NOEUD           =SIMP(statut='o',typ=no),
           SOUS_STRUC      =SIMP(statut='f',typ='TXM' ),
           NOM_CMP         =SIMP(statut='f',typ='TXM' ),
           RELATION        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),
         RELA_EFFO_VITE  =FACT(statut='f',max='**',
           NOEUD           =SIMP(statut='o',typ=no),
           SOUS_STRUC      =SIMP(statut='f',typ='TXM' ),
           NOM_CMP         =SIMP(statut='f',typ='TXM' ),
           RELATION        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),
         b_itmi          =BLOC(condition = "METHODE=='ITMI'",
                regles=(ENSEMBLE('BASE_ELAS_FLUI','NUME_VITE_FLUI'),),
                BASE_ELAS_FLUI  =SIMP(statut='f',typ=melasflu_sdaster ),
                NUME_VITE_FLUI  =SIMP(statut='f',typ='I' ),
                ETAT_STAT       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
                PREC_DUREE      =SIMP(statut='f',typ='R',defaut= 1.E-2 ),
                CHOC_FLUI       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
                NB_MODE         =SIMP(statut='f',typ='I' ),
                NB_MODE_FLUI    =SIMP(statut='f',typ='I' ),
                TS_REG_ETAB     =SIMP(statut='f',typ='R' ),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
         IMPRESSION      =FACT(statut='f',max='**',
           regles=(EXCLUS('TOUT','NIVEAU'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           NIVEAU          =SIMP(statut='f',typ='TXM',into=("DEPL_LOC","VITE_LOC","FORC_LOC","TAUX_CHOC") ),
           INST_INIT       =SIMP(statut='f',typ='R' ),
           INST_FIN        =SIMP(statut='f',typ='R' ),
         ),


         SOLVEUR         =FACT(statut='d', fr="Mthode de rsolution des systmes linaires",
         METHODE         =SIMP(statut='f',typ='TXM',defaut="LDLT",into=("LDLT","MUMPS","MULT_FRONT",) ),


           b_ldlt          =BLOC(condition = "METHODE == 'LDLT' ",fr="Paramtres de la mthode LDLT",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("RCMK","SANS") ),
             NPREC           =SIMP(statut='f',typ='I',defaut=8),
             STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           ),

           b_mult_front    =BLOC(condition = "METHODE == 'MULT_FRONT' ",fr="Paramtres de la mthode multi frontale",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="METIS",into=("MD","MDA","METIS") ),
             NPREC           =SIMP(statut='f',typ='I',defaut=8),
             STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           ),


           b_mumps        =BLOC(condition = "METHODE == 'MUMPS' ",fr="Paramtres de la mthode MUMPS",
             TYPE_RESOL      =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("NONSYM","SYMGEN","SYMDEF","AUTO")),
             PRETRAITEMENTS  =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO")),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("AMD","AMF","PORD","METIS","QAMD","AUTO")),
             ELIM_LAGR2      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
             PCENT_PIVOT     =SIMP(statut='f',typ='I',defaut=10,),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut=-1.0,),
             PARALLELISME    =SIMP(statut='f',typ='TXM',defaut="CENTRALISE",
                                   into=("CENTRALISE","DISTRIBUE_MC","DISTRIBUE_MD","DISTRIBUE_SD")),
             PARTITION       =SIMP(statut='f',typ=sd_feti_sdaster),
             CHARGE_PROC0_MA =SIMP(statut='f',typ='I',defaut=100,val_min=0),
             CHARGE_PROC0_SD =SIMP(statut='f',typ='I',defaut=0,val_min=0),
             OUT_OF_CORE     =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
             ),
         ),


         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
 )  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
ENGENDRE_TEST=PROC(nom="ENGENDRE_TEST",op=178,
                   UIinfo={"groupes":("Impression",)},
                   fr="Engendre des tests pour la non rgression du code (pour dveloppeurs)",
         UNITE           =SIMP(statut='f',typ='I',defaut=8),
         FORMAT          =SIMP(statut='f',typ='TXM',into=("OBJET",) ),
         FORMAT_R        =SIMP(statut='f',typ='TXM',defaut="1PE20.13"),
         PREC_R          =SIMP(statut='f',typ='TXM',defaut="1.E-10"),
#============================================================================
         b_aster     =BLOC( condition = "FORMAT==None",
            CO              =SIMP(statut='o',typ=(cham_gd_sdaster,resultat_sdaster,table_sdaster),
                                  validators=NoRepeat(),max='**'),
            TYPE_TEST       =SIMP(statut='f',typ='TXM',defaut="SOMM_ABS",into=("SOMM","SOMM_ABS","MAX","MIN") ),
         ),
#============================================================================
         b_objet     =BLOC( condition = "FORMAT=='OBJET'",
                            regles=(UN_PARMI('TOUT','CO'),),
            TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
            CO              =SIMP(statut='f',typ=assd,validators=NoRepeat(),max='**'),
            TYPE_TEST       =SIMP(statut='f',typ='TXM',defaut="SOMME",into=("SOMME",) ),
         ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE

from Macro.exec_logiciel_ops import exec_logiciel_ops
def exec_logiciel_prod(self, MAILLAGE, **args):
   if MAILLAGE != None:
      mcf = MAILLAGE[0]
      self.type_sdprod(mcf['MAILLAGE'], maillage_sdaster)
   return None

EXEC_LOGICIEL = MACRO(nom="EXEC_LOGICIEL",op=exec_logiciel_ops, sd_prod=exec_logiciel_prod,
                      fr="Excute un logiciel ou une commande systme depuis Aster",
                      UIinfo={"groupes":("Outils mtier",)},
      
      regles = (AU_MOINS_UN('LOGICIEL', 'MAILLAGE'),),
      
      LOGICIEL = SIMP(statut='f', typ='TXM'),
      ARGUMENT = SIMP(statut='f', max='**', typ='TXM'),

      MAILLAGE = FACT(statut='f',
         FORMAT     = SIMP(statut='o', typ='TXM', into=("GMSH", "GIBI", "SALOME")),
         UNITE_GEOM = SIMP(statut='f', typ='I', val_min=10, val_max=90, defaut=16,
                           fr="Unit logique dfinissant le fichier (fort.N) contenant les donnes gomtriques (datg)"),
         UNITE      = SIMP(statut='f', typ='I', val_min=10, val_max=90, defaut=19,
                           fr="Unit logique dfinissant le fichier (fort.N) produit par le mailleur"),
         MAILLAGE   = SIMP(statut='o', typ=CO),
      ),

      CODE_RETOUR_MAXI = SIMP(statut='f', typ='I', defaut=0, val_min=-1,
                              fr="Valeur maximale du code retour tolr (-1 pour l'ignorer)"),
      
      INFO     = SIMP(statut='f', typ='I', defaut=2, into=(1,2),),
)
#& MODIF COMMANDE  DATE 05/05/2008   AUTEUR NISTOR I.NISTOR 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE NISTOR I.NISTOR

def extr_mode_prod(FILTRE_MODE,**args):
  vale=FILTRE_MODE[0]['MODE']
  if AsType(vale) == mode_meca   : return mode_meca
  if AsType(vale) == mode_meca_c : return mode_meca_c
  if AsType(vale) == mode_gene   : return mode_gene
  raise AsException("type de concept resultat non prevu")

EXTR_MODE=OPER(nom="EXTR_MODE",op= 168,sd_prod=extr_mode_prod,
               reentrant='n',fr="Extraire slctivement des modes des structures de donnes modales",
            UIinfo={"groupes":("Rsolution",)},
         FILTRE_MODE     =FACT(statut='o',max='**',
           regles=(UN_PARMI('TOUT_ORDRE','NUME_ORDRE','NUME_MODE','NUME_MODE_EXCLU','FREQ_MIN','CRIT_EXTR',),),
           MODE            =SIMP(statut='o',typ=(mode_meca,mode_meca_c,mode_gene ) ),
           TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI","NON") ),
           NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
           NUME_MODE       =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
           NUME_MODE_EXCLU =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
           FREQ_MIN        =SIMP(statut='f',typ='R' ),
           CRIT_EXTR       =SIMP(statut='f',typ='TXM',into=("MASS_EFFE_UN","MASS_GENE") ),
           b_freq_min      =BLOC(condition = "FREQ_MIN != None",  
             FREQ_MAX        =SIMP(statut='o',typ='R' ),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-3 ),
           ),
           b_crit_extr     =BLOC(condition = "CRIT_EXTR != None",
             regles=(AU_MOINS_UN('SEUIL','SEUIL_X','SEUIL_Y','SEUIL_Z'),),
             SEUIL           =SIMP(statut='f',typ='R'),
             SEUIL_X         =SIMP(statut='f',typ='R'),
             SEUIL_Y         =SIMP(statut='f',typ='R'),
             SEUIL_Z         =SIMP(statut='f',typ='R'),
           ),    
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         IMPRESSION      =FACT(statut='f',
           CUMUL           =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
           CRIT_EXTR       =SIMP(statut='f',typ='TXM',defaut="MASS_EFFE_UN",into=("MASS_EFFE_UN","MASS_GENE") ),
         ),
)  ;
#& MODIF COMMANDE  DATE 30/09/2008   AUTEUR REZETTE C.REZETTE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE

def extr_resu_prod(RESULTAT,**args):
  if AsType(RESULTAT) == evol_elas    : return evol_elas
  if AsType(RESULTAT) == evol_noli    : return evol_noli
  if AsType(RESULTAT) == evol_ther    : return evol_ther
  if AsType(RESULTAT) == dyna_trans   : return dyna_trans
  if AsType(RESULTAT) == dyna_harmo   : return dyna_harmo
  if AsType(RESULTAT) == acou_harmo   : return acou_harmo
  if AsType(RESULTAT) == mode_meca    : return mode_meca
  if AsType(RESULTAT) == mode_acou    : return mode_acou
  if AsType(RESULTAT) == mode_stat_depl :    return mode_stat_depl
  if AsType(RESULTAT) == mode_stat_acce :    return mode_stat_acce
  if AsType(RESULTAT) == mode_stat_forc :    return mode_stat_forc
  if AsType(RESULTAT) == mult_elas    : return mult_elas
  if AsType(RESULTAT) == fourier_elas : return fourier_elas
  raise AsException("type de concept resultat non prevu")

EXTR_RESU=OPER(nom="EXTR_RESU",op=176,sd_prod=extr_resu_prod,reentrant='f',
            UIinfo={"groupes":("Rsultats et champs",)},
            fr="Extraire des champs au sein d'une SD Rsultat",
         regles=(CONCEPT_SENSIBLE('SEPARE'), 
                 #REUSE_SENSIBLE(),
                 DERIVABLE('RESULTAT'),),
         RESULTAT        =SIMP(statut='o',typ=(evol_elas,dyna_trans,dyna_harmo,acou_harmo,mode_meca,
                                               mode_acou,mode_stat_depl,mode_stat_acce,mode_stat_forc,evol_ther,evol_noli,
                                               mult_elas,fourier_elas,fourier_ther ) ),

         SENSIBILITE     =SIMP(statut='f',typ=(para_sensi,theta_geom),validators=NoRepeat(),max='**',
                                   fr="Liste des paramtres de sensibilit.",
                                   ang="List of sensitivity parameters"),

         ARCHIVAGE       =FACT(statut='f',
           regles=(  UN_PARMI('NUME_ORDRE', 'INST', 'FREQ', 'NUME_MODE',
                        'NOEUD_CMP', 'LIST_INST', 'LIST_FREQ', 'LIST_ORDRE',
                        'NOM_CAS', 'LIST_ARCH', 'PAS_ARCH' ),
                     EXCLUS( 'CHAM_EXCLU','NOM_CHAM' ),   ),
           CHAM_EXCLU      =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**'),
           NOM_CHAM        =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',into=C_NOM_CHAM_INTO()),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",),),
           b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
              PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
           b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
              PRECISION       =SIMP(statut='o',typ='R',),),
           LIST_ARCH       =SIMP(statut='f',typ=listis_sdaster),
           PAS_ARCH        =SIMP(statut='f',typ='I'),
           NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
           LIST_ORDRE      =SIMP(statut='f',typ=listis_sdaster),
           INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
           LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
           FREQ            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
           LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster),
           NUME_MODE       =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
           NOEUD_CMP       =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**'),
           NOM_CAS         =SIMP(statut='f',typ='TXM'),
                               ),

         TITRE           =SIMP(statut='f',typ='TXM',max='**' ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS

def extr_table_prod(TYPE_RESU,**args):
  from Cata import cata
  typ = TYPE_RESU.lower()
  if hasattr(cata, typ):
     return getattr(cata, typ)
  raise AsException("type de concept resultat non prevu")

EXTR_TABLE=OPER(nom="EXTR_TABLE",op=173,sd_prod=extr_table_prod,reentrant='n',
            UIinfo={"groupes":("Rsultats et champs",)},
         fr="Extraire d'une table des concepts Code_Aster",
         TYPE_RESU       =SIMP(statut='o',typ='TXM',),

         TABLE           =SIMP(statut='o',typ=(table_sdaster,table_container)),

         NOM_PARA        =SIMP(statut='o',typ='TXM'),

         FILTRE          =FACT(statut='f',min=1,max='**',
           NOM_PARA        =SIMP(statut='o',typ='TXM'),
           CRIT_COMP       =SIMP(statut='f',typ='TXM',defaut="EQ",
                                 into=("EQ","LT","GT","NE","LE","GE","VIDE",
                                       "NON_VIDE","MAXI","ABS_MAXI","MINI","ABS_MINI") ),
           b_vale          =BLOC(condition = "(CRIT_COMP in ('EQ','NE','GT','LT','GE','LE'))",
              regles=(UN_PARMI('VALE','VALE_I','VALE_K','VALE_C',),),
              VALE            =SIMP(statut='f',typ='R'),
              VALE_I          =SIMP(statut='f',typ='I'),
              VALE_C          =SIMP(statut='f',typ='C'),
              VALE_K          =SIMP(statut='f',typ='TXM'),),

           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
           PRECISION       =SIMP(statut='f',typ='R',defaut= 1.0E-3 ),
         ),

         TITRE           =SIMP(statut='f',typ='TXM',max='**' ),  
)  ;
#& MODIF COMMANDE  DATE 30/09/2008   AUTEUR REZETTE C.REZETTE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2007  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE PELLET J.PELLET

def factoriser_prod(MATR_ASSE,**args):
  if AsType(MATR_ASSE) == matr_asse_depl_r : return matr_asse_depl_r
  if AsType(MATR_ASSE) == matr_asse_depl_c : return matr_asse_depl_c
  if AsType(MATR_ASSE) == matr_asse_temp_r : return matr_asse_temp_r
  if AsType(MATR_ASSE) == matr_asse_temp_c : return matr_asse_temp_c
  if AsType(MATR_ASSE) == matr_asse_pres_r : return matr_asse_pres_r
  if AsType(MATR_ASSE) == matr_asse_pres_c : return matr_asse_pres_c
  raise AsException("type de concept resultat non prevu")

FACTORISER=OPER(nom="FACTORISER",op=14,sd_prod=factoriser_prod,
               fr="Factoriser une matrice assemble en un produit de deux matrices triangulaires"+
                  "ou construire une matrice de prconditionnement pour une rsolution par gradient conjugu",
               reentrant='f', UIinfo={"groupes":("Rsolution",)},
         regles=(EXCLUS('BLOC_DEBUT','DDL_DEBUT'),
                 EXCLUS('BLOC_FIN','DDL_FIN'),),
         MATR_ASSE       =SIMP(statut='o',typ=(matr_asse_depl_r,matr_asse_depl_c,matr_asse_temp_r,
                                               matr_asse_temp_c,matr_asse_pres_r,matr_asse_pres_c) ),

         # mots cls pour solveur LDLT et MULT_FRONT:
         STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         NPREC           =SIMP(statut='f',typ='I',defaut=8,val_min=0,),

         # mots cls pour solveur LDLT :
         BLOC_DEBUT      =SIMP(statut='f',typ='I',val_min=1,),
         DDL_DEBUT       =SIMP(statut='f',typ='I',val_min=1,),
         BLOC_FIN        =SIMP(statut='f',typ='I',val_min=1,),
         DDL_FIN         =SIMP(statut='f',typ='I',val_min=1,),

         # mots cls pour solveur MUMPS :
         TYPE_RESOL      =SIMP(statut='f',typ='TXM',defaut='AUTO',into=('NONSYM','SYMGEN','SYMDEF','AUTO')),
         PRETRAITEMENTS  =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO")),
         PCENT_PIVOT     =SIMP(statut='f',typ='I',defaut=10,),
         ELIM_LAGR2      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
         OUT_OF_CORE  =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
         
         # mots cls pour solveur GCPC et PETSc :
         PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC","JACOBI","SOR"),defaut="LDLT_INC" ),
         b_petsc_ilu     =BLOC(condition = "PRE_COND == 'LDLT_INC' ",
           NIVE_REMPLISSAGE = SIMP(statut='f',typ='I',defaut= 0 ),
           REMPLISSAGE      = SIMP(statut='f',typ='R',defaut= 1.0),
         ),

         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 05/08/2009   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE
FIN=PROC(nom="FIN",op=9999,repetable='n',fr="Fin d'une tude, fin du travail engag par une des commandes DEBUT ou POURSUITE",
            UIinfo={"groupes":("Gestion du travail",)},
#
# FIN est appel prmaturment en cas d'exception ("SIGUSR1", ArretCPUError,
# NonConvergenceError..., erreurs <S> ou erreurs <F> rcupres).
# En cas d'ArretCPUError, on limite au maximum le travail  faire dans FIN.
# Pour cela, on force certains mots-cls dans Execution/E_JDC.py.
# 
         FORMAT_HDF      =SIMP(fr="sauvegarde de la base GLOBALE au format HDF",statut='f',
                               typ='TXM',defaut="NON",into=("OUI","NON",) ), 
         RETASSAGE       =SIMP(fr="provoque le retassage de la base GLOBALE",
                               statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ),
         PERFORMANCE     =SIMP(fr="provoque l'impression d'un rsum des mesures de temps ",
                               statut='f',typ='TXM',defaut="OUI",into=("OUI","NON",) ),
         INFO_RESU       =SIMP(fr="provoque l'impression des informations sur les structures de donnes",
                               statut='f',typ='TXM',defaut="OUI",into=("OUI","NON",) ),
         UNITE           =SIMP(statut='f',typ='I',defaut=6),  
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE ADOBES A.ADOBES
FONC_FLUI_STRU=OPER(nom="FONC_FLUI_STRU",op= 169,sd_prod=fonction_sdaster,
                    reentrant='n',fr="Cre une fonction constante paramtre par l'abscisse curviligne",
            UIinfo={"groupes":("Fonction",)},
         TYPE_FLUI_STRU  =SIMP(statut='o',typ=(type_flui_stru) ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE DURAND C.DURAND
def formule_prod(self,VALE,VALE_C,**args):
   if   VALE   != None:
      return formule
   elif VALE_C != None:
      return formule_c

def form_pyth_ops(self,d):
   NOM_PARA=self.etape['NOM_PARA']
   VALE    =self.etape['VALE']
   VALE_C  =self.etape['VALE_C']
   if type(NOM_PARA) not in (list, tuple):
      NOM_PARA = [NOM_PARA,]
   if self.sd == None:
      return
   if VALE     != None :
      texte = ''.join(VALE.splitlines())
   elif VALE_C != None :
      texte = ''.join(VALE_C.splitlines())
   self.sd.setFormule(NOM_PARA, texte.strip())

FORMULE=FORM(nom="FORMULE",op_init=form_pyth_ops,op=-5,
             sd_prod=formule_prod,UIinfo={"groupes":("Fonction",)},
             fr="Dfinit une formule relle ou complexe  partir de son expression mathmatique",
         regles=(UN_PARMI('VALE','VALE_C',),),
         VALE     =SIMP(statut='f',typ='TXM'),
         VALE_C   =SIMP(statut='f',typ='TXM'),
         NOM_PARA =SIMP(statut='o',typ='TXM',max='**'),
);
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE ZENTNER I.ZENTNER
GENE_FONC_ALEA=OPER(nom="GENE_FONC_ALEA",op= 118,sd_prod=table_fonction,
                    fr="Gnration de la fonction temporelle  partir d une matrice interspectrale",
                    reentrant='n',
            UIinfo={"groupes":("Fonction",)},
         INTE_SPEC       =SIMP(statut='o',typ=table_fonction),
         NUME_VITE_FLUI  =SIMP(statut='f',typ='I' ),
         INTERPOL        =SIMP(statut='f',typ='TXM',defaut="OUI",into=("NON","OUI") ),
         b_interpol_oui    =BLOC(condition = "INTERPOL == 'OUI' ",fr="Parametres cas interpolation autorisee",
           DUREE_TIRAGE    =SIMP(statut='f',typ='R' ),
           FREQ_INIT       =SIMP(statut='f',typ='R' ),
           FREQ_FIN        =SIMP(statut='f',typ='R' ),
             ),
         NB_POIN         =SIMP(statut='f',typ='I'),
         NB_TIRAGE       =SIMP(statut='f',typ='I',defaut= 1 ),
         INIT_ALEA       =SIMP(statut='f',typ='I'),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2002  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ZENTNER I.ZENTNER
def gene_matr_alea_prod(MATR_MOYEN,**args ):
  if (AsType(MATR_MOYEN) == matr_asse_gene_r )  : return matr_asse_gene_r
  if (AsType(MATR_MOYEN) == macr_elem_dyna) : return macr_elem_dyna
  raise AsException("type de concept resultat non prevu")

GENE_MATR_ALEA=OPER(nom="GENE_MATR_ALEA",op=  27,
#sd_prod=matr_asse_gene_r,
sd_prod=gene_matr_alea_prod,
               fr="Gnrer une ralisation d'une matrice alatoire relle sym. df. positive ou d'un macro lment dynamique",
               reentrant='n',
            UIinfo={"groupes":("Matrice",)},
   MATR_MOYEN   = SIMP(statut='o', typ=(matr_asse_gene_r,macr_elem_dyna)),

#    cas matrice generalisee 
   b_matr =BLOC( condition = "AsType(MATR_MOYEN) in (matr_asse_gene_r,)",
           COEF_VAR     = SIMP(statut='f', typ='R', defaut=0.1, val_min=0.E+0 ,
                                fr="coefficient de variation de la matrice a generer" ),
           ),
#    cas macr_elem_dyna 
   b_macr =BLOC( condition = "AsType(MATR_MOYEN) in (macr_elem_dyna,)",
           fr="cas macr_elem_dyna (sous-structuratio)",
           COEF_VAR_RIGI     = SIMP(statut='f', typ='R', defaut=0.1, val_min=0.E+0 ,
                                fr="coefficient de variation de la matrice de raideur" ),
           COEF_VAR_MASS     = SIMP(statut='f', typ='R', defaut=0., val_min=0.E+0 ,
                                fr="coefficient de variation de la matrice de masse" ),
           COEF_VAR_AMOR     = SIMP(statut='f', typ='R', defaut=0., val_min=0.E+0 ,
                                fr="coefficient de variation de la matrice d'amortissement" ),),

   INIT_ALEA    =SIMP(statut='f',typ='I'),
) ;
   
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2002  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ZENTNER I.ZENTNER
from Macro.gene_vari_alea_ops import gene_vari_alea_ops,gene_vari_alea_init
GENE_VARI_ALEA=MACRO(nom="GENE_VARI_ALEA",
               op_init=gene_vari_alea_init,op=gene_vari_alea_ops,
               sd_prod=reel,reentrant='n',
               fr="Gnrer une ralisation d'une variable alatoire relle de loi de probabilit donne (Gamma ou Exponentielle)",
               UIinfo={"groupes":("Fonction",)},
   TYPE       = SIMP(statut='f', typ='TXM', into=("EXP_TRONQUEE", "EXPONENTIELLE", "GAMMA"), defaut="GAMMA"),
   b_gamma    =BLOC(condition = "TYPE == 'GAMMA' ",fr="Parametres loi gamma",
           VALE_MOY   = SIMP(statut='f', typ='R', defaut=1.),
           BORNE_INF  = SIMP(statut='f', typ='R', defaut=0.),
           COEF_VAR   = SIMP(statut='f', typ='R', defaut=0.1),
             ),
   b_expo    =BLOC(condition = "TYPE == 'EXPONENTIELLE' ",fr="Parametres loi exponentielle",
           VALE_MOY   = SIMP(statut='f', typ='R', defaut=0.),
           BORNE_INF  = SIMP(statut='f', typ='R', defaut=-1.),
             ),
   b_expo_tronq    =BLOC(condition = "TYPE == 'EXP_TRONQUEE' ",fr="Parametres loi exponentielle tronquee",
           VALE_MOY   = SIMP(statut='f', typ='R', defaut=0.),
           BORNE_INF  = SIMP(statut='f', typ='R', defaut=-1.),
           BORNE_SUP  = SIMP(statut='f', typ='R', defaut=1.),
             ),
   INIT_ALEA       =SIMP(statut='f',typ='I'),
)
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE
IMPR_CO=PROC(nom="IMPR_CO",op=17,
            UIinfo={"groupes":("Impression",)},
             fr="Imprimer tous les objets JEVEUX qui constituent un concept utilisateur existant (pour les dveloppeurs)",
         regles=(UN_PARMI('CONCEPT','CHAINE','TOUT' ),),

         UNITE           =SIMP(statut='f',typ='I',defaut=8),
         NIVEAU          =SIMP(statut='f',typ='I',defaut=2,into=(-1,0,1,2) ),
         ATTRIBUT        =SIMP(statut='f',typ='TXM',defaut="NON",into=("NON","OUI") ),
         CONTENU         =SIMP(statut='f',typ='TXM',defaut="OUI",into=("NON","OUI") ),
         BASE            =SIMP(statut='f',typ='TXM',defaut="G",into=(" ","G","V","L") ),
         CONCEPT    =FACT(statut='f',max='**',
             regles=(DERIVABLE('NOM'),),
             NOM         =SIMP(statut='o',typ=assd,validators=NoRepeat(),max='**'),
             SENSIBILITE =SIMP(statut='f',typ=(para_sensi,theta_geom),validators=NoRepeat(),
                                 fr="Paramtre de sensibilit.",
                                 ang="Sensitivity parameter",max='**'),),        
         CHAINE          =SIMP(statut='f',typ='TXM'),
         POSITION        =SIMP(statut='f',typ='I',defaut=1),
         TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
)  ;
#& MODIF COMMANDE  DATE 06/05/2008   AUTEUR CNGUYEN C.NGUYEN 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2004  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS
from Macro.impr_fonction_ops import impr_fonction_ops

IMPR_FONCTION=MACRO(nom="IMPR_FONCTION",op=impr_fonction_ops,sd_prod=None,
                 fr="Imprime le contenu d'objets de type fonction ou liste de rels dans un fichier destin  un traceur de courbe",
            UIinfo={"groupes":("Fonction",)},
         FORMAT          =SIMP(statut='o',typ='TXM',position='global',defaut='TABLEAU',
                               into=("TABLEAU","AGRAF","XMGRACE",),),
         b_pilote = BLOC(condition = "FORMAT == 'XMGRACE'",
                        fr="Mots-cls propres  XMGRACE",
           PILOTE          =SIMP(statut='f',typ='TXM',defaut='',
                                 into=('','POSTSCRIPT','EPS','MIF','SVG','PNM','PNG','JPEG','PDF','INTERACTIF'),
                            fr="Pilote de sortie, PNG/JPEG/PDF ne sont pas disponibles sur toutes les installations de xmgrace"),
           UNITE           =SIMP(statut='f',typ='I',val_min=10,val_max=90,defaut=29,
                                 fr="Unit logique dfinissant le fichier (fort.N) dans lequel on crit"),
         ),
         b_agraf = BLOC(condition = "FORMAT == 'AGRAF'",
                        fr="Mots-cls propres  AGRAF",
           UNITE           =SIMP(statut='o',typ='I',defaut=25,
                                 fr="Unit logique dfinissant le fichier (fort.N) dans lequel on crit"),
           UNITE_DIGR      =SIMP(statut='o',typ='I',defaut=26,
                                 fr="Unit logique dfinissant le fichier dans lequel on crit les directives Agraf"),
         ),
         # unite pour TABLEAU dans le bloc de mise en forme spcifique

         COURBE          =FACT(statut='o',max='**',fr="Dfinition de la fonction  tracer",
           regles=(UN_PARMI('FONCTION','LIST_RESU','FONC_X','ABSCISSE'),),
           FONCTION        =SIMP(statut='f',typ=(fonction_sdaster, formule, fonction_c, nappe_sdaster),
                                 fr="Fonction relle ou complexe", ),
           LIST_RESU       =SIMP(statut='f',typ=listr8_sdaster,
                                 fr="Liste des ordonnees d'une fonction relle dfinie par deux listes", ),
           FONC_X          =SIMP(statut='f',typ=(fonction_sdaster,formule),
                                 fr="Fonction abscisses d'une fonction paramtrique",),
           ABSCISSE        =SIMP(statut='f',typ='R',max='**',
                                 fr="Valeurs des abscisses", ),
           b_fonction      =BLOC(condition = "FONCTION != None",
             LIST_PARA       =SIMP(statut='f',typ=listr8_sdaster ),
           ),
           b_fonction_c  =BLOC(condition = "AsType(FONCTION) in (fonction_c, formule_c)",
                                 fr="Fonction complexe dfinie par le mot-cl fonction",
             PARTIE          =SIMP(statut='f',typ='TXM',into=("REEL","IMAG") ),
           ),
           b_list_resu     =BLOC(condition = "LIST_RESU != None",
             LIST_PARA       =SIMP(statut='o',typ=listr8_sdaster ),
           ),
           b_fonc_x        =BLOC(condition = "FONC_X != None",
             FONC_Y          =SIMP(statut='o',typ=(fonction_sdaster,formule),fr="Fonction ordonnes d une fonction paramtrique" ),
             LIST_PARA       =SIMP(statut='f',typ=listr8_sdaster ),
           ),
           b_vale_resu     =BLOC(condition = "ABSCISSE != None",
             ORDONNEE      =SIMP(statut='o',typ='R',max='**',
                                 fr="Valeurs des ordonnes"),
           ),

           # mots-cls utilisant uniquement aux formats autres que TABLEAU
           # mais ce serait trop pnible de devoir les supprimer quand on change de format
           # donc on ne les met pas dans un bloc
           # "pseudo" bloc mise en forme :
               LEGENDE         =SIMP(statut='f',typ='TXM',
                                    fr="Lgende associe  la fonction" ),
               STYLE           =SIMP(statut='f',typ='I',val_min=0,
                                    fr="Style de la ligne reprsentant la fonction",),
               COULEUR         =SIMP(statut='f',typ='I',val_min=0,
                                    fr="Couleur associe  la fonction",),
               MARQUEUR        =SIMP(statut='f',typ='I',val_min=0,
                                    fr="Type du marqueur associ  la fonction",),
               FREQ_MARQUEUR   =SIMP(statut='f',typ='I',defaut=0,
                                    fr="Frquence d impression du marqueur associ  la fonction", ),
           # fin bloc mise en forme
           
           TRI             =SIMP(statut='f',typ='TXM',defaut="N",
                                 fr="Choix du tri effectu sur les abscisses ou sur les ordonnes",
                                 into=("N","X","Y","XY","YX") ),
         ),
         # Mise en page du tableau ou du graphique
         b_tableau = BLOC(condition = "FORMAT == 'TABLEAU'",
                          fr="Mots-cls propres au format Tableau",
           UNITE           =SIMP(statut='o',typ='I',defaut=8,
                                 fr="Unit logique dfinissant le fichier (fort.N) dans lequel on crit"),
           TITRE           =SIMP(statut='f',typ='TXM',
                                 fr="Titre associ au graphique" ),
           SOUS_TITRE      =SIMP(statut='f',typ='TXM',
                                 fr="Sous-titre du graphique" ),
           SEPARATEUR      =SIMP(statut='f',typ='TXM',defaut=' ',
                                 fr="Sparateur des colonnes du tableau (ex : ' ', ';'...)"),
           COMMENTAIRE     =SIMP(statut='f',typ='TXM',defaut='#',
                                 fr="Caractre indiquant au traceur de fonction que la ligne peut etre ignore"),
           COMM_PARA       =SIMP(statut='f',typ='TXM',defaut='',
                                 fr="Caractre utilis pour commentariser la ligne des labels de colonnes"),
           DEBUT_LIGNE     =SIMP(statut='f',typ='TXM',defaut='',
                                 fr="Caractre de debut de ligne"),
           FIN_LIGNE       =SIMP(statut='f',typ='TXM',defaut='\n',
                                 fr="Caractre de fin de ligne"),
         ),
         b_graphique = BLOC(condition = "FORMAT != 'TABLEAU'",
                        fr="Mise en page du graphique",
           TITRE           =SIMP(statut='f',typ='TXM',
                                 fr="Titre associ au graphique" ),
           SOUS_TITRE      =SIMP(statut='f',typ='TXM',
                                 fr="Sous-titre du graphique" ),
           BORNE_X         =SIMP(statut='f',typ='R',min=2,max=2,
                                 fr="Intervalles de variation des abscisses"),
           BORNE_Y         =SIMP(statut='f',typ='R',min=2,max=2,
                                 fr="Intervalles de variation des ordonnes"),
           ECHELLE_X       =SIMP(statut='f',typ='TXM',defaut="LIN",into=("LIN","LOG"),
                                 fr="Type d'chelle pour les abscisses" ),
           ECHELLE_Y       =SIMP(statut='f',typ='TXM',defaut="LIN",into=("LIN","LOG"),
                                 fr="Type d'chelle pour les ordonnes" ),
           GRILLE_X        =SIMP(statut='f',typ='R',max=1,val_min=0.,
                                 fr="Pas du quadrillage vertical" ),
           GRILLE_Y        =SIMP(statut='f',typ='R',max=1,val_min=0.,
                                 fr="Pas du quadrillage horizontal" ),
           LEGENDE_X       =SIMP(statut='f',typ='TXM',
                                 fr="Lgende associe  l'axe des abscisses" ),
           LEGENDE_Y       =SIMP(statut='f',typ='TXM',
                                 fr="Lgende associe  l'axe des ordonnes" ),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 30/09/2008   AUTEUR REZETTE C.REZETTE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE BOYERE E.BOYERE
IMPR_GENE=PROC(nom="IMPR_GENE",op= 157,
            fr="Imprimer le rsultat d'un calcul dynamique en variables gnralises au format RESULTAT",
            UIinfo={"groupes":("Impression",)},
         FORMAT          =SIMP(statut='f',typ='TXM',defaut="RESULTAT",into=("RESULTAT",) ),
         UNITE           =SIMP(statut='f',typ='I',defaut=8),  
         GENE            =FACT(statut='o',max='**',
           regles=(EXCLUS('TOUT_ORDRE','NUME_ORDRE','INST','FREQ','NUME_MODE',
                          'LIST_INST','LIST_FREQ','TOUT_MODE','TOUT_INST','LIST_ORDRE'),
                   EXCLUS('TOUT_MODE','NUME_ORDRE','INST','FREQ','NUME_MODE',
                          'LIST_INST','LIST_FREQ','TOUT_ORDRE','TOUT_INST','LIST_ORDRE'),
                   EXCLUS('TOUT_INST','NUME_ORDRE','INST','FREQ','NUME_MODE',
                          'LIST_INST','LIST_FREQ','TOUT_ORDRE','LIST_ORDRE'),
                   EXCLUS('TOUT_CMP_GENE','NUME_CMP_GENE'),
                   EXCLUS('TOUT_CHAM','NOM_CHAM'),
                   EXCLUS('TOUT_PARA','NOM_PARA'),),
#  faut-il faire des blocs selon le type de RESU_GENE                   
           RESU_GENE       =SIMP(statut='o',typ=(vect_asse_gene, tran_gene, mode_gene, harm_gene)),
           TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
           LIST_ORDRE      =SIMP(statut='f',typ=listis_sdaster ),
           INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
           LIST_INST       =SIMP(statut='f',typ=listr8_sdaster ),
           TOUT_INST       =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           FREQ            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
           LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster ),
           TOUT_MODE       =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           NUME_MODE       =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",),),
           b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
              PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
           b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
              PRECISION       =SIMP(statut='o',typ='R',),),
           TOUT_CMP_GENE   =SIMP(statut='f',typ='TXM',into=("OUI","NON") ),
           NUME_CMP_GENE   =SIMP(statut='f',typ='I',max='**'),
           TOUT_CHAM       =SIMP(statut='f',typ='TXM',into=("OUI","NON") ),
           NOM_CHAM        =SIMP(statut='f',typ='TXM',max='**'),
           TOUT_PARA       =SIMP(statut='f',typ='TXM',into=("OUI","NON") ),
           NOM_PARA        =SIMP(statut='f',typ='TXM',max='**'),
           SOUS_TITRE      =SIMP(statut='f',typ='TXM',max='**'),
           INFO_CMP_GENE   =SIMP(statut='f',typ='TXM',into=("OUI","NON") ),
           INFO_GENE       =SIMP(statut='f',typ='TXM',into=("OUI","NON") ),
         ),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE
IMPR_JEVEUX=PROC(nom="IMPR_JEVEUX",op=16,
            UIinfo={"groupes":("Impression",)},
                 fr="Imprimer le contenu des objets crs par JEVEUX (pour dveloppeur)",
         ENTITE          =SIMP(fr="choix de l'observation",statut='o',typ='TXM',
                               into=("DISQUE","MEMOIRE","REPERTOIRE",    
                                     "OBJET","ATTRIBUT","SYSTEME") ),
         b_objet      =BLOC(condition = "(ENTITE=='OBJET')",
            NOMOBJ          =SIMP(fr="nom d'objet",statut='f',typ='TXM' ),  
            NUMOC           =SIMP(fr="numro d objet de collection",statut='f',typ='I' ),  
            NOMOC           =SIMP(fr="nom d'objet de collection",statut='f',typ='TXM' ),  
         ),
         b_attribut   =BLOC(condition = "(ENTITE=='ATTRIBUT')",
            NOMOBJ          =SIMP(fr="nom de collection",statut='f',typ='TXM' ),  
            NOMATR          =SIMP(fr="nom d attribut de collection",statut='f',typ='TXM',
                                  into=('$$DESO','$$IADD','$$IADM','$$NOM','$$LONG',
                                      '$$LONO','$$LUTI','$$NUM') ),
         ),
         b_systeme    =BLOC(condition = "(ENTITE=='SYSTEME')",
            CLASSE          =SIMP(statut='o',typ='TXM',into=('G','V','L') ),  
            NOMATR          =SIMP(fr="nom d attribut systeme",statut='f',typ='TXM',   
                                  into=('$$CARA','$$IADD','$$GENR','$$TYPE','$$MARQ',
                                      '$$DOCU','$$ORIG','$$RNOM','$$LTYP','$$LONG',
                                      '$$LONO','$$DATE','$$LUTI','$$HCOD','$$INDX',
                                      '$$TLEC','$$TECR','$$IADM','$$ACCE','$$USADI') ),
         ),
         b_repertoire =BLOC(condition = "(ENTITE=='REPERTOIRE')",
            CLASSE          =SIMP(statut='f',typ='TXM',into=('G','V','L',' '),defaut=' '),  
         ),
         b_disque     =BLOC(condition = "(ENTITE=='DISQUE')",
            CLASSE          =SIMP(statut='f',typ='TXM' ,into=('G','V','L',' '),defaut=' '),  
         ),
         IMPRESSION      =FACT(statut='f',
           NOM             =SIMP(statut='f',typ='TXM' ),  
           UNITE           =SIMP(statut='f',typ='I'),  
         ),
         COMMENTAIRE     =SIMP(statut='f',typ='TXM' ),  
)  ;
#& MODIF COMMANDE  DATE 06/05/2008   AUTEUR CORUS M.CORUS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE CORUS M.CORUS

IMPR_MACR_ELEM=PROC(nom="IMPR_MACR_ELEM",op= 160,
                    UIinfo={"groupes":("Impression",)},
         fr="Impression d'une structure de donnes MACR_ELEM_DYNA au format IDEAS MISS3D PLEXUS ou CADYRO",
         MACR_ELEM_DYNA  =SIMP(statut='o',typ=macr_elem_dyna ),
         FORMAT          =SIMP(statut='f',typ='TXM',defaut="IDEAS",
                               into=("MISS_3D","IDEAS","CADYRO","PLEXUS") ),

         b_plexus         =BLOC(condition = "FORMAT == 'IDEAS'",
           UNITE           =SIMP(statut='f',typ='I',defaut=30),
           VERSION          =SIMP(statut='f',typ='I',defaut= 5,into=( 5 ,) ),
         ),             

         b_ideas         =BLOC(condition = "FORMAT == 'PLEXUS'",
           UNITE           =SIMP(statut='f',typ='I',defaut=30),
           VERSION         =SIMP(statut='f',typ='I',defaut= 5,into=( 5 ,) ),
         ),                      

         b_miss_3d       =BLOC(condition = "FORMAT == 'MISS_3D'",
           regles=(EXCLUS('AMOR_REDUIT','LIST_AMOR'),),
           UNITE           =SIMP(statut='f',typ='I',defaut= 26 ),
           SOUS_TITRE      =SIMP(statut='f',typ='TXM',max='**'),
           AMOR_REDUIT     =SIMP(statut='f',typ='R'  ,max='**'),
           LIST_AMOR       =SIMP(statut='f',typ=listr8_sdaster ),
           GROUP_MA_INTERF =SIMP(statut='o',typ=grma ,max='**'),
           GROUP_MA_FLU_STR=SIMP(statut='f',typ=grma,max='**'),
           GROUP_MA_FLU_SOL=SIMP(statut='f',typ=grma,max='**'),
           GROUP_MA_SOL_SOL=SIMP(statut='f',typ=grma,max='**'),
           GROUP_MA_CONTROL=SIMP(statut='f',typ=grma,max='**'),
           FORMAT_R        =SIMP(statut='f',typ='TXM',defaut="1PE12.5",into=("1PE12.5","1PE16.9") ),
           IMPR_MODE_MECA  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           IMPR_MODE_STAT  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         ),

         b_cadyro        =BLOC(condition = "FORMAT == 'CADYRO'",
           SQUELETTE       =SIMP(statut='f',typ=squelette ),
           UNITE_MODE_MECA =SIMP(statut='f',typ='I',defaut= 26 ),
           UNITE_MODE_STAT =SIMP(statut='f',typ='I',defaut= 27 ),
           UNITE_MAILLAGE  =SIMP(statut='f',typ='I',defaut= 28 ),
           IMPR_MODE_MECA  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           IMPR_MODE_STAT  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         ),

)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
IMPR_MATRICE=PROC(nom="IMPR_MATRICE",op= 159,
                  fr="Imprimer sur un fichier au format IDEAS des matrices lmentaires et assembles",
                  UIinfo={"groupes":("Impression",)},
                  regles=(AU_MOINS_UN('MATR_ELEM','MATR_ASSE'),),
# ======================================================================
   MATR_ELEM       =FACT(statut='f',max='**',
#
           MATRICE     =SIMP(statut='o',typ=(matr_elem, vect_elem)),
           FORMAT      =SIMP(statut='f',typ='TXM',defaut="IDEAS",into=("IDEAS",) ),
#
         b_format_ideas  =BLOC(condition="FORMAT=='IDEAS'",fr="unit logique d'impression et version IDEAS",
           UNITE       =SIMP(statut='f',typ='I',defaut=30),
           VERSION     =SIMP(statut='f',typ='I',defaut= 5,into=( 5 ,), ),  ),
         ),
# ======================================================================
   MATR_ASSE       =FACT(statut='f',max='**',
#
           MATRICE     =SIMP(statut='o',typ=matr_asse_gd),
           FORMAT      =SIMP(statut='f',typ='TXM',defaut="IDEAS",into=("IDEAS",) ),
#
         b_format_ideas  =BLOC(condition="FORMAT=='IDEAS'",fr="unit logique d'impression et version IDEAS",
           UNITE       =SIMP(statut='f',typ='I',defaut=30),
           VERSION     =SIMP(statut='f',typ='I',defaut= 5,into=( 5 ,), ),  ),
#
         ),
# ======================================================================
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE DEVESA G.DEVESA
IMPR_MISS_3D=PROC(nom="IMPR_MISS_3D",op= 162,
            UIinfo={"groupes":("Impression",)},
         fr="Impression des donnes d'entre pour une tude sismique avec MISS3D",
         regles=(UN_PARMI('INST_INIT','FREQ_INIT'),
                 PRESENT_PRESENT('INST_INIT','INST_FIN'),
                 PRESENT_PRESENT('FREQ_INIT','FREQ_FIN'),),
         MACR_ELEM_DYNA  =SIMP(statut='o',typ=macr_elem_dyna ),
         EXCIT           =FACT(statut='f',max='**',
           regles=(UN_PARMI('FONC_MULT','COEF_MULT' ),),
           VECT_ASSE       =SIMP(statut='f',typ=cham_no_sdaster),
           FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           COEF_MULT       =SIMP(statut='f',typ='R' ),
         ),
         EXCIT_SOL       =FACT(statut='f',max='**',
           DIRECTION       =SIMP(statut='o',typ='R',min=3,max=3),
           FONC_SIGNAL     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           NOM_CHAM        =SIMP(statut='f',typ='TXM',defaut="DEPL",
                                 into=("DEPL","VITE","ACCE","FORC",) ),
         ),
         INST_INIT       =SIMP(statut='f',typ='R' ),
         INST_FIN        =SIMP(statut='f',typ='R' ),
         FREQ_INIT       =SIMP(statut='f',typ='R' ),
         FREQ_FIN        =SIMP(statut='f',typ='R' ),
         PAS             =SIMP(statut='o',typ='R' ),
         UNITE           =SIMP(statut='f',typ='I',defaut= 26 ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2 ) ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 21/04/2008   AUTEUR LEFEBVRE J-P.LEFEBVRE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2004  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE THOMASSON D.THOMASSON
#
from Macro.impr_oar_ops import impr_oar_ops
IMPR_OAR =MACRO(nom="IMPR_OAR",op= impr_oar_ops, sd_prod=None,
               fr="Impression au format OAR",
               UIinfo={"groupes":("Impression",)},
   TYPE_CALC = SIMP(statut='o', typ='TXM',into=('COMPOSANT', 'MEF', 'TUYAUTERIE')),
   b_composant =BLOC(