#& MODIF ENTETE  DATE 08/03/2011   AUTEUR MASSIN P.MASSIN 
# -*- coding: iso-8859-1 -*-
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS

# faire que la division soit toujours relle
from __future__ import division

import Accas
from Accas import *
from Accas import _F
from math import sin, cos, tan, asin, acos, atan2, atan, sinh, cosh, tanh
from math import pi ,exp,log, log10, sqrt
import ops

try:
  import aster
except ImportError:
  pass


# -----------------------------------------------------------------------------
JdC = JDC_CATA(code='ASTER',
               execmodul=None,
               regles = (AU_MOINS_UN('DEBUT','POURSUITE'),
                         AU_MOINS_UN('FIN'),
                         A_CLASSER(('DEBUT','POURSUITE'),'FIN')))
# Type le plus general
class entier   (ASSD):
   def __init__(self,valeur=None,**args):
      ASSD.__init__(self,**args)
      self.valeur=valeur

   def __adapt__(self,validator):
      if validator.name == "list":
         #validateur liste,cardinalit
         return (self,)
      elif validator.name == "type":
         #validateur type
         return validator.adapt(self.valeur or 0)
      else:
         #validateur into et valid
         return self

class reel(ASSD):
   def __init__(self,valeur=None,**args):
      ASSD.__init__(self,**args)
      self.valeur=valeur

   def __call__(self):
      return self.valeur

   def __adapt__(self,validator):
      if validator.name == "list":
         #validateur liste,cardinalit
         return (self,)
      elif validator.name == "type":
         #validateur type
         return validator.adapt(self.valeur or 0.)
      else:
         #validateur into et valid
         return self

# -----------------------------------------------------------------------------
# Type geometriques
class no  (GEOM):pass
class grno(GEOM):pass
class ma  (GEOM):pass
class grma(GEOM):pass

# -----------------------------------------------------------------------------
from SD.co_cabl_precont     import cabl_precont
from SD.co_cara_elem        import cara_elem
from SD.co_cham_mater       import cham_mater
from SD.co_char_acou        import char_acou
from SD.co_char_cine_acou   import char_cine_acou
from SD.co_char_cine_meca   import char_cine_meca
from SD.co_char_cine_ther   import char_cine_ther
from SD.co_char_meca        import char_meca
from SD.co_char_ther        import char_ther
from SD.co_contact          import char_contact
from SD.co_compor           import compor_sdaster
from SD.co_courbe           import courbe_sdaster
from SD.co_fiss_xfem        import fiss_xfem
from SD.co_fond_fiss        import fond_fiss
from SD.co_interf_dyna_clas import interf_dyna_clas
from SD.co_gfibre           import gfibre_sdaster
from SD.co_listis           import listis_sdaster
from SD.co_list_inst        import list_inst
from SD.co_melasflu         import melasflu_sdaster
from SD.co_mode_cycl        import mode_cycl
from SD.co_nume_ddl_gene    import nume_ddl_gene
from SD.co_nume_ddl         import nume_ddl_sdaster
from SD.co_sd_feti          import sd_feti_sdaster
from SD.co_spectre          import spectre_sdaster
from SD.co_surface          import surface_sdaster
from SD.co_tran_gene        import tran_gene
from SD.co_type_flui_stru   import type_flui_stru

# -----------------------------------------------------------------------------
# modeles :
from SD.co_modele      import modele_sdaster
from SD.co_modele_gene import modele_gene

# -----------------------------------------------------------------------------
# materiau
from SD.co_mater import mater_sdaster

# -----------------------------------------------------------------------------
# macro-elements :
from SD.co_macr_elem_dyna import macr_elem_dyna
from SD.co_macr_elem_stat import macr_elem_stat

# -----------------------------------------------------------------------------
# liste :
from SD.co_listr8 import listr8_sdaster

# -----------------------------------------------------------------------------
# maillage :
from SD.co_maillage  import maillage_sdaster
from SD.co_squelette import squelette
from SD.co_grille    import grille_sdaster

# -----------------------------------------------------------------------------
# champs
from SD.co_champ     import cham_gd_sdaster
from SD.co_cham_no   import cham_no_sdaster
from SD.co_carte     import carte_sdaster
from SD.co_cham_elem import cham_elem

# -----------------------------------------------------------------------------
# resultat : (evol_sdaster,mode_stat,mode_meca)
from SD.co_resultat     import resultat_sdaster, resultat_jeveux
from SD.co_resultat_dyn import resultat_dyn
from SD.co_mode_meca    import mode_meca

# -----------------------------------------------------------------------------
class acou_harmo    (resultat_dyn):pass
class dyna_harmo    (resultat_dyn):pass
class dyna_trans    (resultat_dyn):pass
class harm_gene     (resultat_dyn):pass
class mode_acou     (resultat_dyn):pass
class mode_flamb    (resultat_dyn):pass
class mode_gene     (resultat_dyn):pass

# -----------------------------------------------------------------------------
class comb_fourier  (resultat_sdaster):pass
class fourier_elas  (resultat_sdaster):pass
class fourier_ther  (resultat_sdaster):pass
class mult_elas     (resultat_sdaster):pass
class theta_geom    (resultat_sdaster):pass

# -----------------------------------------------------------------------------
# resultat_sdaster/evol_sdaster :
class evol_sdaster(resultat_sdaster):pass
class evol_char(evol_sdaster):pass
class evol_elas(evol_sdaster):pass
class evol_noli(evol_sdaster):pass
class evol_ther(evol_sdaster):pass
class evol_varc(evol_sdaster):pass

# -----------------------------------------------------------------------------
# resultat_sdaster/mode_meca :
class mode_meca_c(mode_meca):pass

# -----------------------------------------------------------------------------
# fonctions / nappe / para_sensi
from SD.co_fonction import fonction_sdaster, para_sensi, fonction_c, nappe_sdaster

# -----------------------------------------------------------------------------
# matr_asse :
from SD.co_matr_asse      import matr_asse
from SD.co_matr_asse_gene import matr_asse_gene
from SD.co_matr_asse_gene import matr_asse_gene_r
from SD.co_matr_asse_gene import matr_asse_gene_c

from SD.co_matr_asse_gd import matr_asse_gd, \
                               matr_asse_depl_r, matr_asse_depl_c, \
                               matr_asse_pres_r, matr_asse_pres_c, \
                               matr_asse_temp_r, matr_asse_temp_c

# -----------------------------------------------------------------------------
# matr_elem :
from SD.co_matr_elem import matr_elem, \
                            matr_elem_depl_r, matr_elem_depl_c, \
                                              matr_elem_pres_c, \
                            matr_elem_temp_r

# -----------------------------------------------------------------------------
# table :
from SD.co_table import table_sdaster, table_jeveux
from SD.co_table_fonction import table_fonction
from SD.co_table_container import table_container

# -----------------------------------------------------------------------------
# vect_asse_gene :
from SD.co_vect_asse_gene import vect_asse_gene

# -----------------------------------------------------------------------------
# vect_elem :
from SD.co_vect_elem import vect_elem, \
                            vect_elem_depl_r, \
                            vect_elem_pres_r, vect_elem_pres_c, \
                            vect_elem_temp_r


# -----------------------------------------------------------------------------
# corresp_2_mailla :
from SD.co_corresp_2_mailla import corresp_2_mailla

#& MODIF COMMUN  DATE 21/12/2010   AUTEUR ABBAS M.ABBAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2010  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ABBAS M.ABBAS

def C_AFFICHAGE() : return FACT(statut='f',max=1,
        INFO_RESIDU = SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
        UNITE       = SIMP(statut='f',typ='I',val_min=1),
       );
#& MODIF COMMUN  DATE 21/02/2011   AUTEUR ABBAS M.ABBAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ABBAS M.ABBAS
def C_ARCHIVAGE() : return FACT(statut='d',max=1,
    regles         = (EXCLUS('PAS_ARCH','LIST_INST','INST'),),
    LIST_INST      = SIMP(statut='f',typ=(listr8_sdaster) ),
    INST           = SIMP(statut='f',typ='R',validators=NoRepeat(),max='**' ),
    PAS_ARCH       = SIMP(statut='f',typ='I' ),
    CRITERE        = SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
           b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
              PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
           b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
              PRECISION       =SIMP(statut='o',typ='R',),),
    DETR_NUME_SUIV = SIMP(statut='f',typ='TXM',into=("OUI",)),
    CHAM_EXCLU     = SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',),
);
#& MODIF COMMUN  DATE 07/12/2010   AUTEUR GENIAUT S.GENIAUT 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2010  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE GENIAUT S.GENIAUT
def C_COMP_ELAS( COMMAND ) :  #COMMUN#
    
    assert COMMAND in ('MACR_ASCOUF_CALC','MACR_ASPIC_CALC','CALC_G','POST_GP',
                       'CALC_POINT_MAT','SIMU_POINT_MAT', 'DYNA_NON_LINE','STAT_NON_LINE','CALCUL',)
    
    kwargs = {}

# ----------------------------------------------------------------------------------------------------------------------------------
#                            RELATION
# ----------------------------------------------------------------------------------------------------------------------------------
    # commandes pour lesquelles on ne peut pas choisir une relation de type 1d
    if COMMAND in ('CALC_G','POST_GP','CALC_POINT_MAT','SIMU_POINT_MAT' ):
        kwargs['RELATION'] = SIMP(statut='o',typ='TXM',defaut="ELAS",
                                 into=("ELAS","ELAS_VMIS_LINE","ELAS_VMIS_TRAC","ELAS_VMIS_PUIS","ELAS_HYPER"))

    # commandes pour lesquelles tout type de relation est possible
    elif COMMAND in ('DYNA_NON_LINE','STAT_NON_LINE','CALCUL',):
        kwargs['RELATION'] = SIMP(statut='o',typ='TXM',defaut="ELAS",
                                 into=("ELAS","ELAS_VMIS_LINE","ELAS_VMIS_TRAC",
                                       "ELAS_VMIS_PUIS","ELAS_HYPER","ELAS_POUTRE_GR","CABLE"))

     # cas particulier de MACR_ASCOUF/ASPIC_CALC : on limite volontairement le choix pour ne pas perturber l'utilisateur
     # mais theoriquement, toutes les lois disponibles pour CALC_G le sont aussi pour MACR_ASCOUF/ASPIC_CALC
    elif COMMAND in ('MACR_ASCOUF_CALC','MACR_ASPIC_CALC'):
        kwargs['RELATION'] = SIMP(statut='o',typ='TXM',into=("ELAS","ELAS_VMIS_TRAC"))


# ----------------------------------------------------------------------------------------------------------------------------------
#                            DEFORMATION
# ----------------------------------------------------------------------------------------------------------------------------------

    # commandes pour lesquelles on ne peut pas choisir les grandes deformations
    if COMMAND in ('CALC_POINT_MAT','MACR_ASCOUF_CALC','MACR_ASPIC_CALC'):
        kwargs['DEFORMATION'] =SIMP(statut='f',typ='TXM',defaut="PETIT" ,into=("PETIT",))

    # commandes pour lesquelles on peut choisir tout type de deformation
    elif COMMAND in ('DYNA_NON_LINE','STAT_NON_LINE','CALCUL','POST_GP','CALC_G','SIMU_POINT_MAT', ):
        kwargs['DEFORMATION'] =SIMP(statut='f',typ='TXM',defaut="PETIT" ,into=("PETIT","GROT_GDEP",))

# ----------------------------------------------------------------------------------------------------------------------------------
#                            INTEGRATION (RESI_INTE_RELA, ITER_INTE_MAXI, ALGO_INTE)
# ----------------------------------------------------------------------------------------------------------------------------------

    kwargs['RESI_INTE_RELA']    =SIMP(statut='f',typ='R',defaut= 1.0E-6)
    kwargs['ITER_INTE_MAXI']    =SIMP(statut='f',typ='I',defaut= 10 )
    kwargs['ALGO_INTE']         =SIMP(statut='f',typ='TXM',into=("ANALYTIQUE", "SECANTE",))

# ----------------------------------------------------------------------------------------------------------------------------------
#                            LOCALISATION
# ----------------------------------------------------------------------------------------------------------------------------------

    # commandes pour lesquelles la localisation n'a pas de sens
    # 'CALC_POINT_MAT','SIMU_POINT_MAT' 

    # commandes pour lesquelles la localisation est automatique
    # 'MACR_ASCOUF_CALC','MACR_ASPIC_CALC'

    # commandes pour lesquelles on peut choisir la localisation
    if COMMAND in ('DYNA_NON_LINE','STAT_NON_LINE','CALC_G','POST_GP','CALCUL'):
        kwargs['regles'] = (PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),)
        kwargs['TOUT'] =SIMP(statut='f',typ='TXM',into=("OUI",) )
        kwargs['GROUP_MA']  =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**')
        kwargs['MAILLE']    =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**')

# ----------------------------------------------------------------------------------------------------------------------------------
#                            DIVERS
# ----------------------------------------------------------------------------------------------------------------------------------

    if COMMAND == 'CALC_G':
        kwargs['CALCUL_CONTRAINTE'] =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") )


    mcfact = FACT(statut='f',max='**', **kwargs)

    return mcfact
#& MODIF COMMUN  DATE 08/02/2011   AUTEUR PROIX J-M.PROIX 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PROIX J.M.PROIX
def C_COMP_INCR() : return FACT(statut='f',min=1,max='**',  #COMMUN#
           RELATION  =SIMP( statut='o',typ='TXM',defaut="ELAS",into=C_RELATION()),
           b_monox     = BLOC(condition = "RELATION == 'MONOCRISTAL' ",
                                 fr="SD issue de DEFI_COMPOR",
                   COMPOR =SIMP(statut='o',typ=compor_sdaster,max=1),),
           b_polyx     = BLOC(condition = "RELATION == 'POLYCRISTAL' ",
                                 fr="SD issue de DEFI_COMPOR",
                   COMPOR =SIMP(statut='o',typ=compor_sdaster,max=1),),
           b_zmat      = BLOC(condition = "RELATION == 'ZMAT' ",
                                 fr="Comportement de la bibliotheque Zmat",
                   NB_VARI =SIMP(statut='o',typ='I',max=1),
                   UNITE =SIMP(statut='o',typ='I',max=1),),
           b_umat      = BLOC(condition = "RELATION == 'UMAT' ",
                                 fr="Comportement utilisateur de type UMAT",
                   NB_VARI =SIMP(statut='o',typ='I',max=1,fr="Nombre de variables internes"),
                   LIBRAIRIE = SIMP(statut='o', typ='TXM',validators=LongStr(1,128),
                        fr="Chemin vers la bibliothque dynamique dfinissant le comportement UMAT"),
                   NOM_ROUTINE = SIMP(statut='o', typ='TXM',
                        fr="Nom de la routine UMAT dans la bibliothque"),
                   ),

# KITs
           b_kit_ddi = BLOC(condition = "RELATION == 'KIT_DDI' ",
                            fr="relations de couplage fluage-plasticite",
               RELATION_KIT    =SIMP(statut='o',typ='TXM',min=2,max=2,validators=NoRepeat(),
                                 into=(
                                       "VMIS_CINE_LINE",
                                       "VMIS_ISOT_TRAC",
                                       "VMIS_ISOT_LINE",
                                       "VMIS_ISOT_PUIS",
                                       "GLRC_DM",
                                       "GRANGER_FP",
                                       "GRANGER_FP_INDT",
                                       "GRANGER_FP_V",
                                       "BETON_UMLV_FP",
                                       "ROUSS_PR",
                                       "BETON_DOUBLE_DP",
                                       "ENDO_ISOT_BETON",
                                       "MAZARS"
                                       ),),
                   ),
           b_kit_thm = BLOC(condition = "RELATION in ['KIT_HHM','KIT_HH','KIT_H','KIT_HM','KIT_THHM', \
                                                      'KIT_THH','KIT_THM','KIT_THV']",
                            fr="lois de comportements thermo-hydro-mecaniques",
               RELATION_KIT    =SIMP(statut='o',typ='TXM',max=9,validators=NoRepeat(),
                                 into=(
# MECA
                                       "ELAS",
                                       "CJS",
                                       "HUJEUX",
                                       "CAM_CLAY",
                                       "BARCELONE",
                                       "LAIGLE",
                                       "LETK",
                                       "DRUCK_PRAGER",
                                       "DRUCK_PRAG_N_A",
                                       "VISC_DRUC_PRAG",
                                       "ELAS_GONF",
                                       "HOEK_BROWN_EFF",
                                       "HOEK_BROWN_TOT",
                                       "MAZARS",
                                       "ENDO_ISOT_BETON",
                                       "JOINT_BANDIS",
                                       "CZM_LIN_REG",
                                       "CZM_EXP_REG",
# THMC
                                       "GAZ",
                                       "LIQU_SATU",
                                       "LIQU_GAZ_ATM",
                                       "LIQU_VAPE_GAZ",
                                       "LIQU_AD_GAZ_VAPE",
                                       "LIQU_AD_GAZ",
                                       "LIQU_VAPE",
                                       "LIQU_GAZ",
# HYDR
                                       "HYDR_UTIL",
                                       "HYDR_VGM",
                                       "HYDR",
                                       "HYDR_ENDO",
                                       ),),
                                       ),
           b_kit_meta = BLOC(condition = "RELATION in ('META_LEMA_ANI','META_P_CL_PT_RE','META_P_CL_PT','META_P_CL_RE','META_P_CL',\
       'META_P_IL_PT_RE','META_P_IL_PT','META_P_IL_RE','META_P_IL','META_P_INL_PT_RE','META_P_INL_PT','META_P_INL_RE','META_P_INL',\
           'META_V_CL_PT_RE','META_V_CL_PT','META_V_CL_RE','META_V_CL','META_V_IL_PT_RE','META_V_IL_PT','META_V_IL_RE','META_V_IL',\
           'META_V_INL_PT_RE','META_V_INL_PT','META_V_INL_RE','META_V_INL')",
                            fr="nombre de phases metallurgiques",
               RELATION_KIT    =SIMP(statut='o',typ='TXM',max=1,validators=NoRepeat(),
                                 into=("ACIER","ZIRC"),),
                                 ),

           DEFORMATION       =SIMP(statut='f',typ='TXM',defaut="PETIT",
                                   into=("PETIT","PETIT_REAC","GROT_GDEP","SIMO_MIEHE","GDEF_HYPO_ELAS","GREEN_REAC","GDEF_LOG")),
           ALGO_C_PLAN       =SIMP(statut='f',typ='TXM',defaut="ANALYTIQUE",into=("DEBORST","ANALYTIQUE",)),
           RESI_DEBO_MAXI    =SIMP(statut='f',typ='R',fr="Critre d'arret absolu pour assurer la condition de contraintes planes",),

           b_resideborst     =BLOC(condition = " RESI_DEBO_MAXI == None ",
                                      fr="Critre d'arret relatif pour assurer la condition de contraintes planes",
               RESI_DEBO_RELA   =SIMP(statut='f',typ='R',defaut= 1.0E-6),
                                  ),

           ALGO_1D           =SIMP(statut='f',typ='TXM',defaut="ANALYTIQUE",into=("DEBORST","ANALYTIQUE",)),
           ITER_MAXI_DEBORST =SIMP(statut='f',typ='I',defaut= 1),
           RESI_INTE_RELA    =SIMP(statut='f',typ='R',defaut= 1.0E-6),
           ITER_INTE_MAXI    =SIMP(statut='f',typ='I',defaut= 20 ),

           b_redec_local      = BLOC(condition = "DEFORMATION in ('PETIT','PETIT_REAC','GROT_GDEP')",
                                     fr="Nombre de redcoupages internes du pas de temps",
               ITER_INTE_PAS   =SIMP(statut='f',typ='I',defaut= 0 ),
                                     ),

           ALGO_INTE         =SIMP(statut='f',typ='TXM',into=("ANALYTIQUE", "SECANTE", "DEKKER", "NEWTON_1D","BRENT", 
                                                              "NEWTON", "NEWTON_RELI", "NEWTON_PERT", "RUNGE_KUTTA",
                                                              "SPECIFIQUE", "SANS_OBJET")),

           TYPE_MATR_TANG    =SIMP(statut='f',typ='TXM',into=("PERTURBATION","VERIFICATION","TANGENTE_SECANTE")),

           b_perturb         =BLOC(condition = " (TYPE_MATR_TANG != None) and (TYPE_MATR_TANG != 'TANGENTE_SECANTE') ",
                                   fr="Calcul de la matrice tangente par perturbation, valeur de la perturbation",
                VALE_PERT_RELA  =SIMP(statut='f',typ='R',defaut= 1.0E-5),
                                  ),

           b_tangsec        = BLOC(condition = " TYPE_MATR_TANG == 'TANGENTE_SECANTE' ",
                                   fr="Modification evolutive de la matrice tangente/secante",
                 SEUIL        =SIMP(statut='f',typ='R',defaut= 3. ),
                 AMPLITUDE    =SIMP(statut='f',typ='R',defaut= 1.5 ),
                 TAUX_RETOUR  =SIMP(statut='f',typ='R',defaut= 0.05 ),
                                  ),

           PARM_THETA      =SIMP(statut='f',typ='R',val_min=0.,val_max=1., defaut= 1.),
           PARM_ALPHA      =SIMP(statut='f',typ='R',defaut= 1. ),

           regles=(PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),

         ) ;
#& MODIF COMMUN  DATE 06/12/2010   AUTEUR ABBAS M.ABBAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2009  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ABBAS M.ABBAS
def C_CONVERGENCE() : return FACT(statut='d',
           regles=(PRESENT_ABSENT('RESI_REFE_RELA','RESI_GLOB_MAXI','RESI_GLOB_RELA','RESI_COMP_RELA'),),
           b_refe_rela    =BLOC(condition = "RESI_REFE_RELA != None",
             regles=(AU_MOINS_UN('SIGM_REFE','EPSI_REFE','FLUX_THER_REFE','FORC_REFE',
                                  'FLUX_HYD1_REFE','FLUX_HYD2_REFE','VARI_REFE','DEPL_REFE','LAGR_REFE'),),
             FORC_REFE       =SIMP(statut='f',typ='R',min=2,max=2,
                fr="Force et Moment de rfrence pour les lments de structure."),
             SIGM_REFE       =SIMP(statut='f',typ='R'),
             DEPL_REFE       =SIMP(statut='f',typ='R'),
             EPSI_REFE       =SIMP(statut='f',typ='R'),
             FLUX_THER_REFE  =SIMP(statut='f',typ='R'),
             FLUX_HYD1_REFE  =SIMP(statut='f',typ='R'),
             FLUX_HYD2_REFE  =SIMP(statut='f',typ='R'),
             VARI_REFE       =SIMP(statut='f',typ='R'),
             LAGR_REFE       =SIMP(statut='f',typ='R'),
           ),
           RESI_REFE_RELA  =SIMP(statut='f',typ='R'),
           RESI_GLOB_MAXI  =SIMP(statut='f',typ='R'),
           RESI_GLOB_RELA  =SIMP(statut='f',typ='R'),
           RESI_COMP_RELA  =SIMP(statut='f',typ='R'),
           ITER_GLOB_MAXI  =SIMP(statut='f',typ='I',defaut=10),
           ITER_GLOB_ELAS  =SIMP(statut='f',typ='I',defaut=25),
           TYPE            =SIMP(statut='f',typ='TXM',defaut="PIC",into=("PIC","PLATEAU")),
           b_plateau    =BLOC(condition = "TYPE == 'PLATEAU' ",

             PLATEAU_ITER    =SIMP(statut='f',typ='I',defaut=3, val_min =2),
             PLATEAU_RELA    =SIMP(statut='f',typ='R',defaut=1E-3),
           ),


           ARRET           =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
         );
#& MODIF COMMUN  DATE 08/09/2009   AUTEUR SFAYOLLE S.FAYOLLE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2009  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE SFAYOLLE

def C_IMPL_EX() : return FACT(statut='d',
           REAC_INCR       =SIMP(statut='f',typ='I',defaut= 1),
           PREDICTION      =SIMP(statut='f',typ='TXM',defaut="TANGENTE"),
         );
#& MODIF COMMUN  DATE 06/12/2010   AUTEUR ABBAS M.ABBAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2009  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ABBAS M.ABBAS
def C_INCREMENT() : return FACT(statut='o',
           regles=(EXCLUS('NUME_INST_INIT','INST_INIT'),
                   EXCLUS('NUME_INST_FIN','INST_FIN'),),
           LIST_INST       =SIMP(statut='o',typ=(listr8_sdaster,list_inst)),
           NUME_INST_INIT  =SIMP(statut='f',typ='I'),
           INST_INIT       =SIMP(statut='f',typ='R'),
           NUME_INST_FIN   =SIMP(statut='f',typ='I'),
           INST_FIN        =SIMP(statut='f',typ='R'),
           ERRE_TEMPS      =SIMP(statut='f',typ='TXM',into=("OUI","NON"),defaut="NON",
                                 fr="Adaptation temporelle pour les modlisations HM instationnaires",
                                 ang="Time adaptation for unstationary HM models"),
           PRECISION       =SIMP(statut='f',typ='R',defaut=1.0E-6 ),
         );
#& MODIF COMMUN  DATE 06/12/2010   AUTEUR ABBAS M.ABBAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2009  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ABBAS M.ABBAS
def C_NEWTON() : return FACT(statut='d',
           REAC_INCR       =SIMP(statut='f',typ='I',defaut= 1,val_min=0),
           PREDICTION      =SIMP(statut='f',typ='TXM',into=("DEPL_CALCULE","TANGENTE","ELASTIQUE","EXTRAPOL") ),
           MATRICE         =SIMP(statut='f',typ='TXM',defaut="TANGENTE",into=("TANGENTE","ELASTIQUE") ),
           PAS_MINI_ELAS   =SIMP(statut='f',typ='R',val_min=0.0),
           REAC_ITER       =SIMP(statut='f',typ='I',defaut=0,val_min=0),
           REAC_ITER_ELAS  =SIMP(statut='f',typ='I',defaut=0,val_min=0),
           EVOL_NOLI       =SIMP(statut='f',typ=evol_noli),
         );
#& MODIF COMMUN  DATE 19/05/2011   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE VABHHTS J.PELLET
# ce fichier contient la liste des "into" possibles pour le mot cle NOM_CHAM
# c'est a dire les noms de champs des SD RESULTAT (DATA de la routine RSCRSD)

def C_NOM_CHAM_INTO( typ_cham=None ) : #COMMUN# 
  import types
# Liste de tout les champs
  l_tout_cham = [
                        "ACCE",
                        "ACCE_ABSOLU",
                        "ALPH0_ELGA_EPSP",
                        "ALPHP_ELGA_ALPH0",
                        "COMPORTEMENT",
                        "COMPORTHER",
                        "CRIT_ELNO",
                        "DEDE_ELNO",
                        "DEDE_NOEU",
                        "DEGE_ELNO",
                        "DEGE_NOEU",
                        "DEPL",
                        "DEPL_ABSOLU",
                        "DERA_ELGA",
                        "DERA_ELNO",
                        "DERA_NOEU",
                        "DESI_ELNO",
                        "DESI_NOEU",
                        "DETE_ELNO",
                        "DETE_NOEU",
                        "DISS_ELGA",
                        "DISS_ELNO",
                        "DISS_NOEU",
                        "DURT_ELNO",
                        "DURT_NOEU",
                        "ECIN_ELEM",
                        "EFCA_ELNO",
                        "EFCA_NOEU",
                        "EFGE_ELNO",
                        "EFGE_NOEU",
                        "ENDO_ELGA",
                        "ENDO_ELNO",
                        "ENDO_NOEU",
                        "ENEL_ELGA",
                        "ENEL_ELNO",
                        "ENEL_NOEU",
                        "EPEQ_ELGA",
                        "EPEQ_ELNO",
                        "EPEQ_NOEU",
                        "EPFD_ELGA",
                        "EPFD_ELNO",
                        "EPFD_NOEU",
                        "EPFP_ELGA",
                        "EPFP_ELNO",
                        "EPFP_NOEU",
                        "EPME_ELGA",
                        "EPME_ELNO",
                        "EPMG_ELGA",
                        "EPMG_ELNO",
                        "EPMG_NOEU",
                        "EPMQ_ELGA",
                        "EPMQ_ELNO",
                        "EPMQ_NOEU",
                        "EPOT_ELEM",
                        "EPSA_ELNO",
                        "EPSA_NOEU",
                        "EPSG_ELGA",
                        "EPSG_ELNO",
                        "EPSG_NOEU",
                        "EPSI_ELGA",
                        "EPSI_ELNO",
                        "EPSI_NOEU",
                        "EPSP_ELGA",
                        "EPSP_ELNO",
                        "EPSP_NOEU",
                        "EPTQ_ELNO",
                        "EPTU_ELNO",
                        "EPVC_ELGA",
                        "EPVC_ELNO",
                        "EPVC_NOEU",
                        "ERME_ELEM",
                        "ERME_ELNO",
                        "ERME_NOEU",
                        "ERTH_ELEM",
                        "ERTH_ELNO",
                        "ERTH_NOEU",
                        "ERZ1_ELEM",
                        "ERZ2_ELEM",
                        "ETOT_ELEM",
                        "ETOT_ELGA",
                        "ETOT_ELNO",
                        "FERRAILLAGE",
                        "FLHN_ELGA",
                        "FLUX_ELGA",
                        "FLUX_ELNO",
                        "FLUX_NOEU",
                        "FORC_NODA",
                        "FSUR_2D",
                        "FSUR_3D",
                        "FVOL_2D",
                        "FVOL_3D",
                        "GRAD_NOEU_THETA",
                        "HYDR_ELNO",
                        "HYDR_NOEU",
                        "INDL_ELGA",
                        "INTE_ELNO",
                        "INTE_NOEU",
                        "IRRA",
                        "LANL_ELGA",
                        "META_ELGA_TEMP",
                        "META_ELNO",
                        "META_NOEU",
                        "MODE_FLAMB",
                        "PMPB_ELGA",
                        "PMPB_ELNO",
                        "PMPB_NOEU",
                        "PRAC_ELNO",
                        "PRAC_NOEU",
                        "PRES",
                        "PRME_ELNO",
                        "QIRE_ELEM",
                        "QIRE_ELNO",
                        "QIRE_NOEU",
                        "QIZ1_ELEM",
                        "QIZ2_ELEM",
                        "REAC_NODA",
                        "SICA_ELNO",
                        "SICA_NOEU",
                        "SICO_ELNO",
                        "SICO_NOEU",
                        "SIEF_ELGA",
                        "SIEF_ELNO",
                        "SIEF_NOEU",
                        "SIEF_SENO_SEGA",
                        "SIEQ_ELGA",
                        "SIEQ_ELNO",
                        "SIEQ_NOEU",
                        "SIGM_ELNO",
                        "SIGM_NOEU",
                        "SING_ELEM",
                        "SING_ELNO",
                        "SIPM_ELNO",
                        "SIPO_ELNO",
                        "SIPO_NOEU",
                        "SIRO_ELEM",
                        "SITQ_ELNO",
                        "SITU_ELNO",
                        "SIZ1_NOEU",
                        "SIZ2_NOEU",
                        "SOUR_ELGA",
                        "SPMX_ELGA",
                        "TEMP",
                        "THETA",
                        "VACO_ELNO",
                        "VAEX_ELGA",
                        "VAEX_ELNO",
                        "VAEX_NOEU",
                        "VALE_CONT",
                        "VARC_ELGA",
                        "VARI_ELGA",
                        "VARI_ELNO",
                        "VARI_NOEU",
                        "VATU_ELNO",
                        "VITE",
                        "VITE_ABSOLU",
                        "VITE_VENT",
                        ]
#
# Si aucun argument n'est passe, on utilise tous les types de champs possibles
  if ( typ_cham is None ) :
    l_ncham = l_tout_cham
#
# Sinon, on n'utilise que les champs dont le type est passe en argument
  else :
    l_typ_cham = []
    if (type(typ_cham) == types.StringType) :
      l_typ_cham.append(typ_cham)
    else :
      l_typ_cham = typ_cham
    l_ncham = []
    for typ in l_typ_cham :
     for cham in l_tout_cham :
       if (cham.find(typ) != -1) :
        if (cham.split('_')[1] == typ):
           l_ncham.append(cham)

  return tuple(l_ncham)
#& MODIF COMMUN  DATE 04/04/2011   AUTEUR PELLET J.PELLET 
# RESPONSABLE DESROCHES X.DESROCHES
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# ce fichier contient la liste des  noms des grandeurs de CODE_ASTER
def C_NOM_GRANDEUR() : return  ( #COMMUN#
"ABSC_R",
"ADRSJEVE",
"ADRSJEVN",
"CAARPO",
"CACABL",
"CACOQU",
"CADISA",
"CADISK",
"CADISM",
"CAFI_R",
"CAGEBA",
"CAGEPO",
"CAGNBA",
"CAGNPO",
"CAMASS",
"CAORIE",
"CAPOUF",
"CARCRI",
"CASECT",
"CHLI_R",
"CODE_I",
"COEH_F",
"COEH_R",
"COMPOR",
"CORR_R",
"CRRU_R",
"DBEL_R",
"DCEL_I",
"DDLI_C",
"DDLI_F",
"DDLI_R",
"DDLM_C",
"DDLM_R",
"DEPL_C",
"DEPL_F",
"DEPL_R",
"DISS_R",
"DOMA_R",
"DURT_R",
"ENDO_R",
"ENER_R",
"EPSI_C",
"EPSI_F",
"EPSI_R",
"ERRE_R",
"FACY_R",
"FELECR",
"FER2_R",
"FISS_R",
"FLAPLA",
"FLUN_F",
"FLUN_R",
"FLUX_F",
"FLUX_R",
"FORC_C",
"FORC_F",
"FORC_R",
"FREQ_R",
"FTHM_F",
"FTHM_R",
"G",
"GEOM_R",
"G_DEPL_R",
"HARMON",
"HYDR_R",
"IMPE_C",
"IMPE_F",
"IMPE_R",
"INDL_R",
"INFC_R",
"INST_R",
"INTE_R",
"INTLOC",
"IRRA_R",
"ITECREL",
"ITEDEC",
"J",
"LISTMA",
"MACOMP",
"MASS_R",
"MATE_F",
"NBSP_I",
"NEUT_F",
"NEUT_I",
"NEUT_K16",
"NEUT_K24",
"NEUT_K8",
"NEUT_R",
"NUMC_I",
"NUMMOD",
"ONDE_F",
"ONDE_R",
"PESA_R",
"PILO_K",
"PILO_R",
"POSI",
"PREC",
"PRES_C",
"PRES_F",
"PRES_R",
"RAYO_F",
"RAYO_R",
"RCCM_K",
"RCCM_R",
"RESCREL",
"RICE_TRA",
"ROTA_R",
"SECTION",
"SIEF_C",
"SIEF_R",
"SIZZ_R",
"SOUR_F",
"SOUR_R",
"SPMA_R",
"STAOUDYN",
"TEMP_C",
"TEMP_F",
"TEMP_R",
"THETA",
"VALO_R",
"VANL_R",
"VAR2_R",
"VARI_R",
"VENTCX_F",
"VNOR_C",
"VNOR_F",
"VOISIN",
"WEIBULL",
"XCONTAC",
                                 )
#& MODIF COMMUN  DATE 17/01/2011   AUTEUR ABBAS M.ABBAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ABBAS M.ABBAS

def C_OBSERVATION() : return FACT(statut='f',max=99,

           NOM_CHAM        =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=1,
                                   into=("VALE_CONT","FORC_NODA",
                                         "DEPL","VITE","ACCE","TEMP",
                                         "SIEF_ELGA","VARI_ELGA",                                        
                                         "DEPL_ABSOLU","VITE_ABSOLU","ACCE_ABSOLU",)),
          
           EVAL_CHAM       =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max=1,defaut='VALE',
                                   into=("MIN","MAX","MOY","VALE",),),
                                         
           NOM_CMP         =SIMP(statut='o',typ='TXM',max=20),
           EVAL_CMP        =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max=1,defaut='VALE',
                                   into=("VALE","FORMULE",),),
                                   
           b_formule       =BLOC(condition="(EVAL_CMP=='FORMULE')",
                                   FORMULE = SIMP(statut='o',typ=formule,max=1),
                                ),
                                                 
           b_cham_no       =BLOC(condition="(NOM_CHAM=='DEPL') or \
                                            (NOM_CHAM=='VITE') or \
                                            (NOM_CHAM=='ACCE') or \
                                            (NOM_CHAM=='TEMP') or \
                                            (NOM_CHAM=='FORC_NODA') or \
                                            (NOM_CHAM=='VALE_CONT') or \
                                            (NOM_CHAM=='DEPL_ABSOLU') or \
                                            (NOM_CHAM=='VITE_ABSOLU') or \
                                            (NOM_CHAM=='ACCE_ABSOLU')",
                                 regles   =(UN_PARMI('NOEUD','GROUP_NO','GROUP_MA','MAILLE','TOUT')),
                                 TOUT            =SIMP(statut='d',typ='TXM',into=("OUI",) ),
                                 NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                                 GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                                 MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                                 GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),          
                                ),          

                                          
           b_cham_elga     =BLOC(condition="(NOM_CHAM=='SIEF_ELGA') or \
                                            (NOM_CHAM=='VARI_ELGA')",
                                 regles          =(UN_PARMI('GROUP_MA','MAILLE','TOUT')), 
                                 TOUT            =SIMP(statut='d',typ='TXM',into=("OUI",) ),          
                                 MAILLE          =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
                                 GROUP_MA        =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max='**'), 
                                 EVAL_ELGA       =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max=1,defaut='VALE',
                                                        into=("MIN","MAX","VALE",),), 
                                 b_elga_vale     =BLOC(condition="(EVAL_ELGA=='VALE')",                     
                                   POINT           =SIMP(statut='o',typ='I'  ,validators=NoRepeat(),max='**'), 
                                   SOUS_POINT      =SIMP(statut='f',typ='I'  ,validators=NoRepeat(),max='**'),  
                                 ),  
                                ),
             
           INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**' ),
           LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
           PAS_OBSE        =SIMP(statut='f',typ='I'),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
           b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
              PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
           b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
              PRECISION       =SIMP(statut='o',typ='R',),),
       
       
       );
#& MODIF COMMUN  DATE 29/03/2007   AUTEUR GRANET S.GRANET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2004  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# ce fichier contient la liste des PARA possibles pour les fonctions et les nappes
def C_PARA_FONCTION() : return  ( #COMMUN#
                   "DX","DY","DZ","DRX","DRY","DRZ","TEMP","TSEC",
                   "INST","X","Y","Z","EPSI","META","FREQ","PULS","DSP",
                   "AMOR","ABSC","SIGM","HYDR","SECH","PORO","SAT",
                   "PGAZ","PCAP","PLIQ","PVAP","PAD","VITE","ENDO",
                   "NORM","EPAIS","NEUT1","NEUT2",)
#& MODIF COMMUN  DATE 01/02/2011   AUTEUR MASSIN P.MASSIN 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ABBAS M.ABBAS
def C_PILOTAGE() : return FACT(statut='f',
           regles=(EXCLUS('NOEUD','GROUP_NO'),PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TYPE    =SIMP(statut='o',typ='TXM',into=("DDL_IMPO","LONG_ARC","PRED_ELAS","DEFORMATION",
                                                    "ANA_LIM","SAUT_IMPO","SAUT_LONG_ARC") ),
           COEF_MULT       =SIMP(statut='f',typ='R',defaut= 1.0E+0),
           EVOL_PARA       =SIMP(statut='f',typ='TXM',defaut="SANS", into=("SANS","CROISSANT","DECROISSANT") ),
           ETA_PILO_MAX    =SIMP(statut='f',typ='R'),
           ETA_PILO_MIN    =SIMP(statut='f',typ='R'),
           ETA_PILO_R_MAX  =SIMP(statut='f',typ='R'),
           ETA_PILO_R_MIN  =SIMP(statut='f',typ='R'),
           PROJ_BORNES     =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
           SELECTION       =SIMP(statut='f',typ='TXM',defaut="NORM_INCR_DEPL", into=("RESIDU","ANGL_INCR_DEPL","NORM_INCR_DEPL") ),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max='**'),
           FISSURE         =SIMP(statut='f',typ=fiss_xfem ,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no   ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno ,validators=NoRepeat(),max='**'),
           NOM_CMP         =SIMP(statut='f',typ='TXM',max='**'),
           DIRE_PILO       =SIMP(statut='f',typ='TXM',max='**'),
         );

#& MODIF COMMUN  DATE 06/12/2010   AUTEUR ABBAS M.ABBAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2009  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ABBAS M.ABBAS
def C_RECH_LINEAIRE() : return FACT(statut='f',
           METHODE         =SIMP(statut='f',typ='TXM',defaut="CORDE",into=("CORDE","MIXTE","PILOTAGE") ),
           RESI_LINE_RELA  =SIMP(statut='f',typ='R',defaut= 1.0E-1 ),
           ITER_LINE_MAXI  =SIMP(statut='f',typ='I',defaut= 3,val_max=999),
           ITER_LINE_CRIT  =SIMP(statut='f',typ='I',defaut= 20),
           PAS_MINI_CRIT   =SIMP(statut='f',typ='R',defaut=0.0E+0),
           RHO_MIN         =SIMP(statut='f',typ='R',defaut=1.0E-2),
           RHO_MAX         =SIMP(statut='f',typ='R',defaut=1.0E+1),
           RHO_EXCL        =SIMP(statut='f',typ='R',defaut=0.9E-2,val_min=0.),
         );
#& MODIF COMMUN  DATE 28/02/2011   AUTEUR BARGELLI R.BARGELLINI 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PROIX J.M.PROIX
def C_RELATION() : return (             "ELAS",            #COMMUN#

                                        "ARME",
                                        "ASSE_CORN",
                                        "BARCELONE",
                                        "BETON_DOUBLE_DP",
                                        "BETON_RAG",
                                        "BETON_REGLE_PR",
                                        "BETON_UMLV_FP",
                                        "CAM_CLAY",
                                        "CJS",
                                        "CORR_ACIER",
                                        "CZM_EXP",
                                        "CZM_EXP_REG",
                                        "CZM_FAT_MIX",
                                        "CZM_LIN_REG",
                                        "CZM_OUV_MIX",
                                        "CZM_TAC_MIX",
                                        "CZM_TRA_MIX",
                                        "DIS_BILI_ELAS",
                                        "DIS_CHOC",
                                        "DIS_ECRO_CINE",
                                        "DIS_GOUJ2E_ELAS",
                                        "DIS_GOUJ2E_PLAS",
                                        "DIS_GRICRA",
                                        "DIS_VISC",
                                        "DRUCK_PRAGER",
                                        "DRUCK_PRAG_N_A",
                                        "ELAS_GONF",
                                        "ELAS_HYPER",
                                        "ENDO_CARRE",
                                        "ENDO_FRAGILE",
                                        "ENDO_HETEROGENE",
                                        "ENDO_ISOT_BETON",
                                        "ENDO_ORTH_BETON",
                                        "ENDO_SCALAIRE",
                                        "GATT_MONERIE",
                                        "GLRC_DAMAGE",
                                        "GLRC_DM",
                                        "GRANGER_FP",
                                        "GRANGER_FP_INDT",
                                        "GRANGER_FP_V",
                                        "GRAN_IRRA_LOG",
                                        "GRILLE_CINE_LINE",
                                        "GRILLE_ISOT_LINE",
                                        "GRILLE_PINTO_MEN",
                                        "HOEK_BROWN",
                                        "HOEK_BROWN_EFF",
                                        "HOEK_BROWN_TOT",
                                        "HUJEUX",
                                        "IRRAD3M",
                                        "JOINT_BA",
                                        "JOINT_BANDIS",
                                        "JOINT_MECA_RUPT",
                                        "JOINT_MECA_FROT",
                                        "KIT_DDI",
                                        "KIT_HH",
                                        "KIT_H",
                                        "KIT_HHM",
                                        "KIT_HM",
                                        "KIT_THH",
                                        "KIT_THHM",
                                        "KIT_THM",
                                        "KIT_THV",
                                        "LABORD_1D",
                                        "LAIGLE",
                                        "LEMAITRE",
                                        "LEMAITRE_IRRA",
                                        "LEMA_SEUIL",
                                        "LETK",
                                        "LMARC_IRRA",
                                        "MAZARS",
                                        "META_LEMA_ANI",
                                        "META_P_CL",
                                        "META_P_CL_PT",
                                        "META_P_CL_PT_RE",
                                        "META_P_CL_RE",
                                        "META_P_IL",
                                        "META_P_IL_PT",
                                        "META_P_IL_PT_RE",
                                        "META_P_IL_RE",
                                        "META_P_INL",
                                        "META_P_INL_PT",
                                        "META_P_INL_PT_RE",
                                        "META_P_INL_RE",
                                        "META_V_CL",
                                        "META_V_CL_PT",
                                        "META_V_CL_PT_RE",
                                        "META_V_CL_RE",
                                        "META_V_IL",
                                        "META_V_IL_PT",
                                        "META_V_IL_PT_RE",
                                        "META_V_IL_RE",
                                        "META_V_INL",
                                        "META_V_INL_PT",
                                        "META_V_INL_PT_RE",
                                        "META_V_INL_RE",
                                        "MONOCRISTAL",
                                        "MULTIFIBRE",
                                        "NORTON_HOFF",
                                        "PINTO_MENEGOTTO",
                                        "POLYCRISTAL",
                                        "ROUSSELIER",
                                        "ROUSS_PR",
                                        "ROUSS_VISC",
                                        "RUPT_FRAG",
                                        "SANS",
                                        "VENDOCHAB",
                                        "VISC_ENDO_LEMA",
                                        "VISCOCHAB",
                                        "VISC_CIN1_CHAB",
                                        "VISC_CIN2_CHAB",
                                        "VISC_CIN2_MEMO",
                                        "VISC_DRUC_PRAG",
                                        "VISC_IRRA_LOG",
                                        "VISC_ISOT_LINE",
                                        "VISC_ISOT_TRAC",
                                        "VISC_TAHERI",
                                        "VMIS_ASYM_LINE",
                                        "VMIS_CIN1_CHAB",
                                        "VMIS_CIN2_CHAB",
                                        "VMIS_CIN2_MEMO",
                                        "VMIS_CINE_LINE",
                                        "VMIS_ECMI_LINE",
                                        "VMIS_ECMI_TRAC",
                                        "VMIS_ISOT_LINE",
                                        "VMIS_ISOT_PUIS",
                                        "VMIS_ISOT_TRAC",
                                        "VMIS_POU_FLEJOU",
                                        "VMIS_POU_LINE",
                                        "ZMAT",
                                        "UMAT",
                                     )
#& MODIF COMMUN  DATE 08/02/2011   AUTEUR TARDIEU N.TARDIEU 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE REZETTE C.REZETTE
def C_SOLVEUR() : return FACT(statut='d',
           METHODE=SIMP(statut='f',typ='TXM',defaut="MULT_FRONT",into=("MULT_FRONT","LDLT","GCPC","MUMPS","FETI","PETSC") ),
# --------------------------------------------------------------------------------------------------------------------------------
           b_mult_front    =BLOC(condition = "METHODE == 'MULT_FRONT' ",fr="Paramtres de la mthode multi frontale",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="METIS",into=("MD","MDA","METIS") ),
           ),
# --------------------------------------------------------------------------------------------------------------------------------
           b_ldlt         =BLOC(condition = "METHODE == 'LDLT' ",fr="Paramtres de la mthode LDLT",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("RCMK","SANS") ),
           ),
# --------------------------------------------------------------------------------------------------------------------------------
           b_direct_hybride =BLOC( condition = "METHODE=='LDLT' or METHODE=='MULT_FRONT' or METHODE=='MUMPS' or METHODE=='FETI' ",
                                   fr="Paramtres relatifs  la non inversibilit de la matrice  factoriser",
             NPREC           =SIMP(statut='f',typ='I',defaut= 8 ),
             STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON","DECOUPE") ),
           ),
# --------------------------------------------------------------------------------------------------------------------------------
           b_gcpc         =BLOC(condition = "METHODE == 'GCPC' ", fr="Paramtres de la mthode du gradient conjugu",
             PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC","LDLT_SP"),defaut="LDLT_INC" ),
             b_ldltinc       =BLOC(condition = "PRE_COND == 'LDLT_INC' ", fr="Paramtres de la factorisation incomplte",
               NIVE_REMPLISSAGE    =SIMP(statut='f',typ='I',defaut= 0 ),
               RENUM               =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
               ),
             b_simple        =BLOC(condition = "PRE_COND == 'LDLT_SP' ", fr="Paramtres de la factorisation simple prcision",
               REAC_PRECOND        =SIMP(statut='f',typ='I',defaut=30, ),
               ),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
             NMAX_ITER       =SIMP(statut='f',typ='I',defaut= 0 ),
           ),
# --------------------------------------------------------------------------------------------------------------------------------
           b_mumps        =BLOC(condition = "METHODE == 'MUMPS' ",fr="Paramtres de la mthode MUMPS",
             TYPE_RESOL      =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("NONSYM","SYMGEN","SYMDEF","AUTO")),
             PRETRAITEMENTS  =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO")),
             POSTTRAITEMENTS =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO","FORCE")),             
             RENUM           =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("AMD","AMF","PORD","METIS","QAMD","SCOTCH","AUTO")),
             ELIM_LAGR2      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
             PCENT_PIVOT     =SIMP(statut='f',typ='I',defaut=10,),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut=-1.0,),
             OUT_OF_CORE     =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
             LIBERE_MEMOIRE =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),            
             FILTRAGE_MATRICE =SIMP(statut='f',typ='R',defaut=-1.0,),
             MIXER_PRECISION =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
             MATR_DISTRIBUEE =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
             ),
# --------------------------------------------------------------------------------------------------------------------------------
           b_feti          =BLOC(condition = "METHODE == 'FETI' ",fr="Paramtres de la mthode FETI 1",
             PARTITION       =SIMP(statut='o',typ=sd_feti_sdaster),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="METIS",into=("MD","MDA","METIS") ),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut=1.E-6,val_min=0.),
             NMAX_ITER       =SIMP(statut='f',typ='I',defaut=0,val_min=0),
             REAC_RESI       =SIMP(statut='f',typ='I',defaut=0,val_min=0),
             TYPE_REORTHO_DD =SIMP(statut='f',typ='TXM',defaut="GSM",into=("SANS","GS","GSM","IGSM") ),
             NB_REORTHO_DD   =SIMP(statut='f',typ='I',defaut=0,val_min=0),
             NB_REORTHO_INST =SIMP(statut='f',typ='I',defaut=0,val_min=0),
             PRE_COND        =SIMP(statut='f',typ='TXM',defaut="LUMPE",into=("LUMPE","SANS") ),
             SCALING         =SIMP(statut='f',typ='TXM',defaut="MULT",into=("SANS","MULT") ),
             VERIF_SDFETI    =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
             TEST_CONTINU    =SIMP(statut='f',typ='R',defaut=1.E-8,val_min=0.),
             INFO_FETI       =SIMP(statut='f',typ='TXM',defaut='FFFFFFFFFFFFFFFFFFFFFFFF'),
             STOCKAGE_GI     =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON","CAL") ),
             NB_SD_PROC0     =SIMP(statut='f',typ='I',defaut=0,val_min=0),
             ACCELERATION_SM =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           ),
# --------------------------------------------------------------------------------------------------------------------------------
           b_petsc          =BLOC(condition = "METHODE == 'PETSC' ",fr="Paramtres de la mthode PETSC",
             ALGORITHME      =SIMP(statut='f',typ='TXM',into=("BCGS","BICG","CG","CR","GMRES","TFQMR",),defaut="CG" ),
             PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC","JACOBI","SOR","LDLT_SP"),defaut="LDLT_INC" ),
             b_ldlt_inc     =BLOC(condition = "PRE_COND == 'LDLT_INC' ",
               NIVE_REMPLISSAGE = SIMP(statut='f',typ='I',defaut= 0 ),
               REMPLISSAGE      = SIMP(statut='f',typ='R',defaut= 1.0),
               RENUM            =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
             ),
             b_ldlt_sp      =BLOC(condition = "PRE_COND == 'LDLT_SP' ", fr="Paramtres de la factorisation simple prcision",
               REAC_PRECOND        =SIMP(statut='f',typ='I',defaut=30, ),
               RENUM               =SIMP(statut='f',typ='TXM',defaut="SANS",into=("SANS","RCMK") ),
             ),
             b_jacobi_sor   =BLOC(condition = "PRE_COND == 'JACOBI' or PRE_COND == 'SOR'", 
                                                                         fr="Paramtres des prconditionneurs JACOBI et SOR",
               RENUM               =SIMP(statut='f',typ='TXM',defaut="SANS",into=("SANS","RCMK") ),
             ),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
             NMAX_ITER       =SIMP(statut='f',typ='I',defaut= -1 ),
           ),
# --------------------------------------------------------------------------------------------------------------------------------
           SYME            =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         );
#& MODIF COMMUN  DATE 02/08/2011   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ABBAS M.ABBAS

def C_SUIVI_DDL() : return FACT(statut='f',max=4,

           NOM_CHAM        =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=1,
                                   into=("DEPL","VITE","ACCE",
                                         "FORC_NODA",
                                         "SIEF_ELGA","VARI_ELGA",)),
          
           EVAL_CHAM       =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max=1,defaut='VALE',
                                   into=("MIN","MAX","MOY","VALE",),),
                                         
           NOM_CMP         =SIMP(statut='o',typ='TXM',max=20),
           EVAL_CMP        =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max=1,defaut='VALE',
                                   into=("VALE","FORMULE",),),
                                   
           b_formule       =BLOC(condition="(EVAL_CMP=='FORMULE')",
                                   FORMULE = SIMP(statut='o',typ=formule,max=1),
                                ),                 
           
           b_cham_no       =BLOC(condition="(NOM_CHAM=='DEPL') or \
                                            (NOM_CHAM=='VITE') or \
                                            (NOM_CHAM=='ACCE') or \
                                            (NOM_CHAM=='FORC_NODA') or \
                                            (NOM_CHAM=='VALE_CONT')",                                 
                                 regles   =(UN_PARMI('NOEUD','GROUP_NO','GROUP_MA','MAILLE','TOUT')),
                                 TOUT            =SIMP(statut='d',typ='TXM',into=("OUI",) ),
                                 NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                                 GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                                 MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                                 GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),   
                                ), 
                                          
           b_cham_elga     =BLOC(condition="(NOM_CHAM=='SIEF_ELGA') or \
                                            (NOM_CHAM=='VARI_ELGA')",
                                 regles          =(UN_PARMI('GROUP_MA','MAILLE','TOUT')), 
                                 TOUT            =SIMP(statut='d',typ='TXM',into=("OUI",) ),          
                                 MAILLE          =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
                                 GROUP_MA        =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max='**'), 
                                 EVAL_ELGA       =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max=1,defaut='VALE',
                                                        into=("MIN","MAX","VALE",),), 
                                 b_elga_vale     =BLOC(condition="(EVAL_ELGA=='VALE')",                     
                                   POINT           =SIMP(statut='o',typ='I'  ,validators=NoRepeat(),max='**'), 
                                   SOUS_POINT      =SIMP(statut='f',typ='I'  ,validators=NoRepeat(),max='**'),  
                                 ),  
                                ), 
             
           TITRE           =  SIMP(statut='f',typ='TXM',max=3),     
       
       
       );
#& MODIF COMMUN  DATE 09/11/2010   AUTEUR GNICOLAS G.NICOLAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2004  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE GNICOLAS G.NICOLAS
#
# ce fichier contient la liste des "into" possibles pour le mot cle TYPE_CHAM
def C_TYPE_CHAM_INTO( type_cham=None ) : #COMMUN#
# Si aucun argument n'est passe, on utilise tous les types de champs possibles
  if ( type_cham is None ) :
    l_cham = ["ELEM", "ELNO", "ELGA", "CART", "NOEU"]
# Sinon, on n'utilise que les types passes en argument
  else :
    l_cham = []
    for typ in type_cham :
      l_cham.append(typ)
#
  l = []
  for gd in C_NOM_GRANDEUR() :
    for typ in l_cham :
      l.append(typ+"_"+gd)
#
  return tuple(l)

#& MODIF COMMANDE  DATE 04/05/2011   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE FLEJOU J-L.FLEJOU
AFFE_CARA_ELEM=OPER(nom="AFFE_CARA_ELEM",op=  19,sd_prod=cara_elem,
   fr="Affectation de caractristiques  des lments de structure",
   reentrant='n',
   UIinfo ={"groupes":("Modlisation",)},
   regles = (AU_MOINS_UN('POUTRE','BARRE','COQUE','CABLE','DISCRET','DISCRET_2D','MASSIF',
                         'GRILLE','MULTIFIBRE','RIGI_PARASOL'),
             PRESENT_PRESENT('MULTIFIBRE','GEOM_FIBRE'),
             EXCLUS('DISCRET','DISCRET_2D'),),
   MODELE = SIMP(statut='o',typ=modele_sdaster ),
   INFO   = SIMP(statut='f',typ='I', defaut= 1 ,into=(1,2) ),
   VERIF  = SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',into=("MAILLE","NOEUD") ),

#  ============================================================================
   POUTRE               = FACT(statut= 'f',max= '**',
      regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
      MAILLE               = SIMP(statut= 'f',typ= ma  ,validators= NoRepeat(),max= '**'),
      GROUP_MA             = SIMP(statut= 'f',typ= grma,validators= NoRepeat(),max= '**'),
      SECTION              = SIMP(statut= 'o',typ= 'TXM' ,into= ("GENERALE","RECTANGLE","CERCLE") ),
      PREC_AIRE            = SIMP(statut= 'f',typ= 'R',defaut= 0.01),
      PREC_INERTIE         = SIMP(statut= 'f',typ= 'R',defaut= 0.1),
      b_generale           = BLOC(condition = "SECTION == 'GENERALE'",
         VARI_SECT            = SIMP(statut= 'f',typ= 'TXM',into= ("CONSTANT","HOMOTHETIQUE"),defaut= "CONSTANT"),
         b_constant           = BLOC(condition = "VARI_SECT == 'CONSTANT'",
            CARA                 = SIMP(statut= 'o',typ= 'TXM',validators= NoRepeat(),min= 4 ,max= 15,
                                       fr= "A,IY,IZ,JX sont des paramtres obligatoires",
                                       into= ("A","IY","IZ","AY","AZ","EY","EZ","JX","RY","RZ","RT",
                                             "JG","IYR2","IZR2","AI") ),
            VALE                    = SIMP(statut= 'o',typ= 'R',min= 4 ,max= 15), ),
         b_homothetique       = BLOC(condition = "VARI_SECT == 'HOMOTHETIQUE'",
            CARA                 = SIMP(statut= 'o',typ= 'TXM',validators= NoRepeat(),min= 8 ,max= 30,
                                       fr= "A1,A2,IY1,IY2,IZ1,IZ2,JX1,JX2 sont des paramtres obligatoires",
                                       into= ("A1","IY1","IZ1","AY1","AZ1","EY1","EZ1","JX1","RY1",
                                             "RZ1","RT1","JG1","IYR21","IZR21","AI1",
                                             "A2","IY2","IZ2","AY2","AZ2","EY2","EZ2","JX2","RY2",
                                             "RZ2","RT2","JG2","IYR22","IZR22","AI2") ),
            VALE                 = SIMP(statut= 'o',typ= 'R',min= 8 ,max= 30),),
      ),
      b_rectangle          = BLOC(condition = "SECTION == 'RECTANGLE'",
         VARI_SECT            = SIMP(statut= 'f',typ= 'TXM',into= ("CONSTANT","HOMOTHETIQUE","AFFINE"),defaut= "CONSTANT"),
         b_constant           = BLOC(condition = "VARI_SECT == 'CONSTANT'",
            CARA                 = SIMP(statut= 'o',typ= 'TXM',validators= NoRepeat(),min= 1 ,max= 4,
                                       into= ("H","EP", "HY","HZ","EPY","EPZ") ),
            VALE                 = SIMP(statut= 'o',typ= 'R',min= 1 ,max= 4), ),
         b_homothetique       = BLOC(condition = "VARI_SECT == 'HOMOTHETIQUE'",
            CARA                 = SIMP(statut= 'o',typ= 'TXM',validators= NoRepeat(),min= 2 ,max= 8,
                                       into= ("H1","HZ1","HY1","EP1","EPY1","EPZ1",
                                          "H2","HZ2","HY2","EP2","EPY2","EPZ2") ),
            VALE                 = SIMP(statut= 'o',typ= 'R',min= 2 ,max= 8), ),
         b_affine             = BLOC(condition = "VARI_SECT == 'AFFINE'",
            CARA                 = SIMP(statut= 'o',typ= 'TXM',validators= NoRepeat(),min= 3 ,max= 6,
                                       into= ("HY","EPY", "HZ1","EPZ1","HZ2","EPZ2") ),
            VALE                 = SIMP(statut= 'o',typ= 'R',min= 3 ,max= 6), ),
      ),
      b_cercle             = BLOC(condition = "SECTION == 'CERCLE'",
         VARI_SECT            = SIMP(statut= 'f',typ= 'TXM',into= ("CONSTANT","HOMOTHETIQUE"),defaut= "CONSTANT"),
         b_constant           = BLOC(condition = "VARI_SECT == 'CONSTANT'",
            CARA                 = SIMP(statut= 'o',typ= 'TXM',validators= NoRepeat(),min= 1 ,max= 2,
                                       fr= "R est un paramtre obligatoire",
                                       into= ("R","EP") ),
            VALE                 = SIMP(statut= 'o',typ= 'R',min= 1 ,max= 2), ),
         b_homothetique       = BLOC(condition = "VARI_SECT == 'HOMOTHETIQUE'",
            CARA                 = SIMP(statut= 'o',typ= 'TXM',validators= NoRepeat(),min= 2 ,max= 4,
                                       fr= "R1, R2 sont des paramtres obligatoires",
                                       into= ("R1","R2","EP1","EP2") ),
            VALE                 = SIMP(statut= 'o',typ= 'R',min= 2 ,max= 4), ),
         MODI_METRIQUE     = SIMP(statut= 'f',typ= 'TXM',defaut= "NON",into= ("OUI","NON") ),
         FCX               = SIMP(statut= 'f',typ= (fonction_sdaster,nappe_sdaster,formule) ),
         TUYAU_NSEC        = SIMP(statut= 'f',typ= 'I',val_max= 32,defaut= 16),
         TUYAU_NCOU        = SIMP(statut= 'f',typ= 'I',val_max= 10,defaut= 3),
      ),
   ),

#  ============================================================================
   BARRE                = FACT(statut='f',max='**',
      regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      SECTION              = SIMP(statut='o',typ='TXM',into=("GENERALE","RECTANGLE","CERCLE") ),
      b_generale           = BLOC(condition = "SECTION=='GENERALE'",
         CARA                 = SIMP(statut='o',typ='TXM',into=("A",) ),
         VALE                 = SIMP(statut='o',typ='R',min=1,max=1 ), ),
      b_rectangle          = BLOC(condition = "SECTION=='RECTANGLE'",
         CARA                 = SIMP(statut='o',typ='TXM',
                                    into=("H","EP","HZ","HY","EPY","EPZ"),
                                    validators=NoRepeat(),min=1,max=4 ),
         VALE                 = SIMP(statut='o',typ='R',min=1,max=4 ), ),
      b_cercle             =  BLOC(condition = "SECTION=='CERCLE'",
         CARA                 = SIMP(statut='o',typ='TXM',validators=NoRepeat(),min=1,max=2,into=("R","EP") ),
         VALE                 = SIMP(statut='o',typ='R',min=1,max=2 ), ),
      FCX                  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
   ),

#  ============================================================================
   COQUE                = FACT(statut='f',max='**',
      regles               = (UN_PARMI('MAILLE','GROUP_MA' ),
                              PRESENT_PRESENT( 'EXCENTREMENT','INER_ROTA' ),
                              AU_MOINS_UN('EPAIS','EPAIS_F',),
                              PRESENT_ABSENT('EPAIS','EPAIS_F',),
                              EXCLUS('ANGL_REP','VECTEUR'),),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      EPAIS                = SIMP(statut='f',typ='R' ),
      EPAIS_F              = SIMP(statut='f',typ=(para_sensi,),min=1 ,max=1 ),
      ANGL_REP             = SIMP(statut='f',typ='R',min=2,max=2),
      VECTEUR              = SIMP(statut='f',typ='R',min=3,max=3),
      A_CIS                = SIMP(statut='f',typ='R',defaut= 0.8333333E0),
      COEF_RIGI_DRZ        = SIMP(statut='f',typ='R',defaut= 1.0E-5 ),
      COQUE_NCOU           = SIMP(statut='f',typ='I',defaut= 1 ),
      EXCENTREMENT         = SIMP(statut='f',typ='R' ),
      INER_ROTA            = SIMP(statut='f',typ='TXM',into=("OUI",) ),
      MODI_METRIQUE        = SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
   ),

#  ============================================================================
   CABLE                = FACT(statut='f',max='**',
      regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      N_INIT               = SIMP(statut='f',typ='R',defaut= 5000. ),
      SECTION              = SIMP(statut='f',typ='R' ),
      FCX                  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
   ),

#  ============================================================================
   DISCRET              = FACT(statut='f',max='**',
      REPERE               = SIMP(statut='f',typ='TXM',into=("LOCAL","GLOBAL") ),
      AMOR_HYST            = SIMP(statut='f',typ='R' ),

      SYME                 = SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON"),),
      b_SYME_OUI           = BLOC(condition="SYME=='OUI'",
         fr="SYMETRIQUE: Affectation de matrices de rigidit, de masse ou d'amortissement  des mailles ou noeuds",
         CARA                 = SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=1,defaut="None",
            into=("K_T_D_N", "K_T_D_L", "K_TR_D_N", "K_TR_D_L", "K_T_N", "K_T_L", "K_TR_N", "K_TR_L",
                  "M_T_D_N",            "M_TR_D_N",             "M_T_N", "M_T_L", "M_TR_N", "M_TR_L",
                  "A_T_D_N", "A_T_D_L", "A_TR_D_N", "A_TR_D_L", "A_T_N", "A_T_L", "A_TR_N", "A_TR_L",),),
         #  Affection des caractristiques de RIGIDITE/AMORTISSEMENT/MASSE
         b_AK_T_D_N            = BLOC(condition = "((CARA=='K_T_D_N')or(CARA=='A_T_D_N'))",
            fr="NOEUD: 3 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=3 ,max=3 ),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=3 ,max=3 ),),
         b_AK_T_D_L            = BLOC(condition = "((CARA=='K_T_D_L')or(CARA=='A_T_D_L'))",
            fr="SEGMENT: 3 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                                    UN_PARMI('VALE','VALE_F'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=3 ,max=3 ),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=3 ,max=3 ),),
         b_AK_TR_D_N           = BLOC(condition = "((CARA=='K_TR_D_N')or(CARA=='A_TR_D_N'))",
            fr="NOEUD: 6 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=6 ,max=6 ),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=6 ,max=6 ),),
         b_AK_TR_D_L           = BLOC(condition = "((CARA=='K_TR_D_L')or(CARA=='A_TR_D_L'))",
            fr="SEGMENT: 6 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                                    UN_PARMI('VALE','VALE_F'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=6 ,max=6 ),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=6 ,max=6 ),),
         b_MAK_T_N              = BLOC(condition = "((CARA=='K_T_N')or(CARA=='A_T_N')or(CARA=='M_T_N'))",
            fr="NOEUD: 6 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=6 ,max=6 ),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=6 ,max=6 ),),
         b_MAK_T_L              = BLOC(condition = "((CARA=='K_T_L')or(CARA=='A_T_L')or(CARA=='M_T_L'))",
            fr="SEGMENT: 21 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                                    UN_PARMI('VALE','VALE_F'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=21,max=21),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=21 ,max=21 ),),
         b_MAK_TR_N             = BLOC(condition = "((CARA=='K_TR_N')or(CARA=='A_TR_N')or(CARA=='M_TR_N'))",
            fr="NOEUD: 21 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=21,max=21),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=21 ,max=21 ),),
         b_MAK_TR_L             = BLOC(condition = "((CARA=='K_TR_L')or(CARA=='A_TR_L')or(CARA=='M_TR_L'))",
            fr="SEGMENT: 78 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                                    UN_PARMI('VALE','VALE_F'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=78,max=78),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=78 ,max=78 ),),
         #  Affection des caractristiques de MASSE
         b_M_T_D_N           = BLOC(condition = "(CARA=='M_T_D_N')",
            fr="NOEUD: 1 valeur de masse",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=1 ,max=1 ),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=1 ,max=1 ),),
         b_M_TR_D_N           = BLOC(condition = "(CARA=='M_TR_D_N')",
            fr="NOEUD: 1 valeur de masse, 6 valeurs du tenseur d'inertie, 3 composantes du vecteur d'excentrement",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=10,max=10),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=10 ,max=10 ),),
      ),
      #     lments  matrice non-symtrique
      #        b_MAK_T_N_NS       'K_T_N'     'A_T_N'    'M_T_N'
      #        b_MAK_T_L_NS       'K_T_L'     'A_T_L'    'M_T_L'
      #        b_MAK_TR_N_NS      'K_TR_N'    'A_TR_N'   'M_TR_N'
      #        b_MAK_TR_L_NS      'K_TR_L'    'A_TR_L'   'M_TR_L'
      b_SYME_NON           = BLOC(condition="SYME=='NON'",
         fr="NON-SYMETRIQUE: Affectation de matrices de rigidit, de masse ou d'amortissement  des mailles ou noeuds",
         CARA                 = SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=1,defaut="None",
            into=("K_T_N", "K_T_L", "K_TR_N", "K_TR_L",
                  "M_T_N", "M_T_L", "M_TR_N", "M_TR_L",
                  "A_T_N", "A_T_L", "A_TR_N", "A_TR_L",),),
         #  Affection des caractristiques de RIGIDITE/AMORTISSEMENT/MASSE : NON-SYMETRIQUE
         b_MAK_T_N_NS           = BLOC(condition = "((CARA=='K_T_N')or(CARA=='A_T_N')or(CARA=='M_T_N'))",
            fr="NOEUD: 9 valeurs (matrice pleine par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=9 ,max=9 ),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=9 ,max=9 ),),
         b_MAK_T_L_NS           = BLOC(condition = "((CARA=='K_T_L')or(CARA=='A_T_L')or(CARA=='M_T_L'))",
            fr="SEGMENT: 36 valeurs (matrice pleine par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                                    UN_PARMI('VALE','VALE_F'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=36,max=36),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=36 ,max=36 ),),
         b_MAK_TR_N_NS          = BLOC(condition = "((CARA=='K_TR_N')or(CARA=='A_TR_N')or(CARA=='M_TR_N'))",
            fr="NOEUD: 36 valeurs (matrice pleine par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=36,max=36),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=36 ,max=36 ),),
         b_MAK_TR_L_NS          = BLOC(condition = "((CARA=='K_TR_L')or(CARA=='A_TR_L')or(CARA=='M_TR_L'))",
            fr="SEGMENT: 144 valeurs (matrice pleine par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                                    UN_PARMI('VALE','VALE_F'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=144,max=144),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=144 ,max=144 ),),
      ),
   ),
#  ============================================================================
   DISCRET_2D           = FACT(statut='f',max='**',
      REPERE               = SIMP(statut='f',typ='TXM',into=("LOCAL","GLOBAL") ),
      AMOR_HYST            = SIMP(statut='f',typ='R' ),
      SYME                 = SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON"),),
      b_SYME_OUI           = BLOC(condition="SYME=='OUI'",
         fr="SYMETRIQUE: Affectation de matrices de rigidit, de masse ou d'amortissement  des mailles ou noeuds",
         CARA                 = SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=1,defaut="None",
            into=("K_T_D_N", "K_T_D_L", "K_TR_D_N", "K_TR_D_L", "K_T_N", "K_T_L", "K_TR_N", "K_TR_L",
                  "M_T_D_N",            "M_TR_D_N",             "M_T_N", "M_T_L", "M_TR_N", "M_TR_L",
                  "A_T_D_N", "A_T_D_L", "A_TR_D_N", "A_TR_D_L", "A_T_N", "A_T_L", "A_TR_N", "A_TR_L",),),
         #  Affection des caractristiques de RIGIDITE/AMORTISSEMENT/MASSE
         b_AK_T_D_N            = BLOC(condition = "((CARA=='K_T_D_N')or(CARA=='A_T_D_N'))",
            fr="NOEUD: 2 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=2 ,max=2 ),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=2 ,max=2 ),),
         b_AK_T_D_L            = BLOC(condition = "((CARA=='K_T_D_L')or(CARA=='A_T_D_L'))",
            fr="SEGMENT: 2 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                                    UN_PARMI('VALE','VALE_F'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=2 ,max=2 ),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=2 ,max=2 ),),
         b_AK_TR_D_N           = BLOC(condition = "((CARA=='K_TR_D_N')or(CARA=='A_TR_D_N'))",
            fr="NOEUD: 3 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=3 ,max=3 ),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=3 ,max=3 ),),
         b_AK_TR_D_L           = BLOC(condition = "((CARA=='K_TR_D_L')or(CARA=='A_TR_D_L'))",
            fr="SEGMENT: 3 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                                    UN_PARMI('VALE','VALE_F'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=3 ,max=3 ),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=3 ,max=3 ),),
         b_MAK_T_N              = BLOC(condition = "((CARA=='K_T_N')or(CARA=='A_T_N')or(CARA=='M_T_N'))",
            fr="NOEUD: 3 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=3 ,max=3 ),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=3 ,max=3 ),),
         b_MAK_T_L              = BLOC(condition = "((CARA=='K_T_L')or(CARA=='A_T_L')or(CARA=='M_T_L'))",
            fr="SEGMENT: 10 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                                    UN_PARMI('VALE','VALE_F'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=10,max=10),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=10 ,max=10 ),),
         b_MAK_TR_N             = BLOC(condition = "((CARA=='K_TR_N')or(CARA=='A_TR_N')or(CARA=='M_TR_N'))",
            fr="NOEUD: 6 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=6 ,max=6),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=6 ,max=6 ),),
         b_MAK_TR_L             = BLOC(condition = "((CARA=='K_TR_L')or(CARA=='A_TR_L')or(CARA=='M_TR_L'))",
            fr="SEGMENT: 21 valeurs (triangulaire suprieure par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                                    UN_PARMI('VALE','VALE_F'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=21,max=21),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=21 ,max=21 ),),
         #  Affection des caractristiques de MASSE
         b_M_T_D_N            = BLOC(condition = "(CARA=='M_T_D_N')",
            fr="NOEUD: 1 valeur de masse",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=1 ,max=1 ),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=1 ,max=1 ),),
         b_M_TR_D_N           = BLOC(condition = "(CARA=='M_TR_D_N')",
            fr="NOEUD: 1 valeur de masse (m), 1 valeur d'inertie (Izz), 2 composantes du vecteur d'excentrement",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=4 ,max=4 ),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=4 ,max=4 ),),
      ),
      #     lments  matrice non-symtrique
      #        b_MAK_T_N_NS       'K_T_N'     'A_T_N'    'M_T_N'
      #        b_MAK_T_L_NS       'K_T_L'     'A_T_L'    'M_T_L'
      #        b_MAK_TR_N_NS      'K_TR_N'    'A_TR_N'   'M_TR_N'
      #        b_MAK_TR_L_NS      'K_TR_L'    'A_TR_L'   'M_TR_L'
      b_SYME_NON           = BLOC(condition="SYME=='NON'",
         fr="NON-SYMETRIQUE: Affectation de matrices de rigidit, de masse ou d'amortissement  des mailles ou noeuds",
         CARA                 = SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=1,defaut="None",
            into=("K_T_N", "K_T_L", "K_TR_N", "K_TR_L",
                  "M_T_N", "M_T_L", "M_TR_N", "M_TR_L",
                  "A_T_N", "A_T_L", "A_TR_N", "A_TR_L",),),
         #  Affection des caractristiques de RIGIDITE/AMORTISSEMENT/MASSE : NON-SYMETRIQUE
         b_MAK_T_N_NS           = BLOC(condition = "((CARA=='K_T_N')or(CARA=='A_T_N')or(CARA=='M_T_N'))",
            fr="NOEUD: 4 valeurs (matrice pleine par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=4 ,max=4 ),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=4 ,max=4 ),),
         b_MAK_T_L_NS           = BLOC(condition = "((CARA=='K_T_L')or(CARA=='A_T_L')or(CARA=='M_T_L'))",
            fr="SEGMENT: 16 valeurs (matrice pleine par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                                    UN_PARMI('VALE','VALE_F'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=16,max=16),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=16 ,max=16 ),),
         b_MAK_TR_N_NS          = BLOC(condition = "((CARA=='K_TR_N')or(CARA=='A_TR_N')or(CARA=='M_TR_N'))",
            fr="NOEUD: 9 valeurs (matrice pleine par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO'),
                                    UN_PARMI('VALE','VALE_F'),),
            NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=9 ,max=9),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=9 ,max=9 ),),
         b_MAK_TR_L_NS          = BLOC(condition = "((CARA=='K_TR_L')or(CARA=='A_TR_L')or(CARA=='M_TR_L'))",
            fr="SEGMENT: 36 valeurs (matrice pleine par colonne)",
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                                    UN_PARMI('VALE','VALE_F'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='f',typ='R',min=36,max=36),
            VALE_F               = SIMP(statut='f',typ=(para_sensi,),min=36 ,max=36 ),),
      ),
   ),
#  ============================================================================
   ORIENTATION          = FACT(statut='f',max='**',
      regles               = (UN_PARMI('MAILLE','GROUP_MA','NOEUD','GROUP_NO' ),),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      NOEUD                = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
      GROUP_NO             = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
      CARA                 = SIMP(statut='o',typ='TXM',
                                 into=("VECT_Y","ANGL_VRIL","VECT_X_Y","ANGL_NAUT","GENE_TUYAU") ),
      VALE                 = SIMP(statut='o',typ='R',max='**'),
      PRECISION            = SIMP(statut='f',typ='R',defaut= 1.0E-4 ),
      CRITERE              = SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
   ),

# ============================================================================
   DEFI_ARC             = FACT(statut='f',max='**',
      regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                              UN_PARMI('ORIE_ARC','CENTRE','NOEUD_CENTRE','GROUP_NO_CENTRE',
                                       'POIN_TANG','NOEUD_POIN_TANG','GROUP_NO_POIN_TG'),
                              PRESENT_PRESENT('ORIE_ARC','RAYON'),
                              EXCLUS('COEF_FLEX','COEF_FLEX_XY'),
                              EXCLUS('COEF_FLEX','COEF_FLEX_XZ'),
                              EXCLUS('INDI_SIGM','INDI_SIGM_XY'),
                              EXCLUS('INDI_SIGM','INDI_SIGM_XZ'),
                              PRESENT_PRESENT('COEF_FLEX_XY','COEF_FLEX_XZ'),
                              PRESENT_PRESENT('INDI_SIGM_XY','INDI_SIGM_XZ'),),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      ORIE_ARC             = SIMP(statut='f',typ='R'),
      CENTRE               = SIMP(statut='f',typ='R',max='**'),
      NOEUD_CENTRE         = SIMP(statut='f',typ=no),
      GROUP_NO_CENTRE      = SIMP(statut='f',typ=grno),
      POIN_TANG            = SIMP(statut='f',typ='R',max='**'),
      NOEUD_POIN_TANG      = SIMP(statut='f',typ=no),
      GROUP_NO_POIN_TG     = SIMP(statut='f',typ=grno),
      RAYON                = SIMP(statut='f',typ='R'),
      COEF_FLEX            = SIMP(statut='f',typ='R'),
      INDI_SIGM            = SIMP(statut='f',typ='R'),
      COEF_FLEX_XY         = SIMP(statut='f',typ='R'),
      INDI_SIGM_XY         = SIMP(statut='f',typ='R'),
      COEF_FLEX_XZ         = SIMP(statut='f',typ='R'),
      INDI_SIGM_XZ         = SIMP(statut='f',typ='R'),
      PRECISION            = SIMP(statut='f',typ='R',defaut= 1.0E-3),
      CRITERE              = SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
   ),

#============================================================================
   MASSIF               = FACT(statut='f',max='**',
      regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                              UN_PARMI('ANGL_REP','ANGL_AXE','ANGL_EULER'),
                              EXCLUS('ANGL_REP','ANGL_EULER'),
                              EXCLUS('ANGL_REP','ANGL_AXE'),
                              EXCLUS('ANGL_REP','ORIG_AXE'),
                              PRESENT_PRESENT('ANGL_AXE','ORIG_AXE'), ),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      ANGL_REP             = SIMP(statut='f',typ='R',max=3),
      ANGL_EULER           = SIMP(statut='f',typ='R',min=3,max=3),
      ANGL_AXE             = SIMP(statut='f',typ='R',max=2),
      ORIG_AXE             = SIMP(statut='f',typ='R',max=3),
   ),

#  ============================================================================
   POUTRE_FLUI          = FACT(statut='f',max='**',
      regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      B_T                  = SIMP(statut='o',typ='R'),
      B_N                  = SIMP(statut='o',typ='R'),
      B_TN                 = SIMP(statut='o',typ='R',defaut= 0.E+0 ),
      A_FLUI               = SIMP(statut='o',typ='R'),
      A_CELL               = SIMP(statut='o',typ='R'),
      COEF_ECHELLE         = SIMP(statut='o',typ='R'),
   ),

#  ============================================================================
   GRILLE               = FACT(statut='f',max='**',
      regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                              EXCLUS('ANGL_REP','ORIG_AXE'),
                              ENSEMBLE('ORIG_AXE','AXE')),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      SECTION              = SIMP(statut='o',typ='R'),
      ANGL_REP             = SIMP(statut='f',typ='R',max=2),
      EXCENTREMENT         = SIMP(statut='f',typ='R'),
      ORIG_AXE             = SIMP(statut='f',typ='R',max='**'),
      AXE                  = SIMP(statut='f',typ='R',max='**'),
      COEF_RIGI_DRZ        = SIMP(statut='f',typ='R',defaut= 1.0E-10 ),
      GRILLE_NCOU          = SIMP(statut='f',typ='I',defaut= 1,),
   ),

#============================================================================
   RIGI_PARASOL         = FACT(statut='f',max='**',
      regles               = (UN_PARMI('COEF_GROUP','FONC_GROUP'),
                              UN_PARMI('COOR_CENTRE','NOEUD_CENTRE','GROUP_NO_CENTRE'),
                              EXCLUS('GROUP_MA_POI1','GROUP_MA_SEG2'),),
      GROUP_MA             = SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**',
         fr="Surface servant  rpartir les caractristiques des discrets"),
      GROUP_MA_POI1        = SIMP(statut='f',typ=grma,validators=NoRepeat(),max=1,
         fr="Mailles de type point correspondant aux discrets"),
      GROUP_MA_SEG2        = SIMP(statut='f',typ=grma,validators=NoRepeat(),max=1,
         fr="Mailles de type seg2 correspondant aux discrets"),
      FONC_GROUP           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
      COEF_GROUP           = SIMP(statut='f',typ='R',max='**'),
      REPERE               = SIMP(statut='f',typ='TXM',into=("LOCAL","GLOBAL") ),
      CARA                 = SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=2,
                                 into=("K_TR_D_N","K_T_D_N","K_TR_D_L","K_T_D_L",
                                       "A_TR_D_N","A_T_D_N","A_TR_D_L","A_T_D_L"),
                                 fr="Choix des types de discrets du tapis de ressorts." ),
      b_cara= BLOC(condition =""" (CARA in ["K_TR_D_N","K_T_D_N","K_TR_D_L","K_T_D_L",
                                            "A_TR_D_N","A_T_D_N","A_TR_D_L","A_T_D_L"]) or \
                                  (len(CARA)==2 and CARA[0][2:]==CARA[1][2:]) """,
                   fr="Valeurs pour les discrets du tapis de ressorts.",
         VALE = SIMP(statut='o',typ='R',max='**',
              fr="Valeurs pour les discrets du tapis de ressorts.",),
      ),
      GROUP_NO_CENTRE      = SIMP(statut='f',typ=grno),
      NOEUD_CENTRE         = SIMP(statut='f',typ=no),
      COOR_CENTRE          = SIMP(statut='f',typ='R',min=2,max=3),
      EUROPLEXUS           = SIMP(statut='f',typ='TXM',into=("OUI","NON"),defaut="NON"),
      UNITE                = SIMP(statut='f',typ='I',val_min=1),
   ),

#============================================================================
   RIGI_MISS_3D         = FACT(statut='f',max='**',
      GROUP_MA_POI1        = SIMP(statut='o',typ=grma,max=1),
      GROUP_MA_SEG2        = SIMP(statut='f',typ=grma,max=1),
      FREQ_EXTR            = SIMP(statut='o',typ='R',max=1),
      UNITE_RESU_IMPE      = SIMP(statut='f',typ='I',defaut=30),
   ),

#============================================================================
   GEOM_FIBRE           = SIMP(statut='f',max=1,typ=gfibre_sdaster,
      fr="Donner le nom de la SD regroupant tous les groupes de fibres (issue de DEFI_GEOM_FIBRE)"),
   MULTIFIBRE           = FACT(statut='f',max='**',
      regles               = (AU_MOINS_UN('GROUP_MA','MAILLE'),),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_FIBRE          = SIMP(statut='o',typ='TXM',max='**'),
   ),
);
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE None
AFFE_CHAR_ACOU=OPER(nom="AFFE_CHAR_ACOU",op=  68,sd_prod=char_acou,
                    fr="Affectation de charges et conditions aux limites acoustiques constantes",
                    reentrant='n',
            UIinfo={"groupes":("Chargements","Acoustique",)},
         regles=(AU_MOINS_UN('PRES_IMPO','VITE_FACE','IMPE_FACE','LIAISON_UNIF' ),),
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         VERI_DDL        =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         METHODE         =SIMP(statut='c',typ='TXM',fr="Stratgie de rsolution pour les pressions imposes",
                               into=('DUALISATION',),defaut='DUALISATION',),
                               # METHODE='ELIMINATION' est trait dans le fortran mais dangereux actuellement
         PRES_IMPO       =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           PRES            =SIMP(statut='o',typ='C' ),
         ),
         VITE_FACE       =FACT(statut='f',max='**',
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           VNOR            =SIMP(statut='o',typ='C' ),
         ),
         IMPE_FACE       =FACT(statut='f',max='**',
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           IMPE            =SIMP(statut='o',typ='C' ),
         ),
         LIAISON_UNIF    =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE' ),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           DDL             =SIMP(statut='o',typ='TXM',max='**'),
         ),
)  ;
#& MODIF COMMANDE  DATE 01/03/2011   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
def affe_char_cine_prod(MECA_IMPO,THER_IMPO,ACOU_IMPO,EVOL_IMPO,**args):
  if MECA_IMPO != None  : return char_cine_meca
  if THER_IMPO != None  : return char_cine_ther
  if ACOU_IMPO != None  : return char_cine_acou
  if EVOL_IMPO != None  :
      if AsType(EVOL_IMPO) in (evol_elas,evol_noli) :
          return char_cine_meca
      elif AsType(EVOL_IMPO) in (evol_ther,) :
          return char_cine_ther
      else :
          raise AsException("Extension  faire ...")

  raise AsException("type de concept resultat non prevu")


AFFE_CHAR_CINE=OPER(nom="AFFE_CHAR_CINE",op= 101,sd_prod=affe_char_cine_prod
                    ,fr="Affectation de conditions aux limites cinmatiques (U=U0) pour un traitement sans dualisation",
                     reentrant='n',
            UIinfo={"groupes":("Chargements","Mcanique",)},
         regles=(UN_PARMI('MECA_IMPO','THER_IMPO','ACOU_IMPO','EVOL_IMPO'),
                 ),
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),

         MECA_IMPO       =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                   AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI',
                               'TEMP','PRE1','PRE2','UI2','UI3','VI2','VI3','WI2','WI3','UO2',
                               'UO3','VO2','VO3','WO2','WO3','UI4','UI5','VI4','VI5','WI4',
                               'WI5','UO4','UO5','VO4','VO5','WO4','WO5','UI6','UO6','VI6',
                               'VO6','WI6','WO6','WO','WI1','WO1','GONF',
                               'H1X','H1Y','H1Z','E1X','E1Y','E1Z','E2X','E2Y','E2Z',
                               'E3X','E3Y','E3Z','E4X','E4Y','E4Z','V11','V12','V13','V21','V22',
                               'V23','V31','V32','V33','PRES11','PRES12','PRES13','PRES21',
                               'PRES22','PRES23','PRES31','PRES32','PRES33','LH1'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             DX              =SIMP(statut='f',typ='R' ),
             DY              =SIMP(statut='f',typ='R' ),
             DZ              =SIMP(statut='f',typ='R' ),
             DRX             =SIMP(statut='f',typ='R' ),
             DRY             =SIMP(statut='f',typ='R' ),
             DRZ             =SIMP(statut='f',typ='R' ),
             GRX             =SIMP(statut='f',typ='R' ),
             PRES            =SIMP(statut='f',typ='R' ),
             PHI             =SIMP(statut='f',typ='R' ),
             TEMP            =SIMP(statut='f',typ='R' ),
             PRE1            =SIMP(statut='f',typ='R' ),
             PRE2            =SIMP(statut='f',typ='R' ),
             UI2             =SIMP(statut='f',typ='R' ),
             UI3             =SIMP(statut='f',typ='R' ),
             UI4             =SIMP(statut='f',typ='R' ),
             UI5             =SIMP(statut='f',typ='R' ),
             UI6             =SIMP(statut='f',typ='R' ),
             UO2             =SIMP(statut='f',typ='R' ),
             UO3             =SIMP(statut='f',typ='R' ),
             UO4             =SIMP(statut='f',typ='R' ),
             UO5             =SIMP(statut='f',typ='R' ),
             UO6             =SIMP(statut='f',typ='R' ),
             VI2             =SIMP(statut='f',typ='R' ),
             VI3             =SIMP(statut='f',typ='R' ),
             VI4             =SIMP(statut='f',typ='R' ),
             VI5             =SIMP(statut='f',typ='R' ),
             VI6             =SIMP(statut='f',typ='R' ),
             VO2             =SIMP(statut='f',typ='R' ),
             VO3             =SIMP(statut='f',typ='R' ),
             VO4             =SIMP(statut='f',typ='R' ),
             VO5             =SIMP(statut='f',typ='R' ),
             VO6             =SIMP(statut='f',typ='R' ),
             WI2             =SIMP(statut='f',typ='R' ),
             WI3             =SIMP(statut='f',typ='R' ),
             WI4             =SIMP(statut='f',typ='R' ),
             WI5             =SIMP(statut='f',typ='R' ),
             WI6             =SIMP(statut='f',typ='R' ),
             WO2             =SIMP(statut='f',typ='R' ),
             WO3             =SIMP(statut='f',typ='R' ),
             WO4             =SIMP(statut='f',typ='R' ),
             WO5             =SIMP(statut='f',typ='R' ),
             WO6             =SIMP(statut='f',typ='R' ),
             WO              =SIMP(statut='f',typ='R' ),
             WI1             =SIMP(statut='f',typ='R' ),
             WO1             =SIMP(statut='f',typ='R' ),
             GONF            =SIMP(statut='f',typ='R' ),
             H1X             =SIMP(statut='f',typ='R' ),
             H1Y             =SIMP(statut='f',typ='R' ),
             H1Z             =SIMP(statut='f',typ='R' ),
             E1X             =SIMP(statut='f',typ='R' ),
             E1Y             =SIMP(statut='f',typ='R' ),
             E1Z             =SIMP(statut='f',typ='R' ),
             E2X             =SIMP(statut='f',typ='R' ),
             E2Y             =SIMP(statut='f',typ='R' ),
             E2Z             =SIMP(statut='f',typ='R' ),
             E3X             =SIMP(statut='f',typ='R' ),
             E3Y             =SIMP(statut='f',typ='R' ),
             E3Z             =SIMP(statut='f',typ='R' ),
             E4X             =SIMP(statut='f',typ='R' ),
             E4Y             =SIMP(statut='f',typ='R' ),
             E4Z             =SIMP(statut='f',typ='R' ),
             V11             =SIMP(statut='f',typ='R' ),
             V12             =SIMP(statut='f',typ='R' ),
             V13             =SIMP(statut='f',typ='R' ),
             V21             =SIMP(statut='f',typ='R' ),
             V22             =SIMP(statut='f',typ='R' ),
             V23             =SIMP(statut='f',typ='R' ),
             V31             =SIMP(statut='f',typ='R' ),
             V32             =SIMP(statut='f',typ='R' ),
             V33             =SIMP(statut='f',typ='R' ),
             PRES11          =SIMP(statut='f',typ='R' ),
             PRES12          =SIMP(statut='f',typ='R' ),
             PRES13          =SIMP(statut='f',typ='R' ),
             PRES21          =SIMP(statut='f',typ='R' ),
             PRES22          =SIMP(statut='f',typ='R' ),
             PRES23          =SIMP(statut='f',typ='R' ),
             PRES31          =SIMP(statut='f',typ='R' ),
             PRES32          =SIMP(statut='f',typ='R' ),
             PRES33          =SIMP(statut='f',typ='R' ),
             LH1             =SIMP(statut='f',typ='R' ),
         ),

         THER_IMPO       =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                   AU_MOINS_UN('TEMP','TEMP_INF','TEMP_SUP'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           TEMP_SUP        =SIMP(statut='f',typ='R' ),
           TEMP            =SIMP(statut='f',typ='R' ),
           TEMP_INF        =SIMP(statut='f',typ='R' ),
         ),

         ACOU_IMPO       =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           PRES            =SIMP(statut='o',typ='C' ),
         ),

         EVOL_IMPO  =SIMP(statut='f',typ=(evol_noli,evol_elas,evol_ther),fr="Pour imposer les ddls d'un evol_xxx"),
         b_evol_impo = BLOC ( condition = "EVOL_IMPO != None",
           NOM_CMP         =SIMP(statut='f',typ='TXM',max='**',), # pour n'imposer que certaines CMPS (par dfaut : toutes)
         ),

         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
def affe_char_cine_f_prod(MECA_IMPO,THER_IMPO,**args):
  if MECA_IMPO != None  : return char_cine_meca
  if THER_IMPO != None  : return char_cine_ther
  raise AsException("type de concept resultat non prevu")

AFFE_CHAR_CINE_F=OPER(nom="AFFE_CHAR_CINE_F",op= 101,sd_prod=affe_char_cine_f_prod,
                      fr="Affectation de conditions aux limites cinmatiques fonction d'un (ou plusieurs) paramtres"
                        +" pour un traitement sans dualisation",
                     reentrant='n',
            UIinfo={"groupes":("Chargements","Mcanique",)},
         regles=(UN_PARMI('MECA_IMPO','THER_IMPO')),
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         MECA_IMPO       =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                   AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI',
                               'TEMP','PRE1','PRE2','UI2','UI3','VI2','VI3','WI2','WI3','UO2',
                               'UO3','VO2','VO3','WO2','WO3','UI4','UI5','VI4','VI5','WI4',
                               'WI5','UO4','UO5','VO4','VO5','WO4','WO5','UI6','UO6','VI6',
                               'VO6','WI6','WO6','WO','WI1','WO1','GONF',
                               'H1X','H1Y','H1Z','E1X','E1Y','E1Z','E2X','E2Y','E2Z',
                               'E3X','E3Y','E3Z','E4X','E4Y','E4Z','V11','V12','V13','V21','V22',
                               'V23','V31','V32','V33','PRES11','PRES12','PRES13','PRES21',
                               'PRES22','PRES23','PRES31','PRES32','PRES33','LH1'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           DX    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DY    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DZ    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRX   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRY   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRZ   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           GRX   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PHI   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRE1  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRE2  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           UI2   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           UI3   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           UI4   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           UI5   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           UI6   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           UO2   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           UO3   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           UO4   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           UO5   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           UO6   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VI2   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VI3   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VI4   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VI5   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VI6   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VO2   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VO3   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VO4   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VO5   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VO6   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           WI2   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           WI3   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           WI4   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           WI5   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           WI6   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           WO2   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           WO3   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           WO4   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           WO5   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           WO6   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           WO    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           WI1   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           WO1   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           GONF  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           H1X   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           H1Y   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           H1Z   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E1X   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E1Y   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E1Z   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E2X   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E2Y   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E2Z   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E3X   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E3Y   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E3Z   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E4X   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E4Y   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E4Z   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           V11   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           V12   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           V13   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           V21   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           V22   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           V23   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           V31   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           V32   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           V33   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES11=SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES12=SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES13=SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES21=SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES22=SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES23=SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES31=SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES32=SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES33=SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           LH1   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),

         ),
         THER_IMPO       =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                   AU_MOINS_UN('TEMP','TEMP_INF','TEMP_SUP' ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           TEMP_SUP        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP_INF        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 04/05/2011   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
AFFE_CHAR_MECA=OPER(nom="AFFE_CHAR_MECA",op=   7,sd_prod=char_meca,
                    fr="Affectation de charges et conditions aux limites mcaniques constantes",
                     reentrant='n',
            UIinfo={"groupes":("Chargements","Mcanique",)},
         regles=(AU_MOINS_UN('DDL_IMPO','FACE_IMPO','CHAMNO_IMPO','LIAISON_DDL','LIAISON_XFEM','FORCE_NODALE',
                             'FORCE_FACE','FORCE_ARETE','FORCE_CONTOUR','FORCE_INTERNE',
                             'PRES_REP','FORCE_POUTRE','FORCE_COQUE','LIAISON_OBLIQUE',
                             'FORCE_ELEC','INTE_ELEC','PESANTEUR','ROTATION','IMPE_FACE',
                             'VITE_FACE','RELA_CINE_BP','EPSI_INIT',
                             'LIAISON_GROUP','LIAISON_UNIF','FLUX_THM_REP','LIAISON_SOLIDE',
                             'LIAISON_ELEM','ONDE_FLUI','LIAISON_CHAMNO','VECT_ASSE','LIAISON_COQUE',
                             'LIAISON_MAIL','LIAISON_CYCL','FORCE_TUYAU',
                             'EFFE_FOND','EVOL_CHAR','DDL_POUTRE',),
                         ),
         VERI_NORM       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         MODELE          =SIMP(statut='o',typ=(modele_sdaster) ),
         EVOL_CHAR       =SIMP(statut='f',fr="Champ de pression issu d'un autre calcul",
                               typ=evol_char ),

         PESANTEUR       =FACT(statut='f',max=1,fr="Champ de pesanteur",
            GROUP_MA         =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            MAILLE           =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GRAVITE          =SIMP(statut='o',typ='R',min=1,max=1),
            DIRECTION        =SIMP(statut='o',typ='R',min=3,max=3),),

         METHODE         =SIMP(statut='c',typ='TXM',fr="Stratgie de rsolution pour les dplacements imposs",
                               into=('DUALISATION',),defaut='DUALISATION',),
                               # METHODE='ELIMINATION' est trait dans le fortran mais dangereux actuellement

         ROTATION        =FACT(statut='f', max=1, fr="Dfinition d'un chargement de rotation",
                       GROUP_MA = SIMP(statut='f',typ=grma,validators=NoRepeat(), max='**'),
                       MAILLE   = SIMP(statut='f',typ=ma, validators=NoRepeat(),max='**'),
                       VITESSE  = SIMP(statut='o', typ='R',min=1,max=1),
                       AXE      = SIMP(statut='o', typ='R',min=2, max=3),
                       CENTRE   = SIMP(statut='f',typ='R',defaut=(0.,0.,0.),max=3),
         b_rotation_tout=BLOC(condition="(GROUP_MA == None) and (MAILLE ==None)",
                       TOUT     = SIMP(statut='f',typ='TXM',into=("OUI",),defaut="OUI",),),
         b_rotation=BLOC(condition="(GROUP_MA != None) or (MAILLE !=None)",
                       TOUT     = SIMP(statut='f',typ='TXM',into=("NON","OUI"),defaut="NON",),),),

         DDL_IMPO        =FACT(statut='f',max='**',
             fr="Impose  des noeuds une ou plusieurs valeurs de dplacement (ou de certaines grandeurs asscocies)",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                     AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI',
                                 'TEMP','PRE1','PRE2','UI2','UI3','VI2','VI3','WI2','WI3','UO2',
                                 'UO3','VO2','VO3','WO2','WO3','UI4','UI5','VI4','VI5','WI4',
                                 'WI5','UO4','UO5','VO4','VO5','WO4','WO5','UI6','UO6','VI6',
                                 'VO6','WI6','WO6','WO','WI1','WO1','GONF','LIAISON',
                                 'H1X','H1Y','H1Z','H2X','H2Y','H2Z','H3X','H3Y','H3Z','E1X','E1Y','E1Z','E2X','E2Y','E2Z',
                                 'E3X','E3Y','E3Z','E4X','E4Y','E4Z','LAGS_C','V11','V12','V13','V21','V22',
                                 'V23','V31','V32','V33','PRES11','PRES12','PRES13','PRES21','PRES22','PRES23',
                                 'PRES31','PRES32','PRES33',),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             LIAISON         =SIMP(statut='f',typ='TXM',into=('ENCASTRE',)),
             DX              =SIMP(statut='f',typ='R' ),
             DY              =SIMP(statut='f',typ='R' ),
             DZ              =SIMP(statut='f',typ='R' ),
             DRX             =SIMP(statut='f',typ='R' ),
             DRY             =SIMP(statut='f',typ='R' ),
             DRZ             =SIMP(statut='f',typ='R' ),
             GRX             =SIMP(statut='f',typ='R' ),
             PRES            =SIMP(statut='f',typ='R' ),
             PHI             =SIMP(statut='f',typ='R' ),
             TEMP            =SIMP(statut='f',typ='R' ),
             PRE1            =SIMP(statut='f',typ='R' ),
             PRE2            =SIMP(statut='f',typ='R' ),
             UI2             =SIMP(statut='f',typ='R' ),
             UI3             =SIMP(statut='f',typ='R' ),
             UI4             =SIMP(statut='f',typ='R' ),
             UI5             =SIMP(statut='f',typ='R' ),
             UI6             =SIMP(statut='f',typ='R' ),
             UO2             =SIMP(statut='f',typ='R' ),
             UO3             =SIMP(statut='f',typ='R' ),
             UO4             =SIMP(statut='f',typ='R' ),
             UO5             =SIMP(statut='f',typ='R' ),
             UO6             =SIMP(statut='f',typ='R' ),
             VI2             =SIMP(statut='f',typ='R' ),
             VI3             =SIMP(statut='f',typ='R' ),
             VI4             =SIMP(statut='f',typ='R' ),
             VI5             =SIMP(statut='f',typ='R' ),
             VI6             =SIMP(statut='f',typ='R' ),
             VO2             =SIMP(statut='f',typ='R' ),
             VO3             =SIMP(statut='f',typ='R' ),
             VO4             =SIMP(statut='f',typ='R' ),
             VO5             =SIMP(statut='f',typ='R' ),
             VO6             =SIMP(statut='f',typ='R' ),
             WI2             =SIMP(statut='f',typ='R' ),
             WI3             =SIMP(statut='f',typ='R' ),
             WI4             =SIMP(statut='f',typ='R' ),
             WI5             =SIMP(statut='f',typ='R' ),
             WI6             =SIMP(statut='f',typ='R' ),
             WO2             =SIMP(statut='f',typ='R' ),
             WO3             =SIMP(statut='f',typ='R' ),
             WO4             =SIMP(statut='f',typ='R' ),
             WO5             =SIMP(statut='f',typ='R' ),
             WO6             =SIMP(statut='f',typ='R' ),
             WO              =SIMP(statut='f',typ='R' ),
             WI1             =SIMP(statut='f',typ='R' ),
             WO1             =SIMP(statut='f',typ='R' ),
             GONF            =SIMP(statut='f',typ='R' ),
             H1X             =SIMP(statut='f',typ='R' ),
             H1Y             =SIMP(statut='f',typ='R' ),
             H1Z             =SIMP(statut='f',typ='R' ),
             H2X             =SIMP(statut='f',typ='R' ),
             H2Y             =SIMP(statut='f',typ='R' ),
             H2Z             =SIMP(statut='f',typ='R' ),
             H3X             =SIMP(statut='f',typ='R' ),
             H3Y             =SIMP(statut='f',typ='R' ),
             H3Z             =SIMP(statut='f',typ='R' ),
             E1X             =SIMP(statut='f',typ='R' ),
             E1Y             =SIMP(statut='f',typ='R' ),
             E1Z             =SIMP(statut='f',typ='R' ),
             E2X             =SIMP(statut='f',typ='R' ),
             E2Y             =SIMP(statut='f',typ='R' ),
             E2Z             =SIMP(statut='f',typ='R' ),
             E3X             =SIMP(statut='f',typ='R' ),
             E3Y             =SIMP(statut='f',typ='R' ),
             E3Z             =SIMP(statut='f',typ='R' ),
             E4X             =SIMP(statut='f',typ='R' ),
             E4Y             =SIMP(statut='f',typ='R' ),
             E4Z             =SIMP(statut='f',typ='R' ),
             LAGS_C          =SIMP(statut='f',typ='R' ),
             V11             =SIMP(statut='f',typ='R' ),
             V12             =SIMP(statut='f',typ='R' ),
             V13             =SIMP(statut='f',typ='R' ),
             V21             =SIMP(statut='f',typ='R' ),
             V22             =SIMP(statut='f',typ='R' ),
             V23             =SIMP(statut='f',typ='R' ),
             V31             =SIMP(statut='f',typ='R' ),
             V32             =SIMP(statut='f',typ='R' ),
             V33             =SIMP(statut='f',typ='R' ),
             PRES11          =SIMP(statut='f',typ='R' ),
             PRES12          =SIMP(statut='f',typ='R' ),
             PRES13          =SIMP(statut='f',typ='R' ),
             PRES21          =SIMP(statut='f',typ='R' ),
             PRES22          =SIMP(statut='f',typ='R' ),
             PRES23          =SIMP(statut='f',typ='R' ),
             PRES31          =SIMP(statut='f',typ='R' ),
             PRES32          =SIMP(statut='f',typ='R' ),
             PRES33          =SIMP(statut='f',typ='R' ),
           ),



         DDL_POUTRE    =FACT(statut='f',max='**',
             fr="Bloque des DDLs dans un repre local d'une poutre",
             regles=(AU_MOINS_UN('GROUP_NO','NOEUD'),
                     AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ'),
                     UN_PARMI('VECT_Y','ANGL_VRIL'),),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             DX              =SIMP(statut='f',typ='R' ),
             DY              =SIMP(statut='f',typ='R' ),
             DZ              =SIMP(statut='f',typ='R' ),
             DRX             =SIMP(statut='f',typ='R' ),
             DRY             =SIMP(statut='f',typ='R' ),
             DRZ             =SIMP(statut='f',typ='R' ),
#  dfinition du repre local
             VECT_Y          =SIMP(statut='f',typ='R',min=3,max=3),
             ANGL_VRIL       =SIMP(statut='f',typ='R',),
#  restriction sur les mailles servant  dfinir le repre local
             GROUP_MA        =SIMP(statut='f',typ=grma,),
             MAILLE          =SIMP(statut='f',typ=ma,),
                            ),



           FACE_IMPO       =FACT(statut='f',max='**',
             fr="Impose  tous les noeuds d'une face une ou plusieurs valeurs de dplacement (ou de certaines grandeurs associes)",
             regles=(UN_PARMI('GROUP_MA','MAILLE',),
                     AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI',
                                 'TEMP','PRE1','PRE2','DNOR','DTAN'),
                     EXCLUS('DNOR','DX'),
                     EXCLUS('DNOR','DY'),
                     EXCLUS('DNOR','DZ'),
                     EXCLUS('DNOR','DRX'),
                     EXCLUS('DNOR','DRY'),
                     EXCLUS('DNOR','DRZ'),
                     EXCLUS('DTAN','DX'),
                     EXCLUS('DTAN','DY'),
                     EXCLUS('DTAN','DZ'),
                     EXCLUS('DTAN','DRX'),
                     EXCLUS('DTAN','DRY'),
                     EXCLUS('DTAN','DRZ'),),
#  rajout d'un mot cl REPERE :/ LOCAL /GLOBAL
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_MA   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             SANS_MAILLE     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             DX              =SIMP(statut='f',typ='R' ),
             DY              =SIMP(statut='f',typ='R' ),
             DZ              =SIMP(statut='f',typ='R' ),
             DRX             =SIMP(statut='f',typ='R' ),
             DRY             =SIMP(statut='f',typ='R' ),
             DRZ             =SIMP(statut='f',typ='R' ),
             DNOR            =SIMP(statut='f',typ='R' ),
             DTAN            =SIMP(statut='f',typ='R' ),
             GRX             =SIMP(statut='f',typ='R' ),
             PRES            =SIMP(statut='f',typ='R' ),
             PHI             =SIMP(statut='f',typ='R' ),
             TEMP            =SIMP(statut='f',typ='R' ),
             PRE1            =SIMP(statut='f',typ='R' ),
             PRE2            =SIMP(statut='f',typ='R' ),
           ),

         CHAMNO_IMPO  =FACT(statut='f',max='**',
             fr="Impose des DDLs aux valeurs d'un concept cham_no_sdaster",
#  type de cham_no_sdaster CO()
             CHAM_NO         =SIMP(statut='o',typ=cham_no_sdaster), #CO()
             COEF_MULT       =SIMP(statut='o',typ='R' ),
             NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
           ),


           LIAISON_DDL     =FACT(statut='f',max='**',
             fr="Dfinit une relation linaire entre des DDLs de deux ou plusieurs noeuds",
             regles=(UN_PARMI('GROUP_NO','NOEUD'),),
             GROUP_NO        =SIMP(statut='f',typ=grno ,max='**'),
             NOEUD           =SIMP(statut='f',typ=no   ,max='**'),
             DDL             =SIMP(statut='o',typ='TXM',max='**'),
             COEF_MULT       =SIMP(statut='o',typ='R'  ,max='**'),
             COEF_IMPO       =SIMP(statut='o',typ='R' ),
           ),

           LIAISON_OBLIQUE =FACT(statut='f',max='**',
             fr="Applique  des noeuds la meme valeur de dplacement dfinie composante par composante"
              +" dans un repre oblique quelconque",
             regles=(UN_PARMI('GROUP_NO','NOEUD'),
                     UN_PARMI('DX','DY','DZ','DRX','DRY','DRZ'),),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             ANGL_NAUT       =SIMP(statut='o',typ='R',max=3),
             DX              =SIMP(statut='f',typ='R' ),
             DY              =SIMP(statut='f',typ='R' ),
             DZ              =SIMP(statut='f',typ='R' ),
             DRX             =SIMP(statut='f',typ='R' ),
             DRY             =SIMP(statut='f',typ='R' ),
             DRZ             =SIMP(statut='f',typ='R' ),
           ),

           LIAISON_GROUP   =FACT(statut='f',max='**',
             fr="Dfinit la meme relation linaire entre certains DDLs de couples de noeuds",
             regles=(UN_PARMI('GROUP_MA_1','MAILLE_1','GROUP_NO_1','NOEUD_1'),
                     UN_PARMI('GROUP_MA_2','MAILLE_2','GROUP_NO_2','NOEUD_2'),
                     EXCLUS('GROUP_MA_1','GROUP_NO_2'),
                     EXCLUS('GROUP_MA_1','NOEUD_2'),
                     EXCLUS('GROUP_NO_1','GROUP_MA_2'),
                     EXCLUS('GROUP_NO_1','MAILLE_2'),
                     EXCLUS('MAILLE_1','GROUP_NO_2'),
                     EXCLUS('MAILLE_1','NOEUD_2'),
                     EXCLUS('NOEUD_1','GROUP_MA_2'),
                     EXCLUS('NOEUD_1','MAILLE_2'),
                     EXCLUS('SANS_NOEUD','SANS_GROUP_NO'),),

               GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
               MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
               GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
               MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
               GROUP_NO_1      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
               NOEUD_1         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
               GROUP_NO_2      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
               NOEUD_2         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),

             SANS_NOEUD      =SIMP(statut='f',typ=no   ,validators=NoRepeat(),max='**'),
             SANS_GROUP_NO   =SIMP(statut='f',typ=grno ,validators=NoRepeat(),max='**'),
             DDL_1           =SIMP(statut='o',typ='TXM',max='**'),
             COEF_MULT_1     =SIMP(statut='o',typ='R'  ,max='**'),
             DDL_2           =SIMP(statut='o',typ='TXM',max='**'),
             COEF_MULT_2     =SIMP(statut='o',typ='R'  ,max='**'),
             COEF_IMPO       =SIMP(statut='o',typ='R' ),
             SOMMET          =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             TRAN            =SIMP(statut='f',typ='R',max=3),
             ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
             CENTRE          =SIMP(statut='f',typ='R',max=3),
           ),

           LIAISON_MAIL    =FACT(statut='f',max='**',
             fr="Dfinit des relations linaires permettant de recoller deux bords d'une structure",
             regles=(AU_MOINS_UN('GROUP_MA_MAIT','MAILLE_MAIT'),
                     AU_MOINS_UN('GROUP_MA_ESCL','MAILLE_ESCL','GROUP_NO_ESCL','NOEUD_ESCL')),
              GROUP_MA_MAIT   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_MAIT     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
              GROUP_MA_ESCL   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_ESCL     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
              GROUP_NO_ESCL   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
              NOEUD_ESCL      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),

              TYPE_RACCORD    =SIMP(statut='o',typ='TXM',defaut="MASSIF",into=("MASSIF","COQUE","COQUE_MASSIF","MASSIF_COQUE",)),

              b_MASSIF     =BLOC ( condition = "TYPE_RACCORD == 'MASSIF'",
                 regles=( PRESENT_PRESENT('DDL_MAIT','DDL_ESCL'),),
              TRAN            =SIMP(statut='f',typ='R',max=3 ),
              ANGL_NAUT       =SIMP(statut='f',typ='R',max=3 ),
              CENTRE          =SIMP(statut='f',typ='R',max=3 ),
              DDL_MAIT        =SIMP(statut='f',typ='TXM',into=("DNOR",) ),
              DDL_ESCL        =SIMP(statut='f',typ='TXM',into=("DNOR",) ),
              ),
              b_COQUE_MASSIF =BLOC ( condition = "TYPE_RACCORD == 'COQUE_MASSIF'",
                 EPAIS           =SIMP(statut='o',typ='R'),
                 CHAM_NORMALE    =SIMP(statut='o',typ=cham_no_sdaster),
              ),
              ELIM_MULT       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         ),

           LIAISON_CYCL    =FACT(statut='f',max='**',
             fr="Dfinit des relations linaires permettant de recoller les bords de deux parties symtriquement cycliques",
             regles=(AU_MOINS_UN('GROUP_MA_MAIT1','MAILLE_MAIT1'),
                     AU_MOINS_UN('GROUP_MA_ESCL','MAILLE_ESCL','GROUP_NO_ESCL','NOEUD_ESCL'),
                     PRESENT_PRESENT('DDL_MAIT','DDL_ESCL'),
                     ),
              GROUP_MA_MAIT1   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_MAIT1     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
              GROUP_MA_MAIT2   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_MAIT2     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
              GROUP_MA_ESCL   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_ESCL     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
              GROUP_NO_ESCL   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
              NOEUD_ESCL     =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
              TRAN            =SIMP(statut='f',typ='R',max=3 ),
              ANGL_NAUT       =SIMP(statut='f',typ='R',max=3 ),
              CENTRE          =SIMP(statut='f',typ='R',max=3 ),
              COEF_MAIT1            =SIMP(statut='f',typ='R',max=1 ),
              COEF_MAIT2            =SIMP(statut='f',typ='R',max=1 ),
              COEF_ESCL            =SIMP(statut='f',typ='R',max=1 ),
              DDL_MAIT        =SIMP(statut='f',typ='TXM',into=("DNOR",) ),
              DDL_ESCL        =SIMP(statut='f',typ='TXM',into=("DNOR",) ),
         ),


           LIAISON_SOLIDE  =FACT(statut='f',max='**',
             fr="Modlise une partie indformable d'une structure."
              +" Les mots cls TRAN et ANGL_NAUT permettent d'imposer le dplacement de la partie indformable.",
             regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),
                     ENSEMBLE('CENTRE','ANGL_NAUT'),),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             TRAN            =SIMP(statut='f',typ='R',max=3 ),
             ANGL_NAUT       =SIMP(statut='f',typ='R',max=3 ),
             CENTRE          =SIMP(statut='f',typ='R',max=3 ),
             DIST_MIN        =SIMP(statut='f',typ='R'),
             NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
           ),

         LIAISON_ELEM    =FACT(statut='f',max='**',
            fr="Modlise le raccord : d'une partie massive 3D avec une poutre ou avec un tuyau, d'une coque"
               +" avec une poutre ou avec un tuyau, d'une plaque avec une poutre",
            regles      =(UN_PARMI('GROUP_MA_1','MAILLE_1'), UN_PARMI('GROUP_NO_2','NOEUD_2'),),
            OPTION      =SIMP(statut='o',typ='TXM',into=("3D_TUYAU","3D_POU","COQ_POU","COQ_TUYAU","PLAQ_POUT_ORTH") ),
            GROUP_MA_1  =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            MAILLE_1    =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_NO_2  =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            NOEUD_2     =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            NUME_LAGR   =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
            ANGL_MAX    =SIMP(statut='f',typ='R',defaut= 1. ),
            b_dalcol =BLOC( condition = "OPTION == 'PLAQ_POUT_ORTH'",
               VERIF_EXCENT   =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
            ),
            b_option =BLOC( condition = "OPTION != 'PLAQ_POUT_ORTH'",
               CARA_ELEM   =SIMP(statut='f',typ=(cara_elem) ),
               AXE_POUTRE  =SIMP(statut='f',typ='R',max=3),
            ),
         ),

           LIAISON_UNIF    =FACT(statut='f',max='**',
             fr="Impose une meme valeur (inconnue)  des DDLs d'un ensemble de noeuds",
             regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             DDL             =SIMP(statut='o',typ='TXM',max='**'),
           ),

         LIAISON_CHAMNO  =FACT(statut='f',max='**',
             fr="Dfinit une relation linaire entre tous les DDLs prsents dans un concept CHAM_NO",
#  type de cham_no_sdaster CO()
             CHAM_NO         =SIMP(statut='o',typ=cham_no_sdaster), #CO()
             COEF_IMPO       =SIMP(statut='o',typ='R' ),
             NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
           ),


         LIAISON_INTERF  =FACT(statut='f',max='**',
             fr="Dfinit une relation linaire entre les DDLs d'interface  partir d'un MACRELEM",
             MACR_ELEM_DYNA  =SIMP(statut='o',typ=macr_elem_dyna),
             TYPE_LIAISON    =SIMP(statut='f',typ='TXM',defaut="RIGIDE",into=("RIGIDE","SOUPLE") ),
           ),

         LIAISON_XFEM      =SIMP(statut='f',typ='TXM',into=("OUI","NON"),defaut="NON" ),

         CONTACT_XFEM      =SIMP(statut='f',typ=char_contact,min=1,max=1,),


#         SIMP(statut='f',typ='TXM',defaut="NON" ),

         VECT_ASSE       =SIMP(statut='f',typ=cham_no_sdaster ),
#
# FORCES
#
         FORCE_NODALE    =FACT(statut='f',fr="Applique  des noeuds des forces nodales",max='**',
           regles=(AU_MOINS_UN('GROUP_NO','NOEUD'),
                   AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ' ),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           FX              =SIMP(statut='f',typ='R' ),
           FY              =SIMP(statut='f',typ='R' ),
           FZ              =SIMP(statut='f',typ='R' ),
           MX              =SIMP(statut='f',typ='R' ),
           MY              =SIMP(statut='f',typ='R' ),
           MZ              =SIMP(statut='f',typ='R' ),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
         ),

         FORCE_FACE      =FACT(statut='f',max='**',
             fr="Applique des forces surfaciques sur une face d'lment volumique",
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FX','FY','FZ'),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             FX              =SIMP(statut='f',typ='R' ),
             FY              =SIMP(statut='f',typ='R' ),
             FZ              =SIMP(statut='f',typ='R' ),
           ),

         FORCE_ARETE     =FACT(statut='f',max='**',
         fr="Applique des forces liniques  une arete d'lment volumique ou de coque",
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE',),
                     AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ' ),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             FX              =SIMP(statut='f',typ='R' ),
             FY              =SIMP(statut='f',typ='R' ),
             FZ              =SIMP(statut='f',typ='R' ),
             MX              =SIMP(statut='f',typ='R' ),
             MY              =SIMP(statut='f',typ='R' ),
             MZ              =SIMP(statut='f',typ='R' ),
           ),

         FORCE_CONTOUR   =FACT(statut='f',max='**',
             fr="Applique des forces liniques au bord d'un domaine 2D ou AXIS ou AXIS_FOURIER",
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ'),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             FX              =SIMP(statut='f',typ='R' ),
             FY              =SIMP(statut='f',typ='R' ),
             FZ              =SIMP(statut='f',typ='R' ),
             MX              =SIMP(statut='f',typ='R' ),
             MY              =SIMP(statut='f',typ='R' ),
             MZ              =SIMP(statut='f',typ='R' ),
           ),

         FORCE_INTERNE   =FACT(statut='f',max='**',
             fr="Applique des forces volumiques (2D ou 3D)  un domaine volumique",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FX','FY','FZ' ),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             FX              =SIMP(statut='f',typ='R' ),
             FY              =SIMP(statut='f',typ='R' ),
             FZ              =SIMP(statut='f',typ='R' ),
           ),

         SIGM_INTERNE   =FACT(statut='f',max='**',
             fr="Applique des contraintes volumiques (2D ou 3D)  un domaine volumique",
             #INST            =SIMP(statut='f',typ='R' ),
             SIGM            =SIMP(statut='o',typ=(cham_elem,carte_sdaster)),
           ),

         PRES_REP        =FACT(statut='f',max='**',
             fr="Applique une pression  un domaine de milieu continu 2D ou 3D, ou  un domaine de coques et tuyaux",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','FISSURE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE','FISSURE'),
                     AU_MOINS_UN('PRES','CISA_2D' ),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             FISSURE         =SIMP(statut='f',typ=fiss_xfem,min=1,max=100,),
             PRES            =SIMP(statut='f',typ='R' ),
             CISA_2D         =SIMP(statut='f',typ='R' ),
           ),

         EFFE_FOND       =FACT(statut='f',max='**',
           fr="Calcul l'effet de fond sur une branche de tuyauterie (modlisation 3D) soumise  une pression",
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),),
           GROUP_MA_INT    =SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           PRES            =SIMP(statut='o',typ='R' ),
         ),

         EPSI_INIT       =FACT(statut='f',max='**',
             fr="Applique un chargement de dformation initiale  un lment 2D, 3D ou de structure",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('EPXX','EPYY','EPZZ','EPXY','EPXZ','EPYZ','EPX',
                                 'KY','KZ','EXX','EYY','EXY','KXX','KYY','KXY'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             EPXX            =SIMP(statut='f',typ='R' ),
             EPYY            =SIMP(statut='f',typ='R' ),
             EPZZ            =SIMP(statut='f',typ='R' ),
             EPXY            =SIMP(statut='f',typ='R' ),
             EPXZ            =SIMP(statut='f',typ='R' ),
             EPYZ            =SIMP(statut='f',typ='R' ),
             EPX             =SIMP(statut='f',typ='R' ),
             KY              =SIMP(statut='f',typ='R' ),
             KZ              =SIMP(statut='f',typ='R' ),
             EXX             =SIMP(statut='f',typ='R' ),
             EYY             =SIMP(statut='f',typ='R' ),
             EXY             =SIMP(statut='f',typ='R' ),
             KXX             =SIMP(statut='f',typ='R' ),
             KYY             =SIMP(statut='f',typ='R' ),
             KXY             =SIMP(statut='f',typ='R' ),
           ),

        FORCE_POUTRE    =FACT(statut='f',max='**',
             fr="Applique des forces liniques sur des lments de type poutre",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FX','FY','FZ','N','VY','VZ'),
                     PRESENT_ABSENT('FX','N','VY','VZ'),
                     PRESENT_ABSENT('FY','N','VY','VZ'),
                     PRESENT_ABSENT('FZ','N','VY','VZ'),
                     PRESENT_ABSENT('N','FX','FY','FZ'),
                     PRESENT_ABSENT('VY','FX','FY','FZ'),
                     PRESENT_ABSENT('VZ','FX','FY','FZ'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FORCE",into=("VENT","FORCE",) ),
#  rajour d'un mot cl REPERE :/ LOCAL /GLOBAL
               FX              =SIMP(statut='f',typ='R' ),
               FY              =SIMP(statut='f',typ='R' ),
               FZ              =SIMP(statut='f',typ='R' ),

               N               =SIMP(statut='f',typ='R' ),
               VY              =SIMP(statut='f',typ='R' ),
               VZ              =SIMP(statut='f',typ='R' ),

           ),

         FORCE_TUYAU     =FACT(statut='f',max='**',
             fr="Applique une pression sur des lments TUYAU",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             PRES            =SIMP(statut='f',typ='R' ),
           ),

         FORCE_COQUE     =FACT(statut='f',max='**',
             fr="Applique des forces surfaciques sur des lments de types coques",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('FX','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('FY','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('FZ','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('MX','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('MY','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('MZ','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('F1','FX','FY','FZ','MX','MY','MZ','PRES'),
                     PRESENT_ABSENT('F2','FX','FY','FZ','MX','MY','MZ','PRES'),
                     PRESENT_ABSENT('F3','FX','FY','FZ','MX','MY','MZ','PRES'),
                     PRESENT_ABSENT('MF1','FX','FY','FZ','MX','MY','MZ','PRES'),
                     PRESENT_ABSENT('MF2','FX','FY','FZ','MX','MY','MZ','PRES'),
                     PRESENT_ABSENT('PRES','FX','FY','FZ','MX','MY','MZ','F1','F2','F3','MF1','MF2'),),
#  rajour d'un mot cl REPERE :/ LOCAL /GLOBAL
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),

               FX              =SIMP(statut='f',typ='R' ),
               FY              =SIMP(statut='f',typ='R' ),
               FZ              =SIMP(statut='f',typ='R' ),
               MX              =SIMP(statut='f',typ='R' ),
               MY              =SIMP(statut='f',typ='R' ),
               MZ              =SIMP(statut='f',typ='R' ),

               F1              =SIMP(statut='f',typ='R' ),
               F2              =SIMP(statut='f',typ='R' ),
               F3              =SIMP(statut='f',typ='R' ),
               MF1             =SIMP(statut='f',typ='R' ),
               MF2             =SIMP(statut='f',typ='R' ),

             PRES            =SIMP(statut='f',typ='R' ),
             PLAN            =SIMP(statut='f',typ='TXM',defaut="MAIL",into=("SUP","INF","MOY","MAIL",) ),
           ),

           LIAISON_COQUE   =FACT(statut='f',max='**',
             fr="Permet de reprsenter le raccord entre des lments de coques au moyen des relations linaires",
             GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_NO_1      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD_1         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_NO_2      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD_2         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
           ),

         RELA_CINE_BP    =FACT(statut='f',max='**',
           fr="Etablir des relations cinmatiques permettant de relier les noeuds cable aux noeuds du bton, et spcifier"
              +" la prise en compte des contraintes initiales dans les cables",
           CABLE_BP        =SIMP(statut='o',typ=cabl_precont ),
           SIGM_BPEL       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
           RELA_CINE       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           DIST_MIN        =SIMP(statut='f',typ='R'),
         ),

         FORCE_ELEC      =FACT(statut='f',max='**',
             fr="Appliquer la force de LAPLACE agissant sur un conducteur principal, due  la prsence d'un conducteur"
                 +" secondaire droit",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),

             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),

             POSITION        =SIMP(statut='f',typ='TXM',fr="Direction prdfinie",into=("PARA","INFI","FINI",) ),
             b_fxyz  =BLOC ( condition = "POSITION == None",
                  FX   =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
                  FY   =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
                  FZ   =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
                       ),

             b_para     =BLOC ( condition = "POSITION == 'PARA'",
               regles=(UN_PARMI('TRANS','DIST'),),
               TRANS           =SIMP(statut='f',typ='R',max=3),
               DIST            =SIMP(statut='f',typ='R' ),
               b_point2        =BLOC ( condition = "DIST != None",
                 POINT2           =SIMP(statut='o',typ='R',max=3),
               ),
             ),
             b_fini_infi     =BLOC ( condition = "(POSITION == 'FINI') or (POSITION == 'INFI')",
               POINT1          =SIMP(statut='o',typ='R',max=3),
               POINT2          =SIMP(statut='o',typ='R',max=3),
             ),
           ),




        INTE_ELEC       =FACT(statut='f',max='**',
             fr="Appliquer la force de LAPLACE agissant sur un conducteur principal, due  la prsence d'un conducteur"
               +" secondaire non ncessairement droit",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('GROUP_MA_2','MAILLE_2','TRANS','SYME'),
                     EXCLUS('TRANS','SYME'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             TRANS           =SIMP(statut='f',typ='R' ,max='**'),
             SYME            =SIMP(statut='f',typ='R' ,max='**'),
           ),


         IMPE_FACE       =FACT(statut='f',fr="Applique une impdance acoustique  une face",max='**',
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE' ),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             IMPE            =SIMP(statut='o',typ='R' ),
           ),

         VITE_FACE       =FACT(statut='f',fr="Impose des vitesses normales  une face (phnomne ACOUSTIQUE), ",max='**',
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             VNOR            =SIMP(statut='o',typ='R' ),
           ),



         ONDE_FLUI       =FACT(statut='f',max='**',
             fr="Applique une amplitude de pression d'onde incidente sinusoidale arrivant normalement  une face",
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             PRES            =SIMP(statut='o',typ='R' ),
           ),

         FLUX_THM_REP    =FACT(statut='f',max='**',
             fr="Applique  un domaine de milieu continu 2D ou 3D un flux de chaleur et/ou un apport de masse fluide"
                 +" (flux hydraulique)",
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FLUN','FLUN_HYDR1','FLUN_HYDR2'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             FLUN            =SIMP(statut='f',typ='R' ),
             FLUN_HYDR1      =SIMP(statut='f',typ='R' ),
             FLUN_HYDR2      =SIMP(statut='f',typ='R' ),
           ),

         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;


#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
AFFE_CHAR_MECA_C=OPER(nom="AFFE_CHAR_MECA_C",op=   7,sd_prod=char_meca,
                     fr="Affectation de charges et conditions aux limites mcaniques complexes",
                     reentrant='n',
            UIinfo={"groupes":("Chargements","Mcanique",)},
         regles=(AU_MOINS_UN('DDL_IMPO','FORCE_POUTRE','LIAISON_DDL', ),),
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         VERI_DDL        =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         METHODE         =SIMP(statut='c',typ='TXM',fr="Stratgie de rsolution pour les dplacements imposs",
                               into=('DUALISATION',),defaut='DUALISATION',),
                               # METHODE='ELIMINATION' est trait dans le fortran mais dangereux actuellement
         DDL_IMPO        =FACT(statut='f',max='**',
           fr="Impose  des noeuds une ou plusieurs valeurs de dplacement (ou de certaines grandeurs asscocies)",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD',),
                   AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI','LIAISON', ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           LIAISON         =SIMP(statut='f',typ='TXM',into=('ENCASTRE',)),
           DX              =SIMP(statut='f',typ='C' ),
           DY              =SIMP(statut='f',typ='C' ),
           DZ              =SIMP(statut='f',typ='C' ),
           DRX             =SIMP(statut='f',typ='C' ),
           DRY             =SIMP(statut='f',typ='C' ),
           DRZ             =SIMP(statut='f',typ='C' ),
           GRX             =SIMP(statut='f',typ='C' ),
           PRES            =SIMP(statut='f',typ='C' ),
           PHI             =SIMP(statut='f',typ='C' ),
         ),
         FORCE_POUTRE    =FACT(statut='f',max='**',
           fr="Applique des forces liniques sur des lments de type poutre",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FX','FY','FZ','N','VY','VZ',),
                   PRESENT_ABSENT('FX','N','VY','VZ',),
                   PRESENT_ABSENT('FY','N','VY','VZ',),
                   PRESENT_ABSENT('FZ','N','VY','VZ',),
                   PRESENT_ABSENT('N','FX','FY','FZ',),
                   PRESENT_ABSENT('VY', 'FX','FY','FZ',),
                   PRESENT_ABSENT('VZ','FX','FY','FZ', ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FORCE",into=("VENT","FORCE") ),
           FX              =SIMP(statut='f',typ='C' ),
           FY              =SIMP(statut='f',typ='C' ),
           FZ              =SIMP(statut='f',typ='C' ),
           N               =SIMP(statut='f',typ='C' ),
           VY              =SIMP(statut='f',typ='C' ),
           VZ              =SIMP(statut='f',typ='C' ),
         ),
         LIAISON_DDL     =FACT(statut='f',max='**',
           fr="Dfinit une relation linaire entre les DDLs de deux ou plusieurs noeuds",
           regles=(UN_PARMI('GROUP_NO','NOEUD', ),),
           GROUP_NO        =SIMP(statut='f',typ=grno,max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,max='**'),
           DDL             =SIMP(statut='o',typ='TXM',max='**'),
           COEF_MULT       =SIMP(statut='o',typ='R'  ,max='**'),
           COEF_IMPO       =SIMP(statut='o',typ='C' ),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
AFFE_CHAR_MECA_F=OPER(nom="AFFE_CHAR_MECA_F",op=7,sd_prod=char_meca,
                      fr="Affectation de charges et conditions aux limites mcaniques fonction d'un (ou plusieurs) paramtres",
                      reentrant='n',
            UIinfo={"groupes":("Chargements","Mcanique",)},
        regles=(AU_MOINS_UN('DDL_IMPO','FACE_IMPO','LIAISON_DDL','FORCE_NODALE',
                            'FORCE_FACE','FORCE_ARETE','FORCE_CONTOUR','FORCE_INTERNE',
                            'PRES_REP','FORCE_POUTRE','VITE_FACE','IMPE_FACE','ONDE_PLANE',
                            'LIAISON_OBLIQUE','EPSI_INIT','LIAISON_GROUP','LIAISON_UNIF',
                            'LIAISON_SOLIDE','FORCE_COQUE','LIAISON_COQUE','FORCE_TUYAU',
                            'EFFE_FOND','FLUX_THM_REP',),),
         VERI_DDL        =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         VERI_NORM       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         MODELE          =SIMP(statut='o',typ=modele_sdaster),
         METHODE         =SIMP(statut='c',typ='TXM',fr="Stratgie de rsolution pour les dplacements imposs",
                               into=('DUALISATION',),defaut='DUALISATION',),
                               # METHODE='ELIMINATION' est trait dans le fortran mais dangereux actuellement

         DDL_IMPO        =FACT(statut='f',max='**',
           fr="Impose  des noeuds une ou plusieurs valeurs de dplacement (ou de certaines grandeurs asscocies) fournies"
               +" par l'intermdiaire d'un concept fonction ",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                   AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI',
                               'TEMP','PRE1','PRE2','LIAISON','H1X',
                               'H1Y','H1Z','E1X','E1Y','E1Z','E2X','E2Y','E2Z',
                               'E3X','E3Y','E3Z','E4X','E4Y','E4Z','LAGS_C'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           LIAISON         =SIMP(statut='f',typ='TXM',into=('ENCASTRE',)),
           DX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRY             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRZ             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           GRX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PHI             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRE1            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRE2            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           H1X             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           H1Y             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           H1Z             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E1X             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E1Y             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E1Z             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E2X             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E2Y             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E2Z             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E3X             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E3Y             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E3Z             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E4X             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E4Y             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           E4Z             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           LAGS_C          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         FACE_IMPO       =FACT(statut='f',max='**',
           fr="Impose  tous les noeuds d'une face une ou plusieurs valeurs de dplacement (ou de certaines grandeurs associes)"
              +" fournies par l'intrmdiaire d'un concept fonction",
           regles=(UN_PARMI('GROUP_MA','MAILLE'),
                   AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI','TEMP','PRE1','PRE2','DNOR','DTAN'),
                   EXCLUS('DNOR','DX'),
                   EXCLUS('DNOR','DY'),
                   EXCLUS('DNOR','DZ'),
                   EXCLUS('DNOR','DRX'),
                   EXCLUS('DNOR','DRY'),
                   EXCLUS('DNOR','DRZ'),
                   EXCLUS('DTAN','DX'),
                   EXCLUS('DTAN','DY'),
                   EXCLUS('DTAN','DZ'),
                   EXCLUS('DTAN','DRX'),
                   EXCLUS('DTAN','DRY'),
                   EXCLUS('DTAN','DRZ'),),
#  rajout d un mot cle REPERE : / GLOBAL / LOCAL
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           SANS_GROUP_MA   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           SANS_MAILLE     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           DX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRY             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRZ             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           GRX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PHI             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRE1            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRE2            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DNOR            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DTAN            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         LIAISON_DDL     =FACT(statut='f',max='**',
           fr="Dfinit une relation linaire entre des DDLs de deux ou plusieurs noeuds, les valeurs sont fournies par"
               +" l'intermediaire d'un concept de type fonction",
           regles=(UN_PARMI('GROUP_NO','NOEUD'),UN_PARMI('COEF_MULT','COEF_MULT_FONC'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,max='**'),
           DDL             =SIMP(statut='o',typ='TXM',max='**'),
           COEF_MULT       =SIMP(statut='f',typ='R',max='**'),
           COEF_MULT_FONC  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),max='**'),
           COEF_IMPO       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         LIAISON_OBLIQUE =FACT(statut='f',max='**',
           fr="Applique  des noeuds la meme valeur de dplacement dfinie composante par composante dans un repre oblique"
              +" quelconque, les valeurs sont fournis par l'intermdiaire d'un concept fonction",
           regles=(UN_PARMI('GROUP_NO','NOEUD'),
                   UN_PARMI('DX','DY','DZ','DRX','DRY','DRZ'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,max='**'),
           ANGL_NAUT       =SIMP(statut='o',typ='R',max=3),
           DX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRX             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRY             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DRZ             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         LIAISON_GROUP   =FACT(statut='f',max='**',
           fr="Dfinit la meme relation linaire entre certains DDLs de couples de noeuds, les valeurs sont fournies par"
               +" l'intermdiaire de concept fonction",
           regles=(UN_PARMI('GROUP_MA_1','MAILLE_1','GROUP_NO_1','NOEUD_1'),
                   UN_PARMI('GROUP_MA_2','MAILLE_2','GROUP_NO_2','NOEUD_2'),
                   EXCLUS('GROUP_MA_1','GROUP_NO_2'),
                   EXCLUS('GROUP_MA_1','NOEUD_2'),
                   EXCLUS('GROUP_NO_1','GROUP_MA_2'),
                   EXCLUS('GROUP_NO_1','MAILLE_2'),
                   EXCLUS('MAILLE_1','GROUP_NO_2'),
                   EXCLUS('MAILLE_1','NOEUD_2'),
                   EXCLUS('NOEUD_1','GROUP_MA_2'),
                   EXCLUS('NOEUD_1','MAILLE_2'),
                   EXCLUS('SANS_NOEUD','SANS_GROUP_NO'),),
           GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_1      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_1         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_2      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_2         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           DDL_1           =SIMP(statut='o',typ='TXM',max='**'),
           COEF_MULT_1     =SIMP(statut='o',typ='R',max='**'),
           DDL_2           =SIMP(statut='o',typ='TXM',max='**'),
           COEF_MULT_2     =SIMP(statut='o',typ='R',max='**'),
           COEF_IMPO       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           SOMMET          =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           TRAN            =SIMP(statut='f',typ='R',max=3),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
           CENTRE          =SIMP(statut='f',typ='R',max=3),
         ),

          LIAISON_UNIF    =FACT(statut='f',max='**',
           fr="Impose une meme valeur (inconnue)  des DDLs d'un ensemble de noeuds",
           regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           DDL             =SIMP(statut='o',typ='TXM',max='**'),
         ),


         LIAISON_SOLIDE  =FACT(statut='f',max='**',
           fr="Modlise une partie indformable d'une structure."
            +" Les mots cls TRAN et ANGL_NAUT permettent d'imposer le dplacement de la partie indformable.",
           regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),
                   ENSEMBLE('CENTRE','ANGL_NAUT'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           TRAN            =SIMP(statut='f',typ='R',max=3 ),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max=3 ),
           CENTRE          =SIMP(statut='f',typ='R',max=3 ),
           DIST_MIN        =SIMP(statut='f',typ='R'),
           NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
         ),



         FORCE_NODALE    =FACT(statut='f',max='**',
           fr="Applique  des noeuds des forces nodales dont les valeurs des composantes sont fournies par l'intermdiaire"
               +" d'un concept fonction",
           regles=(UN_PARMI('GROUP_NO','NOEUD'),
                   AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           FX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           ANGL_NAUT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),max=3 ),
         ),

         FORCE_FACE      =FACT(statut='f',max='**',
           fr="Applique des forces surfaciques sur une face d'lment volumique dont les valeurs des composantes sont fournies"
               +" par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FX','FY','FZ'),),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),
         FORCE_ARETE     =FACT(statut='f',max='**',
           fr="Applique des forces liniques  une arete d'lment volumique ou de coque dont les valeurs des composantes sont"
               +" fournies par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ'),),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),
         FORCE_CONTOUR   =FACT(statut='f',max='**',
           fr="Applique des forces liniques au bord d'un domaine 2D ou AXIS ou AXIS_FOURIER, dont les valeurs des composantes"
               +" sont fournies par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ'),),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         FORCE_INTERNE   =FACT(statut='f',max='**',
           fr="Applique des forces volumiques (2D ou 3D)  un domaine volumique, dont les valeurs des composantes sont fournies"
               +" par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FX','FY','FZ'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         PRES_REP        =FACT(statut='f',max='**',
           fr="Applique une pression  un domaine de milieu continu 2D ou 3D ou  un domaine de coques et tuyaux, dont les"
               +" valeurs imposes (pression et/ou cisaillement) sont fournies par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','FISSURE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE','FISSURE'),
                   AU_MOINS_UN('PRES','CISA_2D'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FISSURE         =SIMP(statut='f',typ=fiss_xfem,min=1,max=100,),
           PRES            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           CISA_2D         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         EFFE_FOND       =FACT(statut='f',max='**',
           fr="Calcul l'effet de fond sur une branche de tuyauterie (modlisation 3D) soumise"
               +"  une pression dont la valeur est fournie par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),),
           GROUP_MA_INT    =SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           PRES            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         EPSI_INIT       =FACT(statut='f',max='**',
           fr="Applique un chargement de dformation initiale  un lment 2D, 3D ou de structure dont les composantes"
               +" du tenseur de dformation sont fournies par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('EPXX','EPYY','EPZZ','EPXY','EPXZ','EPYZ'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           EPXX            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           EPYY            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           EPZZ            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           EPXY            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           EPXZ            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           EPYZ            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         FORCE_POUTRE    =FACT(statut='f',max='**',
           fr="Applique des forces liniques sur des lments de type poutre dont les valeurs sont fournies par"
               +" l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FX','FY','FZ','N','VY','VZ'),
                   PRESENT_ABSENT('FX','N','VY','VZ'),
                   PRESENT_ABSENT('FY','N','VY','VZ'),
                   PRESENT_ABSENT('FZ','N','VY','VZ'),
                   PRESENT_ABSENT('N','FX','FY','FZ'),
                   PRESENT_ABSENT('VY','FX','FY','FZ'),
                   PRESENT_ABSENT('VZ','FX','FY','FZ'),),
#  rajout d un mot cle REPERE : / GLOBAL / LOCAL
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FORCE",into=("VENT","FORCE") ),
           FX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           N               =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         FORCE_TUYAU     =FACT(statut='f',max='**',
           fr="Applique une pression sur des lments TUYAU, la valeur est fournie par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           PRES            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         FORCE_COQUE     =FACT(statut='f',max='**',
           fr="Applique des forces surfaciques sur des lments de types coques dont les valeurs sont fournies par"
               +" l'intermdiaires d'un concept fonction",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ','PRES','F1','F2','F3','MF1','MF2'),
                   PRESENT_ABSENT('FX','PRES','F1','F2','F3','MF1','MF2'),
                   PRESENT_ABSENT('FY','PRES','F1','F2','F3','MF1','MF2'),
                   PRESENT_ABSENT('FZ','PRES','F1','F2','F3','MF1','MF2'),
                   PRESENT_ABSENT('MX','PRES','F1','F2','F3','MF1','MF2'),
                   PRESENT_ABSENT('MY','PRES','F1','F2','F3','MF1','MF2'),
                   PRESENT_ABSENT('MZ','PRES','F1','F2','F3','MF1','MF2'),
                   PRESENT_ABSENT('F1','PRES','FX','FY','FZ','MX','MY','MZ'),
                   PRESENT_ABSENT('F2','PRES','FX','FY','FZ','MX','MY','MZ'),
                   PRESENT_ABSENT('F3','PRES','FX','FY','FZ','MX','MY','MZ'),
                   PRESENT_ABSENT('MF1','PRES','FX','FY','FZ','MX','MY','MZ'),
                   PRESENT_ABSENT('MF2','PRES','FX','FY','FZ','MX','MY','MZ'),
                   PRESENT_ABSENT('PRES','FX','FY','FZ','MX','MY','MZ','F1','F2','F3','MF1','MF2'),),
#  rajout d un mot cle REPERE : / GLOBAL / LOCAL
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           F1              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           F2              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           F3              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MF1             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           MF2             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PRES            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PLAN            =SIMP(statut='f',typ='TXM',defaut="MAIL",
                                 into=("SUP","INF","MOY","MAIL") ),
         ),

         LIAISON_COQUE   =FACT(statut='f',max='**',
           fr="Permet de reprsenter le raccord entre des lments de coques au moyen des relations linaires",
           GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_1      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_1         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_2      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_2         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES",) ),
         ),


         VITE_FACE       =FACT(statut='f',max='**',
           fr="Impose des vitesses normales  une face (phnomne ACOUSTIQUE) dont les valeurs sont fournies par"
               +" l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('GROUP_MA','MAILLE'),),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           VNOR            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),
         IMPE_FACE       =FACT(statut='f',max='**',
           fr="Applique  une face une impdance acoustique dont la valeur est fournie par l'intermdiaire"
               +" d'un concept fonction",
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('GROUP_MA','MAILLE'),),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           IMPE            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),
         ONDE_PLANE      =FACT(statut='f',max='**',
           fr="Impose un chargement sismique par onde plane dont la valeur est fournie par l'intermdiaire"
               +" d'un concept fonction",
           DIRECTION       =SIMP(statut='o',typ='R',max='**'),
           TYPE_ONDE       =SIMP(statut='o',typ='TXM' ),
           FONC_SIGNAL     =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           DIST_ORIG       =SIMP(statut='o',typ='R' ),
         ),



         FLUX_THM_REP    =FACT(statut='f',max='**',
           fr="Applique  un domaine continue 2D ou 3D un flux de chaleur et/ou un apport de masse fluide (flux hydraulique)"
               +" dont les valeurs des flux sont fournies par l'intermdiaire d'un concept fonction",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FLUN','FLUN_HYDR1','FLUN_HYDR2'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FLUN            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUN_HYDR1      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUN_HYDR2      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;


#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE None
AFFE_CHAR_OPS011=OPER(nom="AFFE_CHAR_OPS011",op= 190,sd_prod=char_ther,
                      fr="Affectation de charges et conditions limites thermiques spcifique  CARA_TORSION",
                      reentrant='n',
            UIinfo={"groupes":("Outils-mtier","Thermique",)},
         regles=(AU_MOINS_UN('CARA_TORSION', ),),
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         VERI_DDL        =SIMP(statut='f',typ='TXM',defaut="OUI",
                               into=("OUI","NON") ),
         CARA_TORSION    =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 22/11/2011   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
AFFE_CHAR_THER=OPER(nom="AFFE_CHAR_THER",op=34,sd_prod=char_ther
                    ,fr="Affectation de charges et conditions aux limites thermiques constantes",
                    reentrant='n',
            UIinfo={"groupes":("Chargements","Thermique",)},
      regles=(AU_MOINS_UN('TEMP_IMPO','SOURCE','FLUX_REP','ECHANGE',
                          'ECHANGE_PAROI','GRAD_TEMP_INIT','LIAISON_DDL','LIAISON_GROUP',
                          'LIAISON_UNIF','LIAISON_CHAMNO','RAYONNEMENT','LIAISON_MAIL' ),),
         MODELE          =SIMP(statut='o',typ=(modele_sdaster) ),
         METHODE         =SIMP(statut='c',typ='TXM',fr="Stratgie de rsolution pour les tempratures imposes",
                               into=('DUALISATION',),defaut='DUALISATION',),
                               # METHODE='ELIMINATION' est trait dans le fortran mais dangereux actuellement

         TEMP_IMPO       =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                   AU_MOINS_UN('TEMP_SUP','TEMP','TEMP_INF'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           TEMP            =SIMP(statut='f',typ='R'),
           TEMP_INF        =SIMP(statut='f',typ='R'),
           TEMP_SUP        =SIMP(statut='f',typ='R'), ),

         FLUX_REP        =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_PRESENT('CARA_TORSION','GROUP_MA'),
                   AU_MOINS_UN('FLUN','FLUN_INF','FLUN_SUP','CARA_TORSION') ),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FLUN            =SIMP(statut='f',typ='R'),
           FLUN_INF        =SIMP(statut='f',typ='R'),
           FLUN_SUP        =SIMP(statut='f',typ='R'),
           CARA_TORSION    =SIMP(statut='f',typ=table_sdaster),
         ),


         RAYONNEMENT     =FACT(statut='f',max='**',
           fr="Attention, exprimer les tempratures en Celsius si rayonnement",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           SIGMA           =SIMP(statut='o',typ='R'),
           EPSILON         =SIMP(statut='o',typ='R'),
           TEMP_EXT        =SIMP(statut='o',typ='R'),
         ),

         ECHANGE         =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('COEF_H','COEF_H_INF','COEF_H_SUP'),
                   ENSEMBLE('COEF_H','TEMP_EXT',),
                   ENSEMBLE('COEF_H_INF','TEMP_EXT_INF'),
                             ENSEMBLE('COEF_H_SUP','TEMP_EXT_SUP'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           COEF_H          =SIMP(statut='f',typ='R'),
           TEMP_EXT        =SIMP(statut='f',typ='R'),
           COEF_H_INF      =SIMP(statut='f',typ='R'),
           TEMP_EXT_INF    =SIMP(statut='f',typ='R'),
           COEF_H_SUP      =SIMP(statut='f',typ='R'),
           TEMP_EXT_SUP    =SIMP(statut='f',typ='R'),
         ),

         SOURCE          =FACT(statut='f',max='**',
           regles=(UN_PARMI('SOUR','SOUR_CALCULEE',),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('SOUR_CALCULEE','TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           SOUR            =SIMP(statut='f',typ='R'),
           SOUR_CALCULEE   =SIMP(statut='f',typ=(cham_elem) ),
         ),

         GRAD_TEMP_INIT  =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FLUX_X','FLUX_Y','FLUX_Z'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FLUX_X          =SIMP(statut='f',typ='R' ),
           FLUX_Y          =SIMP(statut='f',typ='R' ),
           FLUX_Z          =SIMP(statut='f',typ='R' ),
                         ),

         LIAISON_DDL     =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_NO','NOEUD', ),),
           GROUP_NO        =SIMP(statut='f',typ=grno,max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,max='**'),
           DDL             =SIMP(statut='f',typ='TXM',max='**',
                                 into=("TEMP","TEMP_INF","TEMP_SUP") ),
           COEF_MULT       =SIMP(statut='o',typ='R',max='**'),
           COEF_IMPO       =SIMP(statut='o',typ='R' ),
         ),

         LIAISON_GROUP   =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_MA_1','MAILLE_1','GROUP_NO_1','NOEUD_1'),
                   UN_PARMI('GROUP_MA_2','MAILLE_2','GROUP_NO_2','NOEUD_2'),
                             EXCLUS('GROUP_MA_1','GROUP_NO_2'),
                             EXCLUS('GROUP_MA_1','NOEUD_2'),
                   EXCLUS('GROUP_NO_1','GROUP_MA_2'),
                             EXCLUS('GROUP_NO_1','MAILLE_2'),
                             EXCLUS('MAILLE_1','GROUP_NO_2'),
                             EXCLUS('MAILLE_1','NOEUD_2'),
                             EXCLUS('NOEUD_1','GROUP_MA_2'),
                             EXCLUS('NOEUD_1','MAILLE_2'),
                             EXCLUS('SANS_NOEUD','SANS_GROUP_NO'),),
           GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_1      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_1         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_2      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_2         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           DDL_1           =SIMP(statut='f',typ='TXM',max='**',defaut="TEMP",
                                 into=("TEMP","TEMP_INF","TEMP_SUP") ),
           COEF_MULT_1     =SIMP(statut='o',typ='R',max='**'),
           DDL_2           =SIMP(statut='f',typ='TXM',max='**',defaut="TEMP",
                                 into=("TEMP","TEMP_INF","TEMP_SUP",) ),
           COEF_MULT_2     =SIMP(statut='o',typ='R',max='**'),
           COEF_IMPO       =SIMP(statut='o',typ='R' ),
           SOMMET          =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           TRAN            =SIMP(statut='f',typ='R',max='**'),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max='**'),
           CENTRE          =SIMP(statut='f',typ='R',max='**'),
         ),

         LIAISON_MAIL    =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('GROUP_MA_MAIT','MAILLE_MAIT'),
                   AU_MOINS_UN('GROUP_MA_ESCL','MAILLE_ESCL','GROUP_NO_ESCL',
                               'NOEUD_ESCL'),),
           GROUP_MA_MAIT   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_MAIT     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA_ESCL   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_ESCL     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_ESCL   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_ESCL      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           TRAN            =SIMP(statut='f',typ='R',max='**' ),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max='**' ),
           CENTRE          =SIMP(statut='f',typ='R',max='**' ),
           ELIM_MULT       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         ),

         ECHANGE_PAROI   =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_MA_1','MAILLE_1'),
                   UN_PARMI('GROUP_MA_2','MAILLE_2'),),
           GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           COEF_H          =SIMP(statut='f',typ='R'),
           TRAN            =SIMP(statut='f',typ='R',min=2,max=3),
                         ),

         LIAISON_UNIF    =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           DDL             =SIMP(statut='f',typ='TXM',max='**',defaut="TEMP",
                                 into=("TEMP","TEMP_INF","TEMP_SUP") ),
         ),

         LIAISON_CHAMNO  =FACT(statut='f',max='**',
           CHAM_NO         =SIMP(statut='o',typ=cham_no_sdaster),# CO()# "il faut definir une structure de donnee generique chamno"
           COEF_IMPO       =SIMP(statut='o',typ='R' ),
           NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
         ),

         CONVECTION      =FACT(statut='f',max='**',
           VITESSE         =SIMP(statut='o',typ=(cham_no_sdaster) ),
         ),


         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 22/11/2011   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
AFFE_CHAR_THER_F=OPER(nom="AFFE_CHAR_THER_F",op=34,sd_prod=char_ther,
                     fr="Affectation de charges et conditions aux limites thermiques fonction d'un (ou plusieurs)"
                         +" paramtres (temps, ...)",
                     reentrant='n',
            UIinfo={"groupes":("Chargements","Thermique",)},
      regles=(AU_MOINS_UN('TEMP_IMPO','SOURCE','FLUX_REP','FLUX_NL','ECHANGE',
                          'ECHANGE_PAROI','LIAISON_DDL','LIAISON_GROUP','LIAISON_UNIF',
                          'GRAD_TEMP_INIT','RAYONNEMENT'),),
         MODELE          =SIMP(statut='o',typ=(modele_sdaster) ),

         TEMP_IMPO       =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                   AU_MOINS_UN('TEMP_SUP','TEMP','TEMP_INF'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           DDL             =SIMP(statut='f',typ='TXM',into=("TEMP",) ),
           TEMP            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP_INF        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP_SUP        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         FLUX_REP        =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FLUN','FLUN_INF','FLUN_SUP','FLUX_X','FLUX_Y','FLUX_Z'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FLUN            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUN_INF        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUN_SUP        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUX_X          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUX_Y          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUX_Z          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         FLUX_NL         =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FLUN            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),


         RAYONNEMENT     =FACT(statut='f',max='**',
           fr="Attention, exprimer les tempratures en Celsius si rayonnement",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           SIGMA           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           EPSILON         =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP_EXT        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),



         ECHANGE         =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('COEF_H','COEF_H_INF','COEF_H_SUP'),
                   ENSEMBLE('COEF_H','TEMP_EXT'),
                   ENSEMBLE('COEF_H_INF','TEMP_EXT_INF'),
                   ENSEMBLE('COEF_H_SUP','TEMP_EXT_SUP'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           COEF_H          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP_EXT        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           COEF_H_INF      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP_EXT_INF    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           COEF_H_SUP      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TEMP_EXT_SUP    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),


         SOURCE          =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           SOUR            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         GRAD_TEMP_INIT  =FACT(statut='f',max='**',
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                   PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                   AU_MOINS_UN('FLUX_X','FLUX_Y','FLUX_Z'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           FLUX_X          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUX_Y          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FLUX_Z          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         ECHANGE_PAROI   =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_MA_1','MAILLE_1'),
                        UN_PARMI('GROUP_MA_2','MAILLE_2'),),
           GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           COEF_H          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TRAN            =SIMP(statut='f',typ='R',min=2,max=3),
         ),

        LIAISON_DDL     =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_NO','NOEUD'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,max='**'),
           DDL             =SIMP(statut='f',typ='TXM',max='**',into=("TEMP","TEMP_INF","TEMP_SUP") ),
           COEF_MULT       =SIMP(statut='o',typ='R',max='**'),
           COEF_IMPO       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         LIAISON_GROUP   =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_MA_1','MAILLE_1','GROUP_NO_1','NOEUD_1'),
                   UN_PARMI('GROUP_MA_2','MAILLE_2','GROUP_NO_2','NOEUD_2'),
                             EXCLUS('GROUP_MA_1','GROUP_NO_2'),
                        EXCLUS('GROUP_MA_1','NOEUD_2'),
                   EXCLUS('GROUP_NO_1','GROUP_MA_2'),
                        EXCLUS('GROUP_NO_1','MAILLE_2'),
                        EXCLUS('MAILLE_1','GROUP_NO_2'),
                        EXCLUS('MAILLE_1','NOEUD_2'),
                        EXCLUS('NOEUD_1','GROUP_MA_2'),
                        EXCLUS('NOEUD_1','MAILLE_2'),
                        EXCLUS('SANS_NOEUD','SANS_GROUP_NO'),),
           GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_1        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_1      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_1         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_2        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO_2      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD_2         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           SANS_NOEUD      =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           DDL_1           =SIMP(statut='f',typ='TXM',max='**',defaut="TEMP",
                                 into=("TEMP","TEMP_INF","TEMP_SUP") ),
           COEF_MULT_1     =SIMP(statut='o',typ='R',max='**'),
           DDL_2           =SIMP(statut='f',typ='TXM',max='**',defaut="TEMP",
                                 into=("TEMP","TEMP_INF","TEMP_SUP") ),
           COEF_MULT_2     =SIMP(statut='o',typ='R',max='**'),
           COEF_IMPO       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           SOMMET          =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           TRAN            =SIMP(statut='f',typ='R',max='**'),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max='**'),
           CENTRE          =SIMP(statut='f',typ='R',max='**'),
         ),

         LIAISON_UNIF    =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           DDL             =SIMP(statut='f',typ='TXM',defaut="TEMP",
                                 into=("TEMP","TEMP_INF","TEMP_SUP") ),
         ),

         CONVECTION      =FACT(statut='f',max='**',
           VITESSE         =SIMP(statut='o',typ=cham_no_sdaster ),
         ),

         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 29/03/2011   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
AFFE_MATERIAU=OPER(nom="AFFE_MATERIAU",op=6,sd_prod=cham_mater,
                   fr="Affecter des matriaux  des zones gomtriques d'un maillage",
                         reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
         MAILLAGE        =SIMP(statut='o',typ=maillage_sdaster),
         MODELE          =SIMP(statut='f',typ=modele_sdaster),

         #  affectation du nom du matriau (par mailles):
         #  ----------------------------------------------
         AFFE            =FACT(statut='o',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           MATER           =SIMP(statut='o',typ=mater_sdaster,max=30),
         ),

         #  affectation de comportement (multifibres pour l'instant):
         #  ----------------------------------------------
         AFFE_COMPOR        =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           COMPOR          =SIMP(statut='o',typ=compor_sdaster,max=1),
         ),

         #  affectation des variables de commande :
         #  --------------------------------------------------
         # un mot cl cach qui ne sert qu' boucler sur les VARC possibles :
         LIST_NOM_VARC =SIMP(statut='c',typ='TXM', defaut=("TEMP","CORR","IRRA","HYDR","SECH","EPSA",
                                                           "M_ACIER","M_ZIRC","NEUT1","NEUT2")),

         AFFE_VARC    =FACT(statut='f',max='**',
          regles=(PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                  PRESENT_ABSENT('GROUP_MA','TOUT'),
                  PRESENT_ABSENT('MAILLE','TOUT'),
                  AU_MOINS_UN('EVOL','CHAMP_GD','VALE_REF'),
                  EXCLUS('EVOL','CHAMP_GD'),
                  ),

          TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ), # [dfaut]
          GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
          MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),

          NOM_VARC        =SIMP(statut='o',typ='TXM', 
#                                     champ dans la doc   into=("TEMP","CORR","IRRA","HYDR_ELNO","META_ELNO","NEUT")
#                                     champ dans rscrsd   into=("IRRA","TEMP","HYDR_ELNO","HYDR_NOEU","EPSA_ELNO","META_ELNO")
                                                            ),
          CHAMP_GD        =SIMP(statut='f',typ=cham_gd_sdaster,),
          EVOL            =SIMP(statut='f',typ=evol_sdaster,),

          B_EVOL          =BLOC(condition="EVOL!=None",
              NOM_CHAM      =SIMP(statut='f',typ='TXM',into=("TEMP","CORR","IRRA","NEUT"
                                                             "HYDR_ELNO","HYDR_NOEU",
                                                             "META_ELNO","META_NOEU",
                                                             "EPSA_ELNO","EPSA_NOEU",)),
              PROL_DROITE   =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
              PROL_GAUCHE   =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
              FONC_INST     =SIMP(statut='f',typ=(fonction_sdaster,formule)),
          ),
          VALE_REF          =SIMP(statut='f',typ='R'),
         ),

         #  mots cls cachs pour les variables de commande NEUTi :
         #  -------------------------------------------------------
         VARC_NEUT1   =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="NEUT1"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="NEUT_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("X1")),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("NEUT1")),
         ),
         VARC_NEUT2   =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="NEUT2"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="NEUT_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("X1")),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("NEUT2")),
         ),

         #  mots cls cachs pour variable de commande TEMP :
         #  --------------------------------------------------
         VARC_TEMP    =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="TEMP"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="TEMP_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("TEMP",)),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("TEMP",)),
           VALE_DEF        =SIMP(statut='c',typ='R',max=1,min=1,defaut=(0.,)),
         ),

         #  mots cls cachs pour variable de commande SECH :
         #  --------------------------------------------------
         VARC_SECH    =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="SECH"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="TEMP_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("TEMP",)),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("SECH",)),
         ),

         #  mots cls cachs pour variable de commande HYDR :
         #  --------------------------------------------------
         VARC_HYDR    =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="HYDR"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="HYDR_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("HYDR",)),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("HYDR",)),
         ),

         #  mots cls cachs pour variable de commande CORR :
         #  --------------------------------------------------
         VARC_CORR    =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="CORR"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="CORR_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("CORR",)),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("CORR",)),
         ),

         #  mots cls cachs pour variable de commande IRRA :
         #  --------------------------------------------------
         VARC_IRRA    =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="IRRA"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="IRRA_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("IRRA",)),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=1,min=1,defaut=("IRRA",)),
         ),

         #  mots cls cachs pour variable de commande EPSA :
         #  --------------------------------------------------
         VARC_EPSA    =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="EPSA"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="EPSI_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=6,min=6,defaut=("EPXX","EPYY","EPZZ","EPXY","EPXZ","EPYZ",)),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=6,min=6,defaut=("EPSAXX","EPSAYY","EPSAZZ","EPSAXY","EPSAXZ","EPSAYZ",)),
         ),
         #  mots cls cachs pour variable de commande metallurgique ACIER :
         #  -----------------------------------------------------------------
         VARC_M_ACIER  =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="M_ACIER"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="VARI_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=7,min=7,defaut=("V1","V2","V3","V4","V5","V6","V7")),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=7,min=7,defaut=("PFERRITE","PPERLITE","PBAINITE",
                                                                          "PMARTENS","TAUSTE","TRANSF","TACIER",)),
         ),
         #  mots cls cachs pour variable de commande metallurgique ZIRCALOY :
         #  --------------------------------------------------------------------
         VARC_M_ZIRC  =FACT(statut='d',
           NOM_VARC        =SIMP(statut='c',typ='TXM',defaut="M_ZIRC"),
           GRANDEUR        =SIMP(statut='c',typ='TXM',defaut="VARI_R"),
           CMP_GD          =SIMP(statut='c',typ='TXM',max=4,min=4,defaut=("V1","V2","V3","V4")),
           CMP_VARC        =SIMP(statut='c',typ='TXM',max=4,min=4,defaut=("ALPHPUR","ALPHBETA","TZIRC","TEMPS")),
         ),

         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
)  ;


#& MODIF COMMANDE  DATE 22/03/2011   AUTEUR DESOZA T.DESOZA 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
AFFE_MODELE=OPER(nom="AFFE_MODELE",op=18,sd_prod=modele_sdaster,
            UIinfo={"groupes":("Modlisation",)},
                 fr="Dfinir le phnomne physique modlis et le type d'lments finis sur le maillage",reentrant='n',
         regles=(AU_MOINS_UN('AFFE','AFFE_SOUS_STRUC'),UN_PARMI('MAILLAGE','GRILLE')),
         MAILLAGE        =SIMP(statut='f',typ=maillage_sdaster),
         GRILLE          =SIMP(statut='f',typ=grille_sdaster),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
         VERIF           =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max=2,into=("MAILLE","NOEUD") ),
#
#====
# Dfinition des grandeurs caractristiques
#====
#
         GRANDEUR_CARA =FACT(statut='f',max=1,
         fr="Grandeurs caractristiques pour l'adimensionnement des indicateurs d'erreur HM",
         ang="Characteristic data for HM error estimators adimensionalisation",
#
            LONGUEUR      =SIMP(statut='f',typ='R',val_min=0,
                                fr ="Longueur caractristique",
                                ang="Characteristic length",),
            PRESSION      =SIMP(statut='f',typ='R',val_min=0,
                                fr ="Pression caractristique",
                                ang="Characteristic pressure",),
            TEMPERATURE   =SIMP(statut='f',typ='R',val_min=0,
                                fr ="Temprature caractristique",
                                ang="Characteristic temperature",),),
#
         AFFE_SOUS_STRUC =FACT(statut='f',
           regles=(UN_PARMI('TOUT','SUPER_MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           SUPER_MAILLE    =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
           PHENOMENE       =SIMP(statut='f',typ='TXM',defaut="MECANIQUE",into=("MECANIQUE",) ),
         ),
         AFFE            =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','GROUP_NO','MAILLE','NOEUD'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           PHENOMENE       =SIMP(statut='o',typ='TXM',
                                 into=("MECANIQUE","THERMIQUE","ACOUSTIQUE") ),
                b_mecanique     =BLOC( condition = "PHENOMENE=='MECANIQUE'",
                                        fr="modlisations mcaniques",
                    MODELISATION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',into=(
                                  "2D_DIS_T",        # RESP. : FLEJOU J.L.FLEJOU
                                  "2D_DIS_TR",       # RESP. : FLEJOU J.L.FLEJOU
                                  "2D_FLUI_ABSO",    # RESP. : DEVESA G.DEVESA
                                  "2D_FLUI_PESA",    # RESP. : GREFFET N.GREFFET
                                  "2D_FLUI_STRU",    # RESP. : GREFFET N.GREFFET
                                  "2D_FLUIDE",       # RESP. : GREFFET N.GREFFET
                                  "3D",              # RESP. : DESROCHES X.DESROCHES
                                  "3D_ABSO",         # RESP. : DEVESA G.DEVESA
                                  "3D_FAISCEAU",     # RESP. : VOLDOIRE F.VOLDOIRE
                                  "3D_FLUI_ABSO",    # RESP. : DEVESA G.DEVESA
                                  "3D_FLUIDE",       # RESP. : GREFFET N.GREFFET
                                  "3D_INCO",         # RESP. : MICHEL S.MICHEL
                                  "3D_INCO_UP",      # RESP. : SFAYOLLE
                                  "3D_INCO_GD",      # RESP. : MICHEL S.MICHEL
                                  "3D_SI",           # RESP. : DESROCHES X.DESROCHES
                                  "3D_GRAD_EPSI",    # RESP. : MICHEL S.MICHEL
                                  "3D_GRAD_VARI",    # RESP. : MICHEL S.MICHEL
                                  "3D_GVNO",         # RESP. : BEAURAIN J.BEAURAIN
                                  "3D_XFEM_CONT",    # RESP. : GENIAUT S.GENIAUT
                                  "3D_JOINT",        # RESP. : LAVERNE J.LAVERNE
                                  "3D_JOINT_HYME",   # RESP. : LAVERNE J.LAVERNE
                                  "3D_INTERFACE",    # RESP. : LAVERNE J.LAVERNE
                                  "AXIS",            # RESP. : LEFEBVRE J.P.LEFEBVRE
                                  "AXIS_FLUI_STRU",  # RESP. : GREFFET N.GREFFET
                                  "AXIS_FLUIDE",     # RESP. : GREFFET N.GREFFET
                                  "AXIS_FOURIER",    # RESP. : DESROCHES X.DESROCHES
                                  "AXIS_INCO",       # RESP. : MICHEL S.MICHEL
                                  "AXIS_INCO_UP",    # RESP. : SFAYOLLE
                                  "AXIS_INCO_GD",    # RESP. : MICHEL S.MICHEL
                                  "AXIS_SI",         # RESP. : DESROCHES X.DESROCHES
                                  "AXIS_GRAD_VARI",  # RESP. : MICHEL S.MICHEL
                                  "AXIS_GVNO",       # RESP. : BEAURAIN J.BEAURAIN
                                  "AXIS_JOINT",      # RESP. : LAVERNE J.LAVERNE
                                  "AXIS_INTERFACE",  # RESP. : LAVERNE J.LAVERNE
                                  "AXIS_ELDI",       # RESP. : LAVERNE J.LAVERNE
                                  "BARRE",           # RESP. : FLEJOU J.L.FLEJOU
                                  "2D_BARRE",        # RESP. : FLEJOU J.L.FLEJOU
                                  "C_PLAN",          # RESP. : LEFEBVRE J.P.LEFEBVRE
                                  "C_PLAN_XFEM_CONT",# RESP. : GENIAUT S.GENIAUT
                                  "C_PLAN_SI",       # RESP. : DESROCHES X.DESROCHES
                                  "C_PLAN_GRAD_EPSI",# RESP. : MICHEL S.MICHEL
                                  "CABLE",           # RESP. : FLEJOU J.L.FLEJOU
                                  "CABLE_POULIE",    # RESP. : None
                                  "COQUE_3D",        # RESP. : DESROCHES X.DESROCHES
                                  "COQUE_AXIS",      # RESP. : DESROCHES X.DESROCHES
                                  "COQUE_C_PLAN",    # RESP. : DESROCHES X.DESROCHES
                                  "COQUE_D_PLAN",    # RESP. : DESROCHES X.DESROCHES
                                  "D_PLAN",          # RESP. : LEFEBVRE J.P.LEFEBVRE
                                  "D_PLAN_XFEM_CONT",# RESP. : GENIAUT S.GENIAUT
                                  "D_PLAN_GRAD_EPSI",# RESP. : MICHEL S.MICHEL
                                  "D_PLAN_GRAD_VARI",# RESP. : MICHEL S.MICHEL
                                  "D_PLAN_GVNO",     # RESP. : BEAURAIN J.BEAURAIN
                                  "D_PLAN_GRAD_SIGM",# RESP. : GRANET S.GRANET
                                  "PLAN_JOINT",      # RESP. : LAVERNE J.LAVERNE
                                  "PLAN_JOINT_HYME", # RESP. : LAVERNE J.LAVERNE
                                  "PLAN_INTERFACE",  # RESP. : LAVERNE J.LAVERNE
                                  "PLAN_ELDI",       # RESP. : LAVERNE J.LAVERNE
                                  "D_PLAN_ABSO",     # RESP. : DEVESA G.DEVESA
                                  "D_PLAN_INCO",     # RESP. : MICHEL S.MICHEL
                                  "D_PLAN_INCO_UP",  # RESP. : SFAYOLLE
                                  "D_PLAN_INCO_GD",  # RESP. : MICHEL S.MICHEL
                                  "D_PLAN_SI",       # RESP. : DESROCHES X.DESROCHES
                                  "DIS_T",           # RESP. : FLEJOU J.L.FLEJOU
                                  "DIS_TR",          # RESP. : FLEJOU J.L.FLEJOU
                                  "DKT",             # RESP. : DESROCHES X.DESROCHES
                                  "DKTG",            # RESP. : MARKOVIC D.MARKOVIC
                                  "DST",             # RESP. : DESROCHES X.DESROCHES
                                  "FLUI_STRU",       # RESP. : GREFFET N.GREFFET
                                  "GRILLE_EXCENTRE", # RESP. : ROSPARS C.ROSPARS
                                  "GRILLE_MEMBRANE", # RESP. : ROSPARS C.ROSPARS
                                  "POU_C_T",         # RESP. : FLEJOU J.L.FLEJOU
                                  "POU_D_E",         # RESP. : FLEJOU J.L.FLEJOU
                                  "POU_D_EM",        # RESP. : FLEJOU J.L.FLEJOU
                                  "POU_D_T",         # RESP. : FLEJOU J.L.FLEJOU
                                  "POU_D_T_GD",      # RESP. : FLEJOU J.L.FLEJOU
                                  "POU_D_TG",        # RESP. : FLEJOU J.L.FLEJOU
                                  "POU_D_TGM",       # RESP. : FLEJOU J.L.FLEJOU
                                  "Q4G",             # RESP. : DESROCHES X.DESROCHES
                                  "TUYAU_3M",        # RESP. : PROIX J.M.PROIX
                                  "TUYAU_6M",        # RESP. : PROIX J.M.PROIX
                                  "SHB",             # RESP. : DESROCHES X.DESROCHES
                                  "D_PLAN_HHM",      # RESP. : GRANET S.GRANET
                                  "D_PLAN_HM",       # RESP. : GRANET S.GRANET
                                  "D_PLAN_THM",      # RESP. : GRANET S.GRANET
                                  "D_PLAN_HHMD",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_HH2MD",    # RESP. : GRANET S.GRANET
                                  "D_PLAN_HMD",      # RESP. : GRANET S.GRANET
                                  "D_PLAN_THHD",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_THH2D",    # RESP. : GRANET S.GRANET
                                  "D_PLAN_THVD",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_THH2MD",   # RESP. : GRANET S.GRANET
                                  "D_PLAN_THHMD",    # RESP. : GRANET S.GRANET
                                  "D_PLAN_THMD",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_HHMS",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_HH2MS",    # RESP. : GRANET S.GRANET
                                  "D_PLAN_HMS",      # RESP. : GRANET S.GRANET
                                  "D_PLAN_THHS",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_THH2S",    # RESP. : GRANET S.GRANET
                                  "D_PLAN_THVS",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_THH2MS",   # RESP. : GRANET S.GRANET
                                  "D_PLAN_THHMS",    # RESP. : GRANET S.GRANET
                                  "D_PLAN_THMS",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_HM_P",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_HS",       # RESP. : GRANET S.GRANET
                                  "D_PLAN_HHD",      # RESP. : GRANET S.GRANET
                                  "D_PLAN_HHS",      # RESP. : GRANET S.GRANET
                                  "D_PLAN_HH2D",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_HH2S",     # RESP. : GRANET S.GRANET
                                  "D_PLAN_2DG",      # RESP. : GRANET S.GRANET
                                  "D_PLAN_DIL",      # RESP. : GRANET S.GRANET
                                  "AXIS_THM",        # RESP. : GRANET S.GRANET
                                  "AXIS_HHM",        # RESP. : GRANET S.GRANET
                                  "AXIS_HM",         # RESP. : GRANET S.GRANET
                                  "AXIS_HH2MD",      # RESP. : GRANET S.GRANET
                                  "AXIS_HHMD",       # RESP. : GRANET S.GRANET
                                  "AXIS_HMD",        # RESP. : GRANET S.GRANET
                                  "AXIS_THHD",       # RESP. : GRANET S.GRANET
                                  "AXIS_THH2D",      # RESP. : GRANET S.GRANET
                                  "AXIS_THVD",       # RESP. : GRANET S.GRANET
                                  "AXIS_THHMD",      # RESP. : GRANET S.GRANET
                                  "AXIS_THH2MD",     # RESP. : GRANET S.GRANET
                                  "AXIS_THMD",       # RESP. : GRANET S.GRANET
                                  "AXIS_HH2MS",      # RESP. : GRANET S.GRANET
                                  "AXIS_HHMS",       # RESP. : GRANET S.GRANET
                                  "AXIS_HMS",        # RESP. : GRANET S.GRANET
                                  "AXIS_THHS",       # RESP. : GRANET S.GRANET
                                  "AXIS_THH2S",      # RESP. : GRANET S.GRANET
                                  "AXIS_THVS",       # RESP. : GRANET S.GRANET
                                  "AXIS_THHMS",      # RESP. : GRANET S.GRANET
                                  "AXIS_THH2MS",     # RESP. : GRANET S.GRANET
                                  "AXIS_THMS",       # RESP. : GRANET S.GRANET
                                  "AXIS_HHD",        # RESP. : GRANET S.GRANET
                                  "AXIS_HHS",        # RESP. : GRANET S.GRANET
                                  "AXIS_HH2D",       # RESP. : GRANET S.GRANET
                                  "AXIS_HH2S",       # RESP. : GRANET S.GRANET
                                  "3D_HHM" ,         # RESP. : GRANET S.GRANET
                                  "3D_HM",           # RESP. : GRANET S.GRANET
                                  "3D_THHM",         # RESP. : GRANET S.GRANET
                                  "3D_THM",          # RESP. : GRANET S.GRANET
                                  "3D_HHMD",         # RESP. : GRANET S.GRANET
                                  "3D_HMD",          # RESP. : GRANET S.GRANET
                                  "3D_THHD",         # RESP. : GRANET S.GRANET
                                  "3D_THVD",         # RESP. : GRANET S.GRANET
                                  "3D_THHMD",        # RESP. : GRANET S.GRANET
                                  "3D_THMD",         # RESP. : GRANET S.GRANET
                                  "3D_HHMS",         # RESP. : GRANET S.GRANET
                                  "3D_HMS",          # RESP. : GRANET S.GRANET
                                  "3D_THHS",         # RESP. : GRANET S.GRANET
                                  "3D_THVS",         # RESP. : GRANET S.GRANET
                                  "3D_THHMS",        # RESP. : GRANET S.GRANET
                                  "3D_THMS",         # RESP. : GRANET S.GRANET
                                  "3D_THH2MD",       # RESP. : GRANET S.GRANET
                                  "3D_THH2MS",       # RESP. : GRANET S.GRANET
                                  "3D_HH2MD",        # RESP. : GRANET S.GRANET
                                  "3D_HH2MS",        # RESP. : GRANET S.GRANET
                                  "3D_THH2S",        # RESP. : GRANET S.GRANET
                                  "3D_THH2D",        # RESP. : GRANET S.GRANET
                                  "3D_HS",           # RESP. : GRANET S.GRANET
                                  "3D_HHD",          # RESP. : GRANET S.GRANET
                                  "3D_HHS",          # RESP. : GRANET S.GRANET
                                  "3D_HH2D",         # RESP. : GRANET S.GRANET
                                  "3D_HH2S",         # RESP. : GRANET S.GRANET
                                  "VF1",             # RESP. : GRANET S.GRANET
                                  "3D_HH2SUDM",      # RESP. : GRANET S.GRANET
                                  "3D_HH2SUDA",      # RESP. : GRANET S.GRANET
                                  "3D_HH2SUC",       # RESP. : GRANET S.GRANET
                                  "D_PLAN_HH2SUDM",  # RESP. : GRANET S.GRANET
                                  "D_PLAN_HH2SUC",   # RESP. : GRANET S.GRANET
                                  "D_PLAN_HH2SUDA",  # RESP. : GRANET S.GRANET
                                  "PLAN_JHMS",
                                  "AXIS_JHMS",
                                                                      )  )  ),

                b_thermique     =BLOC( condition = "PHENOMENE=='THERMIQUE'",
                                        fr="modlisations thermiques",
                    MODELISATION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',into=(
                                  "3D",              # RESP. : DURAND C.DURAND
                                  "3D_DIAG",         # RESP. : DURAND C.DURAND
                                  "AXIS",            # RESP. : DURAND C.DURAND
                                  "AXIS_DIAG",       # RESP. : DURAND C.DURAND
                                  "AXIS_FOURIER",    # RESP. : DESROCHES X.DESROCHES
                                  "COQUE",           # RESP. : DESROCHES X.DESROCHES
                                  "COQUE_AXIS",      # RESP. : DESROCHES X.DESROCHES
                                  "COQUE_PLAN",      # RESP. : DESROCHES X.DESROCHES
                                  "PLAN",            # RESP. : DURAND C.DURAND
                                  "PLAN_DIAG",       # RESP. : DURAND C.DURAND
                                                                      ),),),

                b_acoustique    =BLOC( condition = "PHENOMENE=='ACOUSTIQUE'",
                                        fr="modlisations acoustiques",
                     MODELISATION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',into=(
                                  "3D",              # RESP. : None
                                  "PLAN"             # RESP. : None
                                                                       ), ),),

         ),

         PARTITION         =FACT(statut='d',
             PARALLELISME    =SIMP(statut='f',typ='TXM',defaut="GROUP_ELEM",
                                   into=("MAIL_CONTIGU","MAIL_DISPERSE","CENTRALISE","GROUP_ELEM")),
             b_dist_maille          =BLOC(condition = "PARALLELISME in ('MAIL_DISPERSE','MAIL_CONTIGU')",
                 CHARGE_PROC0_MA =SIMP(statut='f',typ='I',defaut=100,val_min=0,val_max=100),
             ),
         ),

         VERI_JACOBIEN  =SIMP(statut='f',typ='TXM',into=('OUI','NON'),defaut='OUI',
                              fr ="Vrification de la forme des mailles (jacobiens tous de meme signe).",),
) ;
#& MODIF COMMANDE  DATE 25/01/2011   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE PELLET J.PELLET

def appl_cine_matr_prod(MATR_ASSE,**args):
  if AsType(MATR_ASSE) == matr_asse_depl_r : return matr_asse_depl_r
  if AsType(MATR_ASSE) == matr_asse_depl_c : return matr_asse_depl_c
  if AsType(MATR_ASSE) == matr_asse_temp_r : return matr_asse_temp_r
  if AsType(MATR_ASSE) == matr_asse_temp_c : return matr_asse_temp_c
  if AsType(MATR_ASSE) == matr_asse_pres_r : return matr_asse_pres_r
  if AsType(MATR_ASSE) == matr_asse_pres_c : return matr_asse_pres_c
  raise AsException("type de concept resultat non prevu")

APPL_CINE_MATR=OPER(nom="APPL_CINE_MATR",op=158,sd_prod=appl_cine_matr_prod,
               fr="Appliquer les C.L. cinmatiques sur la matrice",
               reentrant='f', UIinfo={"groupes":("Rsolution",)},
         MATR_ASSE       =SIMP(statut='o',typ=(matr_asse_depl_r,matr_asse_depl_c,matr_asse_temp_r,
                                               matr_asse_temp_c,matr_asse_pres_r,matr_asse_pres_c) ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 25/01/2011   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE PELLET J.PELLET

APPL_CINE_SCMB=OPER(nom="APPL_CINE_SCMB",op=159,sd_prod=cham_no_sdaster,reentrant='f',
               fr="Application des C.L. cinmatiques au second membre",
               UIinfo={"groupes":("Rsolution",)},
         CHAM_NO        =SIMP(statut='o',typ=cham_no_sdaster),
         MATR           =SIMP(statut='o',typ=(matr_asse_depl_r,matr_asse_depl_c,matr_asse_temp_r,
                                               matr_asse_temp_c,matr_asse_pres_r,matr_asse_pres_c) ),
         CHAM_CINE       =SIMP(statut='f',typ=cham_no_sdaster),

         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 03/01/2011   AUTEUR ANDRIAM H.ANDRIAMBOLOLONA 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ANDRIAM H.ANDRIAMBOLOLONA

from Macro.asse_elem_ssd_ops import asse_elem_ssd_ops

def asse_elem_ssd_prod(self,RESU_ASSE_SSD,**args):
    MTYPES = {
        'MODELE' : modele_gene,
        'NUME_DDL_GENE' : nume_ddl_gene,
        'RIGI_GENE' : matr_asse_gene_r,
        'MASS_GENE' : matr_asse_gene_r,
              }
    for res in RESU_ASSE_SSD:
        for mc, typ in MTYPES.items():
            if res[mc]:
                self.type_sdprod(res[mc], typ)
    return None

ASSE_ELEM_SSD=MACRO(nom="ASSE_ELEM_SSD",
        op=asse_elem_ssd_ops,
        sd_prod=asse_elem_ssd_prod,
        reentrant='n',
        fr="Enchainer les commandes DEFI_MODELE_GENE, NUME_DDL_GENE et ASSE_MATR_GENE",
        UIinfo={"groupes":("Matrices/vecteurs",)},

# pour les concepts de sortie
        RESU_ASSE_SSD = FACT( statut='o', max=1,
                          regles=(PRESENT_PRESENT('RIGI_GENE','NUME_DDL_GENE'),
                                  PRESENT_PRESENT('MASS_GENE','NUME_DDL_GENE'),),
                              MODELE=SIMP(statut='o',typ=CO,defaut=None),
                              NUME_DDL_GENE=SIMP(statut='f',typ=CO,defaut=None),
                              RIGI_GENE=SIMP(statut='f',typ=CO,defaut=None),
                              MASS_GENE=SIMP(statut='f',typ=CO,defaut=None),
                           ),

        INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),

# pour DEFI_MODELE_GENE
        SOUS_STRUC      =FACT(statut='o',max='**',
           NOM             =SIMP(statut='o',typ='TXM' ),
           MACR_ELEM_DYNA  =SIMP(statut='o',typ=macr_elem_dyna ),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
           TRANS           =SIMP(statut='f',typ='R',max=3),
         ),
        LIAISON         =FACT(statut='o',max='**',
           SOUS_STRUC_1    =SIMP(statut='o',typ='TXM' ),
           INTERFACE_1     =SIMP(statut='o',typ='TXM' ),
           SOUS_STRUC_2    =SIMP(statut='o',typ='TXM' ),
           INTERFACE_2     =SIMP(statut='o',typ='TXM' ),
           regles=(EXCLUS('GROUP_MA_MAIT_1','GROUP_MA_MAIT_2','MAILLE_MAIT_2'),
                   EXCLUS('MAILLE_MAIT_1','GROUP_MA_MAIT_2','MAILLE_MAIT_2'),),
           GROUP_MA_MAIT_1   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_MAIT_1     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA_MAIT_2   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_MAIT_2     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           OPTION            =SIMP(statut='f',typ='TXM',defaut="CLASSIQUE",into=("REDUIT","CLASSIQUE") ),
         ),
        VERIF           =FACT(statut='d',max=1,
           STOP_ERREUR     =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-3 ),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
         ),


# pour NUME_DDL_GENE
        METHODE      =SIMP(statut='f',typ='TXM',defaut="CLASSIQUE",into=("CLASSIQUE","ELIMINE") ),
        STOCKAGE     =SIMP(statut='f',typ='TXM',defaut="LIGN_CIEL",into=("LIGN_CIEL","PLEIN") ),

)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
ASSE_MAILLAGE=OPER(nom="ASSE_MAILLAGE",op= 105,sd_prod=maillage_sdaster,
                   fr="Assembler deux maillages pour en former un nouveau",
                   reentrant='n',
                   UIinfo={"groupes":("Maillage",)},
         MAILLAGE_1 =  SIMP(statut='o',typ=maillage_sdaster,),
         MAILLAGE_2 =  SIMP(statut='o',typ=maillage_sdaster,),
         OPERATION  =  SIMP(statut='o',typ='TXM',into=("SOUS_STR","SUPERPOSE","COLLAGE"),),
         b_collage  =  BLOC(condition = "OPERATION == 'COLLAGE'",
           COLLAGE  =  FACT(statut='o',
              GROUP_MA_1     =SIMP(statut='o',typ=grma),
              GROUP_MA_2     =SIMP(statut='o',typ=grma),
                             ),
                           ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE BODEL C.BODEL
def asse_matr_gene_prod(METHODE,**args):
    if   (METHODE=="INITIAL") : return matr_asse_gene_r
    elif (args['OPTION']=="RIGI_GENE_C") : return matr_asse_gene_c
    else : return matr_asse_gene_r

ASSE_MATR_GENE=OPER(nom="ASSE_MATR_GENE",op= 128,sd_prod=asse_matr_gene_prod,
                    fr="Assemblage des matrices gnralises de macro lments pour construction de la matrice globale gnralise",
                    reentrant='n',
            UIinfo={"groupes":("Matrices et vecteurs",)},
         NUME_DDL_GENE   =SIMP(statut='o',typ=nume_ddl_gene ),
         METHODE          =SIMP(statut='f',typ='TXM',defaut="CLASSIQUE",into=("CLASSIQUE","INITIAL") ),
         b_option     =BLOC(condition = "METHODE == 'CLASSIQUE'",
           OPTION          =SIMP(statut='o',typ='TXM',into=("RIGI_GENE","RIGI_GENE_C","MASS_GENE","AMOR_GENE") ),
           ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
def asse_matrice_prod(MATR_ELEM,**args):
  if AsType(MATR_ELEM) == matr_elem_depl_r : return matr_asse_depl_r
  if AsType(MATR_ELEM) == matr_elem_depl_c : return matr_asse_depl_c
  if AsType(MATR_ELEM) == matr_elem_temp_r : return matr_asse_temp_r
  if AsType(MATR_ELEM) == matr_elem_pres_c : return matr_asse_pres_c
  raise AsException("type de concept resultat non prevu")

ASSE_MATRICE=OPER(nom="ASSE_MATRICE",op=12,sd_prod=asse_matrice_prod,
                  fr="Construction d'une matrice assemble",reentrant='n',
            UIinfo={"groupes":("Matrices et vecteurs",)},
         MATR_ELEM       =SIMP(statut='o',
                               typ=(matr_elem_depl_r,matr_elem_depl_c,matr_elem_temp_r,matr_elem_pres_c) ),
         NUME_DDL        =SIMP(statut='o',typ=nume_ddl_sdaster),
         SYME            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
         CHAR_CINE       =SIMP(statut='f',typ=(char_cine_meca,char_cine_ther,char_cine_acou) ),
         INFO            =SIMP(statut='f',typ='I',into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET

ASSE_VECTEUR=OPER(nom="ASSE_VECTEUR",op=13,sd_prod=cham_no_sdaster,
                  fr="Construire un champ aux noeuds par assemblage de vecteurs lmentaires",reentrant='n',
            UIinfo={"groupes":("Matrices et vecteurs",)},
         VECT_ELEM       =SIMP(statut='o',typ=vect_elem,max='**'),
         NUME_DDL        =SIMP(statut='o',typ=nume_ddl_sdaster ),
         INFO            =SIMP(statut='f',typ='I',into=(1,2,) ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE BODEL C.BODEL
ASSE_VECT_GENE=OPER(nom="ASSE_VECT_GENE",op= 140,sd_prod=vect_asse_gene,
                    fr="Projection des chargements sur la base modale d'une sous structure",
                    reentrant='n',
            UIinfo={"groupes":("Matrices et vecteurs",)},
         NUME_DDL_GENE   =SIMP(statut='o',typ=nume_ddl_gene ),
         METHODE          =SIMP(statut='f',typ='TXM',defaut="CLASSIQUE",into=("CLASSIQUE","INITIAL") ),
         b_nume     =BLOC(condition = "METHODE == 'CLASSIQUE'",
             CHAR_SOUS_STRUC =FACT(statut='o',max='**',
             SOUS_STRUC      =SIMP(statut='o',typ='TXM' ),
             VECT_ASSE       =SIMP(statut='o',typ=cham_no_sdaster ),
           ),
         ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DEVESA G.DEVESA
CALC_AMOR_MODAL=OPER(nom="CALC_AMOR_MODAL",op= 172,sd_prod=listr8_sdaster,
                     fr="Cration d'une liste d'amortissements modaux calculs selon la rgle du RCC-G",
                     reentrant='n',
            UIinfo={"groupes":("Rsolution","Dynamique",)},
       regles=(EXCLUS('AMOR_RAYLEIGH','ENER_SOL',),
               EXCLUS('AMOR_RAYLEIGH','AMOR_INTERNE',),
               EXCLUS('AMOR_RAYLEIGH','AMOR_SOL',),
               PRESENT_PRESENT('ENER_SOL','AMOR_INTERNE'),
               PRESENT_PRESENT('ENER_SOL','AMOR_SOL'),
               ),
         AMOR_RAYLEIGH   =FACT(statut='f',
           AMOR_ALPHA      =SIMP(statut='o',typ='R'),
           AMOR_BETA       =SIMP(statut='o',typ='R'),
           MODE_MECA       =SIMP(statut='o',typ=mode_meca ),
         ),
         ENER_SOL        =FACT(statut='f',
           regles=(UN_PARMI('GROUP_NO_RADIER','GROUP_MA_RADIER'),
                   PRESENT_ABSENT('COEF_GROUP','FONC_GROUP'),
#  Peut-on remplacer les deux rgles suivantes par un ENSEMBLE_('KRX','KRY','KRZ')
                   PRESENT_PRESENT('KRX','KRY'),
                   PRESENT_PRESENT('KRX','KRZ'),
                   PRESENT_ABSENT('COOR_CENTRE','NOEUD_CENTRE'),
                   PRESENT_ABSENT('GROUP_NO_CENTRE','NOEUD_CENTRE'),
                   PRESENT_ABSENT('GROUP_NO_CENTRE','COOR_CENTRE'),),
           METHODE         =SIMP(statut='f',typ='TXM',defaut="DEPL",into=("DEPL","RIGI_PARASOL") ),
           MODE_MECA       =SIMP(statut='o',typ=mode_meca ),
           GROUP_NO_RADIER =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           GROUP_MA_RADIER =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           FONC_GROUP      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           COEF_GROUP      =SIMP(statut='f',typ='R',max='**'),
           KX              =SIMP(statut='o',typ='R' ),
           KY              =SIMP(statut='o',typ='R' ),
           KZ              =SIMP(statut='o',typ='R' ),
           KRX             =SIMP(statut='f',typ='R' ),
           KRY             =SIMP(statut='f',typ='R' ),
           KRZ             =SIMP(statut='f',typ='R' ),
           GROUP_NO_CENTRE =SIMP(statut='f',typ=grno),
           NOEUD_CENTRE    =SIMP(statut='f',typ=no),
           COOR_CENTRE     =SIMP(statut='f',typ='R',max=3),
         ),
         AMOR_INTERNE    =FACT(statut='f',
           ENER_POT        =SIMP(statut='o',typ=table_sdaster ),
           GROUP_MA        =SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**'),
           AMOR_REDUIT     =SIMP(statut='o',typ='R',max='**'),
         ),
         AMOR_SOL        =FACT(statut='f',
           AMOR_REDUIT     =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           FONC_AMOR_GEO   =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule),max='**' ),
           HOMOGENE        =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           SEUIL           =SIMP(statut='f',typ='R',defaut= 0.3 ),
         ),
)  ;
#& MODIF COMMANDE  DATE 13/01/2011   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ASSIRE A.ASSIRE

CALC_CHAM_ELEM=OPER(nom="CALC_CHAM_ELEM",op=38,sd_prod=cham_elem,
                    fr="Calculer un champ lmentaire en thermique et en accoustique  partir de champs dj calculs",
                    reentrant='n',
            UIinfo={"groupes":("Rsultats et champs","Post-traitements",)},
         MODELE          =SIMP(statut='o',typ=modele_sdaster),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater),
         CARA_ELEM       =SIMP(statut='f',typ=cara_elem),

         regles=(EXCLUS('TOUT','GROUP_MA',),EXCLUS('TOUT','MAILLE',),),
         TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
         GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
         MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),

#
#
#  introduire un mot cle de type modelisation : mcanique,thermique,...
#

         OPTION          =SIMP(statut='o',typ='TXM',
                               into=("FLUX_ELGA","FLUX_ELNO",
                                     "PRAC_ELNO",
                                     "COOR_ELGA"), ),

         b_thermique  =BLOC(condition="OPTION in ('FLUX_ELNO','FLUX_ELGA',)",
           TEMP            =SIMP(statut='o',typ=(cham_no_sdaster,)),
         ),

         b_acoustique  =BLOC(condition="OPTION in ('PRAC_ELNO',)",
           PRES            =SIMP(statut='o',typ=(cham_no_sdaster,)),
         ),



         EXCIT           =FACT(statut='f',max='**',
               regles=(EXCLUS('FONC_MULT','COEF_MULT', ),),
               CHARGE          =SIMP(statut='o',typ=(char_meca,char_ther,char_acou)),
               FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
               COEF_MULT       =SIMP(statut='f',typ='R'), ),

         INST            =SIMP(statut='f',typ='R',defaut= 0.E+0),
         ACCE            =SIMP(statut='f',typ=cham_no_sdaster),
         NUME_COUCHE     =SIMP(statut='f',typ='I',defaut= 1),
         NIVE_COUCHE     =SIMP(statut='f',typ='TXM',defaut="MOY",into=("SUP","INF","MOY") ),
         MODE_FOURIER    =SIMP(statut='f',typ='I',defaut= 0 ),
         ANGLE           =SIMP(statut='f',typ='I',defaut= 0),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET

CALC_CHAR_CINE=OPER(nom="CALC_CHAR_CINE",op= 102,sd_prod=cham_no_sdaster,
                    fr="Calcul des seconds membres associs  des charges cinmatiques (conditions aux limites non dualises)",
                    reentrant='n',
            UIinfo={"groupes":("Matrices et vecteurs",)},
         NUME_DDL        =SIMP(statut='o',typ=nume_ddl_sdaster ),
         CHAR_CINE       =SIMP(statut='o',typ=(char_cine_meca,char_cine_ther,char_cine_acou ),validators=NoRepeat(),max='**' ),
         INST            =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2 ) ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DEVESA G.DEVESA
def calc_char_seisme_prod(MATR_MASS,**args ):
  if AsType(MATR_MASS) == matr_asse_depl_r : return cham_no_sdaster
  raise AsException("type de concept resultat non prevu")

CALC_CHAR_SEISME=OPER(nom="CALC_CHAR_SEISME",op=  92,sd_prod=calc_char_seisme_prod,
                      reentrant='n',fr="Calcul du chargement sismique",
            UIinfo={"groupes":("Matrices et vecteurs",)},
         regles=(UN_PARMI('MONO_APPUI','MODE_STAT' ),),
         MATR_MASS       =SIMP(statut='o',typ=matr_asse_depl_r,fr="Matrice de masse" ),
         DIRECTION       =SIMP(statut='o',typ='R',max=6,fr="Directions du sisme impos"),
         MONO_APPUI      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
         MODE_STAT       =SIMP(statut='f',typ=(mode_meca,) ),
         b_mode_stat     =BLOC ( condition = "MODE_STAT != None",
           regles=(UN_PARMI('NOEUD','GROUP_NO' ),),
           NOEUD           =SIMP(statut='f',typ=no,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 28/02/2011   AUTEUR BOTTONI M.BOTTONI 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE BOTTONI M.BOTTONI

from Macro.calc_ecrevisse_ops import calc_ecrevisse_ops

def calc_ecrevisse_prod(self,CHARGE_MECA,CHARGE_THER1,CHARGE_THER2,TABLE,DEBIT,**args):

  self.type_sdprod(CHARGE_MECA,char_meca)
  self.type_sdprod(CHARGE_THER1,char_ther)
  self.type_sdprod(CHARGE_THER2,char_ther)
  self.type_sdprod(TABLE,table_sdaster)
  self.type_sdprod(DEBIT,table_sdaster)
  return None



CALC_ECREVISSE=MACRO(nom="CALC_ECREVISSE",op=calc_ecrevisse_ops,sd_prod=calc_ecrevisse_prod,reentrant='n',
                     UIinfo={"groupes":("Outils-mtier",)},fr="Procedure de couplage avec Ecrevisse",
                      regles   = (UN_PARMI('LOGICIEL','VERSION'),),

#      CONCEPTS SORTANTS : 2 CHARGEMENTS THERMIQUE + 1 MECANIQUE + 2 TABLES POUR LE POST-TRAITEMENT
#      ********************************************
         CHARGE_MECA        =SIMP(statut='o',typ=CO),
         CHARGE_THER1       =SIMP(statut='o',typ=CO),
         CHARGE_THER2       =SIMP(statut='o',typ=CO),
         TABLE              =SIMP(statut='o',typ=CO),
         DEBIT              =SIMP(statut='o',typ=CO),


#      MODELES MECANIQUES
#      ********************************************
         MODELE_MECA        =SIMP(statut='o',typ=modele_sdaster),
         MODELE_THER        =SIMP(statut='o',typ=modele_sdaster),


#      DONNEES GEOMETRIQUES RELATIVES AUX RESULTATS
#      ********************************************
         RESULTAT           =FACT(statut='o',min=1,max=1,
           MECANIQUE           =SIMP(statut='o',typ=resultat_sdaster),
           THERMIQUE           =SIMP(statut='o',typ=resultat_sdaster),
           regles=(EXCLUS('NUME_ORDRE','INST'),),
           NUME_ORDRE          =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
           INST                =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
         ),

#      DONNEES GEOMETRIQUES RELATIVES A LA FISSURE
#      *******************************************

         FISSURE            =FACT(statut='o',min=1,max='**',
           PREFIXE_FICHIER     =SIMP(statut='f',typ='TXM',validators=LongStr(1,8),),
           GROUP_MA            =SIMP(statut='o',typ=grma,validators=NoRepeat(),min=2,max=2,
                                     fr="Groupe(s) des noeuds definissant les levres de la fissure"),
           GROUP_NO_ORIG       =SIMP(statut='o',typ=grno,validators=NoRepeat(),min=2,max=2),
           GROUP_NO_EXTR       =SIMP(statut='o',typ=grno,validators=NoRepeat(),min=2,max=2),
           ZETA                =SIMP(statut='o',typ='R',fr="Coefficient de la perte de charge singuliere a l'entree [zeta]" ),
           RUGOSITE            =SIMP(statut='o',typ='R',fr="Rugosite absolu (metres) [eps]" ),
           OUVERT_REMANENTE    =SIMP(statut='o',typ='R',val_min=0.,fr="Ouverture remanente"),
           TORTUOSITE          =SIMP(statut='f',typ='R',defaut=1.0, val_min=0., val_max=1.0,
                                       fr="Coefficient de tortuosite de la fissure" ),
           SECTION             =SIMP(statut='o',typ='TXM',into=("ELLIPSE","RECTANGLE"),fr="Type de section [is]" ),
           b_section_ellipse   =BLOC(condition="SECTION=='ELLIPSE'",fr="Fissure a section elliptique",
             LISTE_COTES_BL      =SIMP(statut='f',typ='R',max='**',
                                       fr="Liste des cotes des points definissant le petit axe de la section",
                                       validators=NoRepeat() ),
             LISTE_VAL_BL        =SIMP(statut='o',typ='R',max='**',
                                       fr="Liste des valeurs des points definissant le petit axe de la section", ),
           ),
           b_section_rectangle =BLOC(condition="SECTION=='RECTANGLE'",fr="Fissure a section rectangulaire",
             LISTE_COTES_BL      =SIMP(statut='f',typ='R',max='**',
                                       fr="Liste des cotes des points definissant la largeur de la section",
                                       validators=NoRepeat() ),
             LISTE_VAL_BL        =SIMP(statut='o',typ='R',max='**',
                                       fr="Liste des valeurs des points definissant la largeur de la section", ),
           ),
         ),


#      DONNEES RELATIVES A L"ECOULEMENT
#      ********************************

         ECOULEMENT         =FACT(statut='o',min=1,max=1,
           PRES_ENTREE         =SIMP(statut='o',typ='R',fr="Pression de stagnation a l'entree (Pa) [pe]" ),
           PRES_SORTIE         =SIMP(statut='o',typ='R',fr="Pression de stagnation a la sortie (Pa) [ps]" ),
           FLUIDE_ENTREE       =SIMP(statut='o',typ='I',into=(1,2,3,4,5,6),fr="Condition du fluide a l'entree [iflow]" ),
           b_condition_1       =BLOC(condition="FLUIDE_ENTREE==1",fr="Eau sous-refroidie ou saturee",
             TEMP_ENTREE         =SIMP(statut='o',typ='R',fr="Temperature a l'entree (degres C) [te]" ),
           ),
           b_condition_2       =BLOC(condition="FLUIDE_ENTREE==2",fr="Fluide diphasique",
             TITR_MASS           =SIMP(statut='o',typ='R',fr="Titre massique eau vap/eau tot a l'entree [xe]" ),
           ),
           b_condition_3       =BLOC(condition="FLUIDE_ENTREE==3",fr="Vapeur saturee ou surchauffee",
             TEMP_ENTREE         =SIMP(statut='o',typ='R',fr="Temperature a l'entree (degres C) [te]" ),
           ),
           b_condition_4       =BLOC(condition="FLUIDE_ENTREE==4",fr="Air + vapeur surchauffee",
             TEMP_ENTREE         =SIMP(statut='o',typ='R',fr="Temperature a l'entree (degres C) [te]" ),
             PRES_PART           =SIMP(statut='o',typ='R',fr="Pression partielle air en entree (Pa) [pae]" ),
           ),
           b_condition_5       =BLOC(condition="FLUIDE_ENTREE==5",fr="Air + vapeur saturee",
             TITR_MASS           =SIMP(statut='o',typ='R',fr="Titre massique eau vap/eau tot a l'entree [xe]" ),
             PRES_PART           =SIMP(statut='o',typ='R',fr="Pression partielle air en entree (Pa) [pae]" ),
           ),
           b_condition_6       =BLOC(condition="FLUIDE_ENTREE==6",fr="Air seul",
             TEMP_ENTREE         =SIMP(statut='o',typ='R',fr="Temperature a l'entree (degres C) [te]" ),
           ),
         ),


#      CHOIX DES MODELES
#      *****************

         MODELE_ECRE        =FACT(statut='o',min=1,max=1,
           IVENAC              =SIMP(statut='f', typ='I', into=(0,1), defaut=0,
                                     fr="Calcul ECREVISSE avec prise en compte de la vena contracta"),
           ECOULEMENT          =SIMP(statut='o',typ='TXM',into=("SATURATION","GELE"),
                                     fr="Type de modele d'ecoulement diphasique [imod]" ),
           b_ecou_gele         =BLOC(condition="ECOULEMENT=='GELE'",fr="Modele d'ecoulement gele",
             PRESS_EBULLITION    =SIMP(statut='o',typ='R',fr="Pression d'ebullition [corrp*psat(t)]" ),
           ),
           FROTTEMENT          =SIMP(statut='o',typ='I',into=(-3,-2,-1,0,1,2,3),fr="Correlation de frottement [ifrot]" ),
           b_frottement        =BLOC(condition="FROTTEMENT<0",fr="Modele d'ecoulement gele",
             REYNOLDS_LIM        =SIMP(statut='o',typ='R',fr="Coefficient de Reynolds limite [relim]" ),
             FROTTEMENT_LIM      =SIMP(statut='o',typ='R',fr="Coefficient de frottement impose [frtlim]" ),
           ),

           TRANSFERT_CHAL      =SIMP(statut='o',typ='I',into=(-2,-1,0,1,2),fr="Transfert de chaleur [ichal]" ),
           b_transchal         =BLOC(condition="TRANSFERT_CHAL<0", fr="Cas diphasique",
             XMINCH              =SIMP(statut='o',typ='R',fr="Titre massique gazeux min [xminch]"),
             XMAXCH              =SIMP(statut='o',typ='R',fr="Titre massique gazeux max [xmaxch]"),
           ),
         ),


#      DONNEES RELATIVES A LA CONVERGENCE NUMERIQUE
#      ********************************************

         CONVERGENCE        =FACT(statut='o',min=1,max=1,
           KGTEST              =SIMP(statut='f',typ='R',val_min=0.E+0,val_max=1.E+0,defaut= 0.5E+0,
                                     fr="Parametre de l'algorithme iteratif [kgtest]" ),
           ITER_GLOB_MAXI      =SIMP(statut='f',typ='I',defaut= 400,
                                     fr="Nombre maximum d'iterations de la methode de Newton [itnmax]" ),
           CRIT_CONV_DEBI      =SIMP(statut='f',typ='R',val_min=0.E+0,val_max=1.E+0,defaut= 1.E-5,
                                     fr="Critere de convergence en debit [precdb]" ),
         ),

#      GENERAL
#      *******

         COURBES            =SIMP(statut='f',typ='TXM',into=("INTERACTIF","POSTSCRIPT","AUCUNE"),defaut="AUCUNE",
                                  fr="Generation eventuelle des courbes" ),
         LOGICIEL           =SIMP(statut='f',typ='TXM',validators=LongStr(1,255),),
         VERSION            =SIMP(statut='f',typ='TXM',into = ("3.1.1","3.1.2","3.2")),
         ENTETE             =SIMP(statut='f',typ='TXM',max='**',defaut="Titre du calcul Ecrevisse" ),
         IMPRESSION         =SIMP(statut='f',typ='TXM',defaut='NON',into=( 'OUI','NON') ),
         INFO               =SIMP(statut='f',typ='I',defaut= 1,into=(1,2) ),

)  ;
#& MODIF COMMANDE  DATE 19/05/2011   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ASSIRE A.ASSIRE
def calc_elem_prod(RESULTAT,**args):
   if AsType(RESULTAT) != None : return AsType(RESULTAT)
   raise AsException("type de concept resultat non prevu")

CALC_ELEM=OPER(nom="CALC_ELEM",op=58,sd_prod=calc_elem_prod,reentrant='f',
            UIinfo={"groupes":("Post-traitements","Rsultats et champs",)},
            fr="Complter ou crer un rsultat en calculant des champs par lments (contraintes, dformations,... )",
     MODELE          =SIMP(statut='f',typ=modele_sdaster),
     CHAM_MATER      =SIMP(statut='f',typ=cham_mater),
     CARA_ELEM       =SIMP(statut='f',typ=cara_elem),

     RESULTAT        =SIMP(statut='o',typ=resultat_sdaster,
                                      fr="Rsultat d'une commande globale"),

     regles=(EXCLUS('TOUT_ORDRE','NUME_ORDRE','INST','FREQ','NUME_MODE',
                    'NOEUD_CMP','LIST_INST','LIST_FREQ','LIST_ORDRE','NOM_CAS'),
                    ),
     TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
     NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
     NUME_MODE       =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
     NOEUD_CMP       =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**'),
     NOM_CAS         =SIMP(statut='f',typ='TXM' ),
     INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
     FREQ            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
     LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
     LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster),
     CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",) ),
     b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
         PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6),),
     b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
         PRECISION       =SIMP(statut='o',typ='R'),),
     LIST_ORDRE      =SIMP(statut='f',typ=listis_sdaster),
     TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
     GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**',
                           fr="le calcul ne sera effectu que sur ces mailles l"),
     MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**',
                           fr="le calcul ne sera effectu que sur ces mailles l"),

#    definition d'un repere local

     REPE_COQUE      =FACT(statut='f',max='**',
                           fr="dfiniton du lieu de post-traitement",
                           regles=EXCLUS('ANGL_REP','VECTEUR'),
          TOUT         =SIMP(statut='f',typ='TXM',into=("OUI",) ),
          GROUP_MA     =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**',),
          MAILLE       =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**',),

          NUME_COUCHE  =SIMP(statut='f',typ='I',defaut= 1,
                             fr="numero de couche dans l'paisseur de la coque ou du tuyau" ),
          NIVE_COUCHE  =SIMP(statut='f',typ='TXM',defaut="MOY",into=("SUP","INF","MOY"),
                             fr="position dans l'paisseur de la coque, ou de la couche" ),

          ANGLE        =SIMP(statut='f',typ='I',defaut= 0,
                             fr="angle de dpouillement pour les tuyaux, en degres  partir de la gnratrice" ),

          PLAN         =SIMP(statut='f',typ='TXM',defaut="MAIL",into=("SUP","INF","MOY","MAIL"),
                               fr="Plan de calcul pour les plaques excentres" ),

          ANGL_REP     =SIMP(statut='f',typ='R',min=2,max=2,
                           fr="dfinition du repere de post-traitement, par dfaut ANGL_REP=(0.,0.)"),
          VECTEUR      =SIMP(statut='f',typ='R',min=3,max=3,
                           fr="dfinition du repere de post-traitement, par dfaut VECTEUR=(1.,0.,0.)"),
                            ),

#    options pour des resultats lineaires

     b_lineaire =BLOC( condition = "AsType(RESULTAT) in (evol_elas,dyna_trans,dyna_harmo,mode_meca,\
                                                         comb_fourier,mult_elas,fourier_elas,mode_flamb)",
                                                               fr="options mecaniques lineaires",
          TYPE_OPTION =SIMP(statut='f',typ='TXM',defaut='TOUTES',fr="type d'options mecaniques lineaires",
                           into=("SIGM_MASSIF","SIGM_STRUCT","EPSI","ENER","CRIT","DERIVEES",
                                 "INDI_ERREUR","AUTRES","TOUTES"),
                           ),
          b_toutes=BLOC( condition = "TYPE_OPTION == 'TOUTES'",fr="toutes les options evol elas",
               OPTION =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',defaut="SIEF_ELNO",
                              #  contraintes
                           into=( "SIEF_ELNO","SIGM_ELNO","SIEF_ELGA",
                                  "SIPO_ELNO","EFGE_ELNO","EFCA_ELNO","SICA_ELNO",
                                  "SITU_ELNO","SIRO_ELEM","SIPM_ELNO",
                              # dformations
                                 "EPSI_ELNO","EPSI_ELGA","EPSG_ELGA","EPSG_ELNO",
                                 "EPME_ELNO","EPME_ELGA","DEGE_ELNO","EPTU_ELNO",
                                 "EPVC_ELNO","EPVC_ELGA",
                              #  ENER
                                 "EPOT_ELEM","ECIN_ELEM","ENEL_ELGA","ENEL_ELNO",
                                 "ETOT_ELGA","ETOT_ELNO","ETOT_ELEM","DISS_ELGA","DISS_ELNO",
                              #  estimateurs erreur
                                 "SIZ1_NOEU","ERZ1_ELEM","SIZ2_NOEU","ERZ2_ELEM",
                                 "ERME_ELEM","ERME_ELNO",
                                 "QIRE_ELEM","QIRE_ELNO","QIZ1_ELEM","QIZ2_ELEM",
                                 "SING_ELEM","SING_ELNO",
                              #  CRIT
                                 "SIEQ_ELNO","SIEQ_ELGA","CRIT_ELNO",
                                 "EPEQ_ELNO","EPEQ_ELGA","EPMQ_ELNO","EPMQ_ELGA",
                                 "ENDO_ELGA","ENDO_ELNO",
                                 "SITQ_ELNO","EPTQ_ELNO",
                              #  autres
                                 "SPMX_ELGA","PRME_ELNO","VARC_ELGA"),),

#              Les 2 mots cles suivants ne sont utiles qu' a l'option SPMX_ELGA
#              mais  on est oblig de les laisser ici a cause des blocs
               NOM_CHAM  =SIMP(statut='f',typ='TXM',into=("SIEF_ELGA","EPSI_ELGA","SIEQ_ELGA","EPEQ_ELGA","VARI_ELGA"),
                               fr="nom du champ pour SPMX_ELGA",),
               NOM_CMP   =SIMP(statut='f',typ='TXM',fr="nom de la composante pour SPMX_ELGA",  ),

                b_erre_qi =BLOC(condition = "OPTION in ('QIRE_ELEM','QIZ1_ELEM','QIZ2_ELEM') or \
                                        (type(OPTION)==type(()) and 'QIRE_ELEM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ1_ELEM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ2_ELEM' in OPTION)",
                    RESU_DUAL=SIMP(statut='o',typ=evol_elas,fr="resultat du probleme dual"),),

               b_sing =BLOC(condition= "OPTION == 'SING_ELEM' or \
                               (type(OPTION)==type(()) and  'SING_ELEM' in OPTION)",
                    PREC_ERR=SIMP(statut='o',typ='R',val_min= 0.,
                                  fr="precision demandee pour calculer la carte de taille des elements"),
                    TYPE_ESTI=SIMP(statut='f',typ='TXM',into=("ERME_ELEM","ERZ1_ELEM","ERZ2_ELEM",
                                                              "QIRE_ELEM","QIZ1_ELEM","QIZ2_ELEM",),
                                   fr="choix de l'estimateur d'erreur"),),

               EXCIT           =FACT(statut='f',max='**',
                                     fr="Charges contenant les tempratures, les efforts rpartis pour les poutres...",
                                     regles=(EXCLUS('FONC_MULT','FONC_MULT_C','COEF_MULT','COEF_MULT_C'),),
                    CHARGE          =SIMP(statut='o',typ=(char_meca,char_cine_meca) ),
                    FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                    FONC_MULT_C     =SIMP(statut='f',typ=fonction_c),
                    COEF_MULT       =SIMP(statut='f',typ='R'),
                    COEF_MULT_C     =SIMP(statut='f',typ='C'),
                    PHAS_DEG        =SIMP(statut='f',typ='R'),
                    PUIS_PULS       =SIMP(statut='f',typ='I'),
                    TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE",into=("FIXE",),),),


                            ),
#             fin bloc b_toutes

          b_sigm_massif =BLOC( condition = "TYPE_OPTION == 'SIGM_MASSIF'",
                                     fr="options de contraintes elasticite 2D et 3D",
              OPTION =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',defaut='SIEF_ELNO',
                            fr="option de calcul des contraintes",
                           into=( "SIEF_ELNO","SIGM_ELNO","SIEF_ELGA",),),

                    b_charge =BLOC( condition = "OPTION in ('SIGM_ELNO','SIEF_ELGA',) or \
                                      (type(OPTION)==type(()) and  'SIGM_ELNO' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'SIEF_ELGA' in OPTION ) ",
                                      fr="charge contenant les temperatures ou autre charge",
                         EXCIT           =FACT(statut='f',max='**',
                         CHARGE          =SIMP(statut='o',typ=(char_meca,char_cine_meca) ),),
                                    ),
                                  ),

          b_sigm_struct =BLOC( condition = "TYPE_OPTION == 'SIGM_STRUCT'",
                                      fr="options de contraintes elasticite poutres, coques, tuyaux",
               OPTION =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',defaut='SIEF_ELNO',
                            fr="option de calcul des contraintes ou efforts generalises",
                            into=( "SIEF_ELNO","SIGM_ELNO","SIEF_ELGA","SITU_ELNO",
                                   "SIPO_ELNO","EFGE_ELNO","EFCA_ELNO","SICA_ELNO",
                                   ),),

               b_charge =BLOC( condition = "OPTION in ('SIGM_ELNO','SIEF_ELGA',\
                                                       'SIPO_ELNO','EFGE_ELNO',) or \
                                            (type(OPTION)==type(()) and  'SIGM_ELNO' in OPTION ) or \
                                            (type(OPTION)==type(()) and  'SIEF_ELGA' in OPTION ) or \
                                            (type(OPTION)==type(()) and  'SIPO_ELNO' in OPTION ) or \
                                            (type(OPTION)==type(()) and  'EFGE_ELNO' in OPTION ) ",
                                            fr="charge contenant les temperatures ou les efforts rpartis (poutres) ou autre",
                    EXCIT           =FACT(statut='f',max='**',
                                          regles=(EXCLUS('FONC_MULT','FONC_MULT_C','COEF_MULT','COEF_MULT_C'),),
                         CHARGE          =SIMP(statut='f',typ=(char_meca,char_cine_meca) ),
                         FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                         FONC_MULT_C     =SIMP(statut='f',typ=fonction_c),
                         COEF_MULT       =SIMP(statut='f',typ='R'),
                         COEF_MULT_C     =SIMP(statut='f',typ='C'),
                         PHAS_DEG        =SIMP(statut='f',typ='R'),
                         PUIS_PULS       =SIMP(statut='f',typ='I'),
                         TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE",into=("FIXE",),),),
                             ),


                            ),
#          fin bloc contraintes struct

          b_epsi         =BLOC( condition = "TYPE_OPTION=='EPSI'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("EPSI_ELNO","EPSI_ELGA","EPME_ELNO","EPME_ELGA",
                                 "DEGE_ELNO","EPTU_ELNO","EPVC_ELNO","EPVC_ELGA",),
                                 ),
b_charge =BLOC( condition = "OPTION in ('EPME_ELNO','EPSI_ELGA','EPME_ELGA','EPSI_ELNO','EPTU_ELNO' ) or \
                                      (type(OPTION)==type(()) and  'EPSI_ELNO' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'EPTU_ELNO' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'EPSI_ELGA' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'EPME_ELNO' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'EPME_ELGA' in OPTION ) ",
                                      fr="charge contenant les temperatures",
                    EXCIT           =FACT(statut='f',max='**',
                         CHARGE          =SIMP(statut='o',typ=(char_meca,char_ther,char_acou,char_cine_meca,) ),),
                                 ),
                                       ),
          b_ener         =BLOC( condition = "TYPE_OPTION=='ENER'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("EPOT_ELEM","ECIN_ELEM","ENEL_ELGA","ENEL_ELNO",
                                 "ETOT_ELGA","ETOT_ELNO","ETOT_ELEM","DISS_ELGA","DISS_ELNO",),
                                 ),
               b_charge =BLOC( condition = "OPTION in ('EPOT_ELEM','ECIN_ELEM','ENEL_ELGA','ENEL_ELNO',) or \
                                      (type(OPTION)==type(()) and  'EPOT_ELEM' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'ENEL_ELGA' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'ENEL_ELNO' in OPTION ) or \
                                      (type(OPTION)==type(()) and  'ECIN_ELEM' in OPTION ) ",
                                      fr="charge contenant les temperatures",
                    EXCIT           =FACT(statut='f',max='**',
                         CHARGE          =SIMP(statut='f',typ=(char_meca,char_ther,char_acou) ),),
                              ),
                                 ),

          b_crit         =BLOC( condition = "TYPE_OPTION=='CRIT'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("SIEQ_ELNO","SIEQ_ELGA",
                                 "EPEQ_ELNO","EPEQ_ELGA","EPMQ_ELNO","EPMQ_ELGA",
                                 "ENDO_ELGA","ENDO_ELNO",
                                 "CRIT_ELNO","SITQ_ELNO","EPTQ_ELNO",
                                 ) ),
                EXCIT           =FACT(statut='f',max='**',fr="charge contenant les temperatures",
                     CHARGE          =SIMP(statut='o',typ=(char_meca,char_ther,char_acou) ),),
                                 ),


          b_autres         =BLOC( condition = "TYPE_OPTION=='AUTRES'",
                  OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("SPMX_ELGA","PRME_ELNO",
                                 ) ),
               b_maxi    =BLOC( condition = "OPTION=='SPMX_ELGA' or \
                                (type(OPTION)==type(()) and 'SPMX_ELGA' in OPTION)",
                    NOM_CHAM  =SIMP(statut='o',typ='TXM',into=("SIEF_ELGA","EPSI_ELGA","SIEQ_ELGA","EPEQ_ELGA","VARI_ELGA"),
                                    fr="Nom du champ pour SPMX_ELGA",),
                    NOM_CMP   =SIMP(statut='o',typ='TXM',fr="Nom de la composante pour SPMX_ELGA"),),
                                 ),

          b_indi_erreur        =BLOC( condition = "TYPE_OPTION=='INDI_ERREUR'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',defaut="ERME_ELEM",
                           into=("SIZ1_NOEU","ERZ1_ELEM","SIZ2_NOEU","ERZ2_ELEM",
                                 "ERME_ELEM","ERME_ELNO",
                                 "QIRE_ELEM","QIRE_ELNO","QIZ1_ELEM","QIZ2_ELEM",
                                 "SING_ELEM","SING_ELNO",
                                 )),

               b_erre_qi =BLOC(condition = "OPTION in ('QIRE_ELEM','QIZ1_ELEM','QIZ2_ELEM') or \
                                        (type(OPTION)==type(()) and 'QIRE_ELEM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ1_ELEM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ2_ELEM' in OPTION)",
                    RESU_DUAL=SIMP(statut='o',typ=evol_elas,fr="resultat du probleme dual"),),

               b_sing =BLOC(condition= "OPTION == 'SING_ELEM' or \
                               (type(OPTION)==type(()) and  'SING_ELEM' in OPTION)",
                    PREC_ERR=SIMP(statut='o',typ='R',val_min= 0.,
                                  fr="precision demandee pour calculer la carte de taille des elements" ),
                    TYPE_ESTI=SIMP(statut='f',typ='TXM',into=("ERME_ELEM","ERZ1_ELEM","ERZ2_ELEM",
                                                              "QIRE_ELEM","QIZ1_ELEM","QIZ2_ELEM",),
                                   fr="choix de l'estimateur d'erreur"),),

               EXCIT           =FACT(statut='f',max='**',fr="charge contenant les temperatures",
                     CHARGE          =SIMP(statut='o',typ=(char_meca,char_ther,char_acou) ),),
                                 ),
                                 ),
#    fin bloc lineaire

#    statique ou dynamique non lineaire : evol_noli
     b_noli          =BLOC( condition = "AsType(RESULTAT) == evol_noli",fr="options mecaniques non lineaires",
          TYPE_OPTION =SIMP(statut='f',typ='TXM',defaut='TOUTES',fr="type d'options mecaniques non lineaires",
                           into=("SIGM_MASSIF","SIGM_STRUCT","EPSI","ENER","CRIT","FLUX",
                                 "VARI","INDI_ERREUR","TOUTES","AUTRES"),
                          ),
          b_toutes =BLOC( condition = "TYPE_OPTION == 'TOUTES'",fr="toutes les options evol noli",
               OPTION      =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=( "SIEF_ELNO","SIRO_ELEM",
                                  "SITU_ELNO","SICO_ELNO",
                                  "EFCA_ELNO","SIPO_ELNO","SIPM_ELNO",
                                  "FLHN_ELGA",
                                  # EPSI
                                  "EPSI_ELNO","EPSI_ELGA","EPSG_ELNO","EPSG_ELGA",
                                 "EPME_ELNO","EPME_ELGA","EPMG_ELNO","EPMG_ELGA",
                                 "DEGE_ELNO","EPTU_ELNO",
                                 "EPSP_ELNO","EPSP_ELGA",
                                 "EPFD_ELNO","EPFD_ELGA","EPVC_ELNO","EPVC_ELGA",
                                 "EPFP_ELNO","EPFP_ELGA",
                                 "VARC_ELGA",
                                 "VARI_ELNO","VATU_ELNO","VACO_ELNO","CRIT_ELNO",
                                 "VAEX_ELGA","VAEX_ELNO",
                                 # CRIT
                                 "SIEQ_ELNO","SIEQ_ELGA","SITQ_ELNO","EPTQ_ELNO",
                                 "ERME_ELEM","ERME_ELNO","ERZ1_ELEM","ERZ2_ELEM",
                                 "QIRE_ELEM","QIRE_ELNO","QIZ1_ELEM","QIZ2_ELEM",
                                 "EPEQ_ELNO","EPEQ_ELGA","EPMQ_ELNO","EPMQ_ELGA",
                                 "DERA_ELNO","DERA_ELGA",
                                 "ENDO_ELGA","ENDO_ELNO","INDL_ELGA","SING_ELEM",
                                 "SING_ELNO",
                                 "PMPB_ELNO","PMPB_ELGA","ENEL_ELGA","ENEL_ELNO",
                                 "ETOT_ELGA","ETOT_ELNO","ETOT_ELEM","SPMX_ELGA",
                                 "DISS_ELGA","DISS_ELNO"),
                               ),

#              Les 2 mots cles suivants ne sont utiles qu' a l'option SPMX_ELGA
#              mais  on est oblig de les laisser ici a cause des blocs
               NOM_CHAM  =SIMP(statut='f',typ='TXM',into=("SIEF_ELGA","EPSI_ELGA","SIEQ_ELGA","EPEQ_ELGA","VARI_ELGA"),
                               fr="Nom du champ pour SPMX_ELGA",),
               NOM_CMP   =SIMP(statut='f',typ='TXM',fr="Nom de la composante pour SPMX_ELGA"),

               b_erre_qi =BLOC(condition = "OPTION in ('QIRE_ELEM','QIZ1_ELEM','QIZ2_ELEM') or \
                                        (type(OPTION)==type(()) and 'QIRE_ELEM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ1_ELEM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ2_ELEM' in OPTION)",
                    RESU_DUAL=SIMP(statut='o',typ=(evol_elas,evol_noli),fr="resultat du probleme dual"),),

               b_sing =BLOC(condition= "OPTION == 'SING_ELEM' or \
                               (type(OPTION)==type(()) and  'SING_ELEM' in OPTION)",
                    PREC_ERR=SIMP(statut='o',typ='R',val_min= 0.,
                                  fr="precision demandee pour calculer la carte de taille des elements" ),
                    TYPE_ESTI=SIMP(statut='f',typ='TXM',into=("ERME_ELEM","ERZ1_ELEM","ERZ2_ELEM",
                                                              "QIRE_ELEM","QIZ1_ELEM","QIZ2_ELEM",),
                                   fr="choix de l'estimateur d'erreur"),),


               b_extr = BLOC( condition = "OPTION in ('VAEX_ELNO','VAEX_ELGA')",
                             NOM_VARI =SIMP(statut='o',typ='TXM',min= 1,max=1,fr="nom de la variable  extraire",
                         into=("DPORO","DRHOLQ","DPVP","SATLIQ","EVP","IND_ETA","D","IND_END","TEMP_MAX","GAMP","PCR",
                               "SEUIL_HYD","IND_HYD","PCOHE","COMP_ROC","SEUIL_ISO","ANG_DEV","X11","X22","X33","X12","X13","X23",
                               "DIST_DEV","DEV_SUR_CRIT","DIST_ISO","NB_ITER","ARRET","NB_REDE","SIGNE",
                               "RDEV_1","RDEV_2","RDEV_3","RISO","EPSIVPLA","IND_1","IND_2","IND_3","IND_4",),),
                            ),
               EXCIT           =FACT(statut='f',max='**',
                                      regles=(EXCLUS('FONC_MULT','FONC_MULT_C','COEF_MULT','COEF_MULT_C'),),
                    CHARGE          =SIMP(statut='o',typ=char_meca ),
                    FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                    FONC_MULT_C     =SIMP(statut='f',typ=fonction_c),
                    COEF_MULT       =SIMP(statut='f',typ='R'),
                    COEF_MULT_C     =SIMP(statut='f',typ='C'),
                    PHAS_DEG        =SIMP(statut='f',typ='R'),
                    PUIS_PULS       =SIMP(statut='f',typ='I'),
                    TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE",into=("FIXE",),),),
                         ),

          b_flux =BLOC( condition = "TYPE_OPTION == 'FLUX'",
                                      fr="option de calcul de flux hydraulique 2D et 3D",
               OPTION =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                              #  flux hydraulique
                           into=( "FLHN_ELGA",),),
                            ),

          b_sigm_massif =BLOC( condition = "TYPE_OPTION == 'SIGM_MASSIF'",
                                      fr="options de contraintes non lin 2D et 3D",
               OPTION =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                              #  contraintes
                           into=( "SIEF_ELNO",),),
                            ),

          b_sigm_struct =BLOC( condition = "TYPE_OPTION == 'SIGM_STRUCT'",
                                       fr="options de contraintes non lin poutres, coques",
               OPTION =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                              #  contraintes
                           into=( "SIEF_ELNO","EFCA_ELNO","SITU_ELNO","SICO_ELNO",
                           ),),
                             ),

          b_epsi         =BLOC( condition = "TYPE_OPTION=='EPSI'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=( "EPSI_ELNO","EPSI_ELGA","EPSG_ELNO","EPSG_ELGA",
                                 "EPME_ELNO","EPME_ELGA","EPMG_ELNO","EPMG_ELGA",
                                 "EPSP_ELNO","EPSP_ELGA","DEGE_ELNO","EPVC_ELNO","EPVC_ELGA",
                                 "EPFD_ELNO","EPFD_ELGA","EPFP_ELNO","EPFP_ELGA"),
                                 ),
               EXCIT           =FACT(statut='f',max='**',fr="charge contenant les temperatures",
                    CHARGE          =SIMP(statut='o',typ=(char_meca,char_ther,char_acou) ),),
                                 ),
         b_epstuyo       =BLOC( condition = "OPTION == 'EPTU_ELNO' or \
                                  (type(OPTION)==type(()) and  'EPTU_ELNO' in OPTION) ",
              EXCIT           =FACT(statut='f',max='**',fr="charge contenant les temperatures",
                    CHARGE          =SIMP(statut='o',typ=(char_meca,char_ther,char_acou) ),),
                               ),

          b_vari         =BLOC( condition = "TYPE_OPTION=='VARI'",
                                       fr="Calcul et extraction des variables internes",
                   OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                                   into=("VARI_ELNO","VATU_ELNO","VACO_ELNO",
                                         "VAEX_ELGA","VAEX_ELNO"),
                                 ),
          b_extr         =BLOC( condition = "OPTION in ('VAEX_ELNO','VAEX_ELGA')",
                   NOM_VARI =SIMP(statut='o',typ='TXM',min= 1,max=1,fr="nom de la variable  extraire",
                         into=("DPORO","DRHOLQ","DPVP","SATLIQ","EVP","IND_ETA","D","IND_END","TEMP_MAX","GAMP","PCR",
                               "SEUIL_HYD","IND_HYD","PCOHE","COMP_ROC","SEUIL_ISO","ANG_DEV","X11","X22","X33","X12","X13","X23",
                               "DIST_DEV","DEV_SUR_CRIT","DIST_ISO","NB_ITER","ARRET","NB_REDE","SIGNE",
                               "RDEV_1","RDEV_2","RDEV_3","RISO","EPSIVPLA","IND_1","IND_2","IND_3","IND_4"),),
                            ),
                           ),

          b_ener         =BLOC( condition = "TYPE_OPTION=='ENER'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("ETOT_ELGA","ETOT_ELNO","ETOT_ELEM","ENEL_ELGA","ENEL_ELNO",
                                 "DISS_ELGA","DISS_ELNO",),
                                 ),
               EXCIT           =FACT(statut='f',max='**',fr="charge contenant les temperatures",
                    CHARGE          =SIMP(statut='o',typ=(char_meca,char_ther,char_acou) ),),
                                 ),

          b_crit         =BLOC( condition = "TYPE_OPTION=='CRIT'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("SIEQ_ELNO","SIEQ_ELGA",
                                 "EPEQ_ELNO","EPEQ_ELGA","EPMQ_ELNO","EPMQ_ELGA",
                                 "CRIT_ELNO",
                                 "ENDO_ELGA","ENDO_ELNO",
                                 "PMPB_ELNO","PMPB_ELGA","SITQ_ELNO","EPTQ_ELNO",
                                 ) ),
                                 ),

          b_autres         =BLOC( condition = "TYPE_OPTION=='AUTRES'",
                  OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("SPMX_ELGA",) ),
               b_maxi    =BLOC( condition = "OPTION=='SPMX_ELGA' or \
                                (type(OPTION)==type(()) and 'SPMX_ELGA' in OPTION)",
                    NOM_CHAM  =SIMP(statut='o',typ='TXM',into=("SIEF_ELGA","EPSI_ELGA","SIEQ_ELGA","EPEQ_ELGA","VARI_ELGA"),
                                    fr="Nom du champ pour SPMX_ELGA",),
                    NOM_CMP   =SIMP(statut='o',typ='TXM',fr="Nom de la composante pour SPMX_ELGA"),),
                                 ),

          b_indi_erreur         =BLOC( condition = "TYPE_OPTION=='INDI_ERREUR'",
               OPTION    =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',defaut="ERME_ELEM",
                           into=("ERME_ELEM","ERME_ELNO","ERZ1_ELEM","ERZ2_ELEM",
                                 "DERA_ELNO","DERA_ELGA",
                                 "QIRE_ELEM","QIRE_ELNO","QIZ1_ELEM","QIZ2_ELEM",
                                 "SING_ELEM","SING_ELNO",) ),

               b_erre_qi =BLOC(condition = "OPTION in ('QIRE_ELEM','QIZ1_ELEM','QIZ2_ELEM') or \
                                        (type(OPTION)==type(()) and 'QIRE_ELEM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ1_ELEM' in OPTION) or \
                                        (type(OPTION)==type(()) and 'QIZ2_ELEM' in OPTION)",
                RESU_DUAL    =SIMP(statut='o',typ=(evol_elas,evol_noli),fr="resultat du probleme dual")),

               b_sing =BLOC(condition= "OPTION == 'SING_ELEM' or \
                               (type(OPTION)==type(()) and  'SING_ELEM' in OPTION)",
                    PREC_ERR=SIMP(statut='o',typ='R',val_min= 0.,
                                  fr="precision demandee pour calculer la carte de taille des elements" ),
                    TYPE_ESTI=SIMP(statut='f',typ='TXM',into=("ERME_ELEM","ERZ1_ELEM","ERZ2_ELEM",
                                                              "QIRE_ELEM","QIZ1_ELEM","QIZ2_ELEM",),
                                   fr="choix de l'estimateur d'erreur"),),
                                 ),
                                 ),
#          fin bloc evol_noli

#           thermique : evol_ther, fourier_ther
     b_ther          =BLOC( condition = "AsType(RESULTAT) in (evol_ther,fourier_ther,)" ,fr="options thermiques",
          OPTION          =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("FLUX_ELGA","FLUX_ELNO",
                                  "DURT_ELNO","SOUR_ELGA","ERTH_ELEM","ERTH_ELNO",),),
               EXCIT           =FACT(statut='f',max='**',
                    regles=(EXCLUS('FONC_MULT','FONC_MULT_C','COEF_MULT','COEF_MULT_C'),),
                    CHARGE          =SIMP(statut='o',typ=char_ther ),
                    FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                    FONC_MULT_C     =SIMP(statut='f',typ=fonction_c),
                    COEF_MULT       =SIMP(statut='f',typ='R'),
                    COEF_MULT_C     =SIMP(statut='f',typ='C'),
                    PHAS_DEG        =SIMP(statut='f',typ='R'),
                    PUIS_PULS       =SIMP(statut='f',typ='I'),
                    TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE",into=("FIXE",),),
                                     ),
                                 ),

#    acoustique
     b_acou          =BLOC( condition = "AsType(RESULTAT) in (acou_harmo,mode_acou,)",fr="options acoustiques",
          OPTION          =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                           into=("PRAC_ELNO", "INTE_ELNO",
                                 ),),
          EXCIT           =FACT(statut='f',max='**',
                regles=(EXCLUS('FONC_MULT','FONC_MULT_C','COEF_MULT','COEF_MULT_C'),),
                CHARGE          =SIMP(statut='o',typ=char_acou ),
                FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                FONC_MULT_C     =SIMP(statut='f',typ=fonction_c),
                COEF_MULT       =SIMP(statut='f',typ='R'),
                COEF_MULT_C     =SIMP(statut='f',typ='C'),
                PHAS_DEG        =SIMP(statut='f',typ='R'),
                PUIS_PULS       =SIMP(statut='f',typ='I'),
                TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE",into=("FIXE",),),),
                                 ),


#    Choix du solveur (utilis actuellement pour estimateur d'erreur ZZ1) :
     SOLVEUR         =FACT(statut='d', fr="Mthode de rsolution des systmes linaires",
     METHODE         =SIMP(statut='f',typ='TXM',defaut="MULT_FRONT",into=("LDLT","MUMPS","MULT_FRONT",) ),


       b_ldlt          =BLOC(condition = "METHODE == 'LDLT' ",fr="Paramtres de la mthode LDLT",
         RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("RCMK","SANS") ),
       ),

       b_mult_front    =BLOC(condition = "METHODE == 'MULT_FRONT' ",fr="Paramtres de la mthode multi frontale",
         RENUM           =SIMP(statut='f',typ='TXM',defaut="METIS",into=("MD","MDA","METIS") ),
       ),
       b_ldlt_mult_mumps =BLOC( condition = "METHODE=='LDLT' or METHODE=='MULT_FRONT' or METHODE=='MUMPS' ",
                              fr="Paramtres relatifs  la non inversibilit de la matrice  factoriser",
         NPREC           =SIMP(statut='f',typ='I',defaut= 8 ),
         STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
       ),

       b_mumps        =BLOC(condition = "METHODE == 'MUMPS' ",fr="Paramtres de la mthode MUMPS",
         TYPE_RESOL      =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("NONSYM","SYMGEN","SYMDEF","AUTO")),
         PRETRAITEMENTS  =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO")),
         POSTTRAITEMENTS =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO","FORCE")),
         RENUM           =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("AMD","AMF","PORD","METIS","QAMD","SCOTCH","AUTO")),
         ELIM_LAGR2      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
         PCENT_PIVOT     =SIMP(statut='f',typ='I',defaut=10,),
         RESI_RELA       =SIMP(statut='f',typ='R',defaut=-1.0,),
         OUT_OF_CORE     =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
         LIBERE_MEMOIRE =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
         ),
     ),



     INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
     TITRE           =SIMP(statut='f',typ='TXM',max='**'),
) ;
#& MODIF COMMANDE  DATE 04/05/2011   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================

# RESPONSABLE NISTOR I.NISTOR

from Macro.calc_essai_ops import calc_essai_ops

def calc_essai_prod(self,RESU_IDENTIFICATION,
                    RESU_MODIFSTRU,
                    **args):

    if RESU_IDENTIFICATION != None:
        for res in RESU_IDENTIFICATION:
            self.type_sdprod(res['TABLE'],table_fonction)

    MTYPES = {
        'MODELE'    : modele_sdaster,
        'MODE_MECA' : mode_meca,
        'NUME_DDL'  : nume_ddl_sdaster,
        'MAILLAGE'  : maillage_sdaster,
        'MASS_MECA' : matr_asse_depl_r,
        'RIGI_MECA' : matr_asse_depl_r,
        'AMOR_MECA' : matr_asse_depl_r,
        'MACR_ELEM' : macr_elem_stat,
        'PROJ_MESU' : mode_gene,
        'BASE_ES'   : mode_meca,
        'BASE_LMME' : mode_meca,
        'MODE_STA'  : mode_meca,
              }
    if RESU_MODIFSTRU != None:
        for res in RESU_MODIFSTRU:
            for mc, typ in MTYPES.items():
                if res[mc]:
                    self.type_sdprod(res[mc], typ)
    return None


CALC_ESSAI = MACRO(nom       = 'CALC_ESSAI',
                   op        = calc_essai_ops,
                   sd_prod   = calc_essai_prod,
                   reentrant = 'n',
                   UIinfo    = {"groupes":("Outils-mtier","Dynamique",)},
                   fr        = "Outil de post-traitement interactif pour Meidee ",
                   INTERACTIF  = SIMP( statut='f',typ='TXM',into=('OUI','NON'),defaut='OUI' ),
                   RESU_IDENTIFICATION = FACT( statut='f',max='**',
                                               TABLE = SIMP(statut='f', typ=CO),
                                             ),
                   RESU_MODIFSTRU = FACT( statut='f', max=1,
                                          MODELE=SIMP(statut='f',typ=CO,defaut=None),
                                          MODE_MECA=SIMP(statut='f',typ=CO,defaut=None),
                                          MAILLAGE=SIMP(statut='f',typ=CO,defaut=None),
                                          NUME_DDL=SIMP(statut='f',typ=CO,defaut=None),
                                          MASS_MECA=SIMP(statut='f',typ=CO,defaut=None),
                                          RIGI_MECA=SIMP(statut='f',typ=CO,defaut=None),
                                          AMOR_MECA=SIMP(statut='f',typ=CO,defaut=None),
                                          MACR_ELEM=SIMP(statut='f',typ=CO,defaut=None),
                                          PROJ_MESU=SIMP(statut='f',typ=CO,defaut=None),
                                          BASE_ES=SIMP(statut='f',typ=CO,defaut=None),
                                          BASE_LMME=SIMP(statut='f',typ=CO,defaut=None),
                                          MODE_STA=SIMP(statut='f',typ=CO,defaut=None),
                                         ),

                   b_inter    = BLOC( condition="INTERACTIF=='NON'",

                             EXPANSION        = FACT( statut='f',max='**',
                                                      CALCUL           = SIMP(statut='o',typ=mode_meca),
                                                      NUME_MODE_CALCUL = SIMP(statut='f',typ='I',validators=NoRepeat(),
                                                                              max='**',defaut=0),
                                                      MESURE           = SIMP(statut='o',typ=mode_meca),
                                                      NUME_MODE_MESURE = SIMP(statut='f',typ='I',validators=NoRepeat(),
                                                                              max='**',defaut=0),
                                                      RESOLUTION       = SIMP(statut='f',typ='TXM',defaut='SVD',into=('SVD','LU')),
                                                      b_reso           = BLOC(condition = "RESOLUTION=='SVD'",
                                                                              EPS = SIMP(statut='f',typ='R', defaut = 0.)
                                                                       )
                                                    ),
                             IDENTIFICATION   = FACT( statut='f',max='**',
                                                      ALPHA   = SIMP(statut='f',typ='R', defaut = 0.),
                                                      EPS     = SIMP(statut='f',typ='R', defaut = 0.),
                                                      OBSERVABILITE  = SIMP(statut='o',typ=mode_meca),
                                                      COMMANDABILITE = SIMP(statut='o',typ=mode_meca),
                                                      INTE_SPEC      = SIMP(statut='o',typ=table_sdaster),
                                                      RESU_EXPANSION = SIMP(statut='f',typ='TXM',defaut='NON',into=('OUI','NON')),
                                                      BASE           = SIMP(statut='o',typ=mode_meca),
                                                     ),
                             MODIFSTRUCT = FACT( statut='f', max=1,
                                                 MESURE = SIMP(statut='o', typ=mode_meca),
                                                 MODELE_SUP = SIMP(statut='o', typ=modele_sdaster),
                                                 MATR_RIGI = SIMP(statut='o', typ=matr_asse_depl_r),
                                                 RESOLUTION = SIMP(statut='f', typ='TXM',
                                                               into=('ES', 'LMME'), defaut='ES'),
                                                 b_resol = BLOC( condition = "RESOLUTION=='LMME'",
                                                                 MATR_MASS = SIMP(statut='o', typ=matr_asse_depl_r),
                                                                ),
                                                 NUME_MODE_MESU   = SIMP(statut='o', typ='I',max='**'),
                                                 NUME_MODE_CALCUL = SIMP(statut='o', typ='I',max='**'),
                                                 MODELE_MODIF = SIMP(statut='o', typ=modele_sdaster),
                                               ),
                             # Si on realise une modification structurale, on donne les DDL capteurs et interface
                             b_modif   = BLOC( condition="MODIFSTRUCT!=None",
                                   GROUP_NO_CAPTEURS  = FACT( statut='f', max='**',
                                                              GROUP_NO = SIMP(statut='o',typ=grno, max='**'),
                                                              NOM_CMP  = SIMP(statut='o',typ='TXM', max='**'),
                                                            ),
                                   GROUP_NO_EXTERIEUR = FACT( statut='f', max='**',
                                                              GROUP_NO = SIMP(statut='o',typ=grno, max='**'),
                                                              NOM_CMP  = SIMP(statut='o',typ='TXM', max='**'),
                                                            ),
                                               ),
                                          ),
                        );

#& MODIF COMMANDE  DATE 17/11/2011   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ASSIRE A.ASSIRE
from Macro.calc_europlexus_ops import calc_europlexus_ops

def calc_europlexus_prod(self,COURBE=None,**args):
  if COURBE is not None:
      self.type_sdprod(args['TABLE_COURBE'],table_sdaster)
  return evol_noli

CALC_EUROPLEXUS = MACRO(nom="CALC_EUROPLEXUS",op=calc_europlexus_ops,sd_prod=calc_europlexus_prod,
        reentrant='n',
        UIinfo={"groupes":("Outils-mtier","Dynamique",)},
        fr="Chainage Code_Aster-Europlexus",

        LOGICIEL = SIMP(statut='f', typ='TXM', defaut='/home/europlex/EPXD/bin/europlexus'),

        MODELE     = SIMP(statut='o',typ=modele_sdaster),
        LANCEMENT = SIMP(statut='f', typ='TXM', defaut='OUI',into=('OUI',)),
        CARA_ELEM  = SIMP(statut='o',typ=cara_elem),

        FONC_PARASOL = FACT(statut='f',
           regles=(PRESENT_PRESENT('NFKT','NFKR'),
#                  PRESENT_PRESENT( 'NFAT','NFAR'),
                    ),
           NFKT       = SIMP(statut='f',typ=(fonction_sdaster,)),
           NFKR       = SIMP(statut='f',typ=(fonction_sdaster,)),
#          NFAT       = SIMP(statut='f',typ=(fonction_sdaster,)),
#          NFAR       = SIMP(statut='f',typ=(fonction_sdaster,)),
           GROUP_MA   = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           ),


        CHAM_MATER = SIMP(statut='o',typ=cham_mater),

        EXCIT      = FACT(statut='o',max='**',
           CHARGE         = SIMP(statut='o',typ=(char_meca,)),
           FONC_MULT      = SIMP(statut='o',typ=(fonction_sdaster,)),
          ),

        DIME = FACT(statut='o', regles=(AU_MOINS_UN('UNITE_DIME','Q4GS','FORCE',
                                                    'PT6L','ZONE','POUT','ECRO',
                                                    'APPU','BLOQ','PRESS','PMAT',
                                                    'DKT3','DEPL','FNOM','TABLE','FTAB',
                                                    'MTTI','NEPE','LIAI',), ),
           UNITE_DIME=SIMP(statut='f',typ='I'),

           Q4GS  = SIMP(statut='f',typ='I'),
           FORCE = SIMP(statut='f',typ='I'),
           PT6L  = SIMP(statut='f',typ='I'),
           ZONE  = SIMP(statut='f',typ='I'),
           POUT  = SIMP(statut='f',typ='I'),
           ECRO  = SIMP(statut='f',typ='I'),
           APPU  = SIMP(statut='f',typ='I'),
           BLOQ  = SIMP(statut='f',typ='I'),
           PRESS = SIMP(statut='f',typ='I',min=2,max=2,),
           PMAT  = SIMP(statut='f',typ='I'),
           DKT3  = SIMP(statut='f',typ='I'),
           DEPL  = SIMP(statut='f',typ='I'),
           FNOM  = SIMP(statut='f',typ='I'),
           TABLE = SIMP(statut='f',typ='I',min=2,max=2,),
           FTAB  = SIMP(statut='f',typ='I'),
           MTTI  = SIMP(statut='f',typ='I'),
           NEPE  = SIMP(statut='f',typ='I'),
           LIAI  = SIMP(statut='f',typ='I'),
             ),

        CALCUL = FACT(statut='o',
           TYPE_DISCRETISATION  = SIMP(statut='o',typ='TXM',defaut='AUTO',into=('AUTO','UTIL')),
           INST_FIN             = SIMP(statut='o',typ='R'),
           INST_INIT            = SIMP(statut='o',typ='R'),
           NMAX                 = SIMP(statut='f',typ='R'),

           b_auto =BLOC( condition = "TYPE_DISCRETISATION=='AUTO'",
              CSTAB  = SIMP(statut='o',typ='R',max='**',defaut=0.3),
#              DTMAX  = SIMP(statut='f',typ='R',max='**'),
                       ),

           b_util =BLOC( condition = "TYPE_DISCRETISATION=='UTIL'",
              PASFIX   = SIMP(statut='o',typ='R',max='**'),
                       ),
           ),


        OBSERVATION     =FACT(statut='f',max='**',
           SUIVI_DDL       = SIMP(statut='o',typ='TXM',defaut="OUI",max=1,into=("OUI","NON")),
        b_suivi          =BLOC(condition = "SUIVI_DDL == 'OUI' ",
                               regles=( AU_MOINS_UN('PAS_NBRE','PAS_INST',),
                                        EXCLUS('PAS_NBRE','PAS_INST',),
                                        EXCLUS('GROUP_NO','TOUT_GROUP_NO',),
                                        EXCLUS('GROUP_MA','TOUT_GROUP_MA',), ),
           NOM_CHAM        = SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',defaut=('DEPL',),into=('DEPL'
                                         ,'VITE','ACCE','SIEF_ELGA','EPSI_ELGA','VARI_ELGA'),),
           PAS_INST        = SIMP(statut='f',typ='R'),
           PAS_NBRE        = SIMP(statut='f',typ='I'),
           GROUP_NO        = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           GROUP_MA        = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           TOUT_GROUP_NO   = SIMP(statut='f',typ='TXM',into=('OUI',),),
           TOUT_GROUP_MA   = SIMP(statut='f',typ='TXM',into=('OUI',),),
                             ),
        ),


        ARCHIVAGE        =FACT(statut='o', regles=( AU_MOINS_UN('PAS_NBRE','PAS_INST',), EXCLUS('PAS_NBRE','PAS_INST',), ),
           PAS_INST     = SIMP(statut='f',typ='R'),
           PAS_NBRE     = SIMP(statut='f',typ='I'),
           CONT_GENER   = SIMP(statut='o',typ='TXM',defaut="NON",max=1,into=("OUI","NON")),
                             ),
        COURBE  =  FACT(statut='f',max='**', regles=(EXCLUS('GROUP_NO','GROUP_MA')),
           UNITE_ALIT = SIMP(statut='f',typ='I'),
            NOM_CHAM   = SIMP(statut='f',typ='TXM'),
            NOM_CMP    = SIMP(statut='f',typ='TXM'),
#             NOEUD      = SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**'),
#             MAILLE     = SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**'),
            GROUP_NO   = SIMP(statut='f',typ=grno,validators=NoRepeat(),max=1),
            GROUP_MA   = SIMP(statut='f',typ=grma,validators=NoRepeat(),max=1),

            b_maille = BLOC(condition = "GROUP_MA != None", regles=(AU_MOINS_UN('NUM_GAUSS')),
              NUM_GAUSS = SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),),
         ),
        b_courbe = BLOC(condition = "COURBE != None",
                        regles=(AU_MOINS_UN('PAS_NBRE_COURBE','PAS_INST_COURBE',),
                                AU_MOINS_UN('TABLE_COURBE',)),
          PAS_INST_COURBE      = SIMP(statut='f',typ='R'),
          PAS_NBRE_COURBE       = SIMP(statut='f',typ='I'),
                  TABLE_COURBE      = SIMP(statut='f', typ=CO),
          ),
        DOMAINES = FACT(statut='f',max='**',
             GROUP_MA = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             IDENTIFIANT =  SIMP(statut='f',typ='I'),),
        INTERFACES = FACT(statut='f',max='**',
             GROUP_MA_1 = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             GROUP_MA_2 = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             TOLE        =  SIMP(statut='f',typ='R'),
             IDENT_DOMAINE_1  = SIMP(statut='f',typ='I'),
             IDENT_DOMAINE_2  = SIMP(statut='f',typ='I'),),

         INFO            =SIMP(statut='f',typ='I',defaut=1,into=( 1, 2 ) ),
        ) ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ANGLES J.ANGLES
def calc_fatigue_prod(TYPE_CALCUL,OPTION,**args):
  if TYPE_CALCUL == "CUMUL_DOMMAGE" : return cham_elem
  if TYPE_CALCUL == "FATIGUE_MULTI" and OPTION == "DOMA_ELGA": return cham_elem
  if TYPE_CALCUL == "FATIGUE_MULTI" and OPTION == "DOMA_NOEUD": return cham_no_sdaster
  if TYPE_CALCUL == "FATIGUE_VIBR" : return cham_elem
  raise AsException("type de calcul non prevu")

CALC_FATIGUE=OPER(nom="CALC_FATIGUE",op= 151,sd_prod=calc_fatigue_prod,reentrant='n',
                  fr="Calculer un champ de dommage de fatigue subit par une structure et dterminer le plan critique"
                      +" dans lequel le cisaillement est maximal.",
            UIinfo={"groupes":("Post-traitements","Rupture",)},

         TYPE_CALCUL = SIMP(statut='o',typ='TXM',
                               into=("CUMUL_DOMMAGE","FATIGUE_MULTI","FATIGUE_VIBR") ),

         b_cumul_domma   =BLOC(condition = "TYPE_CALCUL == 'CUMUL_DOMMAGE'",
                               fr="Calcul d un champ de dommage subi par une structure.",
           regles=(PRESENT_PRESENT('DOMMAGE','MATER', ),),
           OPTION          =SIMP(statut='o',typ='TXM',
                                 into=("DOMA_ELNO_SIGM","DOMA_ELGA_SIGM",
                                       "DOMA_ELNO_EPSI","DOMA_ELGA_EPSI",
                                       "DOMA_ELNO_EPME","DOMA_ELGA_EPME") ),

             b_sigm   =BLOC(condition = "OPTION == 'DOMA_ELNO_SIGM' or OPTION == 'DOMA_ELGA_SIGM'",
                               fr="Calcul a partir d un champ de contraintes.",
               HISTOIRE        =FACT(statut='o',
               RESULTAT        =SIMP(statut='o',typ=(evol_elas,dyna_trans,
                                                   evol_noli) ),
               EQUI_GD         =SIMP(statut='f',typ='TXM',defaut="VMIS_SG",
                                 into=("VMIS_SG",) ),
                                   ),
                           ),
             b_epsi   =BLOC(condition = "OPTION != 'DOMA_ELNO_SIGM' and OPTION != 'DOMA_ELGA_SIGM'",
                               fr="Calcul a partir d un champ de dformations.",
               HISTOIRE        =FACT(statut='o',
               RESULTAT        =SIMP(statut='o',typ=(evol_elas,dyna_trans,
                                                   evol_noli) ),
               EQUI_GD         =SIMP(statut='o',typ='TXM',defaut="INVA_2_SG",
                                 into=("INVA_2_SG",) ),
                                    ),
                           ),
           DOMMAGE         =SIMP(statut='o',typ='TXM',
                               into=("WOHLER","MANSON_COFFIN","TAHERI_MANSON",
                                     "TAHERI_MIXTE",) ),
           MATER           =SIMP(statut='o',typ=(mater_sdaster) ),
           TAHERI_NAPPE    =SIMP(statut='f',typ=(nappe_sdaster,formule) ),
           TAHERI_FONC     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
         ),

         b_domma_moda   =BLOC(condition = "TYPE_CALCUL == 'FATIGUE_VIBR'",
                               fr="Calcul d un champ de dommage en dynamique vibratoire",
           regles=(PRESENT_PRESENT('DOMMAGE','MATER', ),),
           OPTION          =SIMP(statut='o',typ='TXM',
                                 into=("DOMA_ELNO_SIGM","DOMA_ELGA_SIGM",) ),
           CORR_SIGM_MOYE = SIMP(statut='o',typ='TXM',into=("GOODMAN","GERBER")),
           HISTOIRE        =FACT(statut='o',
             RESULTAT  =SIMP(statut='o',typ=(evol_elas, evol_noli) ),
             MODE_MECA        =SIMP(statut='o',typ=(mode_meca) ),
             NUME_MODE        =SIMP(statut='o',typ='I',min=1 ,max='**'),
             FACT_PARTICI        =SIMP(statut='o',typ='R',min=1, max='**',defaut=1. ),
             EQUI_GD         =SIMP(statut='f',typ='TXM',defaut="VMIS_SG",
                                 into=("VMIS_SG",) ),
           ),
           DOMMAGE         =SIMP(statut='o',typ='TXM',
                               into=("WOHLER",) ),
           MATER           =SIMP(statut='o',typ=(mater_sdaster) ),
         ),

         b_fatigue_multi   =BLOC(condition = "TYPE_CALCUL == 'FATIGUE_MULTI'",
                                 fr="Plan critique dans le cas de la fatigue multiaxiale  grand nombre de cycles.",
           TYPE_CHARGE   =SIMP(statut='o',typ='TXM',into=("PERIODIQUE","NON_PERIODIQUE") ),
           OPTION        =SIMP(statut='o',typ='TXM',into=("DOMA_ELGA","DOMA_NOEUD") ),
           RESULTAT      =SIMP(statut='o',typ=(evol_elas, evol_noli) ),
           CHAM_MATER    =SIMP(statut='o',typ=(cham_mater) ),
           MAILLAGE      =SIMP(statut='o',typ=maillage_sdaster ),
           regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),),
           GROUP_MA      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**' ),
           MAILLE        =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**' ),
           GROUP_NO      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**' ),
           NOEUD         =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**' ),
           COEF_PREECROU =SIMP(statut='f',typ='R',defaut= 1.0E+0),
           b_period       =BLOC(condition = "TYPE_CHARGE == 'PERIODIQUE'",
               CRITERE       =SIMP(statut='o',typ='TXM',into=("MATAKE_MODI_AC","DANG_VAN_MODI_AC","VMIS_TRESCA") ),
               b_fati_p  =BLOC(condition = "(CRITERE == 'MATAKE_MODI_AC' or CRITERE == 'DANG_VAN_MODI_AC')",
                   METHODE       =SIMP(statut='o',typ='TXM',into=("CERCLE_EXACT",) ),
               ),
           ),
           b_non_period   =BLOC(condition = "TYPE_CHARGE == 'NON_PERIODIQUE'",
               CRITERE       =SIMP(statut='o',typ='TXM',
                                   into=("MATAKE_MODI_AV","DANG_VAN_MODI_AV","FATESOCI_MODI_AV","VMIS_TRESCA") ),
               b_fati_np  =BLOC(condition =
                               "(CRITERE == 'MATAKE_MODI_AV' or CRITERE == 'DANG_VAN_MODI_AV' or CRITERE == 'FATESOCI_MODI_AV')",
                   PROJECTION    =SIMP(statut='o',typ='TXM',into=("UN_AXE", "DEUX_AXES") ),
                   DELTA_OSCI    =SIMP(statut='f',typ='R',defaut= 0.0E+0),
               ),
           ),
         ),

         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 02/02/2011   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET

def calc_ferrailage_prod(RESULTAT,**args):
   if AsType(RESULTAT) != None : return AsType(RESULTAT)
   raise AsException("type de concept resultat non prevu")


CALC_FERRAILLAGE=OPER(nom="CALC_FERRAILLAGE",op=175,sd_prod=calc_ferrailage_prod, reentrant='o',
            UIinfo={"groupes":("Post-traitements","Outils-mtier",)},
                 fr="calcul de cartes de densit de ferraillage ",

         RESULTAT        =SIMP(statut='o',typ=(evol_elas,evol_noli,dyna_trans,) ),


#====
# Slection des numros d'ordre pour lesquels on fait le calcul :
#====
         TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
         NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**' ),
         LIST_ORDRE      =SIMP(statut='f',typ=listis_sdaster),
         INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**' ),
         LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
         FREQ            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**' ),
         LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster),

         b_acce_reel     =BLOC(condition="(FREQ != None)or(LIST_FREQ != None)or(INST != None)or(LIST_INST != None)",
            CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",),),
            b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                 PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
            b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                 PRECISION       =SIMP(statut='o',typ='R',),),
         ),


#
#====
# Dfinition des grandeurs caractristiques
#====
#
         TYPE_COMB    =SIMP(statut='o',typ='TXM',into=('ELU','ELS')),

#        mot cl facteur rptable pour assigner les caractristiques locales par zones topologiques (GROUP_MA)
         AFFE  =FACT(statut='o',max='**',
           regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE'),),
           TOUT       =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE     =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
           ENROBG     =SIMP(statut='o',typ='R'), # enrobage
           CEQUI      =SIMP(statut='f',typ='R'), # coefficient d'quivalence acier/bton  (pour ELS)
           SIGM_ACIER =SIMP(statut='o',typ='R'), # contrainte admissible dans l'acier
           SIGM_BETON =SIMP(statut='o',typ='R'), # contrainte admissible dans le bton
           PIVA       =SIMP(statut='f',typ='R'), # valeur du pivot a  (pour ELU)
           PIVB       =SIMP(statut='f',typ='R'), # valeur du pivot b  (pour ELU)
           ),
      )


##############################################################################################################
# Remarques :
#-----------
#        l'paisseur des coques sera rcupre automatiquement
#        via le cara_elem sous-jacent au rsultat

# Le rsultat produit est un champ constant par lments associ  la grandeur FER2_R
# qui comporte les composantes :
#
#     DNSXI  densit d'acier longitudinal suivant X, peau inf
#     DNSXS  densit d'acier longitudinal suivant X, peau sup
#     DNSYI  densit d'acier longitudinal suivant Y, peau inf
#     DNSYS  densit d'acier longitudinal suivant Y, peau sup
#     DNST   densit d'acier transversal
#     SIGMBE contrainte beton
#     EPSIBE deformation bton

# arrt en erreur si:
# - EFGE_ELNO n'a pas t prcdemment calcul et n'est donc pas prsent dans la structure de donnes RESULTAT
# - si aucun CARA_ELEM n'est rcuprable via la structure de donnes RESULTAT
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ADOBES A.ADOBES
CALC_FLUI_STRU=OPER(nom="CALC_FLUI_STRU",op= 144,sd_prod=melasflu_sdaster,
                    reentrant='n',
                    fr="Calculer les paramtres modaux d'une structure soumise  un coulement",
            UIinfo={"groupes":("Matrices et vecteurs",)},
         VITE_FLUI       =FACT(statut='f',
                               fr="Dfinir la plage de vitesse fluide tudie",
           VITE_MIN        =SIMP(statut='f',typ='R' ),
           VITE_MAX        =SIMP(statut='f',typ='R' ),
           NB_POIN         =SIMP(statut='f',typ='I' ),
         ),
         BASE_MODALE     =FACT(statut='o',

           regles=(AU_MOINS_UN('AMOR_REDUIT','AMOR_UNIF','AMOR_REDUIT_CONN'),),
           MODE_MECA       =SIMP(statut='o',typ=mode_meca ),
           NUME_ORDRE      =SIMP(statut='f',typ='I',max='**'),
           AMOR_REDUIT     =SIMP(statut='f',typ='R',max='**',val_min=0.E+00),
           AMOR_UNIF       =SIMP(statut='f',typ='R',val_min=0.E+00 ),
           AMOR_REDUIT_CONN=SIMP(statut='f',typ='R',max='**',val_min=0.E+00),
         ),
         TYPE_FLUI_STRU  =SIMP(statut='o',typ=type_flui_stru ),
         IMPRESSION      =FACT(statut='f',
                               fr="Choix des informations  imprimer dans le fichier RESULTAT",
           PARA_COUPLAGE   =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           DEFORMEE        =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS
def calc_fonc_interp_prod(FONCTION, NOM_PARA_FONC, **args):
   if   AsType(FONCTION) == nappe_sdaster:
      return nappe_sdaster
   elif AsType(FONCTION) == fonction_sdaster:
      return fonction_sdaster
   elif AsType(FONCTION) == fonction_c:
      return fonction_c
   elif AsType(FONCTION) == formule_c:
      return fonction_c
   elif AsType(FONCTION) == formule:
      if NOM_PARA_FONC != None:
         return nappe_sdaster
      return fonction_sdaster
   elif AsType(FONCTION) == para_sensi:
      return para_sensi
   raise AsException("type de concept resultat non prevu")

CALC_FONC_INTERP=OPER(nom="CALC_FONC_INTERP",op= 134,sd_prod=calc_fonc_interp_prod,
                      docu="U4.32.01",reentrant='n',
           fr="Dfinit une fonction (ou une nappe)  partir d'une fonction FORMULE  1 ou 2 variables",
           UIinfo={"groupes":("Fonctions",)},
         regles=(UN_PARMI('VALE_PARA','LIST_PARA'),),
         FONCTION        =SIMP(statut='o',typ=(formule,fonction_sdaster,nappe_sdaster,fonction_c) ),
         VALE_PARA       =SIMP(statut='f',typ='R',max='**'),
         LIST_PARA       =SIMP(statut='f',typ=listr8_sdaster ),
         NOM_RESU        =SIMP(statut='f',typ='TXM'),
         NOM_PARA        =SIMP(statut='f',typ='TXM'),
         INTERPOL        =SIMP(statut='f',typ='TXM',max=2,into=("NON","LIN","LOG") ),
         PROL_DROITE     =SIMP(statut='f',typ='TXM',into=("EXCLU","CONSTANT","LINEAIRE") ),
         PROL_GAUCHE     =SIMP(statut='f',typ='TXM',into=("EXCLU","CONSTANT","LINEAIRE") ),
         NOM_PARA_FONC   =SIMP(statut='f',typ='TXM'),
         b_eval_nappe    =BLOC(condition = "NOM_PARA_FONC != None",
            regles=(UN_PARMI('VALE_PARA_FONC','LIST_PARA_FONC'),),
            VALE_PARA_FONC  =SIMP(statut='f',typ='R',max='**'),
            LIST_PARA_FONC  =SIMP(statut='f',typ=listr8_sdaster ),
            INTERPOL_FONC   =SIMP(statut='f',typ='TXM',max=2,into=("NON","LIN","LOG")),
            PROL_DROITE_FONC=SIMP(statut='f',typ='TXM',into=("EXCLU","CONSTANT","LINEAIRE") ),
            PROL_GAUCHE_FONC=SIMP(statut='f',typ='TXM',into=("EXCLU","CONSTANT","LINEAIRE") ),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2 ) ),
)  ;
#& MODIF COMMANDE  DATE 22/03/2011   AUTEUR COURTOIS M.COURTOIS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS
from Macro.calc_fonction_ops import calc_fonction_ops
def calc_fonction_prod(self,DERIVE,EXTRACTION,INTEGRE,INVERSE,COMB,COMB_C,
                       ENVELOPPE,FRACTILE,SPEC_OSCI,ASSE,FFT,COMPOSE,CORR_ACCE,PUISSANCE,
                       LISS_ENVELOP,ABS, REGR_POLYNOMIALE, **args):

   if (INTEGRE     != None): return fonction_sdaster
   if (DERIVE      != None): return fonction_sdaster
   if (INVERSE     != None): return fonction_sdaster
   if (COMB        != None):
      type_vale=AsType(COMB[0]['FONCTION'])
      for mcfact in COMB :
          if(AsType(mcfact['FONCTION'])!=type_vale):
             raise AsException("CALC_FONCTION/COMB : pas de types htrognes nappe/fonction")
      return type_vale
   if (COMB_C      != None):
      vale=COMB_C[0]['FONCTION']
      if(AsType(vale) == nappe_sdaster):
         for mcfact in COMB_C[1:] :
             if(AsType(mcfact['FONCTION'])!=nappe_sdaster):
                raise AsException("CALC_FONCTION/COMB_C : pas de types htrognes nappe/fonction")
         return nappe_sdaster
      else:
         for mcfact in COMB_C :
             if(AsType(mcfact['FONCTION'])==nappe_sdaster):
                raise AsException("CALC_FONCTION/COMB_C : pas de types htrognes nappe/fonction")
         return fonction_c
   if (ENVELOPPE   != None): return AsType(ENVELOPPE[0]['FONCTION'])
   if (FRACTILE    != None): return AsType(FRACTILE[0] ['FONCTION'])
   if (EXTRACTION  != None): return fonction_sdaster
   if (SPEC_OSCI   != None): return nappe_sdaster
   if (COMPOSE     != None): return fonction_sdaster
   if (ASSE        != None): return fonction_sdaster
   if (FFT         != None):
      vale=FFT[0]['FONCTION']
      if (AsType(vale) == fonction_sdaster )  : return fonction_c
      if (AsType(vale) == fonction_c) : return fonction_sdaster
   if (CORR_ACCE   != None): return fonction_sdaster
   if (LISS_ENVELOP!= None): return nappe_sdaster
   if (REGR_POLYNOMIALE != None): return fonction_sdaster
   if (PUISSANCE   != None): return AsType(PUISSANCE[0]['FONCTION'])
   if (ABS         != None): return fonction_sdaster
   raise AsException("type de concept resultat non prevu")


CALC_FONCTION=MACRO(nom="CALC_FONCTION",op=calc_fonction_ops,sd_prod=calc_fonction_prod
                    ,fr="Effectue des oprations mathmatiques sur des concepts de type fonction",
                     reentrant='n',
            UIinfo={"groupes":("Fonctions",)},
         regles=(UN_PARMI('DERIVE','INTEGRE','SPEC_OSCI','COMB','COMB_C','ENVELOPPE',
                          'COMPOSE','EXTRACTION','ASSE','FFT','CORR_ACCE', 'PUISSANCE',
                          'LISS_ENVELOP','INVERSE','ABS','FRACTILE','REGR_POLYNOMIALE'),),
         FFT             =FACT(statut='f',fr="Transforme de Fourier ou de son inverse",
           FONCTION        =SIMP(statut='o',typ=(fonction_sdaster,fonction_c) ),
           METHODE         =SIMP(statut='f',typ='TXM',defaut="PROL_ZERO",into=("PROL_ZERO","TRONCATURE","COMPLET") ),
           b_syme          =BLOC ( condition = " AsType(FONCTION)==fonction_c ",
             SYME           =SIMP(statut='f',typ='TXM',into=('OUI','NON'),defaut='OUI' ),
           ),
         ),
         DERIVE          =FACT(statut='f',fr="Drive d une fonction",
           METHODE         =SIMP(statut='f',typ='TXM',defaut="DIFF_CENTREE",into=("DIFF_CENTREE",) ),
           FONCTION        =SIMP(statut='o',typ=fonction_sdaster ),
         ),
         INTEGRE         =FACT(statut='f',fr="Intgrale d'une fonction",
           METHODE         =SIMP(statut='f',typ='TXM',defaut="TRAPEZE",into=("SIMPSON","TRAPEZE") ),
           FONCTION        =SIMP(statut='o',typ=fonction_sdaster),
           COEF            =SIMP(statut='f',typ='R',defaut= 0.E+0,fr="Valeur de la constante d intgration" ),
         ),
         LISS_ENVELOP    = FACT(statut='f',fr="Lissage d une enveloppe",
           NAPPE           =SIMP(statut='o',typ=nappe_sdaster ),
           FREQ_MIN        =SIMP(statut='f',typ='R',defaut =0.2),
           FREQ_MAX        =SIMP(statut='f',typ='R',defaut =35.5),
           ELARG           =SIMP(statut='f',typ='R',defaut =0.1 ),
           TOLE_LISS       =SIMP(statut='f',typ='R',defaut =0.25 ),
         ),
         REGR_POLYNOMIALE = FACT(statut='f',fr="Rgression polynomiale d'une fonction",
           FONCTION        =SIMP(statut='o',typ=fonction_sdaster),
           DEGRE           =SIMP(statut='o',typ='I'),
         ),
         SPEC_OSCI       =FACT(statut='f',fr="Spectre d'oscillateur",
           METHODE         =SIMP(statut='f',typ='TXM',defaut="NIGAM",into=("NIGAM",) ),
           FONCTION        =SIMP(statut='o',typ=fonction_sdaster ),
           AMOR_REDUIT     =SIMP(statut='f',typ='R',max='**'),
           LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster ),
           FREQ            =SIMP(statut='f',typ='R',max='**'),
           NORME           =SIMP(statut='o',typ='R',fr="Valeur de la norme du spectre d oscillateur" ),
           NATURE          =SIMP(statut='f',typ='TXM',defaut="ACCE",into=("DEPL","VITE","ACCE") ),
           NATURE_FONC     =SIMP(statut='f',typ='TXM',defaut="ACCE",into=("DEPL","VITE","ACCE") ),
         ),
         ABS             =FACT(statut='f',fr="Valeur absolue d'une fonction",
           FONCTION        =SIMP(statut='o',typ=fonction_sdaster,),
         ),
         COMB            =FACT(statut='f',max='**',fr="Combinaison linaire relle de fonctions",
           FONCTION        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster) ),
           COEF            =SIMP(statut='o',typ='R',fr="Coefficient rel de la combinaison linaire associe  la fonction" ),
         ),
         COMB_C          =FACT(statut='f',max='**',fr="Combinaison linaire complexe de fonctions",
           regles=(UN_PARMI('COEF_R','COEF_C'),),
           FONCTION        =SIMP(statut='o',typ=(fonction_sdaster,fonction_c,nappe_sdaster) ),
           COEF_R          =SIMP(statut='f',typ='R',fr="Coefficient rel de la combinaison linaire associe  la fonction" ),
           COEF_C          =SIMP(statut='f',typ='C',fr="Coefficient complexe de la combinaison linaire associe  la fonction" ),
         ),
         b_comb          =BLOC ( condition = "COMB != None or COMB_C != None or REGR_POLYNOMIALE != None",
             LIST_PARA      =SIMP(statut='f',typ=listr8_sdaster ),
         ),
         COMPOSE         =FACT(statut='f',fr="Composition de deux fonctions FONC_RESU(FONC_PARA)",
           FONC_RESU       =SIMP(statut='o',typ=fonction_sdaster),
           FONC_PARA       =SIMP(statut='o',typ=fonction_sdaster),
         ),
         EXTRACTION      =FACT(statut='f',fr="Extraction sur une fonction complexe",
           FONCTION        =SIMP(statut='o',typ=fonction_c),
           PARTIE          =SIMP(statut='o',typ='TXM',into=("REEL","IMAG","MODULE","PHASE"),fr="Partie  extraire"),
         ),
         ENVELOPPE       =FACT(statut='f',fr="Enveloppe d une famille de fonctions",
           FONCTION        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster),max='**' ),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="SUP",into=("SUP","INF"),fr="Type de l enveloppe" ),
         ),
         FRACTILE        =FACT(statut='f',fr="Fractile d une famille de fonctions ou de nappes",
           FONCTION        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster),max='**' ),
           FRACT           =SIMP(statut='o',typ='R',defaut=1.,val_min=0.,val_max=1.,fr="Valeur du fractile" ),
         ),
         ASSE            =FACT(statut='f',fr="Concatenation de fonctions",
           FONCTION        =SIMP(statut='o',typ=fonction_sdaster,min=2,max=2 ),
           SURCHARGE       =SIMP(statut='f',typ='TXM',defaut="DROITE",into=("DROITE","GAUCHE")),
         ),
         CORR_ACCE       =FACT(statut='f',fr="Correction d un accelerogramme reel",
            CORR_DEPL       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
            FONCTION        =SIMP(statut='o',typ=fonction_sdaster ),
         ),
         PUISSANCE       =FACT(statut='f',fr="Fonction leve  une puissance",
            FONCTION      =SIMP(statut='o', typ=(fonction_sdaster,nappe_sdaster) ),
            EXPOSANT      =SIMP(statut='f', typ='I', defaut=1 ),
         ),
         INVERSE         =FACT(statut='f',fr="Inverse d'une fonction",
            FONCTION      =SIMP(statut='o', typ=fonction_sdaster),
         ),
         NOM_PARA        =SIMP(statut='f',typ='TXM',into=C_PARA_FONCTION() ),
         NOM_RESU        =SIMP(statut='f',typ='TXM' ),
         INTERPOL        =SIMP(statut='f',typ='TXM',max=2,into=("NON","LIN","LOG"),
                               fr="Type d'interpolation pour les abscisses et les ordonnes de la " \
                                  "fonction ou bien pour le paramtre de la nappe."),
         PROL_DROITE     =SIMP(statut='f',typ='TXM',into=("CONSTANT","LINEAIRE","EXCLU") ),
         PROL_GAUCHE     =SIMP(statut='f',typ='TXM',into=("CONSTANT","LINEAIRE","EXCLU") ),
         NOM_PARA_FONC   =SIMP(statut='f',typ='TXM',into=C_PARA_FONCTION() ),
         INTERPOL_FONC   =SIMP(statut='f',typ='TXM',max=2,into=("NON","LIN","LOG"),
                                 fr="Type d'interpolation pour les abscisses et les ordonnes de la fonction"),
         PROL_DROITE_FONC=SIMP(statut='f',typ='TXM',into=("CONSTANT","LINEAIRE","EXCLU") ),
         PROL_GAUCHE_FONC=SIMP(statut='f',typ='TXM',into=("CONSTANT","LINEAIRE","EXCLU") ),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
)
#& MODIF COMMANDE  DATE 08/02/2011   AUTEUR TARDIEU N.TARDIEU 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE GREFFET N.GREFFET
CALC_FORC_AJOU=OPER(nom="CALC_FORC_AJOU",op=199,sd_prod=vect_asse_gene,
                   fr="Calculer l'effet de surpression hydrodynamique due au mouvement d'entrainement de la structure"
                       +" en analyse sismique",
                   reentrant ='n',
            UIinfo={"groupes":("Matrices et vecteurs",)},

        regles=(EXCLUS('MODE_MECA','MODELE_GENE'),
                PRESENT_PRESENT( 'MODELE_GENE','NUME_DDL_GENE'),
                UN_PARMI('MONO_APPUI', 'NOEUD','GROUP_NO'),
                UN_PARMI('MONO_APPUI','MODE_STAT')),

         MODELE_FLUIDE   =SIMP(statut='o',typ=modele_sdaster ),
         MODELE_INTERFACE=SIMP(statut='o',typ=modele_sdaster ),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater ),
         CHARGE          =SIMP(statut='o',typ=char_ther ),
         MODE_MECA       =SIMP(statut='f',typ=mode_meca ),
         MODELE_GENE     =SIMP(statut='f',typ=modele_gene ),
         NUME_DDL_GENE   =SIMP(statut='f',typ=nume_ddl_gene ),
         DIST_REFE       =SIMP(statut='f',typ='R',defaut= 1.E-2 ),
         AVEC_MODE_STAT  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         NUME_MODE_MECA  =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
         POTENTIEL       =SIMP(statut='f',typ=evol_ther ),
         NOEUD_DOUBLE    =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),

         DIRECTION       =SIMP(statut='o',typ='R',max=3),
         MONO_APPUI      =SIMP(statut='f',typ='TXM',into=("OUI",),),
         NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
         GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
         MODE_STAT       =SIMP(statut='f',typ=mode_meca,),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2 ) ),

         SOLVEUR         =FACT(statut='d',
           METHODE         =SIMP(statut='f',typ='TXM',defaut="MULT_FRONT",into=("MULT_FRONT","LDLT","GCPC","MUMPS","PETSC") ),
           b_mult_front    = BLOC ( condition = "METHODE == 'MULT_FRONT' ",fr="Paramtres de la mthode multi frontale",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="METIS",into=("MD","MDA","METIS") ),
           ),
           b_ldlt          =BLOC( condition = "METHODE == 'LDLT' ",fr="Paramtres de la mthode LDLT",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("RCMK","SANS") ),
           ),
           b_ldlt_mult_mumps =BLOC( condition = "METHODE=='LDLT' or METHODE=='MULT_FRONT' or METHODE=='MUMPS' ",
                                   fr="Paramtres relatifs  la non inversibilit de la matrice  factoriser",
             NPREC           =SIMP(statut='f',typ='I',defaut= 8 ),
             STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           ),
           b_gcpc         =BLOC(condition = "METHODE == 'GCPC' ", fr="Paramtres de la mthode du gradient conjugu",
             PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC","LDLT_SP",),defaut="LDLT_INC" ),
             b_ldltinc       =BLOC(condition = "PRE_COND == 'LDLT_INC' ", fr="Paramtres de la factorisation incomplte",
               NIVE_REMPLISSAGE    =SIMP(statut='f',typ='I',defaut= 0 ),
               RENUM               =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
               ),
             b_simple        =BLOC(condition = "PRE_COND == 'LDLT_SP' ", fr="Paramtres de la factorisation simple prcision",
               REAC_PRECOND        =SIMP(statut='f',typ='I',defaut=30, ),
               ),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
             NMAX_ITER       =SIMP(statut='f',typ='I',defaut= 0 ),
           ),
           b_mumps        =BLOC(condition = "METHODE == 'MUMPS' ",fr="Paramtres de la mthode MUMPS",
             TYPE_RESOL      =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("NONSYM","SYMGEN","SYMDEF","AUTO")),
             PRETRAITEMENTS  =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO")),
             POSTTRAITEMENTS =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO","FORCE")),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("AMD","AMF","PORD","METIS","QAMD","SCOTCH","AUTO")),
             ELIM_LAGR2      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
             PCENT_PIVOT     =SIMP(statut='f',typ='I',defaut=10,),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut=1.0E-6,),
             OUT_OF_CORE     =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
             LIBERE_MEMOIRE =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),            
           ),
           b_petsc          =BLOC(condition = "METHODE == 'PETSC' ",fr="Paramtres de la mthode PETSC",
             ALGORITHME      =SIMP(statut='f',typ='TXM',into=("BCGS","BICG","CG","CR","GMRES","TFQMR",),defaut="CG" ),
             PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC","JACOBI","SOR","LDLT_SP"),defaut="LDLT_INC" ),
             b_ldlt_inc     =BLOC(condition = "PRE_COND == 'LDLT_INC' ",
               NIVE_REMPLISSAGE = SIMP(statut='f',typ='I',defaut= 0 ),
               REMPLISSAGE      = SIMP(statut='f',typ='R',defaut= 1.0),
               RENUM            =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
             ),
             b_ldlt_sp      =BLOC(condition = "PRE_COND == 'LDLT_SP' ", fr="Paramtres de la factorisation simple prcision",
               REAC_PRECOND        =SIMP(statut='f',typ='I',defaut=30, ),
               RENUM               =SIMP(statut='f',typ='TXM',defaut="SANS",into=("SANS","RCMK") ),
             ),
             b_jacobi_sor   =BLOC(condition = "PRE_COND == 'JACOBI' or PRE_COND == 'SOR'",
                                                                         fr="Paramtres des prconditionneurs JACOBI et SOR",
               RENUM               =SIMP(statut='f',typ='TXM',defaut="SANS",into=("SANS","RCMK") ),
             ),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
             NMAX_ITER       =SIMP(statut='f',typ='I',defaut= -1 ),
           ),
        ),
     ) ;
#& MODIF COMMANDE  DATE 14/12/2010   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2010  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE DEVESA

CALC_FORC_NONL=OPER(nom="CALC_FORC_NONL",op= 183,sd_prod=dyna_trans,reentrant='n',
            fr="Crer un dyna_trans contenant des champs nomms 'DEPL' correspondant  'FONL_NOEU' ",
            UIinfo={"groupes":("Post-traitements","Rsultats et champs",)},
         RESULTAT        =SIMP(statut='o',typ=resultat_sdaster),

         regles=(EXCLUS('TOUT_ORDRE','NUME_ORDRE','INST','FREQ','NUME_MODE',
                        'NOEUD_CMP','LIST_INST','LIST_FREQ','LIST_ORDRE','NOM_CAS'),
                 ),
         TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
         NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
         NUME_MODE       =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
         NOEUD_CMP       =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**'),
         NOM_CAS         =SIMP(statut='f',typ='TXM' ),
         INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
         FREQ            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
         LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
         LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster),
         LIST_ORDRE      =SIMP(statut='f',typ=listis_sdaster),
         CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",),),
         b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
         b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
             PRECISION       =SIMP(statut='o',typ='R',),),
         OPTION          =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=1, defaut="FONL_NOEU",
                               into=("FONL_NOEU",) ),

         MODELE          =SIMP(statut='o',typ=modele_sdaster),
         CHAM_MATER      =SIMP(statut='f',typ=cham_mater),
         CARA_ELEM       =SIMP(statut='f',typ=cara_elem),

         COMP_INCR       =C_COMP_INCR(),
)  ;
#& MODIF COMMANDE  DATE 07/12/2010   AUTEUR GENIAUT S.GENIAUT 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2006  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE GALENNE E.GALENNE
CALC_G=OPER(nom="CALC_G",op=100,sd_prod=table_sdaster,
            fr="Calcul du taux de restitution d'nergie par la mthode theta en thermo-lasticit"
                        +" et les facteurs d'intensit de contraintes.",
                    reentrant='f',
            UIinfo={"groupes":("Post-traitements","Rupture",)},
         regles=(EXCLUS('COMP_ELAS','COMP_INCR'),
                 CONCEPT_SENSIBLE("ENSEMBLE"),
                 REUSE_SENSIBLE(),
                 DERIVABLE('RESULTAT'),),

         THETA          =FACT(statut='o',
           THETA           =SIMP(statut='f',typ=(theta_geom,cham_no_sdaster),),
           FOND_FISS       =SIMP(statut='f',typ=fond_fiss,max=1),
           FISSURE         =SIMP(statut='f',typ=fiss_xfem,max=1),
           DTAN_ORIG       =SIMP(statut='f',typ='R',max='**'),
           DTAN_EXTR       =SIMP(statut='f',typ='R',max='**'),
           NB_POINT_FOND   =SIMP(statut='f',typ='I',val_min=2),
           regles=(EXCLUS('FOND_FISS','FISSURE'),
                 EXCLUS('FOND_FISS','NB_POINT_FOND'),
                 EXCLUS('FOND_FISS','DTAN_ORIG'),
                 EXCLUS('FOND_FISS','DTAN_EXTR'),),
          b_theta        =BLOC(condition="THETA == None",fr="calcul de theta",
            regles=(UN_PARMI('R_INF','R_INF_FO'),
                 PRESENT_PRESENT('R_INF','R_SUP'),
                PRESENT_PRESENT('R_INF_FO','R_SUP_FO'), ),
             NUME_FOND        =SIMP(statut='f',typ='I',defaut=1),
             R_INF           =SIMP(statut='f',typ='R'),
             R_SUP           =SIMP(statut='f',typ='R'),
             MODULE          =SIMP(statut='f',typ='R',defaut=1.),
             DIRE_THETA      =SIMP(statut='f',typ=cham_no_sdaster ),
             DIRECTION       =SIMP(statut='f',typ='R',max=3,min=3),
             R_INF_FO        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R_SUP_FO        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MODULE_FO       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ),
            ),

         RESULTAT        =SIMP(statut='o',typ=(evol_elas,evol_noli,dyna_trans,mode_meca,mult_elas),),

         b_no_mult          =BLOC(condition="(AsType(RESULTAT) != mult_elas)",
         regles=(EXCLUS('TOUT_ORDRE','NUME_ORDRE','LIST_ORDRE','INST','LIST_INST',
                  'TOUT_MODE','NUME_MODE','LIST_MODE','FREQ','LIST_FREQ'),),

            TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
            NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
            LIST_ORDRE      =SIMP(statut='f',typ=listis_sdaster),
            INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
            LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
            TOUT_MODE       =SIMP(statut='f',typ='TXM',into=("OUI",) ),
            NUME_MODE       =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
            LIST_MODE       =SIMP(statut='f',typ=listis_sdaster),
            LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster),
            FREQ            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),

           b_acce_reel     =BLOC(condition="(INST != None)or(LIST_INST != None)or(FREQ != None)or(LIST_FREQ != None)",
              CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
                  b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                      PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
                  b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                      PRECISION       =SIMP(statut='o',typ='R'),),
            ),
         ),

         b_mult_elas     =BLOC(condition="(AsType(RESULTAT) == mult_elas)",
            NOM_CAS         =SIMP(statut='f',typ='TXM',validators=NoRepeat() ),
         ),


         EXCIT           =FACT(statut='f',max='**',
               CHARGE          =SIMP(statut='f',typ=(char_meca,char_cine_meca)),
               FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
               TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE",into=("FIXE",) ),
         ),
         SYME_CHAR       =SIMP(statut='f',typ='TXM',defaut="SANS",into=("SYME","ANTI","SANS") ),

         COMP_ELAS       =C_COMP_ELAS('CALC_G'),

         COMP_INCR       =FACT(statut='f',
               RELATION        =SIMP(statut='f',typ='TXM',defaut="ELAS",
                                     into=("ELAS","VMIS_ISOT_TRAC","VMIS_ISOT_LINE","VMIS_CINE_LINE","VMIS_ISOT_PUIS") ),
               DEFORMATION     =SIMP(statut='f',typ='TXM',defaut="PETIT",into=("PETIT","PETIT_REAC") ),
      regles=(PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
               TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
               GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
               MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
         ),
         ETAT_INIT       =FACT(statut='f',
           SIGM            =SIMP(statut='f',typ=cham_elem),
           DEPL            =SIMP(statut='f',typ=cham_no_sdaster),
         ),

         LISSAGE         =FACT(statut='d',
           DEGRE           =SIMP(statut='f',typ='I',defaut=5,into=(0,1,2,3,4,5,6,7) ),
           LISSAGE_THETA   =SIMP(statut='f',typ='TXM',defaut="LEGENDRE",into=("LEGENDRE","LAGRANGE","LAGRANGE_REGU"),),
           LISSAGE_G       =SIMP(statut='f',typ='TXM',defaut="LEGENDRE",into=("LEGENDRE","LAGRANGE",
                                 "LAGRANGE_NO_NO","LAGRANGE_REGU"),),
         ),

         OPTION          =SIMP(statut='o',typ='TXM',max=1,defaut='CALC_G',
              into=("CALC_G","CALC_G_GLOB","CALC_K_G","K_G_MODA","G_MAX","G_MAX_GLOB","G_BILI",
                    "G_BILI_GLOB","CALC_K_MAX"),),

         b_g_max    =BLOC(condition="(OPTION=='G_MAX') or (OPTION=='G_MAX_GLOB')",
           BORNES          =FACT(statut='o',max='**',
                NUME_ORDRE     =SIMP(statut='o',typ='I'),
                VALE_MIN       =SIMP(statut='o',typ='R'),
                VALE_MAX       =SIMP(statut='o',typ='R'),
                                ),
         ),
         b_k_max    =BLOC(condition="(OPTION=='CALC_K_MAX')",
           SIGNES          =FACT(statut='o',max=1,
                CHARGE_S       =SIMP(statut='o',typ='I',validators=NoRepeat(),max='**'),
                CHARGE_NS      =SIMP(statut='o',typ='I',validators=NoRepeat(),max='**'),
                                ),
         ),

         SENSIBILITE     =SIMP(statut='f',typ=(para_sensi,theta_geom),validators=NoRepeat(),max='**',
                           fr="Liste des paramtres de sensibilit.",
                           ang="List of sensitivity parameters"),

         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
);
#& MODIF COMMANDE  DATE 04/05/2011   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE GREFFET N.GREFFET
#
# MACRO DE COUPLAGE IFS AVEC SATURNE VIA YACS
#
from Macro.calc_ifs_dnl_ops import calc_ifs_dnl_ops
#
CALC_IFS_DNL= MACRO(nom='CALC_IFS_DNL',op=calc_ifs_dnl_ops,sd_prod=evol_noli,reentrant='f',
            fr="Calcul de l'volution dynamique d'une structure couple  un domaine fluide (rsolu avec le code Saturne) via YACS",
            UIinfo={"groupes":("Rsolution","Dynamique",)},
         regles=(AU_MOINS_UN('COMP_INCR','COMP_ELAS',),
                 CONCEPT_SENSIBLE('ENSEMBLE'),),
#IFS
#=>
         GROUP_MA_IFS     =SIMP(statut='o',typ=grma,max='**'),
         NOM_CMP_IFS      =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**'),
         UNITE_NOEUD      =SIMP(statut='f',typ='I',defaut= 81 ),
         UNITE_ELEM       =SIMP(statut='f',typ='I',defaut= 82 ),
         PAS_INIT         =SIMP(statut='o',typ='R' ),
#<=
#IFS
         MODELE          =SIMP(statut='o',typ=modele_sdaster),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater),
         MODE_STAT       =SIMP(statut='f',typ=mode_meca),
         CARA_ELEM       =SIMP(statut='f',typ=cara_elem),
         MASS_DIAG       =SIMP(statut='f',typ='TXM',into=("OUI","NON",) ),
#IFS
#=>
#(une charge force nodale est fournie par le couplage avec code_saturne
         EXCIT           =FACT(statut='f',max='**',
#<=
#IFS
           regles=(PRESENT_ABSENT('FONC_MULT','ACCE'),
                   PRESENT_PRESENT('ACCE','VITE','DEPL'),
                   # PRESENT_ABSENT('MULT_APPUI','FONC_MULT'),
                   ),
           TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE_CSTE",
                                 into=("FIXE_CSTE","SUIV","DIDI")),
#IFS
#=>
#(une charge force nodale est fournie par le couplage avec code_saturne
#           CHARGE          =SIMP(statut='o',typ=(char_meca,char_cine_meca)),
           CHARGE          =SIMP(statut='f',typ=(char_meca,char_cine_meca)),
#<=
#IFS
           FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           DEPL            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ACCE            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           VITE            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           MULT_APPUI      =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
           DIRECTION       =SIMP(statut='f',typ='R',max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
         ),
         EXCIT_GENE      =FACT(statut='f',max='**',
           FONC_MULT       =SIMP(statut='f',typ=fonction_sdaster,max='**' ),
           VECT_GENE       =SIMP(statut='f',typ=vect_asse_gene,max='**' ),
         ),
         CONTACT         =SIMP(statut='f',typ=char_contact),
         SOUS_STRUC      =FACT(statut='f',min=01,max='**',
                regles=(UN_PARMI('TOUT','SUPER_MAILLE'),),
                CAS_CHARGE  =SIMP(statut='o',typ='TXM' ),
                TOUT        =SIMP(statut='f',typ='TXM',into=("OUI",) ),
                SUPER_MAILLE=SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**',),
                FONC_MULT   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
              ),
         AMOR_RAYL_RIGI = SIMP(statut='f',typ='TXM',defaut="TANGENTE",into=("TANGENTE","ELASTIQUE"),),
         AMOR_MODAL      =FACT(statut='f',
           regles=(EXCLUS('AMOR_REDUIT','LIST_AMOR'),),
           MODE_MECA       =SIMP(statut='f',typ=mode_meca),
           AMOR_REDUIT     =SIMP(statut='f',typ='R',max='**' ),
           LIST_AMOR       =SIMP(statut='f',typ=listr8_sdaster ),
           NB_MODE         =SIMP(statut='f',typ='I',defaut= 9999 ),
           REAC_VITE       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         ),
         PROJ_MODAL      =FACT(statut='f',max='**',
           MODE_MECA       =SIMP(statut='o',typ=mode_meca),
           NB_MODE         =SIMP(statut='f',typ='I',defaut= 9999 ),
           regles=(PRESENT_PRESENT('MASS_GENE','RIGI_GENE'),),
           MASS_GENE       =SIMP(statut='f',typ=matr_asse_gene_r),
           RIGI_GENE       =SIMP(statut='f',typ=matr_asse_gene_r),
           AMOR_GENE       =SIMP(statut='f',typ=matr_asse_gene_r),
           DEPL_INIT_GENE  =SIMP(statut='f',typ=vect_asse_gene),
           VITE_INIT_GENE  =SIMP(statut='f',typ=vect_asse_gene),
           ACCE_INIT_GENE  =SIMP(statut='f',typ=vect_asse_gene),
         ),
#-------------------------------------------------------------------         
         COMP_INCR       =C_COMP_INCR(),
#-------------------------------------------------------------------         
         COMP_ELAS       =C_COMP_ELAS('DYNA_NON_LINE'),
#-------------------------------------------------------------------
         b_reuse =BLOC(condition = "reuse",fr="en mode concept reentrant : ETAT_INIT obligatoire",
         ETAT_INIT       =FACT(statut='o',
           regles=(AU_MOINS_UN('EVOL_NOLI','DEPL','VITE','ACCE','SIGM','VARI',),
                   EXCLUS('EVOL_NOLI','DEPL',),
                   EXCLUS('EVOL_NOLI','VITE'),
                   EXCLUS('EVOL_NOLI','ACCE'),
                   EXCLUS('EVOL_NOLI','SIGM',),
                   EXCLUS('EVOL_NOLI','VARI',),
                   EXCLUS('NUME_ORDRE','INST'), ),
           DEPL            =SIMP(statut='f',typ=cham_no_sdaster),
           VITE            =SIMP(statut='f',typ=cham_no_sdaster),
           ACCE            =SIMP(statut='f',typ=cham_no_sdaster),
           SIGM            =SIMP(statut='f',typ=(cham_elem,carte_sdaster)),
           VARI            =SIMP(statut='f',typ=cham_elem),
           EVOL_NOLI       =SIMP(statut='f',typ=evol_noli),
           NUME_ORDRE      =SIMP(statut='f',typ='I'),
           INST            =SIMP(statut='f',typ='R'),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
           b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
               PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
           b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
               PRECISION       =SIMP(statut='o',typ='R',),),
           NUME_DIDI       =SIMP(statut='f',typ='I'),
           INST_ETAT_INIT  =SIMP(statut='f',typ='R'),
         ),),
         b_not_reuse =BLOC(condition = "not reuse",fr="en mode concept non reentrant : ETAT_INIT facultatif",
         ETAT_INIT       =FACT(statut='f',
           regles=(AU_MOINS_UN('EVOL_NOLI','DEPL','VITE','ACCE','SIGM','VARI',),
                   EXCLUS('EVOL_NOLI','DEPL',),
                   EXCLUS('EVOL_NOLI','VITE'),
                   EXCLUS('EVOL_NOLI','ACCE'),
                   EXCLUS('EVOL_NOLI','SIGM',),
                   EXCLUS('EVOL_NOLI','VARI',),
                   EXCLUS('NUME_ORDRE','INST'), ),
           DEPL            =SIMP(statut='f',typ=cham_no_sdaster),
           VITE            =SIMP(statut='f',typ=cham_no_sdaster),
           ACCE            =SIMP(statut='f',typ=cham_no_sdaster),
           SIGM            =SIMP(statut='f',typ=(cham_elem,carte_sdaster)),
           VARI            =SIMP(statut='f',typ=cham_elem),
           EVOL_NOLI       =SIMP(statut='f',typ=evol_noli),
           NUME_ORDRE      =SIMP(statut='f',typ='I'),
           INST            =SIMP(statut='f',typ='R'),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
           b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
               PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
           b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
               PRECISION       =SIMP(statut='o',typ='R',),),
           NUME_DIDI       =SIMP(statut='f',typ='I'),
           INST_ETAT_INIT  =SIMP(statut='f',typ='R'),
         ),),
#-------------------------------------------------------------------
#IFS : pas besoin d'INCREMENT
#         INCREMENT       =C_INCREMENT(),
#-------------------------------------------------------------------
         SCHEMA_TEMPS     =FACT(statut='o',
            SCHEMA          =SIMP(statut='o',min=1,max=1,typ='TXM',
            into=("DIFF_CENT","TCHAMWA","NEWMARK","HHT","THETA_METHODE","KRENK"),),
            COEF_MASS_SHIFT =SIMP(statut='f',typ='R',defaut= 0.0E+0 ),
            b_tchamwa = BLOC(condition="SCHEMA=='TCHAMWA'",
               PHI          =SIMP(statut='f',typ='R',defaut= 1.05),),
               
            b_newmark = BLOC(condition="SCHEMA=='NEWMARK'",
               BETA         =SIMP(statut='f',typ='R',defaut= 0.25),
               GAMMA        =SIMP(statut='f',typ='R',defaut= 0.5),),
               
            b_hht     = BLOC(condition="SCHEMA=='HHT'",
               ALPHA        =SIMP(statut='f',typ='R',defaut= -0.3 ),
               MODI_EQUI    =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON"),),),
               
            b_theta   = BLOC(condition="SCHEMA=='THETA_METHODE'",
               THETA         =SIMP(statut='f',typ='R',defaut= 1.,val_min=0.5,val_max=100. ),),

            b_krenk   = BLOC(condition="SCHEMA=='KRENK'",
               KAPPA         =SIMP(statut='f',typ='R',defaut= 1.0,val_min=1.0,val_max=100. ),), 
               
            b_explicit= BLOC(condition="SCHEMA=='TCHAMWA'or SCHEMA=='DIFF_CENT'",
               STOP_CFL     =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON"),),
               FORMULATION  =SIMP(statut='o',typ='TXM',into=("ACCELERATION",),),),
               
            b_implicit= BLOC(condition="SCHEMA!='TCHAMWA'and SCHEMA!='DIFF_CENT'",
               FORMULATION  =SIMP(statut='o',max=1,typ='TXM',into=("DEPLACEMENT","VITESSE","ACCELERATION"),),),
         ),
#-------------------------------------------------------------------         
         NEWTON          =C_NEWTON(),
#-------------------------------------------------------------------
         RECH_LINEAIRE   =C_RECH_LINEAIRE(),
#-------------------------------------------------------------------
         CONVERGENCE     =C_CONVERGENCE(),
#-------------------------------------------------------------------
         SOLVEUR         =C_SOLVEUR(),
#-------------------------------------------------------------------
         OBSERVATION     =C_OBSERVATION(),
#-------------------------------------------------------------------
         SUIVI_DDL       =C_SUIVI_DDL(),
#------------------------------------------------------------------- 
         AFFICHAGE       =C_AFFICHAGE(),
#-------------------------------------------------------------------
         ARCHIVAGE       =C_ARCHIVAGE(),
#-------------------------------------------------------------------
         CRIT_FLAMB     =FACT(statut='f',min=1,max=1,
           NB_FREQ         =SIMP(statut='f',typ='I',max=1,defaut=3),
           CHAR_CRIT       =SIMP(statut='f',typ='R',min=2,max=2,defaut=(-10.0,10.),
                            fr="Valeur des deux charges critiques dlimitant la bande de recherche en HPP"),
           RIGI_GEOM     =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
           bloc_ddl_exclus=BLOC(condition="(RIGI_GEOM=='NON')",
              DDL_EXCLUS      =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max=40,
                                    into=('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI',
                                          'TEMP','PRE1','PRE2','UI2','UI3','VI2','VI3','WI2','WI3','UO2',
                                          'UO3','VO2','VO3','WO2','WO3','UI4','UI5','VI4','VI5','WI4',
                                          'WI5','UO4','UO5','VO4','VO5','WO4','WO5','UI6','UO6','VI6',
                                          'VO6','WI6','WO6','WO','WI1','WO1','GONF','LIAISON','DCX',
                                          'DCY','DCZ','H1X','H1Y','H1Z','E1X','E1Y','E1Z','E2X','E2Y','E2Z',
                                          'E3X','E3Y','E3Z','E4X','E4Y','E4Z','LAGS_C','V11','V12','V13','V21','V22',
                                          'V23','V31','V32','V33','PRES11','PRES12','PRES13','PRES21','PRES22','PRES23',
                                          'PRES31','PRES32','PRES33','VARI','LAG_GV')),),
           INST_CALCUL       =SIMP(statut='f',typ='TXM',defaut="LISTE_ARCHIVAGE",into=("LISTE_ARCHIVAGE","TOUT_PAS",) ),
         ),
         MODE_VIBR     =FACT(statut='f',min=1,max=1,
           MATR_RIGI        =SIMP(statut='f',typ='TXM',defaut="ELASTIQUE",into=("ELASTIQUE","TANGENTE","SECANTE",) ),
           NB_FREQ          =SIMP(statut='f',typ='I',max=1,defaut=3,
                            fr="Nombre de frquences propres  calculer"),
           BANDE            =SIMP(statut='f',typ='R',min=2,max=2,
                            fr="Valeur des deux frquences dlimitant la bande de recherche",),
           INST_CALCUL       =SIMP(statut='f',typ='TXM',defaut="LISTE_ARCHIVAGE",into=("LISTE_ARCHIVAGE","TOUT_PAS",) ),
         ),
#-------------------------------------------------------------------
           SENSIBILITE     =SIMP(statut='f',typ=(para_sensi,theta_geom),validators=NoRepeat(),max='**',
                               fr="Liste des paramtres de sensibilit",
                               ang="List of sensitivity parameters"),
#-------------------------------------------------------------------
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
         b_info=BLOC(condition="(INFO==2)",
               fr="filtre les messages mis dans le .mess selon le type de message demand",
               INFO_DBG = SIMP(statut='f',typ='TXM',max='**',validators=NoRepeat(),
                               into=("CONTACT",
                                     "MECA_NON_LINE",
                                     "PILOTAGE",
                                     "FACTORISATION",
                                     "APPARIEMENT"),
                             ),
                    ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ZENTNER I.ZENTNER
CALC_INTE_SPEC=OPER(nom="CALC_INTE_SPEC",op= 120,sd_prod=table_fonction,
                    fr="Calcul d'une matrice interspectrale  partir d'une fonction du temps",
                    reentrant='n',
            UIinfo={"groupes":("Fonctions",)},
         INST_INIT       =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
         INST_FIN        =SIMP(statut='o',typ='R' ),
         DUREE_ANALYSE   =SIMP(statut='f',typ='R' ),
         DUREE_DECALAGE  =SIMP(statut='f',typ='R' ),
         NB_POIN         =SIMP(statut='o',typ='I' ),
         FONCTION        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule),max='**' ),
         TITRE           =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**'),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 08/02/2011   AUTEUR TARDIEU N.TARDIEU 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE GREFFET N.GREFFET
CALC_MATR_AJOU=OPER(nom="CALC_MATR_AJOU",op= 152,sd_prod=matr_asse_gene_r,
                    fr="Calcul des matrices de masse, d'amortissement ou de rigidit ajouts",
                    reentrant='n',
            UIinfo={"groupes":("Matrices et vecteurs",)},
         regles=(EXCLUS('MODE_MECA','CHAM_NO','MODELE_GENE'),
                 PRESENT_ABSENT('NUME_DDL_GENE','CHAM_NO'),
                 PRESENT_PRESENT('MODELE_GENE','NUME_DDL_GENE'),),
         MODELE_FLUIDE   =SIMP(statut='o',typ=modele_sdaster ),
         MODELE_INTERFACE=SIMP(statut='o',typ=modele_sdaster ),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater ),
         CHARGE          =SIMP(statut='o',typ=char_ther ),
         MODE_MECA       =SIMP(statut='f',typ=mode_meca ),
         CHAM_NO         =SIMP(statut='f',typ=cham_no_sdaster ),
         MODELE_GENE     =SIMP(statut='f',typ=modele_gene ),
         NUME_DDL_GENE   =SIMP(statut='f',typ=nume_ddl_gene ),
         DIST_REFE       =SIMP(statut='f',typ='R',defaut= 1.E-2 ),
         AVEC_MODE_STAT  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         NUME_MODE_MECA  =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
         OPTION          =SIMP(statut='o',typ='TXM',into=("MASS_AJOU","AMOR_AJOU","RIGI_AJOU") ),
         POTENTIEL       =SIMP(statut='f',typ=evol_ther ),
         NOEUD_DOUBLE    =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2 ) ),

         SOLVEUR         =FACT(statut='d',
           METHODE         =SIMP(statut='f',typ='TXM',defaut="MULT_FRONT",into=("MULT_FRONT","LDLT","GCPC","MUMPS","PETSC") ),
           b_mult_front    = BLOC ( condition = "METHODE == 'MULT_FRONT' ",fr="Paramtres de la mthode multi frontale",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="METIS",into=("MD","MDA","METIS") ),
           ),
           b_ldlt          =BLOC( condition = "METHODE == 'LDLT' ",fr="Paramtres de la mthode LDLT",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("RCMK","SANS") ),
           ),
           b_ldlt_mult_mumps =BLOC( condition = "METHODE=='LDLT' or METHODE=='MULT_FRONT' or METHODE=='MUMPS' ",
                                   fr="Paramtres relatifs  la non inversibilit de la matrice  factoriser",
             NPREC           =SIMP(statut='f',typ='I',defaut= 8 ),
             STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           ),
           b_gcpc         =BLOC(condition = "METHODE == 'GCPC' ", fr="Paramtres de la mthode du gradient conjugu",
             PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC","LDLT_SP",),defaut="LDLT_INC" ),
             b_ldltinc       =BLOC(condition = "PRE_COND == 'LDLT_INC' ", fr="Paramtres de la factorisation incomplte",
               NIVE_REMPLISSAGE    =SIMP(statut='f',typ='I',defaut= 0 ),
               RENUM               =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
               ),
             b_simple        =BLOC(condition = "PRE_COND == 'LDLT_SP' ", fr="Paramtres de la factorisation simple prcision",
               REAC_PRECOND        =SIMP(statut='f',typ='I',defaut=30, ),
               ),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
             NMAX_ITER       =SIMP(statut='f',typ='I',defaut= 0 ),
           ),
           b_mumps        =BLOC(condition = "METHODE == 'MUMPS' ",fr="Paramtres de la mthode MUMPS",
             TYPE_RESOL      =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("NONSYM","SYMGEN","SYMDEF","AUTO")),
             PRETRAITEMENTS  =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO")),
             POSTTRAITEMENTS =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO","FORCE")),             
             RENUM           =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("AMD","AMF","PORD","METIS","QAMD","SCOTCH","AUTO")),
             ELIM_LAGR2      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
             PCENT_PIVOT     =SIMP(statut='f',typ='I',defaut=10,),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut=1.0E-6,),
             OUT_OF_CORE     =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
             LIBERE_MEMOIRE =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),             
             ),
           b_petsc          =BLOC(condition = "METHODE == 'PETSC' ",fr="Paramtres de la mthode PETSC",
             ALGORITHME      =SIMP(statut='f',typ='TXM',into=("BCGS","BICG","CG","CR","GMRES","TFQMR",),defaut="CG" ),
             PRE_COND        =SIMP(statut='f',typ='TXM',into=("LDLT_INC","JACOBI","SOR","LDLT_SP"),defaut="LDLT_INC" ),
             b_ldlt_inc     =BLOC(condition = "PRE_COND == 'LDLT_INC' ",
               NIVE_REMPLISSAGE = SIMP(statut='f',typ='I',defaut= 0 ),
               REMPLISSAGE      = SIMP(statut='f',typ='R',defaut= 1.0),
               RENUM            =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("SANS","RCMK") ),
             ),
             b_ldlt_sp      =BLOC(condition = "PRE_COND == 'LDLT_SP' ", fr="Paramtres de la factorisation simple prcision",
               REAC_PRECOND        =SIMP(statut='f',typ='I',defaut=30, ),
               RENUM               =SIMP(statut='f',typ='TXM',defaut="SANS",into=("SANS","RCMK") ),
             ),
             b_jacobi_sor   =BLOC(condition = "PRE_COND == 'JACOBI' or PRE_COND == 'SOR'", 
                                                                         fr="Paramtres des prconditionneurs JACOBI et SOR",
               RENUM               =SIMP(statut='f',typ='TXM',defaut="SANS",into=("SANS","RCMK") ),
             ),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
             NMAX_ITER       =SIMP(statut='f',typ='I',defaut= -1 ),
           ),
         ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
def calc_matr_elem_prod(OPTION,**args):
  if OPTION == "RIGI_MECA"        : return matr_elem_depl_r
  if OPTION == "RIGI_FLUI_STRU"   : return matr_elem_depl_r
  if OPTION == "MASS_MECA"        : return matr_elem_depl_r
  if OPTION == "MASS_FLUI_STRU"   : return matr_elem_depl_r
  if OPTION == "RIGI_GEOM"        : return matr_elem_depl_r
  if OPTION == "RIGI_ROTA"        : return matr_elem_depl_r
  if OPTION == "MECA_GYRO"        : return matr_elem_depl_r
  if OPTION == "AMOR_MECA"        : return matr_elem_depl_r
  if OPTION == "IMPE_MECA"        : return matr_elem_depl_r
  if OPTION == "ONDE_FLUI"        : return matr_elem_depl_r
  if OPTION == "AMOR_MECA_ABSO"   : return matr_elem_depl_r
  if OPTION == "RIGI_MECA_HYST"   : return matr_elem_depl_c
  if OPTION == "RIGI_THER"        : return matr_elem_temp_r
  if OPTION == "MASS_THER"        : return matr_elem_temp_r
  if OPTION == "MASS_MECA_DIAG"   : return matr_elem_depl_r
  if OPTION == "RIGI_ACOU"        : return matr_elem_pres_c
  if OPTION == "MASS_ACOU"        : return matr_elem_pres_c
  if OPTION == "AMOR_ACOU"        : return matr_elem_pres_c
  raise AsException("type de concept resultat non prevu")

CALC_MATR_ELEM=OPER(nom="CALC_MATR_ELEM",op=   9,sd_prod=calc_matr_elem_prod
                    ,fr="Calcul des matrices lmentaires",reentrant='n',
            UIinfo={"groupes":("Matrices et vecteurs",)},

         OPTION          =SIMP(statut='o',typ='TXM',
                               into=("RIGI_MECA","MASS_MECA","RIGI_GEOM",
                                     "AMOR_MECA","RIGI_THER","MASS_THER","IMPE_MECA",
                                     "ONDE_FLUI","AMOR_MECA_ABSO","MASS_FLUI_STRU","RIGI_FLUI_STRU",
                                     "RIGI_ROTA","MECA_GYRO","MASS_MECA_DIAG","RIGI_ACOU",
                                     "MASS_ACOU","AMOR_ACOU","RIGI_MECA_HYST") ),
         MODELE            =SIMP(statut='o',typ=modele_sdaster ),

         # mots cls facultatifs que l'on a du mal  mettre dans les blocs
         # sans gener MACRO_MATR_ASSE :
         #------------------------------------------------------------------
         INST=SIMP(statut='f',typ='R',defaut= 0.E+0 ),


         b_rigi_meca = BLOC( condition = "OPTION=='RIGI_MECA'",
           CHAM_MATER      =SIMP(statut='f',typ=cham_mater ),
           CARA_ELEM       =SIMP(statut='f',typ=cara_elem ),
           MODE_FOURIER    =SIMP(statut='f',typ='I',defaut= 0 ),
           CHARGE          =SIMP(statut='f',typ=char_meca,validators=NoRepeat(),max='**' ),
         ),

         b_mass_meca   =BLOC(condition = "(OPTION=='MASS_MECA') or (OPTION=='MASS_MECA_DIAG')",
           CHAM_MATER      =SIMP(statut='f',typ=cham_mater ),
           CARA_ELEM       =SIMP(statut='f',typ=cara_elem ),
           CHARGE          =SIMP(statut='f',typ=char_meca,validators=NoRepeat(),max='**'),
         ),

         b_rigi_geom       =BLOC(condition = "OPTION=='RIGI_GEOM'",
           CARA_ELEM         =SIMP(statut='f',typ=cara_elem ),
           SIEF_ELGA         =SIMP(statut='o',typ=cham_elem ),
           MODE_FOURIER      =SIMP(statut='f',typ='I',defaut= 0 ),
         ),

         b_rigi_rota       =BLOC(condition = "OPTION=='RIGI_ROTA'",
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CHARGE            =SIMP(statut='o',typ=char_meca,validators=NoRepeat(),max='**' ),
         ),

         b_meca_gyro = BLOC( condition = "OPTION=='MECA_GYRO'",
           CHAM_MATER      =SIMP(statut='f',typ=cham_mater ),
           CARA_ELEM       =SIMP(statut='o',typ=cara_elem ),
           CHARGE          =SIMP(statut='f',typ=char_meca,validators=NoRepeat(),max='**' ),
         ),

         b_amor_meca       =BLOC(condition = "OPTION=='AMOR_MECA'",
           regles=(AU_MOINS_UN('CARA_ELEM','RIGI_MECA'),
                   ENSEMBLE('RIGI_MECA','MASS_MECA','CHAM_MATER'), ),
           CARA_ELEM         =SIMP(statut='f',typ=cara_elem ),
           CHAM_MATER        =SIMP(statut='f',typ=cham_mater ),
           RIGI_MECA         =SIMP(statut='f',typ=matr_elem_depl_r ),
           MASS_MECA         =SIMP(statut='f',typ=matr_elem_depl_r ),
           CHARGE            =SIMP(statut='f',typ=char_meca,validators=NoRepeat(),max='**'),
         ),

         b_amor_meca_abso  =BLOC(condition = "OPTION=='AMOR_MECA_ABSO'",
           regles=(AU_MOINS_UN('CARA_ELEM','RIGI_MECA'),
                   ENSEMBLE('RIGI_MECA','MASS_MECA','CHAM_MATER'), ),
           CARA_ELEM         =SIMP(statut='f',typ=cara_elem ),
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           RIGI_MECA         =SIMP(statut='f',typ=matr_elem_depl_r ),
           MASS_MECA         =SIMP(statut='f',typ=matr_elem_depl_r ),
           CHARGE            =SIMP(statut='f',typ=char_meca,validators=NoRepeat(),max='**'),
         ),

         b_rigi_meca_hyst  =BLOC( condition = "OPTION=='RIGI_MECA_HYST'",
           CHARGE            =SIMP(statut='f',typ=char_meca ,validators=NoRepeat(),max='**' ),
           CHAM_MATER        =SIMP(statut='f',typ=cham_mater ),
           CARA_ELEM         =SIMP(statut='f',typ=cara_elem ),
           RIGI_MECA         =SIMP(statut='o',typ=matr_elem_depl_r ),
         ),

         b_rigi_ther       =BLOC(condition = "OPTION=='RIGI_THER'",
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CARA_ELEM         =SIMP(statut='f',typ=cara_elem ),
           MODE_FOURIER      =SIMP(statut='f',typ='I',defaut= 0 ),
           CHARGE            =SIMP(statut='f',typ=char_ther,validators=NoRepeat(),max='**' ),
         ),

         b_mass_ther       =BLOC(condition = "OPTION=='MASS_THER'",
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CARA_ELEM         =SIMP(statut='f',typ=cara_elem ),
           CHARGE            =SIMP(statut='f',typ=char_ther ,validators=NoRepeat(),max='**' ),
         ),

         b_rigi_acou       =BLOC(condition = "OPTION=='RIGI_ACOU'",
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CHARGE            =SIMP(statut='f',typ=char_acou ,validators=NoRepeat(),max='**' ),
         ),

         b_mass_acou       =BLOC(condition = "(OPTION=='MASS_ACOU') or (OPTION=='AMOR_ACOU')",
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CHARGE            =SIMP(statut='f',typ=char_acou ,validators=NoRepeat(),max='**' ),
         ),

         b_rigi_flui       =BLOC(condition = "OPTION=='RIGI_FLUI_STRU'",
           CARA_ELEM         =SIMP(statut='o',typ=cara_elem ),
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CHARGE            =SIMP(statut='o',typ=char_meca ,validators=NoRepeat(),max='**' ),
         ),

         b_mass_flui       =BLOC(condition = "OPTION=='MASS_FLUI_STRU'",
           CARA_ELEM         =SIMP(statut='o',typ=cara_elem ),
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CHARGE            =SIMP(statut='o',typ=char_meca ,validators=NoRepeat(),max='**'),
         ),

         b_impe_meca       =BLOC(condition = "(OPTION=='IMPE_MECA') or (OPTION=='ONDE_FLUI')",
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater ),
           CHARGE            =SIMP(statut='o',typ=char_meca,validators=NoRepeat(),max='**' ),
         ),
)  ;
#& MODIF COMMANDE  DATE 13/01/2011   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE BARGELLINI R.BARGELLINI
CALC_META=OPER(nom="CALC_META",op=194,sd_prod=evol_ther,reentrant='o',
            UIinfo={"groupes":("Post-traitements","Thermique",)},
               fr="Calcule l'volution mtallurgique  partir du rsultat d'un calcul thermique",
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater ),
         RESULTAT        =SIMP(statut='o',typ=evol_ther ),
         ETAT_INIT       =FACT(statut='o',
            regles=(UN_PARMI('EVOL_THER', 'META_INIT_ELNO'),),
            EVOL_THER       =SIMP(statut='f',typ=evol_ther ),
            META_INIT_ELNO  =SIMP(statut='f',typ=carte_sdaster ),
            b_etat     =BLOC(condition="EVOL_THER != None",
               regles=(UN_PARMI('NUME_INIT', 'INST_INIT',),),
               NUME_INIT       =SIMP(statut='f',typ='I'),
               INST_INIT       =SIMP(statut='f',typ='R'),
               b_inst     =BLOC(condition="INST_INIT != None",
                  CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",),),
                  b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                      PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
                  b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                      PRECISION       =SIMP(statut='o',typ='R',),),
               ),
            ),
         ),
         COMP_INCR       =FACT(statut='o',max=1,
           RELATION        =SIMP(statut='o',typ='TXM',into=("ACIER","ZIRC",) ),
           ACIER           =SIMP(statut='c',typ='I',defaut=7,into=(7,) ),
           ZIRC            =SIMP(statut='c',typ='I',defaut=4,into=(4,) ),
      regles=(PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma, validators=NoRepeat(), max='**'),
           MAILLE          =SIMP(statut='f',typ=ma, validators=NoRepeat(), max='**'),
         ),
         OPTION          =SIMP(statut='f',typ='TXM'
                             ,into=("META_ELNO",) ),
)  ;
#& MODIF COMMANDE  DATE 29/03/2011   AUTEUR COURTOIS M.COURTOIS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS

def calc_miss_sdprod(self, TYPE_RESU, **kwargs):
    if TYPE_RESU == 'TABLE':
        return table_sdaster
    elif TYPE_RESU == 'HARM_GENE':
        return harm_gene
    elif TYPE_RESU == 'TRAN_GENE':
        return tran_gene
    else:
        return None

from Macro.calc_miss_ops import calc_miss_ops

CALC_MISS = MACRO(nom="CALC_MISS",
                  op=calc_miss_ops,
                  sd_prod=calc_miss_sdprod,
                  fr="Prparation des donnes, excution du logiciel Miss3D, et post-traitement",
                  UIinfo={"groupes":("Rsolution","Outils-mtier",)},

    TYPE_RESU   = SIMP(statut='o', typ='TXM', into=('HARM_GENE', 'TRAN_GENE', 'TABLE', 'FICHIER'),
                       fr="Type de rsultat produit en post-traitement. FICHIER : pas de post-traitement"),
    PROJET      = SIMP(statut='f', typ='TXM', defaut='MODELE',
                       fr="Nom de l'tude Miss"),
    REPERTOIRE  = SIMP(statut='f', typ='TXM',
                       fr="Rpertoire de travail de Miss"),
    VERSION     = SIMP(statut='f', typ='TXM', into=("V6.6","V6.5"), defaut="V6.6",
                       fr="Version de Miss utilise"),

    TABLE_SOL   = SIMP(statut='o', typ=table_sdaster,
                       fr="Table des proprits du sol"),

    # pas de post-traitement
    b_fichier   = BLOC(condition="TYPE_RESU == 'FICHIER'",
                       regles=(UN_PARMI('MACR_ELEM_DYNA', 'BASE_MODALE'),),
        MACR_ELEM_DYNA  = SIMP(statut='f', typ=macr_elem_dyna,
                               fr="Macro lment produit en amont"),
        BASE_MODALE     = SIMP(statut='f', typ=mode_meca,
                               fr="Base de modes"),
        b_base_modale = BLOC(condition="BASE_MODALE is not None",
            MATR_RIGI       = SIMP(statut='f', typ=(matr_asse_depl_r, matr_asse_depl_c),),
            MATR_MASS       = SIMP(statut='f', typ=matr_asse_depl_r ),
        ),
        AMOR_REDUIT     = SIMP(statut='f', typ='R', max='**'),
        GROUP_MA_INTERF = SIMP(statut='o', typ=grma, max='**',
                               fr="Groupe de mailles de l'interface"),

        UNITE_IMPR_ASTER = SIMP(statut='f', typ='I', defaut=25,
                                fr="Unit des rsultats transmis par Code_Aster  Miss"),
        UNITE_RESU_IMPE  = SIMP(statut='f', typ='I', defaut=38,
                                fr="Unit logique des impdances crites par Miss"),
        UNITE_RESU_FORC  = SIMP(statut='f', typ='I', defaut=28,
                                fr="Unit logique des forces sismiques crites par Miss"),
    ),
    # si post-traitement
    b_donnees   = BLOC(condition="TYPE_RESU != 'FICHIER'",
        MACR_ELEM_DYNA  = SIMP(statut='f', typ=macr_elem_dyna,
                               fr="Macro lment produit en amont"),
        BASE_MODALE     = SIMP(statut='o', typ=mode_meca,
                               fr="Base de modes"),
        MATR_RIGI       = SIMP(statut='o', typ=(matr_asse_depl_r, matr_asse_depl_c),),
        MATR_MASS       = SIMP(statut='o', typ=matr_asse_depl_r ),
        AMOR_REDUIT     = SIMP(statut='o', typ='R', max='**'),
        GROUP_MA_INTERF = SIMP(statut='o', typ=grma, max='**',
                               fr="Groupe de mailles de l'interface"),

        UNITE_IMPR_ASTER = SIMP(statut='f', typ='I',
                                fr="Unit des rsultats transmis par Code_Aster  Miss"),
        UNITE_RESU_IMPE  = SIMP(statut='f', typ='I',
                                fr="Unit logique des impdances  relire."),
        UNITE_RESU_FORC  = SIMP(statut='f', typ='I',
                                fr="Unit logique des forces sismiques  relire"),
    ),
    # Paramtres du calcul Miss
    PARAMETRE   = FACT(statut='o',
                       regles=(PRESENT_PRESENT('OFFSET_MAX', 'OFFSET_NB'),
                               PRESENT_PRESENT('FREQ_MIN', 'FREQ_MAX','FREQ_PAS'),
                               UN_PARMI('FREQ_MIN', 'LIST_FREQ'),
                               PRESENT_PRESENT('SPEC_MAX', 'SPEC_NB'),),
        FREQ_MIN       = SIMP(statut='f', typ='R'),
        FREQ_MAX       = SIMP(statut='f', typ='R'),
        FREQ_PAS       = SIMP(statut='f', typ='R'),
        LIST_FREQ      = SIMP(statut='f', typ='R', max='**'),
        Z0             = SIMP(statut='f', typ='R', defaut=0.),
        SURF           = SIMP(statut='f', typ='TXM', into=("OUI","NON",), defaut="NON"),
        RFIC           = SIMP(statut='f', typ='R', defaut=0.),

        ALGO           = SIMP(statut='f', typ='TXM', into=("DEPL","REGU")),
        DREF           = SIMP(statut='f', typ='R'),
        SPEC_MAX       = SIMP(statut='f', typ='R'),
        SPEC_NB        = SIMP(statut='f', typ='I'),
        OFFSET_MAX     = SIMP(statut='f', typ='R'),
        OFFSET_NB      = SIMP(statut='f', typ='I'),
        TYPE           = SIMP(statut='f', typ='TXM', into=("BINAIRE","ASCII",), defaut="ASCII"),
    ),
    # Post-traitement type 1 - tran_gene
    b_post_tran_gene = BLOC(condition="TYPE_RESU == 'TRAN_GENE'",
                       regles=(AU_MOINS_UN('ACCE_X', 'ACCE_Y', 'ACCE_Z'),),
        MODELE         = SIMP(statut='o', typ=(modele_sdaster),),
        ACCE_X         = SIMP(statut='f', typ=fonction_sdaster,),
        ACCE_Y         = SIMP(statut='f', typ=fonction_sdaster,),
        ACCE_Z         = SIMP(statut='f', typ=fonction_sdaster,),
        INST_FIN       = SIMP(statut='o', typ='R', fr="Instant final du calcul"),
        PAS_INST       = SIMP(statut='o', typ='R', fr="Pas de temps du calcul"),
    ),
    # Post-traitement type 1 - harm_gene
    b_post_harm_gene  = BLOC(condition="TYPE_RESU == 'HARM_GENE'",
                       regles=(AU_MOINS_UN('EXCIT_HARMO', 'ACCE_X', 'ACCE_Y', 'ACCE_Z'),
                               PRESENT_ABSENT('EXCIT_HARMO', 'ACCE_X', 'ACCE_Y', 'ACCE_Z', 'INST_FIN'),
                               ENSEMBLE('INST_FIN', 'PAS_INST'),),
        MODELE         = SIMP(statut='o', typ=(modele_sdaster),),
        ACCE_X         = SIMP(statut='f', typ=fonction_sdaster,),
        ACCE_Y         = SIMP(statut='f', typ=fonction_sdaster,),
        ACCE_Z         = SIMP(statut='f', typ=fonction_sdaster,),
        INST_FIN       = SIMP(statut='f', typ='R', fr="Instant final du calcul"),
        PAS_INST       = SIMP(statut='f', typ='R', fr="Pas de temps du calcul"),
        # identique  EXCIT de DYNA_LINE_HARM au type attendu pour VECT_ASSE prs
        EXCIT_HARMO    = FACT(statut='f', max='**',
                              regles=(UN_PARMI('VECT_ASSE', 'CHARGE'),
                                      UN_PARMI('FONC_MULT', 'FONC_MULT_C', 'COEF_MULT', 'COEF_MULT_C'),),
            VECT_ASSE     = SIMP(statut='f', typ=cham_no_sdaster,),
            CHARGE        = SIMP(statut='f', typ=char_meca),
            TYPE_CHARGE   = SIMP(statut='f', typ='TXM', defaut="FIXE", into=("FIXE",),),
            FONC_MULT_C   = SIMP(statut='f', typ=(fonction_c, formule_c),),
            COEF_MULT_C   = SIMP(statut='f', typ='C'),
            FONC_MULT     = SIMP(statut='f', typ=(fonction_sdaster, nappe_sdaster, formule) ),
            COEF_MULT     = SIMP(statut='f', typ='R'),
            PHAS_DEG      = SIMP(statut='f', typ='R', defaut=0.),
            PUIS_PULS     = SIMP(statut='f', typ='I', defaut=0),
        ),
    ),
    # Post-traitement type 2
    b_post_table = BLOC(condition="TYPE_RESU == 'TABLE'",
                        regles=(AU_MOINS_UN('ACCE_X', 'ACCE_Y', 'ACCE_Z'),),
        MODELE         = SIMP(statut='o', typ=(modele_sdaster),),
        GROUP_NO       = SIMP(statut='o', typ=grno, max='**',
                              fr="Liste des groupes de noeud de post-traitement"),
        ACCE_X         = SIMP(statut='f', typ=fonction_sdaster,),
        ACCE_Y         = SIMP(statut='f', typ=fonction_sdaster,),
        ACCE_Z         = SIMP(statut='f', typ=fonction_sdaster,),
        INST_FIN       = SIMP(statut='o', typ='R', fr="Instant final du calcul"),
        PAS_INST       = SIMP(statut='o', typ='R', fr="Pas de temps du calcul"),
        NORME          = SIMP(statut='o', typ='R',
                              fr="Valeur de la norme du spectre d'oscillateur" ),
        AMOR_SPEC_OSCI = SIMP(statut='o', typ='R', max='**',
                              fr="Amortissement du spectre d'oscillateur"),
        LIST_FREQ      = SIMP(statut='f', typ=listr8_sdaster,
                              fr="Frquences utilises pour le calcul du spectre d'oscillateur"),
    ),

    INFO        = SIMP(statut='f', typ='I', defaut=1, into=(1,2)),
)

#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2008  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE NISTOR I.NISTOR

from Macro.calc_modal_ops import calc_modal_ops

def calc_modal_prod(self,AMORTISSEMENT,**args):
  if AMORTISSEMENT=="NON": return mode_meca
  if AMORTISSEMENT=="OUI": return mode_meca_c
  raise AsException("type de concept resultat non prevu")


CALC_MODAL=MACRO(nom="CALC_MODAL",op=calc_modal_ops,
            UIinfo={"groupes":("Rsolution","Dynamique",)},
                      sd_prod=calc_modal_prod,
                    fr="Calcul des modes propres reels ou complexes dans une seule commande",
         MODELE          =SIMP(statut='o',typ=modele_sdaster),
         AMORTISSEMENT    =SIMP(statut='f',typ='TXM',into=("OUI","NON"),defaut="NON" ),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater),
         INST            =SIMP(statut='f',typ='R',defaut=0.),
         CARA_ELEM       =SIMP(statut='f',typ=cara_elem),
         CHARGE          =SIMP(statut='f',typ=char_meca,validators=NoRepeat(),max='**'),
         METHODE         =SIMP(statut='f',typ='TXM',defaut="SORENSEN",
                               into=("TRI_DIAG","JACOBI","SORENSEN","QZ") ),
         b_tri_diag =BLOC(condition = "METHODE == 'TRI_DIAG'",
           PREC_ORTHO      =SIMP(statut='f',typ='R',defaut= 1.E-12,val_min=0.E+0 ),
           NMAX_ITER_ORTHO =SIMP(statut='f',typ='I',defaut= 5,val_min=0 ),
           PREC_LANCZOS    =SIMP(statut='f',typ='R',defaut= 1.E-8,val_min=0.E+0 ),
           NMAX_ITER_QR    =SIMP(statut='f',typ='I',defaut= 30,val_min=0 ),
         ),
         b_jacobi =BLOC(condition = "METHODE == 'JACOBI'",
           PREC_BATHE      =SIMP(statut='f',typ='R',defaut= 1.E-10,val_min=0.E+0 ),
           NMAX_ITER_BATHE =SIMP(statut='f',typ='I',defaut= 40,val_min=0 ),
           PREC_JACOBI     =SIMP(statut='f',typ='R',defaut= 1.E-2,val_min=0.E+0 ),
           NMAX_ITER_JACOBI=SIMP(statut='f',typ='I',defaut= 12,val_min=0 ),
         ),
         b_sorensen =BLOC(condition = "METHODE == 'SORENSEN'",
           PREC_SOREN      =SIMP(statut='f',typ='R',defaut= 0.E+0,val_min=0.E+0 ),
           NMAX_ITER_SOREN =SIMP(statut='f',typ='I',defaut= 20,val_min=0 ),
           PARA_ORTHO_SOREN=SIMP(statut='f',typ='R',defaut= 0.717,val_min=0.E+0 ),
         ),
         b_qz =BLOC(condition = "METHODE == 'QZ'",
           TYPE_QZ      =SIMP(statut='f',typ='TXM',defaut="QZ_SIMPLE",into=("QZ_QR","QZ_SIMPLE","QZ_EQUI") ),
         ),
         MODE_RIGIDE          =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON"),
                               fr="Calcul des modes de corps rigide, uniquement pour la mthode TRI_DIAG" ),
         CALC_FREQ       =FACT(statut='d',min=0,
             OPTION      =SIMP(statut='f',typ='TXM',defaut="PLUS_PETITE",into=("PLUS_PETITE","BANDE","CENTRE","TOUT"),
                                   fr="Choix de l option et par consquent du shift du problme modal" ),
             b_plus_petite =BLOC(condition = "OPTION == 'PLUS_PETITE'",fr="Recherche des plus petites valeurs propres",
               NMAX_FREQ       =SIMP(statut='f',typ='I',defaut= 10,val_min=0 ),
             ),
             b_centre       =BLOC(condition = "OPTION == 'CENTRE'",
                                  fr="Recherche des valeurs propres les plus proches d une valeur donne",
               FREQ            =SIMP(statut='o',typ='R',
                                     fr="Frquence autour de laquelle on cherche les frquences propres"),
               AMOR_REDUIT     =SIMP(statut='f',typ='R',),
               NMAX_FREQ       =SIMP(statut='f',typ='I',defaut= 10,val_min=0 ),
             ),
             b_bande         =BLOC(condition = "(OPTION == 'BANDE')",
                                   fr="Recherche des valeurs propres dans une bande donne",
               FREQ            =SIMP(statut='o',typ='R',min=2,validators=NoRepeat(),max=2,
                                     fr="Valeur des deux frquences dlimitant la bande de recherche"),
             ),
             APPROCHE        =SIMP(statut='f',typ='TXM',defaut="REEL",into=("REEL","IMAG","COMPLEXE"),
                                   fr="Choix du pseudo-produit scalaire pour la rsolution du problme quadratique" ),
             regles=(EXCLUS('DIM_SOUS_ESPACE','COEF_DIM_ESPACE'),),
             DIM_SOUS_ESPACE =SIMP(statut='f',typ='I' ),
             COEF_DIM_ESPACE =SIMP(statut='f',typ='I' ),
             NMAX_ITER_SHIFT =SIMP(statut='f',typ='I',defaut= 5,val_min=0 ),
             PREC_SHIFT      =SIMP(statut='f',typ='R',defaut= 5.E-2,val_min=0.E+0 ),
             SEUIL_FREQ      =SIMP(statut='f',typ='R',defaut= 1.E-2,val_min=0.E+0 ),
             STOP_FREQ_VIDE  =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           ),

        VERI_MODE       =FACT(statut='d',min=0,
           STOP_ERREUR     =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           PREC_SHIFT      =SIMP(statut='f',typ='R',defaut= 5.E-3,val_min=0.E+0 ),
           SEUIL           =SIMP(statut='f',typ='R',defaut= 1.E-6,val_min=0.E+0,
                                 fr="Valeur limite admise pour l ereur a posteriori des modes" ),
           STURM           =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         ),

         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2)),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2009  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE TORKHANI M.TORKHANI

from Macro.calc_mode_rotation_ops import calc_mode_rotation_ops

CALC_MODE_ROTATION=MACRO(nom="CALC_MODE_ROTATION",op=calc_mode_rotation_ops,sd_prod=table_container,
                  reentrant='n',fr="calculer les frquences et modes d'un systme en fonction des vitesses de rotation",
                  UIinfo={"groupes":("Rsolution","Dynamique",)},

                  MATR_A          =SIMP(statut='o',typ=matr_asse_depl_r ),
                  MATR_B          =SIMP(statut='o',typ=matr_asse_depl_r ),
                  MATR_AMOR       =SIMP(statut='f',typ=matr_asse_depl_r ),
                  MATR_GYRO       =SIMP(statut='f',typ=matr_asse_depl_r ),
                  VITE_ROTA       =SIMP(statut='f',typ='R',max='**'),

                  METHODE         =SIMP(statut='f',typ='TXM',defaut="QZ",
                                        into=("QZ","SORENSEN",) ),

                  CALC_FREQ       =FACT(statut='d',min=0,
                         OPTION      =SIMP(statut='f',typ='TXM',defaut="PLUS_PETITE",into=("PLUS_PETITE","CENTRE",),
                                           fr="Choix de l option et par consquent du shift du problme modal" ),
                  b_plus_petite =BLOC(condition = "OPTION == 'PLUS_PETITE'",fr="Recherche des plus petites valeurs propres",
                              NMAX_FREQ       =SIMP(statut='f',typ='I',defaut= 10,val_min=0 ),
                              ),
                  b_centre       =BLOC(condition = "OPTION == 'CENTRE'",
                                fr="Recherche des valeurs propres les plus proches d une valeur donne",
                              FREQ            =SIMP(statut='o',typ='R',
                                                     fr="Frquence autour de laquelle on cherche les frquences propres"),
                              AMOR_REDUIT     =SIMP(statut='f',typ='R',),
                              NMAX_FREQ       =SIMP(statut='f',typ='I',defaut= 10,val_min=0 ),
                              ),
                             ),

                  VERI_MODE       =FACT(statut='d',min=0,
                  STOP_ERREUR     =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
                  SEUIL           =SIMP(statut='f',typ='R',defaut= 1.E-6 ),
                  PREC_SHIFT      =SIMP(statut='f',typ='R',defaut= 5.E-3 ),
                  STURM           =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),),
);
#& MODIF COMMANDE  DATE 02/02/2011   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
def calc_no_prod(RESULTAT,**args):
   if AsType(RESULTAT) != None : return AsType(RESULTAT)
   raise AsException("type de concept resultat non prevu")

CALC_NO=OPER(nom="CALC_NO",op= 106,sd_prod=calc_no_prod,reentrant='f',
            fr="Enrichir une SD Rsultat par des champs aux noeuds calculs  partir de champs aux lments valus aux noeuds",
            UIinfo={"groupes":("Post-traitements","Rsultats et champs",)},
         RESULTAT        =SIMP(statut='o',typ=resultat_sdaster),

         regles=(EXCLUS('TOUT_ORDRE','NUME_ORDRE','INST','FREQ','NUME_MODE',
                        'NOEUD_CMP','LIST_INST','LIST_FREQ','LIST_ORDRE','NOM_CAS'),
                 ),
         TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
         NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
         NUME_MODE       =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
         NOEUD_CMP       =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**'),
         NOM_CAS         =SIMP(statut='f',typ='TXM' ),
         INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
         FREQ            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
         LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
         LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster),
         LIST_ORDRE      =SIMP(statut='f',typ=listis_sdaster),
         CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",),),
         b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
         b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
             PRECISION       =SIMP(statut='o',typ='R',),),
         OPTION          =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                               into=("FORC_NODA","REAC_NODA",
                                     "DERA_NOEU",
                                     "DURT_NOEU",
                                     "EFCA_NOEU","EFGE_NOEU",
                                     "ENDO_NOEU",
                                     "ENEL_NOEU",
                                     "EPMG_NOEU",
                                     "EPSG_NOEU",
                                     "EPSI_NOEU",
                                     "EPSP_NOEU"     ,
                                     "EPVC_NOEU","EPFD_NOEU","EPFP_NOEU","EPFP_NOEU",
                                     "EPMQ_NOEU","EPEQ_NOEU","SIEQ_NOEU",
                                     "ERME_NOEU","ERTH_NOEU","QIRE_NOEU",
                                     "FLUX_NOEU",
                                     "HYDR_NOEU",
                                     "INTE_NOEU",
                                     "META_NOEU",
                                     "PMPB_NOEU",
                                     "PRAC_NOEU",
                                     "SIEF_NOEU",
                                     "SICA_NOEU","SICO_NOEU","SIGM_NOEU",
                                     "SIPO_NOEU",
                                     "VAEX_NOEU","VARI_NOEU","DISS_NOEU",) ),


         MODELE          =SIMP(statut='f',typ=modele_sdaster),
         CHAM_MATER      =SIMP(statut='f',typ=cham_mater),
         CARA_ELEM       =SIMP(statut='f',typ=cara_elem),
         EXCIT           =FACT(statut='f',max='**',
           CHARGE          =SIMP(statut='f',typ=(char_meca,char_ther,char_acou,char_cine_meca) ),
           FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE_CSTE",
                                 into=("FIXE_CSTE","FIXE_PILO","SUIV") ),
         ),

         TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
         GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
         MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),

)  ;
#& MODIF COMMANDE  DATE 07/12/2010   AUTEUR GENIAUT S.GENIAUT 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2010  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PROIX J-M.PROIX
CALC_POINT_MAT=OPER(nom="CALC_POINT_MAT",op=33,sd_prod=table_sdaster,reentrant='f',
            UIinfo={"groupes":("Rsolution",)},
            fr="Intgrer une loi de comportement",
     MATER           =SIMP(statut='o',typ=mater_sdaster,max=1),
     COMP_INCR       =C_COMP_INCR(),
     COMP_ELAS       =C_COMP_ELAS('CALC_POINT_MAT'),
     INCREMENT       =C_INCREMENT(),
     NEWTON          =C_NEWTON(),
     CONVERGENCE     =C_CONVERGENCE(),

    # --MASSIF : orientation du materiau (monocristal, orthotropie)
     MASSIF          =FACT(statut='f',max='**',
                    regles=(UN_PARMI('ANGL_REP','ANGL_EULER'),),
         ANGL_REP        =SIMP(statut='f',typ='R',min=1,max=3),
         ANGL_EULER      =SIMP(statut='f',typ='R',min=1,max=3),
      ),
    ## ANGLE : rotation de ANGLE autour de Z uniquement, et seulement pour les dformations imposes.
     ANGLE      =SIMP(statut='f',typ='R',max=1, defaut=0.),
     INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2)),

     regles=(UN_PARMI('SIXX','EPXX'),UN_PARMI('SIYY','EPYY'),UN_PARMI('SIZZ','EPZZ'),
             UN_PARMI('SIXY','EPXY'),UN_PARMI('SIXZ','EPXZ'),UN_PARMI('SIYZ','EPYZ'),),
     SIXX = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
     SIYY = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
     SIZZ = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
     SIXY = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
     SIXZ = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
     SIYZ = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
     EPXX = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
     EPYY = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
     EPZZ = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
     EPXY = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
     EPXZ = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
     EPYZ = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),

     SIGM_INIT=FACT(statut='f',
            SIXX = SIMP(statut='f',typ='R',max=1,defaut=0.0E+0),
            SIYY = SIMP(statut='f',typ='R',max=1,defaut=0.0E+0),
            SIZZ = SIMP(statut='f',typ='R',max=1,defaut=0.0E+0),
            SIXY = SIMP(statut='f',typ='R',max=1,defaut=0.0E+0),
            SIXZ = SIMP(statut='f',typ='R',max=1,defaut=0.0E+0),
            SIYZ = SIMP(statut='f',typ='R',max=1,defaut=0.0E+0),
                       ),
     EPSI_INIT=FACT(statut='f',
            EPXX = SIMP(statut='o',typ='R',max=1),
            EPYY = SIMP(statut='o',typ='R',max=1),
            EPZZ = SIMP(statut='o',typ='R',max=1),
            EPXY = SIMP(statut='o',typ='R',max=1),
            EPXZ = SIMP(statut='o',typ='R',max=1),
            EPYZ = SIMP(statut='o',typ='R',max=1),
                       ),
     VARI_INIT=FACT(statut='f',
            VALE = SIMP(statut='o',typ='R',max='**'),
                       ),
     MATR_C1=FACT(statut='f',max='**',
           VALE          =SIMP(statut='o',typ='R',max=1, ),
           NUME_LIGNE    =SIMP(statut='o',typ='I',max=1,val_min=1,val_max=6 ),
           NUME_COLONNE  =SIMP(statut='o',typ='I',max=1,val_min=1,val_max=12 ),
                              ),
     MATR_C2=FACT(statut='f',max='**',
           VALE          =SIMP(statut='o',typ='R',max=1, ),
           NUME_LIGNE    =SIMP(statut='o',typ='I',max=1,val_min=1,val_max=6 ),
           NUME_COLONNE  =SIMP(statut='o',typ='I',max=1,val_min=1,val_max=12 ),
                              ),
     VECT_IMPO=FACT(statut='f',max='**',
           VALE          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule),max=1, ),
           NUME_LIGNE    =SIMP(statut='o',typ='I',max=1,val_min=1,val_max=6 ),
                              ),
      NB_VARI_TABLE  =SIMP(statut='f',typ='I',max=1,),

      ARCHIVAGE       =FACT(statut='f',
       LIST_INST       =SIMP(statut='f',typ=(listr8_sdaster) ),
       INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**' ),
       PAS_ARCH        =SIMP(statut='f',typ='I' ),
       PRECISION       =SIMP(statut='f',typ='R',defaut= 1.0E-6),
                           ),
     );

#& MODIF COMMANDE  DATE 28/02/2011   AUTEUR BARGELLI R.BARGELLINI 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE MICHEL S.MICHEL

from Macro.calc_precont_ops import calc_precont_ops


# ===========================================================================
#           CATALOGUE DE LA MACRO "CALC_PRECONT"
#           -----------------------------------------
# USAGE :
#
#
# ===========================================================================

CALC_PRECONT=MACRO(nom="CALC_PRECONT",op=calc_precont_ops,sd_prod=evol_noli,
                   fr="Imposer la tension dfinie par le BPEL dans les cables",
                   reentrant='f',UIinfo={"groupes":("Modlisation",)},
         reuse =SIMP(statut='f',typ='evol_noli'),
         MODELE           =SIMP(statut='o',typ=modele_sdaster),
         CHAM_MATER       =SIMP(statut='o',typ=cham_mater),
         CARA_ELEM        =SIMP(statut='o',typ=cara_elem),
         CABLE_BP         =SIMP(statut='o',typ=cabl_precont,validators=NoRepeat(),max='**'),
         CABLE_BP_INACTIF =SIMP(statut='f',typ=cabl_precont,validators=NoRepeat(),max='**'),
         INCREMENT        =C_INCREMENT(),
         RECH_LINEAIRE    =C_RECH_LINEAIRE(),
         CONVERGENCE      =C_CONVERGENCE(),
          ETAT_INIT       =FACT(statut='f',
            regles=(AU_MOINS_UN('EVOL_NOLI','DEPL','SIGM','VARI',),
                    EXCLUS('EVOL_NOLI','DEPL',),
                    EXCLUS('EVOL_NOLI','SIGM',),
                    EXCLUS('EVOL_NOLI','VARI',),
                    EXCLUS('NUME_ORDRE','INST'), ),
            DEPL            =SIMP(statut='f',typ=cham_no_sdaster),
            SIGM            =SIMP(statut='f',typ=(carte_sdaster,cham_elem)),
            VARI            =SIMP(statut='f',typ=cham_elem),
            EVOL_NOLI       =SIMP(statut='f',typ=evol_noli),
            NUME_ORDRE      =SIMP(statut='f',typ='I'),
            INST            =SIMP(statut='f',typ='R'),
            CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
            b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
            b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                PRECISION       =SIMP(statut='o',typ='R',),),
            NUME_DIDI       =SIMP(statut='f',typ='I'),
            INST_ETAT_INIT  =SIMP(statut='f',typ='R'),
          ),
         METHODE = SIMP(statut='d',typ='TXM',defaut="NEWTON",into=("NEWTON","IMPL_EX")),
         b_meth_newton = BLOC(condition = "METHODE == 'NEWTON'",
                           NEWTON = C_NEWTON(),
                        ),
         b_meth_impl_ex = BLOC(condition = "METHODE == 'IMPL_EX'",
                           IMPL_EX = C_IMPL_EX(),
                        ),
          SOLVEUR         =C_SOLVEUR(),
          INFO            =SIMP(statut='f',typ='I',into=(1,2) ),
          TITRE           =SIMP(statut='f',typ='TXM',max='**' ),

          EXCIT           =FACT(statut='o',max='**',
            CHARGE          =SIMP(statut='o',typ=char_meca),
          ),

         COMP_INCR       =C_COMP_INCR(),
  )  ;
#& MODIF COMMANDE  DATE 02/02/2011   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# ======================================================================
# RESPONSABLE GNICOLAS
def calc_sensi_prod(RESULTAT,**args):
   if AsType(RESULTAT) != None : return AsType(RESULTAT)
   raise AsException("type de concept resultat non prevu")

CALC_SENSI=OPER(nom="CALC_SENSI",op=132,sd_prod=calc_sensi_prod,reentrant='f',
            UIinfo={"groupes":("Post-traitements","Rsultats et champs",)},
            fr="Complter ou crer un rsultat en calculant des champs drivs )",
     MODELE          =SIMP(statut='f',typ=modele_sdaster),
     CHAM_MATER      =SIMP(statut='f',typ=cham_mater),
     CARA_ELEM       =SIMP(statut='f',typ=cara_elem),

     RESULTAT        =SIMP(statut='o',typ=resultat_sdaster,
                                      fr="Rsultat d'une commande globale"),

     regles=(EXCLUS('TOUT_ORDRE','NUME_ORDRE','INST','FREQ','NUME_MODE',
                    'NOEUD_CMP','LIST_INST','LIST_FREQ','LIST_ORDRE','NOM_CAS'),
             CONCEPT_SENSIBLE("SEPARE"),
             DERIVABLE('RESULTAT'),),
     TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
     NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
     NUME_MODE       =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
     NOEUD_CMP       =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**'),
     NOM_CAS         =SIMP(statut='f',typ='TXM' ),
     INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
     FREQ            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
     LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
     LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster),
     CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",) ),
     b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
         PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6),),
     b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
         PRECISION       =SIMP(statut='o',typ='R'),),
     LIST_ORDRE      =SIMP(statut='f',typ=listis_sdaster),
     TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
     GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**',
                           fr="le calcul ne sera effectu que sur ces mailles l"),
     MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**',
                           fr="le calcul ne sera effectu que sur ces mailles l"),

     OPTION =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',

                  into=('DEDE_ELNO','DEDE_NOEU','DESI_ELNO',
                  'DESI_NOEU','DETE_ELNO','DETE_NOEU',
                  'EFGE_ELNO','EPSI_ELGA','EPSI_ELNO',
                  'EPSP_ELNO','FLUX_ELNO','FLUX_NOEU','REAC_NODA','SIEF_ELGA',
                  'SIEF_ELNO','SIEF_NOEU',
                  'SIGM_ELNO','SIGM_NOEU',
                  'SIPO_ELNO','VARI_ELNO'),
            ),


   # -- mots cles inutiles mais qui permettent de reutiliser certaines routines :
     EXCIT =FACT(statut='f',max='**', CHARGE=SIMP(statut='o',typ=(char_meca,) ),),
     NORME =SIMP(statut='f',typ='TXM',defaut="XXXX", into=("XXXX",),),


     SENSIBILITE     =SIMP(statut='f',typ=(para_sensi,theta_geom),validators=NoRepeat(),max='**',
                           fr="Liste des paramtres de sensibilit.",
                           ang="List of sensitivity parameters"),
     INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
     TITRE           =SIMP(statut='f',typ='TXM',max='**'),
) ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2008  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================

# RESPONSABLE CORUS M.CORUS

from Macro.calc_spec_ops import calc_spec_ops

CALC_SPEC=MACRO(nom="CALC_SPEC",op= calc_spec_ops,sd_prod=table_fonction,
                     reentrant='n',
                     fr="Calcule une matrice interspectrale ou des fonctions de transferts",
                     UIinfo={"groupes":("Fonctions",)},
         TAB_ECHANT      =FACT(statut='f',
           NOM_TAB         =SIMP(statut='o',typ=table_sdaster),
           LONGUEUR_ECH    =FACT(statut='f',
             DUREE           =SIMP(statut='f',typ='R'),
             POURCENT        =SIMP(statut='f',typ='R'),
             NB_PTS          =SIMP(statut='f',typ='I'),
                              ),
           RECOUVREMENT  =FACT(statut='f',
             DUREE           =SIMP(statut='f',typ='R'),
             POURCENT        =SIMP(statut='f',typ='R'),
             NB_PTS          =SIMP(statut='f',typ='I'),
                                ),
                              ),
         ECHANT          =FACT(statut='f',max='**',
           NUME_ORDRE_I    =SIMP(statut='o',typ='I' ),
           NUME_MES        =SIMP(statut='o',typ='I' ),
           FONCTION        =SIMP(statut='o',typ=fonction_sdaster),
                              ),
#-- Cas de la matrice interspectrale --#
         INTERSPE        =FACT(statut='f',
           FENETRE         =SIMP(statut='f',typ='TXM',defaut="RECT",into=("RECT","HAMM","HANN","EXPO","PART",)),
           BLOC_DEFI_FENE  =BLOC(condition = "FENETRE == 'EXPO' or FENETRE == 'PART' ",
             DEFI_FENE       =SIMP(statut='f',typ='R',max='**'),
                                 ),
                              ),
#-- Cas des transferts - estimateurs H1 / H2 / Hv + Coherence --#
         TRANSFERT       =FACT(statut='f',
           ESTIM           =SIMP(statut='f',typ='TXM',defaut="H1",into=("H1","H2","CO",)),
           REFER           =SIMP(statut='o',typ='I',max='**'),
           FENETRE         =SIMP(statut='f',typ='TXM',defaut="RECT",into=("RECT","HAMM","HANN","EXPO","PART",)),
#           DEFI_FENE       =SIMP(statut='f',typ='R',max='**'),
           BLOC_DEFI_FENE  =BLOC(condition = "FENETRE == 'EXPO' or FENETRE == 'PART' ",
             DEFI_FENE       =SIMP(statut='f',typ='R',max='**'),
                                 ),
                              ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
);
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2005  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# -*- coding: iso-8859-1 -*-
# RESPONSABLE COURTOIS M.COURTOIS

def calc_table_prod(self, TABLE, ACTION, **kargs):
   """Typage du concept produit.
   """
   l_typ = [AsType(TABLE),]
   for mcf in ACTION:
      dmc = mcf.cree_dict_valeurs(mcf.mc_liste)
      if dmc.get('TABLE') != None:
         l_typ.append(AsType(dmc['TABLE']))
   # une table_fonction tant une table
   if table_fonction in l_typ:
      return table_fonction
   else:
      return table_sdaster


from Macro.calc_table_ops import calc_table_ops

CALC_TABLE=MACRO(nom="CALC_TABLE",op=calc_table_ops, sd_prod=calc_table_prod,
                 fr="Oprations sur une table",
                 UIinfo={"groupes":("Tables",)},
                 reentrant='f',
   regles=(DERIVABLE('TABLE'),),
   TABLE  = SIMP(statut='o',typ=table_sdaster),
   ACTION = FACT(statut='o', max='**',
                    fr = "Suite des oprations  effectuer sur la table",
      OPERATION = SIMP(statut='o', typ='TXM',
                  into=('FILTRE', 'EXTR', 'RENOMME', 'TRI', 'COMB', 'AJOUT', 'OPER', 'SUPPRIME')),

      b_filtre = BLOC(condition="OPERATION == 'FILTRE'",
                      fr="Slectionne les lignes de la table vrifiant un critre",
         NOM_PARA  = SIMP(statut='o',typ='TXM'),
         CRIT_COMP = SIMP(statut='f',typ='TXM',defaut="EQ",
                          into=('EQ','NE','GT','LT','GE','LE','REGEXP',
                                'VIDE','NON_VIDE','MAXI','ABS_MAXI','MINI','ABS_MINI'),),
         b_vale = BLOC(condition = "(CRIT_COMP in ('EQ','NE','GT','LT','GE','LE'))",
            regles=(UN_PARMI('VALE','VALE_I','VALE_K','VALE_C',),),
            VALE   = SIMP(statut='f',typ='R',max='**'),
            VALE_I = SIMP(statut='f',typ='I',max='**'),
            VALE_C = SIMP(statut='f',typ='C',max='**'),
            VALE_K = SIMP(statut='f',typ='TXM',max='**'),
         ),
         b_regexp = BLOC(condition = "CRIT_COMP == 'REGEXP'",
            VALE_K = SIMP(statut='o',typ='TXM',max='**'),
         ),
         b_crit = BLOC(condition = "CRIT_COMP in ('EQ','NE')",
            CRITERE   = SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
            PRECISION = SIMP(statut='f',typ='R',defaut= 1.0E-3 ),
         ),
      ),

      b_extr = BLOC(condition="OPERATION ==  'EXTR'",
                    fr="Extrait une ou plusieurs colonnes de la table",
         NOM_PARA = SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                         fr="Noms des colonnes  extraire"),
      ),

      b_suppr = BLOC(condition="OPERATION ==  'SUPPRIME'",
                    fr="Supprime une ou plusieurs colonnes de la table",
         NOM_PARA = SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',
                         fr="Noms des colonnes  supprimer"),
      ),

      b_renomme = BLOC(condition="OPERATION == 'RENOMME'",
                       fr="Renomme un ou plusieurs paramtres de la table",
         NOM_PARA = SIMP(statut='o', typ='TXM', validators=NoRepeat(), min=2, max=2,
                         fr="Couple (ancien nom du paramtre, nouveau nom du paramtre)",),
      ),

      b_tri = BLOC(condition="OPERATION == 'TRI'",
                   fr="Ordonne les lignes de la table selon les valeurs d'un ou plusieurs paramtres",
         NOM_PARA = SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**'),
         ORDRE    = SIMP(statut='f',typ='TXM',defaut="CROISSANT",
                         into=("CROISSANT","DECROISSANT") ),
      ),

      b_comb = BLOC(condition="OPERATION == 'COMB'",
                    fr="Combine deux tables ayant ventuellement des paramtres communs",
         TABLE    = SIMP(statut='o',typ=table_sdaster,
                         fr="Table dont les colonnes vont venir surcharger la table initiale"),
         NOM_PARA = SIMP(statut='f',typ='TXM',max='**',
                         fr="Noms des paramtres dont les valeurs doivent etre identiques dans les deux tables "\
                            "pour que les colonnes soient combines"),
         RESTREINT = SIMP(statut='f', typ='TXM', into=('OUI', 'NON'), defaut='NON',
                          fr="Restreint la fusion uniquement aux lignes o les NOM_PARA sont communs"),
      ),

      b_append = BLOC(condition="OPERATION == 'AJOUT'",
                    fr="Ajoute une ligne  la table initiale",
         NOM_PARA = SIMP(statut='o',typ='TXM',max='**',
                         fr="Noms des paramtres dont les valeurs sont fournies sous VALE"),
         VALE     = SIMP(statut='o',typ=assd,max='**', fr='Valeurs des paramtres'),
      ),

      b_oper = BLOC(condition="OPERATION == 'OPER'",
                    fr="Applique une formule dans laquelle les variables sont les paramtres de la table",
         FORMULE  = SIMP(statut='o',typ=formule,
                         fr="Formule  appliquer aux colonnes de la table"),
         NOM_PARA = SIMP(statut='o',typ='TXM',
                         fr="Nom de la nouvelle colonne"),
      ),
   ),

   SENSIBILITE = SIMP(statut='f',typ=(para_sensi,theta_geom),max=1,
                      fr="Paramtre de sensibilit",
                      ang="Sensitivity parameter"),
   TITRE = SIMP(statut='f',typ='TXM',max='**',
                fr="Titre de la table produite"),
   INFO  = SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
)
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE GALENNE E.GALENNE
CALC_THETA=OPER(nom="CALC_THETA",op=54,sd_prod=theta_geom,reentrant='n',
            UIinfo={"groupes":("Post-traitements","Rupture",)},
                fr="Dfinir un champ theta pour le calcul du taux de restitution d'nergie"
                    +" ou des facteurs d'intensit de contraintes",
         regles=(UN_PARMI('THETA_2D','THETA_3D','THETA_BANDE'),
                 PRESENT_ABSENT('THETA_2D','DIRE_THETA'),
                 EXCLUS('DIRECTION','DIRE_THETA'),),
         OPTION          =SIMP(statut='f',typ='TXM',defaut="COURONNE",into=("COURONNE","BANDE") ),
         MODELE          =SIMP(statut='o',typ=(modele_sdaster) ),
         THETA_3D        =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','GROUP_NO','NOEUD'),
                   UN_PARMI('MODULE','MODULE_FO'),
                   ENSEMBLE('MODULE','R_INF','R_SUP'),
                   ENSEMBLE('MODULE_FO','R_INF_FO','R_SUP_FO'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           MODULE          =SIMP(statut='f',typ='R'),
           R_INF           =SIMP(statut='f',typ='R'),
           R_SUP           =SIMP(statut='f',typ='R'),
           MODULE_FO       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           R_INF_FO        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           R_SUP_FO        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                         ),
         b_theta_3d     =BLOC(condition="THETA_3D != None",
           FOND_FISS       =SIMP(statut='o',typ=fond_fiss),),
         DIRE_THETA      =SIMP(statut='f',typ=cham_no_sdaster ),
         DIRECTION       =SIMP(statut='f',typ='R',max='**'),
         THETA_2D        =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_NO','NOEUD'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           MODULE          =SIMP(statut='o',typ='R'),
           R_INF           =SIMP(statut='o',typ='R'),
           R_SUP           =SIMP(statut='o',typ='R'),
         ),
         THETA_BANDE     =FACT(statut='f',max='**',
           MODULE          =SIMP(statut='o',typ='R'),
           R_INF           =SIMP(statut='o',typ='R'),
           R_SUP           =SIMP(statut='o',typ='R'),
         ),
         GRAD_NOEU_THETA =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         IMPRESSION      =FACT(statut='f',
           UNITE           =SIMP(statut='f',typ='I',defaut=8),
           FORMAT          =SIMP(statut='f',typ='TXM',defaut="EXCEL",into=("EXCEL","AGRAF") ),
         ),
)  ;
#& MODIF COMMANDE  DATE 07/12/2010   AUTEUR GENIAUT S.GENIAUT 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2007  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ABBAS M.ABBAS

CALCUL=OPER(nom="CALCUL",op=26,sd_prod=table_container,reentrant='f',
            UIinfo={"groupes":("Rsolution",)},
            fr="Calculer des objets lmentaires comme une matrice tangente, intgrer une loi de comportement, etc...",
     OPTION          =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',defaut="COMPORTEMENT",
                           into=( "COMPORTEMENT","MATR_TANG_ELEM","FORC_INT_ELEM"),),
     MODELE          =SIMP(statut='o',typ=modele_sdaster),
     CARA_ELEM       =SIMP(statut='f',typ=cara_elem),
     CHAM_MATER      =SIMP(statut='o',typ=cham_mater),
     TABLE           =SIMP(statut='f',typ=table_container),
     EXCIT           =FACT(statut='o',max='**',
       CHARGE          =SIMP(statut='o',typ=(char_meca,char_cine_meca)),
       FONC_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
       TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FIXE_CSTE",
                                 into=("FIXE_CSTE",)),

     ),
     DEPL            =SIMP(statut='o',typ=cham_no_sdaster ),
     INCR_DEPL       =SIMP(statut='o',typ=cham_no_sdaster ),
     SIGM            =SIMP(statut='o',typ=cham_elem),
     VARI            =SIMP(statut='o',typ=cham_elem),
     INCREMENT       =FACT(statut='o',
          LIST_INST       =SIMP(statut='o',typ=listr8_sdaster),
          NUME_ORDRE      =SIMP(statut='o',typ='I'),),
     COMP_INCR       =C_COMP_INCR(),
     COMP_ELAS       =C_COMP_ELAS('CALCUL'),
     INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
) ;

#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
def calc_vect_elem_prod(OPTION,**args):
  if OPTION == "CHAR_MECA" :      return vect_elem_depl_r
  if OPTION == "CHAR_THER" :      return vect_elem_temp_r
  if OPTION == "CHAR_ACOU" :      return vect_elem_pres_c
  if OPTION == "FORC_NODA" :      return vect_elem_depl_r
  raise AsException("type de concept resultat non prevu")

CALC_VECT_ELEM=OPER(nom="CALC_VECT_ELEM",op=8,sd_prod=calc_vect_elem_prod,reentrant='n',
            UIinfo={"groupes":("Matrices et vecteurs",)},
                    fr="Calcul des seconds membres lmentaires",
         OPTION          =SIMP(statut='o',typ='TXM',into=("CHAR_MECA","CHAR_THER","CHAR_ACOU",
                                                           "FORC_NODA") ),
         b_char_meca     =BLOC(condition = "OPTION=='CHAR_MECA'",
           regles=(AU_MOINS_UN('CHARGE','MODELE'),),
           CHARGE          =SIMP(statut='f',typ=char_meca,validators=NoRepeat(),max='**'),
           MODELE          =SIMP(statut='f',typ=modele_sdaster),
           b_charge     =BLOC(condition = "CHARGE != None", fr="modle ne contenant pas de sous-structure",
              CHAM_MATER   =SIMP(statut='f',typ=cham_mater),
              CARA_ELEM    =SIMP(statut='f',typ=cara_elem),
              INST         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
              MODE_FOURIER =SIMP(statut='f',typ='I',defaut= 0 ),
           ),
           b_modele     =BLOC(condition = "(MODELE != None)",fr="modle contenant une sous-structure",
              SOUS_STRUC      =FACT(statut='o',min=01,
                regles=(UN_PARMI('TOUT','SUPER_MAILLE'),),
                CAS_CHARGE  =SIMP(statut='o',typ='TXM' ),
                TOUT        =SIMP(statut='f',typ='TXM',into=("OUI",) ),
                SUPER_MAILLE=SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**',),
              ),
           ),
         ),
         b_char_ther     =BLOC(condition = "OPTION=='CHAR_THER'",
           CARA_ELEM        =SIMP(statut='f',typ=cara_elem),
           CHARGE           =SIMP(statut='o',typ=char_ther,validators=NoRepeat(),max='**'),
           INST             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
         ),

         b_char_acou     =BLOC(condition = "OPTION=='CHAR_ACOU'",
           CHAM_MATER        =SIMP(statut='o',typ=cham_mater),
           CHARGE            =SIMP(statut='o',typ=char_acou,validators=NoRepeat(),max='**'),
         ),

         b_forc_noda     =BLOC(condition = "OPTION=='FORC_NODA'",
           SIEF_ELGA         =SIMP(statut='o',typ=cham_elem),
           CARA_ELEM         =SIMP(statut='f',typ=cara_elem),
           MODELE            =SIMP(statut='f',typ=modele_sdaster),
         ),
) ;
#& MODIF COMMANDE  DATE 29/03/2011   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
COMB_FOURIER=OPER(nom="COMB_FOURIER",op= 161,sd_prod=comb_fourier,
                  reentrant='n',fr="Recombiner les modes de Fourier d'une SD Rsultat dans des directions particulires",
            UIinfo={"groupes":("Post-traitements",)},
         RESULTAT        =SIMP(statut='o',typ=(fourier_elas,fourier_ther),),
         ANGL            =SIMP(statut='o',typ='R',max='**'),
         NOM_CHAM        =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=6,into=("DEPL","REAC_NODA",
                               "SIEF_ELGA","EPSI_ELNO","SIGM_ELNO","TEMP","FLUX_ELNO"),),
) ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE SELLENET N.SELLENET
def comb_matr_asse_prod(COMB_R,COMB_C,CALC_AMOR_GENE,**args):
  if COMB_C != None:
    type_mat = AsType(COMB_C[0]['MATR_ASSE'])
    if type_mat in  (matr_asse_depl_c,matr_asse_depl_r) : return matr_asse_depl_c
    if type_mat in  (matr_asse_gene_c,matr_asse_gene_r) : return matr_asse_gene_c
    if type_mat in  (matr_asse_temp_c,matr_asse_temp_r) : return matr_asse_temp_c
    if type_mat in  (matr_asse_pres_c,matr_asse_pres_r) : return matr_asse_pres_c
  elif COMB_R != None:
    type_mat = AsType(COMB_R[0]['MATR_ASSE'])
    if type_mat in  (matr_asse_depl_c,matr_asse_depl_r) : return matr_asse_depl_r
    if type_mat in  (matr_asse_temp_c,matr_asse_temp_r) : return matr_asse_temp_r
    if type_mat in  (matr_asse_pres_c,matr_asse_pres_r) : return matr_asse_pres_r
    if type_mat in  (matr_asse_gene_c,matr_asse_gene_r) : return matr_asse_gene_r
  elif CALC_AMOR_GENE != None: return matr_asse_gene_r
  raise AsException("type de concept resultat non prevu")

COMB_MATR_ASSE=OPER(nom="COMB_MATR_ASSE",op=  31,sd_prod=comb_matr_asse_prod,
                    fr="Effectuer la combinaison linaire de matrices assembles",
                    reentrant='f',
            UIinfo={"groupes":("Matrices et vecteurs",)},
         regles=(UN_PARMI('COMB_R','COMB_C','CALC_AMOR_GENE' ),),
         COMB_R          =FACT(statut='f',max='**',
           PARTIE          =SIMP(statut='f',typ='TXM',into=("REEL","IMAG") ),
           MATR_ASSE       =SIMP(statut='o',typ=(matr_asse_depl_r,matr_asse_depl_c,matr_asse_temp_r,matr_asse_temp_c
                                                ,matr_asse_pres_r,matr_asse_pres_c,matr_asse_gene_r,matr_asse_gene_c ) ),
           COEF_R          =SIMP(statut='o',typ='R' ),
         ),
         COMB_C          =FACT(statut='f',max='**',
           regles=(UN_PARMI('COEF_R','COEF_C' ),),
           MATR_ASSE       =SIMP(statut='o',typ=(matr_asse_depl_r,matr_asse_depl_c,matr_asse_temp_r,matr_asse_temp_c
                                                ,matr_asse_pres_r,matr_asse_pres_c,matr_asse_gene_r,matr_asse_gene_c ) ),
           COEF_R          =SIMP(statut='f',typ='R' ),
           COEF_C          =SIMP(statut='f',typ='C' ),
         ),
         CALC_AMOR_GENE   =FACT(statut='f',
           RIGI_GENE    = SIMP(statut='o', typ=matr_asse_gene_r),
           MASS_GENE    = SIMP(statut='o', typ=matr_asse_gene_r),
           regles=(UN_PARMI('AMOR_REDUIT','LIST_AMOR' ),),
           AMOR_REDUIT  = SIMP(statut='f',typ='R',max='**'),
           LIST_AMOR    = SIMP(statut='f',typ=listr8_sdaster ),
         ),
         SANS_CMP        =SIMP(statut='f',typ='TXM',into=("LAGR",) ),
)  ;
#& MODIF COMMANDE  DATE 21/03/2011   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE AUDEBERT S.AUDEBERT
COMB_SISM_MODAL=OPER(nom="COMB_SISM_MODAL",op= 109,sd_prod=mode_meca,
                     fr="Rponse sismique par recombinaison modale par une mthode spectrale",
                     reentrant='n',
            UIinfo={"groupes":("Post-traitements","Dynamique",)},
         regles=(EXCLUS('TOUT_ORDRE','NUME_ORDRE','FREQ','NUME_MODE','LIST_FREQ','LIST_ORDRE'),
                 UN_PARMI('AMOR_REDUIT','LIST_AMOR','AMOR_GENE' ),
                 UN_PARMI('MONO_APPUI','MULTI_APPUI' ),),
         MODE_MECA       =SIMP(statut='o',typ=mode_meca ),
         TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
         NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
         LIST_ORDRE      =SIMP(statut='f',typ=listis_sdaster ),
         NUME_MODE       =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
         FREQ            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
         LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster ),
         b_freq          =BLOC(condition = "FREQ != None or LIST_FREQ != None",
           PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-3 ),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
         ),
         MODE_CORR       =SIMP(statut='f',typ=mode_meca ),

         AMOR_REDUIT     =SIMP(statut='f',typ='R',max='**'),
         LIST_AMOR       =SIMP(statut='f',typ=listr8_sdaster ),
         AMOR_GENE       =SIMP(statut='f',typ=matr_asse_gene_r ),

         MASS_INER       =SIMP(statut='f',typ=table_sdaster ),
         CORR_FREQ       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),

         EXCIT           =FACT(statut='o',max='**',
           regles=(UN_PARMI('AXE','TRI_AXE','TRI_SPEC' ),),
           AXE             =SIMP(statut='f',typ='R',max=3,fr="Excitation suivant un seul axe",),
           TRI_AXE         =SIMP(statut='f',typ='R',max=3,fr="Excitation suivant les trois axes mais avec le meme spectre",),
           TRI_SPEC        =SIMP(statut='f',typ='TXM',into=("OUI",),
                                 fr="Excitation suivant les trois axes  avec trois spectres"),
           b_axe           =BLOC(condition = "AXE != None",fr="Excitation suivant un seul axe",
             SPEC_OSCI       =SIMP(statut='o',typ=(nappe_sdaster,formule),),
             ECHELLE         =SIMP(statut='f',typ='R',),
           ),
           b_tri_axe       =BLOC(condition = "TRI_AXE != None",fr="Excitation suivant les trois axes mais avec le meme spectre",
             SPEC_OSCI       =SIMP(statut='o',typ=(nappe_sdaster,formule),),
             ECHELLE         =SIMP(statut='f',typ='R',),
           ),
           b_tri_spec      =BLOC(condition = "TRI_SPEC != None",fr="Excitation suivant les trois axes  avec trois spectres",
             SPEC_OSCI       =SIMP(statut='o',typ=(nappe_sdaster,formule),min=3,max=3 ),
             ECHELLE         =SIMP(statut='f',typ='R',min=3,max=3),
           ),
           NATURE          =SIMP(statut='f',typ='TXM',defaut="ACCE",into=("ACCE","VITE","DEPL") ),
           b_mult_appui    =BLOC(condition = "(MULTI_APPUI != None)",
                                 regles=(UN_PARMI('NOEUD','GROUP_NO' ),),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),)
         ),
         MONO_APPUI      =SIMP(statut='f',typ='TXM',into=("OUI",),
                                 fr="excitation impose unique" ),
         MULTI_APPUI      =SIMP(statut='f',typ='TXM',position='global',into=("DECORRELE","CORRELE"),
                                 fr="excitation impose unique" ),
         b_decorrele     =BLOC(condition = "MULTI_APPUI == 'DECORRELE' ",
           GROUP_APPUI     =FACT(statut='f',max='**',
           regles=(UN_PARMI('NOEUD','GROUP_NO' ),),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),),

         ),
         b_correle =BLOC(condition = "MULTI_APPUI == 'CORRELE' ",
           COMB_MULT_APPUI =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','NOEUD','GROUP_NO' ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           TYPE_COMBI      =SIMP(statut='f',typ='TXM',into=("QUAD","LINE",) ),),
         ),

         COMB_MODE       =FACT(statut='o',
           TYPE            =SIMP(statut='o',typ='TXM',into=("SRSS","CQC","DSC","ABS","DPC") ),
           DUREE           =SIMP(statut='f',typ='R' ),
         ),
         COMB_DIRECTION  =FACT(statut='f',
           TYPE            =SIMP(statut='f',typ='TXM',into=("QUAD","NEWMARK") ),
         ),
         COMB_DEPL_APPUI=FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','LIST_CAS'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",)),
           LIST_CAS       =SIMP(statut='f',typ='I',max='**'),
           TYPE_COMBI      =SIMP(statut='f',typ='TXM',into=("QUAD","LINE","ABS") ),
         ),
         DEPL_MULT_APPUI =FACT(statut='f',max='**',
           regles=(UN_PARMI('NOEUD','GROUP_NO'),
                   AU_MOINS_UN('DX','DY','DZ' ),),
           NOM_CAS         =SIMP(statut='o',typ='TXM',max='**'),
           NUME_CAS        =SIMP(statut='o',typ='I',max='**'),
           MODE_STAT       =SIMP(statut='o',typ=mode_meca, ),
           NOEUD_REFE      =SIMP(statut='f',typ=no),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           DX              =SIMP(statut='f',typ='R' ),
           DY              =SIMP(statut='f',typ='R' ),
           DZ              =SIMP(statut='f',typ='R' ),
         ),
         OPTION          =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=9,
                               into=("DEPL","VITE","ACCE_ABSOLU","SIGM_ELNO","SIEF_ELGA",
                                     "EFGE_ELNO","REAC_NODA","FORC_NODA","EFCA_ELNO",
                                     "SIPO_ELNO") ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2 ) ),
         IMPRESSION      =FACT(statut='f',max='**',
           regles=(EXCLUS('TOUT','NIVEAU'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           NIVEAU          =SIMP(statut='f',typ='TXM',into=("SPEC_OSCI","MASS_EFFE","MAXI_GENE"),validators=NoRepeat(),max=3 ),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 08/03/2011   AUTEUR MASSIN P.MASSIN 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
def crea_champ_prod(TYPE_CHAM,**args):
  if TYPE_CHAM[0:5] == "CART_" :
     return carte_sdaster
  elif TYPE_CHAM[0:5] == "NOEU_" :
     return cham_no_sdaster
  elif TYPE_CHAM[0:2] == "EL"    :
     return cham_elem
  else :
     raise AsException("type de concept resultat_sdaster non prevu")


CREA_CHAMP=OPER(nom="CREA_CHAMP",op= 195,sd_prod=crea_champ_prod,
                fr="Cration d'un champ ",reentrant='f',
            UIinfo={"groupes":("Rsultats et champs",)},
         TYPE_CHAM       =SIMP(statut='o',typ='TXM',into=C_TYPE_CHAM_INTO()),
      # TYPE_CHAM doit etre de la forme : CART_xx, NOEU_xx, ELEM_xx, ELGA_xx ou ELNO_xx
      # ou xx est le nom d'une grandeur dfinie dans le catalogue des grandeurs
#        SI CREATION D'UN CHAM_NO, POUR IMPOSER LA NUMEROTATION DES DDLS :
#        ------------------------------------------------------------------
         regles=(EXCLUS('NUME_DDL','CHAM_NO',)),
         NUME_DDL        =SIMP(statut='f',typ=(nume_ddl_sdaster) ),
         CHAM_NO         =SIMP(statut='f',typ=(cham_no_sdaster) ),

#        SI CREATION D'UN CHAM_ELEM, POUR aider a l'allocation du champ :
#        (PAR DEFAUT : TOU_INI_ELNO/_ELGA/_ELEM)
#        ------------------------------------------------------------------
         OPTION         =SIMP(statut='f',typ='TXM'),

         OPERATION       =SIMP(statut='o',typ='TXM',into=("AFFE","ASSE","EVAL","EXTR","DISC","NORMALE","R2C","C2R","COMB") ),

#        ------------------------------------------------------------------
         b_norm          =BLOC(condition = "OPERATION == 'NORMALE'",
                               regles=(AU_MOINS_UN('GROUP_MA','MAILLE',),),
             MODELE          =SIMP(statut='o',typ=(modele_sdaster) ),
             GROUP_MA        =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
                             ),
#        ------------------------------------------------------------------
         b_affe          =BLOC(condition = "OPERATION == 'AFFE'",
             regles=(UN_PARMI('MAILLAGE','MODELE'),),
             MAILLAGE        =SIMP(statut='f',typ=(maillage_sdaster) ),
             MODELE          =SIMP(statut='f',typ=(modele_sdaster) ),
             b_affe_modele   =BLOC(condition = "MODELE != None",
                 PROL_ZERO       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ), ),
             AFFE            =FACT(statut='o',max='**',
                regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD',),
                        UN_PARMI('VALE','VALE_I','VALE_C','VALE_F', ),),
                TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
                GROUP_MA        =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max='**'),
                MAILLE          =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
                GROUP_NO        =SIMP(statut='f',typ=grno ,validators=NoRepeat(),max='**'),
                NOEUD           =SIMP(statut='f',typ=no   ,validators=NoRepeat(),max='**'),
                NOM_CMP         =SIMP(statut='o',typ='TXM',max='**'),
                VALE            =SIMP(statut='f',typ='R',max='**' ),
                VALE_I          =SIMP(statut='f',typ='I',max='**' ),
                VALE_C          =SIMP(statut='f',typ='C',max='**' ),
                VALE_F          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),max='**'),
                                   ),
                             ),
#        ------------------------------------------------------------------
         b_asse          =BLOC(condition = "OPERATION == 'ASSE'",
             regles=(UN_PARMI('MAILLAGE','MODELE'),),
             MAILLAGE        =SIMP(statut='f',typ=(maillage_sdaster) ),
             MODELE          =SIMP(statut='f',typ=(modele_sdaster) ),
             b_asse_modele   =BLOC(condition = "MODELE != None",
                 PROL_ZERO       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ), ),
             ASSE            =FACT(statut='o',max='**',
                regles=(AU_MOINS_UN('TOUT','GROUP_MA','GROUP_NO','MAILLE','NOEUD',),
                PRESENT_PRESENT('NOM_CMP_RESU','NOM_CMP', ),),
                TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
                GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                CHAM_GD         =SIMP(statut='o',typ=cham_gd_sdaster),
                NOM_CMP         =SIMP(statut='f',typ='TXM',max='**' ),
                NOM_CMP_RESU    =SIMP(statut='f',typ='TXM',max='**' ),
                CUMUL           =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ),
                COEF_R          =SIMP(statut='f',typ='R',defaut= 1. ),
                COEF_C          =SIMP(statut='f',typ='C',max=1),
                                    ),
                             ),
#        ------------------------------------------------------------------
         b_comb          =BLOC(condition = "OPERATION == 'COMB'",
                               fr="Pour faire une combinaison linaire de cham_no ayant meme profil",
             COMB            =FACT(statut='o',max='**',
                CHAM_GD         =SIMP(statut='o',typ=cham_no_sdaster),
                COEF_R          =SIMP(statut='o',typ='R'),
                                   ),
                             ),
#        ------------------------------------------------------------------
         b_eval          =BLOC(condition = "OPERATION == 'EVAL'",
             CHAM_F          =SIMP(statut='o',typ=cham_gd_sdaster),
             CHAM_PARA       =SIMP(statut='o',typ=cham_gd_sdaster,max='**'),
                             ),
#        ------------------------------------------------------------------
         b_r2c           =BLOC(condition = "OPERATION == 'R2C'",
             CHAM_GD          =SIMP(statut='o',typ=cham_gd_sdaster),
                             ),
#        ------------------------------------------------------------------
         b_c2r           =BLOC(condition = "OPERATION == 'C2R'",
             CHAM_GD          =SIMP(statut='o',typ=cham_gd_sdaster),
             PARTIE           =SIMP(statut='o',typ='TXM',into=('REEL','IMAG','MODULE','PHASE'),),
                             ),
#        ------------------------------------------------------------------
         b_disc          =BLOC(condition = "OPERATION == 'DISC'",
             MODELE          =SIMP(statut='f',typ=(modele_sdaster) ),
             PROL_ZERO       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ),
             CHAM_GD         =SIMP(statut='o',typ=cham_gd_sdaster),
                             ),
#        ------------------------------------------------------------------
         b_extr          =BLOC(condition = "OPERATION == 'EXTR'",
             regles=(AU_MOINS_UN('MAILLAGE','FISSURE','RESULTAT','TABLE'),),
#                     PRESENT_PRESENT('GRILLE_AUX','FISSURE'),),
             MAILLAGE        =SIMP(statut='f',typ=(maillage_sdaster) ),
             FISSURE         =SIMP(statut='f',typ=(fiss_xfem) ),
             RESULTAT        =SIMP(statut='f',typ=(resultat_sdaster) ),
             TABLE           =SIMP(statut='f',typ=(table_sdaster),min=1,max=1),
             b_extr_maillage =BLOC(condition = "MAILLAGE != None and TABLE == None",
                 NOM_CHAM        =SIMP(statut='o',typ='TXM',into=("GEOMETRIE",)),
             ),

             b_extr_fissure  = BLOC(condition = "FISSURE != None",
                 NOM_CHAM=SIMP(statut='o',typ='TXM',into=("LTNO","LNNO","GRLTNO","GRLNNO","STNO","STNOR","BASLOC",
                                                                  "GRI.LNNO","GRI.LTNO","GRI.GRLNNO","GRI.GRLTNO")),

             ),
                 
             b_extr_table    =BLOC(condition = "TABLE != None",
                      regles=( EXCLUS('MODELE','MAILLAGE'),
                               EXCLUS('PROL_ZERO','MAILLAGE'),),
                      MAILLAGE        =SIMP(statut='f',typ=(maillage_sdaster),),
                      MODELE          =SIMP(statut='f',typ=(modele_sdaster),),
                      OPTION          =SIMP(statut='f',typ='TXM'),
                      PROL_ZERO       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ),
                 ),
             b_extr_resultat =BLOC(condition = "RESULTAT != None",
                 regles=(DERIVABLE('RESULTAT'),),
                 SENSIBILITE     =SIMP(statut='f',typ=(para_sensi,theta_geom),
                                   fr="Paramtre de sensibilit.",
                                   ang="Sensitivity parameter"),
                 NOM_CHAM        =SIMP(statut='o',typ='TXM',into=C_NOM_CHAM_INTO()),
                 TYPE_MAXI       =SIMP(statut='f',typ='TXM',into=("MAXI","MINI","MAXI_ABS","MINI_ABS","NORM_TRAN",) ),

                 # si TYPE_MAXI, on spcifie en gnral plusieurs numros d'ordre :
                 b_type_maxi =BLOC(condition = "TYPE_MAXI != None",
                      TYPE_RESU       =SIMP(statut='o',typ='TXM',defaut="VALE",into=("VALE","INST",) ),

                      regles=(EXCLUS('TOUT_ORDRE','LIST_INST','LIST_FREQ','NUME_ORDRE','INST',
                                      'FREQ','NUME_MODE','NOEUD_CMP','NOM_CAS','ANGL'),),
                      TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
                      LIST_INST       =SIMP(statut='f',typ=(listr8_sdaster) ),
                      LIST_FREQ       =SIMP(statut='f',typ=(listr8_sdaster) ),
                      NUME_ORDRE      =SIMP(statut='f',typ='I',max='**'),
                      INST            =SIMP(statut='f',typ='R',max='**'),
                      FREQ            =SIMP(statut='f',typ='R',max='**'),
                      NUME_MODE       =SIMP(statut='f',typ='I',max='**'),
                      NOEUD_CMP       =SIMP(statut='f',typ='TXM',max='**'),
                      NOM_CAS         =SIMP(statut='f',typ='TXM',max='**'),
                      ANGL            =SIMP(statut='f',typ='R',max='**'),
                 ),

                 # si .not. TYPE_MAXI, on ne doit spcifier qu'un seul numro d'ordre :
                 b_non_type_maxi =BLOC(condition = "TYPE_MAXI == None",
                      regles=(EXCLUS('NUME_ORDRE','INST','FREQ','NUME_MODE','NOEUD_CMP','NOM_CAS','ANGL'),),
                      NUME_ORDRE      =SIMP(statut='f',typ='I'),
                      INST            =SIMP(statut='f',typ='R'),
                      FREQ            =SIMP(statut='f',typ='R'),
                      NUME_MODE       =SIMP(statut='f',typ='I'),
                      NOEUD_CMP       =SIMP(statut='f',typ='TXM',max=2),
                      NOM_CAS         =SIMP(statut='f',typ='TXM'),
                      ANGL            =SIMP(statut='f',typ='R'),

                      INTERPOL        =SIMP(statut='f',typ='TXM',defaut="NON",into=("NON","LIN",) ),
                 ),

                 CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",) ),
                 b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                     PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
                 b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                     PRECISION       =SIMP(statut='o',typ='R',),),

         ),  # fin bloc b_extr


               ),
# FIN DU CATALOGUE : INFO,TITRE ET TYPAGE DU RESULTAT :
#-----------------------------------------------------
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=(1,2,) ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**' ),
)  ;
#& MODIF COMMANDE  DATE 03/01/2011   AUTEUR ANDRIAM H.ANDRIAMBOLOLONA 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE ANDRIAM H.ANDRIAMBOLOLONA

from Macro.crea_elem_ssd_ops import crea_elem_ssd_ops

def crea_elem_ssd_prod(self,NUME_DDL,**args):
    if NUME_DDL:
        self.type_sdprod(NUME_DDL,nume_ddl_sdaster)
    return macr_elem_dyna

CREA_ELEM_SSD=MACRO(nom="CREA_ELEM_SSD",
         op=crea_elem_ssd_ops,
         sd_prod=crea_elem_ssd_prod,
         reentrant='n',
         fr="Creation de macro-element dynamique en enchainant les commandes : \
             CALC_MATR_ELEM, NUME_DDL, ASSE_MATRICE, MODE_ITER_SIMULT, \
             DEFI_INTERF_DYNA, DEFI_BASE_MODALE et MACR_ELEM_DYNA",
         UIinfo={"groupes":("Matrices/vecteurs",)},

# pour CAL_MATR_ELEM + NUME_DDL + ASSE_MATRICE + MODE_ITER_SIMULT + MODE_STATIQUE
         MODELE          =SIMP(statut='o',typ=modele_sdaster),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater),
         CARA_ELEM       =SIMP(statut='f',typ=cara_elem),
         NUME_DDL        =SIMP(statut='f',typ=CO,defaut=None),
         CHARGE          =SIMP(statut='f',typ=(char_meca,char_ther,char_acou),validators=NoRepeat(),max='**'),

# pour DEFI_INTERF_DYNA
         INTERFACE       =FACT(statut='o',max='**',
           regles=(ENSEMBLE('NOM','TYPE'),
                   UN_PARMI('NOEUD','GROUP_NO'),),
           NOM             =SIMP(statut='f',typ='TXM' ),
           TYPE            =SIMP(statut='f',typ='TXM',into=("MNEAL","CRAIGB","CB_HARMO",) ),
           NOEUD           =SIMP(statut='f',typ=no,max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,max='**'),
           FREQ            =SIMP(statut='f',typ='R',defaut= 1.),
         ),

# pour DEFI_BASE_MODALE
         BASE_MODALE = FACT(statut='o',max = 1,
           TYPE   =SIMP(statut='o',typ='TXM',max=1,into=('CLASSIQUE','RITZ',)),
           b_ritz = BLOC(condition = "TYPE == 'RITZ' ",
             NMAX_MODE_INTF  =SIMP(statut='f',typ='I',defaut=10),
           ),
         ),

         INFO          =SIMP(statut='f',typ='I',defaut= 1,into=(1,2) ),

         SOLVEUR         =C_SOLVEUR(),

# pour le calcul modal
         CALC_FREQ       =FACT(statut='d',min=0,
             OPTION      =SIMP(statut='f',typ='TXM',defaut="PLUS_PETITE",into=("PLUS_PETITE","BANDE","CENTRE"),
                                   fr="Choix de l option et par consequent du shift du probleme modal" ),
             b_plus_petite =BLOC(condition = "OPTION == 'PLUS_PETITE'",fr="Recherche des plus petites valeurs propres",
               NMAX_FREQ       =SIMP(statut='f',typ='I',defaut= 10,val_min=0 ),
             ),
             b_centre       =BLOC(condition = "OPTION == 'CENTRE'",
                                  fr="Recherche des valeurs propres les plus proches d une valeur donnee",
               FREQ            =SIMP(statut='o',typ='R',
                                     fr="Frequence autour de laquelle on cherche les frequences propres"),
               AMOR_REDUIT     =SIMP(statut='f',typ='R',),
               NMAX_FREQ       =SIMP(statut='f',typ='I',defaut= 10,val_min=0 ),
             ),
             b_bande         =BLOC(condition = "(OPTION == 'BANDE')",
                                   fr="Recherche des valeurs propres dans une bande donnee",
               NMAX_FREQ       =SIMP(statut='f',typ='I',defaut= 9999,val_min=0 ),
               FREQ            =SIMP(statut='o',typ='R',min=2,validators=NoRepeat(),max='**',
                                     fr="Valeurs des frequences delimitant les bandes de recherche"),
             ),
             APPROCHE        =SIMP(statut='f',typ='TXM',defaut="REEL",into=("REEL","IMAG","COMPLEXE"),
                                   fr="Choix du pseudo-produit scalaire pour la resolution du probleme quadratique" ),
           ),


)  ;
#& MODIF COMMANDE  DATE 29/03/2011   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
CREA_MAILLAGE=OPER(nom="CREA_MAILLAGE",op= 167,sd_prod=maillage_sdaster,
            reentrant='n',fr="Cre un maillage  partir d'un maillage existant",
            UIinfo={"groupes":("Maillage",)},
         regles=(EXCLUS('COQU_VOLU', 'CREA_FISS', 'CREA_GROUP_MA', 'CREA_MAILLE', 'CREA_POI1',
                        'DETR_GROUP_MA', 'ECLA_PG', 'HEXA20_27', 'LINE_QUAD', 'MODI_MAILLE',
                        'QUAD_LINE', 'REPERE','RESTREINT','PENTA15_18',),),



         # le MAILLAGE est inutile si ECLA_PG
         MAILLAGE        =SIMP(statut='f',typ=maillage_sdaster ),

         CREA_POI1       =FACT(statut='f',max='**',fr="Cration de mailles de type POI1  partir de noeuds",
           regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD' ),),
           NOM_GROUP_MA    =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
         ),
         CREA_MAILLE     =FACT(statut='f',max='**',fr="Duplication de mailles",
           regles=(AU_MOINS_UN('TOUT','MAILLE','GROUP_MA'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           PREF_MAILLE     =SIMP(statut='o',typ='TXM' ),
           PREF_NUME       =SIMP(statut='f',typ='I' ),
         ),
         CREA_GROUP_MA   =FACT(statut='f',max='**',fr="Duplication de mailles et cration de groupes de mailles",
           regles=(AU_MOINS_UN('TOUT','MAILLE','GROUP_MA' ),),
           NOM             =SIMP(statut='o',typ='TXM'),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           PREF_MAILLE     =SIMP(statut='o',typ='TXM' ),
           PREF_NUME       =SIMP(statut='f',typ='I' ),
         ),
         DETR_GROUP_MA   =FACT(statut='f',fr="Destruction de groupes de mailles",
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           NB_MAILLE       =SIMP(statut='f',typ='I',defaut= 0,
                                 fr="Nombre minimal de mailles que doit contenir le groupe pour etre dtruit",  ),
         ),
         RESTREINT   =FACT(statut='f',fr="Restreindre un maillage  des groupes de mailles",max=1,
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE',),),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
           TOUT_GROUP_MA   =SIMP(statut='f',typ='TXM',defaut='NON',into=('OUI','NON'),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           TOUT_GROUP_NO   =SIMP(statut='f',typ='TXM',defaut='NON',into=('OUI','NON'),),
         ),
         COQU_VOLU   =FACT(statut='f',
                           fr="Creation de mailles volumiques  partir de mailles surfaciques",
           NOM             =SIMP(statut='o',typ='TXM'),
           GROUP_MA        =SIMP(statut='o',typ=grma,validators=NoRepeat(),max ='**'),
           EPAIS           =SIMP(statut='o',typ='R' ),
           PREF_MAILLE     =SIMP(statut='f',typ='TXM',defaut="MS" ),
           PREF_NOEUD      =SIMP(statut='f',typ='TXM',defaut="NS" ),
           PREF_NUME       =SIMP(statut='f',typ='I'  ,defaut=1 ),
           PLAN            =SIMP(statut='o',typ='TXM',into=("SUP","MOY","INF")),
           b_MOY =BLOC(condition = "PLAN == 'MOY'",
             TRANSLATION   =SIMP(statut='o',typ='TXM',into=("SUP","INF") ),
           ),
         ),
         MODI_MAILLE     =FACT(statut='f',max='**',fr="Modification du type de mailles",
           regles=(AU_MOINS_UN('TOUT','MAILLE','GROUP_MA' ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma  ,validators=NoRepeat(),max='**'),
           OPTION          =SIMP(statut='o',typ='TXM',into=("TRIA6_7","QUAD8_9","SEG3_4","QUAD_TRIA3"),
                                 fr="Choix de la transformation" ),
           b_NOS =BLOC(condition = "OPTION == 'TRIA6_7'  or  OPTION == 'QUAD8_9'  or  OPTION == 'SEG3_4'",
             PREF_NOEUD      =SIMP(statut='f',typ='TXM',defaut="NS"),
             PREF_NUME       =SIMP(statut='f',typ='I',defaut= 1 ),
           ),
           b_QTR =BLOC(condition = "OPTION == 'QUAD_TRIA3'",
             PREF_MAILLE     =SIMP(statut='f',typ='TXM',defaut="MS" ),
             PREF_NUME       =SIMP(statut='f',typ='I',defaut= 1 ),
           ),
         ),
         CREA_FISS = FACT(statut='f',max='**',fr="Creation d'une fissure potentielle avec elts de joint ou elts  disc",
           NOM             =SIMP(statut='o',typ='TXM'),
           GROUP_NO_1      =SIMP(statut='o',typ=grno),
           GROUP_NO_2      =SIMP(statut='o',typ=grno),
           PREF_MAILLE     =SIMP(statut='o',typ='TXM'),
           PREF_NUME       =SIMP(statut='f',typ='I',defaut=1 ),
         ),
         LINE_QUAD     =FACT(statut='f',fr="Passage linaire -> quadratique",
           regles=(AU_MOINS_UN('TOUT','MAILLE','GROUP_MA' ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma  ,validators=NoRepeat(),max='**'),
           PREF_NOEUD      =SIMP(statut='f',typ='TXM',defaut="NS"),
           PREF_NUME       =SIMP(statut='f',typ='I',defaut= 1 ),
         ),
         HEXA20_27     =FACT(statut='f',fr="Passage HEXA20 -> HEXA27",
           regles=(AU_MOINS_UN('TOUT','MAILLE','GROUP_MA' ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma  ,validators=NoRepeat(),max='**'),
           PREF_NOEUD      =SIMP(statut='f',typ='TXM',defaut="NS"),
           PREF_NUME       =SIMP(statut='f',typ='I',defaut= 1 ),
         ),
         PENTA15_18     =FACT(statut='f',fr="Passage PENTA15 -> PENTA18",
           regles=(AU_MOINS_UN('TOUT','MAILLE','GROUP_MA' ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma  ,validators=NoRepeat(),max='**'),
           PREF_NOEUD      =SIMP(statut='f',typ='TXM',defaut="NS"),
           PREF_NUME       =SIMP(statut='f',typ='I',defaut= 1 ),
         ),
         QUAD_LINE     =FACT(statut='f',fr="Passage quadratique -> linaire",
           regles=(AU_MOINS_UN('TOUT','MAILLE','GROUP_MA' ),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MAILLE          =SIMP(statut='f',typ=ma,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma  ,validators=NoRepeat(),max='**'),
         ),
         REPERE          =FACT(statut='f',max='**',
                               fr="changement de repre servant  dterminer les caractristiques d'une section de poutre",
           TABLE           =SIMP(statut='o',typ=table_sdaster,
                                 fr="Nom de la table contenant les caractristiques de la section de poutre" ),
           NOM_ORIG        =SIMP(statut='f',typ='TXM',into=("CDG","TORSION"),fr="Origine du nouveau repre" ),
           NOM_ROTA        =SIMP(statut='f',typ='TXM',into=("INERTIE",),fr="Direction du repre"  ),
           b_cdg =BLOC(condition = "NOM_ORIG == 'CDG'",
             GROUP_MA        =SIMP(statut='f',typ=grma,
                                   fr="Nom du groupe de mailles dont le centre de gravit sera l origine du nouveau repre"),
           ),
         ),
         ECLA_PG         =FACT(statut='f',
                               fr="Eclatement des mailles en petites mailles contenant chacune un seul point de gauss",
           MODELE          =SIMP(statut='o',typ=modele_sdaster ),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           SHRINK          =SIMP(statut='f',typ='R',defaut= 0.9, fr="Facteur de rduction" ),
           TAILLE_MIN      =SIMP(statut='f',typ='R',defaut= 0.0, fr="Taille minimale d'un cot" ),
           NOM_CHAM        =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',into=C_NOM_CHAM_INTO('ELGA'),),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
#
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 29/03/2011   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE
def crea_resu_prod(TYPE_RESU,**args):
  if TYPE_RESU == "EVOL_ELAS"    : return evol_elas
  if TYPE_RESU == "EVOL_NOLI"    : return evol_noli
  if TYPE_RESU == "EVOL_THER"    : return evol_ther
  if TYPE_RESU == "MULT_ELAS"    : return mult_elas
  if TYPE_RESU == "MODE_MECA"    : return mode_meca
  if TYPE_RESU == "DYNA_TRANS"   : return dyna_trans
  if TYPE_RESU == "DYNA_HARMO"   : return dyna_harmo
  if TYPE_RESU == "FOURIER_ELAS" : return fourier_elas
  if TYPE_RESU == "FOURIER_THER" : return fourier_ther
  if TYPE_RESU == "EVOL_VARC"    : return evol_varc
  if TYPE_RESU == "EVOL_CHAR"    : return evol_char
  raise AsException("type de concept resultat non prevu")

CREA_RESU=OPER(nom="CREA_RESU",op=124,sd_prod=crea_resu_prod,reentrant='f',
            UIinfo={"groupes":("Rsultats et champs",)},
               fr="Crer ou enrichir une structure de donnees resultat  partir de champs aux noeuds",

         OPERATION =SIMP(statut='o',typ='TXM',into=("AFFE","ASSE","ECLA_PG","PERM_CHAM","PROL_RTZ","PREP_VRC1","PREP_VRC2",),
                         fr="choix de la fonction a activer",),


         # Cration par affectation de champs :
         #-------------------------------------
         b_affe       =BLOC(condition = "OPERATION == 'AFFE'",

           TYPE_RESU    =SIMP(statut='o',position='global',typ='TXM',into=("MODE_MECA","MULT_ELAS","EVOL_ELAS","EVOL_NOLI",
                              "DYNA_HARMO","DYNA_TRANS","FOURIER_ELAS","EVOL_THER","EVOL_VARC","EVOL_CHAR","FOURIER_THER") ),
           b_type_resu    =BLOC(condition = "TYPE_RESU == 'EVOL_CHAR'",
             NOM_CHAM     =SIMP(statut='o',typ='TXM',into=("PRES","FSUR_2D","FSUR_3D","FVOL_2D","FVOL_3D","VITE_VENT")),
           ),

           b_evol_char    =BLOC(condition = "TYPE_RESU != 'EVOL_CHAR'",
             NOM_CHAM     =SIMP(statut='o',typ='TXM',into=C_NOM_CHAM_INTO()),
           ),

           b_mode       =BLOC(condition = "TYPE_RESU == 'MODE_MECA'",
             MATR_A         =SIMP(statut='f',typ=matr_asse_depl_r,),
             MATR_B         =SIMP(statut='f',typ=matr_asse_depl_r,),
           ),

           AFFE         =FACT(statut='o',max='**',
             CHAM_GD       =SIMP(statut='o',typ=(cham_gd_sdaster)),
             MODELE        =SIMP(statut='f',typ=modele_sdaster),
             CHAM_MATER    =SIMP(statut='f',typ=cham_mater),
             CARA_ELEM     =SIMP(statut='f',typ=cara_elem),

             b_mult_elas     =BLOC(condition = "TYPE_RESU == 'MULT_ELAS' ",
                NOM_CAS         =SIMP(statut='f',typ='TXM' ),
                CHARGE          =SIMP(statut='f',typ=(char_meca),max='**'),
             ),
             b_evol          =BLOC(condition = "((TYPE_RESU=='EVOL_ELAS') or (TYPE_RESU=='EVOL_NOLI') or (TYPE_RESU=='EVOL_THER')\
                                         or (TYPE_RESU=='EVOL_VARC') or (TYPE_RESU=='EVOL_CHAR') or (TYPE_RESU=='DYNA_TRANS'))",
                regles=(UN_PARMI('INST','LIST_INST'),),
                INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
                LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
                NUME_INIT       =SIMP(statut='f',typ='I', val_min=1),
                NUME_FIN        =SIMP(statut='f',typ='I', val_min=1),
                PRECISION       =SIMP(statut='f',typ='R',defaut= 0.0 ),
                CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
             ),
             b_fourier_elas  =BLOC(condition = "(TYPE_RESU == 'FOURIER_ELAS') ",
                NUME_MODE       =SIMP(statut='f',typ='I'),
                TYPE_MODE       =SIMP(statut='f',typ='TXM',defaut="SYME",into=("SYME","ANTI","TOUS") ),
                CHARGE          =SIMP(statut='f',typ=(char_meca),max='**'),
             ),
             b_fourier_ther  =BLOC(condition = "(TYPE_RESU == 'FOURIER_THER') ",
                NUME_MODE       =SIMP(statut='f',typ='I'),
                TYPE_MODE       =SIMP(statut='f',typ='TXM',defaut="SYME",into=("SYME","ANTI","TOUS") ),
             ),
             b_mode       =BLOC(condition = "TYPE_RESU == 'MODE_MECA'",
                NUME_MODE       =SIMP(statut='f',typ='I'),
                FREQ            =SIMP(statut='f',typ='R'),
             ),
             b_dyna_harmo       =BLOC(condition = "TYPE_RESU == 'DYNA_HARMO'",
                regles=(UN_PARMI('FREQ','LIST_FREQ',),),
                FREQ            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
                LIST_FREQ       =SIMP(statut='f',typ=listr8_sdaster),
                CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
                PRECISION       =SIMP(statut='f',typ='R',defaut=0.0),
             ),
           ),
         ),


         # Cration par assemblage d'evol_ther :
         #-----------------------------------------
         b_asse       =BLOC(condition = "OPERATION == 'ASSE'",
           TYPE_RESU    =SIMP(statut='o',position='global',typ='TXM',into=("EVOL_THER",) ),
           ASSE         =FACT(statut='o',max='**',
             RESULTAT       =SIMP(statut='o',typ=evol_ther),
             TRANSLATION    =SIMP(statut='f',typ='R',defaut= 0. ),
           ),
         ),


         b_ecla_pg    =BLOC(condition = "OPERATION == 'ECLA_PG'",

           TYPE_RESU       =SIMP(statut='o',typ='TXM',into=("EVOL_ELAS","EVOL_NOLI","EVOL_THER"), ),

           ECLA_PG         =FACT(statut='o',
             regles=(EXCLUS('TOUT_ORDRE','NUME_ORDRE','INST','LIST_INST','LIST_ORDRE'),),
             NOM_CHAM        =SIMP(statut='o',typ='TXM',validators=NoRepeat(),max='**',into=C_NOM_CHAM_INTO('ELGA'),),
             MODELE_INIT     =SIMP(statut='o',typ=modele_sdaster),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             RESU_INIT       =SIMP(statut='o',typ=resultat_sdaster),
             MAILLAGE        =SIMP(statut='o',typ=maillage_sdaster),
             TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             NUME_ORDRE      =SIMP(statut='f',typ='I',validators=NoRepeat(),max='**'),
             LIST_ORDRE      =SIMP(statut='f',typ=listis_sdaster),
             INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
             LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
             CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",),),
             b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                 PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
             b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                 PRECISION       =SIMP(statut='o',typ='R',),),
           ),
         ),


         b_perm_cham =BLOC(condition = "OPERATION == 'PERM_CHAM'",

           TYPE_RESU       =SIMP(statut='o',typ='TXM',into=("EVOL_NOLI",) ),
           NOM_CHAM        =SIMP(statut='f',typ='TXM',into=("DEPL","SIEF_ELGA","VARI_ELGA",),validators=NoRepeat(),max='**' ),
           RESU_INIT       =SIMP(statut='o',typ=evol_noli),
           INST_INIT       =SIMP(statut='f',typ='R'),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",),),
           b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
               PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
           b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
               PRECISION       =SIMP(statut='o',typ='R',),),
           MAILLAGE_INIT   =SIMP(statut='o',typ=maillage_sdaster,),
           RESU_FINAL      =SIMP(statut='o',typ=evol_noli,),
           MAILLAGE_FINAL  =SIMP(statut='o',typ=maillage_sdaster,),
           PERM_CHAM       =FACT(statut='o',max='**',
              GROUP_MA_FINAL =SIMP(statut='o',typ=grma),
              GROUP_MA_INIT  =SIMP(statut='o',typ=grma),
              TRAN           =SIMP(statut='o',typ='R',min=3,max=3),
              PRECISION      =SIMP(statut='f',typ='R',defaut=1.0E-3),
           ),
         ),

         b_prol_rtz   =BLOC(condition = "OPERATION == 'PROL_RTZ'",

           TYPE_RESU       =SIMP(statut='o',typ='TXM',into=("EVOL_THER",) ),

           PROL_RTZ        =FACT(statut='o',
              regles=(EXCLUS('INST','LIST_INST'),),
              MAILLAGE_FINAL  =SIMP(statut='o',typ=maillage_sdaster,),
              TABLE           =SIMP(statut='o',typ=table_sdaster,fr="Table issue de post_releve_t"),
              INST            =SIMP(statut='f',typ='R',validators=NoRepeat(),max='**'),
              LIST_INST       =SIMP(statut='f',typ=listr8_sdaster),
              b_acce_reel     =BLOC(condition="(INST != None)or(LIST_INST != None)",
                 CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",),),
                 b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                     PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
                 b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                     PRECISION       =SIMP(statut='o',typ='R',),),
              ),
              PROL_DROITE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU",),),
              PROL_GAUCHE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU",),),
              REPERE          =SIMP(statut='o',typ='TXM',into=("CYLINDRIQUE",),),
              ORIGINE         =SIMP(statut='o',typ='R',min=3,max=3),
              AXE_Z           =SIMP(statut='o',typ='R',min=3,max=3),
           ),
         ),

         b_prep_vrc1      =BLOC(condition = "OPERATION == 'PREP_VRC1'",
           # calculer la temprature dans les couches des coques multicouche  partir d'un champ de fonctions
           # de fonctions du temps et de l'espace (paisseur)

           TYPE_RESU    =SIMP(statut='o',position='global',typ='TXM',into=( "EVOL_THER",) ),

           PREP_VRC1        =FACT(statut='o',max=1,
             CHAM_GD       =SIMP(statut='o',typ=(cham_gd_sdaster)), # carte de fonctions du temps et de l'paisseur
             MODELE        =SIMP(statut='o',typ=modele_sdaster),    # modle mcanique contenant les coques multicouche
             CARA_ELEM     =SIMP(statut='o',typ=cara_elem),         # CARA_ELEM pour connaitre EPAIS et COQU_NCOU
             INST          =SIMP(statut='o',typ='R',validators=NoRepeat(),max='**'),
           ),
         ),

         b_prep_vrc2      =BLOC(condition = "OPERATION == 'PREP_VRC2'",
           # calculer la temprature dans les couches des coques multicouche  partir d'un evol_ther "coque"
           # contenant TEMP/TEMP_INF/TEMP_SUP

           TYPE_RESU    =SIMP(statut='o',position='global',typ='TXM',into=( "EVOL_THER",) ),

           PREP_VRC2        =FACT(statut='o',max=1,
             EVOL_THER     =SIMP(statut='o',typ=(evol_ther)),       # evol_ther de type "coque" (TEMP/TEMP_INF/TEMP_SUP)
             MODELE        =SIMP(statut='o',typ=modele_sdaster),    # modle mcanique contenant les coques multicouche
             CARA_ELEM     =SIMP(statut='o',typ=cara_elem),         # CARA_ELEM pour connaitre EPAIS et COQU_NCOU
           ),
         ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS

def crea_table_prod(TYPE_TABLE, **args):
   """Typage du concept rsultat
   """
   if TYPE_TABLE == 'TABLE_FONCTION':
      return table_fonction
   elif TYPE_TABLE == 'TABLE_CONTENEUR':
      return table_container
   else:
      return table_sdaster

CREA_TABLE=OPER(nom="CREA_TABLE",op=36,sd_prod=crea_table_prod,
                fr="Cration d'une table  partir d'une fonction ou de deux listes",
                reentrant='f',
                UIinfo={"groupes":("Tables",)},

           regles=(EXCLUS('FONCTION','LISTE','RESU'),),

           LISTE=FACT(statut='f',max='**',
                 fr="Creation d'une table a partir de listes",
                 regles=(UN_PARMI('LISTE_I','LISTE_R','LISTE_K')),
                        PARA     =SIMP(statut='o',typ='TXM'),
                        TYPE_K   =SIMP(statut='f',typ='TXM',defaut='K8',
                                    into=('K8','K16','K24')),
                        NUME_LIGN=SIMP(statut='f',typ='I',max='**'),
                        LISTE_I  =SIMP(statut='f',typ='I',max='**'),
                        LISTE_R  =SIMP(statut='f',typ='R',max='**'),
                        LISTE_K  =SIMP(statut='f',typ='TXM', max='**'),
           ),
           FONCTION=FACT(statut='f',
                    fr="Creation d'une table a partir d'une fonction",
                        FONCTION=SIMP(statut='o',typ=(fonction_c,fonction_sdaster)),
                        PARA=SIMP(statut='f',typ='TXM',min=2,max=2),
           ),
           b_fonction = BLOC(condition='FONCTION != None',
               regles=(CONCEPT_SENSIBLE('SEPARE'), REUSE_SENSIBLE(),
                       DERIVABLE('FONCTION'),),
               SENSIBILITE = SIMP(statut='f',typ=(para_sensi,theta_geom),validators=NoRepeat(),max='**',
                                    fr="Liste des paramtres de sensibilit.",
                                    ang="List of sensitivity parameters"),
           ),
           RESU=FACT(statut='f',max=1,
                fr="Creation d'une table a partir d'un resultat ou d'un champ",
                regles=(UN_PARMI('CHAM_GD','RESULTAT'),
                        UN_PARMI('TOUT_CMP','NOM_CMP'),
                        PRESENT_ABSENT('TOUT','GROUP_MA','GROUP_NO','MAILLE','NOEUD',),
                        AU_MOINS_UN('TOUT','GROUP_MA','GROUP_NO','MAILLE','NOEUD',),
                        ),
                        CHAM_GD  =SIMP(statut='f',typ=cham_gd_sdaster),
                        RESULTAT =SIMP(statut='f',typ=(resultat_sdaster) ),
                        b_resultat   =BLOC(condition = "RESULTAT != None",
                               regles=(EXCLUS('TOUT_ORDRE','NUME_ORDRE','LIST_ORDRE','INST','LIST_INST',
                                              'MODE','LIST_MODE','FREQ','LIST_FREQ'),),
                               NOM_CHAM        =SIMP(statut='o',typ='TXM',into=C_NOM_CHAM_INTO()),
                               TOUT_ORDRE      =SIMP(statut='f',typ='TXM',into=("OUI",) ),
                               NUME_ORDRE      =SIMP(statut='f',typ='I',max='**'),
                               LIST_ORDRE      =SIMP(statut='f',typ=(listis_sdaster) ),
                               INST            =SIMP(statut='f',typ='R',max='**'),
                               LIST_INST       =SIMP(statut='f',typ=(listr8_sdaster) ),
                               MODE            =SIMP(statut='f',typ='I',max='**'),
                               LIST_MODE       =SIMP(statut='f',typ=(listis_sdaster) ),
                               FREQ            =SIMP(statut='f',typ='R',max='**'),
                               LIST_FREQ       =SIMP(statut='f',typ=(listr8_sdaster) ),
                               CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU",) ),
                               b_prec_rela=BLOC(condition="(CRITERE=='RELATIF')",
                                       PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-6,),),
                               b_prec_abso=BLOC(condition="(CRITERE=='ABSOLU')",
                                       PRECISION       =SIMP(statut='o',typ='R',),),
                            ),
                      TOUT_CMP        =SIMP(statut='f',typ='TXM',into=("OUI",) ),
                      NOM_CMP         =SIMP(statut='f',typ='TXM',max='**'),
                      TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
                      GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                      GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                      MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                      NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                      ),

           TYPE_TABLE = SIMP(statut='f', typ='TXM', defaut="TABLE",
                             into=('TABLE', 'TABLE_FONCTION', 'TABLE_CONTENEUR'),),

           TITRE=SIMP(statut='f',typ='TXM',max='**'),
)  ;



#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2007  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE

DEBUG=PROC(nom="DEBUG",op=137,
            UIinfo={"groupes":("Utilitaires",)},
               fr="Permettre de changer entre 2 commandes quelques variables globales de debug",

     SDVERI          =SIMP(fr="vrifie la conformit des SD produites par les commandes",
                           statut='f',typ='TXM',into=('OUI','NON')),
     JXVERI          =SIMP(fr="vrifie l intgrit de la segmentation mmoire",
                           statut='f',typ='TXM',into=('OUI','NON')),
     JEVEUX          =SIMP(fr="force les dchargement sur disque",
                           statut='f',typ='TXM',into=('OUI','NON')),
     IMPR_MACRO      =SIMP(fr="affichage des sous-commandes produites par les macros dans le fichier mess",
                           statut='f',typ='TXM',into=("OUI","NON")),
 );
#& MODIF COMMANDE  DATE 03/01/2011   AUTEUR COURTOIS M.COURTOIS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE
DEBUT=MACRO(nom="DEBUT",op=ops.build_debut ,repetable='n',
            UIinfo={"groupes":("Gestion du travail",)},
           fr="Ouverture d'une tude. Allocation des ressources mmoire et disque et fichiers",
          sd_prod=ops.DEBUT,

         PAR_LOT         =SIMP(fr="mode de traitement des commandes",statut='f',typ='TXM',
                           into=("OUI","NON"),defaut="OUI"),
         IMPR_MACRO      =SIMP(fr="affichage des sous-commandes produites par les macros dans le fichier mess",
                           statut='f',typ='TXM',into=("OUI","NON"),defaut="NON"),
#         FORMAT_HDF      =SIMP(fr="sauvegarde de la base GLOBALE au format HDF",statut='f',
#                               typ='TXM',defaut="NON",into=("OUI","NON",) ),
         BASE            =FACT(fr="dfinition des paramtres associs aux bases JEVEUX",
                               statut='f',min=1,max=2,
           FICHIER         =SIMP(fr="nom de la base",statut='o',typ='TXM',
                                 into=('GLOBALE','VOLATILE'),),
           TITRE           =SIMP(statut='f',typ='TXM'),
           CAS             =SIMP(statut='f',typ='TXM'),
           NMAX_ENRE       =SIMP(fr="nombre maximum d enregistrements",statut='f',typ='I'),
           LONG_ENRE       =SIMP(fr="longueur des enregistrements",statut='f',typ='I'),
           LONG_REPE       =SIMP(fr="longueur du rpertoire",statut='f',typ='I'),
         ),

         IMPRESSION      =FACT(statut='f',min=1,max=3,
           FICHIER         =SIMP(statut='o',typ='TXM'),
           UNITE           =SIMP(statut='o',typ='I'),
         ),

         CATALOGUE       =FACT(statut='f',min=1,max=10,
           FICHIER         =SIMP(statut='o',typ='TXM'),
           TITRE           =SIMP(statut='f',typ='TXM'),
           UNITE           =SIMP(statut='f',typ='I'),
         ),

         CODE            =FACT(fr="dfinition d'un nom pour l'ensemble d'une tude",
                               statut='f',min=1,max=1,
           NOM             =SIMP(statut='o',typ='TXM'),
           NIV_PUB_WEB     =SIMP(statut='o',typ='TXM',into=('INTERNET','INTRANET')),
           VISU_EFICAS     =SIMP(statut='f',typ='TXM',into=('OUI','NON'),defaut='OUI'),
         ),

         ERREUR          =FACT(fr="comportement en cas d'erreur",statut='f',min=1,max=1,
           ERREUR_F        =SIMP(statut='f',typ='TXM',into=('ABORT','EXCEPTION'),),
         ),

         DEBUG           =FACT(fr="option de dboggage reserve aux dveloppeurs",
                               statut='f',min=1,max=1,
           JXVERI          =SIMP(fr="vrifie l intgrit de la segmentation mmoire",
                                 statut='f',typ='TXM',into=('OUI','NON'),defaut='NON'),
           SDVERI          =SIMP(fr="vrifie la conformit des SD produites par les commandes",
                                 statut='f',typ='TXM',into=('OUI','NON')),
           JEVEUX          =SIMP(fr="force les dchargement sur disque",
                                 statut='f',typ='TXM',into=('OUI','NON'),defaut='NON'),
           ENVIMA          =SIMP(fr="imprime les valeurs dfinies dans ENVIMA",
                                 statut='f',typ='TXM',into=('TEST',)),
         ),

         MESURE_TEMPS     =FACT(fr="Pour choisir les mesures de temps consomm dans les commandes",
                               statut='d',min=1,max=1,
           NIVE_DETAIL      =SIMP(fr="niveau de dtail des impressions",
                                 statut='f',typ='I',into=(0,1,2,3),defaut=1),
                                 # 0 : rien
                                 # 1 : impression en fin de commande des mesures principales
                                 # 2 : impression en fin de commande des mesures principales et secondaires
                                 # 3 : impression des mesures principales et secondaires pour chaque pas de temps
         ),

         MEMOIRE         =FACT(fr="mode de gestion mmoire utilis",statut='d',min=1,max=1,
           GESTION         =SIMP(statut='f',typ='TXM',into=('COMPACTE','RAPIDE'),defaut='RAPIDE'),
           TYPE_ALLOCATION =SIMP(statut='f',typ='I',into=(1,2,3,4),defaut=1),
           TAILLE          =SIMP(statut='f',typ='I'),
           TAILLE_BLOC     =SIMP(statut='f',typ='R',defaut=800.),
           PARTITION       =SIMP(statut='f',typ='R'),
           DYNAMIQUE       =SIMP(statut='f',typ='I',defaut=1),
         ),

         RESERVE_CPU     =FACT(fr="reserve de temps pour terminer une execution",statut='d',max=1,
           regles=(EXCLUS('VALE','POURCENTAGE'),),
#          par dfaut VALE fixe  10. dans le FORTRAN si CODE prsent
           VALE            =SIMP(statut='f',typ='I',val_min=0,),
#          par dfaut 10% dans le FORTRAN
           POURCENTAGE     =SIMP(statut='f',typ='R',val_min=0.,val_max=1.0),
#          valeur en secondes de la rserve maximum borne  900 secondes
           BORNE           =SIMP(statut='f',typ='I',val_min=0,defaut=900),),

         IGNORE_ALARM = SIMP(statut='f', typ='TXM', max='**', fr="Alarmes que l'utilisateur souhaite dlibrment ignorer"),

         INFO     = SIMP(statut='f', typ='I', defaut=1, into=(1,2),),
);
#& MODIF COMMANDE  DATE 25/01/2011   AUTEUR NISTOR I.NISTOR 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE NISTOR I.NISTOR
DEFI_BASE_MODALE=OPER(nom="DEFI_BASE_MODALE",op=  99,sd_prod=mode_meca,
                     reentrant='f',
                     fr="Dfinit la base d'une sous-structuration dynamique ou d'une recombinaison modale",
            UIinfo={"groupes":("Matrices et vecteurs","Dynamique",)},
         regles=(UN_PARMI('CLASSIQUE','RITZ','DIAG_MASS','ORTHO_BASE'),),
         CLASSIQUE       =FACT(statut='f',
           INTERF_DYNA     =SIMP(statut='o',typ=interf_dyna_clas ),
           MODE_MECA       =SIMP(statut='o',typ=mode_meca,max='**' ),
           NMAX_MODE       =SIMP(statut='f',typ='I',defaut= 10 ),
         ),
         RITZ            =FACT(statut='f',max='**',
           regles=(UN_PARMI('MODE_MECA','BASE_MODALE','MODE_INTF'),),
           MODE_MECA       =SIMP(statut='f',typ=mode_meca,max='**'  ),
           NMAX_MODE       =SIMP(statut='f',typ='I',max='**'),
           BASE_MODALE     =SIMP(statut='f',typ=mode_meca ),
           MODE_INTF       =SIMP(statut='f',typ=(mode_meca,mult_elas), ),
         ),
         b_ritz          =BLOC(condition = "RITZ != None",
           INTERF_DYNA     =SIMP(statut='f',typ=interf_dyna_clas ),
           NUME_REF        =SIMP(statut='f',typ=nume_ddl_sdaster ),
           ORTHO           =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON"),
                               fr="Reorthonormalisation de la base de Ritz" ),
           LIST_AMOR       =SIMP(statut='f',typ=listr8_sdaster ),
           b_ortho          =BLOC(condition = "ORTHO == 'OUI' ",
             MATRICE          =SIMP(statut='o',typ=(matr_asse_depl_r,matr_asse_depl_c,matr_asse_gene_r,matr_asse_pres_r ) ),
               ),
         ),
        DIAG_MASS        =FACT(statut='f',max='**',
           MODE_MECA       =SIMP(statut='o',typ=mode_meca,max='**'  ),
           MODE_STAT       =SIMP(statut='o',typ=mode_meca ),
         ),
        ORTHO_BASE        =FACT(statut='f',max='**',
           BASE       =SIMP(statut='o',typ=(mode_meca,mult_elas)),
           MATRICE    =SIMP(statut='o',typ=(matr_asse_depl_r,matr_asse_depl_c,matr_asse_gene_r,matr_asse_pres_r ) ),
         ),

         SOLVEUR         =FACT(statut='d', fr="Mthode de rsolution des systmes linaires",
         METHODE         =SIMP(statut='f',typ='TXM',defaut="MULT_FRONT",into=("LDLT","MULT_FRONT","MUMPS") ),

           b_ldlt          =BLOC(condition = "METHODE == 'LDLT' ",fr="Paramtres de la mthode LDLT",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="RCMK",into=("RCMK","SANS") ),
           ),

           b_mult_front    =BLOC(condition = "METHODE == 'MULT_FRONT' ",fr="Paramtres de la mthode multi frontale",
             RENUM           =SIMP(statut='f',typ='TXM',defaut="METIS",into=("MD","MDA","METIS") ),
           ),
           b_ldlt_mult_mumps =BLOC( condition = "METHODE=='LDLT' or METHODE=='MULT_FRONT' or METHODE=='MUMPS' ",
                                   fr="Paramtres relatifs  la non inversibilit de la matrice  factoriser",
             NPREC           =SIMP(statut='f',typ='I',defaut= 8 ),
             STOP_SINGULIER  =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
           ),
           b_mumps        =BLOC(condition = "METHODE == 'MUMPS' ",fr="Paramtres de la mthode MUMPS",
             TYPE_RESOL      =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("NONSYM","SYMGEN","SYMDEF","AUTO")),
             PRETRAITEMENTS  =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO")),
             POSTTRAITEMENTS =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("SANS","AUTO","FORCE")),
             RENUM           =SIMP(statut='f',typ='TXM',defaut="AUTO",into=("AMD","AMF","PORD","METIS","QAMD","SCOTCH","AUTO")),
             ELIM_LAGR2      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
             PCENT_PIVOT     =SIMP(statut='f',typ='I',defaut=10,),
             RESI_RELA       =SIMP(statut='f',typ='R',defaut=-1.0,),
             OUT_OF_CORE     =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
             LIBERE_MEMOIRE =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
             ),
         ),



         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE MICHEL S.MICHEL

from Macro.defi_cable_bp_ops import defi_cable_bp_ops

# ===========================================================================
#           CATALOGUE DE LA MACRO "DEFI_CABLE_BP"
#           -----------------------------------------
#
# USAGE :
# Entre :
#  - MODELE
#  - CABLE
#  - CHAM_MATER
#  - CARA_ELEM
#  - GROUP_MA_BETON
#  - DEFI_CABLE
#  - TENSION_INIT
#  - RECUL_ANCRAGE
#  - RELAXATION
#  - CONE
#      RAYON
#      LONGUEUR
#      PRESENT          OUI ou NON deux fois
#  - TITRE
#  - INFO               1 / 2
#
# ===========================================================================

DEFI_CABLE_BP=MACRO(nom="DEFI_CABLE_BP",op=defi_cable_bp_ops,sd_prod=cabl_precont,
                   fr="Calculer les profils initiaux de tension le long des cables de prcontrainte d'une structure en bton",
                   reentrant='n',UIinfo={"groupes":("Modlisation",)},
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater ),
         CARA_ELEM       =SIMP(statut='o',typ=cara_elem ),
         GROUP_MA_BETON  =SIMP(statut='o',typ=grma,max='**'),
         DEFI_CABLE      =FACT(statut='o',max='**',
           regles=(UN_PARMI('MAILLE','GROUP_MA'),
                   UN_PARMI('NOEUD_ANCRAGE','GROUP_NO_ANCRAGE'),),
           MAILLE          =SIMP(statut='f',typ=ma,min=2,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma),
           NOEUD_ANCRAGE   =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max=2),
           GROUP_NO_ANCRAGE=SIMP(statut='f',typ=grno,validators=NoRepeat(),max=2),
         ),
         TYPE_ANCRAGE    =SIMP(statut='o',typ='TXM',min=2,max=2,into=("ACTIF","PASSIF") ),
         TENSION_INIT    =SIMP(statut='o',typ='R',val_min=0.E+0 ),
         RECUL_ANCRAGE   =SIMP(statut='o',typ='R',val_min=0.E+0 ),
         RELAXATION      =FACT(statut='f',min=0,
           R_J             =SIMP(statut='o',typ='R',val_min=0.E+0 ),
         ),
         CONE            =FACT(statut='f',
           RAYON             =SIMP(statut='o',typ='R',val_min=0.E+0 ),
           LONGUEUR          =SIMP(statut='o',typ='R',val_min=0.E+0 ),
           PRESENT           =SIMP(statut='o',typ='TXM',min=2,max=2,into=("OUI","NON") ),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**' ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE MICHEL S.MICHEL

DEFI_CABLE_OP=OPER(nom="DEFI_CABLE_OP",op= 180,sd_prod=cabl_precont,reentrant='n',
            fr="Dfinit les profils initiaux de tension d'une structure en bton le long des cables de prcontrainte"
               +" (utilise par la macro DEFI_CABLE_BP)",
            UIinfo={"groupes":("Modlisation",)},
         MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         CHAM_MATER      =SIMP(statut='o',typ=cham_mater ),
         CARA_ELEM       =SIMP(statut='o',typ=cara_elem ),
         GROUP_MA_BETON  =SIMP(statut='o',typ=grma,max='**'),
         DEFI_CABLE      =FACT(statut='o',max='**',
           regles=(UN_PARMI('MAILLE','GROUP_MA'),
                   UN_PARMI('NOEUD_ANCRAGE','GROUP_NO_ANCRAGE'),),
           MAILLE          =SIMP(statut='f',typ=ma,min=2,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma),
           NOEUD_ANCRAGE   =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max=2),
           GROUP_NO_ANCRAGE=SIMP(statut='f',typ=grno,validators=NoRepeat(),max=2),
           GROUP_NO_FUT    =SIMP(statut='f',typ=grno,validators=NoRepeat(),max=2),
         ),
         TYPE_ANCRAGE    =SIMP(statut='o',typ='TXM',min=2,max=2,into=("ACTIF","PASSIF") ),
         TENSION_INIT    =SIMP(statut='o',typ='R',val_min=0.E+0 ),
         RECUL_ANCRAGE   =SIMP(statut='o',typ='R',val_min=0.E+0 ),
         RELAXATION      =FACT(statut='f',min=0,
           R_J             =SIMP(statut='o',typ='R',val_min=0.E+0 ),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**' ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
         CONE            =FACT(statut='f',min=0,
           RAYON             =SIMP(statut='o',typ='R',val_min=0.E+0 ),
           LONGUEUR          =SIMP(statut='o',typ='R',val_min=0.E+0, defaut=0.E+0 ),
           PRESENT           =SIMP(statut='o',typ='TXM',min=2,max=2,into=("OUI","NON") ),
         ),
)  ;
#& MODIF COMMANDE  DATE 23/02/2011   AUTEUR LAVERNE J.LAVERNE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PROIX J.M.PROIX
DEFI_COMPOR=OPER(nom="DEFI_COMPOR",op=59,sd_prod=compor_sdaster,
                   fr="Dfinir le comportement d'un monocristal, d'un polycristal ou de groupes de fibres",
                   reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
# on exclut MULTIFBRE de MONOCRISTAL ou POLYCRISTAL car la structure de donnes n'est pas organise pareil pour ces cas
                  regles=(UN_PARMI('MONOCRISTAL','POLYCRISTAL','MULTIFIBRE'),
                 PRESENT_PRESENT('MULTIFIBRE','GEOM_FIBRE','MATER_SECT'),
                         ),
          MONOCRISTAL    =FACT(statut='f', max='**',
             MATER           =SIMP(statut='o', typ=mater_sdaster, max=1),
             ECOULEMENT      =SIMP(statut='o', typ='TXM', max=1,
                                into=('MONO_VISC1', 'MONO_VISC2', 'MONO_VISC3', 'MONO_DD_KR', 'MONO_DD_CFC', 'MONO_DD_CC',),
                   fr="Donner le nom du mot-cl facteur de DEFI_MATERIAU prcisant le type d'coulement viscoplastique"),
             ELAS            =SIMP(statut='f', typ='TXM', max=1,
                   fr="Donner le nom du mot-cl facteur de DEFI_MATERIAU prcisant le comportement lastique (un et un seul)"),
             b_non_dd =BLOC(condition="ECOULEMENT=='MONO_VISC1' or ECOULEMENT=='MONO_VISC2' or ECOULEMENT=='MONO_VISC3'",
                   ECRO_ISOT       =SIMP(statut='f', typ='TXM', max=1,
                   fr="Donner le nom du mot-cl facteur de DEFI_MATERIAU prcisant le type d'crouissage isotrope"),
                   ECRO_CINE       =SIMP(statut='f', typ='TXM', max=1,
                   fr="Donner le nom du mot-cl facteur de DEFI_MATERIAU prcisant le type d'crouissage cinmatique"),
                   FAMI_SYST_GLIS  =SIMP(statut='o',typ='TXM', max=1,
                                into=('BASAL', 'PRISMATIQUE', 'OCTAEDRIQUE', 'PYRAMIDAL1',
                                'PYRAMIDAL2', 'CUBIQUE1', 'CUBIQUE2', 'MACLAGE', 'UNIAXIAL','BCC24'),),
                                ),
             b_dd_kr =BLOC(condition="ECOULEMENT=='MONO_DD_KR' ",
                   FAMI_SYST_GLIS  =SIMP(statut='f',typ='TXM', max=1,
                                into=('BCC24',),defaut=('BCC24',),),
                                ),
             b_dd_cfc =BLOC(condition="ECOULEMENT=='MONO_DD_CFC' ",
                   FAMI_SYST_GLIS  =SIMP(statut='f',typ='TXM', max=1,
                                into=('OCTAEDRIQUE',),defaut=('OCTAEDRIQUE',),),
                                ),
             b_dd_cc =BLOC(condition="ECOULEMENT=='MONO_DD_CC' ",
                   FAMI_SYST_GLIS  =SIMP(statut='o',typ='TXM', max=1,
                                into=('CUBIQUE1',),defaut=('CUBIQUE1',),),
                                ),
                                ),

          ROTA_RESEAU =SIMP(statut='f', typ='TXM', max=1,into=('NON','POST','CALC'),defaut='NON',
                   fr="rotation de reseau : NON, POST, CALC"),

          POLYCRISTAL    =FACT(statut='f', max='**',
           regles=(UN_PARMI('ANGL_REP','ANGL_EULER'),),
             MONOCRISTAL     =SIMP(statut='o', typ=compor_sdaster, max=1),
             FRAC_VOL  =SIMP(statut='o', typ='R', max=1,fr="fraction volumique de la phase correspondant au monocristal"),
             ANGL_REP  =SIMP(statut='f',typ='R',max=3,fr="orientation du monocristal : 3 angles nautiques en degrs"),
             ANGL_EULER=SIMP(statut='f',typ='R',max=3,fr="orientation du monocristal : 3 angles d'Euler   en degrs"),
                                ),


          b_poly      =BLOC( condition = "POLYCRISTAL!='None'",
          LOCALISATION     =SIMP(statut='f', typ='TXM', max=1, into=('BZ', 'BETA', 'RL',),
                fr="Donner le nom de la rgle de localisation"),

           b_beta      =BLOC( condition = "LOCALISATION=='BETA'",
             DL            =SIMP(statut='o',typ='R',max=1),
             DA            =SIMP(statut='o',typ='R',max=1),
             ),
             ),

#####################################################################################
          GEOM_FIBRE = SIMP(statut='f',max=1,typ=gfibre_sdaster,
                   fr="Donner le nom du concept regroupant tous les groupes de fibres (issu de DEFI_GEOM_FIBRE)"),
          MATER_SECT = SIMP(statut='f',max=1,typ=mater_sdaster,
                   fr="Donner le nom du materiau pour les caracteristiques homogeneisees sur la section"),
          MULTIFIBRE    = FACT(statut='f',max='**',
          GROUP_FIBRE        =SIMP(statut='o', typ='TXM', max='**'),
             MATER           =SIMP(statut='o', typ=mater_sdaster, max=1,
                                   fr="Donner le nom du materiau pour le groupe de fibres"),
             ALGO_1D         =SIMP(statut='f',typ='TXM',defaut="ANALYTIQUE",into=("DEBORST","ANALYTIQUE",)),
             DEFORMATION      =SIMP(statut='f',typ='TXM',defaut="PETIT",
                                     into=("PETIT","PETIT_REAC","GROT_GDEP")),
             RELATION        =SIMP(statut='f', typ='TXM', max=1,defaut="ELAS",into=C_RELATION(),
                                  fr="Donner le nom de la relation incrementale pour le groupe de fibres",
                                  ),
           RELATION_KIT    =SIMP(statut='f',typ='TXM',max='**',validators=NoRepeat(),
                                 into=(
# MECA KIT_DDI
                                       "VMIS_ISOT_TRAC",
                                       "VMIS_ISOT_LINE",
                                       "VMIS_ISOT_CINE",
                                       "VMIS_ISOT_PUIS",
                                       "GRANGER_FP",
                                       "GRANGER_FP_INDT",
                                       "GRANGER_FP_V",
                                       "BETON_UMLV_FP",
                                       "ROUSS_PR",
                                       "BETON_DOUBLE_DP",
                                       ),),
# on pourrait ajouter TOUT_GROUP_FIBRE

                                ) );

#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS
DEFI_CONSTANTE=OPER(nom="DEFI_CONSTANTE",op=   2,sd_prod=fonction_sdaster,
                    fr="Dfinir la valeur d'une grandeur invariante",
                    reentrant='n',
            UIinfo={"groupes":("Fonctions",)},
         NOM_RESU        =SIMP(statut='f',typ='TXM',defaut="TOUTRESU"),
         VALE            =SIMP(statut='o',typ='R',),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 23/02/2011   AUTEUR MASSIN P.MASSIN 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ABBAS M.ABBAS
#
DEFI_CONTACT=OPER(nom       = "DEFI_CONTACT",
                  op        = 30,
                  sd_prod   = char_contact,
                  fr        = "Dfinit les zones soumises  des conditions de contact unilatral avec ou sans frottement",
                  #en        = "Allows the definition of contact surfaces as well as unilateral conditions",
                  reentrant = 'n',
                  UIinfo    = {"groupes":("Modlisation",)},

# MODELE

         MODELE          =SIMP(statut='o',typ=modele_sdaster,),
         INFO            =SIMP(statut='f',typ='I',into=(1,2),),

# FORMULATION (UNIQUE PAR OCCURRENCE DE DEFI_CONTACT)

         FORMULATION     =SIMP(statut='o',
                               position='global',
                               typ='TXM',
                               fr="Choix d'une formulation de contact ou de liaisons unilatrales",
                               defaut="DISCRETE",
                               into=("DISCRETE","CONTINUE","XFEM","LIAISON_UNIL",),),

# PARAMETRE GENERAL : FROTTEMENT

         FROTTEMENT      =SIMP(statut='f',
                               position='global',
                               typ='TXM',
                               fr="Choix d'un modle de frottement (uniquement pour les formulations de contact)",
                               defaut="SANS",
                               into=("COULOMB","SANS",)),

### PARAMETRES GENERAUX (UNIQUEMENT POUR LE CONTACT MAILLE, NE DEPENDENT PAS DE LA ZONE DE CONTACT)

         b_contact_mail=BLOC(condition = "((FORMULATION == 'CONTINUE') or (FORMULATION == 'DISCRETE'))",
#          ARRET DU CALCUL POUR LE MODE SANS RESOLUTION DU CONTACT
           STOP_INTERP   = SIMP(statut='f',
                                typ='TXM',
                                fr="Arrte le calcul ds qu'une interpntration est dtecte en mode RESOLUTION='NON'",
                                defaut="NON",
                                into=("OUI","NON")),
#          LISSAGE DES NORMALES PAR MOYENNATION AUX NOEUDS
           LISSAGE       = SIMP(statut='f',
                                typ='TXM',
                                fr="Lissage des normales par moyennation aux noeuds",
                                defaut="NON",
                                into=("OUI","NON")),
#          VERIFICATION DE L'ORIENTATION ET DE LA COHERENCE DES NORMALES
           VERI_NORM       =SIMP(statut='f',
                                 typ='TXM',
                                 fr="Vrification de l'orientation (sortante) des normales aux surfaces",
                                 defaut="OUI",
                                 into=("OUI","NON"),),
           ),

### PARAMETRES GENERAUX (UNIQUEMENT POUR LE CONTACT, NE DEPENDENT PAS DE LA ZONE DE CONTACT)

         b_contact=BLOC(condition = "FORMULATION != 'LIAISON_UNIL' ",

# PARAMETRE GENERAL : BOUCLE DE GEOMETRIE

           b_bouc_geom_mail=BLOC(condition = "(FORMULATION == 'DISCRETE' or FORMULATION == 'CONTINUE')",
                                 REAC_GEOM =SIMP(statut='f',
                                                 typ='TXM',
                                                 into=("AUTOMATIQUE","CONTROLE","SANS",),
                                                 defaut="AUTOMATIQUE",
                                                 ),
                                 b_automatique = BLOC(condition = "REAC_GEOM == 'AUTOMATIQUE' ",
                                   ITER_GEOM_MAXI = SIMP(statut='f',typ='I',defaut=10),
                                   RESI_GEOM      = SIMP(statut='f',typ='R',defaut=0.01),
                                   ),
                                 b_controle    = BLOC(condition = "REAC_GEOM == 'CONTROLE' ",
                                   NB_ITER_GEOM   = SIMP(statut='f',typ='I',defaut = 2),
                                   ),
                                 ),

           b_bouc_geom_xfem=BLOC(condition = "FORMULATION == 'XFEM' ",
                                 REAC_GEOM =SIMP(statut='f',
                                                 typ='TXM',
                                                 into=("AUTOMATIQUE","CONTROLE","SANS",),
                                                 defaut="SANS",
                                                 ),
                                 b_automatique = BLOC(condition = "REAC_GEOM == 'AUTOMATIQUE' ",
                                   ITER_GEOM_MAXI = SIMP(statut='f',typ='I',defaut=10),
                                   RESI_GEOM      = SIMP(statut='f',typ='R',defaut=0.0001),
                                   ),
                                 b_controle    = BLOC(condition = "REAC_GEOM == 'CONTROLE' ",
                                   NB_ITER_GEOM   = SIMP(statut='f',typ='I',defaut = 2),
                                   ),
                                 ),


# PARAMETRE GENERAL : BOUCLE DE CONTACT

           b_bouc_cont_disc=BLOC(condition = "FORMULATION == 'DISCRETE' ",
                                 ITER_CONT_MULT = SIMP(statut='f',typ='I',defaut = 4),
                                 ),

           b_bouc_cont_cont=BLOC(condition = "FORMULATION == 'CONTINUE' ",
                                 ITER_CONT_TYPE= SIMP(statut='f',typ='TXM',defaut="MAXI",
                                                      into=("MULT","MAXI")),
                                 b_bouc_cont_mult = BLOC(condition = "ITER_CONT_TYPE=='MULT'",
                                   ITER_CONT_MULT = SIMP(statut='f',typ='I',defaut = 4),
                                   ),
                                 b_bouc_cont_maxi = BLOC(condition = "ITER_CONT_TYPE=='MAXI'",
                                   ITER_CONT_MAXI = SIMP(statut='f',typ='I',defaut = 30),
                                   ),
                                 ),

           b_bouc_cont_xfem=BLOC(condition = "FORMULATION == 'XFEM' ",
                                 ITER_CONT_TYPE= SIMP(statut='f',typ='TXM',defaut="MAXI",
                                                      into=("MULT","MAXI")),
                                 b_bouc_cont_mult = BLOC(condition = "ITER_CONT_TYPE=='MULT'",
                                                         ITER_CONT_MULT = SIMP(statut='f',typ='I',defaut = 4),
                                   ),
                                 b_bouc_cont_maxi = BLOC(condition = "ITER_CONT_TYPE=='MAXI'",
                                                         ITER_CONT_MAXI = SIMP(statut='f',typ='I',defaut = 30),
                                   ),
                                 ),

# PARAMETRE GENERAL : BOUCLE DE FROTTEMENT

           b_bouc_frot     = BLOC(condition = "FROTTEMENT=='COULOMB' and ((FORMULATION == 'CONTINUE') or (FORMULATION == 'XFEM')) ",
                                  REAC_FROT =SIMP(statut='f',
                                                  typ='TXM',
                                                  defaut="AUTOMATIQUE",
                                                  into=("AUTOMATIQUE","CONTROLE",),
                                                  ),
                                  b_automatique = BLOC(condition = "REAC_FROT == 'AUTOMATIQUE' ",
                                                       ITER_FROT_MAXI = SIMP(statut='f',typ='I',defaut=10),
                                                       RESI_FROT      = SIMP(statut='f',typ='R',defaut=0.0001),
                                    ),
                                  b_controle    = BLOC(condition = "REAC_FROT == 'CONTROLE' ",
                                                       NB_ITER_FROT   = SIMP(statut='f',typ='I',defaut = 2),
                                    ),
                                  ),

# PARAMETREs GENERAUX : METHODES DISCRETES

           b_para_discret  = BLOC(condition = "FORMULATION == 'DISCRETE' ",
#                                 ## METHODES DE DUALISATION ##
                                  STOP_SINGULIER= SIMP(statut='f',
                                                       typ='TXM',
                                                       fr="Tient compte de la singularit de la matrice de contact",
                                                       defaut="OUI",
                                                       into=("OUI","NON"),),
                                  NB_RESOL      = SIMP(statut='f',
                                                       typ='I',
                                  fr="Nombre de rsolutions simultanes pour la construction du complment de Schur",
                                                       defaut=10,),
#                                 ## GCP ##
                                  RESI_ABSO     = SIMP(statut='f',
                                                       typ='R',
                                  fr="Critre de convergence (niveau d'interpntration autoris pour 'GCP')",),
                                  REAC_ITER     = SIMP(statut='f',
                                                       typ='I',
                                                       fr="Frquence de rinitialisation de la conjugaison ('GCP')",
                                                       defaut=3,),
                                  ITER_GCP_MAXI = SIMP(statut='f',
                                                       typ='I',
                                                       fr="Nombre d'itrations maximal ('GCP')",
                                                       defaut=0,),
                                  PRE_COND      = SIMP(statut='f',
                                                       typ='TXM',
                                                       fr="Choix d'un prconditionneur (acclre la convergence de 'GCP')",
                                                       defaut="SANS",
                                                       into=("DIRICHLET","SANS"),),
                                  ITER_PRE_MAXI = SIMP(statut='f',
                                                       typ='I',
                                                       fr="Nombre d'itrations maximal pour le prconditionneur ('GCP')",
                                                       defaut=0,),
                                  COEF_RESI     = SIMP(statut='f',
                                                       typ='R',
                                                       fr="Critre de convergence du prconditionneur (COEF_RESI*RESI_ABSO)",
                                                       defaut = 1.,),
                                  RECH_LINEAIRE = SIMP(statut='f',
                                                       typ='TXM',
                                  fr="Autorisation de sortie du domaine admissible lors de la recherche linaire",
                                                       defaut="ADMISSIBLE",
                                                       into=("ADMISSIBLE","NON_ADMISSIBLE"),),
                                  ),
           ), #fin bloc b_contact

## AFFECTATIONS (ZONES PAR ZONES)

# AFFECTATION - CAS LIAISON_UNILATERALE

         b_affe_unil     = BLOC(condition = "FORMULATION == 'LIAISON_UNIL'",
                                ZONE=FACT(statut='o',
                                          max='**',
# -- Liaison unilatrale
                                          regles=(UN_PARMI('GROUP_MA','MAILLE','GROUP_NO','NOEUD'),),
                                          GROUP_MA        =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max='**'),
                                          MAILLE          =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
                                          GROUP_NO        =SIMP(statut='f',typ=grno ,validators=NoRepeat(),max='**'),
                                          NOEUD           =SIMP(statut='f',typ=no   ,validators=NoRepeat(),max='**'),
#
                                          NOM_CMP         =SIMP(statut='o',typ='TXM',max='**'),
                                          COEF_IMPO       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),),
                                          COEF_MULT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),max='**'),
# -- Incompatibilit avec CL
                                          SANS_NOEUD      =SIMP(statut='f',typ=no   ,validators=NoRepeat(),max='**'),
                                          SANS_GROUP_NO   =SIMP(statut='f',typ=grno ,validators=NoRepeat(),max='**'),


                                          ),
                                ), #fin bloc b_affe_unil

# AFFECTATION - CAS DISCRET

         b_affe_discret  = BLOC(condition = "FORMULATION == 'DISCRETE'",
                                ZONE=FACT(statut='o',
                                          max='**',
# -- Appariement
                                          APPARIEMENT     =SIMP(statut='f',typ='TXM',defaut="MAIT_ESCL",
                                                                into=("NODAL","MAIT_ESCL"),),
#
                                          regles=(UN_PARMI('GROUP_MA_ESCL','MAILLE_ESCL'),
                                                  UN_PARMI('GROUP_MA_MAIT','MAILLE_MAIT'),),
                                          GROUP_MA_MAIT   =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max=1),
                                          MAILLE_MAIT     =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
                                          GROUP_MA_ESCL   =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max=1),
                                          MAILLE_ESCL     =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
#
                                          NORMALE         =SIMP(statut='f',typ='TXM',defaut="MAIT",
                                                                into=("MAIT","MAIT_ESCL","ESCL"),),
#
                                          VECT_MAIT       =SIMP(statut='f',typ='TXM',defaut="AUTO",
                                                                into=("AUTO","FIXE","VECT_Y")),

                                          b_nmait_fixe=BLOC(condition = "VECT_MAIT == 'FIXE'",
                                            MAIT_FIXE     =SIMP(statut='o',typ='R',min=3,max=3),
                                            ),

                                          b_nmait_vecty=BLOC(condition = "VECT_MAIT == 'VECT_Y'",
                                            MAIT_VECT_Y   =SIMP(statut='o',typ='R',min=3,max=3),
                                            ),
#
                                          VECT_ESCL       =SIMP(statut='f',typ='TXM',defaut="AUTO",
                                                                into=("AUTO","FIXE","VECT_Y")),

                                          b_nescl_fixe=BLOC(condition = "VECT_ESCL == 'FIXE'",
                                            ESCL_FIXE     =SIMP(statut='o',typ='R',min=3,max=3),
                                            ),

                                          b_nescl_vecty=BLOC(condition = "VECT_ESCL == 'VECT_Y'",
                                            ESCL_VECT_Y   =SIMP(statut='o',typ='R',min=3,max=3),
                                            ),
#
                                          TYPE_APPA       =SIMP(statut='f',typ='TXM',defaut="PROCHE",
                                                           into  =("PROCHE","FIXE")),

                                          b_appa_fixe     =BLOC(condition = "TYPE_APPA == 'FIXE'",
                                            DIRE_APPA     =SIMP(statut='f',typ='R',min=3,max=3),
                                            ),
#
                                          DIST_POUTRE     =SIMP(statut='f',typ='TXM',defaut="NON", into=("OUI","NON")),
                                          DIST_COQUE      =SIMP(statut='f',typ='TXM',defaut="NON", into=("OUI","NON")),
                                          b_cara=BLOC(condition = "DIST_POUTRE == 'OUI' or DIST_COQUE == 'OUI'",
                                            CARA_ELEM     =SIMP(statut='o',typ=(cara_elem) ),
                                            ),

                                          DIST_MAIT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                          DIST_ESCL       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
#
                                          TOLE_APPA       =SIMP(statut='f',typ='R'  ,defaut=-1.0),
                                          TOLE_PROJ_EXT   =SIMP(statut='f',typ='R'  ,defaut=0.50),
# -- Incompatibilit avec CL
                                          SANS_NOEUD      =SIMP(statut='f',typ=no   ,validators=NoRepeat(),max='**'),
                                          SANS_GROUP_NO   =SIMP(statut='f',typ=grno ,validators=NoRepeat(),max='**'),
                                          SANS_MAILLE     =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
                                          SANS_GROUP_MA   =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max='**'),
# -- Mode sans calcul
                                          RESOLUTION      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
                                          b_verif=BLOC(condition = "RESOLUTION == 'NON' ",
                                            TOLE_INTERP   = SIMP(statut='f',typ='R',defaut = 0.),
                                            ),
# -- Rsolution
                                          ALGO_CONT       =SIMP(statut='o',typ='TXM',defaut="CONTRAINTE",
                                                                into=("CONTRAINTE","LAGRANGIEN","PENALISATION","GCP"),),

                                          b_active=BLOC(condition = "ALGO_CONT == 'CONTRAINTE' ",
                                                        fr="Paramtres de la mthode des contraintes actives (contact uniquement)",
                                                        GLISSIERE=SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON")),
                                                        b_glissiere=BLOC(condition = "GLISSIERE == 'OUI' ",
                                                                         ALARME_JEU  =SIMP(statut='f',typ='R',defaut=0.),
                                                                        ),
                                                        ),
#
                                          b_penal_contact=BLOC(condition = "ALGO_CONT == 'PENALISATION' ",
                                                               fr="Paramtres de la mthode pnalise (contact)",
                                                               E_N=SIMP(statut='o',typ='R'),
                                                               ),
#
                                          b_frottement=BLOC(condition = "FROTTEMENT == 'COULOMB' ",
                                                            fr="Paramtres du frottement de Coulomb",
                                                            COULOMB       =SIMP(statut='o',typ='R',),
                                                            COEF_MATR_FROT=SIMP(statut='f',typ='R',defaut=0.E+0),
                                                            ALGO_FROT     =SIMP(statut='o',typ='TXM',defaut="PENALISATION",
                                                                                into=("PENALISATION","LAGRANGIEN"),),
#
                                                            b_penal_frot=BLOC(condition = "ALGO_FROT == 'PENALISATION' ",
                                                                              fr="Paramtres de la mthode pnalise (frottement)",
                                                                              E_T=SIMP(statut='o',typ='R'),
                                                                              ),
                                                           ),
                                          ), #fin mot-cl facteur ZONE
                                ), #fin bloc b_affe_discret

# AFFECTATION - CAS CONTINUE

         b_affe_continue = BLOC(condition = "FORMULATION == 'CONTINUE'",
                                ZONE=FACT(statut='o',
                                          max='**',
# -- Appariement
                                          APPARIEMENT     =SIMP(statut='f',typ='TXM',defaut="MAIT_ESCL",
                                                                into=("MAIT_ESCL",)),
#
                                          regles=(UN_PARMI('GROUP_MA_ESCL','MAILLE_ESCL'),
                                                  UN_PARMI('GROUP_MA_MAIT','MAILLE_MAIT'),),
                                          GROUP_MA_MAIT   =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max=1),
                                          MAILLE_MAIT     =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
                                          GROUP_MA_ESCL   =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max=1),
                                          MAILLE_ESCL     =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
#
                                          NORMALE         =SIMP(statut='f',typ='TXM',defaut="MAIT",
                                                                into=("MAIT","MAIT_ESCL","ESCL"),),
#
                                          VECT_MAIT       =SIMP(statut='f',typ='TXM',defaut="AUTO",
                                                                into=("AUTO","FIXE","VECT_Y")),

                                          b_nmait_fixe=BLOC(condition = "VECT_MAIT == 'FIXE'",
                                            MAIT_FIXE     =SIMP(statut='o',typ='R',min=3,max=3),
                                            ),

                                          b_nmait_vecty=BLOC(condition = "VECT_MAIT == 'VECT_Y'",
                                            MAIT_VECT_Y   =SIMP(statut='o',typ='R',min=3,max=3),
                                            ),
#
                                          VECT_ESCL       =SIMP(statut='f',typ='TXM',defaut="AUTO",
                                                                into=("AUTO","FIXE","VECT_Y")),

                                          b_nescl_fixe=BLOC(condition = "VECT_ESCL == 'FIXE'",
                                            ESCL_FIXE     =SIMP(statut='o',typ='R',min=3,max=3),
                                            ),

                                          b_nescl_vecty=BLOC(condition = "VECT_ESCL == 'VECT_Y'",
                                            ESCL_VECT_Y   =SIMP(statut='o',typ='R',min=3,max=3),
                                            ),
#
                                          TYPE_APPA       =SIMP(statut='f',typ='TXM',defaut="PROCHE",
                                                           into  =("PROCHE","FIXE")),

                                          b_appa_fixe=BLOC(condition = "TYPE_APPA == 'FIXE'",
                                            DIRE_APPA     =SIMP(statut='f',typ='R',min=3,max=3),
                                            ),
#
                                          DIST_POUTRE     =SIMP(statut='f',typ='TXM',defaut="NON", into=("OUI","NON")),
                                          DIST_COQUE      =SIMP(statut='f',typ='TXM',defaut="NON", into=("OUI","NON")),
                                          b_cara=BLOC(condition = "DIST_POUTRE == 'OUI' or DIST_COQUE == 'OUI'",
                                            CARA_ELEM     =SIMP(statut='o',typ=(cara_elem) ),
                                            ),

                                          DIST_MAIT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                          DIST_ESCL       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
#
                                          TOLE_APPA       =SIMP(statut='f',typ='R'  ,defaut=-1.0),
                                          TOLE_PROJ_EXT   =SIMP(statut='f',typ='R'  ,defaut=0.50),
# -- Incompatibilit avec CL
                                          SANS_NOEUD      =SIMP(statut='f',typ=no   ,validators=NoRepeat(),max='**'),
                                          SANS_GROUP_NO   =SIMP(statut='f',typ=grno ,validators=NoRepeat(),max='**'),
                                          SANS_MAILLE     =SIMP(statut='f',typ=ma   ,validators=NoRepeat(),max='**'),
                                          SANS_GROUP_MA   =SIMP(statut='f',typ=grma ,validators=NoRepeat(),max='**'),
#
                                          FOND_FISSURE    =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON"),),
                                          b_fond_fissure  =BLOC(condition = "FOND_FISSURE == 'OUI' ",
                                                                fr="Traitement en fond de fissure",
                                          regles=(UN_PARMI('NOEUD_FOND','GROUP_NO_FOND','MAILLE_FOND','GROUP_MA_FOND'),),
                                          NOEUD_FOND    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                                          GROUP_NO_FOND =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                                          MAILLE_FOND   =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
                                          GROUP_MA_FOND =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                                                                ),
#
                                          RACCORD_LINE_QUAD=SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON"),),
                                          b_raccord_surf =BLOC(condition = "RACCORD_LINE_QUAD == 'OUI' ",
                                                               fr="Traitement du raccord surfacique",
                                                               regles=(UN_PARMI('NOEUD_RACC','GROUP_NO_RACC'),),
                                          NOEUD_RACC    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                                          GROUP_NO_RACC =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                                                               ),
#
                                          EXCLUSION_PIV_NUL=SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",),),
# -- Mode sans calcul
                                          RESOLUTION       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON")),
                                          b_verif=BLOC(condition = "RESOLUTION == 'NON' ",
                                                       TOLE_INTERP   = SIMP(statut='f',typ='R',defaut = 0.),
                                                       ),
# -- Fonctionnalits spcifiques 'CONTINUE'
                                          INTEGRATION     =SIMP(statut='f',typ='TXM',defaut="NOEUD",
                                                                 into=("GAUSS","NOEUD","SIMPSON","SIMPSON1","SIMPSON2",
                                                                                       "NCOTES" ,"NCOTES1" ,"NCOTES2"),),
#
                                          CONTACT_INIT    =SIMP(statut='f',typ='TXM',defaut="NON",
                                                                into=("OUI","INTERPENETRE","NON"),),
#
                                          GLISSIERE       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON"),),
#
                                          ALGO_CONT       =SIMP(statut='f',typ='TXM',defaut="STANDARD",
                                                                into=("STANDARD","AVANCE","PENALISATION"),),

                                          b_cont_std=BLOC(condition = "ALGO_CONT == 'STANDARD' ",
                                                          fr="Paramtres de la formulation Lagrangienne",
                                                          COEF_CONT = SIMP(statut='f',typ='R',defaut=100.E+0),
                                                          ),
                                          b_cont_avc=BLOC(condition = "ALGO_CONT == 'AVANCE' ",
                                                          fr="Paramtres du Lagrangien augment",
                                                          COEF_REGU_CONT=SIMP(statut='f',typ='R',defaut=100.E+0),
                                                          COEF_STAB_CONT=SIMP(statut='f',typ='R',defaut=100.E+0),
                                                          COEF_PENA_CONT=SIMP(statut='f',typ='R',defaut=100.E+0),
                                                          ),
                                          b_cont_pena=BLOC(condition = "ALGO_CONT == 'PENALISATION' ",
                                                            fr="Paramtres de la mthode pnalise",
                                                            COEF_PENA_CONT  =SIMP(statut='o',typ='R'),
                                                            ),
#
                                          COMPLIANCE      =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON",) ),
                                          b_compliance=BLOC(condition = "COMPLIANCE == 'OUI' ",
                                                            fr="Paramtres de la compliance",
                                                            ASPERITE = SIMP(statut='o',typ='R',),
                                                            E_N      = SIMP(statut='o',typ='R',),
                                                            E_V      = SIMP(statut='f',typ='R',defaut=0.E+0),
                                            ),
#
                                          b_frottement=BLOC(condition = "FROTTEMENT == 'COULOMB' ",
                                                            fr="Paramtres du frottement de Coulomb",
                                                            COULOMB    = SIMP(statut='o',typ='R',),
                                                            SEUIL_INIT = SIMP(statut='f',typ='R',defaut=0.E+0),
#
                                          regles=(EXCLUS('SANS_NOEUD_FR','SANS_GROUP_NO_FR'),),
                                          SANS_NOEUD_FR    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                                          SANS_GROUP_NO_FR =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                                                            b_sans_group_no_frot=BLOC(condition = " SANS_GROUP_NO_FR != None or \
                                                                                                    SANS_NOEUD_FR != None ",
                                                            fr="Direction de frottement  exclure (uniquement dans le cas 3D)",
                                                            DIRE_EXCL_FROT=SIMP(statut='f',typ='R',min=3,max=3),
                                                            ),

                                            ALGO_FROT       =SIMP(statut='f',typ='TXM',defaut="STANDARD",
                                                                  into=("STANDARD","AVANCE","PENALISATION"),),
                                            b_frot_std      =BLOC(condition = "ALGO_FROT == 'STANDARD' ",
                                                                  fr="Paramtres de la formulation Lagrangienne",
                                                                  COEF_FROT  =SIMP(statut='f',typ='R',defaut=100.E+0),
                                                                  ),
                                            b_frot_avc      =BLOC(condition = "ALGO_FROT == 'AVANCE' ",
                                                                  fr="Paramtres du Lagrangien augment",
                                                                  COEF_REGU_FROT  =SIMP(statut='f',typ='R',defaut=100.E+0),
                                                                  COEF_STAB_FROT  =SIMP(statut='f',typ='R',defaut=100.E+0),
                                                                  COEF_PENA_FROT  =SIMP(statut='f',typ='R',defaut=100.E+0),
                                                                  ),
                                            b_frot_pena     =BLOC(condition = "ALGO_FROT == 'PENALISATION' ",
                                                                  fr="Paramtres de la mthode pnalise",
                                                                  COEF_PENA_FROT  =SIMP(statut='o',typ='R'),
                                                                  ),
#
                                            USURE           =SIMP(statut='f',typ='TXM',defaut="SANS",into=("SANS","ARCHARD",),),
                                            b_usure         =BLOC(condition = "USURE == 'ARCHARD' ",
                                                                  fr="Parametres de la loi d'usure d'Archard",
                                                                  K =SIMP(statut='o',typ='R',),
                                                                  H =SIMP(statut='o',typ='R',val_min=1E-8),
                                                                  ),

                                            ), #fin bloc b_frottement
                                          ), #fin mot-cl facteur ZONE
                                ), #fin bloc b_affe_continue


# AFFECTATION - CAS XFEM

           b_affe_xfem =BLOC(condition = "FORMULATION == 'XFEM'",
                             ZONE=FACT(statut='o',
                                       max='**',
# -- Fissure
                                       FISS_MAIT      = SIMP(statut='o',typ=fiss_xfem,max=1),
                                       TOLE_PROJ_EXT   =SIMP(statut='f',typ='R'  ,defaut=0.50),

# -- Fonctionnalits spcifiques 'XFEM'
                                       INTEGRATION    = SIMP(statut='f',
                                                             typ='TXM',
                                                             defaut="FPG4",
                                                             into=("GAUSS","FPG2","FPG3","FPG4","FPG6","FPG7",
                                                                   "NOEUD","SIMPSON","SIMPSON1","NCOTES","NCOTES1","NCOTES2"),),


                                       RELATION       = SIMP(statut='f',typ='TXM',defaut="NON",
                                                             into=("CZM_EXP_REG","CZM_LIN_REG","NON"),),

                                       ALGO_LAGR      = SIMP(statut='f',typ='TXM',defaut="VERSION1",
                                                             into=("NON","VERSION1","VERSION2"),),
                                       COEF_ECHELLE   = SIMP(statut='f',typ='R',defaut=1.E+6),

                                       ALGO_CONT      = SIMP(statut='f',typ='TXM',defaut="STANDARD",
                                                                  into=("STANDARD","AVANCE","PENALISATION","CZM"),),
                                                                  
                                       b_cont_nczm =BLOC(condition = "ALGO_CONT!='CZM'",
                                                CONTACT_INIT   = SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON"),),
                                                GLISSIERE      = SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON"),),
                                                ),

                                       b_cont_std=BLOC(condition = "ALGO_CONT == 'STANDARD'",
                                                fr="Parametres de la formulation Lagrangienne",
                                                COEF_CONT    =SIMP(statut='f',typ='R',defaut=100.E+0),
                                                ),
             
                                       b_cont_avc=BLOC(condition = "ALGO_CONT == 'AVANCE' ",
                                                 fr="Parametres du Lagrangien augment",
                                                 COEF_REGU_CONT =SIMP(statut='f',typ='R',defaut=100.E+0),
                                                 COEF_STAB_CONT =SIMP(statut='f',typ='R',defaut=0.E+0),
                                                 COEF_PENA_CONT =SIMP(statut='f',typ='R',defaut=0.E+0),
                                                 ),

                                       b_cont_pen=BLOC(condition = "ALGO_CONT == 'PENALISATION' ",
                                                 fr="Paramtre de la mthode pnalise",
                                                 COEF_PENA_CONT =SIMP(statut='o',typ='R'),
                                                 ),

                                       b_frottement=BLOC(condition = "FROTTEMENT == 'COULOMB' and  ALGO_CONT != 'CZM' ",
                                                 fr="Paramtres du frottement",
                                                 COULOMB      =SIMP(statut='o',typ='R',),
                                                 SEUIL_INIT   =SIMP(statut='f',typ='R',defaut=0.E+0),
                                                 ALGO_FROT    =SIMP(statut='f',typ='TXM',defaut="STANDARD",
                                                                            into=("STANDARD","AVANCE","PENALISATION"),),

                                                 b_frot_std=BLOC(condition = "ALGO_FROT == 'STANDARD' ",
                                                                  fr="Parametres de la formulation Lagrangienne",
                                                                  COEF_FROT  =SIMP(statut='f',typ='R',defaut=100.E+0),
                                                                  ),
                                                 b_frot_avc=BLOC(condition = "ALGO_FROT == 'AVANCE' ",
                                                                  fr="Parametres du Lagrangien augment",
                                                                  COEF_REGU_FROT  =SIMP(statut='f',typ='R',defaut=100.E+0),
                                                                  COEF_STAB_FROT  =SIMP(statut='f',typ='R',defaut=0.E+0),
                                                                  COEF_PENA_FROT  =SIMP(statut='f',typ='R',defaut=0.E+0),
                                                                  ),
                                                 b_frot_pen=BLOC(condition = "ALGO_FROT == 'PENALISATION' ",
                                                                  fr="Paramtre de la mthode pnalise",
                                                                  COEF_PENA_FROT  =SIMP(statut='o',typ='R'),
                                                                  ),
                                                        ), #fin bloc b_frottement
                                       ), #fin mot-cl facteur ZONE
                             ), #fin bloc b_affe_xfem

                  ) #fin OPER
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE DESROCHES X.DESROCHES
DEFI_COQU_MULT=OPER(nom="DEFI_COQU_MULT",op=56,sd_prod=mater_sdaster,reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
                    fr="Dterminer les caractristiques matriaux homognises d'une coque multicouche  partir"
                        +" des caractristiques de chaque couche",
         COUCHE          =FACT(statut='o',max='**',
           EPAIS           =SIMP(statut='o',typ='R',val_min=0.E+0 ),
           MATER           =SIMP(statut='o',typ=(mater_sdaster) ),
           ORIENTATION     =SIMP(statut='f',typ='R',defaut= 0.E+0,
                                 val_min=-90.E+0,val_max=90.E+0   ),
         ),
         IMPRESSION      =FACT(statut='f',
           UNITE           =SIMP(statut='f',typ='I',defaut=8),
         ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE
def DEFIC_prod(self,ACTION,UNITE,**args):
  if ACTION == "ASSOCIER" or ACTION == "RESERVER":
    if UNITE != None :
      return
    else :
      return entier
  elif ACTION == "LIBERER"  :
    return
  else :
    raise AsException("ACTION non prevue : %s" % ACTION)

DEFI_FICHIER=MACRO(nom="DEFI_FICHIER",op=ops.build_DEFI_FICHIER,sd_prod=DEFIC_prod,reentrant='n',
                  UIinfo={"groupes":("Gestion du travail",)},
                  fr="Ouvre ou ferme un fichier associ  un numro d'unit logique",

            ACTION        =SIMP(statut='f',typ='TXM',into=("ASSOCIER","LIBERER","RESERVER"),defaut="ASSOCIER"),

            b_associer    =BLOC(condition = "ACTION == 'ASSOCIER'",
                                fr="Paramtres pour l'ouverture du fichier",
                                regles=(AU_MOINS_UN('FICHIER','UNITE'),),
               UNITE      =SIMP(statut='f',typ='I' ,val_min=1),
               FICHIER    =SIMP(statut='f',typ='TXM',validators=LongStr(1,255)),
               TYPE       =SIMP(statut='f',typ='TXM',into=("ASCII","BINARY","LIBRE"),defaut="ASCII"),

               b_type_ascii  =BLOC(condition = "TYPE == 'ASCII'",fr="Paramtres pour le type ASCII",
                  ACCES      =SIMP(statut='f',typ='TXM',into=("NEW","APPEND","OLD"),defaut="NEW"),
               ),
               b_type_autre  =BLOC(condition = "TYPE != 'ASCII'",fr="Paramtres pour les types BINARY et LIBRE",
                  ACCES      =SIMP(statut='f',typ='TXM',into=("NEW","OLD"),defaut="NEW"),
               ),
            ),

            b_reserver    =BLOC(condition = "ACTION == 'RESERVER'",
                                fr="Paramtres pour la rservation de l'unit du fichier",
                                regles=(AU_MOINS_UN('FICHIER','UNITE'),),
               UNITE      =SIMP(statut='f',typ='I' ,val_min=1),
               FICHIER    =SIMP(statut='f',typ='TXM',validators=LongStr(1,255)),
               TYPE       =SIMP(statut='f',typ='TXM',into=("ASCII",),defaut="ASCII"),
               ACCES      =SIMP(statut='f',typ='TXM',into=("APPEND",),defaut="APPEND"),
            ),

            b_liberer    =BLOC(condition = "ACTION == 'LIBERER'",
                               fr="Paramtres pour la fermeture du fichier",
                               regles=(UN_PARMI('FICHIER','UNITE'),),
                  UNITE         =SIMP(statut='f',typ='I' ,val_min=1),
                  FICHIER   =SIMP(statut='f',typ='TXM',validators=LongStr(1,255)),
           ),

           INFO          =SIMP(statut='f',typ='I',into=(1,2) ),
           )
#& MODIF COMMANDE  DATE 05/07/2011   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE GENIAUT S.GENIAUT

DEFI_FISS_XFEM=OPER(nom="DEFI_FISS_XFEM",op=  41,sd_prod=fiss_xfem,reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
               fr="Dfinition des caratristiques d'une fissure ou d'une interface avec X-FEM",
            regles = EXCLUS('MODELE_GRILLE','FISS_GRILLE'),

# ------------------------------------------------------------------------------------------------------------------------
#                       modele sous-jacent
# ------------------------------------------------------------------------------------------------------------------------

    MODELE                =SIMP(statut='o',typ=modele_sdaster),

# ------------------------------------------------------------------------------------------------------------------------
#                       grille auxiliaire
# ------------------------------------------------------------------------------------------------------------------------

    MODELE_GRILLE         =SIMP(statut='f',typ=modele_sdaster,max=1,position='global'),
    FISS_GRILLE           =SIMP(statut='f',typ=fiss_xfem,max=1),

# ------------------------------------------------------------------------------------------------------------------------
#                       fissure/interface
# ------------------------------------------------------------------------------------------------------------------------

      TYPE_DISCONTINUITE  =SIMP(statut='f',typ='TXM',into=("FISSURE","INTERFACE",) ,defaut="FISSURE",position='global'),

# ------------------------------------------------------------------------------------------------------------------------
#                       caracteristiques de la fissure/interface
# ------------------------------------------------------------------------------------------------------------------------

    DEFI_FISS             =FACT(statut='o',max=1,

      regles              =UN_PARMI('GROUP_MA_FISS','FONC_LN','FORM_FISS','CHAM_NO_LSN'),

# impossible de faire des regles dans des blocs condition, dommage
#       b_fissure           =BLOC(condition = "TYPE_DISCONTINUITE == 'FISSURE' ",fr="Regles pour les fissures",
#                 regles    =(ENSEMBLE('FONC_LN','FONC_LT'),
#                             ENSEMBLE('CHAM_NO_LSN','CHAM_NO_LST'),
#                             ENSEMBLE('GROUP_MA_FISS','GROUP_MA_FOND')),
#                                ),
# 
#       b_interface           =BLOC(condition = "TYPE_DISCONTINUITE == 'INTERFACE' ",fr="Regles pour les interfaces",
#                 regles    =(PRESENT_ABSENT('FONC_LN','FONC_LT'),
#                             PRESENT_ABSENT('CHAM_NO_LSN','CHAM_NO_LST'),
#                             PRESENT_ABSENT('GROUP_MA_FISS','GROUP_MA_FOND')),
#                                ),

      FONC_LT             =SIMP(statut='f',typ=(fonction_sdaster,formule) ),
      FONC_LN             =SIMP(statut='f',typ=(fonction_sdaster,formule) ),
      CHAM_NO_LSN         =SIMP(statut='f',typ=cham_no_sdaster,min=1,max=1),
      CHAM_NO_LST         =SIMP(statut='f',typ=cham_no_sdaster,min=1,max=1),
      GROUP_MA_FISS       =SIMP(statut='f',typ=grma,min=1,max=1),
      GROUP_MA_FOND       =SIMP(statut='f',typ=grma,min=1,max=1),
      FORM_FISS   =SIMP(statut='f',typ='TXM',into=("ELLIPSE","RECTANGLE","CYLINDRE","DEMI_PLAN",
                                                   "SEGMENT","DEMI_DROITE","INCLUSION","DROITE") ),
      b_ellipse           =BLOC(condition = "FORM_FISS == 'ELLIPSE' ",fr="Paramtres de la fissure elliptique",
           DEMI_GRAND_AXE =SIMP(statut='o',typ='R',val_min=0.),
           DEMI_PETIT_AXE =SIMP(statut='o',typ='R',val_min=0.),
           CENTRE         =SIMP(statut='o',typ='R',min=3,max=3),
           VECT_X         =SIMP(statut='o',typ='R',min=3,max=3),
           VECT_Y         =SIMP(statut='o',typ='R',min=3,max=3),
           COTE_FISS      =SIMP(statut='f',typ='TXM',defaut="IN",into=("IN","OUT",) ),    ),
      b_rectangle         =BLOC(condition = "FORM_FISS == 'RECTANGLE' ",fr="Paramtres de la fissure rectangulaire",
           DEMI_GRAND_AXE =SIMP(statut='o',typ='R',val_min=0.),
           DEMI_PETIT_AXE =SIMP(statut='o',typ='R',val_min=0.),
           RAYON_CONGE    =SIMP(statut='f',typ='R',val_min=0.,defaut=0.),
           CENTRE         =SIMP(statut='o',typ='R',min=3,max=3),
           VECT_X         =SIMP(statut='o',typ='R',min=3,max=3),
           VECT_Y         =SIMP(statut='o',typ='R',min=3,max=3),
           COTE_FISS      =SIMP(statut='f',typ='TXM',defaut="IN",into=("IN","OUT",) ),    ),
      b_cylindre          =BLOC(condition = "FORM_FISS == 'CYLINDRE' ",fr="Paramtres de la fissure cylindrique",
           DEMI_GRAND_AXE =SIMP(statut='o',typ='R',val_min=0.),
           DEMI_PETIT_AXE =SIMP(statut='o',typ='R',val_min=0.),
           CENTRE         =SIMP(statut='o',typ='R',min=3,max=3),
           VECT_X         =SIMP(statut='o',typ='R',min=3,max=3),
           VECT_Y         =SIMP(statut='o',typ='R',min=3,max=3),),
      b_demiplan          =BLOC(condition = "FORM_FISS == 'DEMI_PLAN' ",fr="Paramtres de la fissure plane  front droit",
           PFON           =SIMP(statut='o',typ='R',min=3,max=3),
           NORMALE        =SIMP(statut='o',typ='R',min=3,max=3),
           DTAN           =SIMP(statut='o',typ='R',min=3,max=3),),
      b_segment           =BLOC(condition = "FORM_FISS == 'SEGMENT' ",fr="Paramtres de la fissure 2D segment",
           PFON_ORIG      =SIMP(statut='o',typ='R',min=3,max=3),
           PFON_EXTR      =SIMP(statut='o',typ='R',min=3,max=3),),
      b_demidroite         =BLOC(condition = "FORM_FISS == 'DEMI_DROITE' ",fr="Paramtres de la fissure 2D demi-droite",
           PFON           =SIMP(statut='o',typ='R',min=3,max=3),
           DTAN           =SIMP(statut='o',typ='R',min=3,max=3),),
      b_droite            =BLOC(condition = "FORM_FISS == 'DROITE' ",fr="Paramtres de l'interface 2D (fissure traversante)",
           POINT          =SIMP(statut='o',typ='R',min=3,max=3),
           DTAN           =SIMP(statut='o',typ='R',min=3,max=3),),
      b_inclusion         =BLOC(condition = "FORM_FISS == 'INCLUSION' ",fr="Paramtres de l'interface 2D (inclusion)",
           DEMI_GRAND_AXE =SIMP(statut='o',typ='R',val_min=0.),
           DEMI_PETIT_AXE =SIMP(statut='o',typ='R',val_min=0.),
           CENTRE         =SIMP(statut='o',typ='R',min=3,max=3),
           VECT_X         =SIMP(statut='o',typ='R',min=3,max=3),
           VECT_Y         =SIMP(statut='o',typ='R',min=3,max=3),),
                            ),

# ------------------------------------------------------------------------------------------------------------------------
#                       partie du maillage potentiellement enrichie
# ------------------------------------------------------------------------------------------------------------------------

    GROUP_MA_ENRI         =SIMP(statut='f',typ=grma,max=01),

# ------------------------------------------------------------------------------------------------------------------------
#                       types d'enrichissement 
# ------------------------------------------------------------------------------------------------------------------------

    b_enri_inte           =BLOC(condition = "TYPE_DISCONTINUITE == 'INTERFACE' ",

      CHAM_DISCONTINUITE  =SIMP(statut='f',typ='TXM',into=("DEPL","SIGM"),defaut="DEPL" ),

                          ),


    b_enri_fiss           =BLOC(condition = "TYPE_DISCONTINUITE == 'FISSURE' ",

      CHAM_DISCONTINUITE  =SIMP(statut='f',typ='TXM',into=("DEPL",),defaut="DEPL" ),
      TYPE_ENRI_FOND      =SIMP(statut='f',typ='TXM',into=("TOPOLOGIQUE","GEOMETRIQUE"),defaut="TOPOLOGIQUE" ),

        b_enri_geom       =BLOC(condition = "TYPE_ENRI_FOND == 'GEOMETRIQUE' ",fr="Paramtres de l enrichissement geometrique",
           RAYON_ENRI     =SIMP(statut='f',typ='R',val_min=0.E+0),

          b_enri_couches  =BLOC(condition = "(RAYON_ENRI == None) ",fr="Paramtres de l enrichissement  n couches",
           NB_COUCHES     =SIMP(statut='f',typ='I',defaut=4,val_min=1),

                               ),
                             ),                        
                          ),

# ------------------------------------------------------------------------------------------------------------------------
#                       orientation du fond de fissure
# ------------------------------------------------------------------------------------------------------------------------

    b_orie_fond           =BLOC(condition = "TYPE_DISCONTINUITE == 'FISSURE' ",

    ORIE_FOND             =FACT(statut='f',max=1,
      PFON_INI            =SIMP(statut='o',typ='R',max=3),
      VECT_ORIE           =SIMP(statut='o',typ='R',max=3),
      POINT_ORIG          =SIMP(statut='o',typ='R',max=3),
                               ),

                             ),

# ------------------------------------------------------------------------------------------------------------------------
#                       branchement
# ------------------------------------------------------------------------------------------------------------------------

    b_jonction            =BLOC(condition = "(MODELE_GRILLE == None) and (FISS_GRILLE == None)",
        JONCTION              =FACT(statut='f',max=1,
          FISSURE             =SIMP(statut='o',typ=fiss_xfem,min=1,max='**',),
          POINT               =SIMP(statut='o',typ='R',max=3,),
                                   ),
                               ),
# ------------------------------------------------------------------------------------------------------------------------
#                       info
# ------------------------------------------------------------------------------------------------------------------------

    INFO                  =SIMP(statut='f',typ='I',defaut= 1,into=(1,2,3,) ),

)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ADOBES A.ADOBES
DEFI_FLUI_STRU=OPER(nom="DEFI_FLUI_STRU",op= 143,sd_prod=type_flui_stru,
                    reentrant='n',fr="Dfinit les caractristiques ncessaires  l'tude dynamique d'une structure sous coulement",
            UIinfo={"groupes":("Modlisation",)},
         regles=(  UN_PARMI('FAISCEAU_TRANS','GRAPPE','FAISCEAU_AXIAL','COQUE_COAX',),),
         FAISCEAU_TRANS  =FACT(statut='f',max='**',
           regles=(  ENSEMBLE('CSTE_CONNORS','NB_CONNORS','RHO_TUBE'),),
           COUPLAGE        =SIMP(statut='f',typ='TXM',into=("OUI","NON") ),
           CARA_ELEM       =SIMP(statut='f',typ=cara_elem ),
           PROF_VITE_FLUI  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PROF_RHO_F_INT  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PROF_RHO_F_EXT  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           NOM_CMP         =SIMP(statut='f',typ='TXM',into=("DX","DY","DZ") ),
           COEF_MASS_AJOU  =SIMP(statut='f',typ='R' ),
           TYPE_PAS        =SIMP(statut='f',typ='TXM',into=("CARRE_LIGN","TRIA_LIGN") ),
           TYPE_RESEAU     =SIMP(statut='f',typ='I' ),
           UNITE_CD        =SIMP(statut='f',typ='I',defaut=70),
           UNITE_CK        =SIMP(statut='f',typ='I',defaut=71),
           PAS             =SIMP(statut='f',typ='R' ),
           CSTE_CONNORS    =SIMP(statut='f',typ='R',min=2,max=2,val_min=0.E+00),
           NB_CONNORS      =SIMP(statut='f',typ='I',val_min=2,),
           RHO_TUBE        =SIMP(statut='f',typ='R' ),
         ),
         GRAPPE          =FACT(statut='f',
           regles=(ENSEMBLE('GRAPPE_2','NOEUD','CARA_ELEM','MODELE','RHO_FLUI',),
                   PRESENT_PRESENT('COEF_MASS_AJOU','GRAPPE_2', ),),
#  peut on crer un bloc a partir de la valeur de couplage
           COUPLAGE        =SIMP(statut='o',typ='TXM',into=("OUI","NON") ),
           GRAPPE_2        =SIMP(statut='f',typ='TXM',
                                 into=("ASC_CEN","ASC_EXC","DES_CEN","DES_EXC") ),
           NOEUD           =SIMP(statut='f',typ=no),
           CARA_ELEM       =SIMP(statut='f',typ=cara_elem ),
           MODELE          =SIMP(statut='f',typ=modele_sdaster ),
           COEF_MASS_AJOU  =SIMP(statut='f',typ='R' ),
           RHO_FLUI        =SIMP(statut='f',typ='R' ),
           UNITE_CA        =SIMP(statut='f',typ='I',defaut=70),
           UNITE_KA        =SIMP(statut='f',typ='I',defaut=71),
         ),
         FAISCEAU_AXIAL  =FACT(statut='f',max='**',
           regles=(UN_PARMI('GROUP_MA','TRI_GROUP_MA'),
                   UN_PARMI('CARA_ELEM','RAYON_TUBE'),
                   ENSEMBLE('RAYON_TUBE','COOR_TUBE'),
                   PRESENT_ABSENT('RAYON_TUBE','TRI_GROUP_MA'),
                   ENSEMBLE('CARA_PAROI','VALE_PAROI'),
                   ENSEMBLE('LONG_TYPG','LARG_TYPG','EPAI_TYPG','RUGO_TYPG','COEF_TRAI_TYPG','COEF_DPOR_TYPG',
                            'COOR_GRILLE','TYPE_GRILLE', ),),
#  on doit pouvoir mettre des blocs conditionnels mais pas assez d infos pour le faire
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           TRI_GROUP_MA    =SIMP(statut='f',typ='TXM' ),
           VECT_X          =SIMP(statut='f',typ='R',max=3),
           PROF_RHO_FLUI   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           PROF_VISC_CINE  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           CARA_ELEM       =SIMP(statut='f',typ=cara_elem ),
           RAYON_TUBE      =SIMP(statut='f',typ='R' ),
           COOR_TUBE       =SIMP(statut='f',typ='R',max='**'),
           PESANTEUR       =SIMP(statut='f',typ='R',min=4,max=4),
           RUGO_TUBE       =SIMP(statut='f',typ='R' ),
           CARA_PAROI      =SIMP(statut='f',typ='TXM',validators=NoRepeat(),max=5,
                                 into=("YC","ZC","R","HY","HZ") ),
           VALE_PAROI      =SIMP(statut='f',typ='R',max=5),
           ANGL_VRIL       =SIMP(statut='f',typ='R' ),
           LONG_TYPG       =SIMP(statut='f',typ='R',max='**',val_min=0.E+0),
           LARG_TYPG       =SIMP(statut='f',typ='R',max='**',val_min=0.E+0),
           EPAI_TYPG       =SIMP(statut='f',typ='R',max='**',val_min=0.E+0),
           RUGO_TYPG       =SIMP(statut='f',typ='R',max='**',val_min=0.E+0),
           COEF_TRAI_TYPG  =SIMP(statut='f',typ='R',max='**',val_min=0.E+0),
           COEF_DPOR_TYPG  =SIMP(statut='f',typ='R',max='**'),
           COOR_GRILLE     =SIMP(statut='f',typ='R',max='**'),
           TYPE_GRILLE     =SIMP(statut='f',typ='I',max='**'),
         ),
         COQUE_COAX      =FACT(statut='f',
           MASS_AJOU       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           GROUP_MA_INT    =SIMP(statut='o',typ=grma),
           GROUP_MA_EXT    =SIMP(statut='o',typ=grma),
           VECT_X          =SIMP(statut='o',typ='R',max='**'),
           CARA_ELEM       =SIMP(statut='o',typ=cara_elem ),
           MATER_INT       =SIMP(statut='o',typ=mater_sdaster ),
           MATER_EXT       =SIMP(statut='o',typ=mater_sdaster ),
           RHO_FLUI        =SIMP(statut='o',typ='R' ),
           VISC_CINE       =SIMP(statut='o',typ='R' ),
           RUGOSITE        =SIMP(statut='o',typ='R' ),
           PDC_MOY_1       =SIMP(statut='o',typ='R' ),
           PDC_DYN_1       =SIMP(statut='o',typ='R' ),
           PDC_MOY_2       =SIMP(statut='o',typ='R' ),
           PDC_DYN_2       =SIMP(statut='o',typ='R' ),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PEYRARD C.PEYRARD

from Macro.defi_fonc_elec_ops import defi_fonc_elec_ops

DEFI_FONC_ELEC=MACRO(nom="DEFI_FONC_ELEC",op=defi_fonc_elec_ops,sd_prod=fonction_sdaster,reentrant='n',
            UIinfo={"groupes":("Outils-mtier",)},
                    fr="Dfinir une fonction du temps intervenant dans le calcul des forces de LAPLACE",
      regles=(UN_PARMI('COUR_PRIN','COUR'),
              EXCLUS('COUR','COUR_SECO'), ),
         FREQ            =SIMP(statut='f',typ='R',defaut= 50.),
         SIGNAL          =SIMP(statut='f',typ='TXM',defaut="COMPLET",into=("COMPLET","CONTINU") ),
         COUR            =FACT(statut='f',max='**',
         fr="Dfinition du courant de court-circuit",
           regles=(UN_PARMI('PHI_CC_1','INTC_CC_1'),
                   UN_PARMI('PHI_CC_2','INTC_CC_2'),),
           INTE_CC_1       =SIMP(statut='o',typ='R'),
           TAU_CC_1        =SIMP(statut='o',typ='R'),
           PHI_CC_1        =SIMP(statut='f',typ='R'),
           INTC_CC_1       =SIMP(statut='f',typ='R'),
           INTE_CC_2       =SIMP(statut='o',typ='R'),
           TAU_CC_2        =SIMP(statut='o',typ='R'),
           PHI_CC_2        =SIMP(statut='f',typ='R'),
           INTC_CC_2       =SIMP(statut='f',typ='R'),
           INST_CC_INIT    =SIMP(statut='o',typ='R'),
           INST_CC_FIN     =SIMP(statut='o',typ='R'),
         ),
         COUR_PRIN       =FACT(statut='f',
         fr="Dfinition du courant de court-circuit avec renclenchement",
           regles=(UN_PARMI('PHI_CC_1','INTC_CC_1'),),
           INTE_CC_1       =SIMP(statut='o',typ='R'),
           TAU_CC_1        =SIMP(statut='o',typ='R'),
           PHI_CC_1        =SIMP(statut='f',typ='R'),
           INTC_CC_1       =SIMP(statut='f',typ='R'),
           INTE_RENC_1     =SIMP(statut='f',typ='R'),
           TAU_RENC_1      =SIMP(statut='f',typ='R'),
           PHI_RENC_1      =SIMP(statut='f',typ='R'),
           INST_CC_INIT    =SIMP(statut='o',typ='R'),
           INST_CC_FIN     =SIMP(statut='o',typ='R'),
           INST_RENC_INIT  =SIMP(statut='f',typ='R',defaut= 0.0E+0),
           INST_RENC_FIN   =SIMP(statut='f',typ='R',defaut= 0.0E+0),
         ),
         COUR_SECO       =FACT(statut='f',max='**',
         fr="Dfinition du courant de court-circuit avec un intervalle de temps diffrent de celui de COUR_PRIN",
           regles=(UN_PARMI('PHI_CC_2','INTC_CC_2'),),
           INTE_CC_2       =SIMP(statut='o',typ='R'),
           TAU_CC_2        =SIMP(statut='o',typ='R'),
           PHI_CC_2        =SIMP(statut='f',typ='R'),
           INTC_CC_2       =SIMP(statut='f',typ='R'),
           INTE_RENC_2     =SIMP(statut='f',typ='R'),
           TAU_RENC_2      =SIMP(statut='f',typ='R'),
           PHI_RENC_2      =SIMP(statut='f',typ='R'),
           DIST            =SIMP(statut='f',typ='R',defaut=1.0E+0),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
)
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ADOBES A.ADOBES
DEFI_FONC_FLUI=OPER(nom="DEFI_FONC_FLUI",op= 142,sd_prod=fonction_sdaster,
                    reentrant='n',
            fr="Dfinit un profil de vitesse d'coulement fluide le long d'une poutre",
            UIinfo={"groupes":("Modlisation","Fonctions",)},
         MAILLAGE        =SIMP(statut='o',typ=(maillage_sdaster) ),
         NOEUD_INIT      =SIMP(statut='o',typ=no),
         NOEUD_FIN       =SIMP(statut='o',typ=no),
         VITE            =FACT(statut='o',
           VALE            =SIMP(statut='f',typ='R',defaut= 1. ),
           PROFIL          =SIMP(statut='o',typ='TXM',into=("UNIFORME","LEONARD") ),
           NB_BAV          =SIMP(statut='f',typ='I',defaut= 0,into=( 0 , 2 , 3 ) ),
         ),
         INTERPOL        =SIMP(statut='f',typ='TXM',max=2,defaut="LIN",
                               into=("NON","LIN","LOG") ),
         PROL_DROITE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",
                               into=("CONSTANT","LINEAIRE","EXCLU") ),
         PROL_GAUCHE     =SIMP(statut='f',typ='TXM' ,defaut="EXCLU",
                               into=("CONSTANT","LINEAIRE","EXCLU") ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2 ) ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS
def defi_fonction_prod(VALE,VALE_PARA,VALE_C,NOEUD_PARA,ABSCISSE,**args):
  if VALE       != None  : return fonction_sdaster
  if VALE_C     != None  : return fonction_c
  if VALE_PARA  != None  : return fonction_sdaster
  if ABSCISSE   != None  : return fonction_sdaster
  if NOEUD_PARA != None  : return fonction_sdaster
  raise AsException("type de concept resultat non prevu")

DEFI_FONCTION=OPER(nom="DEFI_FONCTION",op=3,sd_prod=defi_fonction_prod
                    ,fr="Dfinit une fonction relle ou complexe d'une variable relle",
                     reentrant='n',
            UIinfo={"groupes":("Fonctions",)},
         regles=(UN_PARMI('VALE','VALE_C','VALE_PARA','NOEUD_PARA','ABSCISSE'),),
         NOM_PARA        =SIMP(statut='o',typ='TXM',into=C_PARA_FONCTION() ),
         NOM_RESU        =SIMP(statut='f',typ='TXM',defaut="TOUTRESU"),
         VALE            =SIMP(statut='f',typ='R',min=2,max='**',
                               fr ="Fonction relle dfinie par une liste de couples (abscisse,ordonne)"),
         ABSCISSE        =SIMP(statut='f',typ='R',min=2,max='**',
                               fr ="Liste d abscisses d une fonction relle"),
         VALE_C          =SIMP(statut='f',typ='R',min=2,max='**',
                               fr ="Fonction complexe dfinie par une liste de couples"),
         VALE_PARA       =SIMP(statut='f',typ=listr8_sdaster,
                               fr ="Fonction relle dfinie par deux concepts de type listr8" ),
         b_vale_para     =BLOC(condition = "VALE_PARA != None",
           VALE_FONC       =SIMP(statut='o',typ=listr8_sdaster ),
         ),
         b_abscisse      =BLOC(condition = "ABSCISSE != None",
           ORDONNEE        =SIMP(statut='o',typ='R',min=2,max='**',
                               fr ="Liste d ordonnes d une fonction relle"),
         ),
         NOEUD_PARA      =SIMP(statut='f',typ=no,max='**',
                               fr ="Fonction relle dfinie par une liste de noeuds et un maillage"),
         b_noeud_para    =BLOC(condition = "NOEUD_PARA != None",
           MAILLAGE        =SIMP(statut='o',typ=maillage_sdaster ),
           VALE_Y          =SIMP(statut='o',typ='R',max='**'),
         ),

         INTERPOL        =SIMP(statut='f',typ='TXM',max=2,defaut="LIN",into=("NON","LIN","LOG") ),
         PROL_DROITE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
         PROL_GAUCHE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
         VERIF           =SIMP(statut='f',typ='TXM',defaut="CROISSANT",into=("CROISSANT","NON") ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 04/05/2011   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE GALENNE E.GALENNE
DEFI_FOND_FISS=OPER(nom="DEFI_FOND_FISS",op=55,sd_prod=fond_fiss,reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
                    fr="Dfinition de lvres et d'un fond de fissure en 3D",
         regles=(UN_PARMI('FOND_FISS','FOND_FERME','FOND_INF'),
                 EXCLUS('FOND_FERME','DTAN_ORIG'),
                 EXCLUS('FOND_FERME','DTAN_EXTR'),
                      EXCLUS('FOND_FERME','VECT_GRNO_ORIG'),
                      EXCLUS('FOND_FERME','VECT_GRNO_EXTR'),
                 UN_PARMI('LEVRE_SUP','NORMALE'),
                      EXCLUS('LEVRE_INF','NORMALE'),
                 ENSEMBLE('DTAN_ORIG','DTAN_EXTR'),
                 ENSEMBLE('FOND_SUP','FOND_INF'),
                 EXCLUS('FOND_INF','FOND_FISS'),
                 EXCLUS('FOND_INF','FOND_FERME'),
                      ENSEMBLE('VECT_GRNO_ORIG','VECT_GRNO_EXTR'),
                      EXCLUS('DTAN_ORIG','VECT_GRNO_ORIG'),
                      EXCLUS('DTAN_EXTR','VECT_GRNO_EXTR') ,),
           MAILLAGE        =SIMP(statut='o',typ=maillage_sdaster ),
           FOND_FISS       =FACT(statut='f',
             regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),
                     EXCLUS('NOEUD_ORIG','GROUP_NO_ORIG'),
                          EXCLUS('NOEUD_EXTR','GROUP_NO_EXTR'),),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
#   mettre  jour le max vaut-il 1
             NOEUD_ORIG      =SIMP(statut='f',typ=no,),
             GROUP_NO_ORIG   =SIMP(statut='f',typ=grno,),
             NOEUD_EXTR      =SIMP(statut='f',typ=no,),
             GROUP_NO_EXTR   =SIMP(statut='f',typ=grno,),
           ),
           FOND_FERME      =FACT(statut='f',
             regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),
                          EXCLUS('NOEUD_ORIG','GROUP_NO_ORIG'),),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             NOEUD_ORIG      =SIMP(statut='f',typ=no,),
             GROUP_NO_ORIG   =SIMP(statut='f',typ=grno,),
             MAILLE_ORIG     =SIMP(statut='f',typ=ma,),
             GROUP_MA_ORIG   =SIMP(statut='f',typ=grma,),
           ),
           FOND_INF       =FACT(statut='f',
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             NOEUD_ORIG      =SIMP(statut='f',typ=no,),
             GROUP_NO_ORIG   =SIMP(statut='f',typ=grno,),
             NOEUD_EXTR      =SIMP(statut='f',typ=no,),
             GROUP_NO_EXTR   =SIMP(statut='f',typ=grno,),
           ),
           FOND_SUP       =FACT(statut='f',
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             NOEUD_ORIG      =SIMP(statut='f',typ=no,),
             GROUP_NO_ORIG   =SIMP(statut='f',typ=grno,),
             NOEUD_EXTR      =SIMP(statut='f',typ=no,),
             GROUP_NO_EXTR   =SIMP(statut='f',typ=grno,),
           ),
           LEVRE_SUP       =FACT(statut='f',
             regles=(UN_PARMI('GROUP_MA','MAILLE'),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           ),
           LEVRE_INF       =FACT(statut='f',
             regles=(UN_PARMI('GROUP_MA','MAILLE', ),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           ),
           NORMALE         =SIMP(statut='f',typ='R',max='**'),
           PREC_NORM       =SIMP(statut='f',typ='R',defaut=0.1),
           DTAN_ORIG       =SIMP(statut='f',typ='R',max='**'),
           DTAN_EXTR       =SIMP(statut='f',typ='R',max='**'),
           VECT_GRNO_ORIG  =SIMP(statut='f',typ=grno,validators=NoRepeat(),max=2),
           VECT_GRNO_EXTR  =SIMP(statut='f',typ=grno,validators=NoRepeat(),max=2),
           INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2007  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE FLEJOU J.L.FLEJOU
#
DEFI_GEOM_FIBRE=OPER(nom="DEFI_GEOM_FIBRE",op=  119, sd_prod=gfibre_sdaster,
                    fr="Definition des groupes de fibres pour les elements multifibres",
                    reentrant='n',
            UIinfo={"groupes":("Modlisation",)},
         regles=(AU_MOINS_UN('SECTION','FIBRE'),),

         INFO       =SIMP(statut='f',typ='I', defaut= 1 ,into=(1,2) ),
#============================================================================
         SECTION     =FACT(statut='f',max='**',
              regles=(AU_MOINS_UN('TOUT_SECT','GROUP_MA_SECT','MAILLE_SECT'),
                      PRESENT_ABSENT('TOUT_SECT','GROUP_MA_SECT','MAILLE_SECT'),),

              GROUP_FIBRE       =SIMP(statut='o',typ='TXM',min=1,max=1),
              TOUT_SECT         =SIMP(statut='f',typ='TXM',into=("OUI",) ),
              GROUP_MA_SECT     =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_SECT       =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),

              MAILLAGE_SECT     =SIMP(statut='o',typ=maillage_sdaster),
              COOR_AXE_POUTRE   =SIMP(statut='o',typ='R',min=2,max=2),
         ),


#============================================================================
         FIBRE     =FACT(statut='f',max='**',
              GROUP_FIBRE       =SIMP(statut='o',typ='TXM',min=1,max=1),
              CARA              =SIMP(statut='f',typ='TXM',defaut='SURFACE',into=('SURFACE','DIAMETRE',)),
              VALE              =SIMP(statut='o',typ='R',max='**'),
              COOR_AXE_POUTRE   =SIMP(statut='o',typ='R',min=2,max=2),
          ),


) ;
#& MODIF COMMANDE  DATE 11/01/2011   AUTEUR SFAYOLLE S.FAYOLLE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE SFAYOLLE S.FAYOLLE
DEFI_GLRC=OPER(nom="DEFI_GLRC",op=57,sd_prod=mater_sdaster,reentrant='f',
               UIinfo={"groupes":("Modlisation",)},
               fr="Dterminer les caractristiques homogenises du bton arm  partir des proprits du bton et des  "
                        +" armatures",
               reuse = SIMP(statut='f',typ=mater_sdaster),
               RELATION = SIMP(statut='o',typ='TXM',defaut="GLRC_DAMAGE",
                          into=("GLRC_DM","GLRC_DAMAGE"),),

               b_glrc_dm=BLOC(condition = "RELATION == 'GLRC_DM'",
                              fr="Paramtres de la loi GLRC_DM",
                              BETON = FACT(statut='o',max=1,
                                MATER = SIMP(statut='o',typ=(mater_sdaster),),
                                EPAIS = SIMP(statut='o',typ='R',val_min=0.E+0 ),),
                              NAPPE = FACT(statut='o',max=1,
                                MATER = SIMP(statut='o',typ=(mater_sdaster),),
                                OMY   = SIMP(statut='o',typ='R',val_min=0.E+0,),
                                OMX   = SIMP(statut='o',typ='R',val_min=0.E+0,),
                                RY    = SIMP(statut='o',typ='R',val_min=-1.0E+0,val_max=1.0E+0,),
                                RX    = SIMP(statut='o',typ='R',val_min=-1.0E+0,val_max=1.0E+0),),
                              RHO = SIMP(statut='f',typ='R',val_min=0.E+0,),
                              AMOR_ALPHA = SIMP(statut='f',typ='R',val_min=0.E+0,),
                              AMOR_BETA = SIMP(statut='f',typ='R',val_min=0.E+0,),
                              COMPR = SIMP(statut='o',typ='TXM',defaut="GAMMA",
                                           into=("GAMMA","SEUIL")),
                   b_gamma=BLOC(condition = "COMPR == 'GAMMA'",
                                fr="Paramtre d'endommagement en compression ",
                                GC = SIMP(statut='o',typ='R',defaut=1.0E+0,val_min=0.0E+0, val_max=1.0E+0),),
                   b_seuil=BLOC(condition = "COMPR == 'SEUIL'",
                                fr="Seuil d'endommagement en compression ",
                                SYC = SIMP(statut='o',typ='R'),),
                   PENTE = SIMP(statut='o',typ='TXM',defaut="RIGI_ACIER",
                                into=("PLAS_ACIER","UTIL","RIGI_ACIER")),
                   b_util = BLOC(condition = "PENTE == 'UTIL'",
                                 fr="Valeur de la dformation maximale de l'lment",
                                  EPSI_MEMB = SIMP(statut='o',typ='R',defaut=0.E+0),
                                  EPSI_FLEX = SIMP(statut='o',typ='R',defaut=0.E+0),),
                   CISAIL = SIMP(statut='o',typ='TXM',defaut="NON",
                                 into=("OUI","NON"),),
                   METHODE_ENDO = SIMP(statut='o',typ='TXM',defaut="ENDO_INTER",
                                  into=("ENDO_NAISS","ENDO_LIM","ENDO_INTER"),),
                   INFO = SIMP(statut='f',typ='I',defaut=1,into=(1,2),),
                           ),
           b_glrc_damage=BLOC(condition = "RELATION == 'GLRC_DAMAGE'",
                            fr="Paramtres de la loi GLRC_DAMAGE",
                   BETON            =FACT(statut='o',max=1,
                     MATER           =SIMP(statut='o',typ=(mater_sdaster) ),
                     EPAIS           =SIMP(statut='o',typ='R',val_min=0.E+0 ),
                     GAMMA           =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=1.E+0),
                     QP1             =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=1.E+0),
                     QP2             =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=1.E+0),

                     C1N1            =SIMP(statut='o',typ='R',val_min=0.E+0),
                     C1N2            =SIMP(statut='o',typ='R',val_min=0.E+0),
                     C1N3            =SIMP(statut='o',typ='R',val_min=0.E+0),
                     C2N1            =SIMP(statut='o',typ='R',val_min=0.E+0),
                     C2N2            =SIMP(statut='o',typ='R',val_min=0.E+0),
                     C2N3            =SIMP(statut='o',typ='R',val_min=0.E+0),
                     C1M1            =SIMP(statut='o',typ='R',val_min=0.E+0),
                     C1M2            =SIMP(statut='o',typ='R',val_min=0.E+0),
                     C1M3            =SIMP(statut='o',typ='R',val_min=0.E+0),
                     C2M1            =SIMP(statut='o',typ='R',val_min=0.E+0),
                     C2M2            =SIMP(statut='o',typ='R',val_min=0.E+0),
                     C2M3            =SIMP(statut='o',typ='R',val_min=0.E+0),

                     OMT             =SIMP(statut='f',typ='R',val_min=0.E+0,defaut=0.0E+0),
                     EAT             =SIMP(statut='f',typ='R',val_min=0.E+0,defaut=0.0E+0),
                     BT1             =SIMP(statut='f',typ='R',val_min=0.E+0,defaut=0.0E+0),
                     BT2             =SIMP(statut='f',typ='R',val_min=0.E+0,defaut=0.0E+0),

                     MP1X            =SIMP(statut='f',typ=('R',listr8_sdaster)),
                     MP2X            =SIMP(statut='f',typ=('R',listr8_sdaster)),
                     MP1Y            =SIMP(statut='f',typ=('R',listr8_sdaster)),
                     MP2Y            =SIMP(statut='f',typ=('R',listr8_sdaster)),
         ),
                   NAPPE     =FACT(statut='o',max=10,
                     MATER           =SIMP(statut='o',typ=(mater_sdaster) ),
                     OMX             =SIMP(statut='o',typ='R',val_min=0.E+0),
                     OMY             =SIMP(statut='o',typ='R',val_min=0.E+0),
                     RX              =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=1.E+0),
                     RY              =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=1.E+0),
         ),
                   CABLE_PREC   =FACT(statut='f',max=1,
                     MATER           =SIMP(statut='o',typ=(mater_sdaster) ),
                     OMX             =SIMP(statut='o',typ='R',val_min=0.E+0),
                     OMY             =SIMP(statut='o',typ='R',val_min=0.E+0),
                     RX              =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=1.E+0),
                     RY              =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=1.E+0),
                     PREX            =SIMP(statut='o',typ='R'),
                     PREY            =SIMP(statut='o',typ='R'),
         ),
                   LINER           =FACT(statut='f',max=10,
                     MATER           =SIMP(statut='o',typ=(mater_sdaster) ),
                     OML             =SIMP(statut='o',typ='R',val_min=0.E+0),
                     RLR             =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=1.E+0),
         ),
                   INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2),),
         ),
)  ;
#& MODIF COMMANDE  DATE 08/03/2011   AUTEUR MASSIN P.MASSIN 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY  
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY  
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR     
# (AT YOUR OPTION) ANY LATER VERSION.                                                  
#                                                                       
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT   
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF            
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU      
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                              
#                                                                       
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE     
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,         
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.        
# ======================================================================
# RESPONSABLE GENIAUT S.GENIAUT
DEFI_GRILLE=OPER(nom="DEFI_GRILLE",op=82,sd_prod=grille_sdaster,reentrant='n',
                UIinfo={"groupes":("Modlisation",)},
                fr="Dfinition d'une grille",
    
    MAILLAGE       = SIMP(statut='o',typ=maillage_sdaster),

    INFO           = SIMP(statut='f',typ='I',defaut= 0,into=(0,1,2) ),
)  ;
#& MODIF COMMANDE  DATE 01/03/2011   AUTEUR GENIAUT S.GENIAUT 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
def defi_group_prod(MAILLAGE,**args):
  if AsType(MAILLAGE) == maillage_sdaster : return maillage_sdaster
  if AsType(MAILLAGE) == squelette : return squelette
  raise AsException("type de concept resultat non prevu")

DEFI_GROUP=OPER(nom="DEFI_GROUP",op= 104,sd_prod=defi_group_prod,
                fr="Dfinition de nouveaux groupes de noeuds et/ou de mailles dans un concept maillage",
                reentrant='o',
            UIinfo={"groupes":("Maillage",)},
         regles=(AU_MOINS_UN('CREA_GROUP_MA','CREA_GROUP_NO','DETR_GROUP_NO','DETR_GROUP_MA'),),
         MAILLAGE        =SIMP(statut='o',typ=(maillage_sdaster,squelette) ),
         DETR_GROUP_MA   =FACT(statut='f',max='**',
           NOM             =SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**'),),
         DETR_GROUP_NO   =FACT(statut='f',max='**',
           NOM             =SIMP(statut='o',typ=grno,validators=NoRepeat(),max='**'),),


         CREA_GROUP_MA   =FACT(statut='f',max='**',
              regles=(UN_PARMI('TOUT','GROUP_MA','MAILLE','INTERSEC','UNION','DIFFE','OPTION'),),
            NOM             =SIMP(statut='o',typ=grma),
            TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
            GROUP_MA        =SIMP(statut='f',typ=grma),
            MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            INTERSEC        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            UNION           =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            DIFFE           =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            TYPE_MAILLE     =SIMP(statut='f',typ='TXM',defaut="TOUT",into=("TOUT","1D","2D","3D"),max=1 ),

            OPTION         =SIMP(statut='f',typ='TXM',into=("FACE_NORMALE","SPHERE","CYLINDRE",
                                                              "BANDE","APPUI_LACHE","APPUI","FISS_XFEM") ),
                b_group_ma      =BLOC(condition = "GROUP_MA != None",
                  regles=(EXCLUS('POSITION','NUME_INIT'),),
                  NUME_INIT       =SIMP(statut='f',typ='I'),
                  POSITION        =SIMP(statut='f',typ='TXM',into=("INIT","FIN","MILIEU") ),
                  b_nume_init   =BLOC(condition = "NUME_INIT != None",
                    NUME_FIN        =SIMP(statut='f',typ='I' ),
                  ),
                ),
                b_face_normale  =BLOC(condition = "OPTION == 'FACE_NORMALE'",
                  regles=(UN_PARMI('ANGL_NAUT','VECT_NORMALE'),),
                  ANGL_NAUT       =SIMP(statut='f',typ='R',max=2),
                  VECT_NORMALE    =SIMP(statut='f',typ='R',max=3),
                  ANGL_PREC       =SIMP(statut='f',typ='R',defaut= 0.5 ),
                  VERI_SIGNE      =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
                ),
                b_sphere        =BLOC(condition = "OPTION == 'SPHERE'",
                  regles=(UN_PARMI('POINT','NOEUD_CENTRE','GROUP_NO_CENTRE'),),
                  POINT           =SIMP(statut='f',typ='R',max=3),
                  NOEUD_CENTRE    =SIMP(statut='f',typ=no),
                  GROUP_NO_CENTRE =SIMP(statut='f',typ=grno),
                  RAYON           =SIMP(statut='o',typ='R' ),
                  CRIT_NOEUD      = SIMP(statut='f',typ='TXM',defaut="AU_MOINS_UN",
                                  into=("TOUS","AU_MOINS_UN","MAJORITE"),),
                ),
                b_cylindre      =BLOC(condition = "OPTION == 'CYLINDRE'",
                  regles=(UN_PARMI('POINT','NOEUD_CENTRE','GROUP_NO_CENTRE'),
                          UN_PARMI('ANGL_NAUT','VECT_NORMALE'),),
                  POINT           =SIMP(statut='f',typ='R',max=3),
                  NOEUD_CENTRE    =SIMP(statut='f',typ=no),
                  GROUP_NO_CENTRE =SIMP(statut='f',typ=grno),
                  RAYON           =SIMP(statut='o',typ='R' ),
                  ANGL_NAUT       =SIMP(statut='f',typ='R',max=2),
                  VECT_NORMALE    =SIMP(statut='f',typ='R',max=3),
                  CRIT_NOEUD      = SIMP(statut='f',typ='TXM',defaut="AU_MOINS_UN",
                                  into=("TOUS","AU_MOINS_UN","MAJORITE"),),
                ),
                b_bande         =BLOC(condition = "OPTION == 'BANDE'",
                  regles=(UN_PARMI('POINT','NOEUD_CENTRE','GROUP_NO_CENTRE'),
                          UN_PARMI('ANGL_NAUT','VECT_NORMALE'),),
                  POINT           =SIMP(statut='f',typ='R' ,max=3),
                  NOEUD_CENTRE    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max=1),
                  GROUP_NO_CENTRE =SIMP(statut='f',typ=grno,validators=NoRepeat(),max=1),
                  DIST            =SIMP(statut='o',typ='R' ),
                  ANGL_NAUT       =SIMP(statut='f',typ='R',max=2),
                  VECT_NORMALE    =SIMP(statut='f',typ='R',max=3),
                  CRIT_NOEUD      = SIMP(statut='f',typ='TXM',defaut="AU_MOINS_UN",
                                  into=("TOUS","AU_MOINS_UN","MAJORITE"),),
                ),
                b_app_lache         =BLOC(condition = "OPTION == 'APPUI_LACHE'",
                  regles=(UN_PARMI('NOEUD','GROUP_NO'),),
                  NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                  GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                ),
                b_appui            =BLOC(condition = "OPTION == 'APPUI'",
                  regles=(UN_PARMI('NOEUD','GROUP_NO'),),
                  NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
                  GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
                  TYPE_APPUI      =SIMP(statut='o',typ='TXM',max=1, into=('AU_MOINS_UN','TOUT','SOMMET','MAJORITE')),
                ),
                b_fiss_xfem       =BLOC(condition = "OPTION == 'FISS_XFEM'",
                  TYPE_GROUP      =SIMP(statut='o',typ='TXM',max=1,defaut='XFEM',
                                          into=('HEAVISIDE','CRACKTIP','MIXTE','FISSUREE','XFEM',),),
                  FISSURE         =SIMP(statut='o',typ=fiss_xfem,min=1,max='**'),
                ),
         ),


         CREA_GROUP_NO   =FACT(statut='f',max='**',
           OPTION          =SIMP(statut='f',typ='TXM',into=("ENV_SPHERE","ENV_CYLINDRE","PLAN",
                                               "SEGM_DROI_ORDO","NOEUD_ORDO","TUNNEL","INCLUSION","FISS_XFEM") ),

           b_option =BLOC(condition = "OPTION == None" ,
                          regles=(UN_PARMI('TOUT_GROUP_MA','GROUP_MA','GROUP_NO','NOEUD',
                                                           'INTERSEC','UNION','DIFFE'),),
              TOUT_GROUP_MA   =SIMP(statut='f',typ='TXM',into=("OUI",) ),
              GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
              NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
              INTERSEC        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
              UNION           =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
              DIFFE           =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),

              b_nom_group_ma  =BLOC(condition = "GROUP_MA != None",
                NOM           = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
                CRIT_NOEUD    = SIMP(statut='f',typ='TXM',defaut="TOUS",
                                  into=("TOUS","SOMMET","MILIEU","CENTRE"),),
              ),
              b_group_no      =BLOC(condition = "GROUP_NO != None",
                                    regles=(EXCLUS('POSITION','NUME_INIT'),),
                NUME_INIT       =SIMP(statut='f',typ='I'),
                POSITION        =SIMP(statut='f',typ='TXM',into=("INIT","FIN","MILIEU") ),
                b_nume_init     =BLOC(condition = "NUME_INIT != None",
                  NUME_FIN        =SIMP(statut='f',typ='I' ),
                ),
              ),
              b_nom =BLOC(condition = "GROUP_MA == None and TOUT_GROUP_MA == None" ,
                NOM             =SIMP(statut='o',typ=geom),
              ),
           ),

           b_env_sphere    =BLOC(condition = "OPTION == 'ENV_SPHERE'",
             regles=(UN_PARMI('POINT','NOEUD_CENTRE','GROUP_NO_CENTRE'),),
             NOM             =SIMP(statut='o',typ=geom),
             POINT           =SIMP(statut='f',typ='R' ,max=3),
             NOEUD_CENTRE    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max=1),
             GROUP_NO_CENTRE =SIMP(statut='f',typ=grno,validators=NoRepeat(),max=1),
             RAYON           =SIMP(statut='o',typ='R' ),
             PRECISION       =SIMP(statut='o',typ='R' ),
           ),
           b_env_cylindre  =BLOC(condition = "OPTION == 'ENV_CYLINDRE'",
             regles=(UN_PARMI('POINT','NOEUD_CENTRE','GROUP_NO_CENTRE'),
                     UN_PARMI('ANGL_NAUT','VECT_NORMALE'),),
             NOM             =SIMP(statut='o',typ=geom),
             POINT           =SIMP(statut='f',typ='R' ,max=3),
             NOEUD_CENTRE    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max=1),
             GROUP_NO_CENTRE =SIMP(statut='f',typ=grno,validators=NoRepeat(),max=1),
             RAYON           =SIMP(statut='o',typ='R' ),
             ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
             VECT_NORMALE    =SIMP(statut='f',typ='R',max=3),
             PRECISION       =SIMP(statut='o',typ='R' ),
           ),
           b_env_plan      =BLOC(condition = "OPTION == 'PLAN'",
             regles=(UN_PARMI('POINT','NOEUD_CENTRE','GROUP_NO_CENTRE'),
                     UN_PARMI('ANGL_NAUT','VECT_NORMALE'),),
             NOM             =SIMP(statut='o',typ=geom),
             POINT           =SIMP(statut='f',typ='R' ,max=3),
             NOEUD_CENTRE    =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max=1),
             GROUP_NO_CENTRE =SIMP(statut='f',typ=grno,validators=NoRepeat(),max=1),
             ANGL_NAUT       =SIMP(statut='f',typ='R' ,max=3),
             VECT_NORMALE    =SIMP(statut='f',typ='R' ,max=3),
             PRECISION       =SIMP(statut='o',typ='R' ),
           ),
           b_segm_droi_ordo=BLOC(condition = "OPTION == 'SEGM_DROI_ORDO'",
             regles=(AU_MOINS_UN('NOEUD','GROUP_NO'),
                     UN_PARMI('NOEUD_ORIG','GROUP_NO_ORIG'),
                     UN_PARMI('NOEUD_EXTR','GROUP_NO_EXTR'),),
             NOM             =SIMP(statut='o',typ=geom),
             NOEUD           =SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD_ORIG      =SIMP(statut='f',typ=no),
             GROUP_NO_ORIG   =SIMP(statut='f',typ=grno),
             NOEUD_EXTR      =SIMP(statut='f',typ=no),
             GROUP_NO_EXTR   =SIMP(statut='f',typ=grno),
             PRECISION       =SIMP(statut='o',typ='R' ),
             CRITERE         =SIMP(statut='o',typ='TXM',into=("ABSOLU","RELATIF") ),
           ),
           b_noeud_ordo    =BLOC(condition = "OPTION == 'NOEUD_ORDO'",
             regles=(EXCLUS('NOEUD_ORIG','GROUP_NO_ORIG'),
                     EXCLUS('NOEUD_EXTR','GROUP_NO_EXTR'),),
             NOM             =SIMP(statut='o',typ=geom),
             GROUP_MA        =SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**'),
             NOEUD_ORIG      =SIMP(statut='f',typ=no),
             GROUP_NO_ORIG   =SIMP(statut='f',typ=grno),
             NOEUD_EXTR      =SIMP(statut='f',typ=no),
             GROUP_NO_EXTR   =SIMP(statut='f',typ=grno),
           ),
           b_tunnel    =BLOC(condition = "OPTION == 'TUNNEL'",
             regles=(AU_MOINS_UN ('TOUT','GROUP_MA','MAILLE'),
                     EXCLUS('NOEUD_ORIG','GROUP_NO_ORIG'),
                     AU_MOINS_UN ('GROUP_MA_AXE','MAILLE_AXE'),),
             NOM             =SIMP(statut='o',typ=geom),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_MA_AXE    =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE_AXE      =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
             NOEUD_ORIG      =SIMP(statut='f',typ=no),
             GROUP_NO_ORIG   =SIMP(statut='f',typ=grno),
             RAYON           =SIMP(statut='o',typ='R'),
             LONGUEUR        =SIMP(statut='f',typ='R'),
           ),
           b_inclusion         =BLOC(condition = "OPTION == 'INCLUSION'",
             fr="""cre le groupe des noeuds des mailles de GROUP_MA inclus gomtriquement
                   dans les mailles de GROUP_MA_INCL""",
             NOM             =SIMP(statut='o',typ=geom),
             CAS_FIGURE      =SIMP(statut='o',typ='TXM',into=("2D","3D","2.5D",)),
             DISTANCE_MAX    =SIMP(statut='f',typ='R',),
             GROUP_MA        =SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**'),
             GROUP_MA_INCL   =SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**'),
             MAILLAGE_INCL   =SIMP(statut='f',typ=maillage_sdaster),
           ),
           b_fiss_xfem            =BLOC(condition = "OPTION == 'FISS_XFEM'",
                  NOM             =SIMP(statut='o',typ=geom),
                  TYPE_GROUP      =SIMP(statut='o',typ='TXM',max=1,into=('HEAVISIDE','CRACKTIP','MIXTE','XFEM',)),
                  FISSURE         =SIMP(statut='o',typ=fiss_xfem,min=1,max='**'),
           ),
          ),
         ALARME          =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         INFO            =SIMP(statut='f',typ='I',into=( 1 , 2 ) ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE CORUS M.CORUS

DEFI_INTERF_DYNA=OPER(nom="DEFI_INTERF_DYNA",op=  98,sd_prod=interf_dyna_clas,
                      reentrant='n',
            UIinfo={"groupes":("Matrices et vecteurs","Dynamique",)},
            fr="Dfinir les interfaces d'une structure et leur affecter un type",
         NUME_DDL        =SIMP(statut='o',typ=nume_ddl_sdaster ),
         INTERFACE       =FACT(statut='o',max='**',
           regles=(ENSEMBLE('NOM','TYPE'),
#  erreur doc U sur la condition qui suit
                   UN_PARMI('NOEUD','GROUP_NO'),),
           NOM             =SIMP(statut='f',typ='TXM' ),
           TYPE            =SIMP(statut='f',typ='TXM',into=("MNEAL","CRAIGB","CB_HARMO","AUCUN") ),
           NOEUD           =SIMP(statut='f',typ=no,max='**'),
           GROUP_NO        =SIMP(statut='f',typ=grno,max='**'),
#           DDL_ACTIF       =SIMP(statut='f',typ='TXM',max='**'),
           MASQUE          =SIMP(statut='f',typ='TXM',max='**'),
         ),
         FREQ            =SIMP(statut='f',typ='R',defaut= 1.),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ZENTNER I.ZENTNER
from Macro.defi_inte_spec_ops import defi_inte_spec_ops

DEFI_INTE_SPEC=MACRO(nom="DEFI_INTE_SPEC",op= defi_inte_spec_ops,sd_prod=table_fonction,
                     reentrant='n',
                     fr="Dfinit une matrice interspectrale",
                     UIinfo={"groupes":("Fonctions",)},

         DIMENSION       =SIMP(statut='f',typ='I',defaut= 1 ),

         PAR_FONCTION    =FACT(statut='f',max='**',
           NUME_ORDRE_I    =SIMP(statut='o',typ='I' ),
           NUME_ORDRE_J    =SIMP(statut='o',typ='I' ),
           FONCTION        =SIMP(statut='o',typ=fonction_c ),
         ),
         KANAI_TAJIMI    =FACT(statut='f',max='**',
           regles=(EXCLUS('VALE_R','VALE_C'),),
           NUME_ORDRE_I    =SIMP(statut='o',typ='I' ),
           NUME_ORDRE_J    =SIMP(statut='o',typ='I' ),
           FREQ_MIN        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           FREQ_MAX        =SIMP(statut='f',typ='R',defaut= 100. ),
           PAS             =SIMP(statut='f',typ='R',defaut= 1. ),
           AMOR_REDUIT     =SIMP(statut='f',typ='R',defaut= 0.6 ),
           FREQ_MOY        =SIMP(statut='f',typ='R',defaut= 5. ),
           VALE_R          =SIMP(statut='f',typ='R' ),
           VALE_C          =SIMP(statut='f',typ='C' ),
           INTERPOL        =SIMP(statut='f',typ='TXM',max=2,defaut="LIN",into=("NON","LIN","LOG") ),
           PROL_DROITE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
           PROL_GAUCHE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
         ),
         CONSTANT        =FACT(statut='f',max='**',
           regles=(EXCLUS('VALE_R','VALE_C'),),
           NUME_ORDRE_I    =SIMP(statut='o',typ='I' ),
           NUME_ORDRE_J    =SIMP(statut='o',typ='I' ),
           FREQ_MIN        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           FREQ_MAX        =SIMP(statut='f',typ='R',defaut= 100. ),
           PAS             =SIMP(statut='f',typ='R',defaut= 1. ),
           VALE_R          =SIMP(statut='f',typ='R' ),
           VALE_C          =SIMP(statut='f',typ='C' ),
           INTERPOL        =SIMP(statut='f',typ='TXM',max=2,defaut="LIN",into=("NON","LIN","LOG") ),
           PROL_DROITE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
           PROL_GAUCHE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS
DEFI_LIST_ENTI=OPER(nom="DEFI_LIST_ENTI",op=22,sd_prod=listis_sdaster,
                    fr="Dfinir une liste d'entiers strictement croissante",
                    reentrant='n',
            UIinfo={"groupes":("Fonctions",)},

         OPERATION    =SIMP(statut='o',typ='TXM',defaut='DEFI',into=('DEFI','NUME_ORDRE',)),


         # dfinition d'une liste d'entiers
         #----------------------------------
         b_defi       =BLOC(condition = "OPERATION == 'DEFI'",
             regles=(UN_PARMI('VALE','DEBUT'),
                     EXCLUS('VALE','INTERVALLE'),),
             VALE            =SIMP(statut='f',typ='I',max='**'),
             DEBUT           =SIMP(statut='f',typ='I'),
             INTERVALLE      =FACT(statut='f',max='**',
                 regles=(UN_PARMI('NOMBRE','PAS'),),
                 JUSQU_A         =SIMP(statut='o',typ='I'),
                 NOMBRE          =SIMP(statut='f',typ='I',val_min=1,),
                 PAS             =SIMP(statut='f',typ='I',val_min=1,),
             ),
         ),


         # extraction d'une liste de nume_ordre dans une sd_resultat :
         #------------------------------------------------------------
         b_extr       =BLOC(condition = "OPERATION == 'NUME_ORDRE'",
             RESULTAT        =SIMP(statut='o',typ=resultat_sdaster),
             PARAMETRE       =SIMP(statut='o',typ='TXM',),
             INTERV_R        =SIMP(statut='o',typ='R',min=2,max=2),
         ),


         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2)),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 05/07/2011   AUTEUR MACOCCO K.MACOCCO 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE GENIAUT S.GENIAUT


# bloc utilis deux fois  l'identique
bloc_unif = BLOC(condition = "SUBD_METHODE == 'UNIFORME'",
                SUBD_COEF_PAS_1=SIMP(statut='f',typ='R',defaut=1.0,val_min=0.0,max=1,
                                     fr="Coefficient multiplicateur de la 1re subdivision"),
                SUBD_PAS       =SIMP(statut='f',typ='I',defaut=4,val_min=2,max=1,
                                     fr="Nombre de subdivision d'un pas de temps"),

                b_subd_unif_manu  =   BLOC(condition="METHODE == 'MANUEL'",
                    regles=(AU_MOINS_UN('SUBD_NIVEAU','SUBD_PAS_MINI'),),
                    SUBD_NIVEAU=SIMP(statut='f',typ='I',val_min=2,defaut=3,max=1,
                                     fr="Nombre maximum de niveau de subdivision d'un pas de temps"),
                    SUBD_PAS_MINI=SIMP(statut='f',typ='R',defaut=0.,val_min=0.0,max=1,
                                       fr="Pas de temps en dessous duquel on ne subdivise plus"),
                ),

                b_subd_unif_auto  =   BLOC(condition="METHODE == 'AUTO'",
                    SUBD_PAS_MINI=SIMP(statut='f',typ='R',defaut=0.,val_min=0.0,max=1,
                                       fr="Pas de temps en dessous duquel on ne subdivise plus"),
                ),
            ) # fin si UNIFORME

DEFI_LIST_INST=OPER(nom="DEFI_LIST_INST",op=  28,sd_prod=list_inst,reentrant='n',
            UIinfo={"groupes":("Fonctions",)},
               fr="Dfinition de la gestion de la liste d'instants",

# ----------------------------------------------------------------------------------------------------------------------------------
# mot-cle pour la definition a priori de la liste d'instant
# ----------------------------------------------------------------------------------------------------------------------------------

    DEFI_LIST             =FACT(statut='o',max=1,

      METHODE  =SIMP(statut='o',typ='TXM',into=("MANUEL","AUTO",),defaut="MANUEL",max=1,position='global' ),

         b_manuel            =BLOC(condition = "METHODE == 'MANUEL' ",fr="Liste d'instants donne par l'utilisateur",
           LIST_INST       =SIMP(statut='o',typ=listr8_sdaster),
                                  ),

         b_auto              =BLOC(condition = "(METHODE == 'AUTO') ",fr="Gestion automatique de la liste d'instants",
           LIST_INST       =SIMP(statut='o',typ=listr8_sdaster),
           PAS_MINI    =SIMP(statut='f',typ='R',val_min=1.e-12,max=1),
           PAS_MAXI    =SIMP(statut='f',typ='R',max=1),
           NB_PAS_MAXI =SIMP(statut='f',typ='I',val_max=1000000,max=1,defaut=1000000),
                                  ),

                      ),
# ----------------------------------------------------------------------------------------------------------------------------------
# mot-cle pour le comportement en cas d'echec (on doit recommencer le meme instant)
# ----------------------------------------------------------------------------------------------------------------------------------

    ECHEC  =FACT(statut='d',max='**',

        EVENEMENT     =SIMP(statut='f',typ='TXM',into=("ERREUR","DELTA_GRANDEUR","DIVE_ITER_PILO"),defaut="ERREUR",max=1 ),

        b_edelta           =BLOC(condition = "EVENEMENT == 'DELTA_GRANDEUR' ",fr=" ",
#      event-driven : on sous-decoupe si l'increment d'une composante d'un champ depasse le seuil
            VALE_REF          =SIMP(statut='o',typ='R',max=1),
            NOM_CHAM          =SIMP(statut='o',typ='TXM',into=("DEPL","VARI_ELGA","SIEF_ELGA",),max=1),
            NOM_CMP           =SIMP(statut='o',typ='TXM',max=1),

            SUBD_METHODE    =SIMP(statut='f',typ='TXM',into =("AUCUNE","UNIFORME"),defaut="UNIFORME",max=1,
                            fr="Mthode de subdivision des pas de temps en cas de diconvergence pour event-driven"),

            b_subd_unif = bloc_unif,

        ), # fin si DELTA_GRANDEUR

        b_subd_erreur  =   BLOC(condition="EVENEMENT == 'ERREUR'",
            SUBD_METHODE    =SIMP(statut='f',typ='TXM',into =("AUCUNE","UNIFORME","EXTRAPOLE"),defaut="UNIFORME",max=1,
                                  fr="Mthode de subdivision des pas de temps en cas de divergence pour erreur"),

            b_subd_unif = bloc_unif,

            b_subd_extr=BLOC(condition = "SUBD_METHODE == 'EXTRAPOLE'",
                SUBD_OPTION    =SIMP(statut='f',typ='TXM', into =("IGNORE_PREMIERES","GARDE_DERNIERES",),
                                     defaut="IGNORE_PREMIERES",
                    fr="Technique d'extrapolation : les 1ere itrations sont ignores ou les dernires sont gardes"),
                SUBD_ITER_IGNO =SIMP(statut='f',typ='I',defaut=3,val_min=3,max=1,
                                     fr="Les n premires itrations sont ignores pour l'extrapolation"),
                SUBD_ITER_FIN  =SIMP(statut='f',typ='I',defaut=8,val_min=3,max=1,
                                     fr="Seules les n dernires itrations sont prises pour l'extrapolation"),
                SUBD_PAS       =SIMP(statut='f',typ='I',defaut=4,val_min=2,max=1,
                                     fr="Nombre de subdivision d'un pas de temps en cas ERREUR"),

                b_subd_unif_manu  =   BLOC(condition="METHODE == 'MANUEL'",
                    regles=(AU_MOINS_UN('SUBD_NIVEAU','SUBD_PAS_MINI'),),
                    SUBD_NIVEAU=SIMP(statut='f',typ='I',val_min=2,max=1,
                                     fr="Nombre maximum de niveau de subdivision d'un pas de temps"),
                    SUBD_PAS_MINI=SIMP(statut='f',typ='R',defaut=0.,val_min=0.0,max=1,
                                       fr="Pas de temps en dessous duquel on ne subdivise plus"),
                ),

                b_subd_unif_auto  =   BLOC(condition="METHODE == 'AUTO'",
                    SUBD_PAS_MINI=SIMP(statut='f',typ='R',defaut=0.,val_min=0.0,max=1,
                                       fr="Pas de temps en dessous duquel on ne subdivise plus"),
                ),

                SUBD_ITER_PLUS =SIMP(statut='f',typ='I',defaut=50,val_min=20,max=1,
                                     fr="% itration autorise en plus"),
            ), # fin si EXTRAPOLE
        ), # fin si ERREUR

   ), # fin ECHEC

# ----------------------------------------------------------------------------------------------------------------------------------
# mot-cle pour le comportement en cas de succes (on a bien converge)
# ----------------------------------------------------------------------------------------------------------------------------------

  b_adap  =   BLOC(condition="METHODE == 'AUTO'",

    ADAPTATION  =FACT(statut='d',max='**',

#     1) parametres de l'evenement declencheur
#     ----------------------------------------

      EVENEMENT       =SIMP(statut='f',typ='TXM',into=("SEUIL","TOUT_INST","AUCUN"),defaut="SEUIL",max=1 ),

         b_adap_seuil       =BLOC(condition = "EVENEMENT == 'SEUIL' ",fr="seuil de re-decoupe",

#          FORMULE_SEUIL          =SIMP(statut='f',typ=formule),

#          b_adap_seuil_nf   =   BLOC(condition="FORMULE_SEUIL == None",
#              critere : si on fait NB_INCR_SEUIL fois de suite des increments verifiant le critere
               regles=(PRESENT_PRESENT('NB_INCR_SEUIL','NOM_PARA',),
                       PRESENT_PRESENT('NB_INCR_SEUIL','CRIT_COMP',),
                       PRESENT_PRESENT('NB_INCR_SEUIL','CRIT_COMP',),),
               NB_INCR_SEUIL     =SIMP(statut='f',typ='I',defaut=2),
               NOM_PARA          =SIMP(statut='f',typ='TXM',into=("NB_ITER_NEWTON",),defaut="NB_ITER_NEWTON"),
               CRIT_COMP         =SIMP(statut='f',typ='TXM',into=("LT","GT","LE","GE"),defaut="LE"),
#                   b_vale_R           =BLOC(condition = "NOM_PARA == 'DP' ",fr="valeur reelle",
#                VALE              =SIMP(statut='o',typ='R'),
#                                           ),
                  b_vale_I           =BLOC(condition = "NOM_PARA == 'NB_ITER_NEWTON' ",fr="valeur entiere",
               VALE_I            =SIMP(statut='f',typ='I'),
                                          ),
#                                    ),
                                ),

#     2) parametre du mode de calcul de dt+
#     ----------------------------------------

      MODE_CALCUL_TPLUS =SIMP(statut='f',typ='TXM',into=("FIXE","DELTA_GRANDEUR","ITER_NEWTON","IMPLEX"),defaut='FIXE',
                              max=1),

         b_mfixe           =BLOC(condition = "MODE_CALCUL_TPLUS == 'FIXE' ",fr="fixe",
#      dans le cas FIXE :(deltaT+) = (deltaT-)x(1+PCENT_AUGM/100)
      PCENT_AUGM                 =SIMP(statut='f',typ='R',defaut=100.,val_min=-100.,max=1),
                               ),
         b_mdelta           =BLOC(condition = "MODE_CALCUL_TPLUS == 'DELTA_GRANDEUR' ",fr=" ",
#      dans le cas DELTA_GRANDEUR : (deltaT+) = (deltaT-)x(VALREF/deltaVAL) : l'acceleration est inversement proportionnelle
#                                                                             a la variation de la grandeur
      VALE_REF          =SIMP(statut='o',typ='R',max=1),
      NOM_CHAM          =SIMP(statut='o',typ='TXM',into=("DEPL","VARI_ELGA","SIEF_ELGA",),max=1),
      NOM_CMP           =SIMP(statut='o',typ='TXM',max=1),
                                  ),
         b_mitnew           =BLOC(condition = "MODE_CALCUL_TPLUS == 'ITER_NEWTON' ",fr=" ",
#      dans le cas ITER_NEWTON : (deltaT+) = (deltaT-) x sqrt(VALREF/N) : l'acceleration est inversement proportionnelle
#                                                                        au nombre d'iter de Newton precedent
      NB_ITER_NEWTON_REF          =SIMP(statut='o',typ='I',max=1),
                                  ),

# les schemas pre-definis :
#  abaqus :
#      EVENEMENT       ='SEUIL'
#      NB_INCR_SEUIL     = 2
#      NOM_PARA          ='NB_ITER_NEWTON'
#      CRIT_COMP         ='LE'
#      VALE_I            = 5
#      MODE_CALCUL_TPLUS ='FIXE'
#      PCENT_AUGM        = 50.
#  Zebulon 1 :
#      EVENEMENT       ='TOUT_INST'
#      MODE_CALCUL_TPLUS ='DELTA_GRANDEUR'
#      VALE_REF          = valref
#      NOM_CHAM          ='VARI_ELGA'
#      NOM_CMP           ='V1'
#  Zebulon 2 :
#      EVENEMENT       ='TOUT_INST'
#      MODE_CALCUL_TPLUS ='ITER_NEWTON'
#      NB_ITER_NEWTON_REF= nc
#  Tough2 :
#      EVENEMENT       ='SEUIL'
#      NB_INCR_SEUIL     = 1
#      NOM_PARA          ='NB_ITER_NEWTON'
#      CRIT_COMP         ='LE'
#      VALE_I            = n
#      MODE_CALCUL_TPLUS ='FIXE'
#      PCENT_AUGM        = 100.
#  Oliver :
#      EVENEMENT       ='TOUT_INST'
#      MODE_CALCUL_TPLUS ='FORMULE'
#      NOM_SCHEMA        ='OLIVER'

             ),
      ),
#  b_adaplex  =   BLOC(condition = "METHODE == 'AUTO' and MODE_CALCUL_TPLUS == 'IMPLEX'",
#
#    ADAPTATION  =FACT(statut='d',max='**',
#
#     1 parametres de l'evenement declencheur
#     ----------------------------------------
#
#      EVENEMENT       =SIMP(statut='f',typ='TXM',into=("TOUT_INST",),defaut="TOUT_INST",max=1 ),
#
#                           
#     2 parametre du mode de calcul de dt+
#     ----------------------------------------
#
#     MODE_CALCUL_TPLUS =SIMP(statut='f',typ='TXM',into=("IMPLEX",),defaut='IMPLEX',max=1,position='global' ),
#
#             ),
#     ),

# ----------------------------------------------------------------------------------------------------------------------------------

    INFO                  =SIMP(statut='f',typ='I',defaut= 1,into=(1,2) ),

)  ;

#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS
DEFI_LIST_REEL=OPER(nom="DEFI_LIST_REEL",op=24,sd_prod=listr8_sdaster,
                    fr="Dfinir une liste de rels strictement croissante",
                    reentrant='n',
            UIinfo={"groupes":("Fonctions",)},
         regles=(UN_PARMI('VALE','DEBUT',),
                 EXCLUS('VALE','INTERVALLE'),
                 ENSEMBLE('DEBUT','INTERVALLE')),
         VALE            =SIMP(statut='f',typ='R',max='**'),
         DEBUT           =SIMP(statut='f',typ='R'),
         INTERVALLE      =FACT(statut='f',max='**',
           regles=(UN_PARMI('NOMBRE','PAS'),),
           JUSQU_A         =SIMP(statut='o',typ='R'),
           NOMBRE          =SIMP(statut='f',typ='I'),
           PAS             =SIMP(statut='f',typ='R'),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2)),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE PELLET J.PELLET
DEFI_MAILLAGE=OPER(nom="DEFI_MAILLAGE",op=  88,sd_prod=maillage_sdaster,
                   fr="Dfinition d'un nouveau maillage  partir de macro-lments",
                   reentrant='n',
            UIinfo={"groupes":("Maillage",)},
         DEFI_SUPER_MAILLE =FACT(statut='o',max='**',
           MACR_ELEM       =SIMP(statut='o',typ=(macr_elem_stat,macr_elem_dyna),max='**' ),
           SUPER_MAILLE    =SIMP(statut='f',typ=ma,max='**'),
           TRAN            =SIMP(statut='f',typ='R',max=3),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
           b_angl_naut     =BLOC(condition = "ANGL_NAUT != None",
             CENTRE          =SIMP(statut='f',typ='R',max=3),
           ),
         ),
         RECO_GLOBAL     =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','SUPER_MAILLE'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
           SUPER_MAILLE    =SIMP(statut='f',typ=ma,max='**'),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
           PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-3 ),
         ),
         RECO_SUPER_MAILLE =FACT(statut='f',max='**',
           SUPER_MAILLE    =SIMP(statut='o',typ=ma,max='**'),
           GROUP_NO        =SIMP(statut='o',typ=grno,max='**'),
           OPTION          =SIMP(statut='f',typ='TXM',defaut="GEOMETRIQUE",into=("GEOMETRIQUE","NOEUD_A_NOEUD","INVERSE") ),
           geometrique     =BLOC(condition = "OPTION == 'GEOMETRIQUE'",
             CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-3 ),
           ),
         ),
         DEFI_NOEUD      =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','NOEUD_INIT'),),
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",),
                                 fr="Renommage de tous les noeuds" ),
           NOEUD_INIT      =SIMP(statut='f',typ=no,
                                 fr="Renommage d un seul noeud"),
           b_tout          =BLOC(condition = "TOUT != None",
             PREFIXE         =SIMP(statut='f',typ='TXM' ),
             INDEX           =SIMP(statut='o',typ='I',max='**'),
           ),
           b_noeud_init    =BLOC(condition = "NOEUD_INIT != None",
             SUPER_MAILLE    =SIMP(statut='o',typ=ma),
             NOEUD_FIN       =SIMP(statut='o',typ=no),
           ),
         ),
         DEFI_GROUP_NO   =FACT(statut='f',max='**',
           regles=(UN_PARMI('TOUT','SUPER_MAILLE'),
                AU_MOINS_UN('INDEX','GROUP_NO_FIN'),
                   ENSEMBLE('GROUP_NO_INIT','GROUP_NO_FIN'),),
#  la regle ancien catalogue AU_MOINS_UN__: ( INDEX , GROUP_NO_FIN ) incoherente avec doc U
           TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",),
                                 fr="Cration de plusieurs groupes de noeuds" ),
           SUPER_MAILLE    =SIMP(statut='f',typ=ma,
                                 fr="Cration de plusieurs groupes de noeuds"),
           GROUP_NO_INIT   =SIMP(statut='f',typ=grno,
                                 fr="Cration d un seul groupe de noeuds"),
           PREFIXE         =SIMP(statut='f',typ='TXM' ),
           INDEX           =SIMP(statut='f',typ='I',max='**'),
           GROUP_NO_FIN    =SIMP(statut='f',typ=grno),
         ),
)  ;
#& MODIF COMMANDE  DATE 23/02/2011   AUTEUR LAVERNE J.LAVERNE 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE LEFEBVRE J.P.LEFEBVRE
DEFI_MATERIAU=OPER(nom="DEFI_MATERIAU",op=5,sd_prod=mater_sdaster,
                   fr="Dfinition des paramtres dcrivant le comportement d un matriau",
                   reentrant='f',
            UIinfo={"groupes":("Modlisation",)},
       regles=(EXCLUS('ELAS','ELAS_FO','ELAS_FLUI','ELAS_ISTR','ELAS_ISTR_FO','ELAS_ORTH',
                      'ELAS_ORTH_FO','ELAS_COQUE','ELAS_COQUE_FO',
                      'ELAS_HYPER','ELAS_2NDG',),
               EXCLUS('THER','THER_FO','THER_ORTH','THER_NL'),
               EXCLUS('ECRO_LINE','ECRO_LINE_FO','ECRO_PUIS'),
               EXCLUS('ENDO_HETEROGENE'),
               EXCLUS('TAHERI','TAHERI_FO'),
               EXCLUS('ROUSSELIER','ROUSSELIER_FO'),
               EXCLUS('VISC_SINH','VISC_SINH_FO'),
               PRESENT_PRESENT('ROUSSELIER','TRACTION'),
               PRESENT_PRESENT('ROUSSELIER_FO','TRACTION'),
               EXCLUS('CIN1_CHAB','CIN1_CHAB_FO'),
               EXCLUS('CIN2_CHAB','CIN2_CHAB_FO'),
               EXCLUS('VISCOCHAB','VISCOCHAB_FO'),
               EXCLUS('LEMAITRE','LEMAITRE_FO','VISC_IRRA_LOG',
               'LEMA_SEUIL','LEMA_SEUIL_FO','LEMAITRE_IRRA','LMARC_IRRA',),
               EXCLUS('META_LEMA_ANI','META_LEMA_ANI_FO'),
               EXCLUS('VMIS_POUTRE','VMIS_POUTRE_FO'),
               EXCLUS('VENDOCHAB','VENDOCHAB_FO'),
               EXCLUS('VISC_ENDO','VISC_ENDO_FO'),
               PRESENT_PRESENT('BPEL_ACIER','ELAS'),
               EXCLUS('RCCM','RCCM_FO'),
               EXCLUS('WEIBULL','WEIBULL_FO'),
               PRESENT_PRESENT('LAIGLE','ELAS'),
               PRESENT_PRESENT('LETK','ELAS'),
               PRESENT_PRESENT('DRUCK_PRAGER','ELAS'),
               PRESENT_PRESENT('VISC_DRUC_PRAG','ELAS'),
               PRESENT_PRESENT('ELAS_GONF','ELAS'),
               PRESENT_PRESENT('HOEK_BROWN','ELAS'),
               EXCLUS('MAZARS','MAZARS_FO'),
               PRESENT_PRESENT('JOINT_BA','ELAS'),
               PRESENT_PRESENT('CABLE','ELAS'),
               ),
           MATER      =SIMP(statut='f',typ=mater_sdaster),
#
# comportement lastique
#
           ELAS            =FACT(statut='f',
             E               =SIMP(statut='o',typ='R',val_min=0.E+0),
             NU              =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=0.5E+0),
             RHO             =SIMP(statut='f',typ='R'),
             ALPHA           =SIMP(statut='f',typ='R'),
             AMOR_ALPHA      =SIMP(statut='f',typ='R'),
             AMOR_BETA       =SIMP(statut='f',typ='R'),
             AMOR_HYST       =SIMP(statut='f',typ='R'),
           ),
           ELAS_FO         =FACT(statut='f',
             regles=(PRESENT_PRESENT('ALPHA','TEMP_DEF_ALPHA'),),
             E               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO             =SIMP(statut='f',typ='R'),
             TEMP_DEF_ALPHA  =SIMP(statut='f',typ='R'),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.),
             ALPHA           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_ALPHA      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_BETA       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_HYST       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K_DESSIC        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             B_ENDOGE        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             FONC_DESORP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ELAS_FLUI       =FACT(statut='f',
             E               =SIMP(statut='o',typ='R'),
             NU              =SIMP(statut='o',typ='R'),
             RHO             =SIMP(statut='o',typ='R'),
             PROF_RHO_F_INT  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PROF_RHO_F_EXT  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COEF_MASS_AJOU  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ELAS_ISTR       =FACT(statut='f',
             E_L             =SIMP(statut='o',typ='R'),
             E_N             =SIMP(statut='o',typ='R'),
             NU_LT           =SIMP(statut='o',typ='R'),
             NU_LN           =SIMP(statut='o',typ='R'),
             G_LN            =SIMP(statut='o',typ='R'),
             RHO             =SIMP(statut='f',typ='R'),
             ALPHA_L         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             ALPHA_N         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           ELAS_ISTR_FO    =FACT(statut='f',
             regles=(
                      PRESENT_PRESENT('ALPHA_L','TEMP_DEF_ALPHA'),
                      PRESENT_PRESENT('ALPHA_N','TEMP_DEF_ALPHA'),
                    ),
             E_L             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             E_N             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_LT           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_LN           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_LN            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO             =SIMP(statut='f',typ='R'),
             TEMP_DEF_ALPHA  =SIMP(statut='f',typ='R'),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.),
             ALPHA_L         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALPHA_N         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ELAS_ORTH       =FACT(statut='f',
             E_L             =SIMP(statut='o',typ='R'),
             E_T             =SIMP(statut='o',typ='R'),
             E_N             =SIMP(statut='f',typ='R'),
             NU_LT           =SIMP(statut='o',typ='R'),
             NU_LN           =SIMP(statut='f',typ='R'),
             NU_TN           =SIMP(statut='f',typ='R'),
             G_LT            =SIMP(statut='o',typ='R'),
             G_LN            =SIMP(statut='f',typ='R'),
             G_TN            =SIMP(statut='f',typ='R'),
             RHO             =SIMP(statut='f',typ='R'),
             ALPHA_L         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             ALPHA_T         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             ALPHA_N         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             XT              =SIMP(statut='f',typ='R',defaut= 1. ),
             XC              =SIMP(statut='f',typ='R',defaut= 1. ),
             YT              =SIMP(statut='f',typ='R',defaut= 1. ),
             YC              =SIMP(statut='f',typ='R',defaut= 1. ),
             S_LT            =SIMP(statut='f',typ='R',defaut= 1. ),
             AMOR_ALPHA      =SIMP(statut='f',typ='R'),
             AMOR_BETA       =SIMP(statut='f',typ='R'),
             AMOR_HYST       =SIMP(statut='f',typ='R'),
           ),
           ELAS_ORTH_FO    =FACT(statut='f',
             regles=(
                      PRESENT_PRESENT('ALPHA_L','TEMP_DEF_ALPHA'),
                      PRESENT_PRESENT('ALPHA_N','TEMP_DEF_ALPHA'),
                      PRESENT_PRESENT('ALPHA_T','TEMP_DEF_ALPHA'),
                    ),
             E_L             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             E_T             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             E_N             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_LT           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_LN           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_TN           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_LT            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_LN            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_TN            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO             =SIMP(statut='f',typ='R'),
             TEMP_DEF_ALPHA  =SIMP(statut='f',typ='R'),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1. ),
             ALPHA_L         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALPHA_T         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALPHA_N         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_ALPHA      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_BETA       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_HYST       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ELAS_HYPER      =FACT(statut='f',
                                 regles=(UN_PARMI('K','NU'),),
             C10             =SIMP(statut='o',typ='R',
                                   fr="Si C10 est le seul coefficient fourni, alors le matriau est No-Hooken."),
             C01             =SIMP(statut='f',typ='R',defaut=0.0,
                                   fr="Si l'on fournit C01 en plus de C10, on obtient un matriau de type Mooney-Rivlin."),
             C20             =SIMP(statut='f',typ='R',defaut=0.0,
                                   fr="Si l'on fournit C20 en plus de C10 et C01, on obtient un matriau de type Signorini."),
             K               =SIMP(statut='f',typ='R',fr="Module de compressibilit."),
             NU              =SIMP(statut='f',typ='R',val_min=-1.E+0,val_max=0.5E+0,fr="Coefficient de Poisson."),
             RHO             =SIMP(statut='f',typ='R',defaut=0.0,fr="Masse volumique."),
           ),
           ELAS_COQUE      =FACT(statut='f',
             regles=(EXCLUS('MEMB_L','M_LLLL',),
                     PRESENT_PRESENT('MEMB_L','MEMB_LT', 'MEMB_T','MEMB_G_LT','FLEX_L','FLEX_LT',
                                     'FLEX_T','FLEX_G_LT','CISA_L','CISA_T',),
                     PRESENT_PRESENT('M_LLLL','M_LLTT','M_LLLT','M_TTTT','M_TTLT','M_LTLT','F_LLLL',
                                     'F_LLTT','F_LLLT','F_TTTT','F_TTLT','F_LTLT','MF_LLLL',
                                     'MF_LLTT','MF_LLLT','MF_TTTT','MF_TTLT','MF_LTLT','MC_LLLZ',
                                     'MC_LLTZ','MC_TTLZ','MC_TTTZ','MC_LTLZ','MC_LTTZ','FC_LLLZ',
                                     'FC_LLTZ','FC_TTLZ','FC_TTTZ','FC_LTLZ','FC_LTTZ','C_LZLZ',
                                     'C_LZTZ','C_TZTZ'),),
             MEMB_L          =SIMP(statut='f',typ='R'),
             MEMB_LT         =SIMP(statut='f',typ='R'),
             MEMB_T          =SIMP(statut='f',typ='R'),
             MEMB_G_LT       =SIMP(statut='f',typ='R'),
             FLEX_L          =SIMP(statut='f',typ='R'),
             FLEX_LT         =SIMP(statut='f',typ='R'),
             FLEX_T          =SIMP(statut='f',typ='R'),
             FLEX_G_LT       =SIMP(statut='f',typ='R'),
             CISA_L          =SIMP(statut='f',typ='R'),
             CISA_T          =SIMP(statut='f',typ='R'),
             M_LLLL          =SIMP(statut='f',typ='R'),
             M_LLTT          =SIMP(statut='f',typ='R'),
             M_LLLT          =SIMP(statut='f',typ='R'),
             M_TTTT          =SIMP(statut='f',typ='R'),
             M_TTLT          =SIMP(statut='f',typ='R'),
             M_LTLT          =SIMP(statut='f',typ='R'),
             F_LLLL          =SIMP(statut='f',typ='R'),
             F_LLTT          =SIMP(statut='f',typ='R'),
             F_LLLT          =SIMP(statut='f',typ='R'),
             F_TTTT          =SIMP(statut='f',typ='R'),
             F_TTLT          =SIMP(statut='f',typ='R'),
             F_LTLT          =SIMP(statut='f',typ='R'),
             MF_LLLL         =SIMP(statut='f',typ='R'),
             MF_LLTT         =SIMP(statut='f',typ='R'),
             MF_LLLT         =SIMP(statut='f',typ='R'),
             MF_TTTT         =SIMP(statut='f',typ='R'),
             MF_TTLT         =SIMP(statut='f',typ='R'),
             MF_LTLT         =SIMP(statut='f',typ='R'),
             MC_LLLZ         =SIMP(statut='f',typ='R'),
             MC_LLTZ         =SIMP(statut='f',typ='R'),
             MC_TTLZ         =SIMP(statut='f',typ='R'),
             MC_TTTZ         =SIMP(statut='f',typ='R'),
             MC_LTLZ         =SIMP(statut='f',typ='R'),
             MC_LTTZ         =SIMP(statut='f',typ='R'),
             FC_LLLZ         =SIMP(statut='f',typ='R'),
             FC_LLTZ         =SIMP(statut='f',typ='R'),
             FC_TTLZ         =SIMP(statut='f',typ='R'),
             FC_TTTZ         =SIMP(statut='f',typ='R'),
             FC_LTLZ         =SIMP(statut='f',typ='R'),
             FC_LTTZ         =SIMP(statut='f',typ='R'),
             C_LZLZ          =SIMP(statut='f',typ='R'),
             C_LZTZ          =SIMP(statut='f',typ='R'),
             C_TZTZ          =SIMP(statut='f',typ='R'),
             RHO             =SIMP(statut='f',typ='R'),
             ALPHA           =SIMP(statut='f',typ='R'),
           ),
           ELAS_COQUE_FO   =FACT(statut='f',
             regles=(EXCLUS('MEMB_L','M_LLLL',),
                     PRESENT_PRESENT('MEMB_L','MEMB_LT','MEMB_T','MEMB_G_LT','FLEX_L','FLEX_LT',
                                     'FLEX_T','FLEX_G_LT','CISA_L','CISA_T',),
                     PRESENT_PRESENT('M_LLLL','M_LLTT','M_LLLT','M_TTTT','M_TTLT','M_LTLT','F_LLLL',
                                     'F_LLTT','F_LLLT','F_TTTT','F_TTLT','F_LTLT','MF_LLLL','MF_LLTT',
                                     'MF_LLLT','MF_TTTT','MF_TTLT','MF_LTLT','MC_LLLZ','MC_LLTZ',
                                     'MC_TTLZ','MC_TTTZ','MC_LTLZ','MC_LTTZ','FC_LLLZ','FC_LLTZ',
                                     'FC_TTLZ','FC_TTTZ','FC_LTLZ','FC_LTTZ','C_LZLZ','C_LZTZ','C_TZTZ'),),
             MEMB_L          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MEMB_LT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MEMB_T          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MEMB_G_LT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FLEX_L          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FLEX_LT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FLEX_T          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FLEX_G_LT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CISA_L          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CISA_T          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_LLLL          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_LLTT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_LLLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_TTTT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_TTLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_LTLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_LLLL          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_LLTT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_LLLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_TTTT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_TTLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_LTLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_LLLL         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_LLTT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_LLLT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_TTTT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_TTLT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_LTLT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_LLLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_LLTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_TTLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_TTTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_LTLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_LTTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_LLLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_LLTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_TTLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_TTTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_LTLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_LTTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_LZLZ          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_LZTZ          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_TZTZ          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO             =SIMP(statut='f',typ='R'),
             ALPHA           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ELAS_2NDG        =FACT(statut='f',
             A1              =SIMP(statut='o',typ='R'),
             A2              =SIMP(statut='f',typ='R'),
             A3              =SIMP(statut='f',typ='R'),
             A4              =SIMP(statut='f',typ='R'),
             A5              =SIMP(statut='f',typ='R'),
           ),
           CABLE           =FACT(statut='f',
             EC_SUR_E        =SIMP(statut='f',typ='R',defaut= 1.E-4 ),
           ),
#
# comportement mcanique non linaire
#
           TRACTION        =FACT(statut='f',
             SIGM            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ECRO_LINE       =FACT(statut='f',
             D_SIGM_EPSI     =SIMP(statut='o',typ='R',),
             SY              =SIMP(statut='o',typ='R',),
           ),
           ENDO_HETEROGENE   =FACT(statut='f',
             WEIBULL         =SIMP(statut='o',typ='R',),
             SY              =SIMP(statut='o',typ='R',),
             KI              =SIMP(statut='o',typ='R',),
             EPAI            =SIMP(statut='o',typ='R',),
             GR              =SIMP(statut='f',typ='R',defaut= 1.0),
           ),
           ECRO_LINE_FO    =FACT(statut='f',
             D_SIGM_EPSI     =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SY              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ECRO_PUIS       =FACT(statut='f',
             SY              =SIMP(statut='o',typ='R',),
             A_PUIS          =SIMP(statut='o',typ='R',val_min=0.0),
             N_PUIS          =SIMP(statut='o',typ='R',val_min=1.E-6),
           ),
           ECRO_PUIS_FO    =FACT(statut='f',
             SY              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_PUIS          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             N_PUIS          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           BETON_ECRO_LINE =FACT(statut='f',
             D_SIGM_EPSI     =SIMP(statut='o',typ='R'),
             SYT             =SIMP(statut='o',typ='R'),
             SYC             =SIMP(statut='f',typ='R'),
           ),
           BETON_REGLE_PR =FACT(statut='f',
             D_SIGM_EPSI     =SIMP(statut='o',typ='R'),
             SYT             =SIMP(statut='o',typ='R'),
             SYC             =SIMP(statut='f',typ='R'),
             EPSC            =SIMP(statut='f',typ='R'),
             N               =SIMP(statut='f',typ='R'),
           ),
           ENDO_ORTH_BETON  =FACT(statut='f',
             ALPHA            =SIMP(statut='f',typ='R',defaut=0.9),
             K0               =SIMP(statut='o',typ='R'),
             K1               =SIMP(statut='o',typ='R'),
             K2               =SIMP(statut='f',typ='R',defaut=7.E-4),
             ECROB            =SIMP(statut='o',typ='R'),
             ECROD            =SIMP(statut='o',typ='R'),
           ),
           PRAGER          =FACT(statut='f',
             C               =SIMP(statut='o',typ='R'),
           ),
           PRAGER_FO       =FACT(statut='f',
             C               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ECRO_FLEJOU     =FACT(statut='f',
             EP              =SIMP(statut='o',typ='R'),
             SY              =SIMP(statut='o',typ='R'),
             SU              =SIMP(statut='o',typ='R'),
             PUISS           =SIMP(statut='o',typ='R'),
           ),
           TAHERI          =FACT(statut='f',
             R_0             =SIMP(statut='o',typ='R'),
             ALPHA           =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
             A               =SIMP(statut='o',typ='R'),
             B               =SIMP(statut='o',typ='R'),
             C1              =SIMP(statut='o',typ='R'),
             C_INF           =SIMP(statut='o',typ='R'),
             S               =SIMP(statut='o',typ='R'),
           ),
           TAHERI_FO       =FACT(statut='f',
             R_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALPHA           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C1              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_INF           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             S               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ROUSSELIER      =FACT(statut='f',
             D               =SIMP(statut='o',typ='R'),
             SIGM_1          =SIMP(statut='o',typ='R'),
             PORO_INIT       =SIMP(statut='o',typ='R'),
             PORO_CRIT       =SIMP(statut='f',typ='R',defaut= 1. ),
             PORO_ACCE       =SIMP(statut='f',typ='R',defaut= 1. ),
             PORO_LIMI       =SIMP(statut='f',typ='R',defaut= 0.999 ),
             D_SIGM_EPSI_NORM=SIMP(statut='f',typ='R',defaut= 1. ),
             AN              =SIMP(statut='f',typ='R',defaut= 0. ),
             DP_MAXI         =SIMP(statut='f',typ='R',defaut= 0.1),
             BETA            =SIMP(statut='f',typ='R',defaut=0.85),
           ),
           ROUSSELIER_FO   =FACT(statut='f',
             D               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_1          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PORO_INIT       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PORO_CRIT       =SIMP(statut='f',typ='R',defaut= 1. ),
             PORO_ACCE       =SIMP(statut='f',typ='R',defaut= 1. ),
             PORO_LIMI       =SIMP(statut='f',typ='R',defaut= 0.999 ),
             D_SIGM_EPSI_NORM=SIMP(statut='f',typ='R',defaut= 1. ),
             AN              =SIMP(statut='f',typ='R',defaut= 0. ),
             DP_MAXI         =SIMP(statut='f',typ='R',defaut= 0.1),
             BETA            =SIMP(statut='f',typ='R',defaut=0.85),
           ),
           VISC_SINH      =FACT(statut='f',
             SIGM_0          =SIMP(statut='o',typ='R'),
             EPSI_0          =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
           ),
           VISC_SINH_FO      =FACT(statut='f',
             SIGM_0          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             EPSI_0          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           CIN1_CHAB  =FACT(statut='f',
             R_0             =SIMP(statut='o',typ='R'),
             R_I             =SIMP(statut='f',typ='R'),
             B               =SIMP(statut='f',typ='R',defaut= 0.0E+0),
             C_I             =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='f',typ='R',defaut= 1.0E+0),
             W               =SIMP(statut='f',typ='R',defaut= 0.0E+0),
             G_0             =SIMP(statut='o',typ='R'),
             A_I             =SIMP(statut='f',typ='R',defaut= 1.0E+0),
           ),
           CIN1_CHAB_FO  =FACT(statut='f',
             R_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             W               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           CIN2_CHAB  =FACT(statut='f',
             R_0             =SIMP(statut='o',typ='R'),
             R_I             =SIMP(statut='f',typ='R'),
             B               =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             C1_I            =SIMP(statut='o',typ='R'),
             C2_I            =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='f',typ='R',defaut= 1.),
             W               =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             G1_0            =SIMP(statut='o',typ='R'),
             G2_0            =SIMP(statut='o',typ='R'),
             A_I             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
           ),
           CIN2_CHAB_FO  =FACT(statut='f',
             R_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C1_I            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C2_I            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             W               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G1_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G2_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           MEMO_ECRO       =FACT(statut='f',
             MU              =SIMP(statut='o',typ='R'),
             Q_M             =SIMP(statut='o',typ='R'),
             Q_0             =SIMP(statut='o',typ='R'),
             ETA             =SIMP(statut='f',typ='R',defaut= 0.5E+0 ),
           ),
           MEMO_ECRO_FO        =FACT(statut='f',
             MU              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q_M             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ETA             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           VISCOCHAB       =FACT(statut='f',
             K_0             =SIMP(statut='o',typ='R'),
             A_K             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             A_R             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             K               =SIMP(statut='o',typ='R'),
             N               =SIMP(statut='o',typ='R'),
             ALP             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             B               =SIMP(statut='f',typ='R'),
             M_R             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             G_R             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             MU              =SIMP(statut='o',typ='R',defaut= 0.E+0 ),
             Q_M             =SIMP(statut='o',typ='R'),
             Q_0             =SIMP(statut='o',typ='R'),
             QR_0            =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             ETA             =SIMP(statut='f',typ='R',defaut= 0.5E+0 ),
             C1              =SIMP(statut='o',typ='R'),
             M_1             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             D1              =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             G_X1            =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             G1_0            =SIMP(statut='o',typ='R'),
             C2              =SIMP(statut='o',typ='R'),
             M_2             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             D2              =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             G_X2            =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             G2_0            =SIMP(statut='o',typ='R'),
             A_I             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
           ),
           VISCOCHAB_FO    =FACT(statut='f',
             K_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_K             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_R             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             N               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALP             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_R             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_R             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MU              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q_M             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             QR_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ETA             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C1              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_1             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D1              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_X1            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G1_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C2              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_2             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D2              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_X2            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G2_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           LEMAITRE        =FACT(statut='f',
             N               =SIMP(statut='o',typ='R'),
             UN_SUR_K        =SIMP(statut='o',typ='R'),
             UN_SUR_M        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           LEMAITRE_IRRA    =FACT(statut='f',
             N               =SIMP(statut='o',typ='R'),
             UN_SUR_K        =SIMP(statut='o',typ='R'),
             UN_SUR_M        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             QSR_K           =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             BETA            =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             PHI_ZERO        =SIMP(statut='f',typ='R',defaut= 1.E+20),
             L               =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             GRAN_A          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             GRAN_B          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             GRAN_S          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           LMARC_IRRA       =FACT(statut='f',
             DE_0            =SIMP(statut='o',typ='R'),
             R_0             =SIMP(statut='o',typ='R'),
             N               =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='o',typ='R'),
             Y_I             =SIMP(statut='o',typ='R'),
             Y_0             =SIMP(statut='o',typ='R'),
             B               =SIMP(statut='o',typ='R'),
             A_0             =SIMP(statut='o',typ='R'),
             RM              =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
             P               =SIMP(statut='o',typ='R'),
             P1              =SIMP(statut='o',typ='R'),
             P2              =SIMP(statut='o',typ='R'),
             M11             =SIMP(statut='o',typ='R'),
             M22             =SIMP(statut='o',typ='R'),
             M33             =SIMP(statut='o',typ='R'),
             M66             =SIMP(statut='o',typ='R'),
             N11             =SIMP(statut='o',typ='R'),
             N22             =SIMP(statut='o',typ='R'),
             N33             =SIMP(statut='o',typ='R'),
             N66             =SIMP(statut='o',typ='R'),
             Q11             =SIMP(statut='o',typ='R'),
             Q22             =SIMP(statut='o',typ='R'),
             Q33             =SIMP(statut='o',typ='R'),
             Q66             =SIMP(statut='o',typ='R'),
             R11             =SIMP(statut='o',typ='R'),
             R22             =SIMP(statut='o',typ='R'),
             R33             =SIMP(statut='o',typ='R'),
             R66             =SIMP(statut='o',typ='R'),
             GRAN_A          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             GRAN_B          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             GRAN_S          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
          VISC_IRRA_LOG    =FACT(statut='f',
             A               =SIMP(statut='f',typ='R',defaut= 1.28E-1),
             B               =SIMP(statut='f',typ='R',defaut= 0.01159),
             CSTE_TPS        =SIMP(statut='f',typ='R',defaut= 0.3540),
             ENER_ACT        =SIMP(statut='f',typ='R',defaut= 5000.),
             FLUX_PHI        =SIMP(statut='o',typ='R',),
           ),
          GRAN_IRRA_LOG    =FACT(statut='f',
             A               =SIMP(statut='f',typ='R',defaut= 1.28E-1),
             B               =SIMP(statut='f',typ='R',defaut= 0.01159),
             CSTE_TPS        =SIMP(statut='f',typ='R',defaut= 0.3540),
             ENER_ACT        =SIMP(statut='f',typ='R',defaut= 5000.),
             FLUX_PHI        =SIMP(statut='o',typ='R',),
             GRAN_A          =SIMP(statut='f',typ='R',defaut= 0.E+0),
             GRAN_B          =SIMP(statut='f',typ='R',defaut= 0.E+0),
             GRAN_S          =SIMP(statut='f',typ='R',defaut= 0.E+0),
           ),
          LEMA_SEUIL   =FACT(statut='f',
             A               =SIMP(statut='o',typ='R',),
             S               =SIMP(statut='o',typ='R',),
           ),
          LEMA_SEUIL_FO=FACT(statut='f',
             A               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             S               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
         IRRAD3M=FACT(statut='f',
               R02      =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
               EPSI_U   =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
               RM       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
               AI0      =SIMP(statut='o',typ='R',val_min=0.0),
               ZETA_F   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
               ETAI_S   =SIMP(statut='o',typ='R',val_min=0.0),
               RG0      =SIMP(statut='o',typ='R',val_min=0.0),
               ALPHA    =SIMP(statut='o',typ='R',val_min=0.0),
               PHI0     =SIMP(statut='o',typ='R',val_min=0.0),
               KAPPA    =SIMP(statut='f',typ='R',val_min=0.0,defaut=0.8,val_max=1.0),
               ZETA_G   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
               TOLER_ET =SIMP(statut='f',typ='R',val_min=0.0,defaut=0.15 ),
         ),
           LEMAITRE_FO     =FACT(statut='f',
             N               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             UN_SUR_K        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             UN_SUR_M        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
             META_LEMA_ANI     =FACT(statut='f',
             F1_A            =SIMP(statut='o',typ='R'),
             F2_A            =SIMP(statut='o',typ='R'),
             C_A             =SIMP(statut='o',typ='R'),
             F1_M            =SIMP(statut='o',typ='R'),
             F2_M            =SIMP(statut='o',typ='R'),
             C_M             =SIMP(statut='o',typ='R'),
             F1_N            =SIMP(statut='o',typ='R'),
             F2_N            =SIMP(statut='o',typ='R'),
             C_N             =SIMP(statut='o',typ='R'),
             F1_Q            =SIMP(statut='o',typ='R'),
             F2_Q            =SIMP(statut='o',typ='R'),
             C_Q             =SIMP(statut='o',typ='R'),
             F_MRR_RR        =SIMP(statut='o',typ='R'),
             C_MRR_RR        =SIMP(statut='o',typ='R'),
             F_MTT_TT        =SIMP(statut='o',typ='R'),
             C_MTT_TT        =SIMP(statut='o',typ='R'),
             F_MZZ_ZZ        =SIMP(statut='o',typ='R'),
             C_MZZ_ZZ        =SIMP(statut='o',typ='R'),
             F_MRT_RT        =SIMP(statut='o',typ='R'),
             C_MRT_RT        =SIMP(statut='o',typ='R'),
             F_MRZ_RZ        =SIMP(statut='o',typ='R'),
             C_MRZ_RZ        =SIMP(statut='o',typ='R'),
             F_MTZ_TZ        =SIMP(statut='o',typ='R'),
             C_MTZ_TZ        =SIMP(statut='o',typ='R'),
           ),
             META_LEMA_ANI_FO  =FACT(statut='f',
             F1_A            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_A            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_A             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_M            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_M            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_M             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_N            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_N            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_N             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_Q            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_Q            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_Q             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MRR_RR        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MRR_RR        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MTT_TT        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MTT_TT        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MZZ_ZZ        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MZZ_ZZ        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MRT_RT        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MRT_RT        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MRZ_RZ        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MRZ_RZ        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MTZ_TZ        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MTZ_TZ        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           VMIS_POUTRE     =FACT(statut='f',
             NP              =SIMP(statut='o',typ='R'),
             MEY             =SIMP(statut='o',typ='R'),
             MPY             =SIMP(statut='o',typ='R'),
             CAY             =SIMP(statut='o',typ='R'),
             CBY             =SIMP(statut='o',typ='R'),
             MEZ             =SIMP(statut='o',typ='R'),
             MPZ             =SIMP(statut='o',typ='R'),
             CAZ             =SIMP(statut='o',typ='R'),
             CBZ             =SIMP(statut='o',typ='R'),
             MPX             =SIMP(statut='o',typ='R'),
           ),
           VMIS_POUTRE_FO  =FACT(statut='f',
             NP              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MEY             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MPY             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CAY             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CBY             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MEZ             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MPZ             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CAZ             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CBZ             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MPX             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ARME            =FACT(statut='f',
             KYE             =SIMP(statut='o',typ='R'),
             DLE             =SIMP(statut='o',typ='R'),
             KYP             =SIMP(statut='o',typ='R'),
             DLP             =SIMP(statut='o',typ='R'),
             KYG             =SIMP(statut='o',typ='R'),
           ),
           ASSE_CORN       =FACT(statut='f',
             NU_1            =SIMP(statut='o',typ='R'),
             MU_1            =SIMP(statut='o',typ='R'),
             DXU_1           =SIMP(statut='o',typ='R'),
             DRYU_1          =SIMP(statut='o',typ='R'),
             C_1             =SIMP(statut='o',typ='R'),
             NU_2            =SIMP(statut='o',typ='R'),
             MU_2            =SIMP(statut='o',typ='R'),
             DXU_2           =SIMP(statut='o',typ='R'),
             DRYU_2          =SIMP(statut='o',typ='R'),
             C_2             =SIMP(statut='o',typ='R'),
             KY              =SIMP(statut='o',typ='R'),
             KZ              =SIMP(statut='o',typ='R'),
             KRX             =SIMP(statut='o',typ='R'),
             KRZ             =SIMP(statut='o',typ='R'),
             R_P0            =SIMP(statut='f',typ='R',defaut= 1.E+4 ),
           ),
           DIS_CONTACT     =FACT(statut='f',
             RIGI_NOR        =SIMP(statut='f',typ='R' ),
             RIGI_TAN        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             AMOR_NOR        =SIMP(statut='f',typ='R' ),
             AMOR_TAN        =SIMP(statut='f',typ='R' ),
             COULOMB         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             DIST_1          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             DIST_2          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             JEU             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           ENDO_SCALAIRE   =FACT(statut='f',
             GAMMA           =SIMP(statut='o',typ='R',),
             SY              =SIMP(statut='o',typ='R',),
             COEF_RIGI_MINI  =SIMP(statut='f',typ='R',defaut=1.E-5),
             DD_MAXI         =SIMP(statut='f',typ='R',defaut= 1.),
           ),
           DIS_GRICRA    =FACT(statut='f',
             KN_AX       =SIMP(statut='o',typ='R' ),
             KT_AX       =SIMP(statut='o',typ='R' ),
             COUL_AX     =SIMP(statut='o',typ='R' ),
             F_SER       =SIMP(statut='f',typ='R' ),
             F_SER_FO    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ET_AX       =SIMP(statut='f',typ='R',defaut=1.e-7 ),
             ET_ROT      =SIMP(statut='f',typ='R',defaut=1.e-7 ),
             ANG1        =SIMP(statut='f',typ='R' ),
             ANG2        =SIMP(statut='f',typ='R' ),
             PEN1        =SIMP(statut='f',typ='R' ),
             PEN2        =SIMP(statut='f',typ='R' ),
             PEN3        =SIMP(statut='f',typ='R' ),
             ANG1_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ANG2_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PEN1_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PEN2_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PEN3_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             regles=(EXCLUS('ANG1','ANG1_FO',),
                     UN_PARMI('ANG1','ANG1_FO',),
                     EXCLUS('F_SER','F_SER_FO',),
                     UN_PARMI('F_SER','F_SER_FO',),
                     PRESENT_PRESENT('ANG1','ANG2','PEN1','PEN2','PEN3',),
                     PRESENT_PRESENT('ANG1_FO','ANG2_FO','PEN1_FO','PEN2_FO','PEN3_FO',),
                                     ),
           ),
           BETON_DOUBLE_DP =FACT(statut='f',
             F_C             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_T             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COEF_BIAX       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ENER_COMP_RUPT  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ENER_TRAC_RUPT  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COEF_ELAS_COMP  =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=100.E+0),
             LONG_CARA       =SIMP(statut='f',typ='R',val_min=0.E+0),
             ECRO_COMP_P_PIC =SIMP(statut='f',typ='TXM',defaut="LINEAIRE",into=("LINEAIRE","PARABOLE") ),
             ECRO_TRAC_P_PIC =SIMP(statut='f',typ='TXM',defaut="LINEAIRE",into=("LINEAIRE","EXPONENT") ),
           ),
           LABORD_1D=FACT(statut='f',min=0 ,
             Y01             =SIMP(statut='o',typ='R'),
             Y02             =SIMP(statut='o',typ='R'),
             A1              =SIMP(statut='o',typ='R'),
             A2              =SIMP(statut='o',typ='R'),
             B1              =SIMP(statut='o',typ='R'),
             B2              =SIMP(statut='o',typ='R'),
             BETA1           =SIMP(statut='o',typ='R'),
             BETA2           =SIMP(statut='o',typ='R'),
             SIGF            =SIMP(statut='o',typ='R'),
           ),
         MAZARS=FACT(statut='f',min=0 ,
             EPSD0           =SIMP(statut='o',typ='R'),
             BETA            =SIMP(statut='o',typ='R'),
             AC              =SIMP(statut='o',typ='R'),
             BC              =SIMP(statut='o',typ='R'),
             AT              =SIMP(statut='o',typ='R'),
             BT              =SIMP(statut='o',typ='R'),
             CHI             =SIMP(statut='f',typ='R',val_min=0.0E+0,val_max=1.0E+0),
           ),
         MAZARS_FO=FACT(statut='f',min=0 ,
             EPSD0           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BETA            =SIMP(statut='o',typ='R'),
             AC              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BC              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AT              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BT              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CHI             =SIMP(statut='f',typ='R'),
           ),
         JOINT_BA=FACT(statut='f',min=0 ,max=1,
             HPEN            =SIMP(statut='o',typ='R',defaut= 1.E+0,val_min=0.E+0),
             GTT             =SIMP(statut='o',typ='R',val_min=0.E+0),
             GAMD0           =SIMP(statut='o',typ='R',val_min=1.E-4,val_max=1.E-1),
             AD1             =SIMP(statut='o',typ='R',val_min=0.E+0),
             BD1             =SIMP(statut='o',typ='R',defaut= 5.E-1,val_min=1.E-1),
             GAMD2           =SIMP(statut='o',typ='R',val_min=1.E-4,val_max=1.E+0),
             AD2             =SIMP(statut='o',typ='R',val_min=0.E+0),
             BD2             =SIMP(statut='o',typ='R',defaut= 1.E+0,val_min=1.E-1),
             VIFROT          =SIMP(statut='o',typ='R',val_min=0.E+0),
             FA              =SIMP(statut='o',typ='R',val_min=0.E+0),
             FC              =SIMP(statut='o',typ='R',val_min=0.E+0),
             EPSTR0          =SIMP(statut='o',typ='R',val_min=1.E-4,val_max=1.E+0),
             ADN             =SIMP(statut='o',typ='R',val_min=0.E+0),
             BDN             =SIMP(statut='o',typ='R',defaut= 1.E+0,val_min=1.E-1),
           ),
          VENDOCHAB       =FACT(statut='f',
             SY              =SIMP(statut='o',typ='R',defaut= 0.E+0),
             ALPHA_D         =SIMP(statut='o',typ='R',defaut= 0.E+0),
             BETA_D          =SIMP(statut='o',typ='R',defaut= 0.E+0),
             R_D             =SIMP(statut='o',typ='R'),
             A_D             =SIMP(statut='o',typ='R'),
             K_D             =SIMP(statut='o',typ='R'),
           ),
           VENDOCHAB_FO    =FACT(statut='f',
             SY              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALPHA_D         =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BETA_D          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R_D             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_D             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K_D             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           VISC_ENDO      =FACT(statut='f',
             SY              =SIMP(statut='o',typ='R',defaut= 0.E+0),
             R_D             =SIMP(statut='o',typ='R'),
             A_D             =SIMP(statut='o',typ='R'),
           ),
           VISC_ENDO_FO   =FACT(statut='f',
             SY              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R_D             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_D             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           PINTO_MENEGOTTO =FACT(statut='f',
             SY              =SIMP(statut='o',typ='R'),
             EPSI_ULTM       =SIMP(statut='o',typ='R'),
             SIGM_ULTM       =SIMP(statut='o',typ='R'),
             ELAN            =SIMP(statut='f',typ='R',defaut= 4. ),
             EPSP_HARD       =SIMP(statut='o',typ='R'),
             R_PM            =SIMP(statut='f',typ='R',defaut= 20. ),
             EP_SUR_E        =SIMP(statut='f',typ='R'),
             A1_PM           =SIMP(statut='f',typ='R',defaut= 18.5 ),
             A2_PM           =SIMP(statut='f',typ='R',defaut= 0.15 ),
             A6_PM           =SIMP(statut='f',typ='R',defaut= 620. ),
             C_PM            =SIMP(statut='f',typ='R',defaut= 0.5 ),
             A_PM            =SIMP(statut='f',typ='R',defaut= 6.0E-3 ),
           ),
           BPEL_BETON      =FACT(statut='f',
             PERT_FLUA       =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             PERT_RETR       =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           BPEL_ACIER      =FACT(statut='f',
            regles=(PRESENT_PRESENT('RELAX_1000','F_PRG',),
                     PRESENT_PRESENT('MU0_RELAX','F_PRG',),),
             RELAX_1000      =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             MU0_RELAX       =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             F_PRG           =SIMP(statut='f',typ='R'),
             FROT_COURB      =SIMP(statut='f',typ='R',defaut=0.E+0),
             FROT_LINE       =SIMP(statut='f',typ='R',defaut=0.E+0),
           ),
           CAM_CLAY      =FACT(statut='f',
             MU              =SIMP(statut='o',typ='R'),
             PORO            =SIMP(statut='o',typ='R'),
             LAMBDA          =SIMP(statut='o',typ='R'),
             KAPA            =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
             PRES_CRIT       =SIMP(statut='o',typ='R'),
             KCAM            =SIMP(statut='f',typ='R',val_min=0.E+0),
             PTRAC           =SIMP(statut='f',typ='R',val_max=0.E+0),
               regles=(PRESENT_PRESENT('PTRAC','KCAM',),),
           ),
           BARCELONE      =FACT(statut='f',
             MU              =SIMP(statut='o',typ='R'),
             PORO            =SIMP(statut='o',typ='R'),
             LAMBDA          =SIMP(statut='o',typ='R'),
             KAPA            =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
             PRES_CRIT       =SIMP(statut='o',typ='R'),
             PA            =SIMP(statut='o',typ='R'),
             R             =SIMP(statut='o',typ='R'),
             BETA          =SIMP(statut='o',typ='R'),
             KC            =SIMP(statut='o',typ='R'),
             PC0_INIT      =SIMP(statut='o',typ='R'),
             KAPAS         =SIMP(statut='o',typ='R'),
             LAMBDAS       =SIMP(statut='o',typ='R'),
             ALPHAB        =SIMP(statut='f',typ='R'),
           ),
           CJS             =FACT(statut='f',
             BETA_CJS        =SIMP(statut='o',typ='R'),
             RM              =SIMP(statut='o',typ='R'),
             N_CJS           =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             KP              =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             RC              =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             A_CJS           =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             B_CJS           =SIMP(statut='f',typ='R',defaut= 1.0E+25 ),
             C_CJS           =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             GAMMA_CJS       =SIMP(statut='o',typ='R'),
             MU_CJS          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             PCO             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             PA              =SIMP(statut='o',typ='R'),
             Q_INIT          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             R_INIT          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           HUJEUX   =FACT(statut='f',
             N      =SIMP(statut='o',typ='R' ),
             BETA   =SIMP(statut='o',typ='R' ),
             B      =SIMP(statut='o',typ='R' ),
             D      =SIMP(statut='o',typ='R' ),
             PHI    =SIMP(statut='o',typ='R' ),
             ANGDIL =SIMP(statut='o',typ='R' ),
             PCO    =SIMP(statut='o',typ='R' ),
             PREF   =SIMP(statut='o',typ='R' ),
             ACYC   =SIMP(statut='o',typ='R' ),
             AMON   =SIMP(statut='o',typ='R' ),
             CCYC   =SIMP(statut='o',typ='R' ),
             CMON   =SIMP(statut='o',typ='R' ),
             RD_ELA =SIMP(statut='o',typ='R' ),
             RI_ELA =SIMP(statut='o',typ='R' ),
             RHYS   =SIMP(statut='o',typ='R' ),
             RMOB   =SIMP(statut='o',typ='R' ),
             XM     =SIMP(statut='o',typ='R' ),
             RD_CYC =SIMP(statut='o',typ='R' ),
             RI_CYC =SIMP(statut='o',typ='R' ),
             DILA   =SIMP(statut='o',typ='R' ),
             PTRAC  =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           ECRO_ASYM_LINE  =FACT(statut='f',
             DC_SIGM_EPSI    =SIMP(statut='o',typ='R'),
             SY_C            =SIMP(statut='o',typ='R'),
             DT_SIGM_EPSI    =SIMP(statut='o',typ='R'),
             SY_T            =SIMP(statut='o',typ='R'),
           ),
           GRANGER_FP      =FACT(statut='f',
             J1              =SIMP(statut='f',typ='R'),
             J2              =SIMP(statut='f',typ='R'),
             J3              =SIMP(statut='f',typ='R'),
             J4              =SIMP(statut='f',typ='R'),
             J5              =SIMP(statut='f',typ='R'),
             J6              =SIMP(statut='f',typ='R'),
             J7              =SIMP(statut='f',typ='R'),
             J8              =SIMP(statut='f',typ='R'),
             TAUX_1          =SIMP(statut='f',typ='R'),
             TAUX_2          =SIMP(statut='f',typ='R'),
             TAUX_3          =SIMP(statut='f',typ='R'),
             TAUX_4          =SIMP(statut='f',typ='R'),
             TAUX_5          =SIMP(statut='f',typ='R'),
             TAUX_6          =SIMP(statut='f',typ='R'),
             TAUX_7          =SIMP(statut='f',typ='R'),
             TAUX_8          =SIMP(statut='f',typ='R'),
             QSR_K           =SIMP(statut='f',typ='R'),
           ),
           GRANGER_FP_INDT =FACT(statut='f',
             J1              =SIMP(statut='f',typ='R'),
             J2              =SIMP(statut='f',typ='R'),
             J3              =SIMP(statut='f',typ='R'),
             J4              =SIMP(statut='f',typ='R'),
             J5              =SIMP(statut='f',typ='R'),
             J6              =SIMP(statut='f',typ='R'),
             J7              =SIMP(statut='f',typ='R'),
             J8              =SIMP(statut='f',typ='R'),
             TAUX_1          =SIMP(statut='f',typ='R'),
             TAUX_2          =SIMP(statut='f',typ='R'),
             TAUX_3          =SIMP(statut='f',typ='R'),
             TAUX_4          =SIMP(statut='f',typ='R'),
             TAUX_5          =SIMP(statut='f',typ='R'),
             TAUX_6          =SIMP(statut='f',typ='R'),
             TAUX_7          =SIMP(statut='f',typ='R'),
             TAUX_8          =SIMP(statut='f',typ='R'),
           ),
           V_GRANGER_FP    =FACT(statut='f',
             QSR_VEIL        =SIMP(statut='f',typ='R'),
             FONC_V          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           BETON_UMLV_FP   =FACT(statut='f',min=0 ,
             K_RS            =SIMP(statut='o',typ='R'),
             ETA_RS          =SIMP(statut='o',typ='R'),
             K_IS            =SIMP(statut='o',typ='R'),
             ETA_IS          =SIMP(statut='o',typ='R'),
             K_RD            =SIMP(statut='o',typ='R'),
             ETA_RD          =SIMP(statut='o',typ='R'),
             ETA_ID          =SIMP(statut='o',typ='R'),
             ETA_FD          =SIMP(statut='f',typ='R'),
           ),
           BETON_RAG    =FACT(statut='f',
             ACTIV_FL        =SIMP(statut='f',typ='R',defaut=1.0 ),
             K_RS            =SIMP(statut='o',typ='R'),
             K_IS            =SIMP(statut='o',typ='R'),
             ETA_RS          =SIMP(statut='o',typ='R'),
             ETA_IS          =SIMP(statut='o',typ='R'),
             K_RD            =SIMP(statut='o',typ='R'),
             K_ID            =SIMP(statut='o',typ='R'),
             ETA_RD          =SIMP(statut='o',typ='R'),
             ETA_ID          =SIMP(statut='o',typ='R'),
             EPS_0           =SIMP(statut='o',typ='R'),
             TAU_0           =SIMP(statut='o',typ='R'),
             EPS_FL_L        =SIMP(statut='f',typ='R',defaut=3.0e-2 ),
             ACTIV_LO        =SIMP(statut='f',typ='R',defaut=1.0 ),
             F_C             =SIMP(statut='o',typ='R'),
             F_T             =SIMP(statut='o',typ='R'),
             ANG_CRIT        =SIMP(statut='f',typ='R',defaut=8.594367 ),
             EPS_COMP        =SIMP(statut='o',typ='R'),
             EPS_TRAC        =SIMP(statut='o',typ='R'),
             LC_COMP         =SIMP(statut='o',typ='R',defaut=1.0  ),
             LC_TRAC         =SIMP(statut='o',typ='R',defaut=1.0  ),
             HYD_PRES        =SIMP(statut='f',typ='R',defaut=0.   ),
             A_VAN_GE        =SIMP(statut='f',typ='R',defaut=0.0  ),
             B_VAN_GE        =SIMP(statut='f',typ='R',defaut=1.9  ),
             BIOT_EAU        =SIMP(statut='o',typ='R',defaut=0.3  ),
             MODU_EAU        =SIMP(statut='o',typ='R',defaut=0.0  ),
             W_EAU_0         =SIMP(statut='o',typ='R'),
             BIOT_GEL        =SIMP(statut='o',typ='R'),
             MODU_GEL        =SIMP(statut='o',typ='R'),
             VOL_GEL         =SIMP(statut='o',typ='R'),
             AVANC_LI        =SIMP(statut='o',typ='R'),
             SEUIL_SR        =SIMP(statut='o',typ='R'),
             PARA_CIN        =SIMP(statut='o',typ='R'),
             ENR_AC_G        =SIMP(statut='o',typ='R'),
           ),
           GLRC_DM         =FACT(statut='f',min=0,max=1,
             regles=(EXCLUS('GAMMA_C','SYC'),),
             GAMMA_T         =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=1.E+0),
             GAMMA_C         =SIMP(statut='f',typ='R',val_min=-1.E+0,val_max=1.E+0),
             GAMMA_F         =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=1.E+0),
             SYT             =SIMP(statut='o',typ='R',val_min=0.E+0),
             SYC             =SIMP(statut='f',typ='R'),
             SYF             =SIMP(statut='o',typ='R',val_min=0.E+0),
             EF              =SIMP(statut='f',typ='R',val_min=0.E+0),
             NUF             =SIMP(statut='f',typ='R',val_min=0.E+0,val_max=0.5+0),
           ),
           GATT_MONERIE    =FACT(statut='f',min=0,max=1,
             D_GRAIN         =SIMP(statut='o',typ='R',val_min=0.E+0),
             PORO_INIT       =SIMP(statut='o',typ='R',val_min=0.E+0),
             EPSI_01         =SIMP(statut='o',typ='R',defaut= 2.7252E-10,val_min=0.E+0),
             EPSI_02         =SIMP(statut='o',typ='R',defaut= 9.1440E-41,val_min=0.E+0),
           ),
           CORR_ACIER   =FACT(statut='f',min=0 ,max=1,
             D_CORR           =SIMP(statut='o',typ='R'),
             ECRO_K           =SIMP(statut='o',typ='R'),
             ECRO_M           =SIMP(statut='o',typ='R'),
             SY              =SIMP(statut='o',typ='R'),
             ),
# Discrets non-linaires : dbut
         DIS_ECRO_CINE  =FACT(statut='f',
            fr="Loi pour les discrets avec crouissage cinmatique.",
            regles=(PRESENT_PRESENT('LIMY_DX','KCIN_DX',),PRESENT_PRESENT('PUIS_DX','LIMU_DX',),
                    PRESENT_PRESENT('LIMY_DY','KCIN_DY',),PRESENT_PRESENT('PUIS_DY','LIMU_DY',),
                    PRESENT_PRESENT('LIMY_DZ','KCIN_DZ',),PRESENT_PRESENT('PUIS_DZ','LIMU_DZ',),
                    PRESENT_PRESENT('LIMY_RX','KCIN_RX',),PRESENT_PRESENT('PUIS_RX','LIMU_RX',),
                    PRESENT_PRESENT('LIMY_RY','KCIN_RY',),PRESENT_PRESENT('PUIS_RY','LIMU_RY',),
                    PRESENT_PRESENT('LIMY_RZ','KCIN_RZ',),PRESENT_PRESENT('PUIS_RZ','LIMU_RZ',),),
            LIMY_DX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Effort limite lastique suivant l'axe local x de l'lment."),
            LIMY_DY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Effort limite lastique suivant l'axe local y de l'lment."),
            LIMY_DZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Effort limite lastique suivant l'axe local z de l'lment."),
            LIMY_RX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Moment limite lastique suivant l'axe local x de l'lment."),
            LIMY_RY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Moment limite lastique suivant l'axe local y de l'lment."),
            LIMY_RZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Moment limite lastique suivant l'axe local z de l'lment."),
            KCIN_DX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Raideur suivant l'axe local x de l'lment."),
            KCIN_DY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Raideur suivant l'axe local y de l'lment."),
            KCIN_DZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Raideur suivant l'axe local z de l'lment."),
            KCIN_RX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Raideur suivant l'axe local Rx de l'lment."),
            KCIN_RY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Raideur suivant l'axe local Ry de l'lment."),
            KCIN_RZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Raideur suivant l'axe local Rz de l'lment."),
            LIMU_DX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Effort limite suivant l'axe local x de l'lment."),
            LIMU_DY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Effort limite suivant l'axe local y de l'lment."),
            LIMU_DZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Effort limite suivant l'axe local z de l'lment."),
            LIMU_RX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Moment limite suivant l'axe local x de l'lment."),
            LIMU_RY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Moment limite suivant l'axe local y de l'lment."),
            LIMU_RZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Moment limite suivant l'axe local z de l'lment."),
            PUIS_DX =SIMP(statut='f',typ='R',val_min = 1.0,
               fr="Coefficient de non-linarit suivant l'axe local x de l'lment."),
            PUIS_DY =SIMP(statut='f',typ='R',val_min = 1.0,
               fr="Coefficient de non-linarit suivant l'axe local y de l'lment."),
            PUIS_DZ =SIMP(statut='f',typ='R',val_min = 1.0,
               fr="Coefficient de non-linarit suivant l'axe local z de l'lment."),
            PUIS_RX =SIMP(statut='f',typ='R',val_min = 1.0,
               fr="Coefficient de non-linarit suivant l'axe local Rx de l'lment."),
            PUIS_RY =SIMP(statut='f',typ='R',val_min = 1.0,
               fr="Coefficient de non-linarit suivant l'axe local Ry de l'lment."),
            PUIS_RZ =SIMP(statut='f',typ='R',val_min = 1.0,
               fr="Coefficient de non-linarit suivant l'axe local Rz de l'lment."),
         ),
         DIS_VISC  =FACT(statut='f',
            fr="Loi pour un discret de type amortisseur visqueux.",
            regles=(PRESENT_PRESENT('PUIS_DX','COEF_DX',),
                    PRESENT_PRESENT('PUIS_DY','COEF_DY',),
                    PRESENT_PRESENT('PUIS_DZ','COEF_DZ',),
                    PRESENT_PRESENT('PUIS_RX','COEF_RX',),
                    PRESENT_PRESENT('PUIS_RY','COEF_RY',),
                    PRESENT_PRESENT('PUIS_RZ','COEF_RZ',),
                    ),
            PUIS_DX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Puissance dans la direction locale Dx de l'lment."),
            PUIS_DY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Puissance dans la direction locale Dy de l'lment."),
            PUIS_DZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Puissance dans la direction locale Dz de l'lment."),
            PUIS_RX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Puissance autour de la direction locale Rx de l'lment."),
            PUIS_RY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Puissance autour de la direction locale Ry de l'lment."),
            PUIS_RZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Puissance autour de la direction locale Rz de l'lment."),
            COEF_DX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Coefficient C dans la direction locale Dx de l'lment."),
            COEF_DY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Coefficient C dans la direction locale Dy de l'lment."),
            COEF_DZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Coefficient C dans la direction locale Dz de l'lment."),
            COEF_RX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Coefficient C autour de la direction locale Rx de l'lment."),
            COEF_RY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Coefficient C autour de la direction locale Ry de l'lment."),
            COEF_RZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr="Coefficient C autour de la direction locale Rz de l'lment."),
         ),
         DIS_BILI_ELAS  =FACT(statut='f',
            fr="Loi bi-linaire pour les discrets.",
            regles=(PRESENT_PRESENT('KDEB_DX','KFIN_DX','FPRE_DX',),
                    PRESENT_PRESENT('KDEB_DY','KFIN_DY','FPRE_DY',),
                    PRESENT_PRESENT('KDEB_DZ','KFIN_DZ','FPRE_DZ',),),
            KDEB_DX =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr="Raideur dbut suivant l'axe local x de l'lment."),
            KDEB_DY =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr="Raideur dbut suivant l'axe local y de l'lment."),
            KDEB_DZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr="Raideur dbut  suivant l'axe local z de l'lment."),
            KFIN_DX =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr="Raideur fin l'axe local x de l'lment."),
            KFIN_DY =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr="Raideur fin l'axe local y de l'lment."),
            KFIN_DZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr="Raideur fin l'axe local z de l'lment."),
            FPRE_DX =SIMP(statut='f',typ='R',
               fr="Effort de prserrage suivant l'axe local x de l'lment."),
            FPRE_DY =SIMP(statut='f',typ='R',
               fr="Effort de prserrage suivant l'axe local y de l'lment."),
            FPRE_DZ =SIMP(statut='f',typ='R',
               fr="Effort de prserrage suivant l'axe local z de l'lment."),
         ),
# Discrets non-linaires : fin
#
# comportement thermique
#
           THER_NL         =FACT(statut='f',
             regles=(UN_PARMI('BETA','RHO_CP', ),),
             LAMBDA          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BETA            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO_CP          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           THER_HYDR       =FACT(statut='f',
             LAMBDA          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BETA            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AFFINITE        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CHALHYDR        =SIMP(statut='o',typ='R'),
           ),
           THER            =FACT(statut='f',
             LAMBDA          =SIMP(statut='o',typ='R'),
             RHO_CP          =SIMP(statut='f',typ='R'),
           ),
           THER_FO         =FACT(statut='f',
             LAMBDA          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO_CP          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           THER_ORTH       =FACT(statut='f',
             LAMBDA_L        =SIMP(statut='o',typ='R'),
             LAMBDA_T        =SIMP(statut='o',typ='R'),
             LAMBDA_N        =SIMP(statut='f',typ='R'),
             RHO_CP          =SIMP(statut='f',typ='R'),
           ),
           THER_COQUE      =FACT(statut='f',
             COND_LMM        =SIMP(statut='o',typ='R'),
             COND_TMM        =SIMP(statut='o',typ='R'),
             COND_LMP        =SIMP(statut='o',typ='R'),
             COND_TMP        =SIMP(statut='o',typ='R'),
             COND_LPP        =SIMP(statut='o',typ='R'),
             COND_TPP        =SIMP(statut='o',typ='R'),
             COND_LSI        =SIMP(statut='o',typ='R'),
             COND_TSI        =SIMP(statut='o',typ='R'),
             COND_NMM        =SIMP(statut='o',typ='R'),
             COND_NMP        =SIMP(statut='o',typ='R'),
             COND_NPP        =SIMP(statut='o',typ='R'),
             COND_NSI        =SIMP(statut='o',typ='R'),
             CMAS_MM         =SIMP(statut='f',typ='R'),
             CMAS_MP         =SIMP(statut='f',typ='R'),
             CMAS_PP         =SIMP(statut='f',typ='R'),
             CMAS_SI         =SIMP(statut='f',typ='R'),
           ),
           THER_COQUE_FO   =FACT(statut='f',
             COND_LMM        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_TMM        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_LMP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_TMP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_LPP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_TPP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_LSI        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_TSI        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_NMM        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_NMP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_NPP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_NSI        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CMAS_MM         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CMAS_MP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CMAS_PP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CMAS_SI         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           SECH_GRANGER    =FACT(statut='f',
             A               =SIMP(statut='o',typ='R'),
             B               =SIMP(statut='o',typ='R'),
             QSR_K           =SIMP(statut='o',typ='R'),
             TEMP_0_C        =SIMP(statut='o',typ='R'),
           ),
           SECH_MENSI      =FACT(statut='f',
             A               =SIMP(statut='o',typ='R'),
             B               =SIMP(statut='o',typ='R'),
           ),
           SECH_BAZANT     =FACT(statut='f',
             D1              =SIMP(statut='o',typ='R'),
             ALPHA_BAZANT    =SIMP(statut='o',typ='R'),
             N               =SIMP(statut='o',typ='R'),
             FONC_DESORP     =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           SECH_NAPPE      =FACT(statut='f',
             FONCTION        =SIMP(statut='o',typ=(nappe_sdaster,formule)),
           ),
#
# comportement mtallurgique
#
           META_ACIER      =FACT(statut='f',
             TRC             =SIMP(statut='o',typ=(table_sdaster) ),
             AR3             =SIMP(statut='o',typ='R'),
             ALPHA           =SIMP(statut='o',typ='R'),
             MS0             =SIMP(statut='o',typ='R'),
             AC1             =SIMP(statut='o',typ='R'),
             AC3             =SIMP(statut='o',typ='R'),
             TAUX_1          =SIMP(statut='o',typ='R'),
             TAUX_3          =SIMP(statut='o',typ='R'),
             LAMBDA0         =SIMP(statut='f',typ='R'),
             QSR_K           =SIMP(statut='f',typ='R'),
             D10             =SIMP(statut='f',typ='R'),
             WSR_K           =SIMP(statut='f',typ='R'),
           ),
           META_ZIRC       =FACT(statut='f',
             TDEQ            =SIMP(statut='o',typ='R'),
             N               =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='o',typ='R'),
             T1C             =SIMP(statut='o',typ='R'),
             T2C             =SIMP(statut='o',typ='R'),
             AC              =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
             QSR_K           =SIMP(statut='o',typ='R'),
             T1R             =SIMP(statut='o',typ='R'),
             T2R             =SIMP(statut='o',typ='R'),
             AR              =SIMP(statut='o',typ='R'),
             BR              =SIMP(statut='o',typ='R'),
           ),
           DURT_META       =FACT(statut='f',
             F1_DURT         =SIMP(statut='o',typ='R'),
             F2_DURT         =SIMP(statut='o',typ='R'),
             F3_DURT         =SIMP(statut='o',typ='R'),
             F4_DURT         =SIMP(statut='o',typ='R'),
             C_DURT          =SIMP(statut='o',typ='R'),
           ),
           ELAS_META       =FACT(statut='f',
             E               =SIMP(statut='o',typ='R'),
             NU              =SIMP(statut='o',typ='R'),
             F_ALPHA         =SIMP(statut='o',typ='R'),
             C_ALPHA         =SIMP(statut='o',typ='R'),
             PHASE_REFE      =SIMP(statut='o',typ='TXM',into=("CHAUD","FROID")),
             EPSF_EPSC_TREF  =SIMP(statut='o',typ='R'),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.0E+0),
             F1_SY           =SIMP(statut='f',typ='R'),
             F2_SY           =SIMP(statut='f',typ='R'),
             F3_SY           =SIMP(statut='f',typ='R'),
             F4_SY           =SIMP(statut='f',typ='R'),
             C_SY            =SIMP(statut='f',typ='R'),
             SY_MELANGE      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_S_VP         =SIMP(statut='f',typ='R'),
             F2_S_VP         =SIMP(statut='f',typ='R'),
             F3_S_VP         =SIMP(statut='f',typ='R'),
             F4_S_VP         =SIMP(statut='f',typ='R'),
             C_S_VP          =SIMP(statut='f',typ='R' ),
             S_VP_MELANGE    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ELAS_META_FO    =FACT(statut='f',
             regles=(
                      PRESENT_PRESENT('F_ALPHA','TEMP_DEF_ALPHA'),
                      PRESENT_PRESENT('C_ALPHA','TEMP_DEF_ALPHA'),
                    ),
             E               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_ALPHA         =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_ALPHA         =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PHASE_REFE      =SIMP(statut='o',typ='TXM',into=("CHAUD","FROID")),
             EPSF_EPSC_TREF  =SIMP(statut='o',typ='R'),
             TEMP_DEF_ALPHA  =SIMP(statut='f',typ='R'),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.0E+0),
             F1_SY           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_SY           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_SY           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_SY           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_SY            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SY_MELANGE      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_S_VP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_S_VP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_S_VP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_S_VP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_S_VP          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             S_VP_MELANGE    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           META_ECRO_LINE  =FACT(statut='f',
             F1_D_SIGM_EPSI  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_D_SIGM_EPSI  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_D_SIGM_EPSI  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_D_SIGM_EPSI  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_D_SIGM_EPSI   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           META_TRACTION   =FACT(statut='f',
             SIGM_F1         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_F2         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_F3         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_F4         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_C          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           META_VISC_FO    =FACT(statut='f',
             F1_ETA          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_N            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_C            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_M            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_ETA          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_N            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_C            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_M            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_ETA          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_N            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_C            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_M            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_ETA          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_N            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_C            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_M            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_ETA           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_N             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_C             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_M             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           META_PT         =FACT(statut='f',
             F1_K            =SIMP(statut='f',typ='R'),
             F2_K            =SIMP(statut='f',typ='R'),
             F3_K            =SIMP(statut='f',typ='R'),
             F4_K            =SIMP(statut='f',typ='R'),
             F1_D_F_META     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_D_F_META     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_D_F_META     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_D_F_META     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           META_RE         =FACT(statut='f',
             C_F1_THETA      =SIMP(statut='f',typ='R'),
             C_F2_THETA      =SIMP(statut='f',typ='R'),
             C_F3_THETA      =SIMP(statut='f',typ='R'),
             C_F4_THETA      =SIMP(statut='f',typ='R'),
             F1_C_THETA      =SIMP(statut='f',typ='R'),
             F2_C_THETA      =SIMP(statut='f',typ='R'),
             F3_C_THETA      =SIMP(statut='f',typ='R'),
             F4_C_THETA      =SIMP(statut='f',typ='R'),
           ),
#
# comportement fluide
#
           FLUIDE          =FACT(statut='f',
             regles=(EXCLUS('CELE_C','CELE_R'),),
             RHO             =SIMP(statut='o',typ='R'),
             CELE_C          =SIMP(statut='f',typ='C'),
             CELE_R          =SIMP(statut='f',typ='R'),
           ),
# =================================================================================
# COMPORTEMENT THERMO_HYDRO_MECANIQUE
# LES DONNEES NECESSAIRES A LA DEFINITION DU MATERIAU SONT DEPENDANTES
# DE LA LOI DE COUPLAGE THM DE LA RELATION
# LE COMPORTEMENT DE COUPLAGE COMP_THM N EST VALABLE QUE POUR LES LOIS
# DE COUPLAGE : LIQU_SATU,LIQU_GAZ,GAZ,LIQU_GAZ_ATM,LIQU_VAPE_GAZ,LIQU_VAPE
# ET LIQU_AD_GAZ_VAPE
# LA CORRESPONDANCE AVEC LES VARIABLES CACHEES EST LA SUIVANTE :
# 1 -->  LIQU_SATU
# 2 -->  GAZ
# 3 -->  LIQU_VAPE
# 4 -->  LIQU_VAPE_GAZ
# 5 -->  LIQU_GAZ
# 6 -->  LIQU_GAZ_ATM
# 9 -->  LIQU_AD_GAZ_VAPE
# 10 -->  LIQU_AD_GAZ
# =================================================================================
           COMP_THM        = SIMP(statut='f', typ='TXM',
                                  into = ( "LIQU_SATU"     ,
                                           "LIQU_GAZ"      ,
                                           "GAZ"           ,
                                           "LIQU_GAZ_ATM"  ,
                                           "LIQU_VAPE_GAZ" ,
                                           "LIQU_VAPE"     ,
                                           "LIQU_AD_GAZ_VAPE" ,
                                           "LIQU_AD_GAZ" ,
                                          ) ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_SATU -------------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU -----------------------------------------------
# =================================================================================
           b_liqusatu      = BLOC(condition = "COMP_THM == 'LIQU_SATU' ",
                                 fr="Paramtres ncessaires pour une loi de couplage de type LIQU_SATU",
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1          = SIMP(statut='o',typ='R'),
                                           PORO          = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP          = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE2          = SIMP(statut='f',typ='R'),
                                           PRES_VAPE     = SIMP(statut='f',typ='R'),
                                           DEGR_SATU     = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 1.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO           = SIMP(statut='o',typ='R'),
                                           BIOT_COEF     = SIMP(statut='o',typ='R'),
                                           PESA_X        = SIMP(statut='o',typ='R'),
                                           PESA_Y        = SIMP(statut='o',typ='R'),
                                           PESA_Z        = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP            = SIMP(statut='f',typ='R'),
                                           PERM_IN       = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                                           regles = (EXCLUS('PERM_IN','PERM_END','PERMIN_X',),
                                                            PRESENT_PRESENT('PERMIN_X','PERMIN_Y','PERMIN_Z',), ),
                                           PERMIN_X      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Y      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Z      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINXY      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINYZ      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINZX      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT   = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ         = SIMP(statut='f',typ='R'),
                                           EMMAG           = SIMP(statut='f',typ='R'),
                                           SATU_PRES       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU=SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO           = SIMP(statut='o',typ='R'),
                                           UN_SUR_K      = SIMP(statut='o',typ='R'),
                                           VISC          = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP   = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA         = SIMP(statut='f',typ='R'),
                                           CP            = SIMP(statut='f',typ='R'),
                                         ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_GAZ         =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_VAPE_GAZ    =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_GAZ --------------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_GAZ --------------------------------------
# =================================================================================
           b_liqugaz      = BLOC(condition = "COMP_THM == 'LIQU_GAZ' ",
                                 fr="Paramtres ncessaires pour une loi de couplage de type LIQU_GAZ",
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PRE2             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           PRES_VAPE        = SIMP(statut='f',typ='R'),
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 5.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='o',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---Van Genhuchten et Muallen-----------------------------------------------------------------------------

                                           VG_N    = SIMP(statut='f',typ='R'),
                                           VG_SR    = SIMP(statut='f',typ='R'),
                                           VG_PR   = SIMP(statut='f',typ='R'),
                                           VG_SMAX = SIMP(statut='f',typ='R'),
                                           VG_SATUR = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
#
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                           PERM_IN          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_X      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Y      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Z      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINXY      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINYZ      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINZX      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT   = SIMP(statut='f',typ='R'),
#
                                  regles = (EXCLUS('PERM_IN','PERM_END','PERMIN_X',),
                                            PRESENT_PRESENT('PERMIN_X','PERMIN_Y','PERMIN_Z',),
                                            ENSEMBLE('SATU_PRES','D_SATU_PRES','PERM_LIQU','D_PERM_LIQU_SATU',
                                                            'PERM_GAZ','D_PERM_SATU_GAZ','D_PERM_PRES_GAZ',),
                                            ENSEMBLE('VG_N','VG_SR','VG_PR','VG_SMAX','VG_SATUR',),
                                            UN_PARMI('VG_N','SATU_PRES'),
                                           ),

# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG           = SIMP(statut='f',typ='R'),
                                           FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ='R'),
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL        = SIMP(statut='o',typ='R'),
                                           VISC            = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP     = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP              = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_VAPE_GAZ    =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE GAZ -------------------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_GAZ ------------------------------------------------
# =================================================================================
           b_gaz          = BLOC(condition = "COMP_THM == 'GAZ' ",
                                 fr="Paramtres ncessaires pour une loi de couplage de type GAZ",
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='o',typ='R'),
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE2             = SIMP(statut='f',typ='R'),
                                           PRES_VAPE        = SIMP(statut='f',typ='R'),
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 2.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='o',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                           PERM_IN          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                                           regles = (EXCLUS('PERM_IN','PERM_END','PERMIN_X',),
                                                            PRESENT_PRESENT('PERMIN_X','PERMIN_Y','PERMIN_Z',), ),
                                           PERMIN_X      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Y      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Z      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT   = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG           = SIMP(statut='f',typ='R'),
                                           SATU_PRES       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU=SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_LIQU        =FACT(statut='f',
             RHO             =SIMP(statut='f',typ='R'),
             UN_SUR_K        =SIMP(statut='f',typ='R'),
             ALPHA           =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COEF_HENRY      =SIMP(statut='f',typ='R'),
           ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_VAPE_GAZ    =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_GAZ_ATM ----------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_GAZ --------------------------------------
# =================================================================================
           b_liqugazatm   = BLOC(condition = "COMP_THM == 'LIQU_GAZ_ATM' ",
                                 fr="Paramtres ncessaires pour une loi de couplage de type LIQU_GAZ_ATM",
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE2             = SIMP(statut='f',typ='R'),
                                           PRES_VAPE        = SIMP(statut='f',typ='R'),
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 6.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='o',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                           PERM_IN          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                                           regles = (EXCLUS('PERM_IN','PERM_END','PERMIN_X',),
                                                            PRESENT_PRESENT('PERMIN_X','PERMIN_Y','PERMIN_Z',), ),
                                           PERMIN_X      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Y      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Z      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT   = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
             EMMAG           = SIMP(statut='f',typ='R'),
             R_GAZ           =SIMP(statut='f',typ='R'),
             PERM_GAZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_PERM_SATU_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_PERM_PRES_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ='R'),
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='f',
                                           MASS_MOL         = SIMP(statut='f',typ='R'),
                                           VISC             = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_VAPE_GAZ    =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
                                 ),

# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_AD_GAZ -------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_GAZ,  THM_AIR_DISSOUS---------
# =================================================================================
           b_liquadgaz  = BLOC(condition = "COMP_THM == 'LIQU_AD_GAZ' ",
                                 fr="Paramtres ncessaires pour une loi de couplage de type LIQU_AD_GAZ",
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PRE2             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
                                           PRES_VAPE        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 10.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='o',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---Van Genhuchten et Muallen-----------------------------------------------------------------------------
                                           VG_N     = SIMP(statut='f',typ='R'),
                                           VG_SR    = SIMP(statut='f',typ='R'),
                                           VG_PR    = SIMP(statut='f',typ='R'),
                                           VG_SMAX  = SIMP(statut='f',typ='R'),
                                           VG_SATUR = SIMP(statut='f',typ='R'),
#
                                           FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                           PERM_IN          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_X      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Y      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Z      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINXY      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINYZ      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINZX      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT   = SIMP(statut='f',typ='R'),
#
                                  regles = (EXCLUS('PERM_IN','PERM_END','PERMIN_X',),
                                            PRESENT_PRESENT('PERMIN_X','PERMIN_Y','PERMIN_Z',),
                                            ENSEMBLE('SATU_PRES','D_SATU_PRES','PERM_LIQU','D_PERM_LIQU_SATU',
                                                            'PERM_GAZ','D_PERM_SATU_GAZ','D_PERM_PRES_GAZ',),
                                            ENSEMBLE('VG_N','VG_SR','VG_PR','VG_SMAX','VG_SATUR',),
                                            UN_PARMI('VG_N','SATU_PRES'),
                                           ),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG            = SIMP(statut='f',typ='R'),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
#
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ='R'),
                                           CP               = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                             ),
# =================================================================================
# --- MOT-CLE FACULTATIF ---------------------------------------------------------
# =================================================================================
                             THM_VAPE_GAZ = FACT(statut='f',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           CP               = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_AIR_DISS = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='o',typ='R'),
                                           COEF_HENRY       = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ),
                                 ),

# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_VAPE_GAZ ---------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_GAZ, THM_VAPE_GAZ ------------------------
# =================================================================================
           b_liquvapegaz  = BLOC(condition = "COMP_THM == 'LIQU_VAPE_GAZ' ",
                                 fr="Paramtres ncessaires pour une loi de couplage de type LIQU_VAPE_GAZ",
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PRE2             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
                                           PRES_VAPE        = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 4.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='o',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---Van Genhuchten et Muallen-----------------------------------------------------------------------------

                                           VG_N     = SIMP(statut='f',typ='R'),
                                           VG_SR    = SIMP(statut='f',typ='R'),
                                           VG_PR    = SIMP(statut='f',typ='R'),
                                           VG_SMAX  = SIMP(statut='f',typ='R'),
                                           VG_SATUR = SIMP(statut='f',typ='R'),
#
                                           FICKV_T          = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                           PERM_IN          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_X      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Y      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Z      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINXY      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINYZ      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINZX      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT   = SIMP(statut='f',typ='R'),
#
                                  regles = (EXCLUS('PERM_IN','PERM_END','PERMIN_X',),
                                            PRESENT_PRESENT('PERMIN_X','PERMIN_Y','PERMIN_Z',),
                                            ENSEMBLE('SATU_PRES','D_SATU_PRES','PERM_LIQU','D_PERM_LIQU_SATU',
                                                            'PERM_GAZ','D_PERM_SATU_GAZ','D_PERM_PRES_GAZ',),
                                            ENSEMBLE('VG_N','VG_SR','VG_PR','VG_SMAX','VG_SATUR',),
                                            UN_PARMI('VG_N','SATU_PRES'),
                                           ),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVE   ----------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG            = SIMP(statut='f',typ='R'),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ='R'),
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_VAPE_GAZ = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           CP               = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_AD_GAZ_VAPE -------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_GAZ, THM_VAPE_GAZ THM_AIR_DISSOUS---------
# =================================================================================
           b_liquadvape  = BLOC(condition = "COMP_THM == 'LIQU_AD_GAZ_VAPE' ",
                                 fr="Paramtres ncessaires pour une loi de couplage de type LIQU_AD_GAZ_VAPE",
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PRE2             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
                                           PRES_VAPE        = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 9.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='o',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---Van Genhuchten et Muallen-----------------------------------------------------------------------------
                                           VG_N     = SIMP(statut='f',typ='R'),
                                           VG_SR    = SIMP(statut='f',typ='R'),
                                           VG_PR    = SIMP(statut='f',typ='R'),
                                           VG_SMAX  = SIMP(statut='f',typ='R'),
                                           VG_SATUR = SIMP(statut='f',typ='R'),
#
                                           FICKV_T          = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                           PERM_IN          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_X      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Y      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Z      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINXY      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINYZ      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINZX      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT   = SIMP(statut='f',typ='R'),
#
                                  regles = (EXCLUS('PERM_IN','PERM_END','PERMIN_X',),
                                            PRESENT_PRESENT('PERMIN_X','PERMIN_Y','PERMIN_Z',),
                                            ENSEMBLE('SATU_PRES','D_SATU_PRES','PERM_LIQU','D_PERM_LIQU_SATU',
                                                            'PERM_GAZ','D_PERM_SATU_GAZ','D_PERM_PRES_GAZ',),
                                            ENSEMBLE('VG_N','VG_SR','VG_PR','VG_SMAX','VG_SATUR',),
                                            UN_PARMI('VG_N','SATU_PRES'),
                                           ),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG            = SIMP(statut='f',typ='R'),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
#
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ='R'),
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_VAPE_GAZ = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           CP               = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_AIR_DISS = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='o',typ='R'),
                                           COEF_HENRY       = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_VAPE -------------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_VAPE_GAZ ---------------------------------
# =================================================================================
           b_liquvape  = BLOC(condition = "COMP_THM == 'LIQU_VAPE' ",
                                 fr="Paramtres ncessaires pour une loi de couplage de type LIQU_VAPE",
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
                                           PRES_VAPE        = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE2             = SIMP(statut='f',typ='R'),
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 3.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='o',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---Van Genhuchten et Muallen-----------------------------------------------------------------------------

                                           VG_N    = SIMP(statut='f',typ='R'),
                                           VG_SR    = SIMP(statut='f',typ='R'),
                                           VG_PR   = SIMP(statut='f',typ='R'),
                                           VG_SMAX = SIMP(statut='f',typ='R'),
                                           VG_SATUR = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                           PERM_IN          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_X      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Y      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_Z      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINXY      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINYZ      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMINZX      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT   = SIMP(statut='f',typ='R'),
#
                                  regles = (EXCLUS('PERM_IN','PERM_END','PERMIN_X',),
                                            PRESENT_PRESENT('PERMIN_X','PERMIN_Y','PERMIN_Z',),
                                            ENSEMBLE('SATU_PRES','D_SATU_PRES','PERM_LIQU','D_PERM_LIQU_SATU',
                                                            'PERM_GAZ','D_PERM_SATU_GAZ','D_PERM_PRES_GAZ',),
                                            ENSEMBLE('VG_N','VG_SR','VG_PR','VG_SMAX','VG_SATUR',),
                                            UN_PARMI('VG_N','SATU_PRES'),
                                           ),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG            = SIMP(statut='f',typ='R'),
                                           FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ='R'),
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_VAPE_GAZ = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           CP               = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_GAZ         =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
                                 ),
# courbes et coefficients associs  la fatigue et au dommage
#
           FATIGUE         =FACT(statut='f',
             regles=(PRESENT_ABSENT('WOHLER','A_BASQUIN','BETA_BASQUIN'),
                     PRESENT_ABSENT('WOHLER','A0','A1','A2','A3','SL'),
                     PRESENT_ABSENT('A_BASQUIN','A0','A1','A2','A3','SL'),
                     ENSEMBLE('A_BASQUIN','BETA_BASQUIN'),
                     ENSEMBLE('A0','A1','A2','A3','SL'),
                     PRESENT_PRESENT('A0','E_REFE'),
                     ENSEMBLE('D0','TAU0'),),
             WOHLER          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_BASQUIN       =SIMP(statut='f',typ='R'),
             BETA_BASQUIN    =SIMP(statut='f',typ='R'),
             A0              =SIMP(statut='f',typ='R'),
             A1              =SIMP(statut='f',typ='R'),
             A2              =SIMP(statut='f',typ='R'),
             A3              =SIMP(statut='f',typ='R'),
             SL              =SIMP(statut='f',typ='R'),
             MANSON_COFFIN   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             E_REFE          =SIMP(statut='f',typ='R'),
             D0              =SIMP(statut='f',typ='R'),
             TAU0            =SIMP(statut='f',typ='R'),
           ),
           DOMMA_LEMAITRE  =FACT(statut='f',
             S               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             EPSP_SEUIL      =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             EXP_S           =SIMP(statut='f',typ='R',val_min=0.0E0,defaut=1.0),
           ),
           CISA_PLAN_CRIT  =FACT(statut='f',
             CRITERE       =SIMP(statut='o',typ='TXM',into=("MATAKE_MODI_AC",
                                                            "DANG_VAN_MODI_AC",
                                                            "DANG_VAN_MODI_AV",
                                                            "MATAKE_MODI_AV",
                                                            "FATESOCI_MODI_AV",
                                                            ) ),

             b_critere_matake =BLOC(condition="CRITERE=='MATAKE_MODI_AC' or CRITERE=='MATAKE_MODI_AV'",
                         fr="Cisaillement plan critique critre de matake pour les cas amplitude constante et amplitude variable",
               MATAKE_A         =SIMP(statut='o',typ='R'),
               MATAKE_B         =SIMP(statut='o',typ='R'),
               COEF_FLEX_TORS   =SIMP(statut='o',typ='R',val_min=1.0E0,val_max=1.7321E0),
             ),

             b_critere_dang_van =BLOC(condition="(CRITERE=='DANG_VAN_MODI_AC' or CRITERE=='DANG_VAN_MODI_AV')",
                                 fr="Critre de Dang Van modifi pour les cas amplitude constante et amplitude variable",
               D_VAN_A            =SIMP(statut='o',typ='R'),
               D_VAN_B            =SIMP(statut='o',typ='R'),
               COEF_CISA_TRAC     =SIMP(statut='o',typ='R',val_min=1.0E0,val_max=1.7321E0),
             ),

             b_critere_fate_soci =BLOC(condition="CRITERE=='FATESOCI_MODI_AV'",
                               fr="Critre de Fatemi et Socie, en lasticit ou lastoplasticit, pour le cas amplitude variable",
               FATSOC_A           =SIMP(statut='o',typ='R'),
               COEF_CISA_TRAC     =SIMP(statut='o',typ='R',val_min=1.0E0,val_max=1.7321E0),
             ),
           ),


           THM_RUPT       =FACT(statut='f',
             OUV_FICT        =SIMP(statut='o',typ='R'),
             UN_SUR_N        =SIMP(statut='f',typ='R',defaut= 0.),
           ),
#
# autres comportements ...
#
           WEIBULL         =FACT(statut='f',
             M               =SIMP(statut='o',typ='R'),
             VOLU_REFE       =SIMP(statut='o',typ='R'),
             SIGM_REFE       =SIMP(statut='o',typ='R'),
             SEUIL_EPSP_CUMU =SIMP(statut='f',typ='R',defaut= 1.0E-6),
           ),
           WEIBULL_FO      =FACT(statut='f',
             M               =SIMP(statut='o',typ='R'),
             VOLU_REFE       =SIMP(statut='o',typ='R'),
             SIGM_CNV        =SIMP(statut='o',typ='R'),
             SIGM_REFE       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SEUIL_EPSP_CUMU =SIMP(statut='f',typ='R',defaut= 1.0E-6),
           ),
           NON_LOCAL       =FACT(statut='f',
             regles=(AU_MOINS_UN('LONG_CARA','C_GONF','C_GRAD_VARI','PENA_LAGR',),),
             LONG_CARA       =SIMP(statut='f',typ='R'),
             C_GRAD_VARI     =SIMP(statut='f',typ='R'),
             PENA_LAGR       =SIMP(statut='f',typ='R',defaut= 1.0E3),
             C_GONF          =SIMP(statut='f',typ='R'),
             COEF_RIGI_MINI  =SIMP(statut='f',typ='R'),
           ),
           RUPT_FRAG       =FACT(statut='f',
             GC              =SIMP(statut='o',typ='R'),
             SIGM_C          =SIMP(statut='f',typ='R'),
             PENA_ADHERENCE  =SIMP(statut='f',typ='R',val_min=1.E-12,val_max=1.E+0),
             PENA_CONTACT    =SIMP(statut='f',typ='R',defaut=1.),
             PENA_LAGR       =SIMP(statut='f',typ='R',defaut=1.0E2,val_min=1.01E+0),
             RIGI_GLIS       =SIMP(statut='f',typ='R',defaut=1.0E1),
           ),
           RUPT_FRAG_FO   =FACT(statut='f',
             GC              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_C          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PENA_ADHERENCE  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PENA_CONTACT    =SIMP(statut='f',typ='R',defaut=1.),
           ),
           RUPT_DUCT       =FACT(statut='f',
             GC              =SIMP(statut='o',typ='R'),
             SIGM_C          =SIMP(statut='o',typ='R'),
             COEF_EXTR       =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=9.99E-1),
             COEF_PLAS       =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=9.99E-1),
             PENA_LAGR       =SIMP(statut='f',typ='R',defaut=1.0E2,val_min=1.01E+0),
             RIGI_GLIS       =SIMP(statut='f',typ='R',defaut=1.0E1),
           ),
           JOINT_MECA_RUPT  =FACT(statut='f',
             regles=(EXCLUS('PRES_FLUIDE','PRES_CLAVAGE'),
                     PRESENT_PRESENT('RHO_FLUIDE','VISC_FLUIDE','OUV_MIN'),
                     PRESENT_ABSENT('PRES_FLUIDE','RHO_FLUIDE','VISC_FLUIDE','OUV_MIN'),
                     PRESENT_ABSENT('PRES_CLAVAGE','RHO_FLUIDE','VISC_FLUIDE','OUV_MIN'),
                     PRESENT_ABSENT('RHO_FLUIDE','PRES_FLUIDE','PRES_CLAVAGE'),
                     PRESENT_ABSENT('VISC_FLUIDE','PRES_FLUIDE','PRES_CLAVAGE'),
                     PRESENT_ABSENT('OUV_MIN','PRES_FLUIDE','PRES_CLAVAGE'),
                     ),
             K_N             =SIMP(statut='o',typ='R',val_min=1.E-12),
             K_T             =SIMP(statut='f',typ='R',val_min=1.E-12),
             SIGM_MAX        =SIMP(statut='o',typ='R',val_min=0.),
             ALPHA           =SIMP(statut='f',typ='R',defaut=1., val_min=0., val_max=2.),
             PENA_RUPTURE    =SIMP(statut='f',typ='R',val_min=1.E-12,val_max=10.E+0),
             PENA_CONTACT    =SIMP(statut='f',typ='R',defaut=1.,val_min=1.E-12),
             PRES_FLUIDE     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PRES_CLAVAGE    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO_FLUIDE      =SIMP(statut='f',typ='R',val_min=0.),
             VISC_FLUIDE     =SIMP(statut='f',typ='R',val_min=1.E-20),
             OUV_MIN         =SIMP(statut='f',typ='R',val_min=1.E-15), 
           ),
           JOINT_MECA_FROT   =FACT(statut='f',
             K_N             =SIMP(statut='o',typ='R',val_min=1.E-12),
             K_T             =SIMP(statut='f',typ='R',val_min=1.E-12),
             MU              =SIMP(statut='o',typ='R',val_min=1.E-3),             
             PENA_TANG       =SIMP(statut='f',typ='R',val_min=0.),
             ADHESION        =SIMP(statut='f',typ='R',defaut=0., val_min=0.),
           ),           
           RCCM            =FACT(statut='f',
             regles=(ENSEMBLE('A_AMORC','B_AMORC','D_AMORC','R_AMORC'),),
             SY_02           =SIMP(statut='f',typ='R'),
             SM              =SIMP(statut='f',typ='R'),
             SU              =SIMP(statut='f',typ='R'),
             SC              =SIMP(statut='f',typ='R'),
             SH              =SIMP(statut='f',typ='R'),
             N_KE            =SIMP(statut='f',typ='R'),
             M_KE            =SIMP(statut='f',typ='R'),
             A_AMORC         =SIMP(statut='f',typ='R'),
             B_AMORC         =SIMP(statut='f',typ='R'),
             D_AMORC         =SIMP(statut='f',typ='R'),
             R_AMORC         =SIMP(statut='f',typ='R'),
           ),
           RCCM_FO         =FACT(statut='f',
             regles=(ENSEMBLE('A_AMORC','B_AMORC','D_AMORC','R_AMORC'),),
             SY_02           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SM              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SU              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             S               =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             N_KE            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_KE            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_AMORC         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B_AMORC         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_AMORC         =SIMP(statut='f',typ='R'),
             R_AMORC         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           LAIGLE          =FACT(statut='f',
             GAMMA_ULT       =SIMP(statut='o',typ='R'),
             GAMMA_E         =SIMP(statut='o',typ='R'),
             M_ULT           =SIMP(statut='o',typ='R'),
             M_E             =SIMP(statut='o',typ='R'),
             A_E             =SIMP(statut='o',typ='R'),
             M_PIC           =SIMP(statut='o',typ='R'),
             A_PIC           =SIMP(statut='o',typ='R'),
             ETA             =SIMP(statut='o',typ='R'),
             SIGMA_C         =SIMP(statut='o',typ='R'),
             GAMMA           =SIMP(statut='o',typ='R'),
             KSI             =SIMP(statut='o',typ='R'),
             GAMMA_CJS       =SIMP(statut='o',typ='R'),
             SIGMA_P1        =SIMP(statut='o',typ='R'),
             PA              =SIMP(statut='o',typ='R'),
           ),
           LETK          =FACT(statut='f',
             PA         =SIMP(statut='o',typ='R',fr="pression atmospherique"),
             NELAS      =SIMP(statut='o',typ='R',fr="exposant de la loi de variation des modules K et G"),
             SIGMA_C    =SIMP(statut='o',typ='R',fr="rsistance en compression simple "),
             H0_EXT     =SIMP(statut='o',typ='R',fr="parametre pilotant la rsistance en extension"),
             GAMMA_CJS  =SIMP(statut='o',typ='R',fr="parametre de forme du critere ds le plan dviatoire entre 0 et 1."),
             XAMS       =SIMP(statut='o',typ='R',fr="parametre non nul intervenant dans les lois d'crouissage pre pic"),
             ETA        =SIMP(statut='o',typ='R',fr="parametre non nul intervenant dans les lois d'crouissage post pic"),
             A_0        =SIMP(statut='o',typ='R',fr="a de la limite d'lasticit initiale"),
             A_E        =SIMP(statut='o',typ='R',fr="a de la limite de clivage ou seuil intermdiaire"),
             A_PIC      =SIMP(statut='o',typ='R',fr="a du seuil de pic"),
             S_0        =SIMP(statut='o',typ='R',fr="s de la limite d'lasticit initiale"),
             M_0        =SIMP(statut='o',typ='R',fr="m de la limite d'lasticit initiale"),
             M_E        =SIMP(statut='o',typ='R',fr="m de la limite de clivage ou seuil intermdiaire"),
             M_PIC      =SIMP(statut='o',typ='R',fr="m du seuil de pic"),
             M_ULT      =SIMP(statut='o',typ='R',fr="m du seuil residuel"),
             XI_ULT     =SIMP(statut='o',typ='R',fr="niveau d crouissage pour atteindre le seuil rsiduel"),
             XI_E       =SIMP(statut='o',typ='R',fr="niveau d crouissage pour atteindre le seuil de clivage"),
             XI_PIC     =SIMP(statut='o',typ='R',fr="niveau d crouissage pour atteindre le seuil de pic"),
             MV_MAX     =SIMP(statut='o',typ='R',fr="m du seuil viscoplastique maximal"),
             XIV_MAX    =SIMP(statut='o',typ='R',fr="niveau d crouissage pour atteindre le seuil viscoplastique maximal"),
             A          =SIMP(statut='o',typ='R',fr="parametre carcaterisant l amplitude de la vitesse de fluage"),
             N          =SIMP(statut='o',typ='R',fr="parametre intervenant dans la formule pilotant la cinetique de fluage"),
             SIGMA_P1   =SIMP(statut='o',typ='R',fr="SIG min de l intersection du seuil de pic et intermediaire "),
             MU0_V      =SIMP(statut='o',typ='R',fr="relatif  l angle de dilatance des mecanismes pre pic et viscoplastique"),
             XI0_V      =SIMP(statut='o',typ='R',fr="relatif  l angle de dilatance des mecanismes pre pic et viscoplastique"),
             MU1        =SIMP(statut='o',typ='R',fr="relatif  l angle de dilatance du mecanisme post pic "),
             XI1        =SIMP(statut='o',typ='R',fr="relatif  l angle de dilatance du mecanisme post pic "),
           ),
           DRUCK_PRAGER  =FACT(statut='f',
             ALPHA           =SIMP(statut='o',typ='R'),
             SY              =SIMP(statut='o',typ='R'),
             P_ULTM          =SIMP(statut='o',typ='R'),
             ECROUISSAGE = SIMP(statut='o',typ='TXM',into=("LINEAIRE","PARABOLIQUE")),
             b_lineaire =BLOC(condition="ECROUISSAGE=='LINEAIRE'",
                                    fr="Loi de comportement de type Drucker Prager avec un ecrouissage lineaire",
                    H               =SIMP(statut='o',typ='R'),
                    TYPE_DP         =SIMP(statut='c',typ='R',defaut= 1.0,),
             ),
             b_parabolique =BLOC(condition="ECROUISSAGE=='PARABOLIQUE'",
                                    fr="Loi de comportement de type Drucker Prager avec un ecrouissage parabolique",
                    SY_ULTM         =SIMP(statut='o',typ='R'),
                    TYPE_DP         =SIMP(statut='c',typ='R',defaut= 2.0,),
             ),
             DILAT           =SIMP(statut='f',typ='R',defaut=0.0),
           ),

           DRUCK_PRAGER_FO  =FACT(statut='f',
             ALPHA           =SIMP(statut='o',typ=(fonction_sdaster,formule)),
             SY              =SIMP(statut='o',typ=(fonction_sdaster,formule)),
             P_ULTM          =SIMP(statut='o',typ=(fonction_sdaster,formule)),
             ECROUISSAGE = SIMP(statut='o',typ='TXM',into=("LINEAIRE","PARABOLIQUE")),
             b_lineaire =BLOC(condition="ECROUISSAGE=='LINEAIRE'",
                                    fr="Loi de comportement de type Drucker Prager avec un ecrouissage lineaire",
                    H               =SIMP(statut='o',typ=(fonction_sdaster,formule)),
                    TYPE_DP         =SIMP(statut='c',typ='R',defaut= 1.0,),
             ),
             b_parabolique =BLOC(condition="ECROUISSAGE=='PARABOLIQUE'",
                                    fr="Loi de comportement de type Drucker Prager avec un ecrouissage parabolique",
                    SY_ULTM         =SIMP(statut='o',typ=(fonction_sdaster,formule)),
                    TYPE_DP         =SIMP(statut='c',typ='R',defaut= 2.0,),
             ),
            DILAT           =SIMP(statut='f',typ='R',defaut=0.0),
           ),

           VISC_DRUC_PRAG          =FACT(statut='f',
             PREF       =SIMP(statut='o',typ='R',fr="pression de reference"),
             A          =SIMP(statut='o',typ='R',fr="parametre carcaterisant l amplitude de la vitesse de fluage"),
             N          =SIMP(statut='o',typ='R',fr="parametre intervenant dans la formule pilotant la cinetique de fluage"),
             P_PIC      =SIMP(statut='o',typ='R',fr="niveau d ecrouissage pour atteindre le seuil de pic"),
             P_ULT      =SIMP(statut='o',typ='R',fr="niveau d ecrouissage pour atteindre le seuil utime"),
             ALPHA_0    =SIMP(statut='o',typ='R',fr="parametre d ecrouissage relatif  la cohesion au seuil d elasticite"),
             ALPHA_PIC  =SIMP(statut='o',typ='R',fr="parametre d ecrouissage relatif  la cohesion au seuil de pic"),
             ALPHA_ULT  =SIMP(statut='o',typ='R',fr="parametre d ecrouissage relatif  la cohesion au seuil ultime"),
             R_0        =SIMP(statut='o',typ='R',fr="parametre d ecrouissage correspondant au seuil d'elasticite"),
             R_PIC      =SIMP(statut='o',typ='R',fr="parametre d ecrouissage correspondant au seuil de pic"),
             R_ULT      =SIMP(statut='o',typ='R',fr="parametre d ecrouissage correspondant au seuil ultime"),
             BETA_0     =SIMP(statut='o',typ='R',fr="parametre d ecrouissage relatif  la dilatance au seuil d elasticite"),
             BETA_PIC   =SIMP(statut='o',typ='R',fr="parametre d ecrouissage relatif  la dilatance au seuil de pic"),
             BETA_ULT   =SIMP(statut='o',typ='R',fr="parametre d ecrouissage relatif  la dilatance au seuil ultime"),
           ),
             HOEK_BROWN          =FACT(statut='f',
             GAMMA_RUP       =SIMP(statut='o',typ='R'),
             GAMMA_RES       =SIMP(statut='o',typ='R'),
             S_END           =SIMP(statut='o',typ='R'),
             S_RUP           =SIMP(statut='o',typ='R'),
             M_END           =SIMP(statut='o',typ='R'),
             M_RUP           =SIMP(statut='o',typ='R'),
             BETA            =SIMP(statut='o',typ='R'),
             ALPHAHB         =SIMP(statut='o',typ='R'),
             PHI_RUP         =SIMP(statut='o',typ='R'),
             PHI_RES         =SIMP(statut='o',typ='R'),
             PHI_END         =SIMP(statut='f',typ='R'),
           ),
             ELAS_GONF             =FACT(statut='f',
             BETAM           =SIMP(statut='o',typ='R'),
             PREF            =SIMP(statut='o',typ='R'),
           ),
             JOINT_BANDIS         =FACT(statut='f',
             K                =SIMP(statut='o',typ='R'),
             DMAX             =SIMP(statut='o',typ='R'),
             GAMMA            =SIMP(statut='o',typ='R'),
             KT               =SIMP(statut='f',typ='R',defaut = 1.E12),
           ),
####  MONOCRISTAL

           MONO_VISC1      =FACT(statut='f',
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             N               =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='o',typ='R'),
             C               =SIMP(statut='o',typ='R'),
           ),
           MONO_VISC2      =FACT(statut='f',
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             N               =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='o',typ='R'),
             C               =SIMP(statut='o',typ='R'),
             D               =SIMP(statut='o',typ='R'),
             A               =SIMP(statut='o',typ='R'),
           ),
           MONO_VISC3      =FACT(statut='f',
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             K               =SIMP(statut='o',typ='R',fr="Constante de Boltzmann, en eV/K"),
             TAUMU           =SIMP(statut='o',typ='R',fr="Seuil d ecoulement, en unite de contraintes"),
             GAMMA0          =SIMP(statut='o',typ='R',fr="Vitesse d ecoulement initiale"),
             DELTAV          =SIMP(statut='o',typ='R',fr="Volume d activation"),
             DELTAG0         =SIMP(statut='o',typ='R',fr="Gain d energie lie au franchissement d obstacle"),
           ),
           MONO_ISOT1      =FACT(statut='f',
              regles=(UN_PARMI('H','H1'),
                      PRESENT_PRESENT('H1','H2','H3','H4'),
                      PRESENT_ABSENT('H','H1','H2','H3','H4','H5','H6'),
                      ),
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECRO_ISOT",),),
             R_0             =SIMP(statut='o',typ='R'),
             Q               =SIMP(statut='o',typ='R'),
             B               =SIMP(statut='o',typ='R'),
             H               =SIMP(statut='f',typ='R'),
             H1              =SIMP(statut='f',typ='R'),
             H2              =SIMP(statut='f',typ='R'),
             H3              =SIMP(statut='f',typ='R'),
             H4              =SIMP(statut='f',typ='R'),
             H5              =SIMP(statut='f',typ='R'),
             H6              =SIMP(statut='f',typ='R'),
           ),
           MONO_ISOT2      =FACT(statut='f',
              regles=(UN_PARMI('H','H1'),
                      PRESENT_PRESENT('H1','H2','H3','H4'),
                      PRESENT_ABSENT('H','H1','H2','H3','H4','H5','H6'),
                      ),
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECRO_ISOT",),),
             R_0             =SIMP(statut='o',typ='R'),
             Q1              =SIMP(statut='o',typ='R'),
             B1              =SIMP(statut='o',typ='R'),
             H               =SIMP(statut='f',typ='R'),
             H1              =SIMP(statut='f',typ='R'),
             H2              =SIMP(statut='f',typ='R'),
             H3              =SIMP(statut='f',typ='R'),
             H4              =SIMP(statut='f',typ='R'),
             H5              =SIMP(statut='f',typ='R'),
             H6              =SIMP(statut='f',typ='R'),
             Q2              =SIMP(statut='o',typ='R'),
             B2              =SIMP(statut='o',typ='R'),
           ),
           MONO_CINE1      =FACT(statut='f',
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECRO_CINE",),),
             D               =SIMP(statut='o',typ='R'),
           ),
           MONO_CINE2      =FACT(statut='f',
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECRO_CINE",),),
             D               =SIMP(statut='o',typ='R'),
             GM              =SIMP(statut='o',typ='R'),
             PM              =SIMP(statut='o',typ='R'),
             C               =SIMP(statut='o',typ='R'),
           ),
           MONO_DD_KR      =FACT(statut='f',
              regles=(UN_PARMI('H','H1'),
                      PRESENT_PRESENT('H1','H2','H3','H4'),
                      PRESENT_ABSENT('H','H1','H2','H3','H4','H5','H6'),
                      ),
            # TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             K               =SIMP(statut='o',typ='R',fr="Constante de Boltzmann, en eV/K"),
             TAUR            =SIMP(statut='o',typ='R',fr="Contraintes de cisaillement  T=0K, en unite de contraintes"),
             TAU0            =SIMP(statut='o',typ='R',fr="Contraintes critique initiale de cisaillement, en unite de contraintes"),
             GAMMA0          =SIMP(statut='o',typ='R',fr="Vitesse d ecoulement initiale"),
             DELTAG0         =SIMP(statut='o',typ='R',fr="Gain d energie lie au franchissement d obstacle"),
             BSD             =SIMP(statut='o',typ='R',fr="fonction de la taille du grain B/D"),
             GCB             =SIMP(statut='o',typ='R',fr="distance critique d'annihilation GC/B"),
             KDCS            =SIMP(statut='o',typ='R',fr="Parametre relatif  la direction principale de la dislocation"),
             P               =SIMP(statut='o',typ='R',fr="Parametre materiau dpendant de la forme de l'obstacle"),
             Q               =SIMP(statut='o',typ='R',fr="Parametre materiau dpendant de la forme de l'obstacle"),
             H               =SIMP(statut='f',typ='R'),
             H1              =SIMP(statut='f',typ='R'),
             H2              =SIMP(statut='f',typ='R'),
             H3              =SIMP(statut='f',typ='R'),
             H4              =SIMP(statut='f',typ='R'),
             H5              =SIMP(statut='f',typ='R'),
             H6              =SIMP(statut='f',typ='R'),
           ),
           MONO_DD_CFC      =FACT(statut='f',
             regles=(UN_PARMI('H','H1'),
                     PRESENT_PRESENT('H1','H2','H3','H4','H5'),
                     PRESENT_ABSENT('H','H1','H2','H3','H4','H5'),
                     ),
             #TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             GAMMA0          =SIMP(statut='f',typ='R',defaut=0.001,fr="Vitesse d ecoulement initiale en s**-1"),
             TAU_F           =SIMP(statut='o',typ='R',fr="Contraintes , en unite de contraintes ex 20 MPa"),
             A               =SIMP(statut='f',typ='R',defaut=0.13,fr="paramtre A, sans unit"),
             B               =SIMP(statut='f',typ='R',defaut=0.005,fr="paramtre B, sans unit"),
             N               =SIMP(statut='f',typ='R',defaut=200.,fr="paramtre n, sans unit"),
             Y               =SIMP(statut='o',typ='R',fr="paramte Y, en unit de longueur ex 2.5 A"),
             ALPHA           =SIMP(statut='f',typ='R',defaut=0.35,fr="ecrouissage, paramtre alpha"),
             BETA            =SIMP(statut='o',typ='R',fr="ecrouissage, paramtre b, en unite de longueur"),
             RHO_REF         =SIMP(statut='o',typ='R',fr="ecrouissage, paramtre rho_ref, en unit de longueur **-2"),
             H               =SIMP(statut='f',typ='R'),
             H1              =SIMP(statut='f',typ='R',defaut=0.124,fr="matrice d'interaction, terme a*",),
             H2              =SIMP(statut='f',typ='R',defaut=0.625,fr="matrice d'interaction, terme a_colineaire",),
             H3              =SIMP(statut='f',typ='R',defaut=0.137,fr="matrice d'interaction, terme a_glissile",),
             H4              =SIMP(statut='f',typ='R',defaut=0.122,fr="matrice d'interaction, terme a_Lomer",),
             H5              =SIMP(statut='f',typ='R',defaut=0.07,fr="matrice d'interaction, terme a_Hirth",),
           ),


           MONO_DD_CC      =FACT(statut='f',
              regles=(UN_PARMI('H','H1'),
                      PRESENT_PRESENT('H1','H2','H3','H4','H5','H6'),
                      PRESENT_ABSENT('H','H1','H2','H3','H4','H5','H6'),
                      ),
             #TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             GAMMA0          =SIMP(statut='f',typ='R',defaut=0.001,fr="Vitesse d ecoulement initiale en s**-1"),
             TAU_F           =SIMP(statut='o',typ='R',fr="Contraintes , en unite de contraintes ex 20 MPa"),
             A               =SIMP(statut='f',typ='R',defaut=0.13,fr="paramtre A, sans unit"),
             B               =SIMP(statut='f',typ='R',defaut=0.005,fr="paramtre B, sans unit"),
             N               =SIMP(statut='f',typ='R',defaut=200.,fr="paramtre n, sans unit"),
             Y               =SIMP(statut='o',typ='R',fr="paramte Y, en unit de longueur ex 2.5 A"),
             ALPHA           =SIMP(statut='f',typ='R',defaut=0.35,fr="ecrouissage, paramtre alpha"),
             BETA            =SIMP(statut='o',typ='R',fr="ecrouissage, paramtre b, en unite de longueur"),
             RHO_REF         =SIMP(statut='o',typ='R',fr="ecrouissage, paramtre rho_ref, en unit de longueur **-2"),
             H               =SIMP(statut='f',typ='R'),
             H1              =SIMP(statut='f',typ='R'),
             H2              =SIMP(statut='f',typ='R'),
             H3              =SIMP(statut='f',typ='R'),
             H4              =SIMP(statut='f',typ='R'),
             H5              =SIMP(statut='f',typ='R'),
             H6              =SIMP(statut='f',typ='R'),
           ),


####  MONOCRISTAL

### UMAT
           UMAT   =FACT(statut='f',
             C1 =SIMP(statut='f',typ='R'),
             C2 =SIMP(statut='f',typ='R'),
             C3 =SIMP(statut='f',typ='R'),
             C4 =SIMP(statut='f',typ='R'),
             C5 =SIMP(statut='f',typ='R'),
             C6 =SIMP(statut='f',typ='R'),
             C7 =SIMP(statut='f',typ='R'),
             C8 =SIMP(statut='f',typ='R'),
             C9 =SIMP(statut='f',typ='R'),
             C10 =SIMP(statut='f',typ='R'),
             C11 =SIMP(statut='f',typ='R'),
             C12 =SIMP(statut='f',typ='R'),
             C13 =SIMP(statut='f',typ='R'),
             C14 =SIMP(statut='f',typ='R'),
             C15 =SIMP(statut='f',typ='R'),
             C16 =SIMP(statut='f',typ='R'),
             C17 =SIMP(statut='f',typ='R'),
             C18 =SIMP(statut='f',typ='R'),
             C19 =SIMP(statut='f',typ='R'),
             C20 =SIMP(statut='f',typ='R'),
             C21 =SIMP(statut='f',typ='R'),
             C22 =SIMP(statut='f',typ='R'),
             C23 =SIMP(statut='f',typ='R'),
             C24 =SIMP(statut='f',typ='R'),
             C25 =SIMP(statut='f',typ='R'),
             C26 =SIMP(statut='f',typ='R'),
             C27 =SIMP(statut='f',typ='R'),
             C28 =SIMP(statut='f',typ='R'),
             C29 =SIMP(statut='f',typ='R'),
             C30 =SIMP(statut='f',typ='R'),
             C31 =SIMP(statut='f',typ='R'),
             C32 =SIMP(statut='f',typ='R'),
             C33 =SIMP(statut='f',typ='R'),
             C34 =SIMP(statut='f',typ='R'),
             C35 =SIMP(statut='f',typ='R'),
             C36 =SIMP(statut='f',typ='R'),
             C37 =SIMP(statut='f',typ='R'),
             C38 =SIMP(statut='f',typ='R'),
             C39 =SIMP(statut='f',typ='R'),
             C40 =SIMP(statut='f',typ='R'),
             C41 =SIMP(statut='f',typ='R'),
             C42 =SIMP(statut='f',typ='R'),
             C43 =SIMP(statut='f',typ='R'),
             C44 =SIMP(statut='f',typ='R'),
             C45 =SIMP(statut='f',typ='R'),
             C46 =SIMP(statut='f',typ='R'),
             C47 =SIMP(statut='f',typ='R'),
             C48 =SIMP(statut='f',typ='R'),
             C49 =SIMP(statut='f',typ='R'),
             C50 =SIMP(statut='f',typ='R'),
           ),
           UMAT_FO   =FACT(statut='f',
             C1 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C2 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C3 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C4 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C5 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C6 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C7 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C8 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C9 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C10 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C11 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C12 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C13 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C14 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C15 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C16 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C17 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C18 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C19 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C20 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C21 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C22 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C23 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C24 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C25 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C26 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C27 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C28 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C29 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C30 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C31 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C32 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C33 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C34 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C35 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C36 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C37 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C38 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C39 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C40 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C41 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C42 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C43 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C44 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C45 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C46 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C47 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C48 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C49 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             C50 =SIMP(statut='f',typ=(fonction_sdaster,formule)),
           ),
### UMAT


           INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
)  ;

#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR NISTOR I.NISTOR 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
# ======================================================================
# RESPONSABLE BODEL C.BODEL
DEFI_MODELE_GENE=OPER(nom="DEFI_MODELE_GENE",op= 126,sd_prod=modele_gene,
                      reentrant='n',
            fr="Crer la structure globale  partir des sous-structures en sous-structuration dynamique", 
            UIinfo={"groupes":("Matrices et vecteurs",)},
         SOUS_STRUC      =FACT(statut='o',max='**',
           NOM             =SIMP(statut='o',typ='TXM' ),
           MACR_ELEM_DYNA  =SIMP(statut='o',typ=macr_elem_dyna ),
           ANGL_NAUT       =SIMP(statut='o',typ='R',max=3),
           TRANS           =SIMP(statut='o',typ='R',max=3),
         ),
         LIAISON         =FACT(statut='o',max='**',
           SOUS_STRUC_1    =SIMP(statut='o',typ='TXM' ),
           INTERFACE_1     =SIMP(statut='o',typ='TXM' ),
           SOUS_STRUC_2    =SIMP(statut='o',typ='TXM' ),
           INTERFACE_2     =SIMP(statut='o',typ='TXM' ),
           regles=(EXCLUS('GROUP_MA_MAIT_1','GROUP_MA_MAIT_2','MAILLE_MAIT_2'),
                   EXCLUS('MAILLE_MAIT_1','GROUP_MA_MAIT_2','MAILLE_MAIT_2'),),
           GROUP_MA_MAIT_1   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_MAIT_1     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           GROUP_MA_MAIT_2   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE_MAIT_2     =SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
           OPTION            =SIMP(statut='f',typ='TXM',defaut="CLASSIQUE",into=("REDUIT","CLASSIQUE") ),
         ),
         VERIF           =FACT(statut='f',max='**',
#  dans la doc U stop_erreur est obligatoire         
           STOP_ERREUR     =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-3 ),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
         ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
)  ;
#& MODIF COMMANDE  DATE 22/03/2011   AUTEUR COURTOIS M.COURTOIS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS
DEFI_NAPPE=OPER(nom="DEFI_NAPPE",op=4,sd_prod=nappe_sdaster,
                fr="Dfinir une fonction relle de deux variables relles",
                reentrant='n',UIinfo={"groupes":("Fonctions",)},
         regles=(UN_PARMI('FONCTION','DEFI_FONCTION'),
                 EXCLUS('FONCTION','NOM_PARA_FONC',),
                 ENSEMBLE('NOM_PARA_FONC','DEFI_FONCTION'),),
         NOM_PARA        =SIMP(statut='o',typ='TXM',into=C_PARA_FONCTION() ),
         NOM_RESU        =SIMP(statut='f',typ='TXM',defaut="TOUTRESU"),
         PARA            =SIMP(statut='o',typ='R',max='**'),
         FONCTION        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),max='**' ),
         NOM_PARA_FONC   =SIMP(statut='f',typ='TXM',into=C_PARA_FONCTION() ),
         DEFI_FONCTION   =FACT(statut='f',max='**',
           VALE            =SIMP(statut='o',typ='R',max='**'),
           INTERPOL        =SIMP(statut='f',typ='TXM',max=2,defaut="LIN",into=("NON","LIN","LOG"),
                                 fr="Type d'interpolation pour les abscisses et les ordonnes de la fonction."),
           PROL_DROITE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
           PROL_GAUCHE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
         ),
         INTERPOL        =SIMP(statut='f',typ='TXM',max=2,defaut="LIN",into=("NON","LIN","LOG"),
                               fr="Type d'interpolation pour le paramtre de la nappe"),
         PROL_DROITE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
         PROL_GAUCHE     =SIMP(statut='f',typ='TXM',defaut="EXCLU",into=("CONSTANT","LINEAIRE","EXCLU") ),
         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=(1, 2) ),
         VERIF           =SIMP(statut='f',typ='TXM',into=("CROISSANT",) ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE KHAM M.KHAM
DEFI_OBSTACLE=OPER(nom="DEFI_OBSTACLE",op=  73,sd_prod=table_fonction,
                   fr="Dfinition d'un obstacle plan perpendiculaire  une structure filaire",
                   reentrant='n',
         UIinfo={"groupes":("Modlisation",)},
         TYPE            =SIMP(statut='o',typ='TXM',defaut="CERCLE",
                             into=("CERCLE","PLAN_Y","PLAN_Z","DISCRET",
                             "BI_CERCLE","BI_PLAN_Y","BI_PLAN_Z","BI_CERC_INT",
                             "CRAYON_900","CRAYON_1300","GUID_A_CARTE_900",
                             "GUID_B_CARTE_900","GUID_C_CARTE_900",
                             "GUID_D_CARTE_900","GUID_E_CARTE_900",
                             "GUID_F_CARTE_900","GUID_A_CARTE_1300",
                             "GUID_B_CARTE_1300","GUID_C_CARTE_1300",
                             "GUID_D_CARTE_1300","GUID_E_CARTE_1300",
                             "GUID_F_CARTE_1300","GUID_A_CARSP_900",
                             "GUID_B_CARSP_900","GUID_C_CARSP_900",
                             "GUID_D_CARSP_900","GUID_E_CARSP_900",
                             "GUID_F_CARSP_900","GUID_A_CARSP_1300",
                             "GUID_B_CARSP_1300","GUID_C_CARSP_1300",
                             "GUID_D_CARSP_1300","GUID_E_CARSP_1300",
                             "GUID_F_CARSP_1300","GUID_A_GCONT_900",
                             "GUID_B_GCONT_900","GUID_C_GCONT_900",
                             "GUID_D_GCONT_900","GUID_E_GCONT_900",
                             "GUID_F_GCONT_900","GUID_A_GCONT_1300",
                             "GUID_B_GCONT_1300","GUID_C_GCONT_1300",
                             "GUID_D_GCONT_1300","GUID_E_GCONT_1300",
                             "GUID_F_GCONT_1300","GUID_A_GCOMB_900",
                             "GUID_B_GCOMB_900","GUID_C_GCOMB_900",
                             "GUID_D_GCOMB_900","GUID_E_GCOMB_900",
                             "GUID_F_GCOMB_900","GUID_A_GCOMB_1300",
                             "GUID_B_GCOMB_1300","GUID_C_GCOMB_1300",
                             "GUID_D_GCOMB_1300","GUID_E_GCOMB_1300",
                             "GUID_F_GCOMB_1300",) ),
         VALE            =SIMP(statut='f',typ='R',max='**'),
         VERIF           =SIMP(statut='f',typ='TXM',defaut="FERME"),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE GNICOLAS G.NICOLAS
DEFI_PARA_SENSI=OPER(nom="DEFI_PARA_SENSI",op=   2,sd_prod=para_sensi,
                    fr="Dfinition d'un paramtre de sensibilit",
                    ang="Definition of a sensitive parameter",
                    reentrant='n',
            UIinfo={"groupes":("Fonctions",)},
         NOM_RESU        =SIMP(statut='c',typ='TXM',into=("TOUTRESU",),defaut="TOUTRESU",
                               fr="Nom du concept cr",
                               ang="Name of the concept"),
         VALE            =SIMP(statut='o',typ='R',
                               fr="Valeur du parametre",
                               ang="Value of the parameter"),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2004  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ASSIRE A.ASSIRE

from Macro.defi_part_feti_ops import defi_part_feti_ops

DEFI_PART_FETI=MACRO(nom="DEFI_PART_FETI",op=defi_part_feti_ops,sd_prod=sd_feti_sdaster,
                     reentrant='n',UIinfo={"groupes":("Modlisation",)},
                     fr="Creation partitionnement en sous-domaines pour FETI",
         regles=(UN_PARMI('MAILLAGE','MODELE'),PRESENT_PRESENT('MODELE','EXCIT'),),

         NB_PART         =SIMP(statut='o',typ='I',val_min=2),
         MAILLAGE        =SIMP(statut='f',typ=maillage_sdaster),
         MODELE          =SIMP(statut='f',typ=modele_sdaster),
         EXCIT           =FACT(statut='f',max='**',
           CHARGE          =SIMP(statut='f',typ=(char_meca,char_cine_meca)),),

         # Methode de partitionnement
         METHODE         =SIMP(statut='f',typ='TXM',into=("PMETIS","SCOTCH","KMETIS",), defaut="KMETIS" ),

         LOGICIEL      =SIMP(statut='f',typ='TXM'),

         # Corrige les problemes possibles de non-connexite des sous-domaines
         CORRECTION_CONNEX    =SIMP(statut='f',typ='TXM',defaut='NON',into=('OUI','NON')),

         # Permet de grouper des mailles dans un meme sous-doamine
         GROUPAGE        =FACT(statut='f',max='**',
           GROUP_MA       =SIMP(statut='o',typ=grma,),
                          ),
         # Permet d'appliquer des poids sur certaines mailles
         POIDS_MAILLES   =FACT(statut='f',max='**',
           GROUP_MA       =SIMP(statut='o',typ=grma,),
           POIDS          =SIMP(statut='f',typ='I',val_min=2),
                          ),
         # Prefixe pour le nom des group_ma definissant les sous-domaines
         NOM_GROUP_MA    =SIMP(statut='f',typ='TXM',defaut='SD' ),

         # Traiter les mailles de bords (elles sont enlevees du graphe puis reinjectees)
         TRAITER_BORDS   =SIMP(statut='f',typ='TXM',defaut='OUI',into=('OUI','NON') ),

         # Si le mot-cl suivant est renseign, cre de nouveau group_ma a partir des bords
         # Note : le calcul FETI sera impossible
         b_traiter_bords =BLOC(condition="TRAITER_BORDS == 'OUI'", fr="Cre t on des nouveaux group_ma",
           NOM_GROUP_MA_BORD  =SIMP(statut='f',typ='TXM'),
             ),

         INFO            =SIMP(statut='f',typ='I',into=(1, 2), defaut=1),
);
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2004  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ASSIRE A.ASSIRE

DEFI_PART_OPS=OPER(nom="DEFI_PART_OPS",op=21,sd_prod=sd_feti_sdaster,
                    fr="Creation partitionnement en sous-domaines pour FETI",
                    docu="U4.23.05",reentrant='n',
                    UIinfo={"groupes":("Modlisation",)},
         MODELE          =SIMP(statut='o',typ=(modele_sdaster) ),
         MAILLAGE        =SIMP(statut='f',typ=(maillage_sdaster) ),
         NOM             =SIMP(statut='f',typ='TXM',defaut='SD'),
         INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2,3,4) ),
         DEFI          =FACT(statut='f',max='**',
           GROUP_MA        =SIMP(statut='o',typ=grma),
           GROUP_MA_BORD   =SIMP(statut='f',typ=grma),
         ),
         EXCIT           =FACT(statut='f',max='**',
           CHARGE          =SIMP(statut='f',typ=(char_meca,char_cine_meca)),
         ),
);
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2005  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ASSIRE A.ASSIRE

DEFI_PART_PA_OPS=PROC(nom="DEFI_PART_PA_OPS",op=29,
                    fr="Creation partitionnement en sous-domaines pour FETI",
                    docu="U4.00.00",
                    UIinfo={"groupes":("Modlisation",)},
         MAILLAGE        =SIMP(statut='o',typ=(maillage_sdaster,squelette) ),
         MODELE          =SIMP(statut='f',typ=(modele_sdaster)),
         NB_PART         =SIMP(statut='o',typ='I',),

         # Methode de partitionnement
         METHODE         =SIMP(statut='f',typ='TXM',into=("PMETIS","SCOTCH","KMETIS",), defaut="KMETIS" ),

         LOGICIEL      =SIMP(statut='f',typ='TXM'),

         # Corrige les problemes possibles de non-connexite des sous-domaines
         CORRECTION_CONNEX    =SIMP(statut='f',typ='TXM',defaut='NON',into=('OUI','NON')),

         # Permet de grouper des mailles dans un meme sous-doamine
         GROUPAGE        =FACT(statut='f',max='**',
           GROUP_MA       =SIMP(statut='o',typ=grma,),
                          ),
         # Permet d'appliquer des poids sur certaines mailles
         POIDS_MAILLES   =FACT(statut='f',max='**',
           GROUP_MA       =SIMP(statut='o',typ=grma,),
           POIDS          =SIMP(statut='f',typ='I'),
                          ),
         # Prefixe pour le nom des group_ma definissant les sous-domaines
         NOM_GROUP_MA    =SIMP(statut='f',typ='TXM',defaut='SD' ),

         # Traiter les mailles de bords (elles sont enlevees du graphe puis reinjectees)
         TRAITER_BORDS   =SIMP(statut='f',typ='TXM',defaut='OUI',into=('OUI','NON') ),

         # Si le mot-cl suivant est renseign, cre de nouveau group_ma a partir des bords
         # Note : le calcul FETI sera impossible
         b_traiter_bords =BLOC(condition="TRAITER_BORDS == 'OUI'", fr="Cre t on des nouveaux group_ma",
           NOM_GROUP_MA_BORD  =SIMP(statut='f',typ='TXM'),
             ),

         INFO            =SIMP(statut='f',typ='I',into=(1, 2), defaut=1),

);
#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2009  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE COURTOIS M.COURTOIS

from Macro.defi_sol_miss_ops import defi_sol_miss_ops

DEFI_SOL_MISS = MACRO(nom="DEFI_SOL_MISS",op=defi_sol_miss_ops, sd_prod=table_sdaster,
                      fr="Dfinition des donnes de sol pour Miss", reentrant='n',
                      UIinfo={"groupes":("Modlisation","Outils-mtier",)},
   MATERIAU = FACT(statut='o', max='**',
            fr="Dfinition des matriaux",
      E         = SIMP(statut='o', typ='R', fr="Module d'Young"),
      NU        = SIMP(statut='o', typ='R', fr="Coefficient de Poisson"),
      RHO       = SIMP(statut='o', typ='R', fr="Masse volumique"),
      AMOR_HYST = SIMP(statut='o', typ='R', fr="Coefficient d'amortissement"),
   ),
   COUCHE = FACT(statut='o', max='**',
                 fr="Dfinition des couches",
      regles=(AU_MOINS_UN('EPAIS','SUBSTRATUM'),),
      SUBSTRATUM= SIMP(statut='f', typ='TXM', into=("OUI","NON"),),
      EPAIS     = SIMP(statut='f', typ='R', fr="Epaisseur de la couche"),
      RECEPTEUR = SIMP(statut='f', typ='TXM', defaut="NON", into=("OUI", "NON"),),
      SOURCE    = SIMP(statut='f', typ='TXM', defaut="NON", into=("OUI", "NON"),),
      NUME_MATE = SIMP(statut='o', typ='I', fr="Numro du matriau"),
   ),
   TITRE = SIMP(statut='f', typ='TXM', max='**',
                fr="Titre de la table produite"),
   INFO  = SIMP(statut='f', typ='I', defaut=1, into=(1,2)),
)

#& MODIF COMMANDE  DATE 09/11/2010   AUTEUR DELMAS J.DELMAS 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2001  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE ADOBES A.ADOBES
DEFI_SPEC_TURB=OPER(nom="DEFI_SPEC_TURB",op= 145,sd_prod=spectre_sdaster,
                    fr="Dfinition d'un spectre d'excitation turbulente",
                    reentrant='n',
            UIinfo={"groupes":("Modlisation","Outils-mtier",)},
         regles=(UN_PARMI('SPEC_LONG_COR_1','SPEC_LONG_COR_2','SPEC_LONG_COR_3',
                          'SPEC_LONG_COR_4','SPEC_CORR_CONV_1','SPEC_CORR_CONV_2',
                          'SPEC_FONC_FORME','SPEC_EXCI_POINT'),),
         SPEC_LONG_COR_1 =FACT(statut='f',
           LONG_COR        =SIMP(statut='o',typ='R' ),
           PROF_VITE_FLUI  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VISC_CINE       =SIMP(statut='o',typ='R' ),
         ),
         SPEC_LONG_COR_2 =FACT(statut='f',
           regles=(ENSEMBLE('FREQ_COUP','PHI0','BETA' ),),
           LONG_COR        =SIMP(statut='o',typ='R' ),
           PROF_VITE_FLUI  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FREQ_COUP       =SIMP(statut='f',typ='R',defaut= 0.1 ),
           PHI0            =SIMP(statut='f',typ='R',defaut= 1.5E-3 ),
           BETA            =SIMP(statut='f',typ='R',defaut= 2.7 ),
         ),
         SPEC_LONG_COR_3 =FACT(statut='f',
           regles=(ENSEMBLE('PHI0_1','BETA_1','PHI0_2','BETA_2','FREQ_COUP'),),
           LONG_COR        =SIMP(statut='o',typ='R' ),
           PROF_VITE_FLUI  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           FREQ_COUP       =SIMP(statut='f',typ='R',defaut= 0.2 ),
           PHI0_1          =SIMP(statut='f',typ='R',defaut= 5.E-3 ),
           BETA_1          =SIMP(statut='f',typ='R',defaut= 0.5 ),
           PHI0_2          =SIMP(statut='f',typ='R',defaut= 4.E-5 ),
           BETA_2          =SIMP(statut='f',typ='R',defaut= 3.5 ),
         ),
         SPEC_LONG_COR_4 =FACT(statut='f',
           regles=(ENSEMBLE('BETA','GAMMA'),),
           LONG_COR        =SIMP(statut='o',typ='R' ),
           PROF_VITE_FLUI  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           TAUX_VIDE       =SIMP(statut='o',typ='R' ),
           BETA            =SIMP(statut='f',typ='R',defaut= 2. ),
           GAMMA           =SIMP(statut='f',typ='R',defaut= 4. ),
         ),
         SPEC_CORR_CONV_1=FACT(statut='f',
           LONG_COR_1      =SIMP(statut='o',typ='R' ),
           LONG_COR_2      =SIMP(statut='f',typ='R' ),
           VITE_FLUI       =SIMP(statut='o',typ='R' ),
           RHO_FLUI        =SIMP(statut='o',typ='R' ),
           FREQ_COUP       =SIMP(statut='f',typ='R' ),
           K               =SIMP(statut='f',typ='R',defaut= 5.8E-3 ),
           D_FLUI          =SIMP(statut='o',typ='R' ),
           COEF_VITE_FLUI_A=SIMP(statut='f',typ='R' ),
           COEF_VITE_FLUI_O=SIMP(statut='f',typ='R' ),
           METHODE         =SIMP(statut='f',typ='TXM',defaut="GENERALE",
                                 into=("AU_YANG","GENERALE","CORCOS") ),
         ),
         SPEC_CORR_CONV_2=FACT(statut='f',
           FONCTION        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
           VITE_FLUI       =SIMP(statut='o',typ='R' ),
           FREQ_COUP       =SIMP(statut='f',typ='R' ),
           METHODE         =SIMP(statut='f',typ='TXM',defaut="GENERALE",
                                 into=("AU_YANG","GENERALE","CORCOS",) ),
           COEF_VITE_FLUI_A=SIMP(statut='f',typ='R' ),
           COEF_VITE_FLUI_O=SIMP(statut='f',typ='R' ),
         ),
         SPEC_FONC_FORME =FACT(statut='f',
           regles=(UN_PARMI('INTE_SPEC','GRAPPE_1'),
                   ENSEMBLE('INTE_SPEC','FONCTION'),),
           INTE_SPEC       =SIMP(statut='f',typ=table_fonction),
           FONCTION        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),max='**'),
           GRAPPE_1        =SIMP(statut='f',typ='TXM',into=("DEBIT_180","DEBIT_300",) ),
           NOEUD           =SIMP(statut='o',typ=no),
           CARA_ELEM       =SIMP(statut='o',typ=cara_elem ),
           MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         ),
         SPEC_EXCI_POINT =FACT(statut='f',
           regles=(UN_PARMI('INTE_SPEC','GRAPPE_2'),),
           INTE_SPEC       =SIMP(statut='f',typ=table_fonction),
           GRAPPE_2        =SIMP(statut='f',typ='TXM',
                                 into=("ASC_CEN","ASC_EXC","DES_CEN","DES_EXC",) ),
#  Quels sont les statuts des mots cles  l interieur des deux blocs qui suivent
           b_inte_spec =BLOC(condition = "INTE_SPEC != None",
             NATURE          =SIMP(statut='o',typ='TXM',max='**',into=("FORCE","MOMENT",) ),
             ANGL            =SIMP(statut='o',typ='R',max='**'),
             NOEUD           =SIMP(statut='o',typ=no,max='**'),
           ),
           b_grappe_2      =BLOC(condition = "GRAPPE_2 != None",
             RHO_FLUI        =SIMP(statut='o',typ='R' ),
             NOEUD           =SIMP(statut='o',typ=no),
           ),
           CARA_ELEM       =SIMP(statut='o',typ=cara_elem ),
           MODELE          =SIMP(statut='o',typ=modele_sdaster ),
         ),
         TITRE           =SIMP(statut='f',typ='TXM',max='**'),
)  ;
#& MODIF COMMANDE  DATE 25/01/2011   AUTEUR PELLET J.PELLET 
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2011  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ======================================================================
# RESPONSABLE BODEL C.BODEL
DEFI_SQUELETTE=OPER(nom="DEFI_SQUELETTE",op= 110,sd_prod=squelette,
                    fr="Dfinit un maillage pour visualiser les rsultats d'une sous-structuration dynamique",
                    reentrant='n',
            UIinfo={"groupes":("Maillage","Dynamique",)},
         regles=(UN_PARMI('CYCLIQUE','MODELE_GENE','MAILLAGE'),
                 PRESENT_PRESENT('CYCLIQUE','SECTEUR'),
                 EXCLUS('SOUS_STRUC','SECTEUR'),
                 PRESENT_PRESENT('NOM_GROUP_MA','MODELE_GENE'),
                 PRESENT_PRESENT('NOM_GROUP_MA','SOUS_STRUC'),),
         CYCLIQUE    =FACT(statut='f',max='**',
           regles=(UN_PARMI('MODE_CYCL','MAILLAGE'),
                   PRESENT_PRESENT('NB_SECTEUR','MAILLAGE'),),
           MODE_CYCL       =SIMP(statut='f',typ=mode_cycl ),
           NB_SECTEUR      =SIMP(statut='f',typ='I',validators=NoRepeat(),max=1 ),
           MAILLAGE        =SIMP(statut='f',typ=maillage_sdaster ),
         ),
         MODELE_GENE     =SIMP(statut='f',typ=modele_gene ),
         SQUELETTE       =SIMP(statut='f',typ=squelette ),
         RECO_GLOBAL     =FACT(statut='f',max='**',
           regles=(EXCLUS('TOUT','GROUP_NO_1'),
                   PRESENT_PRESENT('GROUP_NO_1','GROUP_NO_2'),
                   PRESENT_PRESENT('GROUP_NO_1','SOUS_STRUC_1'),
                   PRESENT_PRESENT('GROUP_NO_2','SOUS_STRUC_2'),
                   PRESENT_PRESENT('SOUS_STRUC_1','SOUS_STRUC_2'),),
           TOUT            =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI",) ),
           GROUP_NO_1      =SIMP(statut='f',typ=grno),
           SOUS_STRUC_1    =SIMP(statut='f',typ='TXM' ),
           GROUP_NO_2      =SIMP(statut='f',typ=grno),
           SOUS_STRUC_2    =SIMP(statut='f',typ='TXM' ),
           PRECISION       =SIMP(statut='f',typ='R',defaut= 1.E-3 ),
           CRITERE         =SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
           DIST_REFE       =SIMP(statut='f',typ='R' ),
         ),
         NOM_GROUP_MA    =FACT(statut='f',max='**',
           NOM             =SIMP(statut='o',typ='TXM' ),
           SOUS_STRUC      =SIMP(statut='o',typ='TXM' ),
           GROUP_MA        =SIMP(statut='o',typ=grma),
         ),
         EXCLUSIF        =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         MAILLAGE        =SIMP(statut='f',typ=maillage_sdaster ),
         MAILLE          =SIMP(s