-- Copyright (C) 2002 Didier CLERC
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GnomeCanvas objects"
	author: "Didier CLERC <didier-clerc@isuisse.com>"
   date: "$Date: 2002/08/26 00:33:09 $"
   cvs: "$Id: gnome_canvas_writer.e,v 1.1 2002/08/26 00:33:09 DJAC Exp $"
   revision: "$Revision: 1.1 $"

class GNOME_CANVAS_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation--, parent_inherit
		end

	CHILD

creation

	make

feature

	type: STRING is "GNOME_CANVAS"

anti_aliased:BOOLEAN
		-- boolean value extract from string
	scroll_x1:STRING
		-- integer value as string for scroll_x1
	scroll_y1:STRING
		-- integer value as string for scroll_y1
	scroll_x2:STRING
		-- integer value as string for scroll_x2
	scroll_y2:STRING
		-- integer value as string for scroll_y2
	pixels_per_unit:STRING
		-- real value as string for pixels_per_units

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			anti_aliased   := tree.get_boolean_from_field       ("anti_aliased", False)
			scroll_x1      := tree.get_integer_string_from_field("scroll_x1")
			scroll_y1      := tree.get_integer_string_from_field("scroll_y1")
			scroll_x2      := tree.get_integer_string_from_field("scroll_x2")
			scroll_y2      := tree.get_integer_string_from_field("scroll_y2")
			pixels_per_unit:= tree.get_real_string_from_field   ("pixels_per_unit")
		end

	append_parent_creation(code: ARRAY[STRING]) is
		do
			if anti_aliased then 
				code.add_last("create " + name + ".make_as_aa")
			else
				code.add_last("create "+name+".make")
			end
			if scroll_x1/=Void and scroll_y1/= Void and scroll_x2 /= Void and scroll_y2 /= Void then
				code.add_last(name+".set_scroll_region("+scroll_x1+","+scroll_y1+","+scroll_x2+","+scroll_y2+")")
			end
			if pixels_per_unit /= Void then
				code.add_last(name+".set_pixels_per_units("+pixels_per_unit+")")
			end
			add_widget_code(code)
		end

end
