-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkFontSelectionDialog objects"
	author: "Daniel Elphick <dre00r@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_font_selection_dialog_writer.e,v 1.8 2002/08/26 02:32:20 DJAC Exp $"

class GTK_FONT_SELECTION_DIALOG_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_FONT_SELECTION_DIALOG"
	ok: TAG_TREE
	cancel: TAG_TREE
	apply: TAG_TREE
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		local
			tree_array: ARRAY[TAG_TREE]
		do
			make_attribute(attr_name, tree, src)
			title := widget_tree.get_string_from_field("title")
			window_type := widget_tree.get_string_from_field("type")
			position := widget_tree.get_string_from_field("position")
			modal := widget_tree.get_boolean_string_from_field("modal")
			allow_shrink := widget_tree.get_boolean_string_from_field("allow_shrink")
			allow_grow := widget_tree.get_boolean_string_from_field("allow_grow")
			auto_shrink := widget_tree.get_boolean_string_from_field("auto_shrink")
			policy := widget_tree.get_string_from_field("policy")
			tree_array := widget_tree.find_children("widget")
			if tree_array.count /= 3 then
				print("FontSelection window should have 3 widgets%N")
				die_with_code(exit_failure_code)
			end
			-- assume first one is ok button, second is apply and third is cancel
			if not (tree_array @ 0).get_string_from_field("child_name").is_equal("FontSel:ok_button") then
				print("First widget should be the ok button%N")
				die_with_code(exit_failure_code)
			end
			if not (tree_array @ 1).get_string_from_field("child_name").is_equal("FontSel:apply_button") then
				print("Second widget should be the apply button%N")
				die_with_code(exit_failure_code)
			end
			if not (tree_array @ 2).get_string_from_field("child_name").is_equal("FontSel:cancel_button") then
				print("Third widget should be the cancel button%N")
				die_with_code(exit_failure_code)
			end
			ok := tree_array @ 0
			apply := tree_array @ 1
			cancel := tree_array @ 2
			check 
				ok /= Void and cancel /= Void and apply /= Void
			end
			
		end
			
	title: STRING
	window_type: STRING
	position: STRING
	modal: STRING
	allow_shrink: STRING
	allow_grow: STRING
	auto_shrink: STRING
	policy: STRING

	append_parent_creation(code: ARRAY[STRING]) is
		local
			temp: STRING
		do
			code.add_last("create " + name + ".make_with_title(%""+title+"%")")
			code.add_last(name + ".set_policy(" + allow_shrink + ", " +
				allow_grow + ", " + auto_shrink + ")")
			temp := ok.get_string_from_field("label")
			if not temp.is_empty and then not temp.is_equal("OK") then
				code.add_last(name + ".ok.set_label(%""+temp+"%")")
			end
			temp := cancel.get_string_from_field("label")
			if not temp.is_empty and then not temp.is_equal("Cancel") then
				code.add_last(name + ".cancel.set_label(%""+temp+"%")")
			end
			temp := apply.get_string_from_field("label")
			if not temp.is_empty and then not temp.is_equal("Apply") then
				code.add_last(name + ".apply.set_label(%""+temp+"%")")
			end
			add_widget_code(code)
		end

end
