-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkLayou objects"
	author: "Daniel Elphick <dre00r@ecs.soton.ac.uk>"
	cvs: "$Id"

class GTK_LAYOUT_WRITER

inherit

	GTK_COMPOSED_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, append_add_widget_code
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_LAYOUT"
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			area_width := tree.get_integer_string_from_field("area_width")
			area_height := tree.get_integer_string_from_field("area_height")
			hstep := tree.get_real_string_from_field("hstep")
			vstep := tree.get_real_string_from_field("vstep")
			create_child_class_array(tree.find_children("widget"), 1)
			self_scrolling := True
		end

	area_width: STRING
	area_height: STRING
	hstep: STRING
	vstep: STRING
			
	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("create "+ name + ".make(Void, Void)")
			code.add_last(name + ".set_size(" + area_width + ", " + area_height + ")")
			code.add_last(name + ".get_hadjustment.set_step_increment(" + hstep + ")")
			code.add_last(name + ".get_vadjustment.set_step_increment(" + vstep + ")")
			add_widget_code(code)
			precursor(code)
		end

	append_add_widget_code(code: ARRAY[STRING]; widget: CAN_BE_CREATED) is
		local
			attr: GTK_ATTRIBUTE_WRITER
		do
			attr ?= widget
			if attr /= Void then
				code.add_last(name + ".put(" + widget.name + ", " +
					attr.x + ", " + attr.y +")")
			else
				print("Layout writer can only handle attributes.%N")
				die_with_code(exit_failure_code)
			end
		end

end
