-- Copyright (C) 2000 Oliver Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--

indexing

   description:	"GNOME_NON_PORTABLE_CALLS: routines whose interface is %
   %not portable between ISE and SmallEiffel"
   author:		"Oliver Elphick"
   date:       "31st August 2000"
   cvs:		"$Id: gnome_non_portable_calls.e,v 1.2 2002/02/26 16:47:26 elphick Exp $"

class GNOME_NON_PORTABLE_CALLS

inherit

   GNOME_HELP_EXTERNALS

feature {GNOME_HELP}

   gnpc_help_file_find_file(n, p: STRING): STRING is
      require
	 n_not_void: n /= Void
	 p_not_void: p /= Void
      do
	 !!Result.make(0)
	 Result.from_external(
			      c_gnome_help_file_find_file (n.to_external,
							   p.to_external)
			      )
      end

   gnpc_help_file_path (n, p: STRING): STRING is
      require
	 n_not_void: n /= Void
	 p_not_void: p /= Void
      do
	 !!Result.make(0)
	 Result.from_external(
			      c_gnome_help_file_path (n.to_external,
						      p.to_external)
			      )
      end

   gnpc_help_display (n, p: STRING) is
      require
	 n_not_void: n /= Void
	 p_not_void: p /= Void
      do
	 c_gnome_help_display (n.to_external, p.to_external)
      end

   gnpc_help_goto (p: STRING) is
      require
	 p_not_void: p /= Void
      do
	 gnome_help_goto (p.to_external)
      end

   gnpc_help_pbox_display (pg: INTEGER; n, p: STRING) is
      require
	 n_not_void: n /= Void
	 p_not_void: p /= Void
      do
	 c_gnome_help_display (pg, n.to_external, p.to_external)
      end

   gnpc_help_pbox_goto (n, p: STRING) is
      require
	 n_not_void: n /= Void
	 p_not_void: p /= Void
      do
	 c_gnome_help_goto (n.to_external, p.to_external)
      end

end -- GNOME_NON_PORTABLE_CALLS
