<?php
  /**************************************************************************\
  * eGroupWare API - Graphical                                               *
  * This file written by Lars Kneschke <lars@kneschke.de>                    *
  * Allows the creation of graphical buttons                                 *
  * Copyright (C) 2001 Lars Kneschke                                         *
  * -------------------------------------------------------------------------*
  * This library is part of the eGroupWare API                               *
  * http://www.egroupware.org/api                                            * 
  * ------------------------------------------------------------------------ *
  * This library is free software; you can redistribute it and/or modify it  *
  * under the terms of the GNU Lesser General Public License as published by *
  * the Free Software Foundation; either version 2.1 of the License,         *
  * or any later version.                                                    *
  * This library is distributed in the hope that it will be useful, but      *
  * WITHOUT ANY WARRANTY; without even the implied warranty of               *
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     *
  * See the GNU Lesser General Public License for more details.              *
  * You should have received a copy of the GNU Lesser General Public License *
  * along with this library; if not, write to the Free Software Foundation,  *
  * Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA            *
  \**************************************************************************/

  /* $Id: class.graphics.inc.php,v 1.9 2004/05/05 12:03:19 reinerj Exp $ */

	class graphics
	{
		/* put a valid font here */
		var $font="/opt/future-project/src/management-server/ttf/arial.ttf";

		function createImage($_text, $_fontsize=11)
		{
			/* create filename */
			$filename = 'button_' . md5($_text) . '.png';
			$filename = strtolower($filename);

			/* see if file exists already, we cache it */
			if (file_exists(PHPGW_IMAGES_FILEDIR.'/'.$filename))
			{
				return $filename;
			}

			$size = imagettfbbox($_fontsize,0,$this->font,$_text);
			$dx = abs($size[2]-$size[0]);
			$dy = abs($size[5]-$size[3]);
			$xpad=9;
			$ypad=9;
			$im = imagecreate($dx+$xpad,$dy+$ypad);
			$blue = ImageColorAllocate($im, 0x2c,0x6D,0xAF);
			$black = ImageColorAllocate($im, 0,0,0);
			$white = ImageColorAllocate($im, 255,255,255);
			ImageRectangle($im,0,0,$dx+$xpad-1,$dy+$ypad-1,$black);
			ImageRectangle($im,0,0,$dx+$xpad,$dy+$ypad,$white);
			ImageTTFText($im, $_fontsize, 0, (int)($xpad/2)+1, $dy+(int)($ypad/2), -$black, $this->font, $_text);
			ImageTTFText($im, $_fontsize, 0, (int)($xpad/2), $dy+(int)($ypad/2)-1, -$white, $this->font, $_text);
			ImagePNG($im,PHPGW_IMAGES_FILEDIR.'/'.$filename);
			ImageDestroy($im);

			return $filename;
		}

		function createInputButton($_text, $_name, $_mode='graphic')
		{
			if ($_mode == 'graphic' && extension_loaded('gd'))
			{
				return '<input type="image" src="/phpgroupware/phpgwapi/templates/default/images/'.$this->createImage($_text).'" border="0" name="'.$_name.'">';
			}
			else
			{
				return '<input type="submit" value="'.$_text.'" name="'.$_name.'">';
			}
		}

		// this function checks, if there is a variable $aaa_x and $aaa_y
		// if so, it will create a new variable $aaa
		function parseHTTPPostVars()
		{
			// execute only if libgd support is enabled
			if (!extension_loaded('gd'))
			{
				return;
			}

			global $HTTP_POST_VARS;

			if (is_array($HTTP_POST_VARS))
			{
				while( list($key, $val) = each($HTTP_POST_VARS)) 
				{
					if (ereg("(.*)_x",$key,$varName) && $HTTP_POST_VARS[$varName[1]."_y"])
					{
						$name = $varName[1];
						global $$name;
						$$name = "content generated by parseHTTPPostVars()";
					}
				}
			}
		}
	}
