<?php
	/**************************************************************************\
	* eGroupWare API - Auth from NIS                                           *
	* Authentication based on NIS maps                                         *
	* by Dylan Adams <dadams@jhu.edu>                                          *
	* Copyright (C) 2001 Dylan Adams                                           *
	* ------------------------------------------------------------------------ *
	* This library is part of the eGroupWare API                               *
	* http://www.egroupware.org/api                                            *  
	* ------------------------------------------------------------------------ *
	* This library is free software; you can redistribute it and/or modify it  *
	* under the terms of the GNU Lesser General Public License as published by *
	* the Free Software Foundation; either version 2.1 of the License,         *
	* or any later version.                                                    *
	* This library is distributed in the hope that it will be useful, but      *
	* WITHOUT ANY WARRANTY; without even the implied warranty of               *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     *
	* See the GNU Lesser General Public License for more details.              *
	* You should have received a copy of the GNU Lesser General Public License *
	* along with this library; if not, write to the Free Software Foundation,  *
	* Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA            *
	\**************************************************************************/

	/* $Id: class.auth_nis.inc.php 20295 2006-02-15 12:31:25Z  $ */

	class auth_
	{
		function authenticate($username, $passwd)
		{
			$domain = yp_get_default_domain();
			if(!empty($GLOBALS['egw_info']['server']['nis_domain']))
			{
				$domain = $GLOBALS['egw_info']['server']['nis_domain'];
			}

			$map = "passwd.byname";
			if(!empty($GLOBALS['egw_info']['server']['nis_map']))
			{
				$map = $GLOBALS['egw_info']['server']['nis_map'];
			}
			$entry = yp_match( $domain, $map, $username );

			/*
			 * we assume that the map is structured in the usual
			 * unix passwd flavor
			 */
			$entry_array = explode(':', $entry);
			$stored_passwd = $entry_array[1];

			$encrypted_passwd = crypt($passwd, $stored_passwd);

			return($encrypted_passwd == $stored_passwd);
		}

		function change_password($old_passwd, $new_passwd, $account_id='')
		{
			// can't change passwords unless server runs as root (bad idea)
			return( False );
		}
	}
